using System;
using System.Linq;
using System.Collections.Generic;
using JetBrains.Application;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.Popups
{
  
  
  [ShellComponent]
  public class PopupInteractionModel : RdBindableBase {
    //fields
    [NotNull] public IViewableMap<int, RdPopupMenuModel> Popups { get { return _Popups; }}
    [NotNull] private readonly RdMap<int, RdPopupMenuModel> _Popups;
    
    //primary constructor
    public PopupInteractionModel(
      [NotNull] RdMap<int, RdPopupMenuModel> popups
    )
    {
      _Popups = popups;
    }
    //secondary constructor
    //statics
    
    private void Register(ISerializers serializers)
    {
      serializers.Register(RdPopupMenuModelItem.Read, RdPopupMenuModelItem.Write);
      serializers.Register(RdDefaultPopupWindowContext.Read, RdDefaultPopupWindowContext.Write);
      serializers.Register(RdMainWindowCenteredPopupWindowContext.Read, RdMainWindowCenteredPopupWindowContext.Write);
      serializers.Register(RdGutterMarkPopupWindowContext.Read, RdGutterMarkPopupWindowContext.Write);
      serializers.Register(RdRichTextCaptionModel.Read, RdRichTextCaptionModel.Write);
      serializers.Register(RdIconCaptionModel.Read, RdIconCaptionModel.Write);
      serializers.Register(RdPresentableItemCaptionModel.Read, RdPresentableItemCaptionModel.Write);
      serializers.Register(RdRichTextWithProgressCaptionModel.Read, RdRichTextWithProgressCaptionModel.Write);
      serializers.Register(RdPinButtonModel.Read, RdPinButtonModel.Write);
      serializers.Register(RdToolBarModel.Read, RdToolBarModel.Write);
      serializers.Register(RdFilterModel.Read, RdFilterModel.Write);
      serializers.Register(RdPopupSelection.Read, RdPopupSelection.Write);
      serializers.Register(RdPopupMenuModelItems.Read, RdPopupMenuModelItems.Write);
      serializers.Register(RdExpandSubmenuRequest.Read, RdExpandSubmenuRequest.Write);
      serializers.Register(RdPopupSubmenuModel.Read, RdPopupSubmenuModel.Write);
      serializers.Register(RdPopupMenuModel.Read, RdPopupMenuModel.Write);
    }
    
    public PopupInteractionModel(Lifetime lifetime, IProtocol protocol) : this (
      new RdMap<int, RdPopupMenuModel>().Static(1017)
    )
    {
      Register(protocol.Serializers);
      Bind(lifetime, protocol, GetType().Name);
    }
    //init method
    protected override void Init(Lifetime lifetime) {
      _Popups.BindEx(lifetime, this, "popups");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Popups.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PopupInteractionModel (");
      using (printer.IndentCookie()) {
        printer.Print("popups = "); _Popups.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdButtonModel : RdBindableBase {
    //fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdButtonModel> Read = (ctx, reader) => ctx.Serializers.Read<RdButtonModel>(ctx, reader);
    
    public static CtxWriteDelegate<RdButtonModel> Write = (ctx, writer, value) => ctx.Serializers.Write<RdButtonModel>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public abstract class RdCaptionModelBase : RdBindableBase {
    //fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdCaptionModelBase> Read = (ctx, reader) => ctx.Serializers.Read<RdCaptionModelBase>(ctx, reader);
    
    public static CtxWriteDelegate<RdCaptionModelBase> Write = (ctx, writer, value) => ctx.Serializers.Write<RdCaptionModelBase>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdDefaultPopupWindowContext : RdPopupWindowContextBase
   {
    //fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdDefaultPopupWindowContext> Read = (ctx, reader) => 
    {
      return new RdDefaultPopupWindowContext();
    };
    
    public static new CtxWriteDelegate<RdDefaultPopupWindowContext> Write = (ctx, writer, value) => 
    {
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdDefaultPopupWindowContext) obj);
    }
    public bool Equals(RdDefaultPopupWindowContext other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdDefaultPopupWindowContext (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdExpandSubmenuRequest : RdBindableBase {
    //fields
    public int ExpandedItem {get; private set;}
    [NotNull] public IRdProperty<RdPopupMenuModelBase> Submenu { get { return _Submenu; }}
    [NotNull] private readonly RdProperty<RdPopupMenuModelBase> _Submenu;
    
    //primary constructor
    private RdExpandSubmenuRequest(
      int expandedItem,
      [NotNull] RdProperty<RdPopupMenuModelBase> submenu
    )
    {
      ExpandedItem = expandedItem;
      _Submenu = submenu;
    }
    //secondary constructor
    public RdExpandSubmenuRequest (
      int ExpandedItem
    ) : this (
      ExpandedItem,
      new RdProperty<RdPopupMenuModelBase>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdExpandSubmenuRequest> Read = (ctx, reader) => 
    {
      var expandedItem = reader.ReadInt();
      var submenu = RdProperty<RdPopupMenuModelBase>.Read(ctx, reader);
      return new RdExpandSubmenuRequest(expandedItem, submenu);
    };
    
    public static CtxWriteDelegate<RdExpandSubmenuRequest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ExpandedItem);
      RdProperty<RdPopupMenuModelBase>.Write(ctx, writer, value._Submenu);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Submenu.BindEx(lifetime, this, "submenu");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Submenu.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdExpandSubmenuRequest (");
      using (printer.IndentCookie()) {
        printer.Print("expandedItem = "); ExpandedItem.PrintEx(printer); printer.Println();
        printer.Print("submenu = "); _Submenu.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdFilterModel : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<string> SearchString { get { return _SearchString; }}
    [NotNull] private readonly RdProperty<string> _SearchString;
    [NotNull] public IRdProperty<bool> IsValid { get { return _IsValid; }}
    [NotNull] private readonly RdProperty<bool> _IsValid;
    
    //primary constructor
    private RdFilterModel(
      [NotNull] RdProperty<string> searchString,
      [NotNull] RdProperty<bool> isValid
    )
    {
      _SearchString = searchString;
      _IsValid = isValid;
      searchString.OptimizeNested = true;
      isValid.OptimizeNested = true;
    }
    //secondary constructor
    public RdFilterModel (
    ) : this (
      new RdProperty<string>(),
      new RdProperty<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<RdFilterModel> Read = (ctx, reader) => 
    {
      var searchString = RdProperty<string>.Read(ctx, reader);
      var isValid = RdProperty<bool>.Read(ctx, reader);
      return new RdFilterModel(searchString, isValid);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<RdFilterModel> Write = (ctx, writer, value) => 
    {
      RdProperty<string>.Write(ctx, writer, value._SearchString);
      RdProperty<bool>.Write(ctx, writer, value._IsValid);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _SearchString.BindEx(lifetime, this, "searchString");
      _IsValid.BindEx(lifetime, this, "isValid");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _SearchString.IdentifyEx(ids);
      _IsValid.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdFilterModel (");
      using (printer.IndentCookie()) {
        printer.Print("searchString = "); _SearchString.PrintEx(printer); printer.Println();
        printer.Print("isValid = "); _IsValid.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdGutterMarkPopupWindowContext : RdPopupWindowContextBase
   {
    //fields
    public int DocOffset {get; private set;}
    
    //primary constructor
    public RdGutterMarkPopupWindowContext(
      int docOffset
    )
    {
      DocOffset = docOffset;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdGutterMarkPopupWindowContext> Read = (ctx, reader) => 
    {
      var docOffset = reader.ReadInt();
      return new RdGutterMarkPopupWindowContext(docOffset);
    };
    
    public static new CtxWriteDelegate<RdGutterMarkPopupWindowContext> Write = (ctx, writer, value) => 
    {
      writer.Write(value.DocOffset);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdGutterMarkPopupWindowContext) obj);
    }
    public bool Equals(RdGutterMarkPopupWindowContext other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return DocOffset == other.DocOffset;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + DocOffset.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdGutterMarkPopupWindowContext (");
      using (printer.IndentCookie()) {
        printer.Print("docOffset = "); DocOffset.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdIconCaptionModel : RdCaptionModelBase
   {
    //fields
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //primary constructor
    public RdIconCaptionModel(
      [NotNull] JetBrains.Rider.Model.Icon icon
    )
    {
      Icon = icon;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdIconCaptionModel> Read = (ctx, reader) => 
    {
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      return new RdIconCaptionModel(icon);
    };
    
    public static new CtxWriteDelegate<RdIconCaptionModel> Write = (ctx, writer, value) => 
    {
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdIconCaptionModel (");
      using (printer.IndentCookie()) {
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdMainWindowCenteredPopupWindowContext : RdPopupWindowContextBase
   {
    //fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdMainWindowCenteredPopupWindowContext> Read = (ctx, reader) => 
    {
      return new RdMainWindowCenteredPopupWindowContext();
    };
    
    public static new CtxWriteDelegate<RdMainWindowCenteredPopupWindowContext> Write = (ctx, writer, value) => 
    {
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdMainWindowCenteredPopupWindowContext) obj);
    }
    public bool Equals(RdMainWindowCenteredPopupWindowContext other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdMainWindowCenteredPopupWindowContext (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdPinButtonModel : RdButtonModel
   {
    //fields
    [CanBeNull] public string Tooltip {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public IVoidSink Execute { get { return _Execute; }}
    [NotNull] private readonly RdVoidSignal _Execute;
    
    //primary constructor
    private RdPinButtonModel(
      [CanBeNull] string tooltip,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdVoidSignal execute
    )
    {
      Tooltip = tooltip;
      Icon = icon;
      _Execute = execute;
    }
    //secondary constructor
    public RdPinButtonModel (
      [CanBeNull] string Tooltip,
      [CanBeNull] JetBrains.Rider.Model.Icon Icon
    ) : this (
      Tooltip,
      Icon,
      new RdVoidSignal()
    ) {}
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static new CtxReadDelegate<RdPinButtonModel> Read = (ctx, reader) => 
    {
      var tooltip = ReadStringNullable(ctx, reader);
      var icon = ReadIconNullable(ctx, reader);
      var execute = RdVoidSignal.Read(ctx, reader);
      return new RdPinButtonModel(tooltip, icon, execute);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static new CtxWriteDelegate<RdPinButtonModel> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.Tooltip);
      WriteIconNullable(ctx, writer, value.Icon);
      RdVoidSignal.Write(ctx, writer, value._Execute);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Execute.BindEx(lifetime, this, "execute");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Execute.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdPinButtonModel (");
      using (printer.IndentCookie()) {
        printer.Print("tooltip = "); Tooltip.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("execute = "); _Execute.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdPopupMenuModel : RdPopupMenuModelBase
   {
    //fields
    [NotNull] public IRdProperty<RdExpandSubmenuRequest> ExpandSubmenu { get { return _ExpandSubmenu; }}
    [NotNull] private readonly RdProperty<RdExpandSubmenuRequest> _ExpandSubmenu;
    [NotNull] public List<JetBrains.Rider.Model.UiContext.ContextPair> Timestamps {get; private set;}
    [NotNull] public RdPopupWindowContextBase Context {get; private set;}
    
    //primary constructor
    private RdPopupMenuModel(
      [NotNull] RdProperty<RdExpandSubmenuRequest> expandSubmenu,
      [NotNull] List<JetBrains.Rider.Model.UiContext.ContextPair> timestamps,
      [NotNull] RdPopupWindowContextBase context,
      [NotNull] RdProperty<RdPopupMenuModelItems> items,
      [NotNull] RdEndpoint<int, bool> executeItem,
      [NotNull] RdProperty<RdPopupSelection> selectedItem,
      [NotNull] RdToolBarModel toolbar,
      [NotNull] RdFilterModel filter,
      bool modal,
      [NotNull] RdProperty<bool> isPrepared
    ) : base (
      items,
      executeItem,
      selectedItem,
      toolbar,
      filter,
      modal,
      isPrepared
     ) 
    {
      _ExpandSubmenu = expandSubmenu;
      Timestamps = timestamps;
      Context = context;
    }
    //secondary constructor
    public RdPopupMenuModel (
      [NotNull] List<JetBrains.Rider.Model.UiContext.ContextPair> Timestamps,
      [NotNull] RdPopupWindowContextBase Context,
      bool Modal
    ) : this (
      new RdProperty<RdExpandSubmenuRequest>(),
      Timestamps,
      Context,
      new RdProperty<RdPopupMenuModelItems>(),
      new RdEndpoint<int, bool>(),
      new RdProperty<RdPopupSelection>(),
      new RdToolBarModel(),
      new RdFilterModel(),
      Modal,
      new RdProperty<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdExpandSubmenuRequest> ReadRdExpandSubmenuRequestNullable = RdExpandSubmenuRequest.Read.NullableClass();
    public static CtxReadDelegate<List<JetBrains.Rider.Model.UiContext.ContextPair>> ReadContextPairList = JetBrains.Rider.Model.UiContext.ContextPair.Read.List();
    public static new CtxReadDelegate<RdPopupMenuModel> Read = (ctx, reader) => 
    {
      var expandSubmenu = RdProperty<RdExpandSubmenuRequest>.Read(ctx, reader);
      var timestamps = ReadContextPairList(ctx, reader);
      var context = RdPopupWindowContextBase.Read(ctx, reader);
      var items = RdProperty<RdPopupMenuModelItems>.Read(ctx, reader);
      var executeItem = RdEndpoint<int, bool>.Read(ctx, reader);
      var selectedItem = RdProperty<RdPopupSelection>.Read(ctx, reader);
      var toolbar = RdToolBarModel.Read(ctx, reader);
      var filter = RdFilterModel.Read(ctx, reader);
      var modal = reader.ReadBool();
      var isPrepared = RdProperty<bool>.Read(ctx, reader);
      return new RdPopupMenuModel(expandSubmenu, timestamps, context, items, executeItem, selectedItem, toolbar, filter, modal, isPrepared);
    };
    
    public static CtxWriteDelegate<RdExpandSubmenuRequest> WriteRdExpandSubmenuRequestNullable = RdExpandSubmenuRequest.Write.NullableClass();
    public static CtxWriteDelegate<List<JetBrains.Rider.Model.UiContext.ContextPair>> WriteContextPairList = JetBrains.Rider.Model.UiContext.ContextPair.Write.List();
    public static new CtxWriteDelegate<RdPopupMenuModel> Write = (ctx, writer, value) => 
    {
      RdProperty<RdExpandSubmenuRequest>.Write(ctx, writer, value._ExpandSubmenu);
      WriteContextPairList(ctx, writer, value.Timestamps);
      RdPopupWindowContextBase.Write(ctx, writer, value.Context);
      RdProperty<RdPopupMenuModelItems>.Write(ctx, writer, value._Items);
      RdEndpoint<int, bool>.Write(ctx, writer, value._ExecuteItem);
      RdProperty<RdPopupSelection>.Write(ctx, writer, value._SelectedItem);
      RdToolBarModel.Write(ctx, writer, value.Toolbar);
      RdFilterModel.Write(ctx, writer, value.Filter);
      writer.Write(value.Modal);
      RdProperty<bool>.Write(ctx, writer, value._IsPrepared);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _ExpandSubmenu.BindEx(lifetime, this, "expandSubmenu");
      _Items.BindEx(lifetime, this, "items");
      _ExecuteItem.BindEx(lifetime, this, "executeItem");
      _SelectedItem.BindEx(lifetime, this, "selectedItem");
      Toolbar.BindEx(lifetime, this, "toolbar");
      Filter.BindEx(lifetime, this, "filter");
      _IsPrepared.BindEx(lifetime, this, "isPrepared");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ExpandSubmenu.IdentifyEx(ids);
      _Items.IdentifyEx(ids);
      _ExecuteItem.IdentifyEx(ids);
      _SelectedItem.IdentifyEx(ids);
      Toolbar.IdentifyEx(ids);
      Filter.IdentifyEx(ids);
      _IsPrepared.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdPopupMenuModel (");
      using (printer.IndentCookie()) {
        printer.Print("expandSubmenu = "); _ExpandSubmenu.PrintEx(printer); printer.Println();
        printer.Print("timestamps = "); Timestamps.PrintEx(printer); printer.Println();
        printer.Print("context = "); Context.PrintEx(printer); printer.Println();
        printer.Print("items = "); _Items.PrintEx(printer); printer.Println();
        printer.Print("executeItem = "); _ExecuteItem.PrintEx(printer); printer.Println();
        printer.Print("selectedItem = "); _SelectedItem.PrintEx(printer); printer.Println();
        printer.Print("toolbar = "); Toolbar.PrintEx(printer); printer.Println();
        printer.Print("filter = "); Filter.PrintEx(printer); printer.Println();
        printer.Print("modal = "); Modal.PrintEx(printer); printer.Println();
        printer.Print("isPrepared = "); _IsPrepared.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdPopupMenuModelBase : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<RdPopupMenuModelItems> Items { get { return _Items; }}
    [NotNull] protected readonly RdProperty<RdPopupMenuModelItems> _Items;
    [NotNull] public RdEndpoint<int, bool> ExecuteItem { get { return _ExecuteItem; }}
    [NotNull] protected readonly RdEndpoint<int, bool> _ExecuteItem;
    [NotNull] public IRdProperty<RdPopupSelection> SelectedItem { get { return _SelectedItem; }}
    [NotNull] protected readonly RdProperty<RdPopupSelection> _SelectedItem;
    [NotNull] public RdToolBarModel Toolbar {get; private set;}
    [NotNull] public RdFilterModel Filter {get; private set;}
    public bool Modal {get; private set;}
    [NotNull] public IRdProperty<bool> IsPrepared { get { return _IsPrepared; }}
    [NotNull] protected readonly RdProperty<bool> _IsPrepared;
    
    //primary constructor
    protected RdPopupMenuModelBase(
      [NotNull] RdProperty<RdPopupMenuModelItems> items,
      [NotNull] RdEndpoint<int, bool> executeItem,
      [NotNull] RdProperty<RdPopupSelection> selectedItem,
      [NotNull] RdToolBarModel toolbar,
      [NotNull] RdFilterModel filter,
      bool modal,
      [NotNull] RdProperty<bool> isPrepared
    )
    {
      _Items = items;
      _ExecuteItem = executeItem;
      _SelectedItem = selectedItem;
      Toolbar = toolbar;
      Filter = filter;
      Modal = modal;
      _IsPrepared = isPrepared;
      isPrepared.OptimizeNested = true;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdPopupMenuModelBase> Read = (ctx, reader) => ctx.Serializers.Read<RdPopupMenuModelBase>(ctx, reader);
    
    public static CtxWriteDelegate<RdPopupMenuModelBase> Write = (ctx, writer, value) => ctx.Serializers.Write<RdPopupMenuModelBase>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdPopupMenuModelItem : RdBindableBase {
    //fields
    public int ItemId {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon OptionalIcon {get; private set;}
    [NotNull] public JetBrains.Rider.Model.ModelRichText Text {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.ModelRichText OptionalText {get; private set;}
    [CanBeNull] public string ActionId {get; private set;}
    [CanBeNull] public string Tooltip {get; private set;}
    public bool IsSeparator {get; private set;}
    public bool IsEnabled {get; private set;}
    public bool CanExpand {get; private set;}
    public bool IsGroupHeader {get; private set;}
    
    //primary constructor
    public RdPopupMenuModelItem(
      int itemId,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [CanBeNull] JetBrains.Rider.Model.Icon optionalIcon,
      [NotNull] JetBrains.Rider.Model.ModelRichText text,
      [CanBeNull] JetBrains.Rider.Model.ModelRichText optionalText,
      [CanBeNull] string actionId,
      [CanBeNull] string tooltip,
      bool isSeparator,
      bool isEnabled,
      bool canExpand,
      bool isGroupHeader
    )
    {
      ItemId = itemId;
      Icon = icon;
      OptionalIcon = optionalIcon;
      Text = text;
      OptionalText = optionalText;
      ActionId = actionId;
      Tooltip = tooltip;
      IsSeparator = isSeparator;
      IsEnabled = isEnabled;
      CanExpand = canExpand;
      IsGroupHeader = isGroupHeader;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<JetBrains.Rider.Model.ModelRichText> ReadModelRichTextNullable = JetBrains.Rider.Model.ModelRichText.Read.NullableClass();
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<RdPopupMenuModelItem> Read = (ctx, reader) => 
    {
      var itemId = reader.ReadInt();
      var icon = ReadIconNullable(ctx, reader);
      var optionalIcon = ReadIconNullable(ctx, reader);
      var text = JetBrains.Rider.Model.ModelRichText.Read(ctx, reader);
      var optionalText = ReadModelRichTextNullable(ctx, reader);
      var actionId = ReadStringNullable(ctx, reader);
      var tooltip = ReadStringNullable(ctx, reader);
      var isSeparator = reader.ReadBool();
      var isEnabled = reader.ReadBool();
      var canExpand = reader.ReadBool();
      var isGroupHeader = reader.ReadBool();
      return new RdPopupMenuModelItem(itemId, icon, optionalIcon, text, optionalText, actionId, tooltip, isSeparator, isEnabled, canExpand, isGroupHeader);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<JetBrains.Rider.Model.ModelRichText> WriteModelRichTextNullable = JetBrains.Rider.Model.ModelRichText.Write.NullableClass();
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<RdPopupMenuModelItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemId);
      WriteIconNullable(ctx, writer, value.Icon);
      WriteIconNullable(ctx, writer, value.OptionalIcon);
      JetBrains.Rider.Model.ModelRichText.Write(ctx, writer, value.Text);
      WriteModelRichTextNullable(ctx, writer, value.OptionalText);
      WriteStringNullable(ctx, writer, value.ActionId);
      WriteStringNullable(ctx, writer, value.Tooltip);
      writer.Write(value.IsSeparator);
      writer.Write(value.IsEnabled);
      writer.Write(value.CanExpand);
      writer.Write(value.IsGroupHeader);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdPopupMenuModelItem (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("optionalIcon = "); OptionalIcon.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("optionalText = "); OptionalText.PrintEx(printer); printer.Println();
        printer.Print("actionId = "); ActionId.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); Tooltip.PrintEx(printer); printer.Println();
        printer.Print("isSeparator = "); IsSeparator.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("canExpand = "); CanExpand.PrintEx(printer); printer.Println();
        printer.Print("isGroupHeader = "); IsGroupHeader.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdPopupMenuModelItems : RdBindableBase {
    //fields
    [NotNull] public List<RdPopupMenuModelItem> Value {get; private set;}
    public int SelectedIndex {get; private set;}
    public int Version {get; private set;}
    
    //primary constructor
    public RdPopupMenuModelItems(
      [NotNull] List<RdPopupMenuModelItem> value,
      int selectedIndex,
      int version
    )
    {
      Value = value;
      SelectedIndex = selectedIndex;
      Version = version;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<RdPopupMenuModelItem>> ReadRdPopupMenuModelItemList = RdPopupMenuModelItem.Read.List();
    public static CtxReadDelegate<RdPopupMenuModelItems> Read = (ctx, reader) => 
    {
      var value = ReadRdPopupMenuModelItemList(ctx, reader);
      var selectedIndex = reader.ReadInt();
      var version = reader.ReadInt();
      return new RdPopupMenuModelItems(value, selectedIndex, version);
    };
    
    public static CtxWriteDelegate<List<RdPopupMenuModelItem>> WriteRdPopupMenuModelItemList = RdPopupMenuModelItem.Write.List();
    public static CtxWriteDelegate<RdPopupMenuModelItems> Write = (ctx, writer, value) => 
    {
      WriteRdPopupMenuModelItemList(ctx, writer, value.Value);
      writer.Write(value.SelectedIndex);
      writer.Write(value.Version);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Value.BindEx(lifetime, this, "value");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Value.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdPopupMenuModelItems (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
        printer.Print("selectedIndex = "); SelectedIndex.PrintEx(printer); printer.Println();
        printer.Print("version = "); Version.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdPopupSelection : RdBindableBase {
    //fields
    public int Index {get; private set;}
    public int Version {get; private set;}
    
    //primary constructor
    public RdPopupSelection(
      int index,
      int version
    )
    {
      Index = index;
      Version = version;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdPopupSelection> Read = (ctx, reader) => 
    {
      var index = reader.ReadInt();
      var version = reader.ReadInt();
      return new RdPopupSelection(index, version);
    };
    
    public static CtxWriteDelegate<RdPopupSelection> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Index);
      writer.Write(value.Version);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdPopupSelection (");
      using (printer.IndentCookie()) {
        printer.Print("index = "); Index.PrintEx(printer); printer.Println();
        printer.Print("version = "); Version.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdPopupSubmenuModel : RdPopupMenuModelBase
   {
    //fields
    [NotNull] public IRdProperty<RdExpandSubmenuRequest> ExpandSubmenu { get { return _ExpandSubmenu; }}
    [NotNull] private readonly RdProperty<RdExpandSubmenuRequest> _ExpandSubmenu;
    
    //primary constructor
    private RdPopupSubmenuModel(
      [NotNull] RdProperty<RdExpandSubmenuRequest> expandSubmenu,
      [NotNull] RdProperty<RdPopupMenuModelItems> items,
      [NotNull] RdEndpoint<int, bool> executeItem,
      [NotNull] RdProperty<RdPopupSelection> selectedItem,
      [NotNull] RdToolBarModel toolbar,
      [NotNull] RdFilterModel filter,
      bool modal,
      [NotNull] RdProperty<bool> isPrepared
    ) : base (
      items,
      executeItem,
      selectedItem,
      toolbar,
      filter,
      modal,
      isPrepared
     ) 
    {
      _ExpandSubmenu = expandSubmenu;
    }
    //secondary constructor
    public RdPopupSubmenuModel (
      bool Modal
    ) : this (
      new RdProperty<RdExpandSubmenuRequest>(),
      new RdProperty<RdPopupMenuModelItems>(),
      new RdEndpoint<int, bool>(),
      new RdProperty<RdPopupSelection>(),
      new RdToolBarModel(),
      new RdFilterModel(),
      Modal,
      new RdProperty<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdExpandSubmenuRequest> ReadRdExpandSubmenuRequestNullable = RdExpandSubmenuRequest.Read.NullableClass();
    public static new CtxReadDelegate<RdPopupSubmenuModel> Read = (ctx, reader) => 
    {
      var expandSubmenu = RdProperty<RdExpandSubmenuRequest>.Read(ctx, reader);
      var items = RdProperty<RdPopupMenuModelItems>.Read(ctx, reader);
      var executeItem = RdEndpoint<int, bool>.Read(ctx, reader);
      var selectedItem = RdProperty<RdPopupSelection>.Read(ctx, reader);
      var toolbar = RdToolBarModel.Read(ctx, reader);
      var filter = RdFilterModel.Read(ctx, reader);
      var modal = reader.ReadBool();
      var isPrepared = RdProperty<bool>.Read(ctx, reader);
      return new RdPopupSubmenuModel(expandSubmenu, items, executeItem, selectedItem, toolbar, filter, modal, isPrepared);
    };
    
    public static CtxWriteDelegate<RdExpandSubmenuRequest> WriteRdExpandSubmenuRequestNullable = RdExpandSubmenuRequest.Write.NullableClass();
    public static new CtxWriteDelegate<RdPopupSubmenuModel> Write = (ctx, writer, value) => 
    {
      RdProperty<RdExpandSubmenuRequest>.Write(ctx, writer, value._ExpandSubmenu);
      RdProperty<RdPopupMenuModelItems>.Write(ctx, writer, value._Items);
      RdEndpoint<int, bool>.Write(ctx, writer, value._ExecuteItem);
      RdProperty<RdPopupSelection>.Write(ctx, writer, value._SelectedItem);
      RdToolBarModel.Write(ctx, writer, value.Toolbar);
      RdFilterModel.Write(ctx, writer, value.Filter);
      writer.Write(value.Modal);
      RdProperty<bool>.Write(ctx, writer, value._IsPrepared);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _ExpandSubmenu.BindEx(lifetime, this, "expandSubmenu");
      _Items.BindEx(lifetime, this, "items");
      _ExecuteItem.BindEx(lifetime, this, "executeItem");
      _SelectedItem.BindEx(lifetime, this, "selectedItem");
      Toolbar.BindEx(lifetime, this, "toolbar");
      Filter.BindEx(lifetime, this, "filter");
      _IsPrepared.BindEx(lifetime, this, "isPrepared");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ExpandSubmenu.IdentifyEx(ids);
      _Items.IdentifyEx(ids);
      _ExecuteItem.IdentifyEx(ids);
      _SelectedItem.IdentifyEx(ids);
      Toolbar.IdentifyEx(ids);
      Filter.IdentifyEx(ids);
      _IsPrepared.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdPopupSubmenuModel (");
      using (printer.IndentCookie()) {
        printer.Print("expandSubmenu = "); _ExpandSubmenu.PrintEx(printer); printer.Println();
        printer.Print("items = "); _Items.PrintEx(printer); printer.Println();
        printer.Print("executeItem = "); _ExecuteItem.PrintEx(printer); printer.Println();
        printer.Print("selectedItem = "); _SelectedItem.PrintEx(printer); printer.Println();
        printer.Print("toolbar = "); Toolbar.PrintEx(printer); printer.Println();
        printer.Print("filter = "); Filter.PrintEx(printer); printer.Println();
        printer.Print("modal = "); Modal.PrintEx(printer); printer.Println();
        printer.Print("isPrepared = "); _IsPrepared.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdPopupWindowContextBase {
    //fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdPopupWindowContextBase> Read = (ctx, reader) => ctx.Serializers.Read<RdPopupWindowContextBase>(ctx, reader);
    
    public static CtxWriteDelegate<RdPopupWindowContextBase> Write = (ctx, writer, value) => ctx.Serializers.Write<RdPopupWindowContextBase>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdPresentableItemCaptionModel : RdCaptionModelBase
   {
    //fields
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public string Title {get; private set;}
    
    //primary constructor
    public RdPresentableItemCaptionModel(
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] string title
    )
    {
      Icon = icon;
      Title = title;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdPresentableItemCaptionModel> Read = (ctx, reader) => 
    {
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var title = reader.ReadString();
      return new RdPresentableItemCaptionModel(icon, title);
    };
    
    public static new CtxWriteDelegate<RdPresentableItemCaptionModel> Write = (ctx, writer, value) => 
    {
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      writer.Write(value.Title);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdPresentableItemCaptionModel (");
      using (printer.IndentCookie()) {
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdRichTextCaptionModel : RdCaptionModelBase
   {
    //fields
    [NotNull] public string Title {get; private set;}
    
    //primary constructor
    public RdRichTextCaptionModel(
      [NotNull] string title
    )
    {
      Title = title;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdRichTextCaptionModel> Read = (ctx, reader) => 
    {
      var title = reader.ReadString();
      return new RdRichTextCaptionModel(title);
    };
    
    public static new CtxWriteDelegate<RdRichTextCaptionModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Title);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdRichTextCaptionModel (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdRichTextWithProgressCaptionModel : RdCaptionModelBase
   {
    //fields
    [NotNull] public IRdProperty<string> Text { get { return _Text; }}
    [NotNull] private readonly RdProperty<string> _Text;
    [NotNull] public IRdProperty<double> Fraction { get { return _Fraction; }}
    [NotNull] private readonly RdProperty<double> _Fraction;
    
    //primary constructor
    private RdRichTextWithProgressCaptionModel(
      [NotNull] RdProperty<string> text,
      [NotNull] RdProperty<double> fraction
    )
    {
      _Text = text;
      _Fraction = fraction;
      text.OptimizeNested = true;
      fraction.OptimizeNested = true;
    }
    //secondary constructor
    public RdRichTextWithProgressCaptionModel (
    ) : this (
      new RdProperty<string>(),
      new RdProperty<double>()
    ) {}
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static new CtxReadDelegate<RdRichTextWithProgressCaptionModel> Read = (ctx, reader) => 
    {
      var text = RdProperty<string>.Read(ctx, reader);
      var fraction = RdProperty<double>.Read(ctx, reader);
      return new RdRichTextWithProgressCaptionModel(text, fraction);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static new CtxWriteDelegate<RdRichTextWithProgressCaptionModel> Write = (ctx, writer, value) => 
    {
      RdProperty<string>.Write(ctx, writer, value._Text);
      RdProperty<double>.Write(ctx, writer, value._Fraction);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Text.BindEx(lifetime, this, "text");
      _Fraction.BindEx(lifetime, this, "fraction");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Text.IdentifyEx(ids);
      _Fraction.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdRichTextWithProgressCaptionModel (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); _Text.PrintEx(printer); printer.Println();
        printer.Print("fraction = "); _Fraction.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdToolBarModel : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<RdCaptionModelBase> Caption { get { return _Caption; }}
    [NotNull] private readonly RdProperty<RdCaptionModelBase> _Caption;
    [NotNull] public IViewableMap<int, RdButtonModel> Buttons { get { return _Buttons; }}
    [NotNull] private readonly RdMap<int, RdButtonModel> _Buttons;
    
    //primary constructor
    private RdToolBarModel(
      [NotNull] RdProperty<RdCaptionModelBase> caption,
      [NotNull] RdMap<int, RdButtonModel> buttons
    )
    {
      _Caption = caption;
      _Buttons = buttons;
    }
    //secondary constructor
    public RdToolBarModel (
    ) : this (
      new RdProperty<RdCaptionModelBase>(),
      new RdMap<int, RdButtonModel>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdCaptionModelBase> ReadRdCaptionModelBaseNullable = RdCaptionModelBase.Read.NullableClass();
    public static CtxReadDelegate<RdToolBarModel> Read = (ctx, reader) => 
    {
      var caption = RdProperty<RdCaptionModelBase>.Read(ctx, reader);
      var buttons = RdMap<int, RdButtonModel>.Read(ctx, reader);
      return new RdToolBarModel(caption, buttons);
    };
    
    public static CtxWriteDelegate<RdCaptionModelBase> WriteRdCaptionModelBaseNullable = RdCaptionModelBase.Write.NullableClass();
    public static CtxWriteDelegate<RdToolBarModel> Write = (ctx, writer, value) => 
    {
      RdProperty<RdCaptionModelBase>.Write(ctx, writer, value._Caption);
      RdMap<int, RdButtonModel>.Write(ctx, writer, value._Buttons);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Caption.BindEx(lifetime, this, "caption");
      _Buttons.BindEx(lifetime, this, "buttons");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Caption.IdentifyEx(ids);
      _Buttons.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdToolBarModel (");
      using (printer.IndentCookie()) {
        printer.Print("caption = "); _Caption.PrintEx(printer); printer.Println();
        printer.Print("buttons = "); _Buttons.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
