using System;
using System.Linq;
using System.Collections.Generic;
using JetBrains.Application;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [ShellComponent]
  public class RdActionExecutionContextHost : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<RdCancelableProgress> ProgressState { get { return _ProgressState; }}
    [NotNull] private readonly RdProperty<RdCancelableProgress> _ProgressState;
    
    //primary constructor
    public RdActionExecutionContextHost(
      [NotNull] RdProperty<RdCancelableProgress> progressState
    )
    {
      _ProgressState = progressState;
    }
    //secondary constructor
    //statics
    
    private void Register(ISerializers serializers)
    {
      serializers.Register(RdCancelableProgress.Read, RdCancelableProgress.Write);
    }
    
    public RdActionExecutionContextHost(Lifetime lifetime, IProtocol protocol) : this (
      new RdProperty<RdCancelableProgress>().Static(1018)
    )
    {
      Register(protocol.Serializers);
      Bind(lifetime, protocol, GetType().Name);
    }
    //init method
    protected override void Init(Lifetime lifetime) {
      _ProgressState.BindEx(lifetime, this, "progressState");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ProgressState.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdActionExecutionContextHost (");
      using (printer.IndentCookie()) {
        printer.Print("progressState = "); _ProgressState.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCancelableProgress : RdBindableBase {
    //fields
    [NotNull] public string TaskName {get; private set;}
    [NotNull] public ISource<double> Fraction { get { return _Fraction; }}
    [NotNull] private readonly RdSignal<double> _Fraction;
    [NotNull] public ISource<string> Text { get { return _Text; }}
    [NotNull] private readonly RdSignal<string> _Text;
    [NotNull] public IAsyncVoidSink Cancel { get { return _Cancel; }}
    [NotNull] private readonly RdVoidSignal _Cancel;
    
    //primary constructor
    private RdCancelableProgress(
      [NotNull] string taskName,
      [NotNull] RdSignal<double> fraction,
      [NotNull] RdSignal<string> text,
      [NotNull] RdVoidSignal cancel
    )
    {
      TaskName = taskName;
      _Fraction = fraction;
      _Text = text;
      _Cancel = cancel;
      cancel.Async = true;
    }
    //secondary constructor
    public RdCancelableProgress (
      [NotNull] string TaskName
    ) : this (
      TaskName,
      new RdSignal<double>(),
      new RdSignal<string>(),
      new RdVoidSignal()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdCancelableProgress> Read = (ctx, reader) => 
    {
      var taskName = reader.ReadString();
      var fraction = RdSignal<double>.Read(ctx, reader);
      var text = RdSignal<string>.Read(ctx, reader);
      var cancel = RdVoidSignal.Read(ctx, reader);
      return new RdCancelableProgress(taskName, fraction, text, cancel);
    };
    
    public static CtxWriteDelegate<RdCancelableProgress> Write = (ctx, writer, value) => 
    {
      writer.Write(value.TaskName);
      RdSignal<double>.Write(ctx, writer, value._Fraction);
      RdSignal<string>.Write(ctx, writer, value._Text);
      RdVoidSignal.Write(ctx, writer, value._Cancel);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Fraction.BindEx(lifetime, this, "fraction");
      _Text.BindEx(lifetime, this, "text");
      _Cancel.BindEx(lifetime, this, "cancel");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Fraction.IdentifyEx(ids);
      _Text.IdentifyEx(ids);
      _Cancel.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdCancelableProgress (");
      using (printer.IndentCookie()) {
        printer.Print("taskName = "); TaskName.PrintEx(printer); printer.Println();
        printer.Print("fraction = "); _Fraction.PrintEx(printer); printer.Println();
        printer.Print("text = "); _Text.PrintEx(printer); printer.Println();
        printer.Print("cancel = "); _Cancel.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
