using System;
using System.Linq;
using System.Collections.Generic;
using JetBrains.Application;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [ShellComponent]
  public class RdCurrentDotNetCoreSettings : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<bool> IsReady { get { return _IsReady; }}
    [NotNull] private readonly RdProperty<bool> _IsReady;
    [NotNull] public IRdProperty<string> CliExePath { get { return _CliExePath; }}
    [NotNull] private readonly RdProperty<string> _CliExePath;
    
    //primary constructor
    public RdCurrentDotNetCoreSettings(
      [NotNull] RdProperty<bool> isReady,
      [NotNull] RdProperty<string> cliExePath
    )
    {
      _IsReady = isReady;
      _CliExePath = cliExePath;
      isReady.OptimizeNested = true;
      cliExePath.OptimizeNested = true;
    }
    //secondary constructor
    //statics
    
    private void Register(ISerializers serializers)
    {
    }
    
    public RdCurrentDotNetCoreSettings(Lifetime lifetime, IProtocol protocol) : this (
      new RdProperty<bool>().Static(1019),
      new RdProperty<string>().Static(1020)
    )
    {
      Register(protocol.Serializers);
      Bind(lifetime, protocol, GetType().Name);
    }
    //init method
    protected override void Init(Lifetime lifetime) {
      _IsReady.BindEx(lifetime, this, "isReady");
      _CliExePath.BindEx(lifetime, this, "cliExePath");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _IsReady.IdentifyEx(ids);
      _CliExePath.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdCurrentDotNetCoreSettings (");
      using (printer.IndentCookie()) {
        printer.Print("isReady = "); _IsReady.PrintEx(printer); printer.Println();
        printer.Print("cliExePath = "); _CliExePath.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
