using System;
using System.Linq;
using System.Collections.Generic;
using JetBrains.Application;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [ShellComponent]
  public class RdCurrentMonoSettings : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<bool> IsReady { get { return _IsReady; }}
    [NotNull] private readonly RdProperty<bool> _IsReady;
    [NotNull] public IRdProperty<string> MonoRootPath { get { return _MonoRootPath; }}
    [NotNull] private readonly RdProperty<string> _MonoRootPath;
    
    //primary constructor
    public RdCurrentMonoSettings(
      [NotNull] RdProperty<bool> isReady,
      [NotNull] RdProperty<string> monoRootPath
    )
    {
      _IsReady = isReady;
      _MonoRootPath = monoRootPath;
      isReady.OptimizeNested = true;
      monoRootPath.OptimizeNested = true;
    }
    //secondary constructor
    //statics
    
    private void Register(ISerializers serializers)
    {
    }
    
    public RdCurrentMonoSettings(Lifetime lifetime, IProtocol protocol) : this (
      new RdProperty<bool>().Static(1021),
      new RdProperty<string>().Static(1022)
    )
    {
      Register(protocol.Serializers);
      Bind(lifetime, protocol, GetType().Name);
    }
    //init method
    protected override void Init(Lifetime lifetime) {
      _IsReady.BindEx(lifetime, this, "isReady");
      _MonoRootPath.BindEx(lifetime, this, "monoRootPath");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _IsReady.IdentifyEx(ids);
      _MonoRootPath.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdCurrentMonoSettings (");
      using (printer.IndentCookie()) {
        printer.Print("isReady = "); _IsReady.PrintEx(printer); printer.Println();
        printer.Print("monoRootPath = "); _MonoRootPath.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
