using System;
using System.Linq;
using System.Collections.Generic;
using JetBrains.Application;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [ShellComponent]
  public class RdCurrentToolsetSettings : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<string> ToolsetVersion { get { return _ToolsetVersion; }}
    [NotNull] private readonly RdProperty<string> _ToolsetVersion;
    [NotNull] public IRdProperty<bool> UseHigherToolsetVersion { get { return _UseHigherToolsetVersion; }}
    [NotNull] private readonly RdProperty<bool> _UseHigherToolsetVersion;
    [NotNull] public IRdProperty<bool> UseCustomToolset { get { return _UseCustomToolset; }}
    [NotNull] private readonly RdProperty<bool> _UseCustomToolset;
    [NotNull] public IRdProperty<string> CustomToolsetPath { get { return _CustomToolsetPath; }}
    [NotNull] private readonly RdProperty<string> _CustomToolsetPath;
    [NotNull] public IRdProperty<RdToolset> CurrentToolset { get { return _CurrentToolset; }}
    [NotNull] private readonly RdProperty<RdToolset> _CurrentToolset;
    [NotNull] public IViewableMap<string, string> AvailableToolsetVersions { get { return _AvailableToolsetVersions; }}
    [NotNull] private readonly RdMap<string, string> _AvailableToolsetVersions;
    [NotNull] public IRdProperty<bool> IsReady { get { return _IsReady; }}
    [NotNull] private readonly RdProperty<bool> _IsReady;
    
    //primary constructor
    public RdCurrentToolsetSettings(
      [NotNull] RdProperty<string> toolsetVersion,
      [NotNull] RdProperty<bool> useHigherToolsetVersion,
      [NotNull] RdProperty<bool> useCustomToolset,
      [NotNull] RdProperty<string> customToolsetPath,
      [NotNull] RdProperty<RdToolset> currentToolset,
      [NotNull] RdMap<string, string> availableToolsetVersions,
      [NotNull] RdProperty<bool> isReady
    )
    {
      _ToolsetVersion = toolsetVersion;
      _UseHigherToolsetVersion = useHigherToolsetVersion;
      _UseCustomToolset = useCustomToolset;
      _CustomToolsetPath = customToolsetPath;
      _CurrentToolset = currentToolset;
      _AvailableToolsetVersions = availableToolsetVersions;
      _IsReady = isReady;
      toolsetVersion.OptimizeNested = true;
      useHigherToolsetVersion.OptimizeNested = true;
      useCustomToolset.OptimizeNested = true;
      customToolsetPath.OptimizeNested = true;
      availableToolsetVersions.OptimizeNested = true;
      isReady.OptimizeNested = true;
    }
    //secondary constructor
    //statics
    
    private void Register(ISerializers serializers)
    {
      serializers.Register(RdToolset.Read, RdToolset.Write);
    }
    
    public RdCurrentToolsetSettings(Lifetime lifetime, IProtocol protocol) : this (
      new RdProperty<string>().Static(1023),
      new RdProperty<bool>().Static(1024),
      new RdProperty<bool>().Static(1025),
      new RdProperty<string>().Static(1026),
      new RdProperty<RdToolset>().Static(1027),
      new RdMap<string, string>().Static(1028),
      new RdProperty<bool>().Static(1029)
    )
    {
      Register(protocol.Serializers);
      Bind(lifetime, protocol, GetType().Name);
    }
    //init method
    protected override void Init(Lifetime lifetime) {
      _ToolsetVersion.BindEx(lifetime, this, "toolsetVersion");
      _UseHigherToolsetVersion.BindEx(lifetime, this, "useHigherToolsetVersion");
      _UseCustomToolset.BindEx(lifetime, this, "useCustomToolset");
      _CustomToolsetPath.BindEx(lifetime, this, "customToolsetPath");
      _CurrentToolset.BindEx(lifetime, this, "currentToolset");
      _AvailableToolsetVersions.BindEx(lifetime, this, "availableToolsetVersions");
      _IsReady.BindEx(lifetime, this, "isReady");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ToolsetVersion.IdentifyEx(ids);
      _UseHigherToolsetVersion.IdentifyEx(ids);
      _UseCustomToolset.IdentifyEx(ids);
      _CustomToolsetPath.IdentifyEx(ids);
      _CurrentToolset.IdentifyEx(ids);
      _AvailableToolsetVersions.IdentifyEx(ids);
      _IsReady.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdCurrentToolsetSettings (");
      using (printer.IndentCookie()) {
        printer.Print("toolsetVersion = "); _ToolsetVersion.PrintEx(printer); printer.Println();
        printer.Print("useHigherToolsetVersion = "); _UseHigherToolsetVersion.PrintEx(printer); printer.Println();
        printer.Print("useCustomToolset = "); _UseCustomToolset.PrintEx(printer); printer.Println();
        printer.Print("customToolsetPath = "); _CustomToolsetPath.PrintEx(printer); printer.Println();
        printer.Print("currentToolset = "); _CurrentToolset.PrintEx(printer); printer.Println();
        printer.Print("availableToolsetVersions = "); _AvailableToolsetVersions.PrintEx(printer); printer.Println();
        printer.Print("isReady = "); _IsReady.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdToolset : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<string> ExePath { get { return _ExePath; }}
    [NotNull] private readonly RdProperty<string> _ExePath;
    [NotNull] public IRdProperty<string> Directory { get { return _Directory; }}
    [NotNull] private readonly RdProperty<string> _Directory;
    [NotNull] public IRdProperty<string> Version { get { return _Version; }}
    [NotNull] private readonly RdProperty<string> _Version;
    
    //primary constructor
    private RdToolset(
      [NotNull] RdProperty<string> exePath,
      [NotNull] RdProperty<string> directory,
      [NotNull] RdProperty<string> version
    )
    {
      _ExePath = exePath;
      _Directory = directory;
      _Version = version;
      exePath.OptimizeNested = true;
      directory.OptimizeNested = true;
      version.OptimizeNested = true;
    }
    //secondary constructor
    public RdToolset (
    ) : this (
      new RdProperty<string>(),
      new RdProperty<string>(),
      new RdProperty<string>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdToolset> Read = (ctx, reader) => 
    {
      var exePath = RdProperty<string>.Read(ctx, reader);
      var directory = RdProperty<string>.Read(ctx, reader);
      var version = RdProperty<string>.Read(ctx, reader);
      return new RdToolset(exePath, directory, version);
    };
    
    public static CtxWriteDelegate<RdToolset> Write = (ctx, writer, value) => 
    {
      RdProperty<string>.Write(ctx, writer, value._ExePath);
      RdProperty<string>.Write(ctx, writer, value._Directory);
      RdProperty<string>.Write(ctx, writer, value._Version);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _ExePath.BindEx(lifetime, this, "exePath");
      _Directory.BindEx(lifetime, this, "directory");
      _Version.BindEx(lifetime, this, "version");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ExePath.IdentifyEx(ids);
      _Directory.IdentifyEx(ids);
      _Version.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdToolset (");
      using (printer.IndentCookie()) {
        printer.Print("exePath = "); _ExePath.PrintEx(printer); printer.Println();
        printer.Print("directory = "); _Directory.PrintEx(printer); printer.Println();
        printer.Print("version = "); _Version.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
