using System;
using System.Linq;
using System.Collections.Generic;
using JetBrains.Application;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [ShellComponent]
  public class RdShellModel : RdBindableBase {
    //fields
    [NotNull] public RdEndpoint<RdVoid, long> GetTotalMemory { get { return _GetTotalMemory; }}
    [NotNull] private readonly RdEndpoint<RdVoid, long> _GetTotalMemory;
    [NotNull] public RdEndpoint<RdVoid, RdVoid> ClearStaticCaches { get { return _ClearStaticCaches; }}
    [NotNull] private readonly RdEndpoint<RdVoid, RdVoid> _ClearStaticCaches;
    [NotNull] public IViewableMap<int, int> RiderInternalProcesses { get { return _RiderInternalProcesses; }}
    [NotNull] private readonly RdMap<int, int> _RiderInternalProcesses;
    [NotNull] public IRdProperty<bool> Initialized { get { return _Initialized; }}
    [NotNull] private readonly RdProperty<bool> _Initialized;
    [NotNull] public IVoidSink Shutdown { get { return _Shutdown; }}
    [NotNull] private readonly RdVoidSignal _Shutdown;
    [NotNull] public IRdProperty<JetBrains.Rider.Model.LookAndFeelTheme> LookAndFeelTheme { get { return _LookAndFeelTheme; }}
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.LookAndFeelTheme> _LookAndFeelTheme;
    [NotNull] public IRdProperty<bool> PersistSolutionCaches { get { return _PersistSolutionCaches; }}
    [NotNull] private readonly RdProperty<bool> _PersistSolutionCaches;
    [NotNull] public RdEndpoint<RdVoid, RdVoid> LogException { get { return _LogException; }}
    [NotNull] private readonly RdEndpoint<RdVoid, RdVoid> _LogException;
    
    //primary constructor
    public RdShellModel(
      [NotNull] RdEndpoint<RdVoid, long> getTotalMemory,
      [NotNull] RdEndpoint<RdVoid, RdVoid> clearStaticCaches,
      [NotNull] RdMap<int, int> riderInternalProcesses,
      [NotNull] RdProperty<bool> initialized,
      [NotNull] RdVoidSignal shutdown,
      [NotNull] RdProperty<JetBrains.Rider.Model.LookAndFeelTheme> lookAndFeelTheme,
      [NotNull] RdProperty<bool> persistSolutionCaches,
      [NotNull] RdEndpoint<RdVoid, RdVoid> logException
    )
    {
      _GetTotalMemory = getTotalMemory;
      _ClearStaticCaches = clearStaticCaches;
      _RiderInternalProcesses = riderInternalProcesses;
      _Initialized = initialized;
      _Shutdown = shutdown;
      _LookAndFeelTheme = lookAndFeelTheme;
      _PersistSolutionCaches = persistSolutionCaches;
      _LogException = logException;
      riderInternalProcesses.OptimizeNested = true;
      initialized.OptimizeNested = true;
      lookAndFeelTheme.OptimizeNested = true;
      persistSolutionCaches.OptimizeNested = true;
    }
    //secondary constructor
    //statics
    
    private void Register(ISerializers serializers)
    {
      serializers.RegisterEnum<LookAndFeelTheme>();
    }
    
    public RdShellModel(Lifetime lifetime, IProtocol protocol) : this (
      new RdEndpoint<RdVoid, long>().Static(1033),
      new RdEndpoint<RdVoid, RdVoid>().Static(1034),
      new RdMap<int, int>().Static(1035),
      new RdProperty<bool>().Static(1036),
      new RdVoidSignal().Static(1037),
      new RdProperty<JetBrains.Rider.Model.LookAndFeelTheme>().Static(1038),
      new RdProperty<bool>().Static(1039),
      new RdEndpoint<RdVoid, RdVoid>().Static(1040)
    )
    {
      Register(protocol.Serializers);
      Bind(lifetime, protocol, GetType().Name);
    }
    //init method
    protected override void Init(Lifetime lifetime) {
      _GetTotalMemory.BindEx(lifetime, this, "getTotalMemory");
      _ClearStaticCaches.BindEx(lifetime, this, "clearStaticCaches");
      _RiderInternalProcesses.BindEx(lifetime, this, "riderInternalProcesses");
      _Initialized.BindEx(lifetime, this, "initialized");
      _Shutdown.BindEx(lifetime, this, "shutdown");
      _LookAndFeelTheme.BindEx(lifetime, this, "lookAndFeelTheme");
      _PersistSolutionCaches.BindEx(lifetime, this, "persistSolutionCaches");
      _LogException.BindEx(lifetime, this, "logException");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _GetTotalMemory.IdentifyEx(ids);
      _ClearStaticCaches.IdentifyEx(ids);
      _RiderInternalProcesses.IdentifyEx(ids);
      _Initialized.IdentifyEx(ids);
      _Shutdown.IdentifyEx(ids);
      _LookAndFeelTheme.IdentifyEx(ids);
      _PersistSolutionCaches.IdentifyEx(ids);
      _LogException.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdShellModel (");
      using (printer.IndentCookie()) {
        printer.Print("getTotalMemory = "); _GetTotalMemory.PrintEx(printer); printer.Println();
        printer.Print("clearStaticCaches = "); _ClearStaticCaches.PrintEx(printer); printer.Println();
        printer.Print("riderInternalProcesses = "); _RiderInternalProcesses.PrintEx(printer); printer.Println();
        printer.Print("initialized = "); _Initialized.PrintEx(printer); printer.Println();
        printer.Print("shutdown = "); _Shutdown.PrintEx(printer); printer.Println();
        printer.Print("lookAndFeelTheme = "); _LookAndFeelTheme.PrintEx(printer); printer.Println();
        printer.Print("persistSolutionCaches = "); _PersistSolutionCaches.PrintEx(printer); printer.Println();
        printer.Print("logException = "); _LogException.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum LookAndFeelTheme {
    Darcula,
    IntelliJ,
    Windows
  }
}
