using System;
using System.Linq;
using System.Collections.Generic;
using JetBrains.Application;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.Refactorings
{
  
  
  [ShellComponent]
  public class RefactoringInteractionModel : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<RefactoringInteraction> CurrentRefactoring { get { return _CurrentRefactoring; }}
    [NotNull] private readonly RdProperty<RefactoringInteraction> _CurrentRefactoring;
    [NotNull] public IViewableMap<int, PullToolSessionModel> PullToolSessions { get { return _PullToolSessions; }}
    [NotNull] private readonly RdMap<int, PullToolSessionModel> _PullToolSessions;
    [NotNull] public IVoidSink TerminatePullToolSessions { get { return _TerminatePullToolSessions; }}
    [NotNull] private readonly RdVoidSignal _TerminatePullToolSessions;
    
    //primary constructor
    public RefactoringInteractionModel(
      [NotNull] RdProperty<RefactoringInteraction> currentRefactoring,
      [NotNull] RdMap<int, PullToolSessionModel> pullToolSessions,
      [NotNull] RdVoidSignal terminatePullToolSessions
    )
    {
      _CurrentRefactoring = currentRefactoring;
      _PullToolSessions = pullToolSessions;
      _TerminatePullToolSessions = terminatePullToolSessions;
    }
    //secondary constructor
    //statics
    
    private void Register(ISerializers serializers)
    {
      serializers.Register(MessageBoxOK.Read, MessageBoxOK.Write);
      serializers.RegisterEnum<CheckboxState>();
      serializers.RegisterEnum<ValidationStates>();
      serializers.Register(ValidationResult.Read, ValidationResult.Write);
      serializers.Register(RefactoringCompletionItem.Read, RefactoringCompletionItem.Write);
      serializers.Register(RefactoringCompletionList.Read, RefactoringCompletionList.Write);
      serializers.Register(TextWithIconModel.Read, TextWithIconModel.Write);
      serializers.Register(ConflictTextFragment.Read, ConflictTextFragment.Write);
      serializers.Register(Conflict.Read, Conflict.Write);
      serializers.Register(ConflictList.Read, ConflictList.Write);
      serializers.Register(LinkInfo.Read, LinkInfo.Write);
      serializers.Register(ConflictsPageModel.Read, ConflictsPageModel.Write);
      serializers.Register(DerivedRenameElement.Read, DerivedRenameElement.Write);
      serializers.Register(DerivedRenameChange.Read, DerivedRenameChange.Write);
      serializers.Register(DerivedRenamePageModel.Read, DerivedRenamePageModel.Write);
      serializers.Register(TextOccurrencesPageModel.Read, TextOccurrencesPageModel.Write);
      serializers.Register(RelatedElementsPageModelNode.Read, RelatedElementsPageModelNode.Write);
      serializers.Register(RelatedElementsPageModel.Read, RelatedElementsPageModel.Write);
      serializers.Register(WizardForm.Read, WizardForm.Write);
      serializers.Register(RefactoringInteraction.Read, RefactoringInteraction.Write);
      serializers.Register(RenameInitialPage.Read, RenameInitialPage.Write);
      serializers.Register(RenameOverloadsPage.Read, RenameOverloadsPage.Write);
      serializers.Register(BulkRenameModel.Read, BulkRenameModel.Write);
      serializers.Register(InlineMethodPageModel.Read, InlineMethodPageModel.Write);
      serializers.Register(InlineParameterInvocationsModel.Read, InlineParameterInvocationsModel.Write);
      serializers.Register(InlineParameterParameterModel.Read, InlineParameterParameterModel.Write);
      serializers.Register(InlineParameterNewParameterList.Read, InlineParameterNewParameterList.Write);
      serializers.Register(InlineParameterRdModel.Read, InlineParameterRdModel.Write);
      serializers.Register(SafeDeleteInheritorsPageModel.Read, SafeDeleteInheritorsPageModel.Write);
      serializers.Register(SafeDeleteDeleteFilesModel.Read, SafeDeleteDeleteFilesModel.Write);
      serializers.RegisterEnum<SafeDeleteReplaceTypeUsagesEnum>();
      serializers.Register(SafeDeleteReplaceTypeUsagesModel.Read, SafeDeleteReplaceTypeUsagesModel.Write);
      serializers.RegisterEnum<SafeDeleteOverridableMemberEnum>();
      serializers.Register(SafeDeleteOverridableMemberModel.Read, SafeDeleteOverridableMemberModel.Write);
      serializers.Register(SafeDeleteReferenceUsagesModel.Read, SafeDeleteReferenceUsagesModel.Write);
      serializers.RegisterEnum<IntroduceFieldVisibility>();
      serializers.Register(IntroduceFieldModelSuggestions.Read, IntroduceFieldModelSuggestions.Write);
      serializers.RegisterEnum<IntroduceFieldTypeEnum>();
      serializers.Register(IntroduceFieldModel.Read, IntroduceFieldModel.Write);
      serializers.Register(IntroduceParameterElementModel.Read, IntroduceParameterElementModel.Write);
      serializers.Register(IntroduceParameterModel.Read, IntroduceParameterModel.Write);
      serializers.Register(EncapsulateFieldModel.Read, EncapsulateFieldModel.Write);
      serializers.Register(ExtractInterfaceSingleMemberModel.Read, ExtractInterfaceSingleMemberModel.Write);
      serializers.Register(ExtractInterfaceMemberModel.Read, ExtractInterfaceMemberModel.Write);
      serializers.Register(ExtractInterfaceSuperclassModel.Read, ExtractInterfaceSuperclassModel.Write);
      serializers.Register(PullUpTreeElementModel.Read, PullUpTreeElementModel.Write);
      serializers.Register(PullUpMembersModel.Read, PullUpMembersModel.Write);
      serializers.Register(PushDownSingleMemberModel.Read, PushDownSingleMemberModel.Write);
      serializers.Register(PushDownMembersModel.Read, PushDownMembersModel.Write);
      serializers.Register(SelectTypePartModel.Read, SelectTypePartModel.Write);
      serializers.Register(UseBaseTypeModel.Read, UseBaseTypeModel.Write);
      serializers.Register(PropertyToMethodModel.Read, PropertyToMethodModel.Write);
      serializers.Register(MethodToPropertyModel.Read, MethodToPropertyModel.Write);
      serializers.Register(AnonymousToDeclaredTypeModel.Read, AnonymousToDeclaredTypeModel.Write);
      serializers.Register(MoveToNamespaceModel.Read, MoveToNamespaceModel.Write);
      serializers.Register(MoveToFolderTreeElement.Read, MoveToFolderTreeElement.Write);
      serializers.Register(MoveToFolderModel.Read, MoveToFolderModel.Write);
      serializers.Register(MoveFileRemoveEmptyFileModel.Read, MoveFileRemoveEmptyFileModel.Write);
      serializers.RegisterEnum<MoveStaticMemberVisibility>();
      serializers.Register(MoveStaticMemberMemberModel.Read, MoveStaticMemberMemberModel.Write);
      serializers.Register(MoveStaticMemberModel.Read, MoveStaticMemberModel.Write);
      serializers.Register(CopyTypeModel.Read, CopyTypeModel.Write);
      serializers.Register(MakeStaticModelParamModel.Read, MakeStaticModelParamModel.Write);
      serializers.RegisterEnum<MakeStaticOption>();
      serializers.Register(MakeStaticModel.Read, MakeStaticModel.Write);
      serializers.RegisterEnum<ChangeSignatureState>();
      serializers.Register(ChangeSignatureItem.Read, ChangeSignatureItem.Write);
      serializers.Register(ChangeSignatureArrows.Read, ChangeSignatureArrows.Write);
      serializers.Register(ApplyChangeSignatureModel.Read, ApplyChangeSignatureModel.Write);
      serializers.RegisterEnum<ChangeSignatureModifierModel>();
      serializers.Register(ChangeSignatureSingleParameterModel.Read, ChangeSignatureSingleParameterModel.Write);
      serializers.Register(ChangeSignatureParametersModel.Read, ChangeSignatureParametersModel.Write);
      serializers.Register(ChangeSignatureRiderModel.Read, ChangeSignatureRiderModel.Write);
      serializers.Register(TypeSuggestionsElementModel.Read, TypeSuggestionsElementModel.Write);
      serializers.Register(TypeSuggestionsModel.Read, TypeSuggestionsModel.Write);
      serializers.RegisterEnum<DefaultParameterSelection>();
      serializers.Register(DefaultParameterValueModel.Read, DefaultParameterValueModel.Write);
      serializers.RegisterEnum<ExtractMethodKind>();
      serializers.Register(ExtractMethodKindModel.Read, ExtractMethodKindModel.Write);
      serializers.RegisterEnum<ExtractMethodVisibility>();
      serializers.Register(ExtractMethodParameterModel.Read, ExtractMethodParameterModel.Write);
      serializers.Register(ExtractMethodParameterListModel.Read, ExtractMethodParameterListModel.Write);
      serializers.Register(ExtractMethodOptionsModel.Read, ExtractMethodOptionsModel.Write);
      serializers.Register(ConstructorToFactoryModel.Read, ConstructorToFactoryModel.Write);
      serializers.Register(AdjustNamespacesModelElement.Read, AdjustNamespacesModelElement.Write);
      serializers.Register(AdjustNamespacesModel.Read, AdjustNamespacesModel.Write);
      serializers.Register(MoveIntoMatchingFilesModel.Read, MoveIntoMatchingFilesModel.Write);
      serializers.Register(MoveConflictsConflictModel.Read, MoveConflictsConflictModel.Write);
      serializers.Register(MoveConflictsModel.Read, MoveConflictsModel.Write);
      serializers.Register(EmptyPage.Read, EmptyPage.Write);
      serializers.Register(FeelLucky.Read, FeelLucky.Write);
      serializers.Register(PullToolSessionNodeChildren.Read, PullToolSessionNodeChildren.Write);
      serializers.Register(PullToolSessionNode.Read, PullToolSessionNode.Write);
      serializers.Register(PullToolSessionModel.Read, PullToolSessionModel.Write);
    }
    
    public RefactoringInteractionModel(Lifetime lifetime, IProtocol protocol) : this (
      new RdProperty<RefactoringInteraction>().Static(1041),
      new RdMap<int, PullToolSessionModel>().Static(1042),
      new RdVoidSignal().Static(1043)
    )
    {
      Register(protocol.Serializers);
      Bind(lifetime, protocol, GetType().Name);
    }
    //init method
    protected override void Init(Lifetime lifetime) {
      _CurrentRefactoring.BindEx(lifetime, this, "currentRefactoring");
      _PullToolSessions.BindEx(lifetime, this, "pullToolSessions");
      _TerminatePullToolSessions.BindEx(lifetime, this, "terminatePullToolSessions");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _CurrentRefactoring.IdentifyEx(ids);
      _PullToolSessions.IdentifyEx(ids);
      _TerminatePullToolSessions.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RefactoringInteractionModel (");
      using (printer.IndentCookie()) {
        printer.Print("currentRefactoring = "); _CurrentRefactoring.PrintEx(printer); printer.Println();
        printer.Print("pullToolSessions = "); _PullToolSessions.PrintEx(printer); printer.Println();
        printer.Print("terminatePullToolSessions = "); _TerminatePullToolSessions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class AbstractPage : RdBindableBase {
    //fields
    [NotNull] public string Title {get; private set;}
    [NotNull] public string Description {get; private set;}
    [NotNull] public IRdProperty<bool> ContinueEnabled { get { return _ContinueEnabled; }}
    [NotNull] protected readonly RdProperty<bool> _ContinueEnabled;
    [NotNull] public ISource<JetBrains.Rider.Model.Refactorings.ValidationResult> ValidationResult { get { return _ValidationResult; }}
    [NotNull] protected readonly RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> _ValidationResult;
    
    //primary constructor
    protected AbstractPage(
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    )
    {
      Title = title;
      Description = description;
      _ContinueEnabled = continueEnabled;
      _ValidationResult = validationResult;
      continueEnabled.OptimizeNested = true;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<AbstractPage> Read = (ctx, reader) => ctx.Serializers.Read<AbstractPage>(ctx, reader);
    
    public static CtxWriteDelegate<AbstractPage> Write = (ctx, writer, value) => ctx.Serializers.Write<AbstractPage>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class AdjustNamespacesModel : AbstractPage
   {
    //fields
    [NotNull] public List<AdjustNamespacesModelElement> Elements {get; private set;}
    
    //primary constructor
    private AdjustNamespacesModel(
      [NotNull] List<AdjustNamespacesModelElement> elements,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      Elements = elements;
    }
    //secondary constructor
    public AdjustNamespacesModel (
      [NotNull] List<AdjustNamespacesModelElement> Elements,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      Elements,
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<AdjustNamespacesModelElement>> ReadAdjustNamespacesModelElementList = AdjustNamespacesModelElement.Read.List();
    public static new CtxReadDelegate<AdjustNamespacesModel> Read = (ctx, reader) => 
    {
      var elements = ReadAdjustNamespacesModelElementList(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new AdjustNamespacesModel(elements, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<AdjustNamespacesModelElement>> WriteAdjustNamespacesModelElementList = AdjustNamespacesModelElement.Write.List();
    public static new CtxWriteDelegate<AdjustNamespacesModel> Write = (ctx, writer, value) => 
    {
      WriteAdjustNamespacesModelElementList(ctx, writer, value.Elements);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Elements.BindEx(lifetime, this, "elements");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Elements.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("AdjustNamespacesModel (");
      using (printer.IndentCookie()) {
        printer.Print("elements = "); Elements.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class AdjustNamespacesModelElement : RdBindableBase {
    //fields
    [NotNull] public string Text {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public IRdProperty<bool> Include { get { return _Include; }}
    [NotNull] private readonly RdProperty<bool> _Include;
    [NotNull] public IVoidSink Navigate { get { return _Navigate; }}
    [NotNull] private readonly RdVoidSignal _Navigate;
    
    //primary constructor
    private AdjustNamespacesModelElement(
      [NotNull] string text,
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<bool> include,
      [NotNull] RdVoidSignal navigate
    )
    {
      Text = text;
      Icon = icon;
      _Include = include;
      _Navigate = navigate;
      include.OptimizeNested = true;
    }
    //secondary constructor
    public AdjustNamespacesModelElement (
      [NotNull] string Text,
      [NotNull] JetBrains.Rider.Model.Icon Icon
    ) : this (
      Text,
      Icon,
      new RdProperty<bool>(),
      new RdVoidSignal()
    ) {}
    //statics
    
    public static CtxReadDelegate<AdjustNamespacesModelElement> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var include = RdProperty<bool>.Read(ctx, reader);
      var navigate = RdVoidSignal.Read(ctx, reader);
      return new AdjustNamespacesModelElement(text, icon, include, navigate);
    };
    
    public static CtxWriteDelegate<AdjustNamespacesModelElement> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      RdProperty<bool>.Write(ctx, writer, value._Include);
      RdVoidSignal.Write(ctx, writer, value._Navigate);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Include.BindEx(lifetime, this, "include");
      _Navigate.BindEx(lifetime, this, "navigate");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Include.IdentifyEx(ids);
      _Navigate.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("AdjustNamespacesModelElement (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("include = "); _Include.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class AnonymousToDeclaredTypeModel : AbstractPage
   {
    //fields
    [NotNull] public IRdProperty<string> NewName { get { return _NewName; }}
    [NotNull] private readonly RdProperty<string> _NewName;
    [NotNull] public IRdProperty<bool> SolutionScope { get { return _SolutionScope; }}
    [NotNull] private readonly RdProperty<bool> _SolutionScope;
    [NotNull] public IRdProperty<bool> TopLevel { get { return _TopLevel; }}
    [NotNull] private readonly RdProperty<bool> _TopLevel;
    [NotNull] public IRdProperty<bool> WritableProperties { get { return _WritableProperties; }}
    [NotNull] private readonly RdProperty<bool> _WritableProperties;
    [NotNull] public IRdProperty<bool> GenerateEquals { get { return _GenerateEquals; }}
    [NotNull] private readonly RdProperty<bool> _GenerateEquals;
    [NotNull] public IRdProperty<bool> GenerateToString { get { return _GenerateToString; }}
    [NotNull] private readonly RdProperty<bool> _GenerateToString;
    [NotNull] public IRdProperty<bool> FindUsagesAfterwards { get { return _FindUsagesAfterwards; }}
    [NotNull] private readonly RdProperty<bool> _FindUsagesAfterwards;
    [NotNull] public IRdProperty<bool> FindUsagesEnabled { get { return _FindUsagesEnabled; }}
    [NotNull] private readonly RdProperty<bool> _FindUsagesEnabled;
    
    //primary constructor
    private AnonymousToDeclaredTypeModel(
      [NotNull] RdProperty<string> newName,
      [NotNull] RdProperty<bool> solutionScope,
      [NotNull] RdProperty<bool> topLevel,
      [NotNull] RdProperty<bool> writableProperties,
      [NotNull] RdProperty<bool> generateEquals,
      [NotNull] RdProperty<bool> generateToString,
      [NotNull] RdProperty<bool> findUsagesAfterwards,
      [NotNull] RdProperty<bool> findUsagesEnabled,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      _NewName = newName;
      _SolutionScope = solutionScope;
      _TopLevel = topLevel;
      _WritableProperties = writableProperties;
      _GenerateEquals = generateEquals;
      _GenerateToString = generateToString;
      _FindUsagesAfterwards = findUsagesAfterwards;
      _FindUsagesEnabled = findUsagesEnabled;
      newName.OptimizeNested = true;
      solutionScope.OptimizeNested = true;
      topLevel.OptimizeNested = true;
      writableProperties.OptimizeNested = true;
      generateEquals.OptimizeNested = true;
      generateToString.OptimizeNested = true;
      findUsagesAfterwards.OptimizeNested = true;
      findUsagesEnabled.OptimizeNested = true;
    }
    //secondary constructor
    public AnonymousToDeclaredTypeModel (
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      new RdProperty<string>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static new CtxReadDelegate<AnonymousToDeclaredTypeModel> Read = (ctx, reader) => 
    {
      var newName = RdProperty<string>.Read(ctx, reader);
      var solutionScope = RdProperty<bool>.Read(ctx, reader);
      var topLevel = RdProperty<bool>.Read(ctx, reader);
      var writableProperties = RdProperty<bool>.Read(ctx, reader);
      var generateEquals = RdProperty<bool>.Read(ctx, reader);
      var generateToString = RdProperty<bool>.Read(ctx, reader);
      var findUsagesAfterwards = RdProperty<bool>.Read(ctx, reader);
      var findUsagesEnabled = RdProperty<bool>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new AnonymousToDeclaredTypeModel(newName, solutionScope, topLevel, writableProperties, generateEquals, generateToString, findUsagesAfterwards, findUsagesEnabled, title, description, continueEnabled, validationResult);
    };
    
    public static new CtxWriteDelegate<AnonymousToDeclaredTypeModel> Write = (ctx, writer, value) => 
    {
      RdProperty<string>.Write(ctx, writer, value._NewName);
      RdProperty<bool>.Write(ctx, writer, value._SolutionScope);
      RdProperty<bool>.Write(ctx, writer, value._TopLevel);
      RdProperty<bool>.Write(ctx, writer, value._WritableProperties);
      RdProperty<bool>.Write(ctx, writer, value._GenerateEquals);
      RdProperty<bool>.Write(ctx, writer, value._GenerateToString);
      RdProperty<bool>.Write(ctx, writer, value._FindUsagesAfterwards);
      RdProperty<bool>.Write(ctx, writer, value._FindUsagesEnabled);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _NewName.BindEx(lifetime, this, "newName");
      _SolutionScope.BindEx(lifetime, this, "solutionScope");
      _TopLevel.BindEx(lifetime, this, "topLevel");
      _WritableProperties.BindEx(lifetime, this, "writableProperties");
      _GenerateEquals.BindEx(lifetime, this, "generateEquals");
      _GenerateToString.BindEx(lifetime, this, "generateToString");
      _FindUsagesAfterwards.BindEx(lifetime, this, "findUsagesAfterwards");
      _FindUsagesEnabled.BindEx(lifetime, this, "findUsagesEnabled");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _NewName.IdentifyEx(ids);
      _SolutionScope.IdentifyEx(ids);
      _TopLevel.IdentifyEx(ids);
      _WritableProperties.IdentifyEx(ids);
      _GenerateEquals.IdentifyEx(ids);
      _GenerateToString.IdentifyEx(ids);
      _FindUsagesAfterwards.IdentifyEx(ids);
      _FindUsagesEnabled.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("AnonymousToDeclaredTypeModel (");
      using (printer.IndentCookie()) {
        printer.Print("newName = "); _NewName.PrintEx(printer); printer.Println();
        printer.Print("solutionScope = "); _SolutionScope.PrintEx(printer); printer.Println();
        printer.Print("topLevel = "); _TopLevel.PrintEx(printer); printer.Println();
        printer.Print("writableProperties = "); _WritableProperties.PrintEx(printer); printer.Println();
        printer.Print("generateEquals = "); _GenerateEquals.PrintEx(printer); printer.Println();
        printer.Print("generateToString = "); _GenerateToString.PrintEx(printer); printer.Println();
        printer.Print("findUsagesAfterwards = "); _FindUsagesAfterwards.PrintEx(printer); printer.Println();
        printer.Print("findUsagesEnabled = "); _FindUsagesEnabled.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ApplyChangeSignatureModel : AbstractPage
   {
    //fields
    [NotNull] public List<ChangeSignatureItem> OldItems {get; private set;}
    [NotNull] public List<ChangeSignatureItem> NewItems {get; private set;}
    [NotNull] public List<ChangeSignatureArrows> Arrows {get; private set;}
    
    //primary constructor
    private ApplyChangeSignatureModel(
      [NotNull] List<ChangeSignatureItem> oldItems,
      [NotNull] List<ChangeSignatureItem> newItems,
      [NotNull] List<ChangeSignatureArrows> arrows,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      OldItems = oldItems;
      NewItems = newItems;
      Arrows = arrows;
    }
    //secondary constructor
    public ApplyChangeSignatureModel (
      [NotNull] List<ChangeSignatureItem> OldItems,
      [NotNull] List<ChangeSignatureItem> NewItems,
      [NotNull] List<ChangeSignatureArrows> Arrows,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      OldItems,
      NewItems,
      Arrows,
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<ChangeSignatureItem>> ReadChangeSignatureItemList = ChangeSignatureItem.Read.List();
    public static CtxReadDelegate<List<ChangeSignatureArrows>> ReadChangeSignatureArrowsList = ChangeSignatureArrows.Read.List();
    public static new CtxReadDelegate<ApplyChangeSignatureModel> Read = (ctx, reader) => 
    {
      var oldItems = ReadChangeSignatureItemList(ctx, reader);
      var newItems = ReadChangeSignatureItemList(ctx, reader);
      var arrows = ReadChangeSignatureArrowsList(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new ApplyChangeSignatureModel(oldItems, newItems, arrows, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<ChangeSignatureItem>> WriteChangeSignatureItemList = ChangeSignatureItem.Write.List();
    public static CtxWriteDelegate<List<ChangeSignatureArrows>> WriteChangeSignatureArrowsList = ChangeSignatureArrows.Write.List();
    public static new CtxWriteDelegate<ApplyChangeSignatureModel> Write = (ctx, writer, value) => 
    {
      WriteChangeSignatureItemList(ctx, writer, value.OldItems);
      WriteChangeSignatureItemList(ctx, writer, value.NewItems);
      WriteChangeSignatureArrowsList(ctx, writer, value.Arrows);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      OldItems.BindEx(lifetime, this, "oldItems");
      NewItems.BindEx(lifetime, this, "newItems");
      Arrows.BindEx(lifetime, this, "arrows");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      OldItems.IdentifyEx(ids);
      NewItems.IdentifyEx(ids);
      Arrows.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ApplyChangeSignatureModel (");
      using (printer.IndentCookie()) {
        printer.Print("oldItems = "); OldItems.PrintEx(printer); printer.Println();
        printer.Print("newItems = "); NewItems.PrintEx(printer); printer.Println();
        printer.Print("arrows = "); Arrows.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BulkRenameModel : AbstractPage
   {
    //fields
    [NotNull] public JetBrains.Rider.Model.RdUsageList Occurrences {get; private set;}
    [NotNull] public List<string> NewNames {get; private set;}
    [NotNull] public ISink<int> Include { get { return _Include; }}
    [NotNull] private readonly RdSignal<int> _Include;
    [NotNull] public ISink<int> Exclude { get { return _Exclude; }}
    [NotNull] private readonly RdSignal<int> _Exclude;
    
    //primary constructor
    private BulkRenameModel(
      [NotNull] JetBrains.Rider.Model.RdUsageList occurrences,
      [NotNull] List<string> newNames,
      [NotNull] RdSignal<int> include,
      [NotNull] RdSignal<int> exclude,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      Occurrences = occurrences;
      NewNames = newNames;
      _Include = include;
      _Exclude = exclude;
    }
    //secondary constructor
    public BulkRenameModel (
      [NotNull] JetBrains.Rider.Model.RdUsageList Occurrences,
      [NotNull] List<string> NewNames,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      Occurrences,
      NewNames,
      new RdSignal<int>(),
      new RdSignal<int>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static new CtxReadDelegate<BulkRenameModel> Read = (ctx, reader) => 
    {
      var occurrences = JetBrains.Rider.Model.RdUsageList.Read(ctx, reader);
      var newNames = ReadStringList(ctx, reader);
      var include = RdSignal<int>.Read(ctx, reader);
      var exclude = RdSignal<int>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new BulkRenameModel(occurrences, newNames, include, exclude, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static new CtxWriteDelegate<BulkRenameModel> Write = (ctx, writer, value) => 
    {
      JetBrains.Rider.Model.RdUsageList.Write(ctx, writer, value.Occurrences);
      WriteStringList(ctx, writer, value.NewNames);
      RdSignal<int>.Write(ctx, writer, value._Include);
      RdSignal<int>.Write(ctx, writer, value._Exclude);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Occurrences.BindEx(lifetime, this, "occurrences");
      _Include.BindEx(lifetime, this, "include");
      _Exclude.BindEx(lifetime, this, "exclude");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Occurrences.IdentifyEx(ids);
      _Include.IdentifyEx(ids);
      _Exclude.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BulkRenameModel (");
      using (printer.IndentCookie()) {
        printer.Print("occurrences = "); Occurrences.PrintEx(printer); printer.Println();
        printer.Print("newNames = "); NewNames.PrintEx(printer); printer.Println();
        printer.Print("include = "); _Include.PrintEx(printer); printer.Println();
        printer.Print("exclude = "); _Exclude.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ChangeSignatureArrows : RdBindableBase {
    //fields
    public int From {get; private set;}
    public int To {get; private set;}
    
    //primary constructor
    public ChangeSignatureArrows(
      int from,
      int to
    )
    {
      From = from;
      To = to;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ChangeSignatureArrows> Read = (ctx, reader) => 
    {
      var from = reader.ReadInt();
      var to = reader.ReadInt();
      return new ChangeSignatureArrows(from, to);
    };
    
    public static CtxWriteDelegate<ChangeSignatureArrows> Write = (ctx, writer, value) => 
    {
      writer.Write(value.From);
      writer.Write(value.To);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ChangeSignatureArrows (");
      using (printer.IndentCookie()) {
        printer.Print("from = "); From.PrintEx(printer); printer.Println();
        printer.Print("to = "); To.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ChangeSignatureItem : RdBindableBase {
    //fields
    public ChangeSignatureState State {get; private set;}
    [NotNull] public string Text {get; private set;}
    public bool IsBold {get; private set;}
    public bool IsChanged {get; private set;}
    [NotNull] public List<int> Children {get; private set;}
    
    //primary constructor
    public ChangeSignatureItem(
      ChangeSignatureState state,
      [NotNull] string text,
      bool isBold,
      bool isChanged,
      [NotNull] List<int> children
    )
    {
      State = state;
      Text = text;
      IsBold = isBold;
      IsChanged = isChanged;
      Children = children;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static CtxReadDelegate<ChangeSignatureItem> Read = (ctx, reader) => 
    {
      var state = (ChangeSignatureState)reader.ReadInt();
      var text = reader.ReadString();
      var isBold = reader.ReadBool();
      var isChanged = reader.ReadBool();
      var children = ReadIntList(ctx, reader);
      return new ChangeSignatureItem(state, text, isBold, isChanged, children);
    };
    
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static CtxWriteDelegate<ChangeSignatureItem> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.State);
      writer.Write(value.Text);
      writer.Write(value.IsBold);
      writer.Write(value.IsChanged);
      WriteIntList(ctx, writer, value.Children);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ChangeSignatureItem (");
      using (printer.IndentCookie()) {
        printer.Print("state = "); State.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("isBold = "); IsBold.PrintEx(printer); printer.Println();
        printer.Print("isChanged = "); IsChanged.PrintEx(printer); printer.Println();
        printer.Print("children = "); Children.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ChangeSignatureModifierModel {
    None,
    Ref,
    Out,
    Params,
    Optional
  }
  
  
  public class ChangeSignatureParametersModel : RdBindableBase {
    //fields
    [NotNull] public List<ChangeSignatureSingleParameterModel> Items {get; private set;}
    
    //primary constructor
    public ChangeSignatureParametersModel(
      [NotNull] List<ChangeSignatureSingleParameterModel> items
    )
    {
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<ChangeSignatureSingleParameterModel>> ReadChangeSignatureSingleParameterModelList = ChangeSignatureSingleParameterModel.Read.List();
    public static CtxReadDelegate<ChangeSignatureParametersModel> Read = (ctx, reader) => 
    {
      var items = ReadChangeSignatureSingleParameterModelList(ctx, reader);
      return new ChangeSignatureParametersModel(items);
    };
    
    public static CtxWriteDelegate<List<ChangeSignatureSingleParameterModel>> WriteChangeSignatureSingleParameterModelList = ChangeSignatureSingleParameterModel.Write.List();
    public static CtxWriteDelegate<ChangeSignatureParametersModel> Write = (ctx, writer, value) => 
    {
      WriteChangeSignatureSingleParameterModelList(ctx, writer, value.Items);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Items.BindEx(lifetime, this, "items");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Items.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ChangeSignatureParametersModel (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ChangeSignatureRiderModel : AbstractPage
   {
    //fields
    [NotNull] public IRdProperty<string> NewName { get { return _NewName; }}
    [NotNull] private readonly RdProperty<string> _NewName;
    [NotNull] public IRdProperty<string> ReturnType { get { return _ReturnType; }}
    [NotNull] private readonly RdProperty<string> _ReturnType;
    [NotNull] public IRdProperty<bool> CreateProxy { get { return _CreateProxy; }}
    [NotNull] private readonly RdProperty<bool> _CreateProxy;
    public bool CanChangeName {get; private set;}
    public bool CanChangeType {get; private set;}
    public bool CanChangeParameters {get; private set;}
    public bool CanChangeProxy {get; private set;}
    [NotNull] public string CreateProxyText {get; private set;}
    public bool ModifiersAllowed {get; private set;}
    public bool HadThis {get; private set;}
    [NotNull] public IRdProperty<RefactoringCompletionList> TypeCompletionLists { get { return _TypeCompletionLists; }}
    [NotNull] private readonly RdProperty<RefactoringCompletionList> _TypeCompletionLists;
    [NotNull] public IRdProperty<ChangeSignatureParametersModel> Parameters { get { return _Parameters; }}
    [NotNull] private readonly RdProperty<ChangeSignatureParametersModel> _Parameters;
    [NotNull] public JetBrains.Rider.Model.RdLanguage PreviewLanguage {get; private set;}
    [NotNull] public IRdProperty<string> SignaturePreview { get { return _SignaturePreview; }}
    [NotNull] private readonly RdProperty<string> _SignaturePreview;
    [NotNull] public IVoidSink NewItem { get { return _NewItem; }}
    [NotNull] private readonly RdVoidSignal _NewItem;
    
    //primary constructor
    private ChangeSignatureRiderModel(
      [NotNull] RdProperty<string> newName,
      [NotNull] RdProperty<string> returnType,
      [NotNull] RdProperty<bool> createProxy,
      bool canChangeName,
      bool canChangeType,
      bool canChangeParameters,
      bool canChangeProxy,
      [NotNull] string createProxyText,
      bool modifiersAllowed,
      bool hadThis,
      [NotNull] RdProperty<RefactoringCompletionList> typeCompletionLists,
      [NotNull] RdProperty<ChangeSignatureParametersModel> parameters,
      [NotNull] JetBrains.Rider.Model.RdLanguage previewLanguage,
      [NotNull] RdProperty<string> signaturePreview,
      [NotNull] RdVoidSignal newItem,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      _NewName = newName;
      _ReturnType = returnType;
      _CreateProxy = createProxy;
      CanChangeName = canChangeName;
      CanChangeType = canChangeType;
      CanChangeParameters = canChangeParameters;
      CanChangeProxy = canChangeProxy;
      CreateProxyText = createProxyText;
      ModifiersAllowed = modifiersAllowed;
      HadThis = hadThis;
      _TypeCompletionLists = typeCompletionLists;
      _Parameters = parameters;
      PreviewLanguage = previewLanguage;
      _SignaturePreview = signaturePreview;
      _NewItem = newItem;
      newName.OptimizeNested = true;
      returnType.OptimizeNested = true;
      createProxy.OptimizeNested = true;
      signaturePreview.OptimizeNested = true;
    }
    //secondary constructor
    public ChangeSignatureRiderModel (
      bool CanChangeName,
      bool CanChangeType,
      bool CanChangeParameters,
      bool CanChangeProxy,
      [NotNull] string CreateProxyText,
      bool ModifiersAllowed,
      bool HadThis,
      [NotNull] JetBrains.Rider.Model.RdLanguage PreviewLanguage,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      new RdProperty<string>(),
      new RdProperty<string>(),
      new RdProperty<bool>(),
      CanChangeName,
      CanChangeType,
      CanChangeParameters,
      CanChangeProxy,
      CreateProxyText,
      ModifiersAllowed,
      HadThis,
      new RdProperty<RefactoringCompletionList>(),
      new RdProperty<ChangeSignatureParametersModel>(),
      PreviewLanguage,
      new RdProperty<string>(),
      new RdVoidSignal(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static new CtxReadDelegate<ChangeSignatureRiderModel> Read = (ctx, reader) => 
    {
      var newName = RdProperty<string>.Read(ctx, reader);
      var returnType = RdProperty<string>.Read(ctx, reader);
      var createProxy = RdProperty<bool>.Read(ctx, reader);
      var canChangeName = reader.ReadBool();
      var canChangeType = reader.ReadBool();
      var canChangeParameters = reader.ReadBool();
      var canChangeProxy = reader.ReadBool();
      var createProxyText = reader.ReadString();
      var modifiersAllowed = reader.ReadBool();
      var hadThis = reader.ReadBool();
      var typeCompletionLists = RdProperty<RefactoringCompletionList>.Read(ctx, reader);
      var parameters = RdProperty<ChangeSignatureParametersModel>.Read(ctx, reader);
      var previewLanguage = JetBrains.Rider.Model.RdLanguage.Read(ctx, reader);
      var signaturePreview = RdProperty<string>.Read(ctx, reader);
      var newItem = RdVoidSignal.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new ChangeSignatureRiderModel(newName, returnType, createProxy, canChangeName, canChangeType, canChangeParameters, canChangeProxy, createProxyText, modifiersAllowed, hadThis, typeCompletionLists, parameters, previewLanguage, signaturePreview, newItem, title, description, continueEnabled, validationResult);
    };
    
    public static new CtxWriteDelegate<ChangeSignatureRiderModel> Write = (ctx, writer, value) => 
    {
      RdProperty<string>.Write(ctx, writer, value._NewName);
      RdProperty<string>.Write(ctx, writer, value._ReturnType);
      RdProperty<bool>.Write(ctx, writer, value._CreateProxy);
      writer.Write(value.CanChangeName);
      writer.Write(value.CanChangeType);
      writer.Write(value.CanChangeParameters);
      writer.Write(value.CanChangeProxy);
      writer.Write(value.CreateProxyText);
      writer.Write(value.ModifiersAllowed);
      writer.Write(value.HadThis);
      RdProperty<RefactoringCompletionList>.Write(ctx, writer, value._TypeCompletionLists);
      RdProperty<ChangeSignatureParametersModel>.Write(ctx, writer, value._Parameters);
      JetBrains.Rider.Model.RdLanguage.Write(ctx, writer, value.PreviewLanguage);
      RdProperty<string>.Write(ctx, writer, value._SignaturePreview);
      RdVoidSignal.Write(ctx, writer, value._NewItem);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _NewName.BindEx(lifetime, this, "newName");
      _ReturnType.BindEx(lifetime, this, "returnType");
      _CreateProxy.BindEx(lifetime, this, "createProxy");
      _TypeCompletionLists.BindEx(lifetime, this, "typeCompletionLists");
      _Parameters.BindEx(lifetime, this, "parameters");
      _SignaturePreview.BindEx(lifetime, this, "signaturePreview");
      _NewItem.BindEx(lifetime, this, "newItem");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _NewName.IdentifyEx(ids);
      _ReturnType.IdentifyEx(ids);
      _CreateProxy.IdentifyEx(ids);
      _TypeCompletionLists.IdentifyEx(ids);
      _Parameters.IdentifyEx(ids);
      _SignaturePreview.IdentifyEx(ids);
      _NewItem.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ChangeSignatureRiderModel (");
      using (printer.IndentCookie()) {
        printer.Print("newName = "); _NewName.PrintEx(printer); printer.Println();
        printer.Print("returnType = "); _ReturnType.PrintEx(printer); printer.Println();
        printer.Print("createProxy = "); _CreateProxy.PrintEx(printer); printer.Println();
        printer.Print("canChangeName = "); CanChangeName.PrintEx(printer); printer.Println();
        printer.Print("canChangeType = "); CanChangeType.PrintEx(printer); printer.Println();
        printer.Print("canChangeParameters = "); CanChangeParameters.PrintEx(printer); printer.Println();
        printer.Print("canChangeProxy = "); CanChangeProxy.PrintEx(printer); printer.Println();
        printer.Print("createProxyText = "); CreateProxyText.PrintEx(printer); printer.Println();
        printer.Print("modifiersAllowed = "); ModifiersAllowed.PrintEx(printer); printer.Println();
        printer.Print("hadThis = "); HadThis.PrintEx(printer); printer.Println();
        printer.Print("typeCompletionLists = "); _TypeCompletionLists.PrintEx(printer); printer.Println();
        printer.Print("parameters = "); _Parameters.PrintEx(printer); printer.Println();
        printer.Print("previewLanguage = "); PreviewLanguage.PrintEx(printer); printer.Println();
        printer.Print("signaturePreview = "); _SignaturePreview.PrintEx(printer); printer.Println();
        printer.Print("newItem = "); _NewItem.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ChangeSignatureSingleParameterModel : RdBindableBase {
    //fields
    public bool Removable {get; private set;}
    public bool CanMoveUp {get; private set;}
    public bool CanMoveDown {get; private set;}
    [NotNull] public IRdProperty<string> TypeName { get { return _TypeName; }}
    [NotNull] private readonly RdProperty<string> _TypeName;
    [NotNull] public IRdProperty<string> ParameterName { get { return _ParameterName; }}
    [NotNull] private readonly RdProperty<string> _ParameterName;
    [NotNull] public IRdProperty<ChangeSignatureModifierModel> Modifier { get { return _Modifier; }}
    [NotNull] private readonly RdProperty<ChangeSignatureModifierModel> _Modifier;
    [NotNull] public IVoidSink MoveUp { get { return _MoveUp; }}
    [NotNull] private readonly RdVoidSignal _MoveUp;
    [NotNull] public IVoidSink MoveDown { get { return _MoveDown; }}
    [NotNull] private readonly RdVoidSignal _MoveDown;
    [NotNull] public IVoidSink RemoveItem { get { return _RemoveItem; }}
    [NotNull] private readonly RdVoidSignal _RemoveItem;
    
    //primary constructor
    private ChangeSignatureSingleParameterModel(
      bool removable,
      bool canMoveUp,
      bool canMoveDown,
      [NotNull] RdProperty<string> typeName,
      [NotNull] RdProperty<string> parameterName,
      [NotNull] RdProperty<ChangeSignatureModifierModel> modifier,
      [NotNull] RdVoidSignal moveUp,
      [NotNull] RdVoidSignal moveDown,
      [NotNull] RdVoidSignal removeItem
    )
    {
      Removable = removable;
      CanMoveUp = canMoveUp;
      CanMoveDown = canMoveDown;
      _TypeName = typeName;
      _ParameterName = parameterName;
      _Modifier = modifier;
      _MoveUp = moveUp;
      _MoveDown = moveDown;
      _RemoveItem = removeItem;
      typeName.OptimizeNested = true;
      parameterName.OptimizeNested = true;
      modifier.OptimizeNested = true;
    }
    //secondary constructor
    public ChangeSignatureSingleParameterModel (
      bool Removable,
      bool CanMoveUp,
      bool CanMoveDown
    ) : this (
      Removable,
      CanMoveUp,
      CanMoveDown,
      new RdProperty<string>(),
      new RdProperty<string>(),
      new RdProperty<ChangeSignatureModifierModel>(),
      new RdVoidSignal(),
      new RdVoidSignal(),
      new RdVoidSignal()
    ) {}
    //statics
    
    public static CtxReadDelegate<ChangeSignatureModifierModel> ReadChangeSignatureModifierModel = new CtxReadDelegate<ChangeSignatureModifierModel>(Serializers.ReadEnum<ChangeSignatureModifierModel>);
    public static CtxReadDelegate<ChangeSignatureSingleParameterModel> Read = (ctx, reader) => 
    {
      var removable = reader.ReadBool();
      var canMoveUp = reader.ReadBool();
      var canMoveDown = reader.ReadBool();
      var typeName = RdProperty<string>.Read(ctx, reader);
      var parameterName = RdProperty<string>.Read(ctx, reader);
      var modifier = RdProperty<ChangeSignatureModifierModel>.Read(ctx, reader);
      var moveUp = RdVoidSignal.Read(ctx, reader);
      var moveDown = RdVoidSignal.Read(ctx, reader);
      var removeItem = RdVoidSignal.Read(ctx, reader);
      return new ChangeSignatureSingleParameterModel(removable, canMoveUp, canMoveDown, typeName, parameterName, modifier, moveUp, moveDown, removeItem);
    };
    
    public static CtxWriteDelegate<ChangeSignatureModifierModel> WriteChangeSignatureModifierModel = new CtxWriteDelegate<ChangeSignatureModifierModel>(Serializers.WriteEnum<ChangeSignatureModifierModel>);
    public static CtxWriteDelegate<ChangeSignatureSingleParameterModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Removable);
      writer.Write(value.CanMoveUp);
      writer.Write(value.CanMoveDown);
      RdProperty<string>.Write(ctx, writer, value._TypeName);
      RdProperty<string>.Write(ctx, writer, value._ParameterName);
      RdProperty<ChangeSignatureModifierModel>.Write(ctx, writer, value._Modifier);
      RdVoidSignal.Write(ctx, writer, value._MoveUp);
      RdVoidSignal.Write(ctx, writer, value._MoveDown);
      RdVoidSignal.Write(ctx, writer, value._RemoveItem);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _TypeName.BindEx(lifetime, this, "typeName");
      _ParameterName.BindEx(lifetime, this, "parameterName");
      _Modifier.BindEx(lifetime, this, "modifier");
      _MoveUp.BindEx(lifetime, this, "moveUp");
      _MoveDown.BindEx(lifetime, this, "moveDown");
      _RemoveItem.BindEx(lifetime, this, "removeItem");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _TypeName.IdentifyEx(ids);
      _ParameterName.IdentifyEx(ids);
      _Modifier.IdentifyEx(ids);
      _MoveUp.IdentifyEx(ids);
      _MoveDown.IdentifyEx(ids);
      _RemoveItem.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ChangeSignatureSingleParameterModel (");
      using (printer.IndentCookie()) {
        printer.Print("removable = "); Removable.PrintEx(printer); printer.Println();
        printer.Print("canMoveUp = "); CanMoveUp.PrintEx(printer); printer.Println();
        printer.Print("canMoveDown = "); CanMoveDown.PrintEx(printer); printer.Println();
        printer.Print("typeName = "); _TypeName.PrintEx(printer); printer.Println();
        printer.Print("parameterName = "); _ParameterName.PrintEx(printer); printer.Println();
        printer.Print("modifier = "); _Modifier.PrintEx(printer); printer.Println();
        printer.Print("moveUp = "); _MoveUp.PrintEx(printer); printer.Println();
        printer.Print("moveDown = "); _MoveDown.PrintEx(printer); printer.Println();
        printer.Print("removeItem = "); _RemoveItem.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ChangeSignatureState {
    Normal,
    Added,
    Removed
  }
  
  
  public enum CheckboxState {
    Checked,
    Unchecked,
    PartiallyChecked
  }
  
  
  public class Conflict : RdBindableBase {
    //fields
    [NotNull] public List<ConflictTextFragment> TextFragments {get; private set;}
    public bool IsError {get; private set;}
    
    //primary constructor
    public Conflict(
      [NotNull] List<ConflictTextFragment> textFragments,
      bool isError
    )
    {
      TextFragments = textFragments;
      IsError = isError;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<ConflictTextFragment>> ReadConflictTextFragmentList = ConflictTextFragment.Read.List();
    public static CtxReadDelegate<Conflict> Read = (ctx, reader) => 
    {
      var textFragments = ReadConflictTextFragmentList(ctx, reader);
      var isError = reader.ReadBool();
      return new Conflict(textFragments, isError);
    };
    
    public static CtxWriteDelegate<List<ConflictTextFragment>> WriteConflictTextFragmentList = ConflictTextFragment.Write.List();
    public static CtxWriteDelegate<Conflict> Write = (ctx, writer, value) => 
    {
      WriteConflictTextFragmentList(ctx, writer, value.TextFragments);
      writer.Write(value.IsError);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      TextFragments.BindEx(lifetime, this, "textFragments");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      TextFragments.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("Conflict (");
      using (printer.IndentCookie()) {
        printer.Print("textFragments = "); TextFragments.PrintEx(printer); printer.Println();
        printer.Print("isError = "); IsError.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ConflictList : RdBindableBase {
    //fields
    [NotNull] public List<Conflict> List {get; private set;}
    
    //primary constructor
    public ConflictList(
      [NotNull] List<Conflict> list
    )
    {
      List = list;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<Conflict>> ReadConflictList = Conflict.Read.List();
    public static CtxReadDelegate<ConflictList> Read = (ctx, reader) => 
    {
      var list = ReadConflictList(ctx, reader);
      return new ConflictList(list);
    };
    
    public static CtxWriteDelegate<List<Conflict>> WriteConflictList = Conflict.Write.List();
    public static CtxWriteDelegate<ConflictList> Write = (ctx, writer, value) => 
    {
      WriteConflictList(ctx, writer, value.List);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      List.BindEx(lifetime, this, "list");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      List.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ConflictList (");
      using (printer.IndentCookie()) {
        printer.Print("list = "); List.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ConflictTextFragment : RdBindableBase {
    //fields
    [NotNull] public string Text {get; private set;}
    public bool IsClickable {get; private set;}
    
    //primary constructor
    public ConflictTextFragment(
      [NotNull] string text,
      bool isClickable
    )
    {
      Text = text;
      IsClickable = isClickable;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ConflictTextFragment> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      var isClickable = reader.ReadBool();
      return new ConflictTextFragment(text, isClickable);
    };
    
    public static CtxWriteDelegate<ConflictTextFragment> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
      writer.Write(value.IsClickable);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ConflictTextFragment (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("isClickable = "); IsClickable.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ConflictsPageModel : AbstractPage
   {
    //fields
    [NotNull] public IRdProperty<ConflictList> Conflicts { get { return _Conflicts; }}
    [NotNull] private readonly RdProperty<ConflictList> _Conflicts;
    [NotNull] public ISink<LinkInfo> NavigateLink { get { return _NavigateLink; }}
    [NotNull] private readonly RdSignal<LinkInfo> _NavigateLink;
    [NotNull] public IVoidSink Refresh { get { return _Refresh; }}
    [NotNull] private readonly RdVoidSignal _Refresh;
    
    //primary constructor
    private ConflictsPageModel(
      [NotNull] RdProperty<ConflictList> conflicts,
      [NotNull] RdSignal<LinkInfo> navigateLink,
      [NotNull] RdVoidSignal refresh,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      _Conflicts = conflicts;
      _NavigateLink = navigateLink;
      _Refresh = refresh;
    }
    //secondary constructor
    public ConflictsPageModel (
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      new RdProperty<ConflictList>(),
      new RdSignal<LinkInfo>(),
      new RdVoidSignal(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static new CtxReadDelegate<ConflictsPageModel> Read = (ctx, reader) => 
    {
      var conflicts = RdProperty<ConflictList>.Read(ctx, reader);
      var navigateLink = RdSignal<LinkInfo>.Read(ctx, reader);
      var refresh = RdVoidSignal.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new ConflictsPageModel(conflicts, navigateLink, refresh, title, description, continueEnabled, validationResult);
    };
    
    public static new CtxWriteDelegate<ConflictsPageModel> Write = (ctx, writer, value) => 
    {
      RdProperty<ConflictList>.Write(ctx, writer, value._Conflicts);
      RdSignal<LinkInfo>.Write(ctx, writer, value._NavigateLink);
      RdVoidSignal.Write(ctx, writer, value._Refresh);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Conflicts.BindEx(lifetime, this, "conflicts");
      _NavigateLink.BindEx(lifetime, this, "navigateLink");
      _Refresh.BindEx(lifetime, this, "refresh");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Conflicts.IdentifyEx(ids);
      _NavigateLink.IdentifyEx(ids);
      _Refresh.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ConflictsPageModel (");
      using (printer.IndentCookie()) {
        printer.Print("conflicts = "); _Conflicts.PrintEx(printer); printer.Println();
        printer.Print("navigateLink = "); _NavigateLink.PrintEx(printer); printer.Println();
        printer.Print("refresh = "); _Refresh.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ConstructorToFactoryModel : AbstractPage
   {
    //fields
    [NotNull] public IRdProperty<string> FactoryName { get { return _FactoryName; }}
    [NotNull] private readonly RdProperty<string> _FactoryName;
    [NotNull] public IRdProperty<string> FactoryClass { get { return _FactoryClass; }}
    [NotNull] private readonly RdProperty<string> _FactoryClass;
    [NotNull] public List<string> PossibleFactoryNames {get; private set;}
    [NotNull] public IRdProperty<RefactoringCompletionList> FactoryClassCompletion { get { return _FactoryClassCompletion; }}
    [NotNull] private readonly RdProperty<RefactoringCompletionList> _FactoryClassCompletion;
    
    //primary constructor
    private ConstructorToFactoryModel(
      [NotNull] RdProperty<string> factoryName,
      [NotNull] RdProperty<string> factoryClass,
      [NotNull] List<string> possibleFactoryNames,
      [NotNull] RdProperty<RefactoringCompletionList> factoryClassCompletion,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      _FactoryName = factoryName;
      _FactoryClass = factoryClass;
      PossibleFactoryNames = possibleFactoryNames;
      _FactoryClassCompletion = factoryClassCompletion;
      factoryName.OptimizeNested = true;
      factoryClass.OptimizeNested = true;
    }
    //secondary constructor
    public ConstructorToFactoryModel (
      [NotNull] List<string> PossibleFactoryNames,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      new RdProperty<string>(),
      new RdProperty<string>(),
      PossibleFactoryNames,
      new RdProperty<RefactoringCompletionList>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static new CtxReadDelegate<ConstructorToFactoryModel> Read = (ctx, reader) => 
    {
      var factoryName = RdProperty<string>.Read(ctx, reader);
      var factoryClass = RdProperty<string>.Read(ctx, reader);
      var possibleFactoryNames = ReadStringList(ctx, reader);
      var factoryClassCompletion = RdProperty<RefactoringCompletionList>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new ConstructorToFactoryModel(factoryName, factoryClass, possibleFactoryNames, factoryClassCompletion, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static new CtxWriteDelegate<ConstructorToFactoryModel> Write = (ctx, writer, value) => 
    {
      RdProperty<string>.Write(ctx, writer, value._FactoryName);
      RdProperty<string>.Write(ctx, writer, value._FactoryClass);
      WriteStringList(ctx, writer, value.PossibleFactoryNames);
      RdProperty<RefactoringCompletionList>.Write(ctx, writer, value._FactoryClassCompletion);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _FactoryName.BindEx(lifetime, this, "factoryName");
      _FactoryClass.BindEx(lifetime, this, "factoryClass");
      _FactoryClassCompletion.BindEx(lifetime, this, "factoryClassCompletion");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _FactoryName.IdentifyEx(ids);
      _FactoryClass.IdentifyEx(ids);
      _FactoryClassCompletion.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ConstructorToFactoryModel (");
      using (printer.IndentCookie()) {
        printer.Print("factoryName = "); _FactoryName.PrintEx(printer); printer.Println();
        printer.Print("factoryClass = "); _FactoryClass.PrintEx(printer); printer.Println();
        printer.Print("possibleFactoryNames = "); PossibleFactoryNames.PrintEx(printer); printer.Println();
        printer.Print("factoryClassCompletion = "); _FactoryClassCompletion.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CopyTypeModel : AbstractPage
   {
    //fields
    [NotNull] public string TitleLabelText {get; private set;}
    [NotNull] public string NamespaceTitle {get; private set;}
    [NotNull] public IRdProperty<string> NewTypeName { get { return _NewTypeName; }}
    [NotNull] private readonly RdProperty<string> _NewTypeName;
    [NotNull] public IRdProperty<string> NewNamespaceName { get { return _NewNamespaceName; }}
    [NotNull] private readonly RdProperty<string> _NewNamespaceName;
    [NotNull] public IRdProperty<RefactoringCompletionList> CompletionList { get { return _CompletionList; }}
    [NotNull] private readonly RdProperty<RefactoringCompletionList> _CompletionList;
    
    //primary constructor
    private CopyTypeModel(
      [NotNull] string titleLabelText,
      [NotNull] string namespaceTitle,
      [NotNull] RdProperty<string> newTypeName,
      [NotNull] RdProperty<string> newNamespaceName,
      [NotNull] RdProperty<RefactoringCompletionList> completionList,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      TitleLabelText = titleLabelText;
      NamespaceTitle = namespaceTitle;
      _NewTypeName = newTypeName;
      _NewNamespaceName = newNamespaceName;
      _CompletionList = completionList;
      newTypeName.OptimizeNested = true;
      newNamespaceName.OptimizeNested = true;
    }
    //secondary constructor
    public CopyTypeModel (
      [NotNull] string TitleLabelText,
      [NotNull] string NamespaceTitle,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      TitleLabelText,
      NamespaceTitle,
      new RdProperty<string>(),
      new RdProperty<string>(),
      new RdProperty<RefactoringCompletionList>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static new CtxReadDelegate<CopyTypeModel> Read = (ctx, reader) => 
    {
      var titleLabelText = reader.ReadString();
      var namespaceTitle = reader.ReadString();
      var newTypeName = RdProperty<string>.Read(ctx, reader);
      var newNamespaceName = RdProperty<string>.Read(ctx, reader);
      var completionList = RdProperty<RefactoringCompletionList>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new CopyTypeModel(titleLabelText, namespaceTitle, newTypeName, newNamespaceName, completionList, title, description, continueEnabled, validationResult);
    };
    
    public static new CtxWriteDelegate<CopyTypeModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.TitleLabelText);
      writer.Write(value.NamespaceTitle);
      RdProperty<string>.Write(ctx, writer, value._NewTypeName);
      RdProperty<string>.Write(ctx, writer, value._NewNamespaceName);
      RdProperty<RefactoringCompletionList>.Write(ctx, writer, value._CompletionList);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _NewTypeName.BindEx(lifetime, this, "newTypeName");
      _NewNamespaceName.BindEx(lifetime, this, "newNamespaceName");
      _CompletionList.BindEx(lifetime, this, "completionList");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _NewTypeName.IdentifyEx(ids);
      _NewNamespaceName.IdentifyEx(ids);
      _CompletionList.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CopyTypeModel (");
      using (printer.IndentCookie()) {
        printer.Print("titleLabelText = "); TitleLabelText.PrintEx(printer); printer.Println();
        printer.Print("namespaceTitle = "); NamespaceTitle.PrintEx(printer); printer.Println();
        printer.Print("newTypeName = "); _NewTypeName.PrintEx(printer); printer.Println();
        printer.Print("newNamespaceName = "); _NewNamespaceName.PrintEx(printer); printer.Println();
        printer.Print("completionList = "); _CompletionList.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum DefaultParameterSelection {
    NonCompilable,
    DefaultValue,
    UniqueValue,
    CreateLocal,
    SpecifyValue,
    ResolveByTool
  }
  
  
  public class DefaultParameterValueModel : AbstractPage
   {
    //fields
    [NotNull] public IRdProperty<DefaultParameterSelection> Selection { get { return _Selection; }}
    [NotNull] private readonly RdProperty<DefaultParameterSelection> _Selection;
    public bool IsUniqueVisible {get; private set;}
    public bool IsLocalVisible {get; private set;}
    public bool IsDefaultVisible {get; private set;}
    [NotNull] public string UniqueValueText {get; private set;}
    [NotNull] public string DefaultLabelText {get; private set;}
    [NotNull] public IRdProperty<string> SpecifyValueText { get { return _SpecifyValueText; }}
    [NotNull] private readonly RdProperty<string> _SpecifyValueText;
    
    //primary constructor
    private DefaultParameterValueModel(
      [NotNull] RdProperty<DefaultParameterSelection> selection,
      bool isUniqueVisible,
      bool isLocalVisible,
      bool isDefaultVisible,
      [NotNull] string uniqueValueText,
      [NotNull] string defaultLabelText,
      [NotNull] RdProperty<string> specifyValueText,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      _Selection = selection;
      IsUniqueVisible = isUniqueVisible;
      IsLocalVisible = isLocalVisible;
      IsDefaultVisible = isDefaultVisible;
      UniqueValueText = uniqueValueText;
      DefaultLabelText = defaultLabelText;
      _SpecifyValueText = specifyValueText;
      selection.OptimizeNested = true;
      specifyValueText.OptimizeNested = true;
    }
    //secondary constructor
    public DefaultParameterValueModel (
      bool IsUniqueVisible,
      bool IsLocalVisible,
      bool IsDefaultVisible,
      [NotNull] string UniqueValueText,
      [NotNull] string DefaultLabelText,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      new RdProperty<DefaultParameterSelection>(),
      IsUniqueVisible,
      IsLocalVisible,
      IsDefaultVisible,
      UniqueValueText,
      DefaultLabelText,
      new RdProperty<string>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<DefaultParameterSelection> ReadDefaultParameterSelection = new CtxReadDelegate<DefaultParameterSelection>(Serializers.ReadEnum<DefaultParameterSelection>);
    public static new CtxReadDelegate<DefaultParameterValueModel> Read = (ctx, reader) => 
    {
      var selection = RdProperty<DefaultParameterSelection>.Read(ctx, reader);
      var isUniqueVisible = reader.ReadBool();
      var isLocalVisible = reader.ReadBool();
      var isDefaultVisible = reader.ReadBool();
      var uniqueValueText = reader.ReadString();
      var defaultLabelText = reader.ReadString();
      var specifyValueText = RdProperty<string>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new DefaultParameterValueModel(selection, isUniqueVisible, isLocalVisible, isDefaultVisible, uniqueValueText, defaultLabelText, specifyValueText, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<DefaultParameterSelection> WriteDefaultParameterSelection = new CtxWriteDelegate<DefaultParameterSelection>(Serializers.WriteEnum<DefaultParameterSelection>);
    public static new CtxWriteDelegate<DefaultParameterValueModel> Write = (ctx, writer, value) => 
    {
      RdProperty<DefaultParameterSelection>.Write(ctx, writer, value._Selection);
      writer.Write(value.IsUniqueVisible);
      writer.Write(value.IsLocalVisible);
      writer.Write(value.IsDefaultVisible);
      writer.Write(value.UniqueValueText);
      writer.Write(value.DefaultLabelText);
      RdProperty<string>.Write(ctx, writer, value._SpecifyValueText);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Selection.BindEx(lifetime, this, "selection");
      _SpecifyValueText.BindEx(lifetime, this, "specifyValueText");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Selection.IdentifyEx(ids);
      _SpecifyValueText.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DefaultParameterValueModel (");
      using (printer.IndentCookie()) {
        printer.Print("selection = "); _Selection.PrintEx(printer); printer.Println();
        printer.Print("isUniqueVisible = "); IsUniqueVisible.PrintEx(printer); printer.Println();
        printer.Print("isLocalVisible = "); IsLocalVisible.PrintEx(printer); printer.Println();
        printer.Print("isDefaultVisible = "); IsDefaultVisible.PrintEx(printer); printer.Println();
        printer.Print("uniqueValueText = "); UniqueValueText.PrintEx(printer); printer.Println();
        printer.Print("defaultLabelText = "); DefaultLabelText.PrintEx(printer); printer.Println();
        printer.Print("specifyValueText = "); _SpecifyValueText.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DerivedRenameChange : RdBindableBase {
    //fields
    [NotNull] public string OldName {get; private set;}
    [NotNull] public IRdProperty<string> NewName { get { return _NewName; }}
    [NotNull] private readonly RdProperty<string> _NewName;
    [NotNull] public IRdProperty<bool> Enabled { get { return _Enabled; }}
    [NotNull] private readonly RdProperty<bool> _Enabled;
    [NotNull] public IVoidSink Navigate { get { return _Navigate; }}
    [NotNull] private readonly RdVoidSignal _Navigate;
    [NotNull] public List<DerivedRenameElement> Elements {get; private set;}
    
    //primary constructor
    private DerivedRenameChange(
      [NotNull] string oldName,
      [NotNull] RdProperty<string> newName,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdVoidSignal navigate,
      [NotNull] List<DerivedRenameElement> elements
    )
    {
      OldName = oldName;
      _NewName = newName;
      _Enabled = enabled;
      _Navigate = navigate;
      Elements = elements;
      newName.OptimizeNested = true;
      enabled.OptimizeNested = true;
    }
    //secondary constructor
    public DerivedRenameChange (
      [NotNull] string OldName,
      [NotNull] List<DerivedRenameElement> Elements
    ) : this (
      OldName,
      new RdProperty<string>(),
      new RdProperty<bool>(),
      new RdVoidSignal(),
      Elements
    ) {}
    //statics
    
    public static CtxReadDelegate<List<DerivedRenameElement>> ReadDerivedRenameElementList = DerivedRenameElement.Read.List();
    public static CtxReadDelegate<DerivedRenameChange> Read = (ctx, reader) => 
    {
      var oldName = reader.ReadString();
      var newName = RdProperty<string>.Read(ctx, reader);
      var enabled = RdProperty<bool>.Read(ctx, reader);
      var navigate = RdVoidSignal.Read(ctx, reader);
      var elements = ReadDerivedRenameElementList(ctx, reader);
      return new DerivedRenameChange(oldName, newName, enabled, navigate, elements);
    };
    
    public static CtxWriteDelegate<List<DerivedRenameElement>> WriteDerivedRenameElementList = DerivedRenameElement.Write.List();
    public static CtxWriteDelegate<DerivedRenameChange> Write = (ctx, writer, value) => 
    {
      writer.Write(value.OldName);
      RdProperty<string>.Write(ctx, writer, value._NewName);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdVoidSignal.Write(ctx, writer, value._Navigate);
      WriteDerivedRenameElementList(ctx, writer, value.Elements);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _NewName.BindEx(lifetime, this, "newName");
      _Enabled.BindEx(lifetime, this, "enabled");
      _Navigate.BindEx(lifetime, this, "navigate");
      Elements.BindEx(lifetime, this, "elements");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _NewName.IdentifyEx(ids);
      _Enabled.IdentifyEx(ids);
      _Navigate.IdentifyEx(ids);
      Elements.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DerivedRenameChange (");
      using (printer.IndentCookie()) {
        printer.Print("oldName = "); OldName.PrintEx(printer); printer.Println();
        printer.Print("newName = "); _NewName.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
        printer.Print("elements = "); Elements.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DerivedRenameElement : RdBindableBase {
    //fields
    [NotNull] public string ElementName {get; private set;}
    [NotNull] public IRdProperty<bool> Enabled { get { return _Enabled; }}
    [NotNull] private readonly RdProperty<bool> _Enabled;
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public IVoidSink Navigate { get { return _Navigate; }}
    [NotNull] private readonly RdVoidSignal _Navigate;
    
    //primary constructor
    private DerivedRenameElement(
      [NotNull] string elementName,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdVoidSignal navigate
    )
    {
      ElementName = elementName;
      _Enabled = enabled;
      Icon = icon;
      _Navigate = navigate;
      enabled.OptimizeNested = true;
    }
    //secondary constructor
    public DerivedRenameElement (
      [NotNull] string ElementName,
      [NotNull] JetBrains.Rider.Model.Icon Icon
    ) : this (
      ElementName,
      new RdProperty<bool>(),
      Icon,
      new RdVoidSignal()
    ) {}
    //statics
    
    public static CtxReadDelegate<DerivedRenameElement> Read = (ctx, reader) => 
    {
      var elementName = reader.ReadString();
      var enabled = RdProperty<bool>.Read(ctx, reader);
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var navigate = RdVoidSignal.Read(ctx, reader);
      return new DerivedRenameElement(elementName, enabled, icon, navigate);
    };
    
    public static CtxWriteDelegate<DerivedRenameElement> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ElementName);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      RdVoidSignal.Write(ctx, writer, value._Navigate);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Enabled.BindEx(lifetime, this, "enabled");
      _Navigate.BindEx(lifetime, this, "navigate");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Enabled.IdentifyEx(ids);
      _Navigate.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DerivedRenameElement (");
      using (printer.IndentCookie()) {
        printer.Print("elementName = "); ElementName.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DerivedRenamePageModel : AbstractPage
   {
    //fields
    [NotNull] public List<DerivedRenameChange> Changes {get; private set;}
    [NotNull] public IRdProperty<bool> GlobalEnabled { get { return _GlobalEnabled; }}
    [NotNull] private readonly RdProperty<bool> _GlobalEnabled;
    
    //primary constructor
    private DerivedRenamePageModel(
      [NotNull] List<DerivedRenameChange> changes,
      [NotNull] RdProperty<bool> globalEnabled,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      Changes = changes;
      _GlobalEnabled = globalEnabled;
      globalEnabled.OptimizeNested = true;
    }
    //secondary constructor
    public DerivedRenamePageModel (
      [NotNull] List<DerivedRenameChange> Changes,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      Changes,
      new RdProperty<bool>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<DerivedRenameChange>> ReadDerivedRenameChangeList = DerivedRenameChange.Read.List();
    public static new CtxReadDelegate<DerivedRenamePageModel> Read = (ctx, reader) => 
    {
      var changes = ReadDerivedRenameChangeList(ctx, reader);
      var globalEnabled = RdProperty<bool>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new DerivedRenamePageModel(changes, globalEnabled, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<DerivedRenameChange>> WriteDerivedRenameChangeList = DerivedRenameChange.Write.List();
    public static new CtxWriteDelegate<DerivedRenamePageModel> Write = (ctx, writer, value) => 
    {
      WriteDerivedRenameChangeList(ctx, writer, value.Changes);
      RdProperty<bool>.Write(ctx, writer, value._GlobalEnabled);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Changes.BindEx(lifetime, this, "changes");
      _GlobalEnabled.BindEx(lifetime, this, "globalEnabled");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Changes.IdentifyEx(ids);
      _GlobalEnabled.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DerivedRenamePageModel (");
      using (printer.IndentCookie()) {
        printer.Print("changes = "); Changes.PrintEx(printer); printer.Println();
        printer.Print("globalEnabled = "); _GlobalEnabled.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EmptyPage : AbstractPage
   {
    //fields
    //primary constructor
    private EmptyPage(
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
    }
    //secondary constructor
    public EmptyPage (
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static new CtxReadDelegate<EmptyPage> Read = (ctx, reader) => 
    {
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new EmptyPage(title, description, continueEnabled, validationResult);
    };
    
    public static new CtxWriteDelegate<EmptyPage> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("EmptyPage (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EncapsulateFieldModel : AbstractPage
   {
    //fields
    [NotNull] public List<TextWithIconModel> ExistingProperties {get; private set;}
    [NotNull] public List<string> AvailableAccessRights {get; private set;}
    [NotNull] public IRdProperty<int> SelectedExistingListItem { get { return _SelectedExistingListItem; }}
    [NotNull] private readonly RdProperty<int> _SelectedExistingListItem;
    [NotNull] public IRdProperty<int> SelectedAccessRights { get { return _SelectedAccessRights; }}
    [NotNull] private readonly RdProperty<int> _SelectedAccessRights;
    [NotNull] public IRdProperty<string> NewName { get { return _NewName; }}
    [NotNull] private readonly RdProperty<string> _NewName;
    [NotNull] public IRdProperty<bool> ToAuto { get { return _ToAuto; }}
    [NotNull] private readonly RdProperty<bool> _ToAuto;
    [NotNull] public IRdProperty<bool> TransformReads { get { return _TransformReads; }}
    [NotNull] private readonly RdProperty<bool> _TransformReads;
    [NotNull] public IRdProperty<bool> TransformWrites { get { return _TransformWrites; }}
    [NotNull] private readonly RdProperty<bool> _TransformWrites;
    [NotNull] public IRdProperty<bool> UpdateLocalUsages { get { return _UpdateLocalUsages; }}
    [NotNull] private readonly RdProperty<bool> _UpdateLocalUsages;
    [NotNull] public IRdProperty<bool> MakeFieldPrivate { get { return _MakeFieldPrivate; }}
    [NotNull] private readonly RdProperty<bool> _MakeFieldPrivate;
    [NotNull] public IRdProperty<bool> TextFieldEnabled { get { return _TextFieldEnabled; }}
    [NotNull] private readonly RdProperty<bool> _TextFieldEnabled;
    [NotNull] public IRdProperty<bool> AutoEnabled { get { return _AutoEnabled; }}
    [NotNull] private readonly RdProperty<bool> _AutoEnabled;
    [NotNull] public IRdProperty<bool> ReadEnabled { get { return _ReadEnabled; }}
    [NotNull] private readonly RdProperty<bool> _ReadEnabled;
    [NotNull] public IRdProperty<bool> WriteEnabled { get { return _WriteEnabled; }}
    [NotNull] private readonly RdProperty<bool> _WriteEnabled;
    [NotNull] public IRdProperty<bool> LocalUsagesEnabled { get { return _LocalUsagesEnabled; }}
    [NotNull] private readonly RdProperty<bool> _LocalUsagesEnabled;
    [NotNull] public IRdProperty<bool> MakePrivateEnabled { get { return _MakePrivateEnabled; }}
    [NotNull] private readonly RdProperty<bool> _MakePrivateEnabled;
    
    //primary constructor
    private EncapsulateFieldModel(
      [NotNull] List<TextWithIconModel> existingProperties,
      [NotNull] List<string> availableAccessRights,
      [NotNull] RdProperty<int> selectedExistingListItem,
      [NotNull] RdProperty<int> selectedAccessRights,
      [NotNull] RdProperty<string> newName,
      [NotNull] RdProperty<bool> toAuto,
      [NotNull] RdProperty<bool> transformReads,
      [NotNull] RdProperty<bool> transformWrites,
      [NotNull] RdProperty<bool> updateLocalUsages,
      [NotNull] RdProperty<bool> makeFieldPrivate,
      [NotNull] RdProperty<bool> textFieldEnabled,
      [NotNull] RdProperty<bool> autoEnabled,
      [NotNull] RdProperty<bool> readEnabled,
      [NotNull] RdProperty<bool> writeEnabled,
      [NotNull] RdProperty<bool> localUsagesEnabled,
      [NotNull] RdProperty<bool> makePrivateEnabled,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      ExistingProperties = existingProperties;
      AvailableAccessRights = availableAccessRights;
      _SelectedExistingListItem = selectedExistingListItem;
      _SelectedAccessRights = selectedAccessRights;
      _NewName = newName;
      _ToAuto = toAuto;
      _TransformReads = transformReads;
      _TransformWrites = transformWrites;
      _UpdateLocalUsages = updateLocalUsages;
      _MakeFieldPrivate = makeFieldPrivate;
      _TextFieldEnabled = textFieldEnabled;
      _AutoEnabled = autoEnabled;
      _ReadEnabled = readEnabled;
      _WriteEnabled = writeEnabled;
      _LocalUsagesEnabled = localUsagesEnabled;
      _MakePrivateEnabled = makePrivateEnabled;
      selectedExistingListItem.OptimizeNested = true;
      selectedAccessRights.OptimizeNested = true;
      newName.OptimizeNested = true;
      toAuto.OptimizeNested = true;
      transformReads.OptimizeNested = true;
      transformWrites.OptimizeNested = true;
      updateLocalUsages.OptimizeNested = true;
      makeFieldPrivate.OptimizeNested = true;
      textFieldEnabled.OptimizeNested = true;
      autoEnabled.OptimizeNested = true;
      readEnabled.OptimizeNested = true;
      writeEnabled.OptimizeNested = true;
      localUsagesEnabled.OptimizeNested = true;
      makePrivateEnabled.OptimizeNested = true;
    }
    //secondary constructor
    public EncapsulateFieldModel (
      [NotNull] List<TextWithIconModel> ExistingProperties,
      [NotNull] List<string> AvailableAccessRights,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      ExistingProperties,
      AvailableAccessRights,
      new RdProperty<int>(),
      new RdProperty<int>(),
      new RdProperty<string>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<TextWithIconModel>> ReadTextWithIconModelList = TextWithIconModel.Read.List();
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static new CtxReadDelegate<EncapsulateFieldModel> Read = (ctx, reader) => 
    {
      var existingProperties = ReadTextWithIconModelList(ctx, reader);
      var availableAccessRights = ReadStringList(ctx, reader);
      var selectedExistingListItem = RdProperty<int>.Read(ctx, reader);
      var selectedAccessRights = RdProperty<int>.Read(ctx, reader);
      var newName = RdProperty<string>.Read(ctx, reader);
      var toAuto = RdProperty<bool>.Read(ctx, reader);
      var transformReads = RdProperty<bool>.Read(ctx, reader);
      var transformWrites = RdProperty<bool>.Read(ctx, reader);
      var updateLocalUsages = RdProperty<bool>.Read(ctx, reader);
      var makeFieldPrivate = RdProperty<bool>.Read(ctx, reader);
      var textFieldEnabled = RdProperty<bool>.Read(ctx, reader);
      var autoEnabled = RdProperty<bool>.Read(ctx, reader);
      var readEnabled = RdProperty<bool>.Read(ctx, reader);
      var writeEnabled = RdProperty<bool>.Read(ctx, reader);
      var localUsagesEnabled = RdProperty<bool>.Read(ctx, reader);
      var makePrivateEnabled = RdProperty<bool>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new EncapsulateFieldModel(existingProperties, availableAccessRights, selectedExistingListItem, selectedAccessRights, newName, toAuto, transformReads, transformWrites, updateLocalUsages, makeFieldPrivate, textFieldEnabled, autoEnabled, readEnabled, writeEnabled, localUsagesEnabled, makePrivateEnabled, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<TextWithIconModel>> WriteTextWithIconModelList = TextWithIconModel.Write.List();
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static new CtxWriteDelegate<EncapsulateFieldModel> Write = (ctx, writer, value) => 
    {
      WriteTextWithIconModelList(ctx, writer, value.ExistingProperties);
      WriteStringList(ctx, writer, value.AvailableAccessRights);
      RdProperty<int>.Write(ctx, writer, value._SelectedExistingListItem);
      RdProperty<int>.Write(ctx, writer, value._SelectedAccessRights);
      RdProperty<string>.Write(ctx, writer, value._NewName);
      RdProperty<bool>.Write(ctx, writer, value._ToAuto);
      RdProperty<bool>.Write(ctx, writer, value._TransformReads);
      RdProperty<bool>.Write(ctx, writer, value._TransformWrites);
      RdProperty<bool>.Write(ctx, writer, value._UpdateLocalUsages);
      RdProperty<bool>.Write(ctx, writer, value._MakeFieldPrivate);
      RdProperty<bool>.Write(ctx, writer, value._TextFieldEnabled);
      RdProperty<bool>.Write(ctx, writer, value._AutoEnabled);
      RdProperty<bool>.Write(ctx, writer, value._ReadEnabled);
      RdProperty<bool>.Write(ctx, writer, value._WriteEnabled);
      RdProperty<bool>.Write(ctx, writer, value._LocalUsagesEnabled);
      RdProperty<bool>.Write(ctx, writer, value._MakePrivateEnabled);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      ExistingProperties.BindEx(lifetime, this, "existingProperties");
      _SelectedExistingListItem.BindEx(lifetime, this, "selectedExistingListItem");
      _SelectedAccessRights.BindEx(lifetime, this, "selectedAccessRights");
      _NewName.BindEx(lifetime, this, "newName");
      _ToAuto.BindEx(lifetime, this, "toAuto");
      _TransformReads.BindEx(lifetime, this, "transformReads");
      _TransformWrites.BindEx(lifetime, this, "transformWrites");
      _UpdateLocalUsages.BindEx(lifetime, this, "updateLocalUsages");
      _MakeFieldPrivate.BindEx(lifetime, this, "makeFieldPrivate");
      _TextFieldEnabled.BindEx(lifetime, this, "textFieldEnabled");
      _AutoEnabled.BindEx(lifetime, this, "autoEnabled");
      _ReadEnabled.BindEx(lifetime, this, "readEnabled");
      _WriteEnabled.BindEx(lifetime, this, "writeEnabled");
      _LocalUsagesEnabled.BindEx(lifetime, this, "localUsagesEnabled");
      _MakePrivateEnabled.BindEx(lifetime, this, "makePrivateEnabled");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      ExistingProperties.IdentifyEx(ids);
      _SelectedExistingListItem.IdentifyEx(ids);
      _SelectedAccessRights.IdentifyEx(ids);
      _NewName.IdentifyEx(ids);
      _ToAuto.IdentifyEx(ids);
      _TransformReads.IdentifyEx(ids);
      _TransformWrites.IdentifyEx(ids);
      _UpdateLocalUsages.IdentifyEx(ids);
      _MakeFieldPrivate.IdentifyEx(ids);
      _TextFieldEnabled.IdentifyEx(ids);
      _AutoEnabled.IdentifyEx(ids);
      _ReadEnabled.IdentifyEx(ids);
      _WriteEnabled.IdentifyEx(ids);
      _LocalUsagesEnabled.IdentifyEx(ids);
      _MakePrivateEnabled.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("EncapsulateFieldModel (");
      using (printer.IndentCookie()) {
        printer.Print("existingProperties = "); ExistingProperties.PrintEx(printer); printer.Println();
        printer.Print("availableAccessRights = "); AvailableAccessRights.PrintEx(printer); printer.Println();
        printer.Print("selectedExistingListItem = "); _SelectedExistingListItem.PrintEx(printer); printer.Println();
        printer.Print("selectedAccessRights = "); _SelectedAccessRights.PrintEx(printer); printer.Println();
        printer.Print("newName = "); _NewName.PrintEx(printer); printer.Println();
        printer.Print("toAuto = "); _ToAuto.PrintEx(printer); printer.Println();
        printer.Print("transformReads = "); _TransformReads.PrintEx(printer); printer.Println();
        printer.Print("transformWrites = "); _TransformWrites.PrintEx(printer); printer.Println();
        printer.Print("updateLocalUsages = "); _UpdateLocalUsages.PrintEx(printer); printer.Println();
        printer.Print("makeFieldPrivate = "); _MakeFieldPrivate.PrintEx(printer); printer.Println();
        printer.Print("textFieldEnabled = "); _TextFieldEnabled.PrintEx(printer); printer.Println();
        printer.Print("autoEnabled = "); _AutoEnabled.PrintEx(printer); printer.Println();
        printer.Print("readEnabled = "); _ReadEnabled.PrintEx(printer); printer.Println();
        printer.Print("writeEnabled = "); _WriteEnabled.PrintEx(printer); printer.Println();
        printer.Print("localUsagesEnabled = "); _LocalUsagesEnabled.PrintEx(printer); printer.Println();
        printer.Print("makePrivateEnabled = "); _MakePrivateEnabled.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ExtractInterfaceMemberModel : RdBindableBase {
    //fields
    [NotNull] public List<ExtractInterfaceSingleMemberModel> Members {get; private set;}
    [NotNull] public IVoidSink PublicButtonClicked { get { return _PublicButtonClicked; }}
    [NotNull] private readonly RdVoidSignal _PublicButtonClicked;
    [NotNull] public IVoidSink DependentButtonClicked { get { return _DependentButtonClicked; }}
    [NotNull] private readonly RdVoidSignal _DependentButtonClicked;
    
    //primary constructor
    private ExtractInterfaceMemberModel(
      [NotNull] List<ExtractInterfaceSingleMemberModel> members,
      [NotNull] RdVoidSignal publicButtonClicked,
      [NotNull] RdVoidSignal dependentButtonClicked
    )
    {
      Members = members;
      _PublicButtonClicked = publicButtonClicked;
      _DependentButtonClicked = dependentButtonClicked;
    }
    //secondary constructor
    public ExtractInterfaceMemberModel (
      [NotNull] List<ExtractInterfaceSingleMemberModel> Members
    ) : this (
      Members,
      new RdVoidSignal(),
      new RdVoidSignal()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<ExtractInterfaceSingleMemberModel>> ReadExtractInterfaceSingleMemberModelList = ExtractInterfaceSingleMemberModel.Read.List();
    public static CtxReadDelegate<ExtractInterfaceMemberModel> Read = (ctx, reader) => 
    {
      var members = ReadExtractInterfaceSingleMemberModelList(ctx, reader);
      var publicButtonClicked = RdVoidSignal.Read(ctx, reader);
      var dependentButtonClicked = RdVoidSignal.Read(ctx, reader);
      return new ExtractInterfaceMemberModel(members, publicButtonClicked, dependentButtonClicked);
    };
    
    public static CtxWriteDelegate<List<ExtractInterfaceSingleMemberModel>> WriteExtractInterfaceSingleMemberModelList = ExtractInterfaceSingleMemberModel.Write.List();
    public static CtxWriteDelegate<ExtractInterfaceMemberModel> Write = (ctx, writer, value) => 
    {
      WriteExtractInterfaceSingleMemberModelList(ctx, writer, value.Members);
      RdVoidSignal.Write(ctx, writer, value._PublicButtonClicked);
      RdVoidSignal.Write(ctx, writer, value._DependentButtonClicked);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Members.BindEx(lifetime, this, "members");
      _PublicButtonClicked.BindEx(lifetime, this, "publicButtonClicked");
      _DependentButtonClicked.BindEx(lifetime, this, "dependentButtonClicked");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Members.IdentifyEx(ids);
      _PublicButtonClicked.IdentifyEx(ids);
      _DependentButtonClicked.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ExtractInterfaceMemberModel (");
      using (printer.IndentCookie()) {
        printer.Print("members = "); Members.PrintEx(printer); printer.Println();
        printer.Print("publicButtonClicked = "); _PublicButtonClicked.PrintEx(printer); printer.Println();
        printer.Print("dependentButtonClicked = "); _DependentButtonClicked.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ExtractInterfaceSingleMemberModel : RdBindableBase {
    //fields
    [NotNull] public string MemberName {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public IRdProperty<bool> IsEnabled { get { return _IsEnabled; }}
    [NotNull] private readonly RdProperty<bool> _IsEnabled;
    public bool CanHaveAbstract {get; private set;}
    [NotNull] public IRdProperty<bool> CanMakeAbstract { get { return _CanMakeAbstract; }}
    [NotNull] private readonly RdProperty<bool> _CanMakeAbstract;
    [NotNull] public IRdProperty<bool> DoMakeAbstract { get { return _DoMakeAbstract; }}
    [NotNull] private readonly RdProperty<bool> _DoMakeAbstract;
    
    //primary constructor
    private ExtractInterfaceSingleMemberModel(
      [NotNull] string memberName,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<bool> isEnabled,
      bool canHaveAbstract,
      [NotNull] RdProperty<bool> canMakeAbstract,
      [NotNull] RdProperty<bool> doMakeAbstract
    )
    {
      MemberName = memberName;
      Icon = icon;
      _IsEnabled = isEnabled;
      CanHaveAbstract = canHaveAbstract;
      _CanMakeAbstract = canMakeAbstract;
      _DoMakeAbstract = doMakeAbstract;
      isEnabled.OptimizeNested = true;
      canMakeAbstract.OptimizeNested = true;
      doMakeAbstract.OptimizeNested = true;
    }
    //secondary constructor
    public ExtractInterfaceSingleMemberModel (
      [NotNull] string MemberName,
      [CanBeNull] JetBrains.Rider.Model.Icon Icon,
      bool CanHaveAbstract
    ) : this (
      MemberName,
      Icon,
      new RdProperty<bool>(),
      CanHaveAbstract,
      new RdProperty<bool>(),
      new RdProperty<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<ExtractInterfaceSingleMemberModel> Read = (ctx, reader) => 
    {
      var memberName = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader);
      var canHaveAbstract = reader.ReadBool();
      var canMakeAbstract = RdProperty<bool>.Read(ctx, reader);
      var doMakeAbstract = RdProperty<bool>.Read(ctx, reader);
      return new ExtractInterfaceSingleMemberModel(memberName, icon, isEnabled, canHaveAbstract, canMakeAbstract, doMakeAbstract);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<ExtractInterfaceSingleMemberModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.MemberName);
      WriteIconNullable(ctx, writer, value.Icon);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
      writer.Write(value.CanHaveAbstract);
      RdProperty<bool>.Write(ctx, writer, value._CanMakeAbstract);
      RdProperty<bool>.Write(ctx, writer, value._DoMakeAbstract);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _IsEnabled.BindEx(lifetime, this, "isEnabled");
      _CanMakeAbstract.BindEx(lifetime, this, "canMakeAbstract");
      _DoMakeAbstract.BindEx(lifetime, this, "doMakeAbstract");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _IsEnabled.IdentifyEx(ids);
      _CanMakeAbstract.IdentifyEx(ids);
      _DoMakeAbstract.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ExtractInterfaceSingleMemberModel (");
      using (printer.IndentCookie()) {
        printer.Print("memberName = "); MemberName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("canHaveAbstract = "); CanHaveAbstract.PrintEx(printer); printer.Println();
        printer.Print("canMakeAbstract = "); _CanMakeAbstract.PrintEx(printer); printer.Println();
        printer.Print("doMakeAbstract = "); _DoMakeAbstract.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ExtractInterfaceSuperclassModel : AbstractPage
   {
    //fields
    public bool IsSuperclass {get; private set;}
    public bool BesideEnabled {get; private set;}
    [NotNull] public IRdProperty<string> InterfaceName { get { return _InterfaceName; }}
    [NotNull] private readonly RdProperty<string> _InterfaceName;
    [NotNull] public IRdProperty<bool> PlaceBeside { get { return _PlaceBeside; }}
    [NotNull] private readonly RdProperty<bool> _PlaceBeside;
    [NotNull] public ExtractInterfaceMemberModel Members {get; private set;}
    
    //primary constructor
    private ExtractInterfaceSuperclassModel(
      bool isSuperclass,
      bool besideEnabled,
      [NotNull] RdProperty<string> interfaceName,
      [NotNull] RdProperty<bool> placeBeside,
      [NotNull] ExtractInterfaceMemberModel members,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      IsSuperclass = isSuperclass;
      BesideEnabled = besideEnabled;
      _InterfaceName = interfaceName;
      _PlaceBeside = placeBeside;
      Members = members;
      interfaceName.OptimizeNested = true;
      placeBeside.OptimizeNested = true;
    }
    //secondary constructor
    public ExtractInterfaceSuperclassModel (
      bool IsSuperclass,
      bool BesideEnabled,
      [NotNull] ExtractInterfaceMemberModel Members,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      IsSuperclass,
      BesideEnabled,
      new RdProperty<string>(),
      new RdProperty<bool>(),
      Members,
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static new CtxReadDelegate<ExtractInterfaceSuperclassModel> Read = (ctx, reader) => 
    {
      var isSuperclass = reader.ReadBool();
      var besideEnabled = reader.ReadBool();
      var interfaceName = RdProperty<string>.Read(ctx, reader);
      var placeBeside = RdProperty<bool>.Read(ctx, reader);
      var members = ExtractInterfaceMemberModel.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new ExtractInterfaceSuperclassModel(isSuperclass, besideEnabled, interfaceName, placeBeside, members, title, description, continueEnabled, validationResult);
    };
    
    public static new CtxWriteDelegate<ExtractInterfaceSuperclassModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IsSuperclass);
      writer.Write(value.BesideEnabled);
      RdProperty<string>.Write(ctx, writer, value._InterfaceName);
      RdProperty<bool>.Write(ctx, writer, value._PlaceBeside);
      ExtractInterfaceMemberModel.Write(ctx, writer, value.Members);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _InterfaceName.BindEx(lifetime, this, "interfaceName");
      _PlaceBeside.BindEx(lifetime, this, "placeBeside");
      Members.BindEx(lifetime, this, "members");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _InterfaceName.IdentifyEx(ids);
      _PlaceBeside.IdentifyEx(ids);
      Members.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ExtractInterfaceSuperclassModel (");
      using (printer.IndentCookie()) {
        printer.Print("isSuperclass = "); IsSuperclass.PrintEx(printer); printer.Println();
        printer.Print("besideEnabled = "); BesideEnabled.PrintEx(printer); printer.Println();
        printer.Print("interfaceName = "); _InterfaceName.PrintEx(printer); printer.Println();
        printer.Print("placeBeside = "); _PlaceBeside.PrintEx(printer); printer.Println();
        printer.Print("members = "); Members.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ExtractMethodKind {
    Method,
    Property,
    ChainedConstructor
  }
  
  
  public class ExtractMethodKindModel : AbstractPage
   {
    //fields
    public bool CanExtractProperty {get; private set;}
    public bool CanExtractChainedConstructor {get; private set;}
    [NotNull] public IRdProperty<ExtractMethodKind> Kind { get { return _Kind; }}
    [NotNull] private readonly RdProperty<ExtractMethodKind> _Kind;
    
    //primary constructor
    private ExtractMethodKindModel(
      bool canExtractProperty,
      bool canExtractChainedConstructor,
      [NotNull] RdProperty<ExtractMethodKind> kind,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      CanExtractProperty = canExtractProperty;
      CanExtractChainedConstructor = canExtractChainedConstructor;
      _Kind = kind;
      kind.OptimizeNested = true;
    }
    //secondary constructor
    public ExtractMethodKindModel (
      bool CanExtractProperty,
      bool CanExtractChainedConstructor,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      CanExtractProperty,
      CanExtractChainedConstructor,
      new RdProperty<ExtractMethodKind>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<ExtractMethodKind> ReadExtractMethodKind = new CtxReadDelegate<ExtractMethodKind>(Serializers.ReadEnum<ExtractMethodKind>);
    public static new CtxReadDelegate<ExtractMethodKindModel> Read = (ctx, reader) => 
    {
      var canExtractProperty = reader.ReadBool();
      var canExtractChainedConstructor = reader.ReadBool();
      var kind = RdProperty<ExtractMethodKind>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new ExtractMethodKindModel(canExtractProperty, canExtractChainedConstructor, kind, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<ExtractMethodKind> WriteExtractMethodKind = new CtxWriteDelegate<ExtractMethodKind>(Serializers.WriteEnum<ExtractMethodKind>);
    public static new CtxWriteDelegate<ExtractMethodKindModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.CanExtractProperty);
      writer.Write(value.CanExtractChainedConstructor);
      RdProperty<ExtractMethodKind>.Write(ctx, writer, value._Kind);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Kind.BindEx(lifetime, this, "kind");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Kind.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ExtractMethodKindModel (");
      using (printer.IndentCookie()) {
        printer.Print("canExtractProperty = "); CanExtractProperty.PrintEx(printer); printer.Println();
        printer.Print("canExtractChainedConstructor = "); CanExtractChainedConstructor.PrintEx(printer); printer.Println();
        printer.Print("kind = "); _Kind.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ExtractMethodOptionsModel : AbstractPage
   {
    //fields
    public bool NameEnabled {get; private set;}
    [NotNull] public IRdProperty<string> NewName { get { return _NewName; }}
    [NotNull] private readonly RdProperty<string> _NewName;
    public bool ReturnComboEnabled {get; private set;}
    [NotNull] public List<string> PossibleReturnValues {get; private set;}
    [NotNull] public IRdProperty<int> ReturnValueIndex { get { return _ReturnValueIndex; }}
    [NotNull] private readonly RdProperty<int> _ReturnValueIndex;
    public bool CanMakeStatic {get; private set;}
    [NotNull] public IRdProperty<bool> CanMakeVirtual { get { return _CanMakeVirtual; }}
    [NotNull] private readonly RdProperty<bool> _CanMakeVirtual;
    [NotNull] public IRdProperty<bool> MakeStatic { get { return _MakeStatic; }}
    [NotNull] private readonly RdProperty<bool> _MakeStatic;
    [NotNull] public IRdProperty<bool> MakeVirtual { get { return _MakeVirtual; }}
    [NotNull] private readonly RdProperty<bool> _MakeVirtual;
    public bool CanChangeAccessRights {get; private set;}
    [NotNull] public IRdProperty<bool> EnablePrivate { get { return _EnablePrivate; }}
    [NotNull] private readonly RdProperty<bool> _EnablePrivate;
    [NotNull] public IRdProperty<ExtractMethodVisibility> AccessRights { get { return _AccessRights; }}
    [NotNull] private readonly RdProperty<ExtractMethodVisibility> _AccessRights;
    public bool CanMoveParameters {get; private set;}
    [NotNull] public IRdProperty<ExtractMethodParameterListModel> Parameters { get { return _Parameters; }}
    [NotNull] private readonly RdProperty<ExtractMethodParameterListModel> _Parameters;
    [NotNull] public IRdProperty<string> PreviewText { get { return _PreviewText; }}
    [NotNull] private readonly RdProperty<string> _PreviewText;
    
    //primary constructor
    private ExtractMethodOptionsModel(
      bool nameEnabled,
      [NotNull] RdProperty<string> newName,
      bool returnComboEnabled,
      [NotNull] List<string> possibleReturnValues,
      [NotNull] RdProperty<int> returnValueIndex,
      bool canMakeStatic,
      [NotNull] RdProperty<bool> canMakeVirtual,
      [NotNull] RdProperty<bool> makeStatic,
      [NotNull] RdProperty<bool> makeVirtual,
      bool canChangeAccessRights,
      [NotNull] RdProperty<bool> enablePrivate,
      [NotNull] RdProperty<ExtractMethodVisibility> accessRights,
      bool canMoveParameters,
      [NotNull] RdProperty<ExtractMethodParameterListModel> parameters,
      [NotNull] RdProperty<string> previewText,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      NameEnabled = nameEnabled;
      _NewName = newName;
      ReturnComboEnabled = returnComboEnabled;
      PossibleReturnValues = possibleReturnValues;
      _ReturnValueIndex = returnValueIndex;
      CanMakeStatic = canMakeStatic;
      _CanMakeVirtual = canMakeVirtual;
      _MakeStatic = makeStatic;
      _MakeVirtual = makeVirtual;
      CanChangeAccessRights = canChangeAccessRights;
      _EnablePrivate = enablePrivate;
      _AccessRights = accessRights;
      CanMoveParameters = canMoveParameters;
      _Parameters = parameters;
      _PreviewText = previewText;
      newName.OptimizeNested = true;
      returnValueIndex.OptimizeNested = true;
      canMakeVirtual.OptimizeNested = true;
      makeStatic.OptimizeNested = true;
      makeVirtual.OptimizeNested = true;
      enablePrivate.OptimizeNested = true;
      accessRights.OptimizeNested = true;
      previewText.OptimizeNested = true;
    }
    //secondary constructor
    public ExtractMethodOptionsModel (
      bool NameEnabled,
      bool ReturnComboEnabled,
      [NotNull] List<string> PossibleReturnValues,
      bool CanMakeStatic,
      bool CanChangeAccessRights,
      bool CanMoveParameters,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      NameEnabled,
      new RdProperty<string>(),
      ReturnComboEnabled,
      PossibleReturnValues,
      new RdProperty<int>(),
      CanMakeStatic,
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      CanChangeAccessRights,
      new RdProperty<bool>(),
      new RdProperty<ExtractMethodVisibility>(),
      CanMoveParameters,
      new RdProperty<ExtractMethodParameterListModel>(),
      new RdProperty<string>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static CtxReadDelegate<ExtractMethodVisibility> ReadExtractMethodVisibility = new CtxReadDelegate<ExtractMethodVisibility>(Serializers.ReadEnum<ExtractMethodVisibility>);
    public static new CtxReadDelegate<ExtractMethodOptionsModel> Read = (ctx, reader) => 
    {
      var nameEnabled = reader.ReadBool();
      var newName = RdProperty<string>.Read(ctx, reader);
      var returnComboEnabled = reader.ReadBool();
      var possibleReturnValues = ReadStringList(ctx, reader);
      var returnValueIndex = RdProperty<int>.Read(ctx, reader);
      var canMakeStatic = reader.ReadBool();
      var canMakeVirtual = RdProperty<bool>.Read(ctx, reader);
      var makeStatic = RdProperty<bool>.Read(ctx, reader);
      var makeVirtual = RdProperty<bool>.Read(ctx, reader);
      var canChangeAccessRights = reader.ReadBool();
      var enablePrivate = RdProperty<bool>.Read(ctx, reader);
      var accessRights = RdProperty<ExtractMethodVisibility>.Read(ctx, reader);
      var canMoveParameters = reader.ReadBool();
      var parameters = RdProperty<ExtractMethodParameterListModel>.Read(ctx, reader);
      var previewText = RdProperty<string>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new ExtractMethodOptionsModel(nameEnabled, newName, returnComboEnabled, possibleReturnValues, returnValueIndex, canMakeStatic, canMakeVirtual, makeStatic, makeVirtual, canChangeAccessRights, enablePrivate, accessRights, canMoveParameters, parameters, previewText, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static CtxWriteDelegate<ExtractMethodVisibility> WriteExtractMethodVisibility = new CtxWriteDelegate<ExtractMethodVisibility>(Serializers.WriteEnum<ExtractMethodVisibility>);
    public static new CtxWriteDelegate<ExtractMethodOptionsModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.NameEnabled);
      RdProperty<string>.Write(ctx, writer, value._NewName);
      writer.Write(value.ReturnComboEnabled);
      WriteStringList(ctx, writer, value.PossibleReturnValues);
      RdProperty<int>.Write(ctx, writer, value._ReturnValueIndex);
      writer.Write(value.CanMakeStatic);
      RdProperty<bool>.Write(ctx, writer, value._CanMakeVirtual);
      RdProperty<bool>.Write(ctx, writer, value._MakeStatic);
      RdProperty<bool>.Write(ctx, writer, value._MakeVirtual);
      writer.Write(value.CanChangeAccessRights);
      RdProperty<bool>.Write(ctx, writer, value._EnablePrivate);
      RdProperty<ExtractMethodVisibility>.Write(ctx, writer, value._AccessRights);
      writer.Write(value.CanMoveParameters);
      RdProperty<ExtractMethodParameterListModel>.Write(ctx, writer, value._Parameters);
      RdProperty<string>.Write(ctx, writer, value._PreviewText);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _NewName.BindEx(lifetime, this, "newName");
      _ReturnValueIndex.BindEx(lifetime, this, "returnValueIndex");
      _CanMakeVirtual.BindEx(lifetime, this, "canMakeVirtual");
      _MakeStatic.BindEx(lifetime, this, "makeStatic");
      _MakeVirtual.BindEx(lifetime, this, "makeVirtual");
      _EnablePrivate.BindEx(lifetime, this, "enablePrivate");
      _AccessRights.BindEx(lifetime, this, "accessRights");
      _Parameters.BindEx(lifetime, this, "parameters");
      _PreviewText.BindEx(lifetime, this, "previewText");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _NewName.IdentifyEx(ids);
      _ReturnValueIndex.IdentifyEx(ids);
      _CanMakeVirtual.IdentifyEx(ids);
      _MakeStatic.IdentifyEx(ids);
      _MakeVirtual.IdentifyEx(ids);
      _EnablePrivate.IdentifyEx(ids);
      _AccessRights.IdentifyEx(ids);
      _Parameters.IdentifyEx(ids);
      _PreviewText.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ExtractMethodOptionsModel (");
      using (printer.IndentCookie()) {
        printer.Print("nameEnabled = "); NameEnabled.PrintEx(printer); printer.Println();
        printer.Print("newName = "); _NewName.PrintEx(printer); printer.Println();
        printer.Print("returnComboEnabled = "); ReturnComboEnabled.PrintEx(printer); printer.Println();
        printer.Print("possibleReturnValues = "); PossibleReturnValues.PrintEx(printer); printer.Println();
        printer.Print("returnValueIndex = "); _ReturnValueIndex.PrintEx(printer); printer.Println();
        printer.Print("canMakeStatic = "); CanMakeStatic.PrintEx(printer); printer.Println();
        printer.Print("canMakeVirtual = "); _CanMakeVirtual.PrintEx(printer); printer.Println();
        printer.Print("makeStatic = "); _MakeStatic.PrintEx(printer); printer.Println();
        printer.Print("makeVirtual = "); _MakeVirtual.PrintEx(printer); printer.Println();
        printer.Print("canChangeAccessRights = "); CanChangeAccessRights.PrintEx(printer); printer.Println();
        printer.Print("enablePrivate = "); _EnablePrivate.PrintEx(printer); printer.Println();
        printer.Print("accessRights = "); _AccessRights.PrintEx(printer); printer.Println();
        printer.Print("canMoveParameters = "); CanMoveParameters.PrintEx(printer); printer.Println();
        printer.Print("parameters = "); _Parameters.PrintEx(printer); printer.Println();
        printer.Print("previewText = "); _PreviewText.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ExtractMethodParameterListModel : RdBindableBase {
    //fields
    [NotNull] public List<ExtractMethodParameterModel> Elements {get; private set;}
    
    //primary constructor
    public ExtractMethodParameterListModel(
      [NotNull] List<ExtractMethodParameterModel> elements
    )
    {
      Elements = elements;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<ExtractMethodParameterModel>> ReadExtractMethodParameterModelList = ExtractMethodParameterModel.Read.List();
    public static CtxReadDelegate<ExtractMethodParameterListModel> Read = (ctx, reader) => 
    {
      var elements = ReadExtractMethodParameterModelList(ctx, reader);
      return new ExtractMethodParameterListModel(elements);
    };
    
    public static CtxWriteDelegate<List<ExtractMethodParameterModel>> WriteExtractMethodParameterModelList = ExtractMethodParameterModel.Write.List();
    public static CtxWriteDelegate<ExtractMethodParameterListModel> Write = (ctx, writer, value) => 
    {
      WriteExtractMethodParameterModelList(ctx, writer, value.Elements);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Elements.BindEx(lifetime, this, "elements");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Elements.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ExtractMethodParameterListModel (");
      using (printer.IndentCookie()) {
        printer.Print("elements = "); Elements.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ExtractMethodParameterModel : RdBindableBase {
    //fields
    [NotNull] public string ParameterName {get; private set;}
    [NotNull] public string ParameterKind {get; private set;}
    public bool Enabled {get; private set;}
    [NotNull] public IRdProperty<bool> Include { get { return _Include; }}
    [NotNull] private readonly RdProperty<bool> _Include;
    [NotNull] public IRdProperty<int> Index { get { return _Index; }}
    [NotNull] private readonly RdProperty<int> _Index;
    [NotNull] public IVoidSink MoveUp { get { return _MoveUp; }}
    [NotNull] private readonly RdVoidSignal _MoveUp;
    [NotNull] public IVoidSink MoveDown { get { return _MoveDown; }}
    [NotNull] private readonly RdVoidSignal _MoveDown;
    
    //primary constructor
    private ExtractMethodParameterModel(
      [NotNull] string parameterName,
      [NotNull] string parameterKind,
      bool enabled,
      [NotNull] RdProperty<bool> include,
      [NotNull] RdProperty<int> index,
      [NotNull] RdVoidSignal moveUp,
      [NotNull] RdVoidSignal moveDown
    )
    {
      ParameterName = parameterName;
      ParameterKind = parameterKind;
      Enabled = enabled;
      _Include = include;
      _Index = index;
      _MoveUp = moveUp;
      _MoveDown = moveDown;
      include.OptimizeNested = true;
      index.OptimizeNested = true;
    }
    //secondary constructor
    public ExtractMethodParameterModel (
      [NotNull] string ParameterName,
      [NotNull] string ParameterKind,
      bool Enabled
    ) : this (
      ParameterName,
      ParameterKind,
      Enabled,
      new RdProperty<bool>(),
      new RdProperty<int>(),
      new RdVoidSignal(),
      new RdVoidSignal()
    ) {}
    //statics
    
    public static CtxReadDelegate<ExtractMethodParameterModel> Read = (ctx, reader) => 
    {
      var parameterName = reader.ReadString();
      var parameterKind = reader.ReadString();
      var enabled = reader.ReadBool();
      var include = RdProperty<bool>.Read(ctx, reader);
      var index = RdProperty<int>.Read(ctx, reader);
      var moveUp = RdVoidSignal.Read(ctx, reader);
      var moveDown = RdVoidSignal.Read(ctx, reader);
      return new ExtractMethodParameterModel(parameterName, parameterKind, enabled, include, index, moveUp, moveDown);
    };
    
    public static CtxWriteDelegate<ExtractMethodParameterModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ParameterName);
      writer.Write(value.ParameterKind);
      writer.Write(value.Enabled);
      RdProperty<bool>.Write(ctx, writer, value._Include);
      RdProperty<int>.Write(ctx, writer, value._Index);
      RdVoidSignal.Write(ctx, writer, value._MoveUp);
      RdVoidSignal.Write(ctx, writer, value._MoveDown);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Include.BindEx(lifetime, this, "include");
      _Index.BindEx(lifetime, this, "index");
      _MoveUp.BindEx(lifetime, this, "moveUp");
      _MoveDown.BindEx(lifetime, this, "moveDown");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Include.IdentifyEx(ids);
      _Index.IdentifyEx(ids);
      _MoveUp.IdentifyEx(ids);
      _MoveDown.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ExtractMethodParameterModel (");
      using (printer.IndentCookie()) {
        printer.Print("parameterName = "); ParameterName.PrintEx(printer); printer.Println();
        printer.Print("parameterKind = "); ParameterKind.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); Enabled.PrintEx(printer); printer.Println();
        printer.Print("include = "); _Include.PrintEx(printer); printer.Println();
        printer.Print("index = "); _Index.PrintEx(printer); printer.Println();
        printer.Print("moveUp = "); _MoveUp.PrintEx(printer); printer.Println();
        printer.Print("moveDown = "); _MoveDown.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ExtractMethodVisibility {
    Private,
    Protected,
    Internal,
    Public
  }
  
  
  public class FeelLucky : AbstractPage
   {
    //fields
    //primary constructor
    private FeelLucky(
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
    }
    //secondary constructor
    public FeelLucky (
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static new CtxReadDelegate<FeelLucky> Read = (ctx, reader) => 
    {
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new FeelLucky(title, description, continueEnabled, validationResult);
    };
    
    public static new CtxWriteDelegate<FeelLucky> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("FeelLucky (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class InlineMethodPageModel : AbstractPage
   {
    //fields
    public bool InlineAllEnabled {get; private set;}
    [NotNull] public IRdProperty<bool> InlineAllUsages { get { return _InlineAllUsages; }}
    [NotNull] private readonly RdProperty<bool> _InlineAllUsages;
    [NotNull] public IRdProperty<bool> RemoveEnabled { get { return _RemoveEnabled; }}
    [NotNull] private readonly RdProperty<bool> _RemoveEnabled;
    [NotNull] public IRdProperty<bool> RemoveMethod { get { return _RemoveMethod; }}
    [NotNull] private readonly RdProperty<bool> _RemoveMethod;
    
    //primary constructor
    private InlineMethodPageModel(
      bool inlineAllEnabled,
      [NotNull] RdProperty<bool> inlineAllUsages,
      [NotNull] RdProperty<bool> removeEnabled,
      [NotNull] RdProperty<bool> removeMethod,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      InlineAllEnabled = inlineAllEnabled;
      _InlineAllUsages = inlineAllUsages;
      _RemoveEnabled = removeEnabled;
      _RemoveMethod = removeMethod;
      inlineAllUsages.OptimizeNested = true;
      removeEnabled.OptimizeNested = true;
      removeMethod.OptimizeNested = true;
    }
    //secondary constructor
    public InlineMethodPageModel (
      bool InlineAllEnabled,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      InlineAllEnabled,
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static new CtxReadDelegate<InlineMethodPageModel> Read = (ctx, reader) => 
    {
      var inlineAllEnabled = reader.ReadBool();
      var inlineAllUsages = RdProperty<bool>.Read(ctx, reader);
      var removeEnabled = RdProperty<bool>.Read(ctx, reader);
      var removeMethod = RdProperty<bool>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new InlineMethodPageModel(inlineAllEnabled, inlineAllUsages, removeEnabled, removeMethod, title, description, continueEnabled, validationResult);
    };
    
    public static new CtxWriteDelegate<InlineMethodPageModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.InlineAllEnabled);
      RdProperty<bool>.Write(ctx, writer, value._InlineAllUsages);
      RdProperty<bool>.Write(ctx, writer, value._RemoveEnabled);
      RdProperty<bool>.Write(ctx, writer, value._RemoveMethod);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _InlineAllUsages.BindEx(lifetime, this, "inlineAllUsages");
      _RemoveEnabled.BindEx(lifetime, this, "removeEnabled");
      _RemoveMethod.BindEx(lifetime, this, "removeMethod");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _InlineAllUsages.IdentifyEx(ids);
      _RemoveEnabled.IdentifyEx(ids);
      _RemoveMethod.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("InlineMethodPageModel (");
      using (printer.IndentCookie()) {
        printer.Print("inlineAllEnabled = "); InlineAllEnabled.PrintEx(printer); printer.Println();
        printer.Print("inlineAllUsages = "); _InlineAllUsages.PrintEx(printer); printer.Println();
        printer.Print("removeEnabled = "); _RemoveEnabled.PrintEx(printer); printer.Println();
        printer.Print("removeMethod = "); _RemoveMethod.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class InlineParameterInvocationsModel : AbstractPage
   {
    //fields
    [NotNull] public string LabelText {get; private set;}
    [NotNull] public List<string> PossibleSources {get; private set;}
    [NotNull] public IRdProperty<int> SelectedItem { get { return _SelectedItem; }}
    [NotNull] private readonly RdProperty<int> _SelectedItem;
    [NotNull] public ISink<int> Navigate { get { return _Navigate; }}
    [NotNull] private readonly RdSignal<int> _Navigate;
    
    //primary constructor
    private InlineParameterInvocationsModel(
      [NotNull] string labelText,
      [NotNull] List<string> possibleSources,
      [NotNull] RdProperty<int> selectedItem,
      [NotNull] RdSignal<int> navigate,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      LabelText = labelText;
      PossibleSources = possibleSources;
      _SelectedItem = selectedItem;
      _Navigate = navigate;
      selectedItem.OptimizeNested = true;
    }
    //secondary constructor
    public InlineParameterInvocationsModel (
      [NotNull] string LabelText,
      [NotNull] List<string> PossibleSources,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      LabelText,
      PossibleSources,
      new RdProperty<int>(),
      new RdSignal<int>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static new CtxReadDelegate<InlineParameterInvocationsModel> Read = (ctx, reader) => 
    {
      var labelText = reader.ReadString();
      var possibleSources = ReadStringList(ctx, reader);
      var selectedItem = RdProperty<int>.Read(ctx, reader);
      var navigate = RdSignal<int>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new InlineParameterInvocationsModel(labelText, possibleSources, selectedItem, navigate, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static new CtxWriteDelegate<InlineParameterInvocationsModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.LabelText);
      WriteStringList(ctx, writer, value.PossibleSources);
      RdProperty<int>.Write(ctx, writer, value._SelectedItem);
      RdSignal<int>.Write(ctx, writer, value._Navigate);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _SelectedItem.BindEx(lifetime, this, "selectedItem");
      _Navigate.BindEx(lifetime, this, "navigate");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _SelectedItem.IdentifyEx(ids);
      _Navigate.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("InlineParameterInvocationsModel (");
      using (printer.IndentCookie()) {
        printer.Print("labelText = "); LabelText.PrintEx(printer); printer.Println();
        printer.Print("possibleSources = "); PossibleSources.PrintEx(printer); printer.Println();
        printer.Print("selectedItem = "); _SelectedItem.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class InlineParameterNewParameterList : RdBindableBase {
    //fields
    [NotNull] public List<InlineParameterParameterModel> Items {get; private set;}
    
    //primary constructor
    public InlineParameterNewParameterList(
      [NotNull] List<InlineParameterParameterModel> items
    )
    {
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<InlineParameterParameterModel>> ReadInlineParameterParameterModelList = InlineParameterParameterModel.Read.List();
    public static CtxReadDelegate<InlineParameterNewParameterList> Read = (ctx, reader) => 
    {
      var items = ReadInlineParameterParameterModelList(ctx, reader);
      return new InlineParameterNewParameterList(items);
    };
    
    public static CtxWriteDelegate<List<InlineParameterParameterModel>> WriteInlineParameterParameterModelList = InlineParameterParameterModel.Write.List();
    public static CtxWriteDelegate<InlineParameterNewParameterList> Write = (ctx, writer, value) => 
    {
      WriteInlineParameterParameterModelList(ctx, writer, value.Items);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Items.BindEx(lifetime, this, "items");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Items.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("InlineParameterNewParameterList (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class InlineParameterParameterModel : RdBindableBase {
    //fields
    [NotNull] public string Text {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public IRdProperty<bool> Included { get { return _Included; }}
    [NotNull] private readonly RdProperty<bool> _Included;
    [NotNull] public IVoidSink Navigate { get { return _Navigate; }}
    [NotNull] private readonly RdVoidSignal _Navigate;
    
    //primary constructor
    private InlineParameterParameterModel(
      [NotNull] string text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<bool> included,
      [NotNull] RdVoidSignal navigate
    )
    {
      Text = text;
      Icon = icon;
      _Included = included;
      _Navigate = navigate;
      included.OptimizeNested = true;
    }
    //secondary constructor
    public InlineParameterParameterModel (
      [NotNull] string Text,
      [CanBeNull] JetBrains.Rider.Model.Icon Icon
    ) : this (
      Text,
      Icon,
      new RdProperty<bool>(),
      new RdVoidSignal()
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<InlineParameterParameterModel> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var included = RdProperty<bool>.Read(ctx, reader);
      var navigate = RdVoidSignal.Read(ctx, reader);
      return new InlineParameterParameterModel(text, icon, included, navigate);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<InlineParameterParameterModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
      WriteIconNullable(ctx, writer, value.Icon);
      RdProperty<bool>.Write(ctx, writer, value._Included);
      RdVoidSignal.Write(ctx, writer, value._Navigate);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Included.BindEx(lifetime, this, "included");
      _Navigate.BindEx(lifetime, this, "navigate");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Included.IdentifyEx(ids);
      _Navigate.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("InlineParameterParameterModel (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("included = "); _Included.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class InlineParameterRdModel : AbstractPage
   {
    //fields
    [NotNull] public string UsedUsage {get; private set;}
    [NotNull] public List<InlineParameterParameterModel> ParameterList {get; private set;}
    [NotNull] public IRdProperty<InlineParameterNewParameterList> NewParameterList { get { return _NewParameterList; }}
    [NotNull] private readonly RdProperty<InlineParameterNewParameterList> _NewParameterList;
    [NotNull] public IRdProperty<string> PreviewText { get { return _PreviewText; }}
    [NotNull] private readonly RdProperty<string> _PreviewText;
    [NotNull] public JetBrains.Rider.Model.RdLanguage Language {get; private set;}
    
    //primary constructor
    private InlineParameterRdModel(
      [NotNull] string usedUsage,
      [NotNull] List<InlineParameterParameterModel> parameterList,
      [NotNull] RdProperty<InlineParameterNewParameterList> newParameterList,
      [NotNull] RdProperty<string> previewText,
      [NotNull] JetBrains.Rider.Model.RdLanguage language,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      UsedUsage = usedUsage;
      ParameterList = parameterList;
      _NewParameterList = newParameterList;
      _PreviewText = previewText;
      Language = language;
      previewText.OptimizeNested = true;
    }
    //secondary constructor
    public InlineParameterRdModel (
      [NotNull] string UsedUsage,
      [NotNull] List<InlineParameterParameterModel> ParameterList,
      [NotNull] JetBrains.Rider.Model.RdLanguage Language,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      UsedUsage,
      ParameterList,
      new RdProperty<InlineParameterNewParameterList>(),
      new RdProperty<string>(),
      Language,
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<InlineParameterParameterModel>> ReadInlineParameterParameterModelList = InlineParameterParameterModel.Read.List();
    public static new CtxReadDelegate<InlineParameterRdModel> Read = (ctx, reader) => 
    {
      var usedUsage = reader.ReadString();
      var parameterList = ReadInlineParameterParameterModelList(ctx, reader);
      var newParameterList = RdProperty<InlineParameterNewParameterList>.Read(ctx, reader);
      var previewText = RdProperty<string>.Read(ctx, reader);
      var language = JetBrains.Rider.Model.RdLanguage.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new InlineParameterRdModel(usedUsage, parameterList, newParameterList, previewText, language, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<InlineParameterParameterModel>> WriteInlineParameterParameterModelList = InlineParameterParameterModel.Write.List();
    public static new CtxWriteDelegate<InlineParameterRdModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.UsedUsage);
      WriteInlineParameterParameterModelList(ctx, writer, value.ParameterList);
      RdProperty<InlineParameterNewParameterList>.Write(ctx, writer, value._NewParameterList);
      RdProperty<string>.Write(ctx, writer, value._PreviewText);
      JetBrains.Rider.Model.RdLanguage.Write(ctx, writer, value.Language);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      ParameterList.BindEx(lifetime, this, "parameterList");
      _NewParameterList.BindEx(lifetime, this, "newParameterList");
      _PreviewText.BindEx(lifetime, this, "previewText");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      ParameterList.IdentifyEx(ids);
      _NewParameterList.IdentifyEx(ids);
      _PreviewText.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("InlineParameterRdModel (");
      using (printer.IndentCookie()) {
        printer.Print("usedUsage = "); UsedUsage.PrintEx(printer); printer.Println();
        printer.Print("parameterList = "); ParameterList.PrintEx(printer); printer.Println();
        printer.Print("newParameterList = "); _NewParameterList.PrintEx(printer); printer.Println();
        printer.Print("previewText = "); _PreviewText.PrintEx(printer); printer.Println();
        printer.Print("language = "); Language.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class IntroduceFieldModel : AbstractPage
   {
    //fields
    [NotNull] public List<string> AccessModifierNames {get; private set;}
    [NotNull] public IRdProperty<string> NewName { get { return _NewName; }}
    [NotNull] private readonly RdProperty<string> _NewName;
    [NotNull] public IRdProperty<IntroduceFieldModelSuggestions> NameSuggestions { get { return _NameSuggestions; }}
    [NotNull] private readonly RdProperty<IntroduceFieldModelSuggestions> _NameSuggestions;
    [NotNull] public IRdProperty<IntroduceFieldTypeEnum> IntroduceType { get { return _IntroduceType; }}
    [NotNull] private readonly RdProperty<IntroduceFieldTypeEnum> _IntroduceType;
    [NotNull] public IRdProperty<IntroduceFieldVisibility> Visibility { get { return _Visibility; }}
    [NotNull] private readonly RdProperty<IntroduceFieldVisibility> _Visibility;
    [NotNull] public IRdProperty<bool> MakeStatic { get { return _MakeStatic; }}
    [NotNull] private readonly RdProperty<bool> _MakeStatic;
    [NotNull] public IRdProperty<bool> MakeReadonly { get { return _MakeReadonly; }}
    [NotNull] private readonly RdProperty<bool> _MakeReadonly;
    [NotNull] public IRdProperty<bool> MemberEnabled { get { return _MemberEnabled; }}
    [NotNull] private readonly RdProperty<bool> _MemberEnabled;
    [NotNull] public IRdProperty<bool> InitializerEnabled { get { return _InitializerEnabled; }}
    [NotNull] private readonly RdProperty<bool> _InitializerEnabled;
    [NotNull] public IRdProperty<bool> ConstructorEnabled { get { return _ConstructorEnabled; }}
    [NotNull] private readonly RdProperty<bool> _ConstructorEnabled;
    [NotNull] public IRdProperty<bool> ConstantEnabled { get { return _ConstantEnabled; }}
    [NotNull] private readonly RdProperty<bool> _ConstantEnabled;
    [NotNull] public IRdProperty<bool> StaticEnabled { get { return _StaticEnabled; }}
    [NotNull] private readonly RdProperty<bool> _StaticEnabled;
    [NotNull] public IRdProperty<bool> ReadonlyEnabled { get { return _ReadonlyEnabled; }}
    [NotNull] private readonly RdProperty<bool> _ReadonlyEnabled;
    
    //primary constructor
    private IntroduceFieldModel(
      [NotNull] List<string> accessModifierNames,
      [NotNull] RdProperty<string> newName,
      [NotNull] RdProperty<IntroduceFieldModelSuggestions> nameSuggestions,
      [NotNull] RdProperty<IntroduceFieldTypeEnum> introduceType,
      [NotNull] RdProperty<IntroduceFieldVisibility> visibility,
      [NotNull] RdProperty<bool> makeStatic,
      [NotNull] RdProperty<bool> makeReadonly,
      [NotNull] RdProperty<bool> memberEnabled,
      [NotNull] RdProperty<bool> initializerEnabled,
      [NotNull] RdProperty<bool> constructorEnabled,
      [NotNull] RdProperty<bool> constantEnabled,
      [NotNull] RdProperty<bool> staticEnabled,
      [NotNull] RdProperty<bool> readonlyEnabled,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      AccessModifierNames = accessModifierNames;
      _NewName = newName;
      _NameSuggestions = nameSuggestions;
      _IntroduceType = introduceType;
      _Visibility = visibility;
      _MakeStatic = makeStatic;
      _MakeReadonly = makeReadonly;
      _MemberEnabled = memberEnabled;
      _InitializerEnabled = initializerEnabled;
      _ConstructorEnabled = constructorEnabled;
      _ConstantEnabled = constantEnabled;
      _StaticEnabled = staticEnabled;
      _ReadonlyEnabled = readonlyEnabled;
      newName.OptimizeNested = true;
      introduceType.OptimizeNested = true;
      visibility.OptimizeNested = true;
      makeStatic.OptimizeNested = true;
      makeReadonly.OptimizeNested = true;
      memberEnabled.OptimizeNested = true;
      initializerEnabled.OptimizeNested = true;
      constructorEnabled.OptimizeNested = true;
      constantEnabled.OptimizeNested = true;
      staticEnabled.OptimizeNested = true;
      readonlyEnabled.OptimizeNested = true;
    }
    //secondary constructor
    public IntroduceFieldModel (
      [NotNull] List<string> AccessModifierNames,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      AccessModifierNames,
      new RdProperty<string>(),
      new RdProperty<IntroduceFieldModelSuggestions>(),
      new RdProperty<IntroduceFieldTypeEnum>(),
      new RdProperty<IntroduceFieldVisibility>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static CtxReadDelegate<IntroduceFieldTypeEnum> ReadIntroduceFieldTypeEnum = new CtxReadDelegate<IntroduceFieldTypeEnum>(Serializers.ReadEnum<IntroduceFieldTypeEnum>);
    public static CtxReadDelegate<IntroduceFieldVisibility> ReadIntroduceFieldVisibility = new CtxReadDelegate<IntroduceFieldVisibility>(Serializers.ReadEnum<IntroduceFieldVisibility>);
    public static new CtxReadDelegate<IntroduceFieldModel> Read = (ctx, reader) => 
    {
      var accessModifierNames = ReadStringList(ctx, reader);
      var newName = RdProperty<string>.Read(ctx, reader);
      var nameSuggestions = RdProperty<IntroduceFieldModelSuggestions>.Read(ctx, reader);
      var introduceType = RdProperty<IntroduceFieldTypeEnum>.Read(ctx, reader);
      var visibility = RdProperty<IntroduceFieldVisibility>.Read(ctx, reader);
      var makeStatic = RdProperty<bool>.Read(ctx, reader);
      var makeReadonly = RdProperty<bool>.Read(ctx, reader);
      var memberEnabled = RdProperty<bool>.Read(ctx, reader);
      var initializerEnabled = RdProperty<bool>.Read(ctx, reader);
      var constructorEnabled = RdProperty<bool>.Read(ctx, reader);
      var constantEnabled = RdProperty<bool>.Read(ctx, reader);
      var staticEnabled = RdProperty<bool>.Read(ctx, reader);
      var readonlyEnabled = RdProperty<bool>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new IntroduceFieldModel(accessModifierNames, newName, nameSuggestions, introduceType, visibility, makeStatic, makeReadonly, memberEnabled, initializerEnabled, constructorEnabled, constantEnabled, staticEnabled, readonlyEnabled, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static CtxWriteDelegate<IntroduceFieldTypeEnum> WriteIntroduceFieldTypeEnum = new CtxWriteDelegate<IntroduceFieldTypeEnum>(Serializers.WriteEnum<IntroduceFieldTypeEnum>);
    public static CtxWriteDelegate<IntroduceFieldVisibility> WriteIntroduceFieldVisibility = new CtxWriteDelegate<IntroduceFieldVisibility>(Serializers.WriteEnum<IntroduceFieldVisibility>);
    public static new CtxWriteDelegate<IntroduceFieldModel> Write = (ctx, writer, value) => 
    {
      WriteStringList(ctx, writer, value.AccessModifierNames);
      RdProperty<string>.Write(ctx, writer, value._NewName);
      RdProperty<IntroduceFieldModelSuggestions>.Write(ctx, writer, value._NameSuggestions);
      RdProperty<IntroduceFieldTypeEnum>.Write(ctx, writer, value._IntroduceType);
      RdProperty<IntroduceFieldVisibility>.Write(ctx, writer, value._Visibility);
      RdProperty<bool>.Write(ctx, writer, value._MakeStatic);
      RdProperty<bool>.Write(ctx, writer, value._MakeReadonly);
      RdProperty<bool>.Write(ctx, writer, value._MemberEnabled);
      RdProperty<bool>.Write(ctx, writer, value._InitializerEnabled);
      RdProperty<bool>.Write(ctx, writer, value._ConstructorEnabled);
      RdProperty<bool>.Write(ctx, writer, value._ConstantEnabled);
      RdProperty<bool>.Write(ctx, writer, value._StaticEnabled);
      RdProperty<bool>.Write(ctx, writer, value._ReadonlyEnabled);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _NewName.BindEx(lifetime, this, "newName");
      _NameSuggestions.BindEx(lifetime, this, "nameSuggestions");
      _IntroduceType.BindEx(lifetime, this, "introduceType");
      _Visibility.BindEx(lifetime, this, "visibility");
      _MakeStatic.BindEx(lifetime, this, "makeStatic");
      _MakeReadonly.BindEx(lifetime, this, "makeReadonly");
      _MemberEnabled.BindEx(lifetime, this, "memberEnabled");
      _InitializerEnabled.BindEx(lifetime, this, "initializerEnabled");
      _ConstructorEnabled.BindEx(lifetime, this, "constructorEnabled");
      _ConstantEnabled.BindEx(lifetime, this, "constantEnabled");
      _StaticEnabled.BindEx(lifetime, this, "staticEnabled");
      _ReadonlyEnabled.BindEx(lifetime, this, "readonlyEnabled");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _NewName.IdentifyEx(ids);
      _NameSuggestions.IdentifyEx(ids);
      _IntroduceType.IdentifyEx(ids);
      _Visibility.IdentifyEx(ids);
      _MakeStatic.IdentifyEx(ids);
      _MakeReadonly.IdentifyEx(ids);
      _MemberEnabled.IdentifyEx(ids);
      _InitializerEnabled.IdentifyEx(ids);
      _ConstructorEnabled.IdentifyEx(ids);
      _ConstantEnabled.IdentifyEx(ids);
      _StaticEnabled.IdentifyEx(ids);
      _ReadonlyEnabled.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("IntroduceFieldModel (");
      using (printer.IndentCookie()) {
        printer.Print("accessModifierNames = "); AccessModifierNames.PrintEx(printer); printer.Println();
        printer.Print("newName = "); _NewName.PrintEx(printer); printer.Println();
        printer.Print("nameSuggestions = "); _NameSuggestions.PrintEx(printer); printer.Println();
        printer.Print("introduceType = "); _IntroduceType.PrintEx(printer); printer.Println();
        printer.Print("visibility = "); _Visibility.PrintEx(printer); printer.Println();
        printer.Print("makeStatic = "); _MakeStatic.PrintEx(printer); printer.Println();
        printer.Print("makeReadonly = "); _MakeReadonly.PrintEx(printer); printer.Println();
        printer.Print("memberEnabled = "); _MemberEnabled.PrintEx(printer); printer.Println();
        printer.Print("initializerEnabled = "); _InitializerEnabled.PrintEx(printer); printer.Println();
        printer.Print("constructorEnabled = "); _ConstructorEnabled.PrintEx(printer); printer.Println();
        printer.Print("constantEnabled = "); _ConstantEnabled.PrintEx(printer); printer.Println();
        printer.Print("staticEnabled = "); _StaticEnabled.PrintEx(printer); printer.Println();
        printer.Print("readonlyEnabled = "); _ReadonlyEnabled.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class IntroduceFieldModelSuggestions : RdBindableBase {
    //fields
    [NotNull] public List<string> Suggestions {get; private set;}
    
    //primary constructor
    public IntroduceFieldModelSuggestions(
      [NotNull] List<string> suggestions
    )
    {
      Suggestions = suggestions;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static CtxReadDelegate<IntroduceFieldModelSuggestions> Read = (ctx, reader) => 
    {
      var suggestions = ReadStringList(ctx, reader);
      return new IntroduceFieldModelSuggestions(suggestions);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static CtxWriteDelegate<IntroduceFieldModelSuggestions> Write = (ctx, writer, value) => 
    {
      WriteStringList(ctx, writer, value.Suggestions);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("IntroduceFieldModelSuggestions (");
      using (printer.IndentCookie()) {
        printer.Print("suggestions = "); Suggestions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum IntroduceFieldTypeEnum {
    Member,
    Initializer,
    Constructor,
    Constant
  }
  
  
  public enum IntroduceFieldVisibility {
    Private,
    Protected,
    ProtectedOrInternal,
    Internal,
    Public
  }
  
  
  public class IntroduceParameterElementModel : RdBindableBase {
    //fields
    [NotNull] public string ElementName {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public IRdProperty<bool> IsEnabled { get { return _IsEnabled; }}
    [NotNull] private readonly RdProperty<bool> _IsEnabled;
    
    //primary constructor
    private IntroduceParameterElementModel(
      [NotNull] string elementName,
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<bool> isEnabled
    )
    {
      ElementName = elementName;
      Icon = icon;
      _IsEnabled = isEnabled;
      isEnabled.OptimizeNested = true;
    }
    //secondary constructor
    public IntroduceParameterElementModel (
      [NotNull] string ElementName,
      [NotNull] JetBrains.Rider.Model.Icon Icon
    ) : this (
      ElementName,
      Icon,
      new RdProperty<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<IntroduceParameterElementModel> Read = (ctx, reader) => 
    {
      var elementName = reader.ReadString();
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader);
      return new IntroduceParameterElementModel(elementName, icon, isEnabled);
    };
    
    public static CtxWriteDelegate<IntroduceParameterElementModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ElementName);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _IsEnabled.BindEx(lifetime, this, "isEnabled");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _IsEnabled.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("IntroduceParameterElementModel (");
      using (printer.IndentCookie()) {
        printer.Print("elementName = "); ElementName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class IntroduceParameterModel : AbstractPage
   {
    //fields
    [NotNull] public List<string> Suggestions {get; private set;}
    public bool CanBeMadeDefault {get; private set;}
    [NotNull] public IRdProperty<string> NewName { get { return _NewName; }}
    [NotNull] private readonly RdProperty<string> _NewName;
    [NotNull] public IRdProperty<string> TypePreview { get { return _TypePreview; }}
    [NotNull] private readonly RdProperty<string> _TypePreview;
    [NotNull] public IRdProperty<bool> MakeDefault { get { return _MakeDefault; }}
    [NotNull] private readonly RdProperty<bool> _MakeDefault;
    [NotNull] public List<IntroduceParameterElementModel> RemovableParameters {get; private set;}
    [NotNull] public List<IntroduceParameterElementModel> LambdaParameters {get; private set;}
    
    //primary constructor
    private IntroduceParameterModel(
      [NotNull] List<string> suggestions,
      bool canBeMadeDefault,
      [NotNull] RdProperty<string> newName,
      [NotNull] RdProperty<string> typePreview,
      [NotNull] RdProperty<bool> makeDefault,
      [NotNull] List<IntroduceParameterElementModel> removableParameters,
      [NotNull] List<IntroduceParameterElementModel> lambdaParameters,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      Suggestions = suggestions;
      CanBeMadeDefault = canBeMadeDefault;
      _NewName = newName;
      _TypePreview = typePreview;
      _MakeDefault = makeDefault;
      RemovableParameters = removableParameters;
      LambdaParameters = lambdaParameters;
      newName.OptimizeNested = true;
      typePreview.OptimizeNested = true;
      makeDefault.OptimizeNested = true;
    }
    //secondary constructor
    public IntroduceParameterModel (
      [NotNull] List<string> Suggestions,
      bool CanBeMadeDefault,
      [NotNull] List<IntroduceParameterElementModel> RemovableParameters,
      [NotNull] List<IntroduceParameterElementModel> LambdaParameters,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      Suggestions,
      CanBeMadeDefault,
      new RdProperty<string>(),
      new RdProperty<string>(),
      new RdProperty<bool>(),
      RemovableParameters,
      LambdaParameters,
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static CtxReadDelegate<List<IntroduceParameterElementModel>> ReadIntroduceParameterElementModelList = IntroduceParameterElementModel.Read.List();
    public static new CtxReadDelegate<IntroduceParameterModel> Read = (ctx, reader) => 
    {
      var suggestions = ReadStringList(ctx, reader);
      var canBeMadeDefault = reader.ReadBool();
      var newName = RdProperty<string>.Read(ctx, reader);
      var typePreview = RdProperty<string>.Read(ctx, reader);
      var makeDefault = RdProperty<bool>.Read(ctx, reader);
      var removableParameters = ReadIntroduceParameterElementModelList(ctx, reader);
      var lambdaParameters = ReadIntroduceParameterElementModelList(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new IntroduceParameterModel(suggestions, canBeMadeDefault, newName, typePreview, makeDefault, removableParameters, lambdaParameters, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static CtxWriteDelegate<List<IntroduceParameterElementModel>> WriteIntroduceParameterElementModelList = IntroduceParameterElementModel.Write.List();
    public static new CtxWriteDelegate<IntroduceParameterModel> Write = (ctx, writer, value) => 
    {
      WriteStringList(ctx, writer, value.Suggestions);
      writer.Write(value.CanBeMadeDefault);
      RdProperty<string>.Write(ctx, writer, value._NewName);
      RdProperty<string>.Write(ctx, writer, value._TypePreview);
      RdProperty<bool>.Write(ctx, writer, value._MakeDefault);
      WriteIntroduceParameterElementModelList(ctx, writer, value.RemovableParameters);
      WriteIntroduceParameterElementModelList(ctx, writer, value.LambdaParameters);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _NewName.BindEx(lifetime, this, "newName");
      _TypePreview.BindEx(lifetime, this, "typePreview");
      _MakeDefault.BindEx(lifetime, this, "makeDefault");
      RemovableParameters.BindEx(lifetime, this, "removableParameters");
      LambdaParameters.BindEx(lifetime, this, "lambdaParameters");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _NewName.IdentifyEx(ids);
      _TypePreview.IdentifyEx(ids);
      _MakeDefault.IdentifyEx(ids);
      RemovableParameters.IdentifyEx(ids);
      LambdaParameters.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("IntroduceParameterModel (");
      using (printer.IndentCookie()) {
        printer.Print("suggestions = "); Suggestions.PrintEx(printer); printer.Println();
        printer.Print("canBeMadeDefault = "); CanBeMadeDefault.PrintEx(printer); printer.Println();
        printer.Print("newName = "); _NewName.PrintEx(printer); printer.Println();
        printer.Print("typePreview = "); _TypePreview.PrintEx(printer); printer.Println();
        printer.Print("makeDefault = "); _MakeDefault.PrintEx(printer); printer.Println();
        printer.Print("removableParameters = "); RemovableParameters.PrintEx(printer); printer.Println();
        printer.Print("lambdaParameters = "); LambdaParameters.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class LinkInfo : IPrintable, IEquatable<LinkInfo> {
    //fields
    public int Row {get; private set;}
    public int LinkInRow {get; private set;}
    
    //primary constructor
    public LinkInfo(
      int row,
      int linkInRow
    )
    {
      Row = row;
      LinkInRow = linkInRow;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<LinkInfo> Read = (ctx, reader) => 
    {
      var row = reader.ReadInt();
      var linkInRow = reader.ReadInt();
      return new LinkInfo(row, linkInRow);
    };
    
    public static CtxWriteDelegate<LinkInfo> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Row);
      writer.Write(value.LinkInRow);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((LinkInfo) obj);
    }
    public bool Equals(LinkInfo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Row == other.Row && LinkInRow == other.LinkInRow;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Row.GetHashCode();
        __r = __r*31 + LinkInRow.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("LinkInfo (");
      using (printer.IndentCookie()) {
        printer.Print("row = "); Row.PrintEx(printer); printer.Println();
        printer.Print("linkInRow = "); LinkInRow.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MakeStaticModel : AbstractPage
   {
    //fields
    public bool CanUseParams {get; private set;}
    public bool IsNotAddingParametersSafe {get; private set;}
    public bool CanAddParameters {get; private set;}
    [NotNull] public List<MakeStaticModelParamModel> ParamList {get; private set;}
    [NotNull] public IRdProperty<string> NewName { get { return _NewName; }}
    [NotNull] private readonly RdProperty<string> _NewName;
    [NotNull] public IRdProperty<MakeStaticOption> SelectedOption { get { return _SelectedOption; }}
    [NotNull] private readonly RdProperty<MakeStaticOption> _SelectedOption;
    
    //primary constructor
    private MakeStaticModel(
      bool canUseParams,
      bool isNotAddingParametersSafe,
      bool canAddParameters,
      [NotNull] List<MakeStaticModelParamModel> paramList,
      [NotNull] RdProperty<string> newName,
      [NotNull] RdProperty<MakeStaticOption> selectedOption,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      CanUseParams = canUseParams;
      IsNotAddingParametersSafe = isNotAddingParametersSafe;
      CanAddParameters = canAddParameters;
      ParamList = paramList;
      _NewName = newName;
      _SelectedOption = selectedOption;
      newName.OptimizeNested = true;
      selectedOption.OptimizeNested = true;
    }
    //secondary constructor
    public MakeStaticModel (
      bool CanUseParams,
      bool IsNotAddingParametersSafe,
      bool CanAddParameters,
      [NotNull] List<MakeStaticModelParamModel> ParamList,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      CanUseParams,
      IsNotAddingParametersSafe,
      CanAddParameters,
      ParamList,
      new RdProperty<string>(),
      new RdProperty<MakeStaticOption>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<MakeStaticModelParamModel>> ReadMakeStaticModelParamModelList = MakeStaticModelParamModel.Read.List();
    public static CtxReadDelegate<MakeStaticOption> ReadMakeStaticOption = new CtxReadDelegate<MakeStaticOption>(Serializers.ReadEnum<MakeStaticOption>);
    public static new CtxReadDelegate<MakeStaticModel> Read = (ctx, reader) => 
    {
      var canUseParams = reader.ReadBool();
      var isNotAddingParametersSafe = reader.ReadBool();
      var canAddParameters = reader.ReadBool();
      var paramList = ReadMakeStaticModelParamModelList(ctx, reader);
      var newName = RdProperty<string>.Read(ctx, reader);
      var selectedOption = RdProperty<MakeStaticOption>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new MakeStaticModel(canUseParams, isNotAddingParametersSafe, canAddParameters, paramList, newName, selectedOption, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<MakeStaticModelParamModel>> WriteMakeStaticModelParamModelList = MakeStaticModelParamModel.Write.List();
    public static CtxWriteDelegate<MakeStaticOption> WriteMakeStaticOption = new CtxWriteDelegate<MakeStaticOption>(Serializers.WriteEnum<MakeStaticOption>);
    public static new CtxWriteDelegate<MakeStaticModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.CanUseParams);
      writer.Write(value.IsNotAddingParametersSafe);
      writer.Write(value.CanAddParameters);
      WriteMakeStaticModelParamModelList(ctx, writer, value.ParamList);
      RdProperty<string>.Write(ctx, writer, value._NewName);
      RdProperty<MakeStaticOption>.Write(ctx, writer, value._SelectedOption);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      ParamList.BindEx(lifetime, this, "paramList");
      _NewName.BindEx(lifetime, this, "newName");
      _SelectedOption.BindEx(lifetime, this, "selectedOption");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      ParamList.IdentifyEx(ids);
      _NewName.IdentifyEx(ids);
      _SelectedOption.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MakeStaticModel (");
      using (printer.IndentCookie()) {
        printer.Print("canUseParams = "); CanUseParams.PrintEx(printer); printer.Println();
        printer.Print("isNotAddingParametersSafe = "); IsNotAddingParametersSafe.PrintEx(printer); printer.Println();
        printer.Print("canAddParameters = "); CanAddParameters.PrintEx(printer); printer.Println();
        printer.Print("paramList = "); ParamList.PrintEx(printer); printer.Println();
        printer.Print("newName = "); _NewName.PrintEx(printer); printer.Println();
        printer.Print("selectedOption = "); _SelectedOption.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MakeStaticModelParamModel : RdBindableBase {
    //fields
    [NotNull] public string Text {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public IRdProperty<bool> IsSelected { get { return _IsSelected; }}
    [NotNull] private readonly RdProperty<bool> _IsSelected;
    
    //primary constructor
    private MakeStaticModelParamModel(
      [NotNull] string text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<bool> isSelected
    )
    {
      Text = text;
      Icon = icon;
      _IsSelected = isSelected;
      isSelected.OptimizeNested = true;
    }
    //secondary constructor
    public MakeStaticModelParamModel (
      [NotNull] string Text,
      [CanBeNull] JetBrains.Rider.Model.Icon Icon
    ) : this (
      Text,
      Icon,
      new RdProperty<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<MakeStaticModelParamModel> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var isSelected = RdProperty<bool>.Read(ctx, reader);
      return new MakeStaticModelParamModel(text, icon, isSelected);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<MakeStaticModelParamModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
      WriteIconNullable(ctx, writer, value.Icon);
      RdProperty<bool>.Write(ctx, writer, value._IsSelected);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _IsSelected.BindEx(lifetime, this, "isSelected");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _IsSelected.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MakeStaticModelParamModel (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("isSelected = "); _IsSelected.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum MakeStaticOption {
    NoParameters,
    AddThis,
    AddParams
  }
  
  
  public class MessageBoxOK : IPrintable, IEquatable<MessageBoxOK> {
    //fields
    [NotNull] public string Title {get; private set;}
    [NotNull] public string Message {get; private set;}
    
    //primary constructor
    public MessageBoxOK(
      [NotNull] string title,
      [NotNull] string message
    )
    {
      Title = title;
      Message = message;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<MessageBoxOK> Read = (ctx, reader) => 
    {
      var title = reader.ReadString();
      var message = reader.ReadString();
      return new MessageBoxOK(title, message);
    };
    
    public static CtxWriteDelegate<MessageBoxOK> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Title);
      writer.Write(value.Message);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MessageBoxOK) obj);
    }
    public bool Equals(MessageBoxOK other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Title == other.Title && Message == other.Message;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Title.GetHashCode();
        __r = __r*31 + Message.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MessageBoxOK (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MethodToPropertyModel : AbstractPage
   {
    //fields
    public bool CanBeDefault {get; private set;}
    [NotNull] public string LabelText {get; private set;}
    [NotNull] public IRdProperty<string> NewName { get { return _NewName; }}
    [NotNull] private readonly RdProperty<string> _NewName;
    [NotNull] public IRdProperty<bool> CreateDefault { get { return _CreateDefault; }}
    [NotNull] private readonly RdProperty<bool> _CreateDefault;
    
    //primary constructor
    private MethodToPropertyModel(
      bool canBeDefault,
      [NotNull] string labelText,
      [NotNull] RdProperty<string> newName,
      [NotNull] RdProperty<bool> createDefault,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      CanBeDefault = canBeDefault;
      LabelText = labelText;
      _NewName = newName;
      _CreateDefault = createDefault;
      newName.OptimizeNested = true;
      createDefault.OptimizeNested = true;
    }
    //secondary constructor
    public MethodToPropertyModel (
      bool CanBeDefault,
      [NotNull] string LabelText,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      CanBeDefault,
      LabelText,
      new RdProperty<string>(),
      new RdProperty<bool>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static new CtxReadDelegate<MethodToPropertyModel> Read = (ctx, reader) => 
    {
      var canBeDefault = reader.ReadBool();
      var labelText = reader.ReadString();
      var newName = RdProperty<string>.Read(ctx, reader);
      var createDefault = RdProperty<bool>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new MethodToPropertyModel(canBeDefault, labelText, newName, createDefault, title, description, continueEnabled, validationResult);
    };
    
    public static new CtxWriteDelegate<MethodToPropertyModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.CanBeDefault);
      writer.Write(value.LabelText);
      RdProperty<string>.Write(ctx, writer, value._NewName);
      RdProperty<bool>.Write(ctx, writer, value._CreateDefault);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _NewName.BindEx(lifetime, this, "newName");
      _CreateDefault.BindEx(lifetime, this, "createDefault");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _NewName.IdentifyEx(ids);
      _CreateDefault.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MethodToPropertyModel (");
      using (printer.IndentCookie()) {
        printer.Print("canBeDefault = "); CanBeDefault.PrintEx(printer); printer.Println();
        printer.Print("labelText = "); LabelText.PrintEx(printer); printer.Println();
        printer.Print("newName = "); _NewName.PrintEx(printer); printer.Println();
        printer.Print("createDefault = "); _CreateDefault.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MoveConflictsConflictModel : RdBindableBase {
    //fields
    [NotNull] public string Text {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    public int ParentId {get; private set;}
    [NotNull] public IVoidSink Navigate { get { return _Navigate; }}
    [NotNull] private readonly RdVoidSignal _Navigate;
    
    //primary constructor
    private MoveConflictsConflictModel(
      [NotNull] string text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      int parentId,
      [NotNull] RdVoidSignal navigate
    )
    {
      Text = text;
      Icon = icon;
      ParentId = parentId;
      _Navigate = navigate;
    }
    //secondary constructor
    public MoveConflictsConflictModel (
      [NotNull] string Text,
      [CanBeNull] JetBrains.Rider.Model.Icon Icon,
      int ParentId
    ) : this (
      Text,
      Icon,
      ParentId,
      new RdVoidSignal()
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<MoveConflictsConflictModel> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var parentId = reader.ReadInt();
      var navigate = RdVoidSignal.Read(ctx, reader);
      return new MoveConflictsConflictModel(text, icon, parentId, navigate);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<MoveConflictsConflictModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
      WriteIconNullable(ctx, writer, value.Icon);
      writer.Write(value.ParentId);
      RdVoidSignal.Write(ctx, writer, value._Navigate);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Navigate.BindEx(lifetime, this, "navigate");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Navigate.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MoveConflictsConflictModel (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("parentId = "); ParentId.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MoveConflictsModel : AbstractPage
   {
    //fields
    [NotNull] public List<MoveConflictsConflictModel> Conflicts {get; private set;}
    
    //primary constructor
    private MoveConflictsModel(
      [NotNull] List<MoveConflictsConflictModel> conflicts,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      Conflicts = conflicts;
    }
    //secondary constructor
    public MoveConflictsModel (
      [NotNull] List<MoveConflictsConflictModel> Conflicts,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      Conflicts,
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<MoveConflictsConflictModel>> ReadMoveConflictsConflictModelList = MoveConflictsConflictModel.Read.List();
    public static new CtxReadDelegate<MoveConflictsModel> Read = (ctx, reader) => 
    {
      var conflicts = ReadMoveConflictsConflictModelList(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new MoveConflictsModel(conflicts, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<MoveConflictsConflictModel>> WriteMoveConflictsConflictModelList = MoveConflictsConflictModel.Write.List();
    public static new CtxWriteDelegate<MoveConflictsModel> Write = (ctx, writer, value) => 
    {
      WriteMoveConflictsConflictModelList(ctx, writer, value.Conflicts);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Conflicts.BindEx(lifetime, this, "conflicts");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Conflicts.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MoveConflictsModel (");
      using (printer.IndentCookie()) {
        printer.Print("conflicts = "); Conflicts.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MoveFileRemoveEmptyFileModel : AbstractPage
   {
    //fields
    [NotNull] public IRdProperty<bool> DoRemove { get { return _DoRemove; }}
    [NotNull] private readonly RdProperty<bool> _DoRemove;
    
    //primary constructor
    private MoveFileRemoveEmptyFileModel(
      [NotNull] RdProperty<bool> doRemove,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      _DoRemove = doRemove;
      doRemove.OptimizeNested = true;
    }
    //secondary constructor
    public MoveFileRemoveEmptyFileModel (
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      new RdProperty<bool>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static new CtxReadDelegate<MoveFileRemoveEmptyFileModel> Read = (ctx, reader) => 
    {
      var doRemove = RdProperty<bool>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new MoveFileRemoveEmptyFileModel(doRemove, title, description, continueEnabled, validationResult);
    };
    
    public static new CtxWriteDelegate<MoveFileRemoveEmptyFileModel> Write = (ctx, writer, value) => 
    {
      RdProperty<bool>.Write(ctx, writer, value._DoRemove);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _DoRemove.BindEx(lifetime, this, "doRemove");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _DoRemove.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MoveFileRemoveEmptyFileModel (");
      using (printer.IndentCookie()) {
        printer.Print("doRemove = "); _DoRemove.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MoveIntoMatchingFilesModel : AbstractPage
   {
    //fields
    public bool CanMoveDelegates {get; private set;}
    public bool CanMoveClasses {get; private set;}
    public bool CanMoveEnums {get; private set;}
    public bool CanRenameFiles {get; private set;}
    [NotNull] public IRdProperty<bool> MoveDelegates { get { return _MoveDelegates; }}
    [NotNull] private readonly RdProperty<bool> _MoveDelegates;
    [NotNull] public IRdProperty<bool> MoveClasses { get { return _MoveClasses; }}
    [NotNull] private readonly RdProperty<bool> _MoveClasses;
    [NotNull] public IRdProperty<bool> MoveEnums { get { return _MoveEnums; }}
    [NotNull] private readonly RdProperty<bool> _MoveEnums;
    [NotNull] public IRdProperty<bool> RenameFiles { get { return _RenameFiles; }}
    [NotNull] private readonly RdProperty<bool> _RenameFiles;
    
    //primary constructor
    private MoveIntoMatchingFilesModel(
      bool canMoveDelegates,
      bool canMoveClasses,
      bool canMoveEnums,
      bool canRenameFiles,
      [NotNull] RdProperty<bool> moveDelegates,
      [NotNull] RdProperty<bool> moveClasses,
      [NotNull] RdProperty<bool> moveEnums,
      [NotNull] RdProperty<bool> renameFiles,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      CanMoveDelegates = canMoveDelegates;
      CanMoveClasses = canMoveClasses;
      CanMoveEnums = canMoveEnums;
      CanRenameFiles = canRenameFiles;
      _MoveDelegates = moveDelegates;
      _MoveClasses = moveClasses;
      _MoveEnums = moveEnums;
      _RenameFiles = renameFiles;
      moveDelegates.OptimizeNested = true;
      moveClasses.OptimizeNested = true;
      moveEnums.OptimizeNested = true;
      renameFiles.OptimizeNested = true;
    }
    //secondary constructor
    public MoveIntoMatchingFilesModel (
      bool CanMoveDelegates,
      bool CanMoveClasses,
      bool CanMoveEnums,
      bool CanRenameFiles,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      CanMoveDelegates,
      CanMoveClasses,
      CanMoveEnums,
      CanRenameFiles,
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static new CtxReadDelegate<MoveIntoMatchingFilesModel> Read = (ctx, reader) => 
    {
      var canMoveDelegates = reader.ReadBool();
      var canMoveClasses = reader.ReadBool();
      var canMoveEnums = reader.ReadBool();
      var canRenameFiles = reader.ReadBool();
      var moveDelegates = RdProperty<bool>.Read(ctx, reader);
      var moveClasses = RdProperty<bool>.Read(ctx, reader);
      var moveEnums = RdProperty<bool>.Read(ctx, reader);
      var renameFiles = RdProperty<bool>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new MoveIntoMatchingFilesModel(canMoveDelegates, canMoveClasses, canMoveEnums, canRenameFiles, moveDelegates, moveClasses, moveEnums, renameFiles, title, description, continueEnabled, validationResult);
    };
    
    public static new CtxWriteDelegate<MoveIntoMatchingFilesModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.CanMoveDelegates);
      writer.Write(value.CanMoveClasses);
      writer.Write(value.CanMoveEnums);
      writer.Write(value.CanRenameFiles);
      RdProperty<bool>.Write(ctx, writer, value._MoveDelegates);
      RdProperty<bool>.Write(ctx, writer, value._MoveClasses);
      RdProperty<bool>.Write(ctx, writer, value._MoveEnums);
      RdProperty<bool>.Write(ctx, writer, value._RenameFiles);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _MoveDelegates.BindEx(lifetime, this, "moveDelegates");
      _MoveClasses.BindEx(lifetime, this, "moveClasses");
      _MoveEnums.BindEx(lifetime, this, "moveEnums");
      _RenameFiles.BindEx(lifetime, this, "renameFiles");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _MoveDelegates.IdentifyEx(ids);
      _MoveClasses.IdentifyEx(ids);
      _MoveEnums.IdentifyEx(ids);
      _RenameFiles.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MoveIntoMatchingFilesModel (");
      using (printer.IndentCookie()) {
        printer.Print("canMoveDelegates = "); CanMoveDelegates.PrintEx(printer); printer.Println();
        printer.Print("canMoveClasses = "); CanMoveClasses.PrintEx(printer); printer.Println();
        printer.Print("canMoveEnums = "); CanMoveEnums.PrintEx(printer); printer.Println();
        printer.Print("canRenameFiles = "); CanRenameFiles.PrintEx(printer); printer.Println();
        printer.Print("moveDelegates = "); _MoveDelegates.PrintEx(printer); printer.Println();
        printer.Print("moveClasses = "); _MoveClasses.PrintEx(printer); printer.Println();
        printer.Print("moveEnums = "); _MoveEnums.PrintEx(printer); printer.Println();
        printer.Print("renameFiles = "); _RenameFiles.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MoveStaticMemberMemberModel : RdBindableBase {
    //fields
    [NotNull] public string MemberName {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public IRdProperty<bool> IsSelected { get { return _IsSelected; }}
    [NotNull] private readonly RdProperty<bool> _IsSelected;
    [NotNull] public IVoidSink Navigate { get { return _Navigate; }}
    [NotNull] private readonly RdVoidSignal _Navigate;
    
    //primary constructor
    private MoveStaticMemberMemberModel(
      [NotNull] string memberName,
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<bool> isSelected,
      [NotNull] RdVoidSignal navigate
    )
    {
      MemberName = memberName;
      Icon = icon;
      _IsSelected = isSelected;
      _Navigate = navigate;
      isSelected.OptimizeNested = true;
    }
    //secondary constructor
    public MoveStaticMemberMemberModel (
      [NotNull] string MemberName,
      [NotNull] JetBrains.Rider.Model.Icon Icon
    ) : this (
      MemberName,
      Icon,
      new RdProperty<bool>(),
      new RdVoidSignal()
    ) {}
    //statics
    
    public static CtxReadDelegate<MoveStaticMemberMemberModel> Read = (ctx, reader) => 
    {
      var memberName = reader.ReadString();
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var isSelected = RdProperty<bool>.Read(ctx, reader);
      var navigate = RdVoidSignal.Read(ctx, reader);
      return new MoveStaticMemberMemberModel(memberName, icon, isSelected, navigate);
    };
    
    public static CtxWriteDelegate<MoveStaticMemberMemberModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.MemberName);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      RdProperty<bool>.Write(ctx, writer, value._IsSelected);
      RdVoidSignal.Write(ctx, writer, value._Navigate);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _IsSelected.BindEx(lifetime, this, "isSelected");
      _Navigate.BindEx(lifetime, this, "navigate");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _IsSelected.IdentifyEx(ids);
      _Navigate.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MoveStaticMemberMemberModel (");
      using (printer.IndentCookie()) {
        printer.Print("memberName = "); MemberName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("isSelected = "); _IsSelected.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MoveStaticMemberModel : AbstractPage
   {
    //fields
    [NotNull] public string SourceType {get; private set;}
    [NotNull] public IRdProperty<string> TargetName { get { return _TargetName; }}
    [NotNull] private readonly RdProperty<string> _TargetName;
    [NotNull] public IRdProperty<MoveStaticMemberVisibility> Visibility { get { return _Visibility; }}
    [NotNull] private readonly RdProperty<MoveStaticMemberVisibility> _Visibility;
    [NotNull] public List<MoveStaticMemberMemberModel> Members {get; private set;}
    [NotNull] public IRdProperty<RefactoringCompletionList> CompletionList { get { return _CompletionList; }}
    [NotNull] private readonly RdProperty<RefactoringCompletionList> _CompletionList;
    
    //primary constructor
    private MoveStaticMemberModel(
      [NotNull] string sourceType,
      [NotNull] RdProperty<string> targetName,
      [NotNull] RdProperty<MoveStaticMemberVisibility> visibility,
      [NotNull] List<MoveStaticMemberMemberModel> members,
      [NotNull] RdProperty<RefactoringCompletionList> completionList,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      SourceType = sourceType;
      _TargetName = targetName;
      _Visibility = visibility;
      Members = members;
      _CompletionList = completionList;
      targetName.OptimizeNested = true;
      visibility.OptimizeNested = true;
    }
    //secondary constructor
    public MoveStaticMemberModel (
      [NotNull] string SourceType,
      [NotNull] List<MoveStaticMemberMemberModel> Members,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      SourceType,
      new RdProperty<string>(),
      new RdProperty<MoveStaticMemberVisibility>(),
      Members,
      new RdProperty<RefactoringCompletionList>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<MoveStaticMemberVisibility> ReadMoveStaticMemberVisibility = new CtxReadDelegate<MoveStaticMemberVisibility>(Serializers.ReadEnum<MoveStaticMemberVisibility>);
    public static CtxReadDelegate<List<MoveStaticMemberMemberModel>> ReadMoveStaticMemberMemberModelList = MoveStaticMemberMemberModel.Read.List();
    public static new CtxReadDelegate<MoveStaticMemberModel> Read = (ctx, reader) => 
    {
      var sourceType = reader.ReadString();
      var targetName = RdProperty<string>.Read(ctx, reader);
      var visibility = RdProperty<MoveStaticMemberVisibility>.Read(ctx, reader);
      var members = ReadMoveStaticMemberMemberModelList(ctx, reader);
      var completionList = RdProperty<RefactoringCompletionList>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new MoveStaticMemberModel(sourceType, targetName, visibility, members, completionList, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<MoveStaticMemberVisibility> WriteMoveStaticMemberVisibility = new CtxWriteDelegate<MoveStaticMemberVisibility>(Serializers.WriteEnum<MoveStaticMemberVisibility>);
    public static CtxWriteDelegate<List<MoveStaticMemberMemberModel>> WriteMoveStaticMemberMemberModelList = MoveStaticMemberMemberModel.Write.List();
    public static new CtxWriteDelegate<MoveStaticMemberModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.SourceType);
      RdProperty<string>.Write(ctx, writer, value._TargetName);
      RdProperty<MoveStaticMemberVisibility>.Write(ctx, writer, value._Visibility);
      WriteMoveStaticMemberMemberModelList(ctx, writer, value.Members);
      RdProperty<RefactoringCompletionList>.Write(ctx, writer, value._CompletionList);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _TargetName.BindEx(lifetime, this, "targetName");
      _Visibility.BindEx(lifetime, this, "visibility");
      Members.BindEx(lifetime, this, "members");
      _CompletionList.BindEx(lifetime, this, "completionList");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _TargetName.IdentifyEx(ids);
      _Visibility.IdentifyEx(ids);
      Members.IdentifyEx(ids);
      _CompletionList.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MoveStaticMemberModel (");
      using (printer.IndentCookie()) {
        printer.Print("sourceType = "); SourceType.PrintEx(printer); printer.Println();
        printer.Print("targetName = "); _TargetName.PrintEx(printer); printer.Println();
        printer.Print("visibility = "); _Visibility.PrintEx(printer); printer.Println();
        printer.Print("members = "); Members.PrintEx(printer); printer.Println();
        printer.Print("completionList = "); _CompletionList.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum MoveStaticMemberVisibility {
    AsIs,
    Public,
    Private,
    Protected,
    Internal,
    ProtectedInternal
  }
  
  
  public class MoveToFolderModel : AbstractPage
   {
    //fields
    [NotNull] public IRdProperty<string> FolderName { get { return _FolderName; }}
    [NotNull] private readonly RdProperty<string> _FolderName;
    [NotNull] public IRdProperty<RefactoringCompletionList> CompletionList { get { return _CompletionList; }}
    [NotNull] private readonly RdProperty<RefactoringCompletionList> _CompletionList;
    [NotNull] public IRdProperty<bool> CreateEnabled { get { return _CreateEnabled; }}
    [NotNull] private readonly RdProperty<bool> _CreateEnabled;
    [NotNull] public IVoidSink CreateClicked { get { return _CreateClicked; }}
    [NotNull] private readonly RdVoidSignal _CreateClicked;
    public bool FixNamespacesVisible {get; private set;}
    public bool SearchInRelatedFilesVisible {get; private set;}
    [NotNull] public IRdProperty<bool> FixVisibility { get { return _FixVisibility; }}
    [NotNull] private readonly RdProperty<bool> _FixVisibility;
    [NotNull] public IRdProperty<bool> FixNamespaces { get { return _FixNamespaces; }}
    [NotNull] private readonly RdProperty<bool> _FixNamespaces;
    [NotNull] public IRdProperty<bool> SearchInRelatedFiles { get { return _SearchInRelatedFiles; }}
    [NotNull] private readonly RdProperty<bool> _SearchInRelatedFiles;
    [NotNull] public IRdProperty<bool> MoveToSeparateFiles { get { return _MoveToSeparateFiles; }}
    [NotNull] private readonly RdProperty<bool> _MoveToSeparateFiles;
    [NotNull] public List<MoveToFolderTreeElement> ElementsTree {get; private set;}
    [NotNull] public IRdProperty<string> TextfieldValidationResult { get { return _TextfieldValidationResult; }}
    [NotNull] private readonly RdProperty<string> _TextfieldValidationResult;
    [NotNull] public IRdProperty<string> TreeValidationResult { get { return _TreeValidationResult; }}
    [NotNull] private readonly RdProperty<string> _TreeValidationResult;
    
    //primary constructor
    private MoveToFolderModel(
      [NotNull] RdProperty<string> folderName,
      [NotNull] RdProperty<RefactoringCompletionList> completionList,
      [NotNull] RdProperty<bool> createEnabled,
      [NotNull] RdVoidSignal createClicked,
      bool fixNamespacesVisible,
      bool searchInRelatedFilesVisible,
      [NotNull] RdProperty<bool> fixVisibility,
      [NotNull] RdProperty<bool> fixNamespaces,
      [NotNull] RdProperty<bool> searchInRelatedFiles,
      [NotNull] RdProperty<bool> moveToSeparateFiles,
      [NotNull] List<MoveToFolderTreeElement> elementsTree,
      [NotNull] RdProperty<string> textfieldValidationResult,
      [NotNull] RdProperty<string> treeValidationResult,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      _FolderName = folderName;
      _CompletionList = completionList;
      _CreateEnabled = createEnabled;
      _CreateClicked = createClicked;
      FixNamespacesVisible = fixNamespacesVisible;
      SearchInRelatedFilesVisible = searchInRelatedFilesVisible;
      _FixVisibility = fixVisibility;
      _FixNamespaces = fixNamespaces;
      _SearchInRelatedFiles = searchInRelatedFiles;
      _MoveToSeparateFiles = moveToSeparateFiles;
      ElementsTree = elementsTree;
      _TextfieldValidationResult = textfieldValidationResult;
      _TreeValidationResult = treeValidationResult;
      folderName.OptimizeNested = true;
      createEnabled.OptimizeNested = true;
      fixVisibility.OptimizeNested = true;
      fixNamespaces.OptimizeNested = true;
      searchInRelatedFiles.OptimizeNested = true;
      moveToSeparateFiles.OptimizeNested = true;
      textfieldValidationResult.OptimizeNested = true;
      treeValidationResult.OptimizeNested = true;
    }
    //secondary constructor
    public MoveToFolderModel (
      bool FixNamespacesVisible,
      bool SearchInRelatedFilesVisible,
      [NotNull] List<MoveToFolderTreeElement> ElementsTree,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      new RdProperty<string>(),
      new RdProperty<RefactoringCompletionList>(),
      new RdProperty<bool>(),
      new RdVoidSignal(),
      FixNamespacesVisible,
      SearchInRelatedFilesVisible,
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      ElementsTree,
      new RdProperty<string>(),
      new RdProperty<string>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<MoveToFolderTreeElement>> ReadMoveToFolderTreeElementList = MoveToFolderTreeElement.Read.List();
    public static new CtxReadDelegate<MoveToFolderModel> Read = (ctx, reader) => 
    {
      var folderName = RdProperty<string>.Read(ctx, reader);
      var completionList = RdProperty<RefactoringCompletionList>.Read(ctx, reader);
      var createEnabled = RdProperty<bool>.Read(ctx, reader);
      var createClicked = RdVoidSignal.Read(ctx, reader);
      var fixNamespacesVisible = reader.ReadBool();
      var searchInRelatedFilesVisible = reader.ReadBool();
      var fixVisibility = RdProperty<bool>.Read(ctx, reader);
      var fixNamespaces = RdProperty<bool>.Read(ctx, reader);
      var searchInRelatedFiles = RdProperty<bool>.Read(ctx, reader);
      var moveToSeparateFiles = RdProperty<bool>.Read(ctx, reader);
      var elementsTree = ReadMoveToFolderTreeElementList(ctx, reader);
      var textfieldValidationResult = RdProperty<string>.Read(ctx, reader);
      var treeValidationResult = RdProperty<string>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new MoveToFolderModel(folderName, completionList, createEnabled, createClicked, fixNamespacesVisible, searchInRelatedFilesVisible, fixVisibility, fixNamespaces, searchInRelatedFiles, moveToSeparateFiles, elementsTree, textfieldValidationResult, treeValidationResult, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<MoveToFolderTreeElement>> WriteMoveToFolderTreeElementList = MoveToFolderTreeElement.Write.List();
    public static new CtxWriteDelegate<MoveToFolderModel> Write = (ctx, writer, value) => 
    {
      RdProperty<string>.Write(ctx, writer, value._FolderName);
      RdProperty<RefactoringCompletionList>.Write(ctx, writer, value._CompletionList);
      RdProperty<bool>.Write(ctx, writer, value._CreateEnabled);
      RdVoidSignal.Write(ctx, writer, value._CreateClicked);
      writer.Write(value.FixNamespacesVisible);
      writer.Write(value.SearchInRelatedFilesVisible);
      RdProperty<bool>.Write(ctx, writer, value._FixVisibility);
      RdProperty<bool>.Write(ctx, writer, value._FixNamespaces);
      RdProperty<bool>.Write(ctx, writer, value._SearchInRelatedFiles);
      RdProperty<bool>.Write(ctx, writer, value._MoveToSeparateFiles);
      WriteMoveToFolderTreeElementList(ctx, writer, value.ElementsTree);
      RdProperty<string>.Write(ctx, writer, value._TextfieldValidationResult);
      RdProperty<string>.Write(ctx, writer, value._TreeValidationResult);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _FolderName.BindEx(lifetime, this, "folderName");
      _CompletionList.BindEx(lifetime, this, "completionList");
      _CreateEnabled.BindEx(lifetime, this, "createEnabled");
      _CreateClicked.BindEx(lifetime, this, "createClicked");
      _FixVisibility.BindEx(lifetime, this, "fixVisibility");
      _FixNamespaces.BindEx(lifetime, this, "fixNamespaces");
      _SearchInRelatedFiles.BindEx(lifetime, this, "searchInRelatedFiles");
      _MoveToSeparateFiles.BindEx(lifetime, this, "moveToSeparateFiles");
      ElementsTree.BindEx(lifetime, this, "elementsTree");
      _TextfieldValidationResult.BindEx(lifetime, this, "textfieldValidationResult");
      _TreeValidationResult.BindEx(lifetime, this, "treeValidationResult");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _FolderName.IdentifyEx(ids);
      _CompletionList.IdentifyEx(ids);
      _CreateEnabled.IdentifyEx(ids);
      _CreateClicked.IdentifyEx(ids);
      _FixVisibility.IdentifyEx(ids);
      _FixNamespaces.IdentifyEx(ids);
      _SearchInRelatedFiles.IdentifyEx(ids);
      _MoveToSeparateFiles.IdentifyEx(ids);
      ElementsTree.IdentifyEx(ids);
      _TextfieldValidationResult.IdentifyEx(ids);
      _TreeValidationResult.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MoveToFolderModel (");
      using (printer.IndentCookie()) {
        printer.Print("folderName = "); _FolderName.PrintEx(printer); printer.Println();
        printer.Print("completionList = "); _CompletionList.PrintEx(printer); printer.Println();
        printer.Print("createEnabled = "); _CreateEnabled.PrintEx(printer); printer.Println();
        printer.Print("createClicked = "); _CreateClicked.PrintEx(printer); printer.Println();
        printer.Print("fixNamespacesVisible = "); FixNamespacesVisible.PrintEx(printer); printer.Println();
        printer.Print("searchInRelatedFilesVisible = "); SearchInRelatedFilesVisible.PrintEx(printer); printer.Println();
        printer.Print("fixVisibility = "); _FixVisibility.PrintEx(printer); printer.Println();
        printer.Print("fixNamespaces = "); _FixNamespaces.PrintEx(printer); printer.Println();
        printer.Print("searchInRelatedFiles = "); _SearchInRelatedFiles.PrintEx(printer); printer.Println();
        printer.Print("moveToSeparateFiles = "); _MoveToSeparateFiles.PrintEx(printer); printer.Println();
        printer.Print("elementsTree = "); ElementsTree.PrintEx(printer); printer.Println();
        printer.Print("textfieldValidationResult = "); _TextfieldValidationResult.PrintEx(printer); printer.Println();
        printer.Print("treeValidationResult = "); _TreeValidationResult.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MoveToFolderTreeElement : RdBindableBase {
    //fields
    [NotNull] public List<int> Children {get; private set;}
    [NotNull] public string Text {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public IRdProperty<bool> Included { get { return _Included; }}
    [NotNull] private readonly RdProperty<bool> _Included;
    [NotNull] public IRdProperty<string> ErrorText { get { return _ErrorText; }}
    [NotNull] private readonly RdProperty<string> _ErrorText;
    [NotNull] public IVoidSink Navigate { get { return _Navigate; }}
    [NotNull] private readonly RdVoidSignal _Navigate;
    
    //primary constructor
    private MoveToFolderTreeElement(
      [NotNull] List<int> children,
      [NotNull] string text,
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<bool> included,
      [NotNull] RdProperty<string> errorText,
      [NotNull] RdVoidSignal navigate
    )
    {
      Children = children;
      Text = text;
      Icon = icon;
      _Included = included;
      _ErrorText = errorText;
      _Navigate = navigate;
      included.OptimizeNested = true;
      errorText.OptimizeNested = true;
    }
    //secondary constructor
    public MoveToFolderTreeElement (
      [NotNull] List<int> Children,
      [NotNull] string Text,
      [NotNull] JetBrains.Rider.Model.Icon Icon
    ) : this (
      Children,
      Text,
      Icon,
      new RdProperty<bool>(),
      new RdProperty<string>(),
      new RdVoidSignal()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static CtxReadDelegate<MoveToFolderTreeElement> Read = (ctx, reader) => 
    {
      var children = ReadIntList(ctx, reader);
      var text = reader.ReadString();
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var included = RdProperty<bool>.Read(ctx, reader);
      var errorText = RdProperty<string>.Read(ctx, reader);
      var navigate = RdVoidSignal.Read(ctx, reader);
      return new MoveToFolderTreeElement(children, text, icon, included, errorText, navigate);
    };
    
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static CtxWriteDelegate<MoveToFolderTreeElement> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.Children);
      writer.Write(value.Text);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      RdProperty<bool>.Write(ctx, writer, value._Included);
      RdProperty<string>.Write(ctx, writer, value._ErrorText);
      RdVoidSignal.Write(ctx, writer, value._Navigate);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Included.BindEx(lifetime, this, "included");
      _ErrorText.BindEx(lifetime, this, "errorText");
      _Navigate.BindEx(lifetime, this, "navigate");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Included.IdentifyEx(ids);
      _ErrorText.IdentifyEx(ids);
      _Navigate.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MoveToFolderTreeElement (");
      using (printer.IndentCookie()) {
        printer.Print("children = "); Children.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("included = "); _Included.PrintEx(printer); printer.Println();
        printer.Print("errorText = "); _ErrorText.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MoveToNamespaceModel : AbstractPage
   {
    //fields
    [NotNull] public string LabelText {get; private set;}
    [NotNull] public IRdProperty<string> NamespaceName { get { return _NamespaceName; }}
    [NotNull] private readonly RdProperty<string> _NamespaceName;
    [NotNull] public IRdProperty<RefactoringCompletionList> CompletionList { get { return _CompletionList; }}
    [NotNull] private readonly RdProperty<RefactoringCompletionList> _CompletionList;
    
    //primary constructor
    private MoveToNamespaceModel(
      [NotNull] string labelText,
      [NotNull] RdProperty<string> namespaceName,
      [NotNull] RdProperty<RefactoringCompletionList> completionList,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      LabelText = labelText;
      _NamespaceName = namespaceName;
      _CompletionList = completionList;
      namespaceName.OptimizeNested = true;
    }
    //secondary constructor
    public MoveToNamespaceModel (
      [NotNull] string LabelText,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      LabelText,
      new RdProperty<string>(),
      new RdProperty<RefactoringCompletionList>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static new CtxReadDelegate<MoveToNamespaceModel> Read = (ctx, reader) => 
    {
      var labelText = reader.ReadString();
      var namespaceName = RdProperty<string>.Read(ctx, reader);
      var completionList = RdProperty<RefactoringCompletionList>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new MoveToNamespaceModel(labelText, namespaceName, completionList, title, description, continueEnabled, validationResult);
    };
    
    public static new CtxWriteDelegate<MoveToNamespaceModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.LabelText);
      RdProperty<string>.Write(ctx, writer, value._NamespaceName);
      RdProperty<RefactoringCompletionList>.Write(ctx, writer, value._CompletionList);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _NamespaceName.BindEx(lifetime, this, "namespaceName");
      _CompletionList.BindEx(lifetime, this, "completionList");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _NamespaceName.IdentifyEx(ids);
      _CompletionList.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MoveToNamespaceModel (");
      using (printer.IndentCookie()) {
        printer.Print("labelText = "); LabelText.PrintEx(printer); printer.Println();
        printer.Print("namespaceName = "); _NamespaceName.PrintEx(printer); printer.Println();
        printer.Print("completionList = "); _CompletionList.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PropertyToMethodModel : AbstractPage
   {
    //fields
    [NotNull] public string PropertyName {get; private set;}
    public bool CanTransformGetter {get; private set;}
    public bool CanTransformSetter {get; private set;}
    [NotNull] public IRdProperty<bool> TransformGetter { get { return _TransformGetter; }}
    [NotNull] private readonly RdProperty<bool> _TransformGetter;
    [NotNull] public IRdProperty<bool> TransformSetter { get { return _TransformSetter; }}
    [NotNull] private readonly RdProperty<bool> _TransformSetter;
    [NotNull] public IRdProperty<string> GetterName { get { return _GetterName; }}
    [NotNull] private readonly RdProperty<string> _GetterName;
    [NotNull] public IRdProperty<string> SetterName { get { return _SetterName; }}
    [NotNull] private readonly RdProperty<string> _SetterName;
    
    //primary constructor
    private PropertyToMethodModel(
      [NotNull] string propertyName,
      bool canTransformGetter,
      bool canTransformSetter,
      [NotNull] RdProperty<bool> transformGetter,
      [NotNull] RdProperty<bool> transformSetter,
      [NotNull] RdProperty<string> getterName,
      [NotNull] RdProperty<string> setterName,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      PropertyName = propertyName;
      CanTransformGetter = canTransformGetter;
      CanTransformSetter = canTransformSetter;
      _TransformGetter = transformGetter;
      _TransformSetter = transformSetter;
      _GetterName = getterName;
      _SetterName = setterName;
      transformGetter.OptimizeNested = true;
      transformSetter.OptimizeNested = true;
      getterName.OptimizeNested = true;
      setterName.OptimizeNested = true;
    }
    //secondary constructor
    public PropertyToMethodModel (
      [NotNull] string PropertyName,
      bool CanTransformGetter,
      bool CanTransformSetter,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      PropertyName,
      CanTransformGetter,
      CanTransformSetter,
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<string>(),
      new RdProperty<string>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static new CtxReadDelegate<PropertyToMethodModel> Read = (ctx, reader) => 
    {
      var propertyName = reader.ReadString();
      var canTransformGetter = reader.ReadBool();
      var canTransformSetter = reader.ReadBool();
      var transformGetter = RdProperty<bool>.Read(ctx, reader);
      var transformSetter = RdProperty<bool>.Read(ctx, reader);
      var getterName = RdProperty<string>.Read(ctx, reader);
      var setterName = RdProperty<string>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new PropertyToMethodModel(propertyName, canTransformGetter, canTransformSetter, transformGetter, transformSetter, getterName, setterName, title, description, continueEnabled, validationResult);
    };
    
    public static new CtxWriteDelegate<PropertyToMethodModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.PropertyName);
      writer.Write(value.CanTransformGetter);
      writer.Write(value.CanTransformSetter);
      RdProperty<bool>.Write(ctx, writer, value._TransformGetter);
      RdProperty<bool>.Write(ctx, writer, value._TransformSetter);
      RdProperty<string>.Write(ctx, writer, value._GetterName);
      RdProperty<string>.Write(ctx, writer, value._SetterName);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _TransformGetter.BindEx(lifetime, this, "transformGetter");
      _TransformSetter.BindEx(lifetime, this, "transformSetter");
      _GetterName.BindEx(lifetime, this, "getterName");
      _SetterName.BindEx(lifetime, this, "setterName");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _TransformGetter.IdentifyEx(ids);
      _TransformSetter.IdentifyEx(ids);
      _GetterName.IdentifyEx(ids);
      _SetterName.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PropertyToMethodModel (");
      using (printer.IndentCookie()) {
        printer.Print("propertyName = "); PropertyName.PrintEx(printer); printer.Println();
        printer.Print("canTransformGetter = "); CanTransformGetter.PrintEx(printer); printer.Println();
        printer.Print("canTransformSetter = "); CanTransformSetter.PrintEx(printer); printer.Println();
        printer.Print("transformGetter = "); _TransformGetter.PrintEx(printer); printer.Println();
        printer.Print("transformSetter = "); _TransformSetter.PrintEx(printer); printer.Println();
        printer.Print("getterName = "); _GetterName.PrintEx(printer); printer.Println();
        printer.Print("setterName = "); _SetterName.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class PullToolSessionBaseNode : RdBindableBase {
    //fields
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public string Text {get; private set;}
    [NotNull] public IRdProperty<string> ResolutionText { get { return _ResolutionText; }}
    [NotNull] protected readonly RdProperty<string> _ResolutionText;
    [NotNull] public IRdProperty<bool> IsEnabled { get { return _IsEnabled; }}
    [NotNull] protected readonly RdProperty<bool> _IsEnabled;
    [NotNull] public List<string> PossibleFixes {get; private set;}
    [NotNull] public IRdProperty<int> SelectedFix { get { return _SelectedFix; }}
    [NotNull] protected readonly RdProperty<int> _SelectedFix;
    [NotNull] public IVoidSink Navigate { get { return _Navigate; }}
    [NotNull] protected readonly RdVoidSignal _Navigate;
    
    //primary constructor
    protected PullToolSessionBaseNode(
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] string text,
      [NotNull] RdProperty<string> resolutionText,
      [NotNull] RdProperty<bool> isEnabled,
      [NotNull] List<string> possibleFixes,
      [NotNull] RdProperty<int> selectedFix,
      [NotNull] RdVoidSignal navigate
    )
    {
      Icon = icon;
      Text = text;
      _ResolutionText = resolutionText;
      _IsEnabled = isEnabled;
      PossibleFixes = possibleFixes;
      _SelectedFix = selectedFix;
      _Navigate = navigate;
      resolutionText.OptimizeNested = true;
      isEnabled.OptimizeNested = true;
      selectedFix.OptimizeNested = true;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<PullToolSessionBaseNode> Read = (ctx, reader) => ctx.Serializers.Read<PullToolSessionBaseNode>(ctx, reader);
    
    public static CtxWriteDelegate<PullToolSessionBaseNode> Write = (ctx, writer, value) => ctx.Serializers.Write<PullToolSessionBaseNode>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class PullToolSessionModel : RdBindableBase {
    //fields
    [NotNull] public string SessionName {get; private set;}
    [NotNull] public List<PullToolSessionNode> Roots {get; private set;}
    
    //primary constructor
    public PullToolSessionModel(
      [NotNull] string sessionName,
      [NotNull] List<PullToolSessionNode> roots
    )
    {
      SessionName = sessionName;
      Roots = roots;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<PullToolSessionNode>> ReadPullToolSessionNodeList = PullToolSessionNode.Read.List();
    public static CtxReadDelegate<PullToolSessionModel> Read = (ctx, reader) => 
    {
      var sessionName = reader.ReadString();
      var roots = ReadPullToolSessionNodeList(ctx, reader);
      return new PullToolSessionModel(sessionName, roots);
    };
    
    public static CtxWriteDelegate<List<PullToolSessionNode>> WritePullToolSessionNodeList = PullToolSessionNode.Write.List();
    public static CtxWriteDelegate<PullToolSessionModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.SessionName);
      WritePullToolSessionNodeList(ctx, writer, value.Roots);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Roots.BindEx(lifetime, this, "roots");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Roots.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PullToolSessionModel (");
      using (printer.IndentCookie()) {
        printer.Print("sessionName = "); SessionName.PrintEx(printer); printer.Println();
        printer.Print("roots = "); Roots.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PullToolSessionNode : PullToolSessionBaseNode
   {
    //fields
    [NotNull] public IRdProperty<PullToolSessionNodeChildren> Children { get { return _Children; }}
    [NotNull] private readonly RdProperty<PullToolSessionNodeChildren> _Children;
    
    //primary constructor
    private PullToolSessionNode(
      [NotNull] RdProperty<PullToolSessionNodeChildren> children,
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] string text,
      [NotNull] RdProperty<string> resolutionText,
      [NotNull] RdProperty<bool> isEnabled,
      [NotNull] List<string> possibleFixes,
      [NotNull] RdProperty<int> selectedFix,
      [NotNull] RdVoidSignal navigate
    ) : base (
      icon,
      text,
      resolutionText,
      isEnabled,
      possibleFixes,
      selectedFix,
      navigate
     ) 
    {
      _Children = children;
    }
    //secondary constructor
    public PullToolSessionNode (
      [NotNull] JetBrains.Rider.Model.Icon Icon,
      [NotNull] string Text,
      [NotNull] List<string> PossibleFixes
    ) : this (
      new RdProperty<PullToolSessionNodeChildren>(),
      Icon,
      Text,
      new RdProperty<string>(),
      new RdProperty<bool>(),
      PossibleFixes,
      new RdProperty<int>(),
      new RdVoidSignal()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static new CtxReadDelegate<PullToolSessionNode> Read = (ctx, reader) => 
    {
      var children = RdProperty<PullToolSessionNodeChildren>.Read(ctx, reader);
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var text = reader.ReadString();
      var resolutionText = RdProperty<string>.Read(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader);
      var possibleFixes = ReadStringList(ctx, reader);
      var selectedFix = RdProperty<int>.Read(ctx, reader);
      var navigate = RdVoidSignal.Read(ctx, reader);
      return new PullToolSessionNode(children, icon, text, resolutionText, isEnabled, possibleFixes, selectedFix, navigate);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static new CtxWriteDelegate<PullToolSessionNode> Write = (ctx, writer, value) => 
    {
      RdProperty<PullToolSessionNodeChildren>.Write(ctx, writer, value._Children);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      writer.Write(value.Text);
      RdProperty<string>.Write(ctx, writer, value._ResolutionText);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
      WriteStringList(ctx, writer, value.PossibleFixes);
      RdProperty<int>.Write(ctx, writer, value._SelectedFix);
      RdVoidSignal.Write(ctx, writer, value._Navigate);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Children.BindEx(lifetime, this, "children");
      _ResolutionText.BindEx(lifetime, this, "resolutionText");
      _IsEnabled.BindEx(lifetime, this, "isEnabled");
      _SelectedFix.BindEx(lifetime, this, "selectedFix");
      _Navigate.BindEx(lifetime, this, "navigate");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Children.IdentifyEx(ids);
      _ResolutionText.IdentifyEx(ids);
      _IsEnabled.IdentifyEx(ids);
      _SelectedFix.IdentifyEx(ids);
      _Navigate.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PullToolSessionNode (");
      using (printer.IndentCookie()) {
        printer.Print("children = "); _Children.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("resolutionText = "); _ResolutionText.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("possibleFixes = "); PossibleFixes.PrintEx(printer); printer.Println();
        printer.Print("selectedFix = "); _SelectedFix.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PullToolSessionNodeChildren : RdBindableBase {
    //fields
    [NotNull] public List<PullToolSessionBaseNode> Data {get; private set;}
    
    //primary constructor
    public PullToolSessionNodeChildren(
      [NotNull] List<PullToolSessionBaseNode> data
    )
    {
      Data = data;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<PullToolSessionBaseNode>> ReadPullToolSessionBaseNodeList = PullToolSessionBaseNode.Read.List();
    public static CtxReadDelegate<PullToolSessionNodeChildren> Read = (ctx, reader) => 
    {
      var data = ReadPullToolSessionBaseNodeList(ctx, reader);
      return new PullToolSessionNodeChildren(data);
    };
    
    public static CtxWriteDelegate<List<PullToolSessionBaseNode>> WritePullToolSessionBaseNodeList = PullToolSessionBaseNode.Write.List();
    public static CtxWriteDelegate<PullToolSessionNodeChildren> Write = (ctx, writer, value) => 
    {
      WritePullToolSessionBaseNodeList(ctx, writer, value.Data);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Data.BindEx(lifetime, this, "data");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Data.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PullToolSessionNodeChildren (");
      using (printer.IndentCookie()) {
        printer.Print("data = "); Data.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PullUpMembersModel : AbstractPage
   {
    //fields
    [NotNull] public List<PullUpTreeElementModel> Ancestors {get; private set;}
    [NotNull] public IRdProperty<int> SelectedIndex { get { return _SelectedIndex; }}
    [NotNull] private readonly RdProperty<int> _SelectedIndex;
    [NotNull] public IRdProperty<ExtractInterfaceMemberModel> Members { get { return _Members; }}
    [NotNull] private readonly RdProperty<ExtractInterfaceMemberModel> _Members;
    
    //primary constructor
    private PullUpMembersModel(
      [NotNull] List<PullUpTreeElementModel> ancestors,
      [NotNull] RdProperty<int> selectedIndex,
      [NotNull] RdProperty<ExtractInterfaceMemberModel> members,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      Ancestors = ancestors;
      _SelectedIndex = selectedIndex;
      _Members = members;
      selectedIndex.OptimizeNested = true;
    }
    //secondary constructor
    public PullUpMembersModel (
      [NotNull] List<PullUpTreeElementModel> Ancestors,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      Ancestors,
      new RdProperty<int>(),
      new RdProperty<ExtractInterfaceMemberModel>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<PullUpTreeElementModel>> ReadPullUpTreeElementModelList = PullUpTreeElementModel.Read.List();
    public static new CtxReadDelegate<PullUpMembersModel> Read = (ctx, reader) => 
    {
      var ancestors = ReadPullUpTreeElementModelList(ctx, reader);
      var selectedIndex = RdProperty<int>.Read(ctx, reader);
      var members = RdProperty<ExtractInterfaceMemberModel>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new PullUpMembersModel(ancestors, selectedIndex, members, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<PullUpTreeElementModel>> WritePullUpTreeElementModelList = PullUpTreeElementModel.Write.List();
    public static new CtxWriteDelegate<PullUpMembersModel> Write = (ctx, writer, value) => 
    {
      WritePullUpTreeElementModelList(ctx, writer, value.Ancestors);
      RdProperty<int>.Write(ctx, writer, value._SelectedIndex);
      RdProperty<ExtractInterfaceMemberModel>.Write(ctx, writer, value._Members);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Ancestors.BindEx(lifetime, this, "ancestors");
      _SelectedIndex.BindEx(lifetime, this, "selectedIndex");
      _Members.BindEx(lifetime, this, "members");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Ancestors.IdentifyEx(ids);
      _SelectedIndex.IdentifyEx(ids);
      _Members.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PullUpMembersModel (");
      using (printer.IndentCookie()) {
        printer.Print("ancestors = "); Ancestors.PrintEx(printer); printer.Println();
        printer.Print("selectedIndex = "); _SelectedIndex.PrintEx(printer); printer.Println();
        printer.Print("members = "); _Members.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PullUpTreeElementModel : RdBindableBase {
    //fields
    [NotNull] public string ClassName {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public List<int> Children {get; private set;}
    
    //primary constructor
    public PullUpTreeElementModel(
      [NotNull] string className,
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] List<int> children
    )
    {
      ClassName = className;
      Icon = icon;
      Children = children;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static CtxReadDelegate<PullUpTreeElementModel> Read = (ctx, reader) => 
    {
      var className = reader.ReadString();
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var children = ReadIntList(ctx, reader);
      return new PullUpTreeElementModel(className, icon, children);
    };
    
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static CtxWriteDelegate<PullUpTreeElementModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ClassName);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      WriteIntList(ctx, writer, value.Children);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PullUpTreeElementModel (");
      using (printer.IndentCookie()) {
        printer.Print("className = "); ClassName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("children = "); Children.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PushDownMembersModel : AbstractPage
   {
    //fields
    [NotNull] public ExtractInterfaceMemberModel Members {get; private set;}
    [NotNull] public List<PushDownSingleMemberModel> Children {get; private set;}
    
    //primary constructor
    private PushDownMembersModel(
      [NotNull] ExtractInterfaceMemberModel members,
      [NotNull] List<PushDownSingleMemberModel> children,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      Members = members;
      Children = children;
    }
    //secondary constructor
    public PushDownMembersModel (
      [NotNull] ExtractInterfaceMemberModel Members,
      [NotNull] List<PushDownSingleMemberModel> Children,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      Members,
      Children,
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<PushDownSingleMemberModel>> ReadPushDownSingleMemberModelList = PushDownSingleMemberModel.Read.List();
    public static new CtxReadDelegate<PushDownMembersModel> Read = (ctx, reader) => 
    {
      var members = ExtractInterfaceMemberModel.Read(ctx, reader);
      var children = ReadPushDownSingleMemberModelList(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new PushDownMembersModel(members, children, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<PushDownSingleMemberModel>> WritePushDownSingleMemberModelList = PushDownSingleMemberModel.Write.List();
    public static new CtxWriteDelegate<PushDownMembersModel> Write = (ctx, writer, value) => 
    {
      ExtractInterfaceMemberModel.Write(ctx, writer, value.Members);
      WritePushDownSingleMemberModelList(ctx, writer, value.Children);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Members.BindEx(lifetime, this, "members");
      Children.BindEx(lifetime, this, "children");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Members.IdentifyEx(ids);
      Children.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PushDownMembersModel (");
      using (printer.IndentCookie()) {
        printer.Print("members = "); Members.PrintEx(printer); printer.Println();
        printer.Print("children = "); Children.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PushDownSingleMemberModel : RdBindableBase {
    //fields
    [NotNull] public TextWithIconModel Info {get; private set;}
    [NotNull] public IRdProperty<bool> IsSelected { get { return _IsSelected; }}
    [NotNull] private readonly RdProperty<bool> _IsSelected;
    
    //primary constructor
    private PushDownSingleMemberModel(
      [NotNull] TextWithIconModel info,
      [NotNull] RdProperty<bool> isSelected
    )
    {
      Info = info;
      _IsSelected = isSelected;
      isSelected.OptimizeNested = true;
    }
    //secondary constructor
    public PushDownSingleMemberModel (
      [NotNull] TextWithIconModel Info
    ) : this (
      Info,
      new RdProperty<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<PushDownSingleMemberModel> Read = (ctx, reader) => 
    {
      var info = TextWithIconModel.Read(ctx, reader);
      var isSelected = RdProperty<bool>.Read(ctx, reader);
      return new PushDownSingleMemberModel(info, isSelected);
    };
    
    public static CtxWriteDelegate<PushDownSingleMemberModel> Write = (ctx, writer, value) => 
    {
      TextWithIconModel.Write(ctx, writer, value.Info);
      RdProperty<bool>.Write(ctx, writer, value._IsSelected);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Info.BindEx(lifetime, this, "info");
      _IsSelected.BindEx(lifetime, this, "isSelected");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Info.IdentifyEx(ids);
      _IsSelected.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PushDownSingleMemberModel (");
      using (printer.IndentCookie()) {
        printer.Print("info = "); Info.PrintEx(printer); printer.Println();
        printer.Print("isSelected = "); _IsSelected.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RefactoringCompletionItem : RdBindableBase {
    //fields
    [NotNull] public string Label {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public string TranslatedText {get; private set;}
    
    //primary constructor
    public RefactoringCompletionItem(
      [NotNull] string label,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] string translatedText
    )
    {
      Label = label;
      Icon = icon;
      TranslatedText = translatedText;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<RefactoringCompletionItem> Read = (ctx, reader) => 
    {
      var label = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var translatedText = reader.ReadString();
      return new RefactoringCompletionItem(label, icon, translatedText);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<RefactoringCompletionItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Label);
      WriteIconNullable(ctx, writer, value.Icon);
      writer.Write(value.TranslatedText);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RefactoringCompletionItem (");
      using (printer.IndentCookie()) {
        printer.Print("label = "); Label.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("translatedText = "); TranslatedText.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RefactoringCompletionList : RdBindableBase {
    //fields
    [NotNull] public List<RefactoringCompletionItem> Items {get; private set;}
    
    //primary constructor
    public RefactoringCompletionList(
      [NotNull] List<RefactoringCompletionItem> items
    )
    {
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<RefactoringCompletionItem>> ReadRefactoringCompletionItemList = RefactoringCompletionItem.Read.List();
    public static CtxReadDelegate<RefactoringCompletionList> Read = (ctx, reader) => 
    {
      var items = ReadRefactoringCompletionItemList(ctx, reader);
      return new RefactoringCompletionList(items);
    };
    
    public static CtxWriteDelegate<List<RefactoringCompletionItem>> WriteRefactoringCompletionItemList = RefactoringCompletionItem.Write.List();
    public static CtxWriteDelegate<RefactoringCompletionList> Write = (ctx, writer, value) => 
    {
      WriteRefactoringCompletionItemList(ctx, writer, value.Items);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Items.BindEx(lifetime, this, "items");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Items.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RefactoringCompletionList (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RefactoringInteraction : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<JetBrains.Rider.Model.Refactorings.WizardForm> WizardForm { get { return _WizardForm; }}
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.Refactorings.WizardForm> _WizardForm;
    [NotNull] public string Title {get; private set;}
    [NotNull] public ISource<MessageBoxOK> Message { get { return _Message; }}
    [NotNull] private readonly RdSignal<MessageBoxOK> _Message;
    
    //primary constructor
    private RefactoringInteraction(
      [NotNull] RdProperty<JetBrains.Rider.Model.Refactorings.WizardForm> wizardForm,
      [NotNull] string title,
      [NotNull] RdSignal<MessageBoxOK> message
    )
    {
      _WizardForm = wizardForm;
      Title = title;
      _Message = message;
    }
    //secondary constructor
    public RefactoringInteraction (
      [NotNull] string Title
    ) : this (
      new RdProperty<JetBrains.Rider.Model.Refactorings.WizardForm>(),
      Title,
      new RdSignal<MessageBoxOK>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RefactoringInteraction> Read = (ctx, reader) => 
    {
      var wizardForm = RdProperty<JetBrains.Rider.Model.Refactorings.WizardForm>.Read(ctx, reader);
      var title = reader.ReadString();
      var message = RdSignal<MessageBoxOK>.Read(ctx, reader);
      return new RefactoringInteraction(wizardForm, title, message);
    };
    
    public static CtxWriteDelegate<RefactoringInteraction> Write = (ctx, writer, value) => 
    {
      RdProperty<JetBrains.Rider.Model.Refactorings.WizardForm>.Write(ctx, writer, value._WizardForm);
      writer.Write(value.Title);
      RdSignal<MessageBoxOK>.Write(ctx, writer, value._Message);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _WizardForm.BindEx(lifetime, this, "wizardForm");
      _Message.BindEx(lifetime, this, "message");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _WizardForm.IdentifyEx(ids);
      _Message.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RefactoringInteraction (");
      using (printer.IndentCookie()) {
        printer.Print("wizardForm = "); _WizardForm.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("message = "); _Message.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RelatedElementsPageModel : AbstractPage
   {
    //fields
    [NotNull] public List<RelatedElementsPageModelNode> Node {get; private set;}
    
    //primary constructor
    private RelatedElementsPageModel(
      [NotNull] List<RelatedElementsPageModelNode> node,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      Node = node;
    }
    //secondary constructor
    public RelatedElementsPageModel (
      [NotNull] List<RelatedElementsPageModelNode> Node,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      Node,
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<RelatedElementsPageModelNode>> ReadRelatedElementsPageModelNodeList = RelatedElementsPageModelNode.Read.List();
    public static new CtxReadDelegate<RelatedElementsPageModel> Read = (ctx, reader) => 
    {
      var node = ReadRelatedElementsPageModelNodeList(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new RelatedElementsPageModel(node, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<RelatedElementsPageModelNode>> WriteRelatedElementsPageModelNodeList = RelatedElementsPageModelNode.Write.List();
    public static new CtxWriteDelegate<RelatedElementsPageModel> Write = (ctx, writer, value) => 
    {
      WriteRelatedElementsPageModelNodeList(ctx, writer, value.Node);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Node.BindEx(lifetime, this, "node");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Node.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RelatedElementsPageModel (");
      using (printer.IndentCookie()) {
        printer.Print("node = "); Node.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RelatedElementsPageModelNode : RdBindableBase {
    //fields
    [NotNull] public string Text {get; private set;}
    public int ParentIndex {get; private set;}
    [NotNull] public IRdProperty<CheckboxState> Enabled { get { return _Enabled; }}
    [NotNull] private readonly RdProperty<CheckboxState> _Enabled;
    
    //primary constructor
    private RelatedElementsPageModelNode(
      [NotNull] string text,
      int parentIndex,
      [NotNull] RdProperty<CheckboxState> enabled
    )
    {
      Text = text;
      ParentIndex = parentIndex;
      _Enabled = enabled;
      enabled.OptimizeNested = true;
    }
    //secondary constructor
    public RelatedElementsPageModelNode (
      [NotNull] string Text,
      int ParentIndex
    ) : this (
      Text,
      ParentIndex,
      new RdProperty<CheckboxState>()
    ) {}
    //statics
    
    public static CtxReadDelegate<CheckboxState> ReadCheckboxState = new CtxReadDelegate<CheckboxState>(Serializers.ReadEnum<CheckboxState>);
    public static CtxReadDelegate<RelatedElementsPageModelNode> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      var parentIndex = reader.ReadInt();
      var enabled = RdProperty<CheckboxState>.Read(ctx, reader);
      return new RelatedElementsPageModelNode(text, parentIndex, enabled);
    };
    
    public static CtxWriteDelegate<CheckboxState> WriteCheckboxState = new CtxWriteDelegate<CheckboxState>(Serializers.WriteEnum<CheckboxState>);
    public static CtxWriteDelegate<RelatedElementsPageModelNode> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
      writer.Write(value.ParentIndex);
      RdProperty<CheckboxState>.Write(ctx, writer, value._Enabled);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Enabled.BindEx(lifetime, this, "enabled");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Enabled.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RelatedElementsPageModelNode (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("parentIndex = "); ParentIndex.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RenameInitialPage : AbstractPage
   {
    //fields
    [NotNull] public IRdProperty<string> NewName { get { return _NewName; }}
    [NotNull] private readonly RdProperty<string> _NewName;
    [NotNull] public IRdProperty<bool> SearchText { get { return _SearchText; }}
    [NotNull] private readonly RdProperty<bool> _SearchText;
    [NotNull] public IRdProperty<bool> RenameFile { get { return _RenameFile; }}
    [NotNull] private readonly RdProperty<bool> _RenameFile;
    [NotNull] public List<string> Suggestions {get; private set;}
    public bool RenameFileAvailable {get; private set;}
    
    //primary constructor
    private RenameInitialPage(
      [NotNull] RdProperty<string> newName,
      [NotNull] RdProperty<bool> searchText,
      [NotNull] RdProperty<bool> renameFile,
      [NotNull] List<string> suggestions,
      bool renameFileAvailable,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      _NewName = newName;
      _SearchText = searchText;
      _RenameFile = renameFile;
      Suggestions = suggestions;
      RenameFileAvailable = renameFileAvailable;
      newName.OptimizeNested = true;
      searchText.OptimizeNested = true;
      renameFile.OptimizeNested = true;
    }
    //secondary constructor
    public RenameInitialPage (
      [NotNull] List<string> Suggestions,
      bool RenameFileAvailable,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      new RdProperty<string>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      Suggestions,
      RenameFileAvailable,
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static new CtxReadDelegate<RenameInitialPage> Read = (ctx, reader) => 
    {
      var newName = RdProperty<string>.Read(ctx, reader);
      var searchText = RdProperty<bool>.Read(ctx, reader);
      var renameFile = RdProperty<bool>.Read(ctx, reader);
      var suggestions = ReadStringList(ctx, reader);
      var renameFileAvailable = reader.ReadBool();
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new RenameInitialPage(newName, searchText, renameFile, suggestions, renameFileAvailable, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static new CtxWriteDelegate<RenameInitialPage> Write = (ctx, writer, value) => 
    {
      RdProperty<string>.Write(ctx, writer, value._NewName);
      RdProperty<bool>.Write(ctx, writer, value._SearchText);
      RdProperty<bool>.Write(ctx, writer, value._RenameFile);
      WriteStringList(ctx, writer, value.Suggestions);
      writer.Write(value.RenameFileAvailable);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _NewName.BindEx(lifetime, this, "newName");
      _SearchText.BindEx(lifetime, this, "searchText");
      _RenameFile.BindEx(lifetime, this, "renameFile");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _NewName.IdentifyEx(ids);
      _SearchText.IdentifyEx(ids);
      _RenameFile.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RenameInitialPage (");
      using (printer.IndentCookie()) {
        printer.Print("newName = "); _NewName.PrintEx(printer); printer.Println();
        printer.Print("searchText = "); _SearchText.PrintEx(printer); printer.Println();
        printer.Print("renameFile = "); _RenameFile.PrintEx(printer); printer.Println();
        printer.Print("suggestions = "); Suggestions.PrintEx(printer); printer.Println();
        printer.Print("renameFileAvailable = "); RenameFileAvailable.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RenameOverloadsPage : AbstractPage
   {
    //fields
    [NotNull] public string DoRenameOverloads {get; private set;}
    [NotNull] public string DontRenameOverloads {get; private set;}
    [NotNull] public IRdProperty<bool> RenameOverloads { get { return _RenameOverloads; }}
    [NotNull] private readonly RdProperty<bool> _RenameOverloads;
    
    //primary constructor
    private RenameOverloadsPage(
      [NotNull] string doRenameOverloads,
      [NotNull] string dontRenameOverloads,
      [NotNull] RdProperty<bool> renameOverloads,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      DoRenameOverloads = doRenameOverloads;
      DontRenameOverloads = dontRenameOverloads;
      _RenameOverloads = renameOverloads;
      renameOverloads.OptimizeNested = true;
    }
    //secondary constructor
    public RenameOverloadsPage (
      [NotNull] string DoRenameOverloads,
      [NotNull] string DontRenameOverloads,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      DoRenameOverloads,
      DontRenameOverloads,
      new RdProperty<bool>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static new CtxReadDelegate<RenameOverloadsPage> Read = (ctx, reader) => 
    {
      var doRenameOverloads = reader.ReadString();
      var dontRenameOverloads = reader.ReadString();
      var renameOverloads = RdProperty<bool>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new RenameOverloadsPage(doRenameOverloads, dontRenameOverloads, renameOverloads, title, description, continueEnabled, validationResult);
    };
    
    public static new CtxWriteDelegate<RenameOverloadsPage> Write = (ctx, writer, value) => 
    {
      writer.Write(value.DoRenameOverloads);
      writer.Write(value.DontRenameOverloads);
      RdProperty<bool>.Write(ctx, writer, value._RenameOverloads);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _RenameOverloads.BindEx(lifetime, this, "renameOverloads");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _RenameOverloads.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RenameOverloadsPage (");
      using (printer.IndentCookie()) {
        printer.Print("doRenameOverloads = "); DoRenameOverloads.PrintEx(printer); printer.Println();
        printer.Print("dontRenameOverloads = "); DontRenameOverloads.PrintEx(printer); printer.Println();
        printer.Print("renameOverloads = "); _RenameOverloads.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SafeDeleteDeleteFilesModel : AbstractPage
   {
    //fields
    [NotNull] public IRdProperty<bool> DeleteFiles { get { return _DeleteFiles; }}
    [NotNull] private readonly RdProperty<bool> _DeleteFiles;
    
    //primary constructor
    private SafeDeleteDeleteFilesModel(
      [NotNull] RdProperty<bool> deleteFiles,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      _DeleteFiles = deleteFiles;
      deleteFiles.OptimizeNested = true;
    }
    //secondary constructor
    public SafeDeleteDeleteFilesModel (
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      new RdProperty<bool>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static new CtxReadDelegate<SafeDeleteDeleteFilesModel> Read = (ctx, reader) => 
    {
      var deleteFiles = RdProperty<bool>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new SafeDeleteDeleteFilesModel(deleteFiles, title, description, continueEnabled, validationResult);
    };
    
    public static new CtxWriteDelegate<SafeDeleteDeleteFilesModel> Write = (ctx, writer, value) => 
    {
      RdProperty<bool>.Write(ctx, writer, value._DeleteFiles);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _DeleteFiles.BindEx(lifetime, this, "deleteFiles");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _DeleteFiles.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SafeDeleteDeleteFilesModel (");
      using (printer.IndentCookie()) {
        printer.Print("deleteFiles = "); _DeleteFiles.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SafeDeleteInheritorsPageModel : AbstractPage
   {
    //fields
    [NotNull] public IRdProperty<bool> DeleteInheritors { get { return _DeleteInheritors; }}
    [NotNull] private readonly RdProperty<bool> _DeleteInheritors;
    [NotNull] public string ObjectType {get; private set;}
    
    //primary constructor
    private SafeDeleteInheritorsPageModel(
      [NotNull] RdProperty<bool> deleteInheritors,
      [NotNull] string objectType,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      _DeleteInheritors = deleteInheritors;
      ObjectType = objectType;
      deleteInheritors.OptimizeNested = true;
    }
    //secondary constructor
    public SafeDeleteInheritorsPageModel (
      [NotNull] string ObjectType,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      new RdProperty<bool>(),
      ObjectType,
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static new CtxReadDelegate<SafeDeleteInheritorsPageModel> Read = (ctx, reader) => 
    {
      var deleteInheritors = RdProperty<bool>.Read(ctx, reader);
      var objectType = reader.ReadString();
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new SafeDeleteInheritorsPageModel(deleteInheritors, objectType, title, description, continueEnabled, validationResult);
    };
    
    public static new CtxWriteDelegate<SafeDeleteInheritorsPageModel> Write = (ctx, writer, value) => 
    {
      RdProperty<bool>.Write(ctx, writer, value._DeleteInheritors);
      writer.Write(value.ObjectType);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _DeleteInheritors.BindEx(lifetime, this, "deleteInheritors");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _DeleteInheritors.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SafeDeleteInheritorsPageModel (");
      using (printer.IndentCookie()) {
        printer.Print("deleteInheritors = "); _DeleteInheritors.PrintEx(printer); printer.Println();
        printer.Print("objectType = "); ObjectType.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum SafeDeleteOverridableMemberEnum {
    All,
    Inheritors,
    Single
  }
  
  
  public class SafeDeleteOverridableMemberModel : AbstractPage
   {
    //fields
    [NotNull] public IRdProperty<SafeDeleteOverridableMemberEnum> ReplaceType { get { return _ReplaceType; }}
    [NotNull] private readonly RdProperty<SafeDeleteOverridableMemberEnum> _ReplaceType;
    [NotNull] public string BaseName {get; private set;}
    public bool EnableInheritor {get; private set;}
    
    //primary constructor
    private SafeDeleteOverridableMemberModel(
      [NotNull] RdProperty<SafeDeleteOverridableMemberEnum> replaceType,
      [NotNull] string baseName,
      bool enableInheritor,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      _ReplaceType = replaceType;
      BaseName = baseName;
      EnableInheritor = enableInheritor;
      replaceType.OptimizeNested = true;
    }
    //secondary constructor
    public SafeDeleteOverridableMemberModel (
      [NotNull] string BaseName,
      bool EnableInheritor,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      new RdProperty<SafeDeleteOverridableMemberEnum>(),
      BaseName,
      EnableInheritor,
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<SafeDeleteOverridableMemberEnum> ReadSafeDeleteOverridableMemberEnum = new CtxReadDelegate<SafeDeleteOverridableMemberEnum>(Serializers.ReadEnum<SafeDeleteOverridableMemberEnum>);
    public static new CtxReadDelegate<SafeDeleteOverridableMemberModel> Read = (ctx, reader) => 
    {
      var replaceType = RdProperty<SafeDeleteOverridableMemberEnum>.Read(ctx, reader);
      var baseName = reader.ReadString();
      var enableInheritor = reader.ReadBool();
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new SafeDeleteOverridableMemberModel(replaceType, baseName, enableInheritor, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<SafeDeleteOverridableMemberEnum> WriteSafeDeleteOverridableMemberEnum = new CtxWriteDelegate<SafeDeleteOverridableMemberEnum>(Serializers.WriteEnum<SafeDeleteOverridableMemberEnum>);
    public static new CtxWriteDelegate<SafeDeleteOverridableMemberModel> Write = (ctx, writer, value) => 
    {
      RdProperty<SafeDeleteOverridableMemberEnum>.Write(ctx, writer, value._ReplaceType);
      writer.Write(value.BaseName);
      writer.Write(value.EnableInheritor);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _ReplaceType.BindEx(lifetime, this, "replaceType");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ReplaceType.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SafeDeleteOverridableMemberModel (");
      using (printer.IndentCookie()) {
        printer.Print("replaceType = "); _ReplaceType.PrintEx(printer); printer.Println();
        printer.Print("baseName = "); BaseName.PrintEx(printer); printer.Println();
        printer.Print("enableInheritor = "); EnableInheritor.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SafeDeleteReferenceUsagesModel : AbstractPage
   {
    //fields
    [NotNull] public IRdProperty<bool> RemoveOnlyUnused { get { return _RemoveOnlyUnused; }}
    [NotNull] private readonly RdProperty<bool> _RemoveOnlyUnused;
    [NotNull] public IRdProperty<bool> RemoveUnusedEnabled { get { return _RemoveUnusedEnabled; }}
    [NotNull] private readonly RdProperty<bool> _RemoveUnusedEnabled;
    [NotNull] public IRdProperty<JetBrains.Rider.Model.RdUsageList> Occurrences { get { return _Occurrences; }}
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.RdUsageList> _Occurrences;
    
    //primary constructor
    private SafeDeleteReferenceUsagesModel(
      [NotNull] RdProperty<bool> removeOnlyUnused,
      [NotNull] RdProperty<bool> removeUnusedEnabled,
      [NotNull] RdProperty<JetBrains.Rider.Model.RdUsageList> occurrences,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      _RemoveOnlyUnused = removeOnlyUnused;
      _RemoveUnusedEnabled = removeUnusedEnabled;
      _Occurrences = occurrences;
      removeOnlyUnused.OptimizeNested = true;
      removeUnusedEnabled.OptimizeNested = true;
    }
    //secondary constructor
    public SafeDeleteReferenceUsagesModel (
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<JetBrains.Rider.Model.RdUsageList>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static new CtxReadDelegate<SafeDeleteReferenceUsagesModel> Read = (ctx, reader) => 
    {
      var removeOnlyUnused = RdProperty<bool>.Read(ctx, reader);
      var removeUnusedEnabled = RdProperty<bool>.Read(ctx, reader);
      var occurrences = RdProperty<JetBrains.Rider.Model.RdUsageList>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new SafeDeleteReferenceUsagesModel(removeOnlyUnused, removeUnusedEnabled, occurrences, title, description, continueEnabled, validationResult);
    };
    
    public static new CtxWriteDelegate<SafeDeleteReferenceUsagesModel> Write = (ctx, writer, value) => 
    {
      RdProperty<bool>.Write(ctx, writer, value._RemoveOnlyUnused);
      RdProperty<bool>.Write(ctx, writer, value._RemoveUnusedEnabled);
      RdProperty<JetBrains.Rider.Model.RdUsageList>.Write(ctx, writer, value._Occurrences);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _RemoveOnlyUnused.BindEx(lifetime, this, "removeOnlyUnused");
      _RemoveUnusedEnabled.BindEx(lifetime, this, "removeUnusedEnabled");
      _Occurrences.BindEx(lifetime, this, "occurrences");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _RemoveOnlyUnused.IdentifyEx(ids);
      _RemoveUnusedEnabled.IdentifyEx(ids);
      _Occurrences.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SafeDeleteReferenceUsagesModel (");
      using (printer.IndentCookie()) {
        printer.Print("removeOnlyUnused = "); _RemoveOnlyUnused.PrintEx(printer); printer.Println();
        printer.Print("removeUnusedEnabled = "); _RemoveUnusedEnabled.PrintEx(printer); printer.Println();
        printer.Print("occurrences = "); _Occurrences.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum SafeDeleteReplaceTypeUsagesEnum {
    None,
    Inheritor,
    Base
  }
  
  
  public class SafeDeleteReplaceTypeUsagesModel : AbstractPage
   {
    //fields
    [NotNull] public IRdProperty<SafeDeleteReplaceTypeUsagesEnum> ReplaceType { get { return _ReplaceType; }}
    [NotNull] private readonly RdProperty<SafeDeleteReplaceTypeUsagesEnum> _ReplaceType;
    [NotNull] public string BaseName {get; private set;}
    [NotNull] public string InheritorName {get; private set;}
    
    //primary constructor
    private SafeDeleteReplaceTypeUsagesModel(
      [NotNull] RdProperty<SafeDeleteReplaceTypeUsagesEnum> replaceType,
      [NotNull] string baseName,
      [NotNull] string inheritorName,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      _ReplaceType = replaceType;
      BaseName = baseName;
      InheritorName = inheritorName;
      replaceType.OptimizeNested = true;
    }
    //secondary constructor
    public SafeDeleteReplaceTypeUsagesModel (
      [NotNull] string BaseName,
      [NotNull] string InheritorName,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      new RdProperty<SafeDeleteReplaceTypeUsagesEnum>(),
      BaseName,
      InheritorName,
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<SafeDeleteReplaceTypeUsagesEnum> ReadSafeDeleteReplaceTypeUsagesEnum = new CtxReadDelegate<SafeDeleteReplaceTypeUsagesEnum>(Serializers.ReadEnum<SafeDeleteReplaceTypeUsagesEnum>);
    public static new CtxReadDelegate<SafeDeleteReplaceTypeUsagesModel> Read = (ctx, reader) => 
    {
      var replaceType = RdProperty<SafeDeleteReplaceTypeUsagesEnum>.Read(ctx, reader);
      var baseName = reader.ReadString();
      var inheritorName = reader.ReadString();
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new SafeDeleteReplaceTypeUsagesModel(replaceType, baseName, inheritorName, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<SafeDeleteReplaceTypeUsagesEnum> WriteSafeDeleteReplaceTypeUsagesEnum = new CtxWriteDelegate<SafeDeleteReplaceTypeUsagesEnum>(Serializers.WriteEnum<SafeDeleteReplaceTypeUsagesEnum>);
    public static new CtxWriteDelegate<SafeDeleteReplaceTypeUsagesModel> Write = (ctx, writer, value) => 
    {
      RdProperty<SafeDeleteReplaceTypeUsagesEnum>.Write(ctx, writer, value._ReplaceType);
      writer.Write(value.BaseName);
      writer.Write(value.InheritorName);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _ReplaceType.BindEx(lifetime, this, "replaceType");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ReplaceType.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SafeDeleteReplaceTypeUsagesModel (");
      using (printer.IndentCookie()) {
        printer.Print("replaceType = "); _ReplaceType.PrintEx(printer); printer.Println();
        printer.Print("baseName = "); BaseName.PrintEx(printer); printer.Println();
        printer.Print("inheritorName = "); InheritorName.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SelectTypePartModel : AbstractPage
   {
    //fields
    [NotNull] public List<TextWithIconModel> Parts {get; private set;}
    [NotNull] public IRdProperty<int> SelectedIndex { get { return _SelectedIndex; }}
    [NotNull] private readonly RdProperty<int> _SelectedIndex;
    [NotNull] public ISink<int> NavigateTo { get { return _NavigateTo; }}
    [NotNull] private readonly RdSignal<int> _NavigateTo;
    
    //primary constructor
    private SelectTypePartModel(
      [NotNull] List<TextWithIconModel> parts,
      [NotNull] RdProperty<int> selectedIndex,
      [NotNull] RdSignal<int> navigateTo,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      Parts = parts;
      _SelectedIndex = selectedIndex;
      _NavigateTo = navigateTo;
      selectedIndex.OptimizeNested = true;
    }
    //secondary constructor
    public SelectTypePartModel (
      [NotNull] List<TextWithIconModel> Parts,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      Parts,
      new RdProperty<int>(),
      new RdSignal<int>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<TextWithIconModel>> ReadTextWithIconModelList = TextWithIconModel.Read.List();
    public static new CtxReadDelegate<SelectTypePartModel> Read = (ctx, reader) => 
    {
      var parts = ReadTextWithIconModelList(ctx, reader);
      var selectedIndex = RdProperty<int>.Read(ctx, reader);
      var navigateTo = RdSignal<int>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new SelectTypePartModel(parts, selectedIndex, navigateTo, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<TextWithIconModel>> WriteTextWithIconModelList = TextWithIconModel.Write.List();
    public static new CtxWriteDelegate<SelectTypePartModel> Write = (ctx, writer, value) => 
    {
      WriteTextWithIconModelList(ctx, writer, value.Parts);
      RdProperty<int>.Write(ctx, writer, value._SelectedIndex);
      RdSignal<int>.Write(ctx, writer, value._NavigateTo);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Parts.BindEx(lifetime, this, "parts");
      _SelectedIndex.BindEx(lifetime, this, "selectedIndex");
      _NavigateTo.BindEx(lifetime, this, "navigateTo");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Parts.IdentifyEx(ids);
      _SelectedIndex.IdentifyEx(ids);
      _NavigateTo.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SelectTypePartModel (");
      using (printer.IndentCookie()) {
        printer.Print("parts = "); Parts.PrintEx(printer); printer.Println();
        printer.Print("selectedIndex = "); _SelectedIndex.PrintEx(printer); printer.Println();
        printer.Print("navigateTo = "); _NavigateTo.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TextOccurrencesPageModel : AbstractPage
   {
    //fields
    [NotNull] public JetBrains.Rider.Model.RdUsageList Occurrences {get; private set;}
    [NotNull] public string GlobalCheckboxLabel {get; private set;}
    [NotNull] public ISink<int> SetChecked { get { return _SetChecked; }}
    [NotNull] private readonly RdSignal<int> _SetChecked;
    [NotNull] public ISink<int> SetUnchecked { get { return _SetUnchecked; }}
    [NotNull] private readonly RdSignal<int> _SetUnchecked;
    [NotNull] public IRdProperty<bool> GlobalEnabled { get { return _GlobalEnabled; }}
    [NotNull] private readonly RdProperty<bool> _GlobalEnabled;
    
    //primary constructor
    private TextOccurrencesPageModel(
      [NotNull] JetBrains.Rider.Model.RdUsageList occurrences,
      [NotNull] string globalCheckboxLabel,
      [NotNull] RdSignal<int> setChecked,
      [NotNull] RdSignal<int> setUnchecked,
      [NotNull] RdProperty<bool> globalEnabled,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      Occurrences = occurrences;
      GlobalCheckboxLabel = globalCheckboxLabel;
      _SetChecked = setChecked;
      _SetUnchecked = setUnchecked;
      _GlobalEnabled = globalEnabled;
      globalEnabled.OptimizeNested = true;
    }
    //secondary constructor
    public TextOccurrencesPageModel (
      [NotNull] JetBrains.Rider.Model.RdUsageList Occurrences,
      [NotNull] string GlobalCheckboxLabel,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      Occurrences,
      GlobalCheckboxLabel,
      new RdSignal<int>(),
      new RdSignal<int>(),
      new RdProperty<bool>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static new CtxReadDelegate<TextOccurrencesPageModel> Read = (ctx, reader) => 
    {
      var occurrences = JetBrains.Rider.Model.RdUsageList.Read(ctx, reader);
      var globalCheckboxLabel = reader.ReadString();
      var setChecked = RdSignal<int>.Read(ctx, reader);
      var setUnchecked = RdSignal<int>.Read(ctx, reader);
      var globalEnabled = RdProperty<bool>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new TextOccurrencesPageModel(occurrences, globalCheckboxLabel, setChecked, setUnchecked, globalEnabled, title, description, continueEnabled, validationResult);
    };
    
    public static new CtxWriteDelegate<TextOccurrencesPageModel> Write = (ctx, writer, value) => 
    {
      JetBrains.Rider.Model.RdUsageList.Write(ctx, writer, value.Occurrences);
      writer.Write(value.GlobalCheckboxLabel);
      RdSignal<int>.Write(ctx, writer, value._SetChecked);
      RdSignal<int>.Write(ctx, writer, value._SetUnchecked);
      RdProperty<bool>.Write(ctx, writer, value._GlobalEnabled);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Occurrences.BindEx(lifetime, this, "occurrences");
      _SetChecked.BindEx(lifetime, this, "setChecked");
      _SetUnchecked.BindEx(lifetime, this, "setUnchecked");
      _GlobalEnabled.BindEx(lifetime, this, "globalEnabled");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Occurrences.IdentifyEx(ids);
      _SetChecked.IdentifyEx(ids);
      _SetUnchecked.IdentifyEx(ids);
      _GlobalEnabled.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TextOccurrencesPageModel (");
      using (printer.IndentCookie()) {
        printer.Print("occurrences = "); Occurrences.PrintEx(printer); printer.Println();
        printer.Print("globalCheckboxLabel = "); GlobalCheckboxLabel.PrintEx(printer); printer.Println();
        printer.Print("setChecked = "); _SetChecked.PrintEx(printer); printer.Println();
        printer.Print("setUnchecked = "); _SetUnchecked.PrintEx(printer); printer.Println();
        printer.Print("globalEnabled = "); _GlobalEnabled.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TextWithIconModel : RdBindableBase {
    //fields
    [NotNull] public string Text {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //primary constructor
    public TextWithIconModel(
      [NotNull] string text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    )
    {
      Text = text;
      Icon = icon;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<TextWithIconModel> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      return new TextWithIconModel(text, icon);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<TextWithIconModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
      WriteIconNullable(ctx, writer, value.Icon);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TextWithIconModel (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TypeSuggestionsElementModel : RdBindableBase {
    //fields
    [NotNull] public string ParameterName {get; private set;}
    [NotNull] public List<string> PossibleResolutions {get; private set;}
    [NotNull] public IRdProperty<int> Resolution { get { return _Resolution; }}
    [NotNull] private readonly RdProperty<int> _Resolution;
    
    //primary constructor
    private TypeSuggestionsElementModel(
      [NotNull] string parameterName,
      [NotNull] List<string> possibleResolutions,
      [NotNull] RdProperty<int> resolution
    )
    {
      ParameterName = parameterName;
      PossibleResolutions = possibleResolutions;
      _Resolution = resolution;
      resolution.OptimizeNested = true;
    }
    //secondary constructor
    public TypeSuggestionsElementModel (
      [NotNull] string ParameterName,
      [NotNull] List<string> PossibleResolutions
    ) : this (
      ParameterName,
      PossibleResolutions,
      new RdProperty<int>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static CtxReadDelegate<TypeSuggestionsElementModel> Read = (ctx, reader) => 
    {
      var parameterName = reader.ReadString();
      var possibleResolutions = ReadStringList(ctx, reader);
      var resolution = RdProperty<int>.Read(ctx, reader);
      return new TypeSuggestionsElementModel(parameterName, possibleResolutions, resolution);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static CtxWriteDelegate<TypeSuggestionsElementModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ParameterName);
      WriteStringList(ctx, writer, value.PossibleResolutions);
      RdProperty<int>.Write(ctx, writer, value._Resolution);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Resolution.BindEx(lifetime, this, "resolution");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Resolution.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TypeSuggestionsElementModel (");
      using (printer.IndentCookie()) {
        printer.Print("parameterName = "); ParameterName.PrintEx(printer); printer.Println();
        printer.Print("possibleResolutions = "); PossibleResolutions.PrintEx(printer); printer.Println();
        printer.Print("resolution = "); _Resolution.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TypeSuggestionsModel : AbstractPage
   {
    //fields
    [NotNull] public List<TypeSuggestionsElementModel> Elements {get; private set;}
    
    //primary constructor
    private TypeSuggestionsModel(
      [NotNull] List<TypeSuggestionsElementModel> elements,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      Elements = elements;
    }
    //secondary constructor
    public TypeSuggestionsModel (
      [NotNull] List<TypeSuggestionsElementModel> Elements,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      Elements,
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<TypeSuggestionsElementModel>> ReadTypeSuggestionsElementModelList = TypeSuggestionsElementModel.Read.List();
    public static new CtxReadDelegate<TypeSuggestionsModel> Read = (ctx, reader) => 
    {
      var elements = ReadTypeSuggestionsElementModelList(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new TypeSuggestionsModel(elements, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<TypeSuggestionsElementModel>> WriteTypeSuggestionsElementModelList = TypeSuggestionsElementModel.Write.List();
    public static new CtxWriteDelegate<TypeSuggestionsModel> Write = (ctx, writer, value) => 
    {
      WriteTypeSuggestionsElementModelList(ctx, writer, value.Elements);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Elements.BindEx(lifetime, this, "elements");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Elements.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TypeSuggestionsModel (");
      using (printer.IndentCookie()) {
        printer.Print("elements = "); Elements.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class UseBaseTypeModel : AbstractPage
   {
    //fields
    [NotNull] public string DerivedTypeName {get; private set;}
    [NotNull] public List<TextWithIconModel> TypeParts {get; private set;}
    [NotNull] public IRdProperty<int> SelectedIndex { get { return _SelectedIndex; }}
    [NotNull] private readonly RdProperty<int> _SelectedIndex;
    [NotNull] public ISink<int> NavigateTo { get { return _NavigateTo; }}
    [NotNull] private readonly RdSignal<int> _NavigateTo;
    [NotNull] public IRdProperty<bool> ReplaceInTypeof { get { return _ReplaceInTypeof; }}
    [NotNull] private readonly RdProperty<bool> _ReplaceInTypeof;
    [NotNull] public IRdProperty<bool> ReplaceInIs { get { return _ReplaceInIs; }}
    [NotNull] private readonly RdProperty<bool> _ReplaceInIs;
    
    //primary constructor
    private UseBaseTypeModel(
      [NotNull] string derivedTypeName,
      [NotNull] List<TextWithIconModel> typeParts,
      [NotNull] RdProperty<int> selectedIndex,
      [NotNull] RdSignal<int> navigateTo,
      [NotNull] RdProperty<bool> replaceInTypeof,
      [NotNull] RdProperty<bool> replaceInIs,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      DerivedTypeName = derivedTypeName;
      TypeParts = typeParts;
      _SelectedIndex = selectedIndex;
      _NavigateTo = navigateTo;
      _ReplaceInTypeof = replaceInTypeof;
      _ReplaceInIs = replaceInIs;
      selectedIndex.OptimizeNested = true;
      replaceInTypeof.OptimizeNested = true;
      replaceInIs.OptimizeNested = true;
    }
    //secondary constructor
    public UseBaseTypeModel (
      [NotNull] string DerivedTypeName,
      [NotNull] List<TextWithIconModel> TypeParts,
      [NotNull] string Title,
      [NotNull] string Description
    ) : this (
      DerivedTypeName,
      TypeParts,
      new RdProperty<int>(),
      new RdSignal<int>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      Title,
      Description,
      new RdProperty<bool>(),
      new RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<TextWithIconModel>> ReadTextWithIconModelList = TextWithIconModel.Read.List();
    public static new CtxReadDelegate<UseBaseTypeModel> Read = (ctx, reader) => 
    {
      var derivedTypeName = reader.ReadString();
      var typeParts = ReadTextWithIconModelList(ctx, reader);
      var selectedIndex = RdProperty<int>.Read(ctx, reader);
      var navigateTo = RdSignal<int>.Read(ctx, reader);
      var replaceInTypeof = RdProperty<bool>.Read(ctx, reader);
      var replaceInIs = RdProperty<bool>.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader);
      var validationResult = RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Read(ctx, reader);
      return new UseBaseTypeModel(derivedTypeName, typeParts, selectedIndex, navigateTo, replaceInTypeof, replaceInIs, title, description, continueEnabled, validationResult);
    };
    
    public static CtxWriteDelegate<List<TextWithIconModel>> WriteTextWithIconModelList = TextWithIconModel.Write.List();
    public static new CtxWriteDelegate<UseBaseTypeModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.DerivedTypeName);
      WriteTextWithIconModelList(ctx, writer, value.TypeParts);
      RdProperty<int>.Write(ctx, writer, value._SelectedIndex);
      RdSignal<int>.Write(ctx, writer, value._NavigateTo);
      RdProperty<bool>.Write(ctx, writer, value._ReplaceInTypeof);
      RdProperty<bool>.Write(ctx, writer, value._ReplaceInIs);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<JetBrains.Rider.Model.Refactorings.ValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      TypeParts.BindEx(lifetime, this, "typeParts");
      _SelectedIndex.BindEx(lifetime, this, "selectedIndex");
      _NavigateTo.BindEx(lifetime, this, "navigateTo");
      _ReplaceInTypeof.BindEx(lifetime, this, "replaceInTypeof");
      _ReplaceInIs.BindEx(lifetime, this, "replaceInIs");
      _ContinueEnabled.BindEx(lifetime, this, "continueEnabled");
      _ValidationResult.BindEx(lifetime, this, "validationResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      TypeParts.IdentifyEx(ids);
      _SelectedIndex.IdentifyEx(ids);
      _NavigateTo.IdentifyEx(ids);
      _ReplaceInTypeof.IdentifyEx(ids);
      _ReplaceInIs.IdentifyEx(ids);
      _ContinueEnabled.IdentifyEx(ids);
      _ValidationResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("UseBaseTypeModel (");
      using (printer.IndentCookie()) {
        printer.Print("derivedTypeName = "); DerivedTypeName.PrintEx(printer); printer.Println();
        printer.Print("typeParts = "); TypeParts.PrintEx(printer); printer.Println();
        printer.Print("selectedIndex = "); _SelectedIndex.PrintEx(printer); printer.Println();
        printer.Print("navigateTo = "); _NavigateTo.PrintEx(printer); printer.Println();
        printer.Print("replaceInTypeof = "); _ReplaceInTypeof.PrintEx(printer); printer.Println();
        printer.Print("replaceInIs = "); _ReplaceInIs.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ValidationResult : IPrintable, IEquatable<ValidationResult> {
    //fields
    public ValidationStates State {get; private set;}
    [NotNull] public string ResultMessage {get; private set;}
    
    //primary constructor
    public ValidationResult(
      ValidationStates state,
      [NotNull] string resultMessage
    )
    {
      State = state;
      ResultMessage = resultMessage;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ValidationResult> Read = (ctx, reader) => 
    {
      var state = (ValidationStates)reader.ReadInt();
      var resultMessage = reader.ReadString();
      return new ValidationResult(state, resultMessage);
    };
    
    public static CtxWriteDelegate<ValidationResult> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.State);
      writer.Write(value.ResultMessage);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ValidationResult) obj);
    }
    public bool Equals(ValidationResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return State == other.State && ResultMessage == other.ResultMessage;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (int) State;
        __r = __r*31 + ResultMessage.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ValidationResult (");
      using (printer.IndentCookie()) {
        printer.Print("state = "); State.PrintEx(printer); printer.Println();
        printer.Print("resultMessage = "); ResultMessage.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ValidationStates {
    validationPassed,
    validationWarning,
    validationError
  }
  
  
  public class WizardForm : RdBindableBase {
    //fields
    [NotNull] public IVoidSink ContinueClicked { get { return _ContinueClicked; }}
    [NotNull] private readonly RdVoidSignal _ContinueClicked;
    [NotNull] public IVoidSink BackClicked { get { return _BackClicked; }}
    [NotNull] private readonly RdVoidSignal _BackClicked;
    [NotNull] public IVoidSink FormClosed { get { return _FormClosed; }}
    [NotNull] private readonly RdVoidSignal _FormClosed;
    [NotNull] public IVoidSink Activated { get { return _Activated; }}
    [NotNull] private readonly RdVoidSignal _Activated;
    [NotNull] public IRdProperty<JetBrains.Rider.Model.RdCancelableProgress> ExecuteTask { get { return _ExecuteTask; }}
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.RdCancelableProgress> _ExecuteTask;
    [NotNull] public IRdProperty<AbstractPage> Page { get { return _Page; }}
    [NotNull] private readonly RdProperty<AbstractPage> _Page;
    [NotNull] public IRdProperty<bool> HasBack { get { return _HasBack; }}
    [NotNull] private readonly RdProperty<bool> _HasBack;
    [NotNull] public IVoidSource PumpUi { get { return _PumpUi; }}
    [NotNull] private readonly RdVoidSignal _PumpUi;
    
    //primary constructor
    private WizardForm(
      [NotNull] RdVoidSignal continueClicked,
      [NotNull] RdVoidSignal backClicked,
      [NotNull] RdVoidSignal formClosed,
      [NotNull] RdVoidSignal activated,
      [NotNull] RdProperty<JetBrains.Rider.Model.RdCancelableProgress> executeTask,
      [NotNull] RdProperty<AbstractPage> page,
      [NotNull] RdProperty<bool> hasBack,
      [NotNull] RdVoidSignal pumpUi
    )
    {
      _ContinueClicked = continueClicked;
      _BackClicked = backClicked;
      _FormClosed = formClosed;
      _Activated = activated;
      _ExecuteTask = executeTask;
      _Page = page;
      _HasBack = hasBack;
      _PumpUi = pumpUi;
      hasBack.OptimizeNested = true;
    }
    //secondary constructor
    public WizardForm (
    ) : this (
      new RdVoidSignal(),
      new RdVoidSignal(),
      new RdVoidSignal(),
      new RdVoidSignal(),
      new RdProperty<JetBrains.Rider.Model.RdCancelableProgress>(),
      new RdProperty<AbstractPage>(),
      new RdProperty<bool>(),
      new RdVoidSignal()
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.RdCancelableProgress> ReadRdCancelableProgressNullable = JetBrains.Rider.Model.RdCancelableProgress.Read.NullableClass();
    public static CtxReadDelegate<AbstractPage> ReadAbstractPageNullable = AbstractPage.Read.NullableClass();
    public static CtxReadDelegate<WizardForm> Read = (ctx, reader) => 
    {
      var continueClicked = RdVoidSignal.Read(ctx, reader);
      var backClicked = RdVoidSignal.Read(ctx, reader);
      var formClosed = RdVoidSignal.Read(ctx, reader);
      var activated = RdVoidSignal.Read(ctx, reader);
      var executeTask = RdProperty<JetBrains.Rider.Model.RdCancelableProgress>.Read(ctx, reader);
      var page = RdProperty<AbstractPage>.Read(ctx, reader);
      var hasBack = RdProperty<bool>.Read(ctx, reader);
      var pumpUi = RdVoidSignal.Read(ctx, reader);
      return new WizardForm(continueClicked, backClicked, formClosed, activated, executeTask, page, hasBack, pumpUi);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.RdCancelableProgress> WriteRdCancelableProgressNullable = JetBrains.Rider.Model.RdCancelableProgress.Write.NullableClass();
    public static CtxWriteDelegate<AbstractPage> WriteAbstractPageNullable = AbstractPage.Write.NullableClass();
    public static CtxWriteDelegate<WizardForm> Write = (ctx, writer, value) => 
    {
      RdVoidSignal.Write(ctx, writer, value._ContinueClicked);
      RdVoidSignal.Write(ctx, writer, value._BackClicked);
      RdVoidSignal.Write(ctx, writer, value._FormClosed);
      RdVoidSignal.Write(ctx, writer, value._Activated);
      RdProperty<JetBrains.Rider.Model.RdCancelableProgress>.Write(ctx, writer, value._ExecuteTask);
      RdProperty<AbstractPage>.Write(ctx, writer, value._Page);
      RdProperty<bool>.Write(ctx, writer, value._HasBack);
      RdVoidSignal.Write(ctx, writer, value._PumpUi);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _ContinueClicked.BindEx(lifetime, this, "continueClicked");
      _BackClicked.BindEx(lifetime, this, "backClicked");
      _FormClosed.BindEx(lifetime, this, "formClosed");
      _Activated.BindEx(lifetime, this, "activated");
      _ExecuteTask.BindEx(lifetime, this, "executeTask");
      _Page.BindEx(lifetime, this, "page");
      _HasBack.BindEx(lifetime, this, "hasBack");
      _PumpUi.BindEx(lifetime, this, "pumpUi");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ContinueClicked.IdentifyEx(ids);
      _BackClicked.IdentifyEx(ids);
      _FormClosed.IdentifyEx(ids);
      _Activated.IdentifyEx(ids);
      _ExecuteTask.IdentifyEx(ids);
      _Page.IdentifyEx(ids);
      _HasBack.IdentifyEx(ids);
      _PumpUi.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("WizardForm (");
      using (printer.IndentCookie()) {
        printer.Print("continueClicked = "); _ContinueClicked.PrintEx(printer); printer.Println();
        printer.Print("backClicked = "); _BackClicked.PrintEx(printer); printer.Println();
        printer.Print("formClosed = "); _FormClosed.PrintEx(printer); printer.Println();
        printer.Print("activated = "); _Activated.PrintEx(printer); printer.Println();
        printer.Print("executeTask = "); _ExecuteTask.PrintEx(printer); printer.Println();
        printer.Print("page = "); _Page.PrintEx(printer); printer.Println();
        printer.Print("hasBack = "); _HasBack.PrintEx(printer); printer.Println();
        printer.Print("pumpUi = "); _PumpUi.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
