using System;
using System.Linq;
using System.Collections.Generic;
using JetBrains.Application;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [ShellComponent]
  public class SettingsModel : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<bool> HighlightElementUnderCursor { get { return _HighlightElementUnderCursor; }}
    [NotNull] private readonly RdProperty<bool> _HighlightElementUnderCursor;
    [NotNull] public IRdProperty<bool> EditorConfigEnabled { get { return _EditorConfigEnabled; }}
    [NotNull] private readonly RdProperty<bool> _EditorConfigEnabled;
    [NotNull] public IRdProperty<LineSeparators> LineSeparator { get { return _LineSeparator; }}
    [NotNull] private readonly RdProperty<LineSeparators> _LineSeparator;
    [NotNull] public IRdProperty<int> RightMargin { get { return _RightMargin; }}
    [NotNull] private readonly RdProperty<int> _RightMargin;
    
    //primary constructor
    public SettingsModel(
      [NotNull] RdProperty<bool> highlightElementUnderCursor,
      [NotNull] RdProperty<bool> editorConfigEnabled,
      [NotNull] RdProperty<LineSeparators> lineSeparator,
      [NotNull] RdProperty<int> rightMargin
    )
    {
      _HighlightElementUnderCursor = highlightElementUnderCursor;
      _EditorConfigEnabled = editorConfigEnabled;
      _LineSeparator = lineSeparator;
      _RightMargin = rightMargin;
      highlightElementUnderCursor.OptimizeNested = true;
      editorConfigEnabled.OptimizeNested = true;
      lineSeparator.OptimizeNested = true;
      rightMargin.OptimizeNested = true;
    }
    //secondary constructor
    //statics
    
    private void Register(ISerializers serializers)
    {
      serializers.RegisterEnum<LineSeparators>();
      serializers.Register(RdLanguage.Read, RdLanguage.Write);
    }
    
    public SettingsModel(Lifetime lifetime, IProtocol protocol) : this (
      new RdProperty<bool>().Static(1044),
      new RdProperty<bool>().Static(1045),
      new RdProperty<LineSeparators>().Static(1046),
      new RdProperty<int>().Static(1047)
    )
    {
      Register(protocol.Serializers);
      Bind(lifetime, protocol, GetType().Name);
    }
    //init method
    protected override void Init(Lifetime lifetime) {
      _HighlightElementUnderCursor.BindEx(lifetime, this, "highlightElementUnderCursor");
      _EditorConfigEnabled.BindEx(lifetime, this, "editorConfigEnabled");
      _LineSeparator.BindEx(lifetime, this, "lineSeparator");
      _RightMargin.BindEx(lifetime, this, "rightMargin");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _HighlightElementUnderCursor.IdentifyEx(ids);
      _EditorConfigEnabled.IdentifyEx(ids);
      _LineSeparator.IdentifyEx(ids);
      _RightMargin.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SettingsModel (");
      using (printer.IndentCookie()) {
        printer.Print("highlightElementUnderCursor = "); _HighlightElementUnderCursor.PrintEx(printer); printer.Println();
        printer.Print("editorConfigEnabled = "); _EditorConfigEnabled.PrintEx(printer); printer.Println();
        printer.Print("lineSeparator = "); _LineSeparator.PrintEx(printer); printer.Println();
        printer.Print("rightMargin = "); _RightMargin.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum LineSeparators {
    LF,
    CR,
    CRLF
  }
  
  
  public class RdLanguage : IPrintable, IEquatable<RdLanguage> {
    //fields
    [NotNull] public string Name {get; private set;}
    
    //primary constructor
    public RdLanguage(
      [NotNull] string name
    )
    {
      Name = name;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdLanguage> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      return new RdLanguage(name);
    };
    
    public static CtxWriteDelegate<RdLanguage> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdLanguage) obj);
    }
    public bool Equals(RdLanguage other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Name.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdLanguage (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
