using System;
using System.Linq;
using System.Collections.Generic;
using JetBrains.Application;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [ShellComponent]
  public class SettingsViewModel : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<JetBrains.Rider.Model.OptionsDialog> OptionsDialog { get { return _OptionsDialog; }}
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.OptionsDialog> _OptionsDialog;
    
    //primary constructor
    public SettingsViewModel(
      [NotNull] RdProperty<JetBrains.Rider.Model.OptionsDialog> optionsDialog
    )
    {
      _OptionsDialog = optionsDialog;
    }
    //secondary constructor
    //statics
    
    private void Register(ISerializers serializers)
    {
      serializers.Register(SimpleOption.Read, SimpleOption.Write);
      serializers.Register(SimpleOptionsPageContent.Read, SimpleOptionsPageContent.Write);
      serializers.Register(EnumWithValue.Read, EnumWithValue.Write);
      serializers.Register(RdColor.Read, RdColor.Write);
      serializers.Register(SeverityElement.Read, SeverityElement.Write);
      serializers.Register(Severity.Read, Severity.Write);
      serializers.Register(CodeStyleGroupOption.Read, CodeStyleGroupOption.Write);
      serializers.Register(CodeStyleBoolOption.Read, CodeStyleBoolOption.Write);
      serializers.Register(CodeStyleEnumOption.Read, CodeStyleEnumOption.Write);
      serializers.Register(FlaggedEnumOptionValue.Read, FlaggedEnumOptionValue.Write);
      serializers.Register(CodeStyleFlaggedEnumOption.Read, CodeStyleFlaggedEnumOption.Write);
      serializers.Register(CodeStyleNumericOption.Read, CodeStyleNumericOption.Write);
      serializers.Register(CodeStyleStringOption.Read, CodeStyleStringOption.Write);
      serializers.Register(OrderedCollection.Read, OrderedCollection.Write);
      serializers.Register(CodeStyleOrderedCollectionOption.Read, CodeStyleOrderedCollectionOption.Write);
      serializers.Register(CodeStyleCodePreview.Read, CodeStyleCodePreview.Write);
      serializers.Register(CodeStyleDiffPreview.Read, CodeStyleDiffPreview.Write);
      serializers.Register(CodeStyleDescriptionPreview.Read, CodeStyleDescriptionPreview.Write);
      serializers.Register(CodeStyleNonePreview.Read, CodeStyleNonePreview.Write);
      serializers.Register(CodeStylePageContent.Read, CodeStylePageContent.Write);
      serializers.Register(SettingsLayer.Read, SettingsLayer.Write);
      serializers.Register(SettingsLayerCollection.Read, SettingsLayerCollection.Write);
      serializers.Register(CurrentOptionsPage.Read, CurrentOptionsPage.Write);
      serializers.Register(OptionsPage.Read, OptionsPage.Write);
      serializers.Register(JetBrains.Rider.Model.OptionsDialog.Read, JetBrains.Rider.Model.OptionsDialog.Write);
    }
    
    public SettingsViewModel(Lifetime lifetime, IProtocol protocol) : this (
      new RdProperty<JetBrains.Rider.Model.OptionsDialog>().Static(1048)
    )
    {
      Register(protocol.Serializers);
      Bind(lifetime, protocol, GetType().Name);
    }
    //init method
    protected override void Init(Lifetime lifetime) {
      _OptionsDialog.BindEx(lifetime, this, "optionsDialog");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _OptionsDialog.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SettingsViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("optionsDialog = "); _OptionsDialog.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleBoolOption : CodeStyleOptionBase
   {
    //fields
    [NotNull] public IRdProperty<bool> Value { get { return _Value; }}
    [NotNull] private readonly RdProperty<bool> _Value;
    
    //primary constructor
    private CodeStyleBoolOption(
      [NotNull] RdProperty<bool> value,
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool> isEnabled
    ) : base (
      id,
      description,
      severity,
      isEnabled
     ) 
    {
      _Value = value;
      value.OptimizeNested = true;
    }
    //secondary constructor
    public CodeStyleBoolOption (
      int Id,
      [NotNull] string Description,
      [CanBeNull] JetBrains.Rider.Model.Severity Severity
    ) : this (
      new RdProperty<bool>(),
      Id,
      Description,
      Severity,
      new RdProperty<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Severity> ReadSeverityNullable = JetBrains.Rider.Model.Severity.Read.NullableClass();
    public static new CtxReadDelegate<CodeStyleBoolOption> Read = (ctx, reader) => 
    {
      var value = RdProperty<bool>.Read(ctx, reader);
      var id = reader.ReadInt();
      var description = reader.ReadString();
      var severity = ReadSeverityNullable(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader);
      return new CodeStyleBoolOption(value, id, description, severity, isEnabled);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Severity> WriteSeverityNullable = JetBrains.Rider.Model.Severity.Write.NullableClass();
    public static new CtxWriteDelegate<CodeStyleBoolOption> Write = (ctx, writer, value) => 
    {
      RdProperty<bool>.Write(ctx, writer, value._Value);
      writer.Write(value.Id);
      writer.Write(value.Description);
      WriteSeverityNullable(ctx, writer, value.Severity);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Value.BindEx(lifetime, this, "value");
      Severity.BindEx(lifetime, this, "severity");
      _IsEnabled.BindEx(lifetime, this, "isEnabled");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Value.IdentifyEx(ids);
      Severity.IdentifyEx(ids);
      _IsEnabled.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleBoolOption (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleCodePreview : CodeStylePreviewBase
   {
    //fields
    [NotNull] public string Text {get; private set;}
    
    //primary constructor
    public CodeStyleCodePreview(
      [NotNull] string text
    )
    {
      Text = text;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CodeStyleCodePreview> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      return new CodeStyleCodePreview(text);
    };
    
    public static new CtxWriteDelegate<CodeStyleCodePreview> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleCodePreview (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleDescriptionPreview : CodeStylePreviewBase
   {
    //fields
    [NotNull] public string Text {get; private set;}
    
    //primary constructor
    public CodeStyleDescriptionPreview(
      [NotNull] string text
    )
    {
      Text = text;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CodeStyleDescriptionPreview> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      return new CodeStyleDescriptionPreview(text);
    };
    
    public static new CtxWriteDelegate<CodeStyleDescriptionPreview> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleDescriptionPreview (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleDiffPreview : CodeStylePreviewBase
   {
    //fields
    [NotNull] public string Input {get; private set;}
    [NotNull] public string Output {get; private set;}
    
    //primary constructor
    public CodeStyleDiffPreview(
      [NotNull] string input,
      [NotNull] string output
    )
    {
      Input = input;
      Output = output;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CodeStyleDiffPreview> Read = (ctx, reader) => 
    {
      var input = reader.ReadString();
      var output = reader.ReadString();
      return new CodeStyleDiffPreview(input, output);
    };
    
    public static new CtxWriteDelegate<CodeStyleDiffPreview> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Input);
      writer.Write(value.Output);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleDiffPreview (");
      using (printer.IndentCookie()) {
        printer.Print("input = "); Input.PrintEx(printer); printer.Println();
        printer.Print("output = "); Output.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleEnumOption : CodeStyleOptionBase
   {
    //fields
    [NotNull] public IRdProperty<int> Value { get { return _Value; }}
    [NotNull] private readonly RdProperty<int> _Value;
    [NotNull] public List<EnumWithValue> PossibleValues {get; private set;}
    
    //primary constructor
    private CodeStyleEnumOption(
      [NotNull] RdProperty<int> value,
      [NotNull] List<EnumWithValue> possibleValues,
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool> isEnabled
    ) : base (
      id,
      description,
      severity,
      isEnabled
     ) 
    {
      _Value = value;
      PossibleValues = possibleValues;
      value.OptimizeNested = true;
    }
    //secondary constructor
    public CodeStyleEnumOption (
      [NotNull] List<EnumWithValue> PossibleValues,
      int Id,
      [NotNull] string Description,
      [CanBeNull] JetBrains.Rider.Model.Severity Severity
    ) : this (
      new RdProperty<int>(),
      PossibleValues,
      Id,
      Description,
      Severity,
      new RdProperty<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<EnumWithValue>> ReadEnumWithValueList = EnumWithValue.Read.List();
    public static CtxReadDelegate<JetBrains.Rider.Model.Severity> ReadSeverityNullable = JetBrains.Rider.Model.Severity.Read.NullableClass();
    public static new CtxReadDelegate<CodeStyleEnumOption> Read = (ctx, reader) => 
    {
      var value = RdProperty<int>.Read(ctx, reader);
      var possibleValues = ReadEnumWithValueList(ctx, reader);
      var id = reader.ReadInt();
      var description = reader.ReadString();
      var severity = ReadSeverityNullable(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader);
      return new CodeStyleEnumOption(value, possibleValues, id, description, severity, isEnabled);
    };
    
    public static CtxWriteDelegate<List<EnumWithValue>> WriteEnumWithValueList = EnumWithValue.Write.List();
    public static CtxWriteDelegate<JetBrains.Rider.Model.Severity> WriteSeverityNullable = JetBrains.Rider.Model.Severity.Write.NullableClass();
    public static new CtxWriteDelegate<CodeStyleEnumOption> Write = (ctx, writer, value) => 
    {
      RdProperty<int>.Write(ctx, writer, value._Value);
      WriteEnumWithValueList(ctx, writer, value.PossibleValues);
      writer.Write(value.Id);
      writer.Write(value.Description);
      WriteSeverityNullable(ctx, writer, value.Severity);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Value.BindEx(lifetime, this, "value");
      PossibleValues.BindEx(lifetime, this, "possibleValues");
      Severity.BindEx(lifetime, this, "severity");
      _IsEnabled.BindEx(lifetime, this, "isEnabled");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Value.IdentifyEx(ids);
      PossibleValues.IdentifyEx(ids);
      Severity.IdentifyEx(ids);
      _IsEnabled.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleEnumOption (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("possibleValues = "); PossibleValues.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleFlaggedEnumOption : CodeStyleOptionBase
   {
    //fields
    [NotNull] public IRdProperty<FlaggedEnumOptionValue> Value { get { return _Value; }}
    [NotNull] private readonly RdProperty<FlaggedEnumOptionValue> _Value;
    [NotNull] public List<EnumWithValue> PossibleValues {get; private set;}
    
    //primary constructor
    private CodeStyleFlaggedEnumOption(
      [NotNull] RdProperty<FlaggedEnumOptionValue> value,
      [NotNull] List<EnumWithValue> possibleValues,
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool> isEnabled
    ) : base (
      id,
      description,
      severity,
      isEnabled
     ) 
    {
      _Value = value;
      PossibleValues = possibleValues;
    }
    //secondary constructor
    public CodeStyleFlaggedEnumOption (
      [NotNull] List<EnumWithValue> PossibleValues,
      int Id,
      [NotNull] string Description,
      [CanBeNull] JetBrains.Rider.Model.Severity Severity
    ) : this (
      new RdProperty<FlaggedEnumOptionValue>(),
      PossibleValues,
      Id,
      Description,
      Severity,
      new RdProperty<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<EnumWithValue>> ReadEnumWithValueList = EnumWithValue.Read.List();
    public static CtxReadDelegate<JetBrains.Rider.Model.Severity> ReadSeverityNullable = JetBrains.Rider.Model.Severity.Read.NullableClass();
    public static new CtxReadDelegate<CodeStyleFlaggedEnumOption> Read = (ctx, reader) => 
    {
      var value = RdProperty<FlaggedEnumOptionValue>.Read(ctx, reader);
      var possibleValues = ReadEnumWithValueList(ctx, reader);
      var id = reader.ReadInt();
      var description = reader.ReadString();
      var severity = ReadSeverityNullable(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader);
      return new CodeStyleFlaggedEnumOption(value, possibleValues, id, description, severity, isEnabled);
    };
    
    public static CtxWriteDelegate<List<EnumWithValue>> WriteEnumWithValueList = EnumWithValue.Write.List();
    public static CtxWriteDelegate<JetBrains.Rider.Model.Severity> WriteSeverityNullable = JetBrains.Rider.Model.Severity.Write.NullableClass();
    public static new CtxWriteDelegate<CodeStyleFlaggedEnumOption> Write = (ctx, writer, value) => 
    {
      RdProperty<FlaggedEnumOptionValue>.Write(ctx, writer, value._Value);
      WriteEnumWithValueList(ctx, writer, value.PossibleValues);
      writer.Write(value.Id);
      writer.Write(value.Description);
      WriteSeverityNullable(ctx, writer, value.Severity);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Value.BindEx(lifetime, this, "value");
      PossibleValues.BindEx(lifetime, this, "possibleValues");
      Severity.BindEx(lifetime, this, "severity");
      _IsEnabled.BindEx(lifetime, this, "isEnabled");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Value.IdentifyEx(ids);
      PossibleValues.IdentifyEx(ids);
      Severity.IdentifyEx(ids);
      _IsEnabled.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleFlaggedEnumOption (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("possibleValues = "); PossibleValues.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleGroupOption : CodeStyleOptionBase
   {
    //fields
    [NotNull] public List<CodeStyleOptionBase> Children {get; private set;}
    
    //primary constructor
    private CodeStyleGroupOption(
      [NotNull] List<CodeStyleOptionBase> children,
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool> isEnabled
    ) : base (
      id,
      description,
      severity,
      isEnabled
     ) 
    {
      Children = children;
    }
    //secondary constructor
    public CodeStyleGroupOption (
      [NotNull] List<CodeStyleOptionBase> Children,
      int Id,
      [NotNull] string Description,
      [CanBeNull] JetBrains.Rider.Model.Severity Severity
    ) : this (
      Children,
      Id,
      Description,
      Severity,
      new RdProperty<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<CodeStyleOptionBase>> ReadCodeStyleOptionBaseList = CodeStyleOptionBase.Read.List();
    public static CtxReadDelegate<JetBrains.Rider.Model.Severity> ReadSeverityNullable = JetBrains.Rider.Model.Severity.Read.NullableClass();
    public static new CtxReadDelegate<CodeStyleGroupOption> Read = (ctx, reader) => 
    {
      var children = ReadCodeStyleOptionBaseList(ctx, reader);
      var id = reader.ReadInt();
      var description = reader.ReadString();
      var severity = ReadSeverityNullable(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader);
      return new CodeStyleGroupOption(children, id, description, severity, isEnabled);
    };
    
    public static CtxWriteDelegate<List<CodeStyleOptionBase>> WriteCodeStyleOptionBaseList = CodeStyleOptionBase.Write.List();
    public static CtxWriteDelegate<JetBrains.Rider.Model.Severity> WriteSeverityNullable = JetBrains.Rider.Model.Severity.Write.NullableClass();
    public static new CtxWriteDelegate<CodeStyleGroupOption> Write = (ctx, writer, value) => 
    {
      WriteCodeStyleOptionBaseList(ctx, writer, value.Children);
      writer.Write(value.Id);
      writer.Write(value.Description);
      WriteSeverityNullable(ctx, writer, value.Severity);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Children.BindEx(lifetime, this, "children");
      Severity.BindEx(lifetime, this, "severity");
      _IsEnabled.BindEx(lifetime, this, "isEnabled");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Children.IdentifyEx(ids);
      Severity.IdentifyEx(ids);
      _IsEnabled.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleGroupOption (");
      using (printer.IndentCookie()) {
        printer.Print("children = "); Children.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleNonePreview : CodeStylePreviewBase
   {
    //fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CodeStyleNonePreview> Read = (ctx, reader) => 
    {
      return new CodeStyleNonePreview();
    };
    
    public static new CtxWriteDelegate<CodeStyleNonePreview> Write = (ctx, writer, value) => 
    {
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleNonePreview (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStyleNumericOption : CodeStyleOptionBase
   {
    //fields
    [NotNull] public IRdProperty<int> Value { get { return _Value; }}
    [NotNull] private readonly RdProperty<int> _Value;
    public int Min {get; private set;}
    public int Max {get; private set;}
    
    //primary constructor
    private CodeStyleNumericOption(
      [NotNull] RdProperty<int> value,
      int min,
      int max,
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool> isEnabled
    ) : base (
      id,
      description,
      severity,
      isEnabled
     ) 
    {
      _Value = value;
      Min = min;
      Max = max;
      value.OptimizeNested = true;
    }
    //secondary constructor
    public CodeStyleNumericOption (
      int Min,
      int Max,
      int Id,
      [NotNull] string Description,
      [CanBeNull] JetBrains.Rider.Model.Severity Severity
    ) : this (
      new RdProperty<int>(),
      Min,
      Max,
      Id,
      Description,
      Severity,
      new RdProperty<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Severity> ReadSeverityNullable = JetBrains.Rider.Model.Severity.Read.NullableClass();
    public static new CtxReadDelegate<CodeStyleNumericOption> Read = (ctx, reader) => 
    {
      var value = RdProperty<int>.Read(ctx, reader);
      var min = reader.ReadInt();
      var max = reader.ReadInt();
      var id = reader.ReadInt();
      var description = reader.ReadString();
      var severity = ReadSeverityNullable(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader);
      return new CodeStyleNumericOption(value, min, max, id, description, severity, isEnabled);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Severity> WriteSeverityNullable = JetBrains.Rider.Model.Severity.Write.NullableClass();
    public static new CtxWriteDelegate<CodeStyleNumericOption> Write = (ctx, writer, value) => 
    {
      RdProperty<int>.Write(ctx, writer, value._Value);
      writer.Write(value.Min);
      writer.Write(value.Max);
      writer.Write(value.Id);
      writer.Write(value.Description);
      WriteSeverityNullable(ctx, writer, value.Severity);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Value.BindEx(lifetime, this, "value");
      Severity.BindEx(lifetime, this, "severity");
      _IsEnabled.BindEx(lifetime, this, "isEnabled");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Value.IdentifyEx(ids);
      Severity.IdentifyEx(ids);
      _IsEnabled.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleNumericOption (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("min = "); Min.PrintEx(printer); printer.Println();
        printer.Print("max = "); Max.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class CodeStyleOptionBase : RdBindableBase {
    //fields
    public int Id {get; private set;}
    [NotNull] public string Description {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Severity Severity {get; private set;}
    [NotNull] public IRdProperty<bool> IsEnabled { get { return _IsEnabled; }}
    [NotNull] protected readonly RdProperty<bool> _IsEnabled;
    
    //primary constructor
    protected CodeStyleOptionBase(
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool> isEnabled
    )
    {
      Id = id;
      Description = description;
      Severity = severity;
      _IsEnabled = isEnabled;
      isEnabled.OptimizeNested = true;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CodeStyleOptionBase> Read = (ctx, reader) => ctx.Serializers.Read<CodeStyleOptionBase>(ctx, reader);
    
    public static CtxWriteDelegate<CodeStyleOptionBase> Write = (ctx, writer, value) => ctx.Serializers.Write<CodeStyleOptionBase>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class CodeStyleOrderedCollectionOption : CodeStyleOptionBase
   {
    //fields
    [NotNull] public IRdProperty<OrderedCollection> Value { get { return _Value; }}
    [NotNull] private readonly RdProperty<OrderedCollection> _Value;
    
    //primary constructor
    private CodeStyleOrderedCollectionOption(
      [NotNull] RdProperty<OrderedCollection> value,
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool> isEnabled
    ) : base (
      id,
      description,
      severity,
      isEnabled
     ) 
    {
      _Value = value;
    }
    //secondary constructor
    public CodeStyleOrderedCollectionOption (
      int Id,
      [NotNull] string Description,
      [CanBeNull] JetBrains.Rider.Model.Severity Severity
    ) : this (
      new RdProperty<OrderedCollection>(),
      Id,
      Description,
      Severity,
      new RdProperty<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Severity> ReadSeverityNullable = JetBrains.Rider.Model.Severity.Read.NullableClass();
    public static new CtxReadDelegate<CodeStyleOrderedCollectionOption> Read = (ctx, reader) => 
    {
      var value = RdProperty<OrderedCollection>.Read(ctx, reader);
      var id = reader.ReadInt();
      var description = reader.ReadString();
      var severity = ReadSeverityNullable(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader);
      return new CodeStyleOrderedCollectionOption(value, id, description, severity, isEnabled);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Severity> WriteSeverityNullable = JetBrains.Rider.Model.Severity.Write.NullableClass();
    public static new CtxWriteDelegate<CodeStyleOrderedCollectionOption> Write = (ctx, writer, value) => 
    {
      RdProperty<OrderedCollection>.Write(ctx, writer, value._Value);
      writer.Write(value.Id);
      writer.Write(value.Description);
      WriteSeverityNullable(ctx, writer, value.Severity);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Value.BindEx(lifetime, this, "value");
      Severity.BindEx(lifetime, this, "severity");
      _IsEnabled.BindEx(lifetime, this, "isEnabled");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Value.IdentifyEx(ids);
      Severity.IdentifyEx(ids);
      _IsEnabled.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleOrderedCollectionOption (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStylePageContent : OptionsPageContentBase
   {
    //fields
    [NotNull] public List<CodeStyleOptionBase> Options {get; private set;}
    [NotNull] public IRdProperty<int> SelectedItemId { get { return _SelectedItemId; }}
    [NotNull] private readonly RdProperty<int> _SelectedItemId;
    [NotNull] public IRdProperty<CodeStylePreviewBase> Preview { get { return _Preview; }}
    [NotNull] private readonly RdProperty<CodeStylePreviewBase> _Preview;
    
    //primary constructor
    private CodeStylePageContent(
      [NotNull] List<CodeStyleOptionBase> options,
      [NotNull] RdProperty<int> selectedItemId,
      [NotNull] RdProperty<CodeStylePreviewBase> preview
    )
    {
      Options = options;
      _SelectedItemId = selectedItemId;
      _Preview = preview;
      selectedItemId.OptimizeNested = true;
    }
    //secondary constructor
    public CodeStylePageContent (
      [NotNull] List<CodeStyleOptionBase> Options
    ) : this (
      Options,
      new RdProperty<int>(),
      new RdProperty<CodeStylePreviewBase>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<CodeStyleOptionBase>> ReadCodeStyleOptionBaseList = CodeStyleOptionBase.Read.List();
    public static new CtxReadDelegate<CodeStylePageContent> Read = (ctx, reader) => 
    {
      var options = ReadCodeStyleOptionBaseList(ctx, reader);
      var selectedItemId = RdProperty<int>.Read(ctx, reader);
      var preview = RdProperty<CodeStylePreviewBase>.Read(ctx, reader);
      return new CodeStylePageContent(options, selectedItemId, preview);
    };
    
    public static CtxWriteDelegate<List<CodeStyleOptionBase>> WriteCodeStyleOptionBaseList = CodeStyleOptionBase.Write.List();
    public static new CtxWriteDelegate<CodeStylePageContent> Write = (ctx, writer, value) => 
    {
      WriteCodeStyleOptionBaseList(ctx, writer, value.Options);
      RdProperty<int>.Write(ctx, writer, value._SelectedItemId);
      RdProperty<CodeStylePreviewBase>.Write(ctx, writer, value._Preview);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Options.BindEx(lifetime, this, "options");
      _SelectedItemId.BindEx(lifetime, this, "selectedItemId");
      _Preview.BindEx(lifetime, this, "preview");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Options.IdentifyEx(ids);
      _SelectedItemId.IdentifyEx(ids);
      _Preview.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStylePageContent (");
      using (printer.IndentCookie()) {
        printer.Print("options = "); Options.PrintEx(printer); printer.Println();
        printer.Print("selectedItemId = "); _SelectedItemId.PrintEx(printer); printer.Println();
        printer.Print("preview = "); _Preview.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class CodeStylePreviewBase : RdBindableBase {
    //fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CodeStylePreviewBase> Read = (ctx, reader) => ctx.Serializers.Read<CodeStylePreviewBase>(ctx, reader);
    
    public static CtxWriteDelegate<CodeStylePreviewBase> Write = (ctx, writer, value) => ctx.Serializers.Write<CodeStylePreviewBase>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class CodeStyleStringOption : CodeStyleOptionBase
   {
    //fields
    [NotNull] public IRdProperty<string> Value { get { return _Value; }}
    [NotNull] private readonly RdProperty<string> _Value;
    
    //primary constructor
    private CodeStyleStringOption(
      [NotNull] RdProperty<string> value,
      int id,
      [NotNull] string description,
      [CanBeNull] JetBrains.Rider.Model.Severity severity,
      [NotNull] RdProperty<bool> isEnabled
    ) : base (
      id,
      description,
      severity,
      isEnabled
     ) 
    {
      _Value = value;
      value.OptimizeNested = true;
    }
    //secondary constructor
    public CodeStyleStringOption (
      int Id,
      [NotNull] string Description,
      [CanBeNull] JetBrains.Rider.Model.Severity Severity
    ) : this (
      new RdProperty<string>(),
      Id,
      Description,
      Severity,
      new RdProperty<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Severity> ReadSeverityNullable = JetBrains.Rider.Model.Severity.Read.NullableClass();
    public static new CtxReadDelegate<CodeStyleStringOption> Read = (ctx, reader) => 
    {
      var value = RdProperty<string>.Read(ctx, reader);
      var id = reader.ReadInt();
      var description = reader.ReadString();
      var severity = ReadSeverityNullable(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader);
      return new CodeStyleStringOption(value, id, description, severity, isEnabled);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Severity> WriteSeverityNullable = JetBrains.Rider.Model.Severity.Write.NullableClass();
    public static new CtxWriteDelegate<CodeStyleStringOption> Write = (ctx, writer, value) => 
    {
      RdProperty<string>.Write(ctx, writer, value._Value);
      writer.Write(value.Id);
      writer.Write(value.Description);
      WriteSeverityNullable(ctx, writer, value.Severity);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Value.BindEx(lifetime, this, "value");
      Severity.BindEx(lifetime, this, "severity");
      _IsEnabled.BindEx(lifetime, this, "isEnabled");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Value.IdentifyEx(ids);
      Severity.IdentifyEx(ids);
      _IsEnabled.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStyleStringOption (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CurrentOptionsPage : RdBindableBase {
    //fields
    [NotNull] public string PageId {get; private set;}
    [NotNull] public OptionsPageContentBase Content {get; private set;}
    
    //primary constructor
    public CurrentOptionsPage(
      [NotNull] string pageId,
      [NotNull] OptionsPageContentBase content
    )
    {
      PageId = pageId;
      Content = content;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CurrentOptionsPage> Read = (ctx, reader) => 
    {
      var pageId = reader.ReadString();
      var content = OptionsPageContentBase.Read(ctx, reader);
      return new CurrentOptionsPage(pageId, content);
    };
    
    public static CtxWriteDelegate<CurrentOptionsPage> Write = (ctx, writer, value) => 
    {
      writer.Write(value.PageId);
      OptionsPageContentBase.Write(ctx, writer, value.Content);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Content.BindEx(lifetime, this, "content");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Content.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CurrentOptionsPage (");
      using (printer.IndentCookie()) {
        printer.Print("pageId = "); PageId.PrintEx(printer); printer.Println();
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EnumWithValue : RdBindableBase {
    //fields
    public int Value {get; private set;}
    [NotNull] public string Presentation {get; private set;}
    
    //primary constructor
    public EnumWithValue(
      int value,
      [NotNull] string presentation
    )
    {
      Value = value;
      Presentation = presentation;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<EnumWithValue> Read = (ctx, reader) => 
    {
      var value = reader.ReadInt();
      var presentation = reader.ReadString();
      return new EnumWithValue(value, presentation);
    };
    
    public static CtxWriteDelegate<EnumWithValue> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Value);
      writer.Write(value.Presentation);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("EnumWithValue (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
        printer.Print("presentation = "); Presentation.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class FlaggedEnumOptionValue : RdBindableBase {
    //fields
    [NotNull] public List<int> Values {get; private set;}
    
    //primary constructor
    public FlaggedEnumOptionValue(
      [NotNull] List<int> values
    )
    {
      Values = values;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static CtxReadDelegate<FlaggedEnumOptionValue> Read = (ctx, reader) => 
    {
      var values = ReadIntList(ctx, reader);
      return new FlaggedEnumOptionValue(values);
    };
    
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static CtxWriteDelegate<FlaggedEnumOptionValue> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.Values);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("FlaggedEnumOptionValue (");
      using (printer.IndentCookie()) {
        printer.Print("values = "); Values.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class OptionsDialog : RdBindableBase {
    //fields
    [NotNull] public IViewableMap<string, OptionsPage> Pages { get { return _Pages; }}
    [NotNull] private readonly RdMap<string, OptionsPage> _Pages;
    [NotNull] public IVoidSink Save { get { return _Save; }}
    [NotNull] private readonly RdVoidSignal _Save;
    [NotNull] public IVoidSink Cancel { get { return _Cancel; }}
    [NotNull] private readonly RdVoidSignal _Cancel;
    [NotNull] public IRdProperty<JetBrains.Rider.Model.SettingsLayerCollection> SettingsLayerCollection { get { return _SettingsLayerCollection; }}
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.SettingsLayerCollection> _SettingsLayerCollection;
    [NotNull] public ISink<SettingsLayer> SaveTo { get { return _SaveTo; }}
    [NotNull] private readonly RdSignal<SettingsLayer> _SaveTo;
    
    //primary constructor
    private OptionsDialog(
      [NotNull] RdMap<string, OptionsPage> pages,
      [NotNull] RdVoidSignal save,
      [NotNull] RdVoidSignal cancel,
      [NotNull] RdProperty<JetBrains.Rider.Model.SettingsLayerCollection> settingsLayerCollection,
      [NotNull] RdSignal<SettingsLayer> saveTo
    )
    {
      _Pages = pages;
      _Save = save;
      _Cancel = cancel;
      _SettingsLayerCollection = settingsLayerCollection;
      _SaveTo = saveTo;
    }
    //secondary constructor
    public OptionsDialog (
    ) : this (
      new RdMap<string, OptionsPage>(),
      new RdVoidSignal(),
      new RdVoidSignal(),
      new RdProperty<JetBrains.Rider.Model.SettingsLayerCollection>(),
      new RdSignal<SettingsLayer>()
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.SettingsLayerCollection> ReadSettingsLayerCollectionNullable = JetBrains.Rider.Model.SettingsLayerCollection.Read.NullableClass();
    public static CtxReadDelegate<OptionsDialog> Read = (ctx, reader) => 
    {
      var pages = RdMap<string, OptionsPage>.Read(ctx, reader);
      var save = RdVoidSignal.Read(ctx, reader);
      var cancel = RdVoidSignal.Read(ctx, reader);
      var settingsLayerCollection = RdProperty<JetBrains.Rider.Model.SettingsLayerCollection>.Read(ctx, reader);
      var saveTo = RdSignal<SettingsLayer>.Read(ctx, reader);
      return new OptionsDialog(pages, save, cancel, settingsLayerCollection, saveTo);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.SettingsLayerCollection> WriteSettingsLayerCollectionNullable = JetBrains.Rider.Model.SettingsLayerCollection.Write.NullableClass();
    public static CtxWriteDelegate<OptionsDialog> Write = (ctx, writer, value) => 
    {
      RdMap<string, OptionsPage>.Write(ctx, writer, value._Pages);
      RdVoidSignal.Write(ctx, writer, value._Save);
      RdVoidSignal.Write(ctx, writer, value._Cancel);
      RdProperty<JetBrains.Rider.Model.SettingsLayerCollection>.Write(ctx, writer, value._SettingsLayerCollection);
      RdSignal<SettingsLayer>.Write(ctx, writer, value._SaveTo);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Pages.BindEx(lifetime, this, "pages");
      _Save.BindEx(lifetime, this, "save");
      _Cancel.BindEx(lifetime, this, "cancel");
      _SettingsLayerCollection.BindEx(lifetime, this, "settingsLayerCollection");
      _SaveTo.BindEx(lifetime, this, "saveTo");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Pages.IdentifyEx(ids);
      _Save.IdentifyEx(ids);
      _Cancel.IdentifyEx(ids);
      _SettingsLayerCollection.IdentifyEx(ids);
      _SaveTo.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("OptionsDialog (");
      using (printer.IndentCookie()) {
        printer.Print("pages = "); _Pages.PrintEx(printer); printer.Println();
        printer.Print("save = "); _Save.PrintEx(printer); printer.Println();
        printer.Print("cancel = "); _Cancel.PrintEx(printer); printer.Println();
        printer.Print("settingsLayerCollection = "); _SettingsLayerCollection.PrintEx(printer); printer.Println();
        printer.Print("saveTo = "); _SaveTo.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class OptionsPage : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<OptionsPageContentBase> Content { get { return _Content; }}
    [NotNull] private readonly RdProperty<OptionsPageContentBase> _Content;
    
    //primary constructor
    private OptionsPage(
      [NotNull] RdProperty<OptionsPageContentBase> content
    )
    {
      _Content = content;
    }
    //secondary constructor
    public OptionsPage (
    ) : this (
      new RdProperty<OptionsPageContentBase>()
    ) {}
    //statics
    
    public static CtxReadDelegate<OptionsPageContentBase> ReadOptionsPageContentBaseNullable = OptionsPageContentBase.Read.NullableClass();
    public static CtxReadDelegate<OptionsPage> Read = (ctx, reader) => 
    {
      var content = RdProperty<OptionsPageContentBase>.Read(ctx, reader);
      return new OptionsPage(content);
    };
    
    public static CtxWriteDelegate<OptionsPageContentBase> WriteOptionsPageContentBaseNullable = OptionsPageContentBase.Write.NullableClass();
    public static CtxWriteDelegate<OptionsPage> Write = (ctx, writer, value) => 
    {
      RdProperty<OptionsPageContentBase>.Write(ctx, writer, value._Content);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Content.BindEx(lifetime, this, "content");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Content.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("OptionsPage (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); _Content.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class OptionsPageContentBase : RdBindableBase {
    //fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<OptionsPageContentBase> Read = (ctx, reader) => ctx.Serializers.Read<OptionsPageContentBase>(ctx, reader);
    
    public static CtxWriteDelegate<OptionsPageContentBase> Write = (ctx, writer, value) => ctx.Serializers.Write<OptionsPageContentBase>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class OrderedCollection : RdBindableBase {
    //fields
    [NotNull] public List<string> Items {get; private set;}
    
    //primary constructor
    public OrderedCollection(
      [NotNull] List<string> items
    )
    {
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static CtxReadDelegate<OrderedCollection> Read = (ctx, reader) => 
    {
      var items = ReadStringList(ctx, reader);
      return new OrderedCollection(items);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static CtxWriteDelegate<OrderedCollection> Write = (ctx, writer, value) => 
    {
      WriteStringList(ctx, writer, value.Items);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("OrderedCollection (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdColor : RdBindableBase {
    //fields
    public int A {get; private set;}
    public int R {get; private set;}
    public int G {get; private set;}
    public int B {get; private set;}
    
    //primary constructor
    public RdColor(
      int a,
      int r,
      int g,
      int b
    )
    {
      A = a;
      R = r;
      G = g;
      B = b;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdColor> Read = (ctx, reader) => 
    {
      var a = reader.ReadInt();
      var r = reader.ReadInt();
      var g = reader.ReadInt();
      var b = reader.ReadInt();
      return new RdColor(a, r, g, b);
    };
    
    public static CtxWriteDelegate<RdColor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.A);
      writer.Write(value.R);
      writer.Write(value.G);
      writer.Write(value.B);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdColor (");
      using (printer.IndentCookie()) {
        printer.Print("a = "); A.PrintEx(printer); printer.Println();
        printer.Print("r = "); R.PrintEx(printer); printer.Println();
        printer.Print("g = "); G.PrintEx(printer); printer.Println();
        printer.Print("b = "); B.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SettingsLayer : IPrintable, IEquatable<SettingsLayer> {
    //fields
    [NotNull] public string DisplayName {get; private set;}
    
    //primary constructor
    public SettingsLayer(
      [NotNull] string displayName
    )
    {
      DisplayName = displayName;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SettingsLayer> Read = (ctx, reader) => 
    {
      var displayName = reader.ReadString();
      return new SettingsLayer(displayName);
    };
    
    public static CtxWriteDelegate<SettingsLayer> Write = (ctx, writer, value) => 
    {
      writer.Write(value.DisplayName);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SettingsLayer) obj);
    }
    public bool Equals(SettingsLayer other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return DisplayName == other.DisplayName;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + DisplayName.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SettingsLayer (");
      using (printer.IndentCookie()) {
        printer.Print("displayName = "); DisplayName.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SettingsLayerCollection : RdBindableBase {
    //fields
    [NotNull] public List<SettingsLayer> Layers {get; private set;}
    
    //primary constructor
    public SettingsLayerCollection(
      [NotNull] List<SettingsLayer> layers
    )
    {
      Layers = layers;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<SettingsLayer>> ReadSettingsLayerList = SettingsLayer.Read.List();
    public static CtxReadDelegate<SettingsLayerCollection> Read = (ctx, reader) => 
    {
      var layers = ReadSettingsLayerList(ctx, reader);
      return new SettingsLayerCollection(layers);
    };
    
    public static CtxWriteDelegate<List<SettingsLayer>> WriteSettingsLayerList = SettingsLayer.Write.List();
    public static CtxWriteDelegate<SettingsLayerCollection> Write = (ctx, writer, value) => 
    {
      WriteSettingsLayerList(ctx, writer, value.Layers);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SettingsLayerCollection (");
      using (printer.IndentCookie()) {
        printer.Print("layers = "); Layers.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class Severity : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<int> Value { get { return _Value; }}
    [NotNull] private readonly RdProperty<int> _Value;
    [NotNull] public List<SeverityElement> PossibleValues {get; private set;}
    public bool IsEnabled {get; private set;}
    
    //primary constructor
    private Severity(
      [NotNull] RdProperty<int> value,
      [NotNull] List<SeverityElement> possibleValues,
      bool isEnabled
    )
    {
      _Value = value;
      PossibleValues = possibleValues;
      IsEnabled = isEnabled;
      value.OptimizeNested = true;
    }
    //secondary constructor
    public Severity (
      [NotNull] List<SeverityElement> PossibleValues,
      bool IsEnabled
    ) : this (
      new RdProperty<int>(),
      PossibleValues,
      IsEnabled
    ) {}
    //statics
    
    public static CtxReadDelegate<List<SeverityElement>> ReadSeverityElementList = SeverityElement.Read.List();
    public static CtxReadDelegate<Severity> Read = (ctx, reader) => 
    {
      var value = RdProperty<int>.Read(ctx, reader);
      var possibleValues = ReadSeverityElementList(ctx, reader);
      var isEnabled = reader.ReadBool();
      return new Severity(value, possibleValues, isEnabled);
    };
    
    public static CtxWriteDelegate<List<SeverityElement>> WriteSeverityElementList = SeverityElement.Write.List();
    public static CtxWriteDelegate<Severity> Write = (ctx, writer, value) => 
    {
      RdProperty<int>.Write(ctx, writer, value._Value);
      WriteSeverityElementList(ctx, writer, value.PossibleValues);
      writer.Write(value.IsEnabled);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Value.BindEx(lifetime, this, "value");
      PossibleValues.BindEx(lifetime, this, "possibleValues");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Value.IdentifyEx(ids);
      PossibleValues.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("Severity (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("possibleValues = "); PossibleValues.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); IsEnabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SeverityElement : RdBindableBase {
    //fields
    [NotNull] public EnumWithValue Value {get; private set;}
    [NotNull] public RdColor Color {get; private set;}
    
    //primary constructor
    public SeverityElement(
      [NotNull] EnumWithValue value,
      [NotNull] RdColor color
    )
    {
      Value = value;
      Color = color;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SeverityElement> Read = (ctx, reader) => 
    {
      var value = EnumWithValue.Read(ctx, reader);
      var color = RdColor.Read(ctx, reader);
      return new SeverityElement(value, color);
    };
    
    public static CtxWriteDelegate<SeverityElement> Write = (ctx, writer, value) => 
    {
      EnumWithValue.Write(ctx, writer, value.Value);
      RdColor.Write(ctx, writer, value.Color);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Value.BindEx(lifetime, this, "value");
      Color.BindEx(lifetime, this, "color");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Value.IdentifyEx(ids);
      Color.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SeverityElement (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
        printer.Print("color = "); Color.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SimpleOption : RdBindableBase {
    //fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SimpleOption> Read = (ctx, reader) => 
    {
      return new SimpleOption();
    };
    
    public static CtxWriteDelegate<SimpleOption> Write = (ctx, writer, value) => 
    {
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SimpleOption (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SimpleOptionsPageContent : OptionsPageContentBase
   {
    //fields
    [NotNull] public List<SimpleOption> SimpleOptions {get; private set;}
    
    //primary constructor
    public SimpleOptionsPageContent(
      [NotNull] List<SimpleOption> simpleOptions
    )
    {
      SimpleOptions = simpleOptions;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<SimpleOption>> ReadSimpleOptionList = SimpleOption.Read.List();
    public static new CtxReadDelegate<SimpleOptionsPageContent> Read = (ctx, reader) => 
    {
      var simpleOptions = ReadSimpleOptionList(ctx, reader);
      return new SimpleOptionsPageContent(simpleOptions);
    };
    
    public static CtxWriteDelegate<List<SimpleOption>> WriteSimpleOptionList = SimpleOption.Write.List();
    public static new CtxWriteDelegate<SimpleOptionsPageContent> Write = (ctx, writer, value) => 
    {
      WriteSimpleOptionList(ctx, writer, value.SimpleOptions);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      SimpleOptions.BindEx(lifetime, this, "simpleOptions");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      SimpleOptions.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SimpleOptionsPageContent (");
      using (printer.IndentCookie()) {
        printer.Print("simpleOptions = "); SimpleOptions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
