using System;
using System.Linq;
using System.Collections.Generic;
using JetBrains.Application;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [ShellComponent]
  public class ShellModel : RdBindableBase {
    //fields
    //primary constructor
    //secondary constructor
    //statics
    
    private void Register(ISerializers serializers)
    {
      serializers.Register(RgbColor.Read, RgbColor.Write);
      serializers.RegisterEnum<IconNodeType>();
      serializers.Register(IconNode.Read, IconNode.Write);
      serializers.Register(Icon.Read, Icon.Write);
      serializers.RegisterEnum<EffectStyle>();
      serializers.RegisterEnum<FontStyle>();
      serializers.Register(ModelRichString.Read, ModelRichString.Write);
      serializers.Register(ModelRichText.Read, ModelRichText.Write);
    }
    
    public ShellModel(Lifetime lifetime, IProtocol protocol){
      Register(protocol.Serializers);
      Bind(lifetime, protocol, GetType().Name);
    }
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ShellModel (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum EffectStyle {
    None,
    StraightUnderline,
    WeavyUnderline,
    StrikeOut
  }
  
  
  public enum FontStyle {
    Regular,
    Bold,
    Italic,
    Underline,
    Strikeout
  }
  
  
  public class Icon : IPrintable, IEquatable<Icon> {
    //fields
    [NotNull] public List<IconNode> IconNodes {get; private set;}
    
    //primary constructor
    public Icon(
      [NotNull] List<IconNode> iconNodes
    )
    {
      IconNodes = iconNodes;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<IconNode>> ReadIconNodeList = IconNode.Read.List();
    public static CtxReadDelegate<Icon> Read = (ctx, reader) => 
    {
      var iconNodes = ReadIconNodeList(ctx, reader);
      return new Icon(iconNodes);
    };
    
    public static CtxWriteDelegate<List<IconNode>> WriteIconNodeList = IconNode.Write.List();
    public static CtxWriteDelegate<Icon> Write = (ctx, writer, value) => 
    {
      WriteIconNodeList(ctx, writer, value.IconNodes);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((Icon) obj);
    }
    public bool Equals(Icon other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IconNodes.SequenceEqual(other.IconNodes);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(IconNodes);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("Icon (");
      using (printer.IndentCookie()) {
        printer.Print("iconNodes = "); IconNodes.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class IconNode : IPrintable, IEquatable<IconNode> {
    //fields
    public IconNodeType Type {get; private set;}
    public int NodeId {get; private set;}
    [CanBeNull] public int? ParentNodeId {get; private set;}
    [CanBeNull] public int? IconPackStringId {get; private set;}
    [CanBeNull] public int? IconNameStringId {get; private set;}
    [CanBeNull] public int? ExtensionWithDotStringId {get; private set;}
    
    //primary constructor
    public IconNode(
      IconNodeType type,
      int nodeId,
      [CanBeNull] int? parentNodeId,
      [CanBeNull] int? iconPackStringId,
      [CanBeNull] int? iconNameStringId,
      [CanBeNull] int? extensionWithDotStringId
    )
    {
      Type = type;
      NodeId = nodeId;
      ParentNodeId = parentNodeId;
      IconPackStringId = iconPackStringId;
      IconNameStringId = iconNameStringId;
      ExtensionWithDotStringId = extensionWithDotStringId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<int?> ReadIntNullable = Serializers.ReadInt.NullableStruct();
    public static CtxReadDelegate<IconNode> Read = (ctx, reader) => 
    {
      var type = (IconNodeType)reader.ReadInt();
      var nodeId = reader.ReadInt();
      var parentNodeId = ReadIntNullable(ctx, reader);
      var iconPackStringId = ReadIntNullable(ctx, reader);
      var iconNameStringId = ReadIntNullable(ctx, reader);
      var extensionWithDotStringId = ReadIntNullable(ctx, reader);
      return new IconNode(type, nodeId, parentNodeId, iconPackStringId, iconNameStringId, extensionWithDotStringId);
    };
    
    public static CtxWriteDelegate<int?> WriteIntNullable = Serializers.WriteInt.NullableStruct();
    public static CtxWriteDelegate<IconNode> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Type);
      writer.Write(value.NodeId);
      WriteIntNullable(ctx, writer, value.ParentNodeId);
      WriteIntNullable(ctx, writer, value.IconPackStringId);
      WriteIntNullable(ctx, writer, value.IconNameStringId);
      WriteIntNullable(ctx, writer, value.ExtensionWithDotStringId);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((IconNode) obj);
    }
    public bool Equals(IconNode other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Type == other.Type && NodeId == other.NodeId && Equals(ParentNodeId, other.ParentNodeId) && Equals(IconPackStringId, other.IconPackStringId) && Equals(IconNameStringId, other.IconNameStringId) && Equals(ExtensionWithDotStringId, other.ExtensionWithDotStringId);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (int) Type;
        __r = __r*31 + NodeId.GetHashCode();
        __r = __r*31 + (ParentNodeId != null ?ParentNodeId.GetHashCode() : 0);
        __r = __r*31 + (IconPackStringId != null ?IconPackStringId.GetHashCode() : 0);
        __r = __r*31 + (IconNameStringId != null ?IconNameStringId.GetHashCode() : 0);
        __r = __r*31 + (ExtensionWithDotStringId != null ?ExtensionWithDotStringId.GetHashCode() : 0);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("IconNode (");
      using (printer.IndentCookie()) {
        printer.Print("type = "); Type.PrintEx(printer); printer.Println();
        printer.Print("nodeId = "); NodeId.PrintEx(printer); printer.Println();
        printer.Print("parentNodeId = "); ParentNodeId.PrintEx(printer); printer.Println();
        printer.Print("iconPackStringId = "); IconPackStringId.PrintEx(printer); printer.Println();
        printer.Print("iconNameStringId = "); IconNameStringId.PrintEx(printer); printer.Println();
        printer.Print("extensionWithDotStringId = "); ExtensionWithDotStringId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum IconNodeType {
    Result,
    Composition,
    ImageSource,
    Shell,
    Rotated
  }
  
  
  public class ModelRichString : IPrintable, IEquatable<ModelRichString> {
    //fields
    [NotNull] public string Text {get; private set;}
    [CanBeNull] public RgbColor ForegroundColor {get; private set;}
    [CanBeNull] public RgbColor BackgroundColor {get; private set;}
    [CanBeNull] public RgbColor EffectColor {get; private set;}
    public JetBrains.Rider.Model.EffectStyle EffectStyle {get; private set;}
    public JetBrains.Rider.Model.FontStyle FontStyle {get; private set;}
    
    //primary constructor
    public ModelRichString(
      [NotNull] string text,
      [CanBeNull] RgbColor foregroundColor,
      [CanBeNull] RgbColor backgroundColor,
      [CanBeNull] RgbColor effectColor,
      JetBrains.Rider.Model.EffectStyle effectStyle,
      JetBrains.Rider.Model.FontStyle fontStyle
    )
    {
      Text = text;
      ForegroundColor = foregroundColor;
      BackgroundColor = backgroundColor;
      EffectColor = effectColor;
      EffectStyle = effectStyle;
      FontStyle = fontStyle;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RgbColor> ReadRgbColorNullable = RgbColor.Read.NullableClass();
    public static CtxReadDelegate<ModelRichString> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      var foregroundColor = ReadRgbColorNullable(ctx, reader);
      var backgroundColor = ReadRgbColorNullable(ctx, reader);
      var effectColor = ReadRgbColorNullable(ctx, reader);
      var effectStyle = (EffectStyle)reader.ReadInt();
      var fontStyle = (FontStyle)reader.ReadInt();
      return new ModelRichString(text, foregroundColor, backgroundColor, effectColor, effectStyle, fontStyle);
    };
    
    public static CtxWriteDelegate<RgbColor> WriteRgbColorNullable = RgbColor.Write.NullableClass();
    public static CtxWriteDelegate<ModelRichString> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
      WriteRgbColorNullable(ctx, writer, value.ForegroundColor);
      WriteRgbColorNullable(ctx, writer, value.BackgroundColor);
      WriteRgbColorNullable(ctx, writer, value.EffectColor);
      writer.Write((int)value.EffectStyle);
      writer.Write((int)value.FontStyle);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ModelRichString) obj);
    }
    public bool Equals(ModelRichString other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Text == other.Text && Equals(ForegroundColor, other.ForegroundColor) && Equals(BackgroundColor, other.BackgroundColor) && Equals(EffectColor, other.EffectColor) && EffectStyle == other.EffectStyle && FontStyle == other.FontStyle;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Text.GetHashCode();
        __r = __r*31 + (ForegroundColor != null ?ForegroundColor.GetHashCode() : 0);
        __r = __r*31 + (BackgroundColor != null ?BackgroundColor.GetHashCode() : 0);
        __r = __r*31 + (EffectColor != null ?EffectColor.GetHashCode() : 0);
        __r = __r*31 + (int) EffectStyle;
        __r = __r*31 + (int) FontStyle;
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ModelRichString (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("foregroundColor = "); ForegroundColor.PrintEx(printer); printer.Println();
        printer.Print("backgroundColor = "); BackgroundColor.PrintEx(printer); printer.Println();
        printer.Print("effectColor = "); EffectColor.PrintEx(printer); printer.Println();
        printer.Print("effectStyle = "); EffectStyle.PrintEx(printer); printer.Println();
        printer.Print("fontStyle = "); FontStyle.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ModelRichText : IPrintable, IEquatable<ModelRichText> {
    //fields
    [NotNull] public List<ModelRichString> Parts {get; private set;}
    
    //primary constructor
    public ModelRichText(
      [NotNull] List<ModelRichString> parts
    )
    {
      Parts = parts;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<ModelRichString>> ReadModelRichStringList = ModelRichString.Read.List();
    public static CtxReadDelegate<ModelRichText> Read = (ctx, reader) => 
    {
      var parts = ReadModelRichStringList(ctx, reader);
      return new ModelRichText(parts);
    };
    
    public static CtxWriteDelegate<List<ModelRichString>> WriteModelRichStringList = ModelRichString.Write.List();
    public static CtxWriteDelegate<ModelRichText> Write = (ctx, writer, value) => 
    {
      WriteModelRichStringList(ctx, writer, value.Parts);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ModelRichText) obj);
    }
    public bool Equals(ModelRichText other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Parts.SequenceEqual(other.Parts);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(Parts);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ModelRichText (");
      using (printer.IndentCookie()) {
        printer.Print("parts = "); Parts.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RgbColor : IPrintable, IEquatable<RgbColor> {
    //fields
    public int Red {get; private set;}
    public int Green {get; private set;}
    public int Blue {get; private set;}
    
    //primary constructor
    public RgbColor(
      int red,
      int green,
      int blue
    )
    {
      Red = red;
      Green = green;
      Blue = blue;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RgbColor> Read = (ctx, reader) => 
    {
      var red = reader.ReadInt();
      var green = reader.ReadInt();
      var blue = reader.ReadInt();
      return new RgbColor(red, green, blue);
    };
    
    public static CtxWriteDelegate<RgbColor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Red);
      writer.Write(value.Green);
      writer.Write(value.Blue);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RgbColor) obj);
    }
    public bool Equals(RgbColor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Red == other.Red && Green == other.Green && Blue == other.Blue;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Red.GetHashCode();
        __r = __r*31 + Green.GetHashCode();
        __r = __r*31 + Blue.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RgbColor (");
      using (printer.IndentCookie()) {
        printer.Print("red = "); Red.PrintEx(printer); printer.Println();
        printer.Print("green = "); Green.PrintEx(printer); printer.Println();
        printer.Print("blue = "); Blue.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
