using System;
using System.Linq;
using System.Collections.Generic;
using JetBrains.Application;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [ShellComponent]
  public class SolutionModel : RdBindableBase {
    //fields
    [NotNull] public IViewableMap<int, Solution> Solutions { get { return _Solutions; }}
    [NotNull] private readonly RdMap<int, Solution> _Solutions;
    [NotNull] public IRdProperty<bool> HasBackedSolution { get { return _HasBackedSolution; }}
    [NotNull] private readonly RdProperty<bool> _HasBackedSolution;
    
    //primary constructor
    public SolutionModel(
      [NotNull] RdMap<int, Solution> solutions,
      [NotNull] RdProperty<bool> hasBackedSolution
    )
    {
      _Solutions = solutions;
      _HasBackedSolution = hasBackedSolution;
      hasBackedSolution.OptimizeNested = true;
    }
    //secondary constructor
    //statics
    
    private void Register(ISerializers serializers)
    {
      serializers.Register(EditableEntityId.Read, EditableEntityId.Write);
      serializers.Register(SelectionRange.Read, SelectionRange.Write);
      serializers.Register(VisibleRange.Read, VisibleRange.Write);
      serializers.Register(RdTextRange.Read, RdTextRange.Write);
      serializers.RegisterEnum<ErrorStripeIndicatorStateEnum>();
      serializers.RegisterEnum<ScrollKind>();
      serializers.Register(ScrollingInfo.Read, ScrollingInfo.Write);
      serializers.Register(TextControlModel.Read, TextControlModel.Write);
      serializers.Register(TextControlId.Read, TextControlId.Write);
      serializers.Register(TextControlSnapshot.Read, TextControlSnapshot.Write);
      serializers.Register(FrontendTextControl.Read, FrontendTextControl.Write);
      serializers.RegisterEnum<CompletionMode>();
      serializers.Register(CompletionParameters.Read, CompletionParameters.Write);
      serializers.Register(CompletionItem.Read, CompletionItem.Write);
      serializers.Register(CompletionList.Read, CompletionList.Write);
      serializers.Register(CompletionAcceptance.Read, CompletionAcceptance.Write);
      serializers.Register(CompleteData.Read, CompleteData.Write);
      serializers.Register(ItemsToUpdate.Read, ItemsToUpdate.Write);
      serializers.Register(AdvancedPresentation.Read, AdvancedPresentation.Write);
      serializers.Register(ToUpdate.Read, ToUpdate.Write);
      serializers.RegisterEnum<FocusBehaviour>();
      serializers.RegisterEnum<SessionState>();
      serializers.Register(CompletionSessionModel.Read, CompletionSessionModel.Write);
      serializers.Register(DebugCompletionParameters.Read, DebugCompletionParameters.Write);
      serializers.Register(DebugCompletionProvider.Read, DebugCompletionProvider.Write);
      serializers.Register(SignatureItem.Read, SignatureItem.Write);
      serializers.Register(CreateSignatureList.Read, CreateSignatureList.Write);
      serializers.Register(UpdateSignatureList.Read, UpdateSignatureList.Write);
      serializers.Register(ParameterInfoModel.Read, ParameterInfoModel.Write);
      serializers.RegisterEnum<DaemonStateEnum>();
      serializers.Register(TooltipProviderModel.Read, TooltipProviderModel.Write);
      serializers.Register(RdGutterExecutionRequest.Read, RdGutterExecutionRequest.Write);
      serializers.Register(GutterMarkActionActivator.Read, GutterMarkActionActivator.Write);
      serializers.Register(DocumentVersion.Read, DocumentVersion.Write);
      serializers.Register(GutterMarkHighlighterModel.Read, GutterMarkHighlighterModel.Write);
      serializers.Register(FoldingHighlighterModel.Read, FoldingHighlighterModel.Write);
      serializers.Register(DefaultHighlighterModel.Read, DefaultHighlighterModel.Write);
      serializers.Register(HighlighterList.Read, HighlighterList.Write);
      serializers.Register(HighlighterIdList.Read, HighlighterIdList.Write);
      serializers.Register(MarkupDumpInfo.Read, MarkupDumpInfo.Write);
      serializers.Register(RdMarkupModel.Read, RdMarkupModel.Write);
      serializers.Register(StackTraceFileHyperlinkHighlighter.Read, StackTraceFileHyperlinkHighlighter.Write);
      serializers.Register(StackTraceHyperlinkHighlighter.Read, StackTraceHyperlinkHighlighter.Write);
      serializers.Register(StackTraceIdentifierHighlighter.Read, StackTraceIdentifierHighlighter.Write);
      serializers.Register(StackTraceFilterResult.Read, StackTraceFilterResult.Write);
      serializers.Register(StackTraceNavigationPoint.Read, StackTraceNavigationPoint.Write);
      serializers.Register(StackTraceFilterProvider.Read, StackTraceFilterProvider.Write);
      serializers.RegisterEnum<ShouldBeShown>();
      serializers.Register(AutoPopupResult.Read, AutoPopupResult.Write);
      serializers.Register(CompletionTuple.Read, CompletionTuple.Write);
      serializers.Register(LastFocusedTextControl.Read, LastFocusedTextControl.Write);
      serializers.Register(TextControlsCollection.Read, TextControlsCollection.Write);
      serializers.Register(EditableEntity.Read, EditableEntity.Write);
      serializers.RegisterEnum<RdMakeWritableResultKind>();
      serializers.Register(MakeWritableRequest.Read, MakeWritableRequest.Write);
      serializers.Register(MakeWritableResponse.Read, MakeWritableResponse.Write);
      serializers.Register(RdEnsureWritableHandler.Read, RdEnsureWritableHandler.Write);
      serializers.Register(RdCommandProcessor.Read, RdCommandProcessor.Write);
      serializers.Register(TextControlTuple.Read, TextControlTuple.Write);
      serializers.Register(EditableEntityCollection.Read, EditableEntityCollection.Write);
      serializers.Register(TodoItem.Read, TodoItem.Write);
      serializers.Register(TodoItems.Read, TodoItems.Write);
      serializers.RegisterEnum<TodoIconStyle>();
      serializers.Register(TodoPattern.Read, TodoPattern.Write);
      serializers.Register(TodoPatterns.Read, TodoPatterns.Write);
      serializers.Register(TodoModel.Read, TodoModel.Write);
      serializers.Register(PopupActionModel.Read, PopupActionModel.Write);
      serializers.Register(ActionPopupSession.Read, ActionPopupSession.Write);
      serializers.Register(RdNullLocation.Read, RdNullLocation.Write);
      serializers.Register(RdNameLocation.Read, RdNameLocation.Write);
      serializers.Register(RdCustomLocation.Read, RdCustomLocation.Write);
      serializers.RegisterEnum<RdSolutionState>();
      serializers.Register(RdSolutionDescriptor.Read, RdSolutionDescriptor.Write);
      serializers.Register(RdSolutionFolderDescriptor.Read, RdSolutionFolderDescriptor.Write);
      serializers.RegisterEnum<RdProjectState>();
      serializers.Register(RdProjectDescriptor.Read, RdProjectDescriptor.Write);
      serializers.Register(RdProjectFolderDescriptor.Read, RdProjectFolderDescriptor.Write);
      serializers.Register(RdProjectFileDescriptor.Read, RdProjectFileDescriptor.Write);
      serializers.RegisterEnum<RdUnloadProjectState>();
      serializers.Register(RdUnloadProjectDescriptor.Read, RdUnloadProjectDescriptor.Write);
      serializers.Register(RdAssemblyReferenceDescriptor.Read, RdAssemblyReferenceDescriptor.Write);
      serializers.Register(RdProjectReferenceDescriptor.Read, RdProjectReferenceDescriptor.Write);
      serializers.Register(RdUnresolvedReferenceDescriptor.Read, RdUnresolvedReferenceDescriptor.Write);
      serializers.Register(RdReferenceFolderDescriptor.Read, RdReferenceFolderDescriptor.Write);
      serializers.Register(RdFrameworkFolderDescriptor.Read, RdFrameworkFolderDescriptor.Write);
      serializers.RegisterEnum<RdDependencyType>();
      serializers.Register(RdDependencyDescriptor.Read, RdDependencyDescriptor.Write);
      serializers.Register(RdProjectModelItem.Read, RdProjectModelItem.Write);
      serializers.Register(RdProjectModelSyncData.Read, RdProjectModelSyncData.Write);
      serializers.Register(RdProjectModelView.Read, RdProjectModelView.Write);
      serializers.RegisterEnum<ProjectModelDumpFlags>();
      serializers.Register(ProjectModelDumpParams.Read, ProjectModelDumpParams.Write);
      serializers.RegisterEnum<ProjectModelTaskResultKind>();
      serializers.Register(ProjectModelTaskResult.Read, ProjectModelTaskResult.Write);
      serializers.Register(FileToOpen.Read, FileToOpen.Write);
      serializers.Register(OpenExistingSolution.Read, OpenExistingSolution.Write);
      serializers.Register(OpenExistingSolutionAndReformat.Read, OpenExistingSolutionAndReformat.Write);
      serializers.Register(OpenExistingSolutionAndPauseLoading.Read, OpenExistingSolutionAndPauseLoading.Write);
      serializers.Register(AddProjectCommand.Read, AddProjectCommand.Write);
      serializers.Register(AddSolutionFolderCommand.Read, AddSolutionFolderCommand.Write);
      serializers.Register(AddAssemblyReferenceCommandArgument.Read, AddAssemblyReferenceCommandArgument.Write);
      serializers.Register(AddProjectReferenceCommandArgument.Read, AddProjectReferenceCommandArgument.Write);
      serializers.Register(AddReferenceCommand.Read, AddReferenceCommand.Write);
      serializers.RegisterEnum<AddExistingItemStrategy>();
      serializers.Register(AddItemCommand.Read, AddItemCommand.Write);
      serializers.Register(AddItemResult.Read, AddItemResult.Write);
      serializers.Register(RenameItemCommand.Read, RenameItemCommand.Write);
      serializers.Register(RemoveCommand.Read, RemoveCommand.Write);
      serializers.Register(ExcludeCommand.Read, ExcludeCommand.Write);
      serializers.Register(CopyCommand.Read, CopyCommand.Write);
      serializers.Register(MoveCommand.Read, MoveCommand.Write);
      serializers.Register(UnloadCommand.Read, UnloadCommand.Write);
      serializers.Register(ReloadCommand.Read, ReloadCommand.Write);
      serializers.Register(ReloadAndShowLogCommand.Read, ReloadAndShowLogCommand.Write);
      serializers.Register(FindNamespaceCommand.Read, FindNamespaceCommand.Write);
      serializers.Register(ProjectTargetFrameworkId.Read, ProjectTargetFrameworkId.Write);
      serializers.Register(RdEditPropertiesSession.Read, RdEditPropertiesSession.Write);
      serializers.Register(RdEditPropertyItemText.Read, RdEditPropertyItemText.Write);
      serializers.Register(RdEditPropertyItemCheck.Read, RdEditPropertyItemCheck.Write);
      serializers.Register(RdEditPropertyItemTextBox.Read, RdEditPropertyItemTextBox.Write);
      serializers.Register(RdEditPropertyItemCheckBox.Read, RdEditPropertyItemCheckBox.Write);
      serializers.Register(RdEditPropertyItemComboBox.Read, RdEditPropertyItemComboBox.Write);
      serializers.Register(RdEditPropertySection.Read, RdEditPropertySection.Write);
      serializers.Register(RdEditProjectItemPropertiesContent.Read, RdEditProjectItemPropertiesContent.Write);
      serializers.Register(RdEditPropertiesMessageContent.Read, RdEditPropertiesMessageContent.Write);
      serializers.Register(ProjectModelTasks.Read, ProjectModelTasks.Write);
      serializers.Register(RdFileTemplate.Read, RdFileTemplate.Write);
      serializers.Register(RdGetTemplatesCommand.Read, RdGetTemplatesCommand.Write);
      serializers.Register(RdGeTemplatesResult.Read, RdGeTemplatesResult.Write);
      serializers.Register(RdCreateFromTemplateCommand.Read, RdCreateFromTemplateCommand.Write);
      serializers.Register(RdFileTemplateModel.Read, RdFileTemplateModel.Write);
      serializers.Register(RdFromTo.Read, RdFromTo.Write);
      serializers.Register(FileToSave.Read, FileToSave.Write);
      serializers.Register(FilesToSave.Read, FilesToSave.Write);
      serializers.Register(RdRefreshRequest.Read, RdRefreshRequest.Write);
      serializers.RegisterEnum<RdDeltaType>();
      serializers.Register(RdDelta.Read, RdDelta.Write);
      serializers.Register(RdDeltaBatch.Read, RdDeltaBatch.Write);
      serializers.Register(RdOperationResult.Read, RdOperationResult.Write);
      serializers.Register(RdFileSystemModel.Read, RdFileSystemModel.Write);
      serializers.Register(SearchItemData.Read, SearchItemData.Write);
      serializers.Register(GotoInput.Read, GotoInput.Write);
      serializers.Register(GotoResultList.Read, GotoResultList.Write);
      serializers.Register(GotoSearchSession.Read, GotoSearchSession.Write);
      serializers.RegisterEnum<GotoKind>();
      serializers.Register(SearchSessionTuple.Read, SearchSessionTuple.Write);
      serializers.Register(SearchPopup.Read, SearchPopup.Write);
      serializers.Register(TypeData.Read, TypeData.Write);
      serializers.Register(RdTypingAssistHost.Read, RdTypingAssistHost.Write);
      serializers.Register(RdUsagePosition.Read, RdUsagePosition.Write);
      serializers.Register(RdUsageAccessType.Read, RdUsageAccessType.Write);
      serializers.Register(RdUsageGroup.Read, RdUsageGroup.Write);
      serializers.Register(RdUsage.Read, RdUsage.Write);
      serializers.Register(RdMergeableUsage.Read, RdMergeableUsage.Write);
      serializers.Register(RdUsageNavigationData.Read, RdUsageNavigationData.Write);
      serializers.Register(RdUsageGroupNavigationData.Read, RdUsageGroupNavigationData.Write);
      serializers.Register(RdUsageList.Read, RdUsageList.Write);
      serializers.RegisterEnum<RdUsageKind>();
      serializers.Register(RdLightUsage.Read, RdLightUsage.Write);
      serializers.Register(RdHighlights.Read, RdHighlights.Write);
      serializers.Register(RdUsageTarget.Read, RdUsageTarget.Write);
      serializers.Register(RdUsageTargetNavigationData.Read, RdUsageTargetNavigationData.Write);
      serializers.Register(RdUsageTargetList.Read, RdUsageTargetList.Write);
      serializers.Register(RdFindUsagesSession.Read, RdFindUsagesSession.Write);
      serializers.Register(RdUsageGroupingRule.Read, RdUsageGroupingRule.Write);
      serializers.Register(RdUsageGroupingRuleList.Read, RdUsageGroupingRuleList.Write);
      serializers.Register(RdFindUsagesHost.Read, RdFindUsagesHost.Write);
      serializers.RegisterEnum<RdNuGetDependencyBehavior>();
      serializers.RegisterEnum<RdNuGetFileConflictAction>();
      serializers.RegisterEnum<RdNuGetVersionConstraints>();
      serializers.Register(RdNuGetVersionRange.Read, RdNuGetVersionRange.Write);
      serializers.Register(RdNuGetPackageVersionInfo.Read, RdNuGetPackageVersionInfo.Write);
      serializers.Register(RdNuGetPackageIdentity.Read, RdNuGetPackageIdentity.Write);
      serializers.Register(RdNuGetFramework.Read, RdNuGetFramework.Write);
      serializers.Register(RdNuGetPackageDependency.Read, RdNuGetPackageDependency.Write);
      serializers.Register(RdNuGetPackageDependencyGroup.Read, RdNuGetPackageDependencyGroup.Write);
      serializers.Register(RdNuGetPackageMetadata.Read, RdNuGetPackageMetadata.Write);
      serializers.Register(RdNuGetBriefMetadata.Read, RdNuGetBriefMetadata.Write);
      serializers.Register(RdNuGetPackages.Read, RdNuGetPackages.Write);
      serializers.Register(RdNuGetPackageSource.Read, RdNuGetPackageSource.Write);
      serializers.Register(RdNuGetConfig.Read, RdNuGetConfig.Write);
      serializers.Register(RdNuGetSettings.Read, RdNuGetSettings.Write);
      serializers.Register(RdNuGetProjects.Read, RdNuGetProjects.Write);
      serializers.RegisterEnum<RdNuGetLogLevel>();
      serializers.Register(RdNuGetLogMessage.Read, RdNuGetLogMessage.Write);
      serializers.Register(RdNuGetInstallRequest.Read, RdNuGetInstallRequest.Write);
      serializers.Register(RdNuGetUninstallRequest.Read, RdNuGetUninstallRequest.Write);
      serializers.Register(RdNuGetRestoreRequest.Read, RdNuGetRestoreRequest.Write);
      serializers.Register(RdNuGetUpgradeAllRequest.Read, RdNuGetUpgradeAllRequest.Write);
      serializers.Register(RdNuGetProjectInfo.Read, RdNuGetProjectInfo.Write);
      serializers.Register(RdNuGetChosenPackageView.Read, RdNuGetChosenPackageView.Write);
      serializers.Register(RdNuGetPackageSourceModel.Read, RdNuGetPackageSourceModel.Write);
      serializers.Register(RdNuGetPackageSources.Read, RdNuGetPackageSources.Write);
      serializers.Register(RdNuGetCacheFolder.Read, RdNuGetCacheFolder.Write);
      serializers.Register(RdNuGetCaches.Read, RdNuGetCaches.Write);
      serializers.Register(RdNuGetStateInfo.Read, RdNuGetStateInfo.Write);
      serializers.Register(RdNuGetHost.Read, RdNuGetHost.Write);
      serializers.RegisterEnum<RdUnitTestStatus>();
      serializers.Register(RdUnitTestResult.Read, RdUnitTestResult.Write);
      serializers.Register(RdUnitTestResultData.Read, RdUnitTestResultData.Write);
      serializers.Register(RdUnitTestOptions.Read, RdUnitTestOptions.Write);
      serializers.Register(RdUnitTestElement.Read, RdUnitTestElement.Write);
      serializers.Register(RdUnitTestElementList.Read, RdUnitTestElementList.Write);
      serializers.Register(RdUnitTestElementSet.Read, RdUnitTestElementSet.Write);
      serializers.Register(RdUnitTestSessionDescriptor.Read, RdUnitTestSessionDescriptor.Write);
      serializers.Register(RdUnitTestSelection.Read, RdUnitTestSelection.Write);
      serializers.Register(RdUnitTestElementManager.Read, RdUnitTestElementManager.Write);
      serializers.Register(RdUnitTestExplorerWindowService.Read, RdUnitTestExplorerWindowService.Write);
      serializers.Register(RdUnitTestOpenSessionArgs.Read, RdUnitTestOpenSessionArgs.Write);
      serializers.Register(RdUnitTestSessionConductor.Read, RdUnitTestSessionConductor.Write);
      serializers.Register(RdUniTestLaunchMessage.Read, RdUniTestLaunchMessage.Write);
      serializers.Register(RdUnitTestShowResultDataArgs.Read, RdUnitTestShowResultDataArgs.Write);
      serializers.Register(RdUnitTestSessionManipulator.Read, RdUnitTestSessionManipulator.Write);
      serializers.Register(RdUnitTestElementManipulatorSelectionRequest.Read, RdUnitTestElementManipulatorSelectionRequest.Write);
      serializers.Register(RdUnitTestElementManipulatorSimpleRequest.Read, RdUnitTestElementManipulatorSimpleRequest.Write);
      serializers.Register(RdUnitTestNavigateToElementArgs.Read, RdUnitTestNavigateToElementArgs.Write);
      serializers.Register(RdUnitTestNavigateToProjectArgs.Read, RdUnitTestNavigateToProjectArgs.Write);
      serializers.Register(RdUnitTestElementManipulator.Read, RdUnitTestElementManipulator.Write);
      serializers.Register(RdUnitTestResultItem.Read, RdUnitTestResultItem.Write);
      serializers.Register(RdUnitTestResultList.Read, RdUnitTestResultList.Write);
      serializers.Register(RdUnitTestResultManager.Read, RdUnitTestResultManager.Write);
      serializers.Register(RdUnitTestHost.Read, RdUnitTestHost.Write);
      serializers.RegisterEnum<AssertMode>();
      serializers.Register(RdMemoryUsageState.Read, RdMemoryUsageState.Write);
      serializers.Register(RdMemoryUsageIndicator.Read, RdMemoryUsageIndicator.Write);
      serializers.RegisterEnum<RdSpecialPathKind>();
      serializers.Register(RdSpecialPath.Read, RdSpecialPath.Write);
      serializers.Register(RdDiagnosticsHost.Read, RdDiagnosticsHost.Write);
      serializers.Register(CodeStructureTreeNode.Read, CodeStructureTreeNode.Write);
      serializers.Register(CodeStructureTreeNodesList.Read, CodeStructureTreeNodesList.Write);
      serializers.Register(CodeStructureTree.Read, CodeStructureTree.Write);
      serializers.Register(SolutionAnalysisError.Read, SolutionAnalysisError.Write);
      serializers.Register(SolutionAnalysisErrorWithIgnore.Read, SolutionAnalysisErrorWithIgnore.Write);
      serializers.Register(SolutionAnalysisErrorListWithIgnore.Read, SolutionAnalysisErrorListWithIgnore.Write);
      serializers.Register(SolutionAnalysisState.Read, SolutionAnalysisState.Write);
      serializers.Register(SolutionAnalysisNavigation.Read, SolutionAnalysisNavigation.Write);
      serializers.Register(SolutionAnalysisIgnore.Read, SolutionAnalysisIgnore.Write);
      serializers.Register(SolutionAnalysisErrors.Read, SolutionAnalysisErrors.Write);
      serializers.Register(SolutionAnalysisIconState.Read, SolutionAnalysisIconState.Write);
      serializers.RegisterEnum<SolutionAnalysisAction>();
      serializers.Register(SolutionAnalysisProjectModelIgnore.Read, SolutionAnalysisProjectModelIgnore.Write);
      serializers.Register(SolutionAnalysisModel.Read, SolutionAnalysisModel.Write);
      serializers.Register(ConfigurationPlatformCollection.Read, ConfigurationPlatformCollection.Write);
      serializers.Register(QuickDocElementInfo.Read, QuickDocElementInfo.Write);
      serializers.Register(QuickDocNavigationArgs.Read, QuickDocNavigationArgs.Write);
      serializers.Register(QuickDocSession.Read, QuickDocSession.Write);
      serializers.Register(QuickDocHostModel.Read, QuickDocHostModel.Write);
      serializers.Register(RdConfigurationAndPlatform.Read, RdConfigurationAndPlatform.Write);
      serializers.Register(SolutionProperties.Read, SolutionProperties.Write);
      serializers.Register(ToolWindowNavigation.Read, ToolWindowNavigation.Write);
      serializers.RegisterEnum<ProjectType>();
      serializers.Register(LoadResult.Read, LoadResult.Write);
      serializers.Register(SolutionLifecycle.Read, SolutionLifecycle.Write);
      serializers.RegisterEnum<ProjectOutputType>();
      serializers.Register(ProjectPropertiesModel.Read, ProjectPropertiesModel.Write);
      serializers.Register(ProjectModel.Read, ProjectModel.Write);
      serializers.Register(ProjectPropertiesHostModel.Read, ProjectPropertiesHostModel.Write);
      serializers.RegisterEnum<RunnableProjectKind>();
      serializers.Register(ProjectOutput.Read, ProjectOutput.Write);
      serializers.Register(RunnableProject.Read, RunnableProject.Write);
      serializers.Register(RunnableProjectsModel.Read, RunnableProjectsModel.Write);
      serializers.Register(DebuggerWorkerConnectionHelperModel.Read, DebuggerWorkerConnectionHelperModel.Write);
      serializers.Register(BreakpointVariantModel.Read, BreakpointVariantModel.Write);
      serializers.Register(BreakpointVariantList.Read, BreakpointVariantList.Write);
      serializers.Register(SourcePositionInfo.Read, SourcePositionInfo.Write);
      serializers.Register(BreakpointHelperHost.Read, BreakpointHelperHost.Write);
      serializers.Register(ResolveExpressionArgs.Read, ResolveExpressionArgs.Write);
      serializers.Register(ResolveExpressionResult.Read, ResolveExpressionResult.Write);
      serializers.Register(ResolveLocalSymbolArg.Read, ResolveLocalSymbolArg.Write);
      serializers.Register(ResolveLocalSymbolResult.Read, ResolveLocalSymbolResult.Write);
      serializers.Register(PsiDebuggerHostModel.Read, PsiDebuggerHostModel.Write);
      serializers.Register(StringPair.Read, StringPair.Write);
      serializers.Register(SessionStartDescriptor.Read, SessionStartDescriptor.Write);
      serializers.Register(HostDebuggerSessionModel.Read, HostDebuggerSessionModel.Write);
      serializers.Register(DebuggerSessionsHostModel.Read, DebuggerSessionsHostModel.Write);
      serializers.RegisterEnum<RiderBrowseMode>();
      serializers.Register(HyperlinkHighlightingArgs.Read, HyperlinkHighlightingArgs.Write);
      serializers.Register(HyperlinkHighlightingResult.Read, HyperlinkHighlightingResult.Write);
      serializers.Register(RdPsiElementRangeProvider.Read, RdPsiElementRangeProvider.Write);
      serializers.Register(RdLiveTemplateMacroArg.Read, RdLiveTemplateMacroArg.Write);
      serializers.Register(RdLiveTemplateMacro.Read, RdLiveTemplateMacro.Write);
      serializers.Register(RdLiveTemplateVariableRange.Read, RdLiveTemplateVariableRange.Write);
      serializers.Register(RdLiveTemplateVariable.Read, RdLiveTemplateVariable.Write);
      serializers.Register(RdLiveTemplateInitialData.Read, RdLiveTemplateInitialData.Write);
      serializers.Register(RdLiveTemplateSnapshot.Read, RdLiveTemplateSnapshot.Write);
      serializers.Register(RdLiveTemplateLookupItem.Read, RdLiveTemplateLookupItem.Write);
      serializers.Register(RdLiveTemplateLookup.Read, RdLiveTemplateLookup.Write);
      serializers.Register(RdLiveTemplateHost.Read, RdLiveTemplateHost.Write);
      serializers.RegisterEnum<ErrorStripeKind>();
      serializers.RegisterEnum<HighlighterEffectType>();
      serializers.Register(HighlighterDescription.Read, HighlighterDescription.Write);
      serializers.Register(HighlighterRegistryModel.Read, HighlighterRegistryModel.Write);
      serializers.RegisterEnum<GatewayState>();
      serializers.Register(RdTextEditingGateway.Read, RdTextEditingGateway.Write);
      serializers.Register(Solution.Read, Solution.Write);
    }
    
    public SolutionModel(Lifetime lifetime, IProtocol protocol) : this (
      new RdMap<int, Solution>().Static(1049),
      new RdProperty<bool>().Static(1050)
    )
    {
      Register(protocol.Serializers);
      Bind(lifetime, protocol, GetType().Name);
    }
    //init method
    protected override void Init(Lifetime lifetime) {
      _Solutions.BindEx(lifetime, this, "solutions");
      _HasBackedSolution.BindEx(lifetime, this, "hasBackedSolution");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Solutions.IdentifyEx(ids);
      _HasBackedSolution.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionModel (");
      using (printer.IndentCookie()) {
        printer.Print("solutions = "); _Solutions.PrintEx(printer); printer.Println();
        printer.Print("hasBackedSolution = "); _HasBackedSolution.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ActionPopupSession : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<PopupActionModel> PopupAction { get { return _PopupAction; }}
    [NotNull] private readonly RdProperty<PopupActionModel> _PopupAction;
    
    //primary constructor
    private ActionPopupSession(
      [NotNull] RdProperty<PopupActionModel> popupAction
    )
    {
      _PopupAction = popupAction;
    }
    //secondary constructor
    public ActionPopupSession (
    ) : this (
      new RdProperty<PopupActionModel>()
    ) {}
    //statics
    
    public static CtxReadDelegate<PopupActionModel> ReadPopupActionModelNullable = PopupActionModel.Read.NullableClass();
    public static CtxReadDelegate<ActionPopupSession> Read = (ctx, reader) => 
    {
      var popupAction = RdProperty<PopupActionModel>.Read(ctx, reader);
      return new ActionPopupSession(popupAction);
    };
    
    public static CtxWriteDelegate<PopupActionModel> WritePopupActionModelNullable = PopupActionModel.Write.NullableClass();
    public static CtxWriteDelegate<ActionPopupSession> Write = (ctx, writer, value) => 
    {
      RdProperty<PopupActionModel>.Write(ctx, writer, value._PopupAction);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _PopupAction.BindEx(lifetime, this, "popupAction");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _PopupAction.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ActionPopupSession (");
      using (printer.IndentCookie()) {
        printer.Print("popupAction = "); _PopupAction.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class AddAssemblyReferenceCommandArgument : AddReferenceCommandArgument
   {
    //fields
    [NotNull] public string AssemblyReferencePath {get; private set;}
    public int ProjectId {get; private set;}
    
    //primary constructor
    public AddAssemblyReferenceCommandArgument(
      [NotNull] string assemblyReferencePath,
      int projectId
    )
    {
      AssemblyReferencePath = assemblyReferencePath;
      ProjectId = projectId;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<AddAssemblyReferenceCommandArgument> Read = (ctx, reader) => 
    {
      var assemblyReferencePath = reader.ReadString();
      var projectId = reader.ReadInt();
      return new AddAssemblyReferenceCommandArgument(assemblyReferencePath, projectId);
    };
    
    public static new CtxWriteDelegate<AddAssemblyReferenceCommandArgument> Write = (ctx, writer, value) => 
    {
      writer.Write(value.AssemblyReferencePath);
      writer.Write(value.ProjectId);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((AddAssemblyReferenceCommandArgument) obj);
    }
    public bool Equals(AddAssemblyReferenceCommandArgument other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return AssemblyReferencePath == other.AssemblyReferencePath && ProjectId == other.ProjectId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + AssemblyReferencePath.GetHashCode();
        __r = __r*31 + ProjectId.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("AddAssemblyReferenceCommandArgument (");
      using (printer.IndentCookie()) {
        printer.Print("assemblyReferencePath = "); AssemblyReferencePath.PrintEx(printer); printer.Println();
        printer.Print("projectId = "); ProjectId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum AddExistingItemStrategy {
    AsLink,
    PreserveDirectories
  }
  
  
  public class AddItemCommand : IPrintable, IEquatable<AddItemCommand> {
    //fields
    [NotNull] public string ItemLocation {get; private set;}
    public int ParentId {get; private set;}
    public AddExistingItemStrategy Strategy {get; private set;}
    
    //primary constructor
    public AddItemCommand(
      [NotNull] string itemLocation,
      int parentId,
      AddExistingItemStrategy strategy
    )
    {
      ItemLocation = itemLocation;
      ParentId = parentId;
      Strategy = strategy;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<AddItemCommand> Read = (ctx, reader) => 
    {
      var itemLocation = reader.ReadString();
      var parentId = reader.ReadInt();
      var strategy = (AddExistingItemStrategy)reader.ReadInt();
      return new AddItemCommand(itemLocation, parentId, strategy);
    };
    
    public static CtxWriteDelegate<AddItemCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemLocation);
      writer.Write(value.ParentId);
      writer.Write((int)value.Strategy);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((AddItemCommand) obj);
    }
    public bool Equals(AddItemCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemLocation == other.ItemLocation && ParentId == other.ParentId && Strategy == other.Strategy;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + ItemLocation.GetHashCode();
        __r = __r*31 + ParentId.GetHashCode();
        __r = __r*31 + (int) Strategy;
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("AddItemCommand (");
      using (printer.IndentCookie()) {
        printer.Print("itemLocation = "); ItemLocation.PrintEx(printer); printer.Println();
        printer.Print("parentId = "); ParentId.PrintEx(printer); printer.Println();
        printer.Print("strategy = "); Strategy.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class AddItemResult : ProjectModelTaskResultContent
   {
    //fields
    public int ItemId {get; private set;}
    
    //primary constructor
    public AddItemResult(
      int itemId
    )
    {
      ItemId = itemId;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<AddItemResult> Read = (ctx, reader) => 
    {
      var itemId = reader.ReadInt();
      return new AddItemResult(itemId);
    };
    
    public static new CtxWriteDelegate<AddItemResult> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemId);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((AddItemResult) obj);
    }
    public bool Equals(AddItemResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemId == other.ItemId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + ItemId.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("AddItemResult (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class AddProjectCommand : IPrintable, IEquatable<AddProjectCommand> {
    //fields
    [NotNull] public string ProjectFileLocation {get; private set;}
    public int ParentId {get; private set;}
    public bool Reformat {get; private set;}
    public bool RestorePackages {get; private set;}
    [CanBeNull] public Guid? TypeGuid {get; private set;}
    [NotNull] public List<FileToOpen> FilesToOpen {get; private set;}
    
    //primary constructor
    public AddProjectCommand(
      [NotNull] string projectFileLocation,
      int parentId,
      bool reformat,
      bool restorePackages,
      [CanBeNull] Guid? typeGuid,
      [NotNull] List<FileToOpen> filesToOpen
    )
    {
      ProjectFileLocation = projectFileLocation;
      ParentId = parentId;
      Reformat = reformat;
      RestorePackages = restorePackages;
      TypeGuid = typeGuid;
      FilesToOpen = filesToOpen;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<Guid?> ReadGuidNullable = Serializers.ReadGuid.NullableStruct();
    public static CtxReadDelegate<List<FileToOpen>> ReadFileToOpenList = FileToOpen.Read.List();
    public static CtxReadDelegate<AddProjectCommand> Read = (ctx, reader) => 
    {
      var projectFileLocation = reader.ReadString();
      var parentId = reader.ReadInt();
      var reformat = reader.ReadBool();
      var restorePackages = reader.ReadBool();
      var typeGuid = ReadGuidNullable(ctx, reader);
      var filesToOpen = ReadFileToOpenList(ctx, reader);
      return new AddProjectCommand(projectFileLocation, parentId, reformat, restorePackages, typeGuid, filesToOpen);
    };
    
    public static CtxWriteDelegate<Guid?> WriteGuidNullable = Serializers.WriteGuid.NullableStruct();
    public static CtxWriteDelegate<List<FileToOpen>> WriteFileToOpenList = FileToOpen.Write.List();
    public static CtxWriteDelegate<AddProjectCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProjectFileLocation);
      writer.Write(value.ParentId);
      writer.Write(value.Reformat);
      writer.Write(value.RestorePackages);
      WriteGuidNullable(ctx, writer, value.TypeGuid);
      WriteFileToOpenList(ctx, writer, value.FilesToOpen);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((AddProjectCommand) obj);
    }
    public bool Equals(AddProjectCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectFileLocation == other.ProjectFileLocation && ParentId == other.ParentId && Reformat == other.Reformat && RestorePackages == other.RestorePackages && Equals(TypeGuid, other.TypeGuid) && FilesToOpen.SequenceEqual(other.FilesToOpen);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + ProjectFileLocation.GetHashCode();
        __r = __r*31 + ParentId.GetHashCode();
        __r = __r*31 + Reformat.GetHashCode();
        __r = __r*31 + RestorePackages.GetHashCode();
        __r = __r*31 + (TypeGuid != null ?TypeGuid.GetHashCode() : 0);
        __r = __r*31 + CollectionUtil.GetHashCode(FilesToOpen);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("AddProjectCommand (");
      using (printer.IndentCookie()) {
        printer.Print("projectFileLocation = "); ProjectFileLocation.PrintEx(printer); printer.Println();
        printer.Print("parentId = "); ParentId.PrintEx(printer); printer.Println();
        printer.Print("reformat = "); Reformat.PrintEx(printer); printer.Println();
        printer.Print("restorePackages = "); RestorePackages.PrintEx(printer); printer.Println();
        printer.Print("typeGuid = "); TypeGuid.PrintEx(printer); printer.Println();
        printer.Print("filesToOpen = "); FilesToOpen.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class AddProjectReferenceCommandArgument : AddReferenceCommandArgument
   {
    //fields
    [NotNull] public string ProjectReferencePath {get; private set;}
    public int ProjectId {get; private set;}
    
    //primary constructor
    public AddProjectReferenceCommandArgument(
      [NotNull] string projectReferencePath,
      int projectId
    )
    {
      ProjectReferencePath = projectReferencePath;
      ProjectId = projectId;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<AddProjectReferenceCommandArgument> Read = (ctx, reader) => 
    {
      var projectReferencePath = reader.ReadString();
      var projectId = reader.ReadInt();
      return new AddProjectReferenceCommandArgument(projectReferencePath, projectId);
    };
    
    public static new CtxWriteDelegate<AddProjectReferenceCommandArgument> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProjectReferencePath);
      writer.Write(value.ProjectId);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((AddProjectReferenceCommandArgument) obj);
    }
    public bool Equals(AddProjectReferenceCommandArgument other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectReferencePath == other.ProjectReferencePath && ProjectId == other.ProjectId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + ProjectReferencePath.GetHashCode();
        __r = __r*31 + ProjectId.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("AddProjectReferenceCommandArgument (");
      using (printer.IndentCookie()) {
        printer.Print("projectReferencePath = "); ProjectReferencePath.PrintEx(printer); printer.Println();
        printer.Print("projectId = "); ProjectId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class AddReferenceCommand : IPrintable, IEquatable<AddReferenceCommand> {
    //fields
    [NotNull] public List<AddReferenceCommandArgument> References {get; private set;}
    
    //primary constructor
    public AddReferenceCommand(
      [NotNull] List<AddReferenceCommandArgument> references
    )
    {
      References = references;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<AddReferenceCommandArgument>> ReadAddReferenceCommandArgumentList = AddReferenceCommandArgument.Read.List();
    public static CtxReadDelegate<AddReferenceCommand> Read = (ctx, reader) => 
    {
      var references = ReadAddReferenceCommandArgumentList(ctx, reader);
      return new AddReferenceCommand(references);
    };
    
    public static CtxWriteDelegate<List<AddReferenceCommandArgument>> WriteAddReferenceCommandArgumentList = AddReferenceCommandArgument.Write.List();
    public static CtxWriteDelegate<AddReferenceCommand> Write = (ctx, writer, value) => 
    {
      WriteAddReferenceCommandArgumentList(ctx, writer, value.References);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((AddReferenceCommand) obj);
    }
    public bool Equals(AddReferenceCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return References.SequenceEqual(other.References);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(References);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("AddReferenceCommand (");
      using (printer.IndentCookie()) {
        printer.Print("references = "); References.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class AddReferenceCommandArgument {
    //fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<AddReferenceCommandArgument> Read = (ctx, reader) => ctx.Serializers.Read<AddReferenceCommandArgument>(ctx, reader);
    
    public static CtxWriteDelegate<AddReferenceCommandArgument> Write = (ctx, writer, value) => ctx.Serializers.Write<AddReferenceCommandArgument>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class AddSolutionFolderCommand : IPrintable, IEquatable<AddSolutionFolderCommand> {
    //fields
    [NotNull] public string SolutionFolderName {get; private set;}
    public int ParentId {get; private set;}
    
    //primary constructor
    public AddSolutionFolderCommand(
      [NotNull] string solutionFolderName,
      int parentId
    )
    {
      SolutionFolderName = solutionFolderName;
      ParentId = parentId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<AddSolutionFolderCommand> Read = (ctx, reader) => 
    {
      var solutionFolderName = reader.ReadString();
      var parentId = reader.ReadInt();
      return new AddSolutionFolderCommand(solutionFolderName, parentId);
    };
    
    public static CtxWriteDelegate<AddSolutionFolderCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.SolutionFolderName);
      writer.Write(value.ParentId);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((AddSolutionFolderCommand) obj);
    }
    public bool Equals(AddSolutionFolderCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return SolutionFolderName == other.SolutionFolderName && ParentId == other.ParentId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + SolutionFolderName.GetHashCode();
        __r = __r*31 + ParentId.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("AddSolutionFolderCommand (");
      using (printer.IndentCookie()) {
        printer.Print("solutionFolderName = "); SolutionFolderName.PrintEx(printer); printer.Println();
        printer.Print("parentId = "); ParentId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class AdvancedPresentation : IPrintable, IEquatable<AdvancedPresentation> {
    //fields
    public int Id {get; private set;}
    [CanBeNull] public ModelRichText DisplayName {get; private set;}
    [CanBeNull] public string ReturnType {get; private set;}
    
    //primary constructor
    public AdvancedPresentation(
      int id,
      [CanBeNull] ModelRichText displayName,
      [CanBeNull] string returnType
    )
    {
      Id = id;
      DisplayName = displayName;
      ReturnType = returnType;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ModelRichText> ReadModelRichTextNullable = ModelRichText.Read.NullableClass();
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<AdvancedPresentation> Read = (ctx, reader) => 
    {
      var id = reader.ReadInt();
      var displayName = ReadModelRichTextNullable(ctx, reader);
      var returnType = ReadStringNullable(ctx, reader);
      return new AdvancedPresentation(id, displayName, returnType);
    };
    
    public static CtxWriteDelegate<ModelRichText> WriteModelRichTextNullable = ModelRichText.Write.NullableClass();
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<AdvancedPresentation> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      WriteModelRichTextNullable(ctx, writer, value.DisplayName);
      WriteStringNullable(ctx, writer, value.ReturnType);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((AdvancedPresentation) obj);
    }
    public bool Equals(AdvancedPresentation other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Equals(DisplayName, other.DisplayName) && Equals(ReturnType, other.ReturnType);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Id.GetHashCode();
        __r = __r*31 + (DisplayName != null ?DisplayName.GetHashCode() : 0);
        __r = __r*31 + (ReturnType != null ?ReturnType.GetHashCode() : 0);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("AdvancedPresentation (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("displayName = "); DisplayName.PrintEx(printer); printer.Println();
        printer.Print("returnType = "); ReturnType.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum AssertMode {
    Relaxed,
    ThrowAssert
  }
  
  
  public class AutoPopupResult : IPrintable, IEquatable<AutoPopupResult> {
    //fields
    public JetBrains.Rider.Model.ShouldBeShown ShouldBeShown {get; private set;}
    public int TypingTimeStamp {get; private set;}
    
    //primary constructor
    public AutoPopupResult(
      JetBrains.Rider.Model.ShouldBeShown shouldBeShown,
      int typingTimeStamp
    )
    {
      ShouldBeShown = shouldBeShown;
      TypingTimeStamp = typingTimeStamp;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<AutoPopupResult> Read = (ctx, reader) => 
    {
      var shouldBeShown = (ShouldBeShown)reader.ReadInt();
      var typingTimeStamp = reader.ReadInt();
      return new AutoPopupResult(shouldBeShown, typingTimeStamp);
    };
    
    public static CtxWriteDelegate<AutoPopupResult> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.ShouldBeShown);
      writer.Write(value.TypingTimeStamp);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((AutoPopupResult) obj);
    }
    public bool Equals(AutoPopupResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ShouldBeShown == other.ShouldBeShown && TypingTimeStamp == other.TypingTimeStamp;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (int) ShouldBeShown;
        __r = __r*31 + TypingTimeStamp.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("AutoPopupResult (");
      using (printer.IndentCookie()) {
        printer.Print("shouldBeShown = "); ShouldBeShown.PrintEx(printer); printer.Println();
        printer.Print("typingTimeStamp = "); TypingTimeStamp.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BreakpointHelperHost : RdBindableBase {
    //fields
    [NotNull] public RdEndpoint<SourcePositionInfo, BreakpointVariantList> GetPossibleBreakpointVariants { get { return _GetPossibleBreakpointVariants; }}
    [NotNull] private readonly RdEndpoint<SourcePositionInfo, BreakpointVariantList> _GetPossibleBreakpointVariants;
    
    //primary constructor
    private BreakpointHelperHost(
      [NotNull] RdEndpoint<SourcePositionInfo, BreakpointVariantList> getPossibleBreakpointVariants
    )
    {
      _GetPossibleBreakpointVariants = getPossibleBreakpointVariants;
      getPossibleBreakpointVariants.Async = true;
    }
    //secondary constructor
    public BreakpointHelperHost (
    ) : this (
      new RdEndpoint<SourcePositionInfo, BreakpointVariantList>()
    ) {}
    //statics
    
    public static CtxReadDelegate<BreakpointHelperHost> Read = (ctx, reader) => 
    {
      var getPossibleBreakpointVariants = RdEndpoint<SourcePositionInfo, BreakpointVariantList>.Read(ctx, reader);
      return new BreakpointHelperHost(getPossibleBreakpointVariants);
    };
    
    public static CtxWriteDelegate<BreakpointHelperHost> Write = (ctx, writer, value) => 
    {
      RdEndpoint<SourcePositionInfo, BreakpointVariantList>.Write(ctx, writer, value._GetPossibleBreakpointVariants);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _GetPossibleBreakpointVariants.BindEx(lifetime, this, "getPossibleBreakpointVariants");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _GetPossibleBreakpointVariants.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BreakpointHelperHost (");
      using (printer.IndentCookie()) {
        printer.Print("getPossibleBreakpointVariants = "); _GetPossibleBreakpointVariants.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BreakpointVariantList : IPrintable, IEquatable<BreakpointVariantList> {
    //fields
    [NotNull] public List<BreakpointVariantModel> Items {get; private set;}
    
    //primary constructor
    public BreakpointVariantList(
      [NotNull] List<BreakpointVariantModel> items
    )
    {
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<BreakpointVariantModel>> ReadBreakpointVariantModelList = BreakpointVariantModel.Read.List();
    public static CtxReadDelegate<BreakpointVariantList> Read = (ctx, reader) => 
    {
      var items = ReadBreakpointVariantModelList(ctx, reader);
      return new BreakpointVariantList(items);
    };
    
    public static CtxWriteDelegate<List<BreakpointVariantModel>> WriteBreakpointVariantModelList = BreakpointVariantModel.Write.List();
    public static CtxWriteDelegate<BreakpointVariantList> Write = (ctx, writer, value) => 
    {
      WriteBreakpointVariantModelList(ctx, writer, value.Items);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BreakpointVariantList) obj);
    }
    public bool Equals(BreakpointVariantList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Items.SequenceEqual(other.Items);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(Items);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BreakpointVariantList (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BreakpointVariantModel : IPrintable, IEquatable<BreakpointVariantModel> {
    //fields
    public int StartOffset {get; private set;}
    public int EndOffset {get; private set;}
    [NotNull] public string Text {get; private set;}
    
    //primary constructor
    public BreakpointVariantModel(
      int startOffset,
      int endOffset,
      [NotNull] string text
    )
    {
      StartOffset = startOffset;
      EndOffset = endOffset;
      Text = text;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BreakpointVariantModel> Read = (ctx, reader) => 
    {
      var startOffset = reader.ReadInt();
      var endOffset = reader.ReadInt();
      var text = reader.ReadString();
      return new BreakpointVariantModel(startOffset, endOffset, text);
    };
    
    public static CtxWriteDelegate<BreakpointVariantModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.StartOffset);
      writer.Write(value.EndOffset);
      writer.Write(value.Text);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BreakpointVariantModel) obj);
    }
    public bool Equals(BreakpointVariantModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return StartOffset == other.StartOffset && EndOffset == other.EndOffset && Text == other.Text;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + StartOffset.GetHashCode();
        __r = __r*31 + EndOffset.GetHashCode();
        __r = __r*31 + Text.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BreakpointVariantModel (");
      using (printer.IndentCookie()) {
        printer.Print("startOffset = "); StartOffset.PrintEx(printer); printer.Println();
        printer.Print("endOffset = "); EndOffset.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStructureTree : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<CodeStructureTreeNodesList> TreeNodes { get { return _TreeNodes; }}
    [NotNull] private readonly RdProperty<CodeStructureTreeNodesList> _TreeNodes;
    [NotNull] public ISink<int> NavigateTo { get { return _NavigateTo; }}
    [NotNull] private readonly RdSignal<int> _NavigateTo;
    
    //primary constructor
    private CodeStructureTree(
      [NotNull] RdProperty<CodeStructureTreeNodesList> treeNodes,
      [NotNull] RdSignal<int> navigateTo
    )
    {
      _TreeNodes = treeNodes;
      _NavigateTo = navigateTo;
      treeNodes.OptimizeNested = true;
    }
    //secondary constructor
    public CodeStructureTree (
    ) : this (
      new RdProperty<CodeStructureTreeNodesList>(),
      new RdSignal<int>()
    ) {}
    //statics
    
    public static CtxReadDelegate<CodeStructureTree> Read = (ctx, reader) => 
    {
      var treeNodes = RdProperty<CodeStructureTreeNodesList>.Read(ctx, reader);
      var navigateTo = RdSignal<int>.Read(ctx, reader);
      return new CodeStructureTree(treeNodes, navigateTo);
    };
    
    public static CtxWriteDelegate<CodeStructureTree> Write = (ctx, writer, value) => 
    {
      RdProperty<CodeStructureTreeNodesList>.Write(ctx, writer, value._TreeNodes);
      RdSignal<int>.Write(ctx, writer, value._NavigateTo);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _TreeNodes.BindEx(lifetime, this, "treeNodes");
      _NavigateTo.BindEx(lifetime, this, "navigateTo");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _TreeNodes.IdentifyEx(ids);
      _NavigateTo.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStructureTree (");
      using (printer.IndentCookie()) {
        printer.Print("treeNodes = "); _TreeNodes.PrintEx(printer); printer.Println();
        printer.Print("navigateTo = "); _NavigateTo.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStructureTreeNode : IPrintable, IEquatable<CodeStructureTreeNode> {
    //fields
    public int Id {get; private set;}
    [NotNull] public List<int> Children {get; private set;}
    public bool Navigable {get; private set;}
    public int Offset {get; private set;}
    [NotNull] public string Name {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //primary constructor
    public CodeStructureTreeNode(
      int id,
      [NotNull] List<int> children,
      bool navigable,
      int offset,
      [NotNull] string name,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    )
    {
      Id = id;
      Children = children;
      Navigable = navigable;
      Offset = offset;
      Name = name;
      Icon = icon;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<CodeStructureTreeNode> Read = (ctx, reader) => 
    {
      var id = reader.ReadInt();
      var children = ReadIntList(ctx, reader);
      var navigable = reader.ReadBool();
      var offset = reader.ReadInt();
      var name = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      return new CodeStructureTreeNode(id, children, navigable, offset, name, icon);
    };
    
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<CodeStructureTreeNode> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      WriteIntList(ctx, writer, value.Children);
      writer.Write(value.Navigable);
      writer.Write(value.Offset);
      writer.Write(value.Name);
      WriteIconNullable(ctx, writer, value.Icon);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CodeStructureTreeNode) obj);
    }
    public bool Equals(CodeStructureTreeNode other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Children.SequenceEqual(other.Children) && Navigable == other.Navigable && Offset == other.Offset && Name == other.Name && Equals(Icon, other.Icon);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Id.GetHashCode();
        __r = __r*31 + CollectionUtil.GetHashCode(Children);
        __r = __r*31 + Navigable.GetHashCode();
        __r = __r*31 + Offset.GetHashCode();
        __r = __r*31 + Name.GetHashCode();
        __r = __r*31 + (Icon != null ?Icon.GetHashCode() : 0);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStructureTreeNode (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("children = "); Children.PrintEx(printer); printer.Println();
        printer.Print("navigable = "); Navigable.PrintEx(printer); printer.Println();
        printer.Print("offset = "); Offset.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CodeStructureTreeNodesList : IPrintable, IEquatable<CodeStructureTreeNodesList> {
    //fields
    [NotNull] public List<CodeStructureTreeNode> TreeNodes {get; private set;}
    
    //primary constructor
    public CodeStructureTreeNodesList(
      [NotNull] List<CodeStructureTreeNode> treeNodes
    )
    {
      TreeNodes = treeNodes;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<CodeStructureTreeNode>> ReadCodeStructureTreeNodeList = CodeStructureTreeNode.Read.List();
    public static CtxReadDelegate<CodeStructureTreeNodesList> Read = (ctx, reader) => 
    {
      var treeNodes = ReadCodeStructureTreeNodeList(ctx, reader);
      return new CodeStructureTreeNodesList(treeNodes);
    };
    
    public static CtxWriteDelegate<List<CodeStructureTreeNode>> WriteCodeStructureTreeNodeList = CodeStructureTreeNode.Write.List();
    public static CtxWriteDelegate<CodeStructureTreeNodesList> Write = (ctx, writer, value) => 
    {
      WriteCodeStructureTreeNodeList(ctx, writer, value.TreeNodes);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CodeStructureTreeNodesList) obj);
    }
    public bool Equals(CodeStructureTreeNodesList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return TreeNodes.SequenceEqual(other.TreeNodes);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(TreeNodes);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CodeStructureTreeNodesList (");
      using (printer.IndentCookie()) {
        printer.Print("treeNodes = "); TreeNodes.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CompleteData : IPrintable, IEquatable<CompleteData> {
    //fields
    [NotNull] public CompletionItem Item {get; private set;}
    [CanBeNull] public char? TypedChar {get; private set;}
    
    //primary constructor
    public CompleteData(
      [NotNull] CompletionItem item,
      [CanBeNull] char? typedChar
    )
    {
      Item = item;
      TypedChar = typedChar;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<char?> ReadCharNullable = Serializers.ReadChar.NullableStruct();
    public static CtxReadDelegate<CompleteData> Read = (ctx, reader) => 
    {
      var item = CompletionItem.Read(ctx, reader);
      var typedChar = ReadCharNullable(ctx, reader);
      return new CompleteData(item, typedChar);
    };
    
    public static CtxWriteDelegate<char?> WriteCharNullable = Serializers.WriteChar.NullableStruct();
    public static CtxWriteDelegate<CompleteData> Write = (ctx, writer, value) => 
    {
      CompletionItem.Write(ctx, writer, value.Item);
      WriteCharNullable(ctx, writer, value.TypedChar);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CompleteData) obj);
    }
    public bool Equals(CompleteData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Item, other.Item) && Equals(TypedChar, other.TypedChar);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Item.GetHashCode();
        __r = __r*31 + (TypedChar != null ?TypedChar.GetHashCode() : 0);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CompleteData (");
      using (printer.IndentCookie()) {
        printer.Print("item = "); Item.PrintEx(printer); printer.Println();
        printer.Print("typedChar = "); TypedChar.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CompletionAcceptance : RdBindableBase {
    //fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CompletionAcceptance> Read = (ctx, reader) => 
    {
      return new CompletionAcceptance();
    };
    
    public static CtxWriteDelegate<CompletionAcceptance> Write = (ctx, writer, value) => 
    {
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CompletionAcceptance (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CompletionItem : IPrintable, IEquatable<CompletionItem> {
    //fields
    [NotNull] public string ShortText {get; private set;}
    [CanBeNull] public ModelRichText DisplayName {get; private set;}
    [CanBeNull] public string TypeName {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    public int Id {get; private set;}
    public long Priority {get; private set;}
    
    //primary constructor
    public CompletionItem(
      [NotNull] string shortText,
      [CanBeNull] ModelRichText displayName,
      [CanBeNull] string typeName,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      int id,
      long priority
    )
    {
      ShortText = shortText;
      DisplayName = displayName;
      TypeName = typeName;
      Icon = icon;
      Id = id;
      Priority = priority;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ModelRichText> ReadModelRichTextNullable = ModelRichText.Read.NullableClass();
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<CompletionItem> Read = (ctx, reader) => 
    {
      var shortText = reader.ReadString();
      var displayName = ReadModelRichTextNullable(ctx, reader);
      var typeName = ReadStringNullable(ctx, reader);
      var icon = ReadIconNullable(ctx, reader);
      var id = reader.ReadInt();
      var priority = reader.ReadLong();
      return new CompletionItem(shortText, displayName, typeName, icon, id, priority);
    };
    
    public static CtxWriteDelegate<ModelRichText> WriteModelRichTextNullable = ModelRichText.Write.NullableClass();
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<CompletionItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ShortText);
      WriteModelRichTextNullable(ctx, writer, value.DisplayName);
      WriteStringNullable(ctx, writer, value.TypeName);
      WriteIconNullable(ctx, writer, value.Icon);
      writer.Write(value.Id);
      writer.Write(value.Priority);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CompletionItem) obj);
    }
    public bool Equals(CompletionItem other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ShortText == other.ShortText && Equals(DisplayName, other.DisplayName) && Equals(TypeName, other.TypeName) && Equals(Icon, other.Icon) && Id == other.Id && Priority == other.Priority;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + ShortText.GetHashCode();
        __r = __r*31 + (DisplayName != null ?DisplayName.GetHashCode() : 0);
        __r = __r*31 + (TypeName != null ?TypeName.GetHashCode() : 0);
        __r = __r*31 + (Icon != null ?Icon.GetHashCode() : 0);
        __r = __r*31 + Id.GetHashCode();
        __r = __r*31 + Priority.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CompletionItem (");
      using (printer.IndentCookie()) {
        printer.Print("shortText = "); ShortText.PrintEx(printer); printer.Println();
        printer.Print("displayName = "); DisplayName.PrintEx(printer); printer.Println();
        printer.Print("typeName = "); TypeName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("priority = "); Priority.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CompletionList : IPrintable, IEquatable<CompletionList> {
    //fields
    [NotNull] public List<CompletionItem> Items {get; private set;}
    
    //primary constructor
    public CompletionList(
      [NotNull] List<CompletionItem> items
    )
    {
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<CompletionItem>> ReadCompletionItemList = CompletionItem.Read.List();
    public static CtxReadDelegate<CompletionList> Read = (ctx, reader) => 
    {
      var items = ReadCompletionItemList(ctx, reader);
      return new CompletionList(items);
    };
    
    public static CtxWriteDelegate<List<CompletionItem>> WriteCompletionItemList = CompletionItem.Write.List();
    public static CtxWriteDelegate<CompletionList> Write = (ctx, writer, value) => 
    {
      WriteCompletionItemList(ctx, writer, value.Items);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CompletionList) obj);
    }
    public bool Equals(CompletionList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Items.SequenceEqual(other.Items);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(Items);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CompletionList (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum CompletionMode {
    Basic,
    Smart,
    Import
  }
  
  
  public class CompletionParameters : RdBindableBase {
    //fields
    public CompletionMode Mode {get; private set;}
    public bool IsAutoCompletion {get; private set;}
    
    //primary constructor
    public CompletionParameters(
      CompletionMode mode,
      bool isAutoCompletion
    )
    {
      Mode = mode;
      IsAutoCompletion = isAutoCompletion;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CompletionParameters> Read = (ctx, reader) => 
    {
      var mode = (CompletionMode)reader.ReadInt();
      var isAutoCompletion = reader.ReadBool();
      return new CompletionParameters(mode, isAutoCompletion);
    };
    
    public static CtxWriteDelegate<CompletionParameters> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Mode);
      writer.Write(value.IsAutoCompletion);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CompletionParameters (");
      using (printer.IndentCookie()) {
        printer.Print("mode = "); Mode.PrintEx(printer); printer.Println();
        printer.Print("isAutoCompletion = "); IsAutoCompletion.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CompletionSessionModel : RdBindableBase {
    //fields
    [NotNull] public ISource<CompletionList> LightCompletionItems { get { return _LightCompletionItems; }}
    [NotNull] private readonly RdSignal<CompletionList> _LightCompletionItems;
    [NotNull] public ISource<CompletionList> AdvancedItems { get { return _AdvancedItems; }}
    [NotNull] private readonly RdSignal<CompletionList> _AdvancedItems;
    [NotNull] public ISource<FocusBehaviour> IsSoft { get { return _IsSoft; }}
    [NotNull] private readonly RdSignal<FocusBehaviour> _IsSoft;
    [NotNull] public IRdProperty<CompletionAcceptance> Acceptance { get { return _Acceptance; }}
    [NotNull] private readonly RdProperty<CompletionAcceptance> _Acceptance;
    [NotNull] public IRdProperty<bool> AdvancedItemsContainer { get { return _AdvancedItemsContainer; }}
    [NotNull] private readonly RdProperty<bool> _AdvancedItemsContainer;
    [NotNull] public IRdProperty<JetBrains.Rider.Model.SessionState> SessionState { get { return _SessionState; }}
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.SessionState> _SessionState;
    [NotNull] public RdEndpoint<CompleteData, bool> Complete { get { return _Complete; }}
    [NotNull] private readonly RdEndpoint<CompleteData, bool> _Complete;
    [NotNull] public RdEndpoint<ItemsToUpdate, ToUpdate> UpdatePresentation { get { return _UpdatePresentation; }}
    [NotNull] private readonly RdEndpoint<ItemsToUpdate, ToUpdate> _UpdatePresentation;
    
    //primary constructor
    private CompletionSessionModel(
      [NotNull] RdSignal<CompletionList> lightCompletionItems,
      [NotNull] RdSignal<CompletionList> advancedItems,
      [NotNull] RdSignal<FocusBehaviour> isSoft,
      [NotNull] RdProperty<CompletionAcceptance> acceptance,
      [NotNull] RdProperty<bool> advancedItemsContainer,
      [NotNull] RdProperty<JetBrains.Rider.Model.SessionState> sessionState,
      [NotNull] RdEndpoint<CompleteData, bool> complete,
      [NotNull] RdEndpoint<ItemsToUpdate, ToUpdate> updatePresentation
    )
    {
      _LightCompletionItems = lightCompletionItems;
      _AdvancedItems = advancedItems;
      _IsSoft = isSoft;
      _Acceptance = acceptance;
      _AdvancedItemsContainer = advancedItemsContainer;
      _SessionState = sessionState;
      _Complete = complete;
      _UpdatePresentation = updatePresentation;
      advancedItemsContainer.OptimizeNested = true;
      sessionState.OptimizeNested = true;
      lightCompletionItems.Async = true;
      advancedItems.Async = true;
      isSoft.Async = true;
    }
    //secondary constructor
    public CompletionSessionModel (
    ) : this (
      new RdSignal<CompletionList>(),
      new RdSignal<CompletionList>(),
      new RdSignal<FocusBehaviour>(),
      new RdProperty<CompletionAcceptance>(),
      new RdProperty<bool>(),
      new RdProperty<JetBrains.Rider.Model.SessionState>(),
      new RdEndpoint<CompleteData, bool>(),
      new RdEndpoint<ItemsToUpdate, ToUpdate>()
    ) {}
    //statics
    
    public static CtxReadDelegate<FocusBehaviour> ReadFocusBehaviour = new CtxReadDelegate<FocusBehaviour>(Serializers.ReadEnum<FocusBehaviour>);
    public static CtxReadDelegate<JetBrains.Rider.Model.SessionState> ReadSessionState = new CtxReadDelegate<SessionState>(Serializers.ReadEnum<SessionState>);
    public static CtxReadDelegate<CompleteData> ReadCompleteDataNullable = CompleteData.Read.NullableClass();
    public static CtxReadDelegate<CompletionSessionModel> Read = (ctx, reader) => 
    {
      var lightCompletionItems = RdSignal<CompletionList>.Read(ctx, reader);
      var advancedItems = RdSignal<CompletionList>.Read(ctx, reader);
      var isSoft = RdSignal<FocusBehaviour>.Read(ctx, reader);
      var acceptance = RdProperty<CompletionAcceptance>.Read(ctx, reader);
      var advancedItemsContainer = RdProperty<bool>.Read(ctx, reader);
      var sessionState = RdProperty<JetBrains.Rider.Model.SessionState>.Read(ctx, reader);
      var complete = RdEndpoint<CompleteData, bool>.Read(ctx, reader);
      var updatePresentation = RdEndpoint<ItemsToUpdate, ToUpdate>.Read(ctx, reader);
      return new CompletionSessionModel(lightCompletionItems, advancedItems, isSoft, acceptance, advancedItemsContainer, sessionState, complete, updatePresentation);
    };
    
    public static CtxWriteDelegate<FocusBehaviour> WriteFocusBehaviour = new CtxWriteDelegate<FocusBehaviour>(Serializers.WriteEnum<FocusBehaviour>);
    public static CtxWriteDelegate<JetBrains.Rider.Model.SessionState> WriteSessionState = new CtxWriteDelegate<SessionState>(Serializers.WriteEnum<SessionState>);
    public static CtxWriteDelegate<CompleteData> WriteCompleteDataNullable = CompleteData.Write.NullableClass();
    public static CtxWriteDelegate<CompletionSessionModel> Write = (ctx, writer, value) => 
    {
      RdSignal<CompletionList>.Write(ctx, writer, value._LightCompletionItems);
      RdSignal<CompletionList>.Write(ctx, writer, value._AdvancedItems);
      RdSignal<FocusBehaviour>.Write(ctx, writer, value._IsSoft);
      RdProperty<CompletionAcceptance>.Write(ctx, writer, value._Acceptance);
      RdProperty<bool>.Write(ctx, writer, value._AdvancedItemsContainer);
      RdProperty<JetBrains.Rider.Model.SessionState>.Write(ctx, writer, value._SessionState);
      RdEndpoint<CompleteData, bool>.Write(ctx, writer, value._Complete);
      RdEndpoint<ItemsToUpdate, ToUpdate>.Write(ctx, writer, value._UpdatePresentation);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _LightCompletionItems.BindEx(lifetime, this, "lightCompletionItems");
      _AdvancedItems.BindEx(lifetime, this, "advancedItems");
      _IsSoft.BindEx(lifetime, this, "isSoft");
      _Acceptance.BindEx(lifetime, this, "acceptance");
      _AdvancedItemsContainer.BindEx(lifetime, this, "advancedItemsContainer");
      _SessionState.BindEx(lifetime, this, "sessionState");
      _Complete.BindEx(lifetime, this, "complete");
      _UpdatePresentation.BindEx(lifetime, this, "updatePresentation");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _LightCompletionItems.IdentifyEx(ids);
      _AdvancedItems.IdentifyEx(ids);
      _IsSoft.IdentifyEx(ids);
      _Acceptance.IdentifyEx(ids);
      _AdvancedItemsContainer.IdentifyEx(ids);
      _SessionState.IdentifyEx(ids);
      _Complete.IdentifyEx(ids);
      _UpdatePresentation.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CompletionSessionModel (");
      using (printer.IndentCookie()) {
        printer.Print("lightCompletionItems = "); _LightCompletionItems.PrintEx(printer); printer.Println();
        printer.Print("advancedItems = "); _AdvancedItems.PrintEx(printer); printer.Println();
        printer.Print("isSoft = "); _IsSoft.PrintEx(printer); printer.Println();
        printer.Print("acceptance = "); _Acceptance.PrintEx(printer); printer.Println();
        printer.Print("advancedItemsContainer = "); _AdvancedItemsContainer.PrintEx(printer); printer.Println();
        printer.Print("sessionState = "); _SessionState.PrintEx(printer); printer.Println();
        printer.Print("complete = "); _Complete.PrintEx(printer); printer.Println();
        printer.Print("updatePresentation = "); _UpdatePresentation.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CompletionTuple : RdBindableBase {
    //fields
    [NotNull] public CompletionParameters Parameters {get; private set;}
    [NotNull] public CompletionSessionModel Session {get; private set;}
    
    //primary constructor
    private CompletionTuple(
      [NotNull] CompletionParameters parameters,
      [NotNull] CompletionSessionModel session
    )
    {
      Parameters = parameters;
      Session = session;
    }
    //secondary constructor
    public CompletionTuple (
      [NotNull] CompletionParameters Parameters
    ) : this (
      Parameters,
      new CompletionSessionModel()
    ) {}
    //statics
    
    public static CtxReadDelegate<CompletionTuple> Read = (ctx, reader) => 
    {
      var parameters = CompletionParameters.Read(ctx, reader);
      var session = CompletionSessionModel.Read(ctx, reader);
      return new CompletionTuple(parameters, session);
    };
    
    public static CtxWriteDelegate<CompletionTuple> Write = (ctx, writer, value) => 
    {
      CompletionParameters.Write(ctx, writer, value.Parameters);
      CompletionSessionModel.Write(ctx, writer, value.Session);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Parameters.BindEx(lifetime, this, "parameters");
      Session.BindEx(lifetime, this, "session");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Parameters.IdentifyEx(ids);
      Session.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CompletionTuple (");
      using (printer.IndentCookie()) {
        printer.Print("parameters = "); Parameters.PrintEx(printer); printer.Println();
        printer.Print("session = "); Session.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ConfigurationPlatformCollection : RdBindableBase {
    //fields
    [NotNull] public List<string> Configurations {get; private set;}
    [NotNull] public List<string> Platforms {get; private set;}
    
    //primary constructor
    public ConfigurationPlatformCollection(
      [NotNull] List<string> configurations,
      [NotNull] List<string> platforms
    )
    {
      Configurations = configurations;
      Platforms = platforms;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static CtxReadDelegate<ConfigurationPlatformCollection> Read = (ctx, reader) => 
    {
      var configurations = ReadStringList(ctx, reader);
      var platforms = ReadStringList(ctx, reader);
      return new ConfigurationPlatformCollection(configurations, platforms);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static CtxWriteDelegate<ConfigurationPlatformCollection> Write = (ctx, writer, value) => 
    {
      WriteStringList(ctx, writer, value.Configurations);
      WriteStringList(ctx, writer, value.Platforms);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ConfigurationPlatformCollection (");
      using (printer.IndentCookie()) {
        printer.Print("configurations = "); Configurations.PrintEx(printer); printer.Println();
        printer.Print("platforms = "); Platforms.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CopyCommand : IPrintable, IEquatable<CopyCommand> {
    //fields
    public int ItemId {get; private set;}
    public int ParentId {get; private set;}
    
    //primary constructor
    public CopyCommand(
      int itemId,
      int parentId
    )
    {
      ItemId = itemId;
      ParentId = parentId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CopyCommand> Read = (ctx, reader) => 
    {
      var itemId = reader.ReadInt();
      var parentId = reader.ReadInt();
      return new CopyCommand(itemId, parentId);
    };
    
    public static CtxWriteDelegate<CopyCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemId);
      writer.Write(value.ParentId);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CopyCommand) obj);
    }
    public bool Equals(CopyCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemId == other.ItemId && ParentId == other.ParentId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + ItemId.GetHashCode();
        __r = __r*31 + ParentId.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CopyCommand (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
        printer.Print("parentId = "); ParentId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CreateSignatureList : SignatureListBase
   {
    //fields
    [NotNull] public List<SignatureItem> Items {get; private set;}
    public int LBracketOffset {get; private set;}
    
    //primary constructor
    public CreateSignatureList(
      [NotNull] List<SignatureItem> items,
      int lBracketOffset,
      [CanBeNull] int? matchedSignature,
      int currentParamIndex,
      [NotNull] List<int> disabledSignatures
    ) : base (
      matchedSignature,
      currentParamIndex,
      disabledSignatures
     ) 
    {
      Items = items;
      LBracketOffset = lBracketOffset;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<SignatureItem>> ReadSignatureItemList = SignatureItem.Read.List();
    public static CtxReadDelegate<int?> ReadIntNullable = Serializers.ReadInt.NullableStruct();
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static new CtxReadDelegate<CreateSignatureList> Read = (ctx, reader) => 
    {
      var items = ReadSignatureItemList(ctx, reader);
      var lBracketOffset = reader.ReadInt();
      var matchedSignature = ReadIntNullable(ctx, reader);
      var currentParamIndex = reader.ReadInt();
      var disabledSignatures = ReadIntList(ctx, reader);
      return new CreateSignatureList(items, lBracketOffset, matchedSignature, currentParamIndex, disabledSignatures);
    };
    
    public static CtxWriteDelegate<List<SignatureItem>> WriteSignatureItemList = SignatureItem.Write.List();
    public static CtxWriteDelegate<int?> WriteIntNullable = Serializers.WriteInt.NullableStruct();
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static new CtxWriteDelegate<CreateSignatureList> Write = (ctx, writer, value) => 
    {
      WriteSignatureItemList(ctx, writer, value.Items);
      writer.Write(value.LBracketOffset);
      WriteIntNullable(ctx, writer, value.MatchedSignature);
      writer.Write(value.CurrentParamIndex);
      WriteIntList(ctx, writer, value.DisabledSignatures);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CreateSignatureList) obj);
    }
    public bool Equals(CreateSignatureList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Items.SequenceEqual(other.Items) && LBracketOffset == other.LBracketOffset && Equals(MatchedSignature, other.MatchedSignature) && CurrentParamIndex == other.CurrentParamIndex && DisabledSignatures.SequenceEqual(other.DisabledSignatures);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(Items);
        __r = __r*31 + LBracketOffset.GetHashCode();
        __r = __r*31 + (MatchedSignature != null ?MatchedSignature.GetHashCode() : 0);
        __r = __r*31 + CurrentParamIndex.GetHashCode();
        __r = __r*31 + CollectionUtil.GetHashCode(DisabledSignatures);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CreateSignatureList (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
        printer.Print("lBracketOffset = "); LBracketOffset.PrintEx(printer); printer.Println();
        printer.Print("matchedSignature = "); MatchedSignature.PrintEx(printer); printer.Println();
        printer.Print("currentParamIndex = "); CurrentParamIndex.PrintEx(printer); printer.Println();
        printer.Print("disabledSignatures = "); DisabledSignatures.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum DaemonStateEnum {
    HIDDEN,
    UNSUPPORTED,
    DISABLED,
    INVALIDATED,
    IN_PROGRESS_LOCAL,
    IN_PROGRESS_GLOBAL,
    UP_TO_DATE
  }
  
  
  public class DebugCompletionParameters : IPrintable, IEquatable<DebugCompletionParameters> {
    //fields
    [NotNull] public string Prefix {get; private set;}
    [NotNull] public string ProjectFile {get; private set;}
    public int ProjectFileOffset {get; private set;}
    
    //primary constructor
    public DebugCompletionParameters(
      [NotNull] string prefix,
      [NotNull] string projectFile,
      int projectFileOffset
    )
    {
      Prefix = prefix;
      ProjectFile = projectFile;
      ProjectFileOffset = projectFileOffset;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DebugCompletionParameters> Read = (ctx, reader) => 
    {
      var prefix = reader.ReadString();
      var projectFile = reader.ReadString();
      var projectFileOffset = reader.ReadInt();
      return new DebugCompletionParameters(prefix, projectFile, projectFileOffset);
    };
    
    public static CtxWriteDelegate<DebugCompletionParameters> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Prefix);
      writer.Write(value.ProjectFile);
      writer.Write(value.ProjectFileOffset);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DebugCompletionParameters) obj);
    }
    public bool Equals(DebugCompletionParameters other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Prefix == other.Prefix && ProjectFile == other.ProjectFile && ProjectFileOffset == other.ProjectFileOffset;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Prefix.GetHashCode();
        __r = __r*31 + ProjectFile.GetHashCode();
        __r = __r*31 + ProjectFileOffset.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DebugCompletionParameters (");
      using (printer.IndentCookie()) {
        printer.Print("prefix = "); Prefix.PrintEx(printer); printer.Println();
        printer.Print("projectFile = "); ProjectFile.PrintEx(printer); printer.Println();
        printer.Print("projectFileOffset = "); ProjectFileOffset.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DebugCompletionProvider : RdBindableBase {
    //fields
    [NotNull] public RdEndpoint<DebugCompletionParameters, CompletionList> GetCompletions { get { return _GetCompletions; }}
    [NotNull] private readonly RdEndpoint<DebugCompletionParameters, CompletionList> _GetCompletions;
    
    //primary constructor
    private DebugCompletionProvider(
      [NotNull] RdEndpoint<DebugCompletionParameters, CompletionList> getCompletions
    )
    {
      _GetCompletions = getCompletions;
      getCompletions.Async = true;
    }
    //secondary constructor
    public DebugCompletionProvider (
    ) : this (
      new RdEndpoint<DebugCompletionParameters, CompletionList>()
    ) {}
    //statics
    
    public static CtxReadDelegate<DebugCompletionProvider> Read = (ctx, reader) => 
    {
      var getCompletions = RdEndpoint<DebugCompletionParameters, CompletionList>.Read(ctx, reader);
      return new DebugCompletionProvider(getCompletions);
    };
    
    public static CtxWriteDelegate<DebugCompletionProvider> Write = (ctx, writer, value) => 
    {
      RdEndpoint<DebugCompletionParameters, CompletionList>.Write(ctx, writer, value._GetCompletions);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _GetCompletions.BindEx(lifetime, this, "getCompletions");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _GetCompletions.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DebugCompletionProvider (");
      using (printer.IndentCookie()) {
        printer.Print("getCompletions = "); _GetCompletions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DebuggerSessionsHostModel : RdBindableBase {
    //fields
    [NotNull] public IViewableMap<Guid, HostDebuggerSessionModel> Sessions { get { return _Sessions; }}
    [NotNull] private readonly RdMap<Guid, HostDebuggerSessionModel> _Sessions;
    
    //primary constructor
    private DebuggerSessionsHostModel(
      [NotNull] RdMap<Guid, HostDebuggerSessionModel> sessions
    )
    {
      _Sessions = sessions;
    }
    //secondary constructor
    public DebuggerSessionsHostModel (
    ) : this (
      new RdMap<Guid, HostDebuggerSessionModel>()
    ) {}
    //statics
    
    public static CtxReadDelegate<DebuggerSessionsHostModel> Read = (ctx, reader) => 
    {
      var sessions = RdMap<Guid, HostDebuggerSessionModel>.Read(ctx, reader);
      return new DebuggerSessionsHostModel(sessions);
    };
    
    public static CtxWriteDelegate<DebuggerSessionsHostModel> Write = (ctx, writer, value) => 
    {
      RdMap<Guid, HostDebuggerSessionModel>.Write(ctx, writer, value._Sessions);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Sessions.BindEx(lifetime, this, "sessions");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Sessions.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DebuggerSessionsHostModel (");
      using (printer.IndentCookie()) {
        printer.Print("sessions = "); _Sessions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DebuggerWorkerConnectionHelperModel : RdBindableBase {
    //fields
    [NotNull] public IViewableMap<long, int> Ports { get { return _Ports; }}
    [NotNull] private readonly RdMap<long, int> _Ports;
    
    //primary constructor
    private DebuggerWorkerConnectionHelperModel(
      [NotNull] RdMap<long, int> ports
    )
    {
      _Ports = ports;
      ports.OptimizeNested = true;
    }
    //secondary constructor
    public DebuggerWorkerConnectionHelperModel (
    ) : this (
      new RdMap<long, int>()
    ) {}
    //statics
    
    public static CtxReadDelegate<DebuggerWorkerConnectionHelperModel> Read = (ctx, reader) => 
    {
      var ports = RdMap<long, int>.Read(ctx, reader);
      return new DebuggerWorkerConnectionHelperModel(ports);
    };
    
    public static CtxWriteDelegate<DebuggerWorkerConnectionHelperModel> Write = (ctx, writer, value) => 
    {
      RdMap<long, int>.Write(ctx, writer, value._Ports);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Ports.BindEx(lifetime, this, "ports");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Ports.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DebuggerWorkerConnectionHelperModel (");
      using (printer.IndentCookie()) {
        printer.Print("ports = "); _Ports.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DefaultHighlighterModel : HighlighterModel
   {
    //fields
    //primary constructor
    public DefaultHighlighterModel(
      int layer,
      bool isExactRange,
      [NotNull] JetBrains.Rider.Model.DocumentVersion documentVersion,
      [CanBeNull] string textToHighlight,
      int id,
      int registryKey,
      int start,
      int end
    ) : base (
      layer,
      isExactRange,
      documentVersion,
      textToHighlight,
      id,
      registryKey,
      start,
      end
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static new CtxReadDelegate<DefaultHighlighterModel> Read = (ctx, reader) => 
    {
      var layer = reader.ReadInt();
      var isExactRange = reader.ReadBool();
      var documentVersion = JetBrains.Rider.Model.DocumentVersion.Read(ctx, reader);
      var textToHighlight = ReadStringNullable(ctx, reader);
      var id = reader.ReadInt();
      var registryKey = reader.ReadInt();
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      return new DefaultHighlighterModel(layer, isExactRange, documentVersion, textToHighlight, id, registryKey, start, end);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static new CtxWriteDelegate<DefaultHighlighterModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Layer);
      writer.Write(value.IsExactRange);
      JetBrains.Rider.Model.DocumentVersion.Write(ctx, writer, value.DocumentVersion);
      WriteStringNullable(ctx, writer, value.TextToHighlight);
      writer.Write(value.Id);
      writer.Write(value.RegistryKey);
      writer.Write(value.Start);
      writer.Write(value.End);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DefaultHighlighterModel) obj);
    }
    public bool Equals(DefaultHighlighterModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Layer == other.Layer && IsExactRange == other.IsExactRange && Equals(DocumentVersion, other.DocumentVersion) && Equals(TextToHighlight, other.TextToHighlight) && Id == other.Id && RegistryKey == other.RegistryKey && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Layer.GetHashCode();
        __r = __r*31 + IsExactRange.GetHashCode();
        __r = __r*31 + DocumentVersion.GetHashCode();
        __r = __r*31 + (TextToHighlight != null ?TextToHighlight.GetHashCode() : 0);
        __r = __r*31 + Id.GetHashCode();
        __r = __r*31 + RegistryKey.GetHashCode();
        __r = __r*31 + Start.GetHashCode();
        __r = __r*31 + End.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DefaultHighlighterModel (");
      using (printer.IndentCookie()) {
        printer.Print("layer = "); Layer.PrintEx(printer); printer.Println();
        printer.Print("isExactRange = "); IsExactRange.PrintEx(printer); printer.Println();
        printer.Print("documentVersion = "); DocumentVersion.PrintEx(printer); printer.Println();
        printer.Print("textToHighlight = "); TextToHighlight.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("registryKey = "); RegistryKey.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DocumentVersion : IPrintable, IEquatable<DocumentVersion> {
    //fields
    public int Master {get; private set;}
    public int Slave {get; private set;}
    
    //primary constructor
    public DocumentVersion(
      int master,
      int slave
    )
    {
      Master = master;
      Slave = slave;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DocumentVersion> Read = (ctx, reader) => 
    {
      var master = reader.ReadInt();
      var slave = reader.ReadInt();
      return new DocumentVersion(master, slave);
    };
    
    public static CtxWriteDelegate<DocumentVersion> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Master);
      writer.Write(value.Slave);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DocumentVersion) obj);
    }
    public bool Equals(DocumentVersion other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Master == other.Master && Slave == other.Slave;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Master.GetHashCode();
        __r = __r*31 + Slave.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DocumentVersion (");
      using (printer.IndentCookie()) {
        printer.Print("master = "); Master.PrintEx(printer); printer.Println();
        printer.Print("slave = "); Slave.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EditableEntity : RdBindableBase {
    //fields
    [NotNull] public TextControlsCollection TabsForDocument {get; private set;}
    [NotNull] public RdTextBuffer Text { get { return _Text; }}
    [NotNull] private readonly RdTextBuffer _Text;
    [NotNull] public RdMarkupModel Markup {get; private set;}
    [NotNull] public RdEndpoint<string, bool> CompareAllTextTask { get { return _CompareAllTextTask; }}
    [NotNull] private readonly RdEndpoint<string, bool> _CompareAllTextTask;
    
    //primary constructor
    private EditableEntity(
      [NotNull] TextControlsCollection tabsForDocument,
      [NotNull] RdTextBuffer text,
      [NotNull] RdMarkupModel markup,
      [NotNull] RdEndpoint<string, bool> compareAllTextTask
    )
    {
      TabsForDocument = tabsForDocument;
      _Text = text;
      Markup = markup;
      _CompareAllTextTask = compareAllTextTask;
    }
    //secondary constructor
    public EditableEntity (
      [NotNull] RdMarkupModel Markup
    ) : this (
      new TextControlsCollection(),
      new RdTextBuffer(),
      Markup,
      new RdEndpoint<string, bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<EditableEntity> Read = (ctx, reader) => 
    {
      var tabsForDocument = TextControlsCollection.Read(ctx, reader);
      var text = RdTextBuffer.Read(ctx, reader);
      var markup = RdMarkupModel.Read(ctx, reader);
      var compareAllTextTask = RdEndpoint<string, bool>.Read(ctx, reader);
      return new EditableEntity(tabsForDocument, text, markup, compareAllTextTask);
    };
    
    public static CtxWriteDelegate<EditableEntity> Write = (ctx, writer, value) => 
    {
      TextControlsCollection.Write(ctx, writer, value.TabsForDocument);
      RdTextBuffer.Write(ctx, writer, value._Text);
      RdMarkupModel.Write(ctx, writer, value.Markup);
      RdEndpoint<string, bool>.Write(ctx, writer, value._CompareAllTextTask);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      TabsForDocument.BindEx(lifetime, this, "tabsForDocument");
      _Text.BindEx(lifetime, this, "text");
      Markup.BindEx(lifetime, this, "markup");
      _CompareAllTextTask.BindEx(lifetime, this, "compareAllTextTask");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      TabsForDocument.IdentifyEx(ids);
      _Text.IdentifyEx(ids);
      Markup.IdentifyEx(ids);
      _CompareAllTextTask.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("EditableEntity (");
      using (printer.IndentCookie()) {
        printer.Print("tabsForDocument = "); TabsForDocument.PrintEx(printer); printer.Println();
        printer.Print("text = "); _Text.PrintEx(printer); printer.Println();
        printer.Print("markup = "); Markup.PrintEx(printer); printer.Println();
        printer.Print("compareAllTextTask = "); _CompareAllTextTask.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EditableEntityCollection : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<TextControlId> FocusedTextControlSession { get { return _FocusedTextControlSession; }}
    [NotNull] private readonly RdProperty<TextControlId> _FocusedTextControlSession;
    [NotNull] public IRdProperty<TextControlTuple> LastFocusedTextControlSession { get { return _LastFocusedTextControlSession; }}
    [NotNull] private readonly RdProperty<TextControlTuple> _LastFocusedTextControlSession;
    [NotNull] public ISink<FrontendTextControl> CheckInternalState { get { return _CheckInternalState; }}
    [NotNull] private readonly RdSignal<FrontendTextControl> _CheckInternalState;
    [NotNull] public RdEndpoint<RdVoid, string> DumpBackendTextControls { get { return _DumpBackendTextControls; }}
    [NotNull] private readonly RdEndpoint<RdVoid, string> _DumpBackendTextControls;
    [NotNull] public IViewableMap<EditableEntityId, EditableEntity> Documents { get { return _Documents; }}
    [NotNull] private readonly RdMap<EditableEntityId, EditableEntity> _Documents;
    [NotNull] public ISource<EditableEntityId> NeedRecover { get { return _NeedRecover; }}
    [NotNull] private readonly RdSignal<EditableEntityId> _NeedRecover;
    [NotNull] public IRdProperty<bool> CommittingTransaction { get { return _CommittingTransaction; }}
    [NotNull] private readonly RdProperty<bool> _CommittingTransaction;
    [NotNull] public RdCommandProcessor CommandProcessor {get; private set;}
    [NotNull] public IRdCall<bool, bool> SaveAllEditors { get { return _SaveAllEditors; }}
    [NotNull] private readonly RdCall<bool, bool> _SaveAllEditors;
    [NotNull] public IRdCall<string, bool> SaveFile { get { return _SaveFile; }}
    [NotNull] private readonly RdCall<string, bool> _SaveFile;
    
    //primary constructor
    private EditableEntityCollection(
      [NotNull] RdProperty<TextControlId> focusedTextControlSession,
      [NotNull] RdProperty<TextControlTuple> lastFocusedTextControlSession,
      [NotNull] RdSignal<FrontendTextControl> checkInternalState,
      [NotNull] RdEndpoint<RdVoid, string> dumpBackendTextControls,
      [NotNull] RdMap<EditableEntityId, EditableEntity> documents,
      [NotNull] RdSignal<EditableEntityId> needRecover,
      [NotNull] RdProperty<bool> committingTransaction,
      [NotNull] RdCommandProcessor commandProcessor,
      [NotNull] RdCall<bool, bool> saveAllEditors,
      [NotNull] RdCall<string, bool> saveFile
    )
    {
      _FocusedTextControlSession = focusedTextControlSession;
      _LastFocusedTextControlSession = lastFocusedTextControlSession;
      _CheckInternalState = checkInternalState;
      _DumpBackendTextControls = dumpBackendTextControls;
      _Documents = documents;
      _NeedRecover = needRecover;
      _CommittingTransaction = committingTransaction;
      CommandProcessor = commandProcessor;
      _SaveAllEditors = saveAllEditors;
      _SaveFile = saveFile;
      focusedTextControlSession.OptimizeNested = true;
      committingTransaction.OptimizeNested = true;
      lastFocusedTextControlSession.Async = true;
    }
    //secondary constructor
    public EditableEntityCollection (
    ) : this (
      new RdProperty<TextControlId>(),
      new RdProperty<TextControlTuple>(),
      new RdSignal<FrontendTextControl>(),
      new RdEndpoint<RdVoid, string>(),
      new RdMap<EditableEntityId, EditableEntity>(),
      new RdSignal<EditableEntityId>(),
      new RdProperty<bool>(),
      new RdCommandProcessor(),
      new RdCall<bool, bool>(),
      new RdCall<string, bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<TextControlId> ReadTextControlIdNullable = TextControlId.Read.NullableClass();
    public static CtxReadDelegate<TextControlTuple> ReadTextControlTupleNullable = TextControlTuple.Read.NullableClass();
    public static CtxReadDelegate<EditableEntityCollection> Read = (ctx, reader) => 
    {
      var focusedTextControlSession = RdProperty<TextControlId>.Read(ctx, reader);
      var lastFocusedTextControlSession = RdProperty<TextControlTuple>.Read(ctx, reader);
      var checkInternalState = RdSignal<FrontendTextControl>.Read(ctx, reader);
      var dumpBackendTextControls = RdEndpoint<RdVoid, string>.Read(ctx, reader);
      var documents = RdMap<EditableEntityId, EditableEntity>.Read(ctx, reader);
      var needRecover = RdSignal<EditableEntityId>.Read(ctx, reader);
      var committingTransaction = RdProperty<bool>.Read(ctx, reader);
      var commandProcessor = RdCommandProcessor.Read(ctx, reader);
      var saveAllEditors = RdCall<bool, bool>.Read(ctx, reader);
      var saveFile = RdCall<string, bool>.Read(ctx, reader);
      return new EditableEntityCollection(focusedTextControlSession, lastFocusedTextControlSession, checkInternalState, dumpBackendTextControls, documents, needRecover, committingTransaction, commandProcessor, saveAllEditors, saveFile);
    };
    
    public static CtxWriteDelegate<TextControlId> WriteTextControlIdNullable = TextControlId.Write.NullableClass();
    public static CtxWriteDelegate<TextControlTuple> WriteTextControlTupleNullable = TextControlTuple.Write.NullableClass();
    public static CtxWriteDelegate<EditableEntityCollection> Write = (ctx, writer, value) => 
    {
      RdProperty<TextControlId>.Write(ctx, writer, value._FocusedTextControlSession);
      RdProperty<TextControlTuple>.Write(ctx, writer, value._LastFocusedTextControlSession);
      RdSignal<FrontendTextControl>.Write(ctx, writer, value._CheckInternalState);
      RdEndpoint<RdVoid, string>.Write(ctx, writer, value._DumpBackendTextControls);
      RdMap<EditableEntityId, EditableEntity>.Write(ctx, writer, value._Documents);
      RdSignal<EditableEntityId>.Write(ctx, writer, value._NeedRecover);
      RdProperty<bool>.Write(ctx, writer, value._CommittingTransaction);
      RdCommandProcessor.Write(ctx, writer, value.CommandProcessor);
      RdCall<bool, bool>.Write(ctx, writer, value._SaveAllEditors);
      RdCall<string, bool>.Write(ctx, writer, value._SaveFile);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _FocusedTextControlSession.BindEx(lifetime, this, "focusedTextControlSession");
      _LastFocusedTextControlSession.BindEx(lifetime, this, "lastFocusedTextControlSession");
      _CheckInternalState.BindEx(lifetime, this, "checkInternalState");
      _DumpBackendTextControls.BindEx(lifetime, this, "dumpBackendTextControls");
      _Documents.BindEx(lifetime, this, "documents");
      _NeedRecover.BindEx(lifetime, this, "needRecover");
      _CommittingTransaction.BindEx(lifetime, this, "committingTransaction");
      CommandProcessor.BindEx(lifetime, this, "commandProcessor");
      _SaveAllEditors.BindEx(lifetime, this, "saveAllEditors");
      _SaveFile.BindEx(lifetime, this, "saveFile");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _FocusedTextControlSession.IdentifyEx(ids);
      _LastFocusedTextControlSession.IdentifyEx(ids);
      _CheckInternalState.IdentifyEx(ids);
      _DumpBackendTextControls.IdentifyEx(ids);
      _Documents.IdentifyEx(ids);
      _NeedRecover.IdentifyEx(ids);
      _CommittingTransaction.IdentifyEx(ids);
      CommandProcessor.IdentifyEx(ids);
      _SaveAllEditors.IdentifyEx(ids);
      _SaveFile.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("EditableEntityCollection (");
      using (printer.IndentCookie()) {
        printer.Print("focusedTextControlSession = "); _FocusedTextControlSession.PrintEx(printer); printer.Println();
        printer.Print("lastFocusedTextControlSession = "); _LastFocusedTextControlSession.PrintEx(printer); printer.Println();
        printer.Print("checkInternalState = "); _CheckInternalState.PrintEx(printer); printer.Println();
        printer.Print("dumpBackendTextControls = "); _DumpBackendTextControls.PrintEx(printer); printer.Println();
        printer.Print("documents = "); _Documents.PrintEx(printer); printer.Println();
        printer.Print("needRecover = "); _NeedRecover.PrintEx(printer); printer.Println();
        printer.Print("committingTransaction = "); _CommittingTransaction.PrintEx(printer); printer.Println();
        printer.Print("commandProcessor = "); CommandProcessor.PrintEx(printer); printer.Println();
        printer.Print("saveAllEditors = "); _SaveAllEditors.PrintEx(printer); printer.Println();
        printer.Print("saveFile = "); _SaveFile.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EditableEntityId : IPrintable, IEquatable<EditableEntityId> {
    //fields
    public int ProjectModelElementId {get; private set;}
    [NotNull] public string FilePath {get; private set;}
    
    //primary constructor
    public EditableEntityId(
      int projectModelElementId,
      [NotNull] string filePath
    )
    {
      ProjectModelElementId = projectModelElementId;
      FilePath = filePath;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<EditableEntityId> Read = (ctx, reader) => 
    {
      var projectModelElementId = reader.ReadInt();
      var filePath = reader.ReadString();
      return new EditableEntityId(projectModelElementId, filePath);
    };
    
    public static CtxWriteDelegate<EditableEntityId> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProjectModelElementId);
      writer.Write(value.FilePath);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((EditableEntityId) obj);
    }
    public bool Equals(EditableEntityId other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectModelElementId == other.ProjectModelElementId && FilePath == other.FilePath;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + ProjectModelElementId.GetHashCode();
        __r = __r*31 + FilePath.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("EditableEntityId (");
      using (printer.IndentCookie()) {
        printer.Print("projectModelElementId = "); ProjectModelElementId.PrintEx(printer); printer.Println();
        printer.Print("filePath = "); FilePath.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ErrorStripeIndicatorStateEnum {
    HIDDEN,
    OFF,
    INVALID,
    WORKING,
    ON
  }
  
  
  public enum ErrorStripeKind {
    NONE,
    WARNING,
    ERROR
  }
  
  
  public class ExcludeCommand : IPrintable, IEquatable<ExcludeCommand> {
    //fields
    public int ItemId {get; private set;}
    
    //primary constructor
    public ExcludeCommand(
      int itemId
    )
    {
      ItemId = itemId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ExcludeCommand> Read = (ctx, reader) => 
    {
      var itemId = reader.ReadInt();
      return new ExcludeCommand(itemId);
    };
    
    public static CtxWriteDelegate<ExcludeCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemId);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ExcludeCommand) obj);
    }
    public bool Equals(ExcludeCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemId == other.ItemId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + ItemId.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ExcludeCommand (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class FileToOpen : IPrintable, IEquatable<FileToOpen> {
    //fields
    [NotNull] public string FileName {get; private set;}
    public int Caret {get; private set;}
    
    //primary constructor
    public FileToOpen(
      [NotNull] string fileName,
      int caret
    )
    {
      FileName = fileName;
      Caret = caret;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<FileToOpen> Read = (ctx, reader) => 
    {
      var fileName = reader.ReadString();
      var caret = reader.ReadInt();
      return new FileToOpen(fileName, caret);
    };
    
    public static CtxWriteDelegate<FileToOpen> Write = (ctx, writer, value) => 
    {
      writer.Write(value.FileName);
      writer.Write(value.Caret);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((FileToOpen) obj);
    }
    public bool Equals(FileToOpen other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return FileName == other.FileName && Caret == other.Caret;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + FileName.GetHashCode();
        __r = __r*31 + Caret.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("FileToOpen (");
      using (printer.IndentCookie()) {
        printer.Print("fileName = "); FileName.PrintEx(printer); printer.Println();
        printer.Print("caret = "); Caret.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class FileToSave : IPrintable, IEquatable<FileToSave> {
    //fields
    [NotNull] public string Path {get; private set;}
    [NotNull] public string FullText {get; private set;}
    
    //primary constructor
    public FileToSave(
      [NotNull] string path,
      [NotNull] string fullText
    )
    {
      Path = path;
      FullText = fullText;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<FileToSave> Read = (ctx, reader) => 
    {
      var path = reader.ReadString();
      var fullText = reader.ReadString();
      return new FileToSave(path, fullText);
    };
    
    public static CtxWriteDelegate<FileToSave> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Path);
      writer.Write(value.FullText);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((FileToSave) obj);
    }
    public bool Equals(FileToSave other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Path == other.Path && FullText == other.FullText;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Path.GetHashCode();
        __r = __r*31 + FullText.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("FileToSave (");
      using (printer.IndentCookie()) {
        printer.Print("path = "); Path.PrintEx(printer); printer.Println();
        printer.Print("fullText = "); FullText.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class FilesToSave : IPrintable, IEquatable<FilesToSave> {
    //fields
    [NotNull] public List<FileToSave> Files {get; private set;}
    
    //primary constructor
    public FilesToSave(
      [NotNull] List<FileToSave> files
    )
    {
      Files = files;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<FileToSave>> ReadFileToSaveList = FileToSave.Read.List();
    public static CtxReadDelegate<FilesToSave> Read = (ctx, reader) => 
    {
      var files = ReadFileToSaveList(ctx, reader);
      return new FilesToSave(files);
    };
    
    public static CtxWriteDelegate<List<FileToSave>> WriteFileToSaveList = FileToSave.Write.List();
    public static CtxWriteDelegate<FilesToSave> Write = (ctx, writer, value) => 
    {
      WriteFileToSaveList(ctx, writer, value.Files);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((FilesToSave) obj);
    }
    public bool Equals(FilesToSave other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Files.SequenceEqual(other.Files);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(Files);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("FilesToSave (");
      using (printer.IndentCookie()) {
        printer.Print("files = "); Files.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class FindNamespaceCommand : IPrintable, IEquatable<FindNamespaceCommand> {
    //fields
    public int ItemId {get; private set;}
    [NotNull] public string Language {get; private set;}
    
    //primary constructor
    public FindNamespaceCommand(
      int itemId,
      [NotNull] string language
    )
    {
      ItemId = itemId;
      Language = language;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<FindNamespaceCommand> Read = (ctx, reader) => 
    {
      var itemId = reader.ReadInt();
      var language = reader.ReadString();
      return new FindNamespaceCommand(itemId, language);
    };
    
    public static CtxWriteDelegate<FindNamespaceCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemId);
      writer.Write(value.Language);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((FindNamespaceCommand) obj);
    }
    public bool Equals(FindNamespaceCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemId == other.ItemId && Language == other.Language;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + ItemId.GetHashCode();
        __r = __r*31 + Language.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("FindNamespaceCommand (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
        printer.Print("language = "); Language.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum FocusBehaviour {
    Soft,
    SoftWhenEmpty,
    Hard
  }
  
  
  public class FoldingHighlighterModel : HighlighterModel
   {
    //fields
    [NotNull] public string PlaceholderText {get; private set;}
    public bool CollapsedByDefault {get; private set;}
    
    //primary constructor
    public FoldingHighlighterModel(
      [NotNull] string placeholderText,
      bool collapsedByDefault,
      int layer,
      bool isExactRange,
      [NotNull] JetBrains.Rider.Model.DocumentVersion documentVersion,
      [CanBeNull] string textToHighlight,
      int id,
      int registryKey,
      int start,
      int end
    ) : base (
      layer,
      isExactRange,
      documentVersion,
      textToHighlight,
      id,
      registryKey,
      start,
      end
     ) 
    {
      PlaceholderText = placeholderText;
      CollapsedByDefault = collapsedByDefault;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static new CtxReadDelegate<FoldingHighlighterModel> Read = (ctx, reader) => 
    {
      var placeholderText = reader.ReadString();
      var collapsedByDefault = reader.ReadBool();
      var layer = reader.ReadInt();
      var isExactRange = reader.ReadBool();
      var documentVersion = JetBrains.Rider.Model.DocumentVersion.Read(ctx, reader);
      var textToHighlight = ReadStringNullable(ctx, reader);
      var id = reader.ReadInt();
      var registryKey = reader.ReadInt();
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      return new FoldingHighlighterModel(placeholderText, collapsedByDefault, layer, isExactRange, documentVersion, textToHighlight, id, registryKey, start, end);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static new CtxWriteDelegate<FoldingHighlighterModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.PlaceholderText);
      writer.Write(value.CollapsedByDefault);
      writer.Write(value.Layer);
      writer.Write(value.IsExactRange);
      JetBrains.Rider.Model.DocumentVersion.Write(ctx, writer, value.DocumentVersion);
      WriteStringNullable(ctx, writer, value.TextToHighlight);
      writer.Write(value.Id);
      writer.Write(value.RegistryKey);
      writer.Write(value.Start);
      writer.Write(value.End);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((FoldingHighlighterModel) obj);
    }
    public bool Equals(FoldingHighlighterModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return PlaceholderText == other.PlaceholderText && CollapsedByDefault == other.CollapsedByDefault && Layer == other.Layer && IsExactRange == other.IsExactRange && Equals(DocumentVersion, other.DocumentVersion) && Equals(TextToHighlight, other.TextToHighlight) && Id == other.Id && RegistryKey == other.RegistryKey && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + PlaceholderText.GetHashCode();
        __r = __r*31 + CollapsedByDefault.GetHashCode();
        __r = __r*31 + Layer.GetHashCode();
        __r = __r*31 + IsExactRange.GetHashCode();
        __r = __r*31 + DocumentVersion.GetHashCode();
        __r = __r*31 + (TextToHighlight != null ?TextToHighlight.GetHashCode() : 0);
        __r = __r*31 + Id.GetHashCode();
        __r = __r*31 + RegistryKey.GetHashCode();
        __r = __r*31 + Start.GetHashCode();
        __r = __r*31 + End.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("FoldingHighlighterModel (");
      using (printer.IndentCookie()) {
        printer.Print("placeholderText = "); PlaceholderText.PrintEx(printer); printer.Println();
        printer.Print("collapsedByDefault = "); CollapsedByDefault.PrintEx(printer); printer.Println();
        printer.Print("layer = "); Layer.PrintEx(printer); printer.Println();
        printer.Print("isExactRange = "); IsExactRange.PrintEx(printer); printer.Println();
        printer.Print("documentVersion = "); DocumentVersion.PrintEx(printer); printer.Println();
        printer.Print("textToHighlight = "); TextToHighlight.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("registryKey = "); RegistryKey.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class FrontendTextControl : IPrintable, IEquatable<FrontendTextControl> {
    //fields
    [NotNull] public TextControlId Id {get; private set;}
    [NotNull] public TextControlSnapshot FrontendState {get; private set;}
    
    //primary constructor
    public FrontendTextControl(
      [NotNull] TextControlId id,
      [NotNull] TextControlSnapshot frontendState
    )
    {
      Id = id;
      FrontendState = frontendState;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<FrontendTextControl> Read = (ctx, reader) => 
    {
      var id = TextControlId.Read(ctx, reader);
      var frontendState = TextControlSnapshot.Read(ctx, reader);
      return new FrontendTextControl(id, frontendState);
    };
    
    public static CtxWriteDelegate<FrontendTextControl> Write = (ctx, writer, value) => 
    {
      TextControlId.Write(ctx, writer, value.Id);
      TextControlSnapshot.Write(ctx, writer, value.FrontendState);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((FrontendTextControl) obj);
    }
    public bool Equals(FrontendTextControl other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Id, other.Id) && Equals(FrontendState, other.FrontendState);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Id.GetHashCode();
        __r = __r*31 + FrontendState.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("FrontendTextControl (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("frontendState = "); FrontendState.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum GatewayState {
    BothSides,
    ClosedToBackend,
    SyncFromBackend
  }
  
  
  public class GotoInput : RdBindableBase {
    //fields
    [NotNull] public string InputString {get; private set;}
    public bool Scope {get; private set;}
    
    //primary constructor
    public GotoInput(
      [NotNull] string inputString,
      bool scope
    )
    {
      InputString = inputString;
      Scope = scope;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<GotoInput> Read = (ctx, reader) => 
    {
      var inputString = reader.ReadString();
      var scope = reader.ReadBool();
      return new GotoInput(inputString, scope);
    };
    
    public static CtxWriteDelegate<GotoInput> Write = (ctx, writer, value) => 
    {
      writer.Write(value.InputString);
      writer.Write(value.Scope);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("GotoInput (");
      using (printer.IndentCookie()) {
        printer.Print("inputString = "); InputString.PrintEx(printer); printer.Println();
        printer.Print("scope = "); Scope.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum GotoKind {
    Unknown,
    None,
    GotoType,
    GotoSymbol,
    SearchEverywhere,
    FileMember,
    Exception
  }
  
  
  public class GotoResultList : IPrintable, IEquatable<GotoResultList> {
    //fields
    [NotNull] public List<SearchItemData> Items {get; private set;}
    
    //primary constructor
    public GotoResultList(
      [NotNull] List<SearchItemData> items
    )
    {
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<SearchItemData>> ReadSearchItemDataList = SearchItemData.Read.List();
    public static CtxReadDelegate<GotoResultList> Read = (ctx, reader) => 
    {
      var items = ReadSearchItemDataList(ctx, reader);
      return new GotoResultList(items);
    };
    
    public static CtxWriteDelegate<List<SearchItemData>> WriteSearchItemDataList = SearchItemData.Write.List();
    public static CtxWriteDelegate<GotoResultList> Write = (ctx, writer, value) => 
    {
      WriteSearchItemDataList(ctx, writer, value.Items);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((GotoResultList) obj);
    }
    public bool Equals(GotoResultList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Items.SequenceEqual(other.Items);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(Items);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("GotoResultList (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GotoSearchSession : RdBindableBase {
    //fields
    [NotNull] public GotoInput Input {get; private set;}
    [NotNull] public ISource<GotoResultList> GetItemsTask { get { return _GetItemsTask; }}
    [NotNull] private readonly RdSignal<GotoResultList> _GetItemsTask;
    
    //primary constructor
    private GotoSearchSession(
      [NotNull] GotoInput input,
      [NotNull] RdSignal<GotoResultList> getItemsTask
    )
    {
      Input = input;
      _GetItemsTask = getItemsTask;
      getItemsTask.Async = true;
    }
    //secondary constructor
    public GotoSearchSession (
      [NotNull] GotoInput Input
    ) : this (
      Input,
      new RdSignal<GotoResultList>()
    ) {}
    //statics
    
    public static CtxReadDelegate<GotoSearchSession> Read = (ctx, reader) => 
    {
      var input = GotoInput.Read(ctx, reader);
      var getItemsTask = RdSignal<GotoResultList>.Read(ctx, reader);
      return new GotoSearchSession(input, getItemsTask);
    };
    
    public static CtxWriteDelegate<GotoSearchSession> Write = (ctx, writer, value) => 
    {
      GotoInput.Write(ctx, writer, value.Input);
      RdSignal<GotoResultList>.Write(ctx, writer, value._GetItemsTask);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Input.BindEx(lifetime, this, "input");
      _GetItemsTask.BindEx(lifetime, this, "getItemsTask");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Input.IdentifyEx(ids);
      _GetItemsTask.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("GotoSearchSession (");
      using (printer.IndentCookie()) {
        printer.Print("input = "); Input.PrintEx(printer); printer.Println();
        printer.Print("getItemsTask = "); _GetItemsTask.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GutterMarkActionActivator : RdBindableBase {
    //fields
    [NotNull] public ISink<RdGutterExecutionRequest> LeftClick { get { return _LeftClick; }}
    [NotNull] private readonly RdSignal<RdGutterExecutionRequest> _LeftClick;
    
    //primary constructor
    private GutterMarkActionActivator(
      [NotNull] RdSignal<RdGutterExecutionRequest> leftClick
    )
    {
      _LeftClick = leftClick;
    }
    //secondary constructor
    public GutterMarkActionActivator (
    ) : this (
      new RdSignal<RdGutterExecutionRequest>()
    ) {}
    //statics
    
    public static CtxReadDelegate<GutterMarkActionActivator> Read = (ctx, reader) => 
    {
      var leftClick = RdSignal<RdGutterExecutionRequest>.Read(ctx, reader);
      return new GutterMarkActionActivator(leftClick);
    };
    
    public static CtxWriteDelegate<GutterMarkActionActivator> Write = (ctx, writer, value) => 
    {
      RdSignal<RdGutterExecutionRequest>.Write(ctx, writer, value._LeftClick);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _LeftClick.BindEx(lifetime, this, "leftClick");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _LeftClick.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("GutterMarkActionActivator (");
      using (printer.IndentCookie()) {
        printer.Print("leftClick = "); _LeftClick.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GutterMarkHighlighterModel : HighlighterModel
   {
    //fields
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public List<long> Priority {get; private set;}
    [CanBeNull] public string Tooltip {get; private set;}
    [NotNull] public string Text {get; private set;}
    
    //primary constructor
    public GutterMarkHighlighterModel(
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] List<long> priority,
      [CanBeNull] string tooltip,
      [NotNull] string text,
      int layer,
      bool isExactRange,
      [NotNull] JetBrains.Rider.Model.DocumentVersion documentVersion,
      [CanBeNull] string textToHighlight,
      int id,
      int registryKey,
      int start,
      int end
    ) : base (
      layer,
      isExactRange,
      documentVersion,
      textToHighlight,
      id,
      registryKey,
      start,
      end
     ) 
    {
      Icon = icon;
      Priority = priority;
      Tooltip = tooltip;
      Text = text;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<long>> ReadLongList = Serializers.ReadLong.List();
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static new CtxReadDelegate<GutterMarkHighlighterModel> Read = (ctx, reader) => 
    {
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var priority = ReadLongList(ctx, reader);
      var tooltip = ReadStringNullable(ctx, reader);
      var text = reader.ReadString();
      var layer = reader.ReadInt();
      var isExactRange = reader.ReadBool();
      var documentVersion = JetBrains.Rider.Model.DocumentVersion.Read(ctx, reader);
      var textToHighlight = ReadStringNullable(ctx, reader);
      var id = reader.ReadInt();
      var registryKey = reader.ReadInt();
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      return new GutterMarkHighlighterModel(icon, priority, tooltip, text, layer, isExactRange, documentVersion, textToHighlight, id, registryKey, start, end);
    };
    
    public static CtxWriteDelegate<List<long>> WriteLongList = Serializers.WriteLong.List();
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static new CtxWriteDelegate<GutterMarkHighlighterModel> Write = (ctx, writer, value) => 
    {
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      WriteLongList(ctx, writer, value.Priority);
      WriteStringNullable(ctx, writer, value.Tooltip);
      writer.Write(value.Text);
      writer.Write(value.Layer);
      writer.Write(value.IsExactRange);
      JetBrains.Rider.Model.DocumentVersion.Write(ctx, writer, value.DocumentVersion);
      WriteStringNullable(ctx, writer, value.TextToHighlight);
      writer.Write(value.Id);
      writer.Write(value.RegistryKey);
      writer.Write(value.Start);
      writer.Write(value.End);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((GutterMarkHighlighterModel) obj);
    }
    public bool Equals(GutterMarkHighlighterModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Icon, other.Icon) && Priority.SequenceEqual(other.Priority) && Equals(Tooltip, other.Tooltip) && Text == other.Text && Layer == other.Layer && IsExactRange == other.IsExactRange && Equals(DocumentVersion, other.DocumentVersion) && Equals(TextToHighlight, other.TextToHighlight) && Id == other.Id && RegistryKey == other.RegistryKey && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Icon.GetHashCode();
        __r = __r*31 + CollectionUtil.GetHashCode(Priority);
        __r = __r*31 + (Tooltip != null ?Tooltip.GetHashCode() : 0);
        __r = __r*31 + Text.GetHashCode();
        __r = __r*31 + Layer.GetHashCode();
        __r = __r*31 + IsExactRange.GetHashCode();
        __r = __r*31 + DocumentVersion.GetHashCode();
        __r = __r*31 + (TextToHighlight != null ?TextToHighlight.GetHashCode() : 0);
        __r = __r*31 + Id.GetHashCode();
        __r = __r*31 + RegistryKey.GetHashCode();
        __r = __r*31 + Start.GetHashCode();
        __r = __r*31 + End.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("GutterMarkHighlighterModel (");
      using (printer.IndentCookie()) {
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("priority = "); Priority.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); Tooltip.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("layer = "); Layer.PrintEx(printer); printer.Println();
        printer.Print("isExactRange = "); IsExactRange.PrintEx(printer); printer.Println();
        printer.Print("documentVersion = "); DocumentVersion.PrintEx(printer); printer.Println();
        printer.Print("textToHighlight = "); TextToHighlight.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("registryKey = "); RegistryKey.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class HighlighterDescription : RdBindableBase {
    //fields
    public int RegistryKey {get; private set;}
    public HighlighterEffectType EffectType {get; private set;}
    [CanBeNull] public int? LightForegroundColor {get; private set;}
    [CanBeNull] public int? LightBackgroundColor {get; private set;}
    [CanBeNull] public int? DarkForegroundColor {get; private set;}
    [CanBeNull] public int? DarkBackgroundColor {get; private set;}
    [CanBeNull] public int? EffectColor {get; private set;}
    public ErrorStripeKind ErrorStripeAttributesKind {get; private set;}
    public int FontStyle {get; private set;}
    [CanBeNull] public string AttributeId {get; private set;}
    [CanBeNull] public string Message {get; private set;}
    
    //primary constructor
    public HighlighterDescription(
      int registryKey,
      HighlighterEffectType effectType,
      [CanBeNull] int? lightForegroundColor,
      [CanBeNull] int? lightBackgroundColor,
      [CanBeNull] int? darkForegroundColor,
      [CanBeNull] int? darkBackgroundColor,
      [CanBeNull] int? effectColor,
      ErrorStripeKind errorStripeAttributesKind,
      int fontStyle,
      [CanBeNull] string attributeId,
      [CanBeNull] string message
    )
    {
      RegistryKey = registryKey;
      EffectType = effectType;
      LightForegroundColor = lightForegroundColor;
      LightBackgroundColor = lightBackgroundColor;
      DarkForegroundColor = darkForegroundColor;
      DarkBackgroundColor = darkBackgroundColor;
      EffectColor = effectColor;
      ErrorStripeAttributesKind = errorStripeAttributesKind;
      FontStyle = fontStyle;
      AttributeId = attributeId;
      Message = message;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<int?> ReadIntNullable = Serializers.ReadInt.NullableStruct();
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<HighlighterDescription> Read = (ctx, reader) => 
    {
      var registryKey = reader.ReadInt();
      var effectType = (HighlighterEffectType)reader.ReadInt();
      var lightForegroundColor = ReadIntNullable(ctx, reader);
      var lightBackgroundColor = ReadIntNullable(ctx, reader);
      var darkForegroundColor = ReadIntNullable(ctx, reader);
      var darkBackgroundColor = ReadIntNullable(ctx, reader);
      var effectColor = ReadIntNullable(ctx, reader);
      var errorStripeAttributesKind = (ErrorStripeKind)reader.ReadInt();
      var fontStyle = reader.ReadInt();
      var attributeId = ReadStringNullable(ctx, reader);
      var message = ReadStringNullable(ctx, reader);
      return new HighlighterDescription(registryKey, effectType, lightForegroundColor, lightBackgroundColor, darkForegroundColor, darkBackgroundColor, effectColor, errorStripeAttributesKind, fontStyle, attributeId, message);
    };
    
    public static CtxWriteDelegate<int?> WriteIntNullable = Serializers.WriteInt.NullableStruct();
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<HighlighterDescription> Write = (ctx, writer, value) => 
    {
      writer.Write(value.RegistryKey);
      writer.Write((int)value.EffectType);
      WriteIntNullable(ctx, writer, value.LightForegroundColor);
      WriteIntNullable(ctx, writer, value.LightBackgroundColor);
      WriteIntNullable(ctx, writer, value.DarkForegroundColor);
      WriteIntNullable(ctx, writer, value.DarkBackgroundColor);
      WriteIntNullable(ctx, writer, value.EffectColor);
      writer.Write((int)value.ErrorStripeAttributesKind);
      writer.Write(value.FontStyle);
      WriteStringNullable(ctx, writer, value.AttributeId);
      WriteStringNullable(ctx, writer, value.Message);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("HighlighterDescription (");
      using (printer.IndentCookie()) {
        printer.Print("registryKey = "); RegistryKey.PrintEx(printer); printer.Println();
        printer.Print("effectType = "); EffectType.PrintEx(printer); printer.Println();
        printer.Print("lightForegroundColor = "); LightForegroundColor.PrintEx(printer); printer.Println();
        printer.Print("lightBackgroundColor = "); LightBackgroundColor.PrintEx(printer); printer.Println();
        printer.Print("darkForegroundColor = "); DarkForegroundColor.PrintEx(printer); printer.Println();
        printer.Print("darkBackgroundColor = "); DarkBackgroundColor.PrintEx(printer); printer.Println();
        printer.Print("effectColor = "); EffectColor.PrintEx(printer); printer.Println();
        printer.Print("errorStripeAttributesKind = "); ErrorStripeAttributesKind.PrintEx(printer); printer.Println();
        printer.Print("fontStyle = "); FontStyle.PrintEx(printer); printer.Println();
        printer.Print("attributeId = "); AttributeId.PrintEx(printer); printer.Println();
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum HighlighterEffectType {
    NONE,
    HIGHLIGHT_BELOW_TEXT_MARKER,
    HIGHLIGHT_ABOVE_TEXT_MARKER,
    TEXT,
    WAVE,
    SOLID_UNDERLINE,
    DOTTED_OUTLINE,
    GUTTER_MARK,
    SOLID_OUTLINE,
    DOTTED_UNDERLINE,
    ERROR_STRIPE_MARK,
    FOLDING
  }
  
  
  public class HighlighterIdList : IPrintable, IEquatable<HighlighterIdList> {
    //fields
    [NotNull] public List<int> Elements {get; private set;}
    
    //primary constructor
    public HighlighterIdList(
      [NotNull] List<int> elements
    )
    {
      Elements = elements;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static CtxReadDelegate<HighlighterIdList> Read = (ctx, reader) => 
    {
      var elements = ReadIntList(ctx, reader);
      return new HighlighterIdList(elements);
    };
    
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static CtxWriteDelegate<HighlighterIdList> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.Elements);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((HighlighterIdList) obj);
    }
    public bool Equals(HighlighterIdList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Elements.SequenceEqual(other.Elements);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(Elements);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("HighlighterIdList (");
      using (printer.IndentCookie()) {
        printer.Print("elements = "); Elements.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class HighlighterList : IPrintable, IEquatable<HighlighterList> {
    //fields
    [NotNull] public List<HighlighterModel> Elements {get; private set;}
    
    //primary constructor
    public HighlighterList(
      [NotNull] List<HighlighterModel> elements
    )
    {
      Elements = elements;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<HighlighterModel>> ReadHighlighterModelList = HighlighterModel.Read.List();
    public static CtxReadDelegate<HighlighterList> Read = (ctx, reader) => 
    {
      var elements = ReadHighlighterModelList(ctx, reader);
      return new HighlighterList(elements);
    };
    
    public static CtxWriteDelegate<List<HighlighterModel>> WriteHighlighterModelList = HighlighterModel.Write.List();
    public static CtxWriteDelegate<HighlighterList> Write = (ctx, writer, value) => 
    {
      WriteHighlighterModelList(ctx, writer, value.Elements);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((HighlighterList) obj);
    }
    public bool Equals(HighlighterList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Elements.SequenceEqual(other.Elements);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(Elements);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("HighlighterList (");
      using (printer.IndentCookie()) {
        printer.Print("elements = "); Elements.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class HighlighterModel : LightweightHighlighter
   {
    //fields
    public int Layer {get; private set;}
    public bool IsExactRange {get; private set;}
    [NotNull] public JetBrains.Rider.Model.DocumentVersion DocumentVersion {get; private set;}
    [CanBeNull] public string TextToHighlight {get; private set;}
    
    //primary constructor
    protected HighlighterModel(
      int layer,
      bool isExactRange,
      [NotNull] JetBrains.Rider.Model.DocumentVersion documentVersion,
      [CanBeNull] string textToHighlight,
      int id,
      int registryKey,
      int start,
      int end
    ) : base (
      id,
      registryKey,
      start,
      end
     ) 
    {
      Layer = layer;
      IsExactRange = isExactRange;
      DocumentVersion = documentVersion;
      TextToHighlight = textToHighlight;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<HighlighterModel> Read = (ctx, reader) => ctx.Serializers.Read<HighlighterModel>(ctx, reader);
    
    public static new CtxWriteDelegate<HighlighterModel> Write = (ctx, writer, value) => ctx.Serializers.Write<HighlighterModel>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class HighlighterRegistryModel : RdBindableBase {
    //fields
    [NotNull] public IViewableMap<int, HighlighterDescription> DynamicallyRegisteredHighlighters { get { return _DynamicallyRegisteredHighlighters; }}
    [NotNull] private readonly RdMap<int, HighlighterDescription> _DynamicallyRegisteredHighlighters;
    [NotNull] public List<string> StaticallyRegisteredHighlighters {get; private set;}
    
    //primary constructor
    private HighlighterRegistryModel(
      [NotNull] RdMap<int, HighlighterDescription> dynamicallyRegisteredHighlighters,
      [NotNull] List<string> staticallyRegisteredHighlighters
    )
    {
      _DynamicallyRegisteredHighlighters = dynamicallyRegisteredHighlighters;
      StaticallyRegisteredHighlighters = staticallyRegisteredHighlighters;
    }
    //secondary constructor
    public HighlighterRegistryModel (
      [NotNull] List<string> StaticallyRegisteredHighlighters
    ) : this (
      new RdMap<int, HighlighterDescription>(),
      StaticallyRegisteredHighlighters
    ) {}
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static CtxReadDelegate<HighlighterRegistryModel> Read = (ctx, reader) => 
    {
      var dynamicallyRegisteredHighlighters = RdMap<int, HighlighterDescription>.Read(ctx, reader);
      var staticallyRegisteredHighlighters = ReadStringList(ctx, reader);
      return new HighlighterRegistryModel(dynamicallyRegisteredHighlighters, staticallyRegisteredHighlighters);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static CtxWriteDelegate<HighlighterRegistryModel> Write = (ctx, writer, value) => 
    {
      RdMap<int, HighlighterDescription>.Write(ctx, writer, value._DynamicallyRegisteredHighlighters);
      WriteStringList(ctx, writer, value.StaticallyRegisteredHighlighters);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _DynamicallyRegisteredHighlighters.BindEx(lifetime, this, "dynamicallyRegisteredHighlighters");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _DynamicallyRegisteredHighlighters.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("HighlighterRegistryModel (");
      using (printer.IndentCookie()) {
        printer.Print("dynamicallyRegisteredHighlighters = "); _DynamicallyRegisteredHighlighters.PrintEx(printer); printer.Println();
        printer.Print("staticallyRegisteredHighlighters = "); StaticallyRegisteredHighlighters.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class HostDebuggerSessionModel : RdBindableBase {
    //fields
    [NotNull] public JetBrains.Rider.Model.SessionStartDescriptor SessionStartDescriptor {get; private set;}
    [NotNull] public ISource<bool> Terminate { get { return _Terminate; }}
    [NotNull] private readonly RdSignal<bool> _Terminate;
    [NotNull] public IVoidSink Terminated { get { return _Terminated; }}
    [NotNull] private readonly RdVoidSignal _Terminated;
    
    //primary constructor
    private HostDebuggerSessionModel(
      [NotNull] JetBrains.Rider.Model.SessionStartDescriptor sessionStartDescriptor,
      [NotNull] RdSignal<bool> terminate,
      [NotNull] RdVoidSignal terminated
    )
    {
      SessionStartDescriptor = sessionStartDescriptor;
      _Terminate = terminate;
      _Terminated = terminated;
    }
    //secondary constructor
    public HostDebuggerSessionModel (
      [NotNull] JetBrains.Rider.Model.SessionStartDescriptor SessionStartDescriptor
    ) : this (
      SessionStartDescriptor,
      new RdSignal<bool>(),
      new RdVoidSignal()
    ) {}
    //statics
    
    public static CtxReadDelegate<HostDebuggerSessionModel> Read = (ctx, reader) => 
    {
      var sessionStartDescriptor = JetBrains.Rider.Model.SessionStartDescriptor.Read(ctx, reader);
      var terminate = RdSignal<bool>.Read(ctx, reader);
      var terminated = RdVoidSignal.Read(ctx, reader);
      return new HostDebuggerSessionModel(sessionStartDescriptor, terminate, terminated);
    };
    
    public static CtxWriteDelegate<HostDebuggerSessionModel> Write = (ctx, writer, value) => 
    {
      JetBrains.Rider.Model.SessionStartDescriptor.Write(ctx, writer, value.SessionStartDescriptor);
      RdSignal<bool>.Write(ctx, writer, value._Terminate);
      RdVoidSignal.Write(ctx, writer, value._Terminated);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Terminate.BindEx(lifetime, this, "terminate");
      _Terminated.BindEx(lifetime, this, "terminated");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Terminate.IdentifyEx(ids);
      _Terminated.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("HostDebuggerSessionModel (");
      using (printer.IndentCookie()) {
        printer.Print("sessionStartDescriptor = "); SessionStartDescriptor.PrintEx(printer); printer.Println();
        printer.Print("terminate = "); _Terminate.PrintEx(printer); printer.Println();
        printer.Print("terminated = "); _Terminated.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class HyperlinkHighlightingArgs : IPrintable, IEquatable<HyperlinkHighlightingArgs> {
    //fields
    [NotNull] public JetBrains.Rider.Model.TextControlId TextControlId {get; private set;}
    public int Offset {get; private set;}
    public RiderBrowseMode Mode {get; private set;}
    
    //primary constructor
    public HyperlinkHighlightingArgs(
      [NotNull] JetBrains.Rider.Model.TextControlId textControlId,
      int offset,
      RiderBrowseMode mode
    )
    {
      TextControlId = textControlId;
      Offset = offset;
      Mode = mode;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<HyperlinkHighlightingArgs> Read = (ctx, reader) => 
    {
      var textControlId = JetBrains.Rider.Model.TextControlId.Read(ctx, reader);
      var offset = reader.ReadInt();
      var mode = (RiderBrowseMode)reader.ReadInt();
      return new HyperlinkHighlightingArgs(textControlId, offset, mode);
    };
    
    public static CtxWriteDelegate<HyperlinkHighlightingArgs> Write = (ctx, writer, value) => 
    {
      JetBrains.Rider.Model.TextControlId.Write(ctx, writer, value.TextControlId);
      writer.Write(value.Offset);
      writer.Write((int)value.Mode);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((HyperlinkHighlightingArgs) obj);
    }
    public bool Equals(HyperlinkHighlightingArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(TextControlId, other.TextControlId) && Offset == other.Offset && Mode == other.Mode;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + TextControlId.GetHashCode();
        __r = __r*31 + Offset.GetHashCode();
        __r = __r*31 + (int) Mode;
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("HyperlinkHighlightingArgs (");
      using (printer.IndentCookie()) {
        printer.Print("textControlId = "); TextControlId.PrintEx(printer); printer.Println();
        printer.Print("offset = "); Offset.PrintEx(printer); printer.Println();
        printer.Print("mode = "); Mode.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class HyperlinkHighlightingResult : IPrintable, IEquatable<HyperlinkHighlightingResult> {
    //fields
    [NotNull] public RdTextRange TextRange {get; private set;}
    [NotNull] public string DocInfo {get; private set;}
    
    //primary constructor
    public HyperlinkHighlightingResult(
      [NotNull] RdTextRange textRange,
      [NotNull] string docInfo
    )
    {
      TextRange = textRange;
      DocInfo = docInfo;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<HyperlinkHighlightingResult> Read = (ctx, reader) => 
    {
      var textRange = RdTextRange.Read(ctx, reader);
      var docInfo = reader.ReadString();
      return new HyperlinkHighlightingResult(textRange, docInfo);
    };
    
    public static CtxWriteDelegate<HyperlinkHighlightingResult> Write = (ctx, writer, value) => 
    {
      RdTextRange.Write(ctx, writer, value.TextRange);
      writer.Write(value.DocInfo);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((HyperlinkHighlightingResult) obj);
    }
    public bool Equals(HyperlinkHighlightingResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(TextRange, other.TextRange) && DocInfo == other.DocInfo;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + TextRange.GetHashCode();
        __r = __r*31 + DocInfo.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("HyperlinkHighlightingResult (");
      using (printer.IndentCookie()) {
        printer.Print("textRange = "); TextRange.PrintEx(printer); printer.Println();
        printer.Print("docInfo = "); DocInfo.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ItemsToUpdate : IPrintable, IEquatable<ItemsToUpdate> {
    //fields
    [NotNull] public List<int> ItemIds {get; private set;}
    
    //primary constructor
    public ItemsToUpdate(
      [NotNull] List<int> itemIds
    )
    {
      ItemIds = itemIds;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static CtxReadDelegate<ItemsToUpdate> Read = (ctx, reader) => 
    {
      var itemIds = ReadIntList(ctx, reader);
      return new ItemsToUpdate(itemIds);
    };
    
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static CtxWriteDelegate<ItemsToUpdate> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.ItemIds);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ItemsToUpdate) obj);
    }
    public bool Equals(ItemsToUpdate other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemIds.SequenceEqual(other.ItemIds);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(ItemIds);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ItemsToUpdate (");
      using (printer.IndentCookie()) {
        printer.Print("itemIds = "); ItemIds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class LastFocusedTextControl : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<CompletionTuple> CompletionSession { get { return _CompletionSession; }}
    [NotNull] private readonly RdProperty<CompletionTuple> _CompletionSession;
    [NotNull] public ISource<JetBrains.Rider.Model.AutoPopupResult> AutoPopupResult { get { return _AutoPopupResult; }}
    [NotNull] private readonly RdSignal<JetBrains.Rider.Model.AutoPopupResult> _AutoPopupResult;
    [NotNull] public ParameterInfoModel ParameterInfo {get; private set;}
    
    //primary constructor
    private LastFocusedTextControl(
      [NotNull] RdProperty<CompletionTuple> completionSession,
      [NotNull] RdSignal<JetBrains.Rider.Model.AutoPopupResult> autoPopupResult,
      [NotNull] ParameterInfoModel parameterInfo
    )
    {
      _CompletionSession = completionSession;
      _AutoPopupResult = autoPopupResult;
      ParameterInfo = parameterInfo;
      completionSession.Async = true;
    }
    //secondary constructor
    public LastFocusedTextControl (
    ) : this (
      new RdProperty<CompletionTuple>(),
      new RdSignal<JetBrains.Rider.Model.AutoPopupResult>(),
      new ParameterInfoModel()
    ) {}
    //statics
    
    public static CtxReadDelegate<CompletionTuple> ReadCompletionTupleNullable = CompletionTuple.Read.NullableClass();
    public static CtxReadDelegate<LastFocusedTextControl> Read = (ctx, reader) => 
    {
      var completionSession = RdProperty<CompletionTuple>.Read(ctx, reader);
      var autoPopupResult = RdSignal<JetBrains.Rider.Model.AutoPopupResult>.Read(ctx, reader);
      var parameterInfo = ParameterInfoModel.Read(ctx, reader);
      return new LastFocusedTextControl(completionSession, autoPopupResult, parameterInfo);
    };
    
    public static CtxWriteDelegate<CompletionTuple> WriteCompletionTupleNullable = CompletionTuple.Write.NullableClass();
    public static CtxWriteDelegate<LastFocusedTextControl> Write = (ctx, writer, value) => 
    {
      RdProperty<CompletionTuple>.Write(ctx, writer, value._CompletionSession);
      RdSignal<JetBrains.Rider.Model.AutoPopupResult>.Write(ctx, writer, value._AutoPopupResult);
      ParameterInfoModel.Write(ctx, writer, value.ParameterInfo);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _CompletionSession.BindEx(lifetime, this, "completionSession");
      _AutoPopupResult.BindEx(lifetime, this, "autoPopupResult");
      ParameterInfo.BindEx(lifetime, this, "parameterInfo");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _CompletionSession.IdentifyEx(ids);
      _AutoPopupResult.IdentifyEx(ids);
      ParameterInfo.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("LastFocusedTextControl (");
      using (printer.IndentCookie()) {
        printer.Print("completionSession = "); _CompletionSession.PrintEx(printer); printer.Println();
        printer.Print("autoPopupResult = "); _AutoPopupResult.PrintEx(printer); printer.Println();
        printer.Print("parameterInfo = "); ParameterInfo.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class LightweightHighlighter {
    //fields
    public int Id {get; private set;}
    public int RegistryKey {get; private set;}
    public int Start {get; private set;}
    public int End {get; private set;}
    
    //primary constructor
    protected LightweightHighlighter(
      int id,
      int registryKey,
      int start,
      int end
    )
    {
      Id = id;
      RegistryKey = registryKey;
      Start = start;
      End = end;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<LightweightHighlighter> Read = (ctx, reader) => ctx.Serializers.Read<LightweightHighlighter>(ctx, reader);
    
    public static CtxWriteDelegate<LightweightHighlighter> Write = (ctx, writer, value) => ctx.Serializers.Write<LightweightHighlighter>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class LoadResult : RdBindableBase {
    //fields
    public long LoadTime {get; private set;}
    public bool IsCold {get; private set;}
    
    //primary constructor
    public LoadResult(
      long loadTime,
      bool isCold
    )
    {
      LoadTime = loadTime;
      IsCold = isCold;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<LoadResult> Read = (ctx, reader) => 
    {
      var loadTime = reader.ReadLong();
      var isCold = reader.ReadBool();
      return new LoadResult(loadTime, isCold);
    };
    
    public static CtxWriteDelegate<LoadResult> Write = (ctx, writer, value) => 
    {
      writer.Write(value.LoadTime);
      writer.Write(value.IsCold);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("LoadResult (");
      using (printer.IndentCookie()) {
        printer.Print("loadTime = "); LoadTime.PrintEx(printer); printer.Println();
        printer.Print("isCold = "); IsCold.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MakeWritableRequest : IPrintable, IEquatable<MakeWritableRequest> {
    //fields
    [NotNull] public List<string> Files {get; private set;}
    
    //primary constructor
    public MakeWritableRequest(
      [NotNull] List<string> files
    )
    {
      Files = files;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static CtxReadDelegate<MakeWritableRequest> Read = (ctx, reader) => 
    {
      var files = ReadStringList(ctx, reader);
      return new MakeWritableRequest(files);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static CtxWriteDelegate<MakeWritableRequest> Write = (ctx, writer, value) => 
    {
      WriteStringList(ctx, writer, value.Files);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MakeWritableRequest) obj);
    }
    public bool Equals(MakeWritableRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Files.SequenceEqual(other.Files);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(Files);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MakeWritableRequest (");
      using (printer.IndentCookie()) {
        printer.Print("files = "); Files.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MakeWritableResponse : IPrintable, IEquatable<MakeWritableResponse> {
    //fields
    [CanBeNull] public string Message {get; private set;}
    public RdMakeWritableResultKind Result {get; private set;}
    
    //primary constructor
    public MakeWritableResponse(
      [CanBeNull] string message,
      RdMakeWritableResultKind result
    )
    {
      Message = message;
      Result = result;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<MakeWritableResponse> Read = (ctx, reader) => 
    {
      var message = ReadStringNullable(ctx, reader);
      var result = (RdMakeWritableResultKind)reader.ReadInt();
      return new MakeWritableResponse(message, result);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<MakeWritableResponse> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.Message);
      writer.Write((int)value.Result);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MakeWritableResponse) obj);
    }
    public bool Equals(MakeWritableResponse other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Message, other.Message) && Result == other.Result;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (Message != null ?Message.GetHashCode() : 0);
        __r = __r*31 + (int) Result;
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MakeWritableResponse (");
      using (printer.IndentCookie()) {
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
        printer.Print("result = "); Result.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MarkupDumpInfo : IPrintable, IEquatable<MarkupDumpInfo> {
    //fields
    [NotNull] public HighlighterIdList AllIds {get; private set;}
    public int HighlighterCounter {get; private set;}
    [NotNull] public DocumentVersion DocumentTimestamp {get; private set;}
    
    //primary constructor
    public MarkupDumpInfo(
      [NotNull] HighlighterIdList allIds,
      int highlighterCounter,
      [NotNull] DocumentVersion documentTimestamp
    )
    {
      AllIds = allIds;
      HighlighterCounter = highlighterCounter;
      DocumentTimestamp = documentTimestamp;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<MarkupDumpInfo> Read = (ctx, reader) => 
    {
      var allIds = HighlighterIdList.Read(ctx, reader);
      var highlighterCounter = reader.ReadInt();
      var documentTimestamp = DocumentVersion.Read(ctx, reader);
      return new MarkupDumpInfo(allIds, highlighterCounter, documentTimestamp);
    };
    
    public static CtxWriteDelegate<MarkupDumpInfo> Write = (ctx, writer, value) => 
    {
      HighlighterIdList.Write(ctx, writer, value.AllIds);
      writer.Write(value.HighlighterCounter);
      DocumentVersion.Write(ctx, writer, value.DocumentTimestamp);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MarkupDumpInfo) obj);
    }
    public bool Equals(MarkupDumpInfo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(AllIds, other.AllIds) && HighlighterCounter == other.HighlighterCounter && Equals(DocumentTimestamp, other.DocumentTimestamp);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + AllIds.GetHashCode();
        __r = __r*31 + HighlighterCounter.GetHashCode();
        __r = __r*31 + DocumentTimestamp.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MarkupDumpInfo (");
      using (printer.IndentCookie()) {
        printer.Print("allIds = "); AllIds.PrintEx(printer); printer.Println();
        printer.Print("highlighterCounter = "); HighlighterCounter.PrintEx(printer); printer.Println();
        printer.Print("documentTimestamp = "); DocumentTimestamp.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MoveCommand : IPrintable, IEquatable<MoveCommand> {
    //fields
    public int ItemId {get; private set;}
    public int ParentId {get; private set;}
    
    //primary constructor
    public MoveCommand(
      int itemId,
      int parentId
    )
    {
      ItemId = itemId;
      ParentId = parentId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<MoveCommand> Read = (ctx, reader) => 
    {
      var itemId = reader.ReadInt();
      var parentId = reader.ReadInt();
      return new MoveCommand(itemId, parentId);
    };
    
    public static CtxWriteDelegate<MoveCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemId);
      writer.Write(value.ParentId);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MoveCommand) obj);
    }
    public bool Equals(MoveCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemId == other.ItemId && ParentId == other.ParentId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + ItemId.GetHashCode();
        __r = __r*31 + ParentId.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MoveCommand (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
        printer.Print("parentId = "); ParentId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class Navigation {
    //fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<Navigation> Read = (ctx, reader) => ctx.Serializers.Read<Navigation>(ctx, reader);
    
    public static CtxWriteDelegate<Navigation> Write = (ctx, writer, value) => ctx.Serializers.Write<Navigation>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class OpenExistingSolution : SolutionOpenStrategy
   {
    //fields
    //primary constructor
    public OpenExistingSolution(
      [NotNull] string solutionFilePath,
      bool restorePackages
    ) : base (
      solutionFilePath,
      restorePackages
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<OpenExistingSolution> Read = (ctx, reader) => 
    {
      var solutionFilePath = reader.ReadString();
      var restorePackages = reader.ReadBool();
      return new OpenExistingSolution(solutionFilePath, restorePackages);
    };
    
    public static new CtxWriteDelegate<OpenExistingSolution> Write = (ctx, writer, value) => 
    {
      writer.Write(value.SolutionFilePath);
      writer.Write(value.RestorePackages);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("OpenExistingSolution (");
      using (printer.IndentCookie()) {
        printer.Print("solutionFilePath = "); SolutionFilePath.PrintEx(printer); printer.Println();
        printer.Print("restorePackages = "); RestorePackages.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class OpenExistingSolutionAndPauseLoading : SolutionOpenStrategy
   {
    //fields
    [NotNull] public IVoidSink ResumeLoad { get { return _ResumeLoad; }}
    [NotNull] private readonly RdVoidSignal _ResumeLoad;
    
    //primary constructor
    private OpenExistingSolutionAndPauseLoading(
      [NotNull] RdVoidSignal resumeLoad,
      [NotNull] string solutionFilePath,
      bool restorePackages
    ) : base (
      solutionFilePath,
      restorePackages
     ) 
    {
      _ResumeLoad = resumeLoad;
    }
    //secondary constructor
    public OpenExistingSolutionAndPauseLoading (
      [NotNull] string SolutionFilePath,
      bool RestorePackages
    ) : this (
      new RdVoidSignal(),
      SolutionFilePath,
      RestorePackages
    ) {}
    //statics
    
    public static new CtxReadDelegate<OpenExistingSolutionAndPauseLoading> Read = (ctx, reader) => 
    {
      var resumeLoad = RdVoidSignal.Read(ctx, reader);
      var solutionFilePath = reader.ReadString();
      var restorePackages = reader.ReadBool();
      return new OpenExistingSolutionAndPauseLoading(resumeLoad, solutionFilePath, restorePackages);
    };
    
    public static new CtxWriteDelegate<OpenExistingSolutionAndPauseLoading> Write = (ctx, writer, value) => 
    {
      RdVoidSignal.Write(ctx, writer, value._ResumeLoad);
      writer.Write(value.SolutionFilePath);
      writer.Write(value.RestorePackages);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _ResumeLoad.BindEx(lifetime, this, "resumeLoad");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ResumeLoad.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("OpenExistingSolutionAndPauseLoading (");
      using (printer.IndentCookie()) {
        printer.Print("resumeLoad = "); _ResumeLoad.PrintEx(printer); printer.Println();
        printer.Print("solutionFilePath = "); SolutionFilePath.PrintEx(printer); printer.Println();
        printer.Print("restorePackages = "); RestorePackages.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class OpenExistingSolutionAndReformat : SolutionOpenStrategy
   {
    //fields
    [NotNull] public List<FileToOpen> FilesToOpen {get; private set;}
    
    //primary constructor
    public OpenExistingSolutionAndReformat(
      [NotNull] List<FileToOpen> filesToOpen,
      [NotNull] string solutionFilePath,
      bool restorePackages
    ) : base (
      solutionFilePath,
      restorePackages
     ) 
    {
      FilesToOpen = filesToOpen;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<FileToOpen>> ReadFileToOpenList = FileToOpen.Read.List();
    public static new CtxReadDelegate<OpenExistingSolutionAndReformat> Read = (ctx, reader) => 
    {
      var filesToOpen = ReadFileToOpenList(ctx, reader);
      var solutionFilePath = reader.ReadString();
      var restorePackages = reader.ReadBool();
      return new OpenExistingSolutionAndReformat(filesToOpen, solutionFilePath, restorePackages);
    };
    
    public static CtxWriteDelegate<List<FileToOpen>> WriteFileToOpenList = FileToOpen.Write.List();
    public static new CtxWriteDelegate<OpenExistingSolutionAndReformat> Write = (ctx, writer, value) => 
    {
      WriteFileToOpenList(ctx, writer, value.FilesToOpen);
      writer.Write(value.SolutionFilePath);
      writer.Write(value.RestorePackages);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("OpenExistingSolutionAndReformat (");
      using (printer.IndentCookie()) {
        printer.Print("filesToOpen = "); FilesToOpen.PrintEx(printer); printer.Println();
        printer.Print("solutionFilePath = "); SolutionFilePath.PrintEx(printer); printer.Println();
        printer.Print("restorePackages = "); RestorePackages.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ParameterInfoModel : RdBindableBase {
    //fields
    [NotNull] public IViewableMap<int, CreateSignatureList> Infos { get { return _Infos; }}
    [NotNull] private readonly RdMap<int, CreateSignatureList> _Infos;
    [NotNull] public ISource<UpdateSignatureList> Delta { get { return _Delta; }}
    [NotNull] private readonly RdSignal<UpdateSignatureList> _Delta;
    
    //primary constructor
    private ParameterInfoModel(
      [NotNull] RdMap<int, CreateSignatureList> infos,
      [NotNull] RdSignal<UpdateSignatureList> delta
    )
    {
      _Infos = infos;
      _Delta = delta;
      infos.OptimizeNested = true;
    }
    //secondary constructor
    public ParameterInfoModel (
    ) : this (
      new RdMap<int, CreateSignatureList>(),
      new RdSignal<UpdateSignatureList>()
    ) {}
    //statics
    
    public static CtxReadDelegate<ParameterInfoModel> Read = (ctx, reader) => 
    {
      var infos = RdMap<int, CreateSignatureList>.Read(ctx, reader);
      var delta = RdSignal<UpdateSignatureList>.Read(ctx, reader);
      return new ParameterInfoModel(infos, delta);
    };
    
    public static CtxWriteDelegate<ParameterInfoModel> Write = (ctx, writer, value) => 
    {
      RdMap<int, CreateSignatureList>.Write(ctx, writer, value._Infos);
      RdSignal<UpdateSignatureList>.Write(ctx, writer, value._Delta);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Infos.BindEx(lifetime, this, "infos");
      _Delta.BindEx(lifetime, this, "delta");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Infos.IdentifyEx(ids);
      _Delta.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ParameterInfoModel (");
      using (printer.IndentCookie()) {
        printer.Print("infos = "); _Infos.PrintEx(printer); printer.Println();
        printer.Print("delta = "); _Delta.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PopupActionModel : RdBindableBase {
    //fields
    public int StartOffset {get; private set;}
    public int EndOffset {get; private set;}
    [NotNull] public string Caption {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public IVoidSink IgnoreThisActionPopup { get { return _IgnoreThisActionPopup; }}
    [NotNull] private readonly RdVoidSignal _IgnoreThisActionPopup;
    [NotNull] public List<JetBrains.Rider.Model.UiContext.ContextPair> Timestamps {get; private set;}
    [NotNull] public JetBrains.Rider.Model.TextControlId TextControlId {get; private set;}
    
    //primary constructor
    private PopupActionModel(
      int startOffset,
      int endOffset,
      [NotNull] string caption,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdVoidSignal ignoreThisActionPopup,
      [NotNull] List<JetBrains.Rider.Model.UiContext.ContextPair> timestamps,
      [NotNull] JetBrains.Rider.Model.TextControlId textControlId
    )
    {
      StartOffset = startOffset;
      EndOffset = endOffset;
      Caption = caption;
      Icon = icon;
      _IgnoreThisActionPopup = ignoreThisActionPopup;
      Timestamps = timestamps;
      TextControlId = textControlId;
    }
    //secondary constructor
    public PopupActionModel (
      int StartOffset,
      int EndOffset,
      [NotNull] string Caption,
      [CanBeNull] JetBrains.Rider.Model.Icon Icon,
      [NotNull] List<JetBrains.Rider.Model.UiContext.ContextPair> Timestamps,
      [NotNull] JetBrains.Rider.Model.TextControlId TextControlId
    ) : this (
      StartOffset,
      EndOffset,
      Caption,
      Icon,
      new RdVoidSignal(),
      Timestamps,
      TextControlId
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<List<JetBrains.Rider.Model.UiContext.ContextPair>> ReadContextPairList = JetBrains.Rider.Model.UiContext.ContextPair.Read.List();
    public static CtxReadDelegate<PopupActionModel> Read = (ctx, reader) => 
    {
      var startOffset = reader.ReadInt();
      var endOffset = reader.ReadInt();
      var caption = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var ignoreThisActionPopup = RdVoidSignal.Read(ctx, reader);
      var timestamps = ReadContextPairList(ctx, reader);
      var textControlId = JetBrains.Rider.Model.TextControlId.Read(ctx, reader);
      return new PopupActionModel(startOffset, endOffset, caption, icon, ignoreThisActionPopup, timestamps, textControlId);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<List<JetBrains.Rider.Model.UiContext.ContextPair>> WriteContextPairList = JetBrains.Rider.Model.UiContext.ContextPair.Write.List();
    public static CtxWriteDelegate<PopupActionModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.StartOffset);
      writer.Write(value.EndOffset);
      writer.Write(value.Caption);
      WriteIconNullable(ctx, writer, value.Icon);
      RdVoidSignal.Write(ctx, writer, value._IgnoreThisActionPopup);
      WriteContextPairList(ctx, writer, value.Timestamps);
      JetBrains.Rider.Model.TextControlId.Write(ctx, writer, value.TextControlId);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _IgnoreThisActionPopup.BindEx(lifetime, this, "ignoreThisActionPopup");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _IgnoreThisActionPopup.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PopupActionModel (");
      using (printer.IndentCookie()) {
        printer.Print("startOffset = "); StartOffset.PrintEx(printer); printer.Println();
        printer.Print("endOffset = "); EndOffset.PrintEx(printer); printer.Println();
        printer.Print("caption = "); Caption.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("ignoreThisActionPopup = "); _IgnoreThisActionPopup.PrintEx(printer); printer.Println();
        printer.Print("timestamps = "); Timestamps.PrintEx(printer); printer.Println();
        printer.Print("textControlId = "); TextControlId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ProjectModel : RdBindableBase {
    //fields
    [NotNull] public string Path {get; private set;}
    [NotNull] public IRdProperty<ProjectPropertiesModel> Properties { get { return _Properties; }}
    [NotNull] private readonly RdProperty<ProjectPropertiesModel> _Properties;
    
    //primary constructor
    private ProjectModel(
      [NotNull] string path,
      [NotNull] RdProperty<ProjectPropertiesModel> properties
    )
    {
      Path = path;
      _Properties = properties;
      properties.OptimizeNested = true;
    }
    //secondary constructor
    public ProjectModel (
      [NotNull] string Path
    ) : this (
      Path,
      new RdProperty<ProjectPropertiesModel>()
    ) {}
    //statics
    
    public static CtxReadDelegate<ProjectModel> Read = (ctx, reader) => 
    {
      var path = reader.ReadString();
      var properties = RdProperty<ProjectPropertiesModel>.Read(ctx, reader);
      return new ProjectModel(path, properties);
    };
    
    public static CtxWriteDelegate<ProjectModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Path);
      RdProperty<ProjectPropertiesModel>.Write(ctx, writer, value._Properties);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Properties.BindEx(lifetime, this, "properties");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Properties.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ProjectModel (");
      using (printer.IndentCookie()) {
        printer.Print("path = "); Path.PrintEx(printer); printer.Println();
        printer.Print("properties = "); _Properties.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ProjectModelDumpFlags {
    Structure,
    Full
  }
  
  
  public class ProjectModelDumpParams : IPrintable, IEquatable<ProjectModelDumpParams> {
    //fields
    public ProjectModelDumpFlags Category {get; private set;}
    
    //primary constructor
    public ProjectModelDumpParams(
      ProjectModelDumpFlags category
    )
    {
      Category = category;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ProjectModelDumpParams> Read = (ctx, reader) => 
    {
      var category = (ProjectModelDumpFlags)reader.ReadInt();
      return new ProjectModelDumpParams(category);
    };
    
    public static CtxWriteDelegate<ProjectModelDumpParams> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Category);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ProjectModelDumpParams) obj);
    }
    public bool Equals(ProjectModelDumpParams other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Category == other.Category;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (int) Category;
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ProjectModelDumpParams (");
      using (printer.IndentCookie()) {
        printer.Print("category = "); Category.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ProjectModelTaskResult : IPrintable, IEquatable<ProjectModelTaskResult> {
    //fields
    public ProjectModelTaskResultKind Result {get; private set;}
    [CanBeNull] public string ErrorMessage {get; private set;}
    [CanBeNull] public ProjectModelTaskResultContent Content {get; private set;}
    
    //primary constructor
    public ProjectModelTaskResult(
      ProjectModelTaskResultKind result,
      [CanBeNull] string errorMessage,
      [CanBeNull] ProjectModelTaskResultContent content
    )
    {
      Result = result;
      ErrorMessage = errorMessage;
      Content = content;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<ProjectModelTaskResultContent> ReadProjectModelTaskResultContentNullable = ProjectModelTaskResultContent.Read.NullableClass();
    public static CtxReadDelegate<ProjectModelTaskResult> Read = (ctx, reader) => 
    {
      var result = (ProjectModelTaskResultKind)reader.ReadInt();
      var errorMessage = ReadStringNullable(ctx, reader);
      var content = ReadProjectModelTaskResultContentNullable(ctx, reader);
      return new ProjectModelTaskResult(result, errorMessage, content);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<ProjectModelTaskResultContent> WriteProjectModelTaskResultContentNullable = ProjectModelTaskResultContent.Write.NullableClass();
    public static CtxWriteDelegate<ProjectModelTaskResult> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Result);
      WriteStringNullable(ctx, writer, value.ErrorMessage);
      WriteProjectModelTaskResultContentNullable(ctx, writer, value.Content);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ProjectModelTaskResult) obj);
    }
    public bool Equals(ProjectModelTaskResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Result == other.Result && Equals(ErrorMessage, other.ErrorMessage) && Equals(Content, other.Content);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (int) Result;
        __r = __r*31 + (ErrorMessage != null ?ErrorMessage.GetHashCode() : 0);
        __r = __r*31 + (Content != null ?Content.GetHashCode() : 0);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ProjectModelTaskResult (");
      using (printer.IndentCookie()) {
        printer.Print("result = "); Result.PrintEx(printer); printer.Println();
        printer.Print("errorMessage = "); ErrorMessage.PrintEx(printer); printer.Println();
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class ProjectModelTaskResultContent {
    //fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ProjectModelTaskResultContent> Read = (ctx, reader) => ctx.Serializers.Read<ProjectModelTaskResultContent>(ctx, reader);
    
    public static CtxWriteDelegate<ProjectModelTaskResultContent> Write = (ctx, writer, value) => ctx.Serializers.Write<ProjectModelTaskResultContent>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public enum ProjectModelTaskResultKind {
    Complete,
    Error
  }
  
  
  public class ProjectModelTasks : RdBindableBase {
    //fields
    [NotNull] public RdEndpoint<AddItemCommand, ProjectModelTaskResult> AddItem { get { return _AddItem; }}
    [NotNull] private readonly RdEndpoint<AddItemCommand, ProjectModelTaskResult> _AddItem;
    [NotNull] public RdEndpoint<AddProjectCommand, ProjectModelTaskResult> AddProject { get { return _AddProject; }}
    [NotNull] private readonly RdEndpoint<AddProjectCommand, ProjectModelTaskResult> _AddProject;
    [NotNull] public RdEndpoint<AddSolutionFolderCommand, ProjectModelTaskResult> AddSolutionFolder { get { return _AddSolutionFolder; }}
    [NotNull] private readonly RdEndpoint<AddSolutionFolderCommand, ProjectModelTaskResult> _AddSolutionFolder;
    [NotNull] public RdEndpoint<AddReferenceCommand, ProjectModelTaskResult> AddReference { get { return _AddReference; }}
    [NotNull] private readonly RdEndpoint<AddReferenceCommand, ProjectModelTaskResult> _AddReference;
    [NotNull] public RdEndpoint<CopyCommand, ProjectModelTaskResult> Copy { get { return _Copy; }}
    [NotNull] private readonly RdEndpoint<CopyCommand, ProjectModelTaskResult> _Copy;
    [NotNull] public RdEndpoint<MoveCommand, ProjectModelTaskResult> Move { get { return _Move; }}
    [NotNull] private readonly RdEndpoint<MoveCommand, ProjectModelTaskResult> _Move;
    [NotNull] public RdEndpoint<RemoveCommand, ProjectModelTaskResult> Remove { get { return _Remove; }}
    [NotNull] private readonly RdEndpoint<RemoveCommand, ProjectModelTaskResult> _Remove;
    [NotNull] public RdEndpoint<RenameItemCommand, ProjectModelTaskResult> Rename { get { return _Rename; }}
    [NotNull] private readonly RdEndpoint<RenameItemCommand, ProjectModelTaskResult> _Rename;
    [NotNull] public RdEndpoint<ExcludeCommand, ProjectModelTaskResult> Exclude { get { return _Exclude; }}
    [NotNull] private readonly RdEndpoint<ExcludeCommand, ProjectModelTaskResult> _Exclude;
    [NotNull] public RdEndpoint<UnloadCommand, bool> UnloadProjects { get { return _UnloadProjects; }}
    [NotNull] private readonly RdEndpoint<UnloadCommand, bool> _UnloadProjects;
    [NotNull] public RdEndpoint<ReloadCommand, bool> ReloadProjects { get { return _ReloadProjects; }}
    [NotNull] private readonly RdEndpoint<ReloadCommand, bool> _ReloadProjects;
    [NotNull] public RdEndpoint<ReloadAndShowLogCommand, bool> ReloadProjectAndShowLog { get { return _ReloadProjectAndShowLog; }}
    [NotNull] private readonly RdEndpoint<ReloadAndShowLogCommand, bool> _ReloadProjectAndShowLog;
    [NotNull] public IViewableMap<int, RdEditPropertiesSession> EditPropertiesSessions { get { return _EditPropertiesSessions; }}
    [NotNull] private readonly RdMap<int, RdEditPropertiesSession> _EditPropertiesSessions;
    [NotNull] public RdEndpoint<ProjectModelDumpParams, string> DumpProjectModelTask { get { return _DumpProjectModelTask; }}
    [NotNull] private readonly RdEndpoint<ProjectModelDumpParams, string> _DumpProjectModelTask;
    [NotNull] public ISink<ProjectTargetFrameworkId> ChangeTargetFrameworkId { get { return _ChangeTargetFrameworkId; }}
    [NotNull] private readonly RdSignal<ProjectTargetFrameworkId> _ChangeTargetFrameworkId;
    [NotNull] public IRdProperty<bool> DotNetCoreReloading { get { return _DotNetCoreReloading; }}
    [NotNull] private readonly RdProperty<bool> _DotNetCoreReloading;
    
    //primary constructor
    private ProjectModelTasks(
      [NotNull] RdEndpoint<AddItemCommand, ProjectModelTaskResult> addItem,
      [NotNull] RdEndpoint<AddProjectCommand, ProjectModelTaskResult> addProject,
      [NotNull] RdEndpoint<AddSolutionFolderCommand, ProjectModelTaskResult> addSolutionFolder,
      [NotNull] RdEndpoint<AddReferenceCommand, ProjectModelTaskResult> addReference,
      [NotNull] RdEndpoint<CopyCommand, ProjectModelTaskResult> copy,
      [NotNull] RdEndpoint<MoveCommand, ProjectModelTaskResult> move,
      [NotNull] RdEndpoint<RemoveCommand, ProjectModelTaskResult> remove,
      [NotNull] RdEndpoint<RenameItemCommand, ProjectModelTaskResult> rename,
      [NotNull] RdEndpoint<ExcludeCommand, ProjectModelTaskResult> exclude,
      [NotNull] RdEndpoint<UnloadCommand, bool> unloadProjects,
      [NotNull] RdEndpoint<ReloadCommand, bool> reloadProjects,
      [NotNull] RdEndpoint<ReloadAndShowLogCommand, bool> reloadProjectAndShowLog,
      [NotNull] RdMap<int, RdEditPropertiesSession> editPropertiesSessions,
      [NotNull] RdEndpoint<ProjectModelDumpParams, string> dumpProjectModelTask,
      [NotNull] RdSignal<ProjectTargetFrameworkId> changeTargetFrameworkId,
      [NotNull] RdProperty<bool> dotNetCoreReloading
    )
    {
      _AddItem = addItem;
      _AddProject = addProject;
      _AddSolutionFolder = addSolutionFolder;
      _AddReference = addReference;
      _Copy = copy;
      _Move = move;
      _Remove = remove;
      _Rename = rename;
      _Exclude = exclude;
      _UnloadProjects = unloadProjects;
      _ReloadProjects = reloadProjects;
      _ReloadProjectAndShowLog = reloadProjectAndShowLog;
      _EditPropertiesSessions = editPropertiesSessions;
      _DumpProjectModelTask = dumpProjectModelTask;
      _ChangeTargetFrameworkId = changeTargetFrameworkId;
      _DotNetCoreReloading = dotNetCoreReloading;
      dotNetCoreReloading.OptimizeNested = true;
    }
    //secondary constructor
    public ProjectModelTasks (
    ) : this (
      new RdEndpoint<AddItemCommand, ProjectModelTaskResult>(),
      new RdEndpoint<AddProjectCommand, ProjectModelTaskResult>(),
      new RdEndpoint<AddSolutionFolderCommand, ProjectModelTaskResult>(),
      new RdEndpoint<AddReferenceCommand, ProjectModelTaskResult>(),
      new RdEndpoint<CopyCommand, ProjectModelTaskResult>(),
      new RdEndpoint<MoveCommand, ProjectModelTaskResult>(),
      new RdEndpoint<RemoveCommand, ProjectModelTaskResult>(),
      new RdEndpoint<RenameItemCommand, ProjectModelTaskResult>(),
      new RdEndpoint<ExcludeCommand, ProjectModelTaskResult>(),
      new RdEndpoint<UnloadCommand, bool>(),
      new RdEndpoint<ReloadCommand, bool>(),
      new RdEndpoint<ReloadAndShowLogCommand, bool>(),
      new RdMap<int, RdEditPropertiesSession>(),
      new RdEndpoint<ProjectModelDumpParams, string>(),
      new RdSignal<ProjectTargetFrameworkId>(),
      new RdProperty<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<AddReferenceCommand> ReadAddReferenceCommandNullable = AddReferenceCommand.Read.NullableClass();
    public static CtxReadDelegate<ProjectModelTasks> Read = (ctx, reader) => 
    {
      var addItem = RdEndpoint<AddItemCommand, ProjectModelTaskResult>.Read(ctx, reader);
      var addProject = RdEndpoint<AddProjectCommand, ProjectModelTaskResult>.Read(ctx, reader);
      var addSolutionFolder = RdEndpoint<AddSolutionFolderCommand, ProjectModelTaskResult>.Read(ctx, reader);
      var addReference = RdEndpoint<AddReferenceCommand, ProjectModelTaskResult>.Read(ctx, reader);
      var copy = RdEndpoint<CopyCommand, ProjectModelTaskResult>.Read(ctx, reader);
      var move = RdEndpoint<MoveCommand, ProjectModelTaskResult>.Read(ctx, reader);
      var remove = RdEndpoint<RemoveCommand, ProjectModelTaskResult>.Read(ctx, reader);
      var rename = RdEndpoint<RenameItemCommand, ProjectModelTaskResult>.Read(ctx, reader);
      var exclude = RdEndpoint<ExcludeCommand, ProjectModelTaskResult>.Read(ctx, reader);
      var unloadProjects = RdEndpoint<UnloadCommand, bool>.Read(ctx, reader);
      var reloadProjects = RdEndpoint<ReloadCommand, bool>.Read(ctx, reader);
      var reloadProjectAndShowLog = RdEndpoint<ReloadAndShowLogCommand, bool>.Read(ctx, reader);
      var editPropertiesSessions = RdMap<int, RdEditPropertiesSession>.Read(ctx, reader);
      var dumpProjectModelTask = RdEndpoint<ProjectModelDumpParams, string>.Read(ctx, reader);
      var changeTargetFrameworkId = RdSignal<ProjectTargetFrameworkId>.Read(ctx, reader);
      var dotNetCoreReloading = RdProperty<bool>.Read(ctx, reader);
      return new ProjectModelTasks(addItem, addProject, addSolutionFolder, addReference, copy, move, remove, rename, exclude, unloadProjects, reloadProjects, reloadProjectAndShowLog, editPropertiesSessions, dumpProjectModelTask, changeTargetFrameworkId, dotNetCoreReloading);
    };
    
    public static CtxWriteDelegate<AddReferenceCommand> WriteAddReferenceCommandNullable = AddReferenceCommand.Write.NullableClass();
    public static CtxWriteDelegate<ProjectModelTasks> Write = (ctx, writer, value) => 
    {
      RdEndpoint<AddItemCommand, ProjectModelTaskResult>.Write(ctx, writer, value._AddItem);
      RdEndpoint<AddProjectCommand, ProjectModelTaskResult>.Write(ctx, writer, value._AddProject);
      RdEndpoint<AddSolutionFolderCommand, ProjectModelTaskResult>.Write(ctx, writer, value._AddSolutionFolder);
      RdEndpoint<AddReferenceCommand, ProjectModelTaskResult>.Write(ctx, writer, value._AddReference);
      RdEndpoint<CopyCommand, ProjectModelTaskResult>.Write(ctx, writer, value._Copy);
      RdEndpoint<MoveCommand, ProjectModelTaskResult>.Write(ctx, writer, value._Move);
      RdEndpoint<RemoveCommand, ProjectModelTaskResult>.Write(ctx, writer, value._Remove);
      RdEndpoint<RenameItemCommand, ProjectModelTaskResult>.Write(ctx, writer, value._Rename);
      RdEndpoint<ExcludeCommand, ProjectModelTaskResult>.Write(ctx, writer, value._Exclude);
      RdEndpoint<UnloadCommand, bool>.Write(ctx, writer, value._UnloadProjects);
      RdEndpoint<ReloadCommand, bool>.Write(ctx, writer, value._ReloadProjects);
      RdEndpoint<ReloadAndShowLogCommand, bool>.Write(ctx, writer, value._ReloadProjectAndShowLog);
      RdMap<int, RdEditPropertiesSession>.Write(ctx, writer, value._EditPropertiesSessions);
      RdEndpoint<ProjectModelDumpParams, string>.Write(ctx, writer, value._DumpProjectModelTask);
      RdSignal<ProjectTargetFrameworkId>.Write(ctx, writer, value._ChangeTargetFrameworkId);
      RdProperty<bool>.Write(ctx, writer, value._DotNetCoreReloading);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _AddItem.BindEx(lifetime, this, "addItem");
      _AddProject.BindEx(lifetime, this, "addProject");
      _AddSolutionFolder.BindEx(lifetime, this, "addSolutionFolder");
      _AddReference.BindEx(lifetime, this, "addReference");
      _Copy.BindEx(lifetime, this, "copy");
      _Move.BindEx(lifetime, this, "move");
      _Remove.BindEx(lifetime, this, "remove");
      _Rename.BindEx(lifetime, this, "rename");
      _Exclude.BindEx(lifetime, this, "exclude");
      _UnloadProjects.BindEx(lifetime, this, "unloadProjects");
      _ReloadProjects.BindEx(lifetime, this, "reloadProjects");
      _ReloadProjectAndShowLog.BindEx(lifetime, this, "reloadProjectAndShowLog");
      _EditPropertiesSessions.BindEx(lifetime, this, "editPropertiesSessions");
      _DumpProjectModelTask.BindEx(lifetime, this, "dumpProjectModelTask");
      _ChangeTargetFrameworkId.BindEx(lifetime, this, "changeTargetFrameworkId");
      _DotNetCoreReloading.BindEx(lifetime, this, "dotNetCoreReloading");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _AddItem.IdentifyEx(ids);
      _AddProject.IdentifyEx(ids);
      _AddSolutionFolder.IdentifyEx(ids);
      _AddReference.IdentifyEx(ids);
      _Copy.IdentifyEx(ids);
      _Move.IdentifyEx(ids);
      _Remove.IdentifyEx(ids);
      _Rename.IdentifyEx(ids);
      _Exclude.IdentifyEx(ids);
      _UnloadProjects.IdentifyEx(ids);
      _ReloadProjects.IdentifyEx(ids);
      _ReloadProjectAndShowLog.IdentifyEx(ids);
      _EditPropertiesSessions.IdentifyEx(ids);
      _DumpProjectModelTask.IdentifyEx(ids);
      _ChangeTargetFrameworkId.IdentifyEx(ids);
      _DotNetCoreReloading.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ProjectModelTasks (");
      using (printer.IndentCookie()) {
        printer.Print("addItem = "); _AddItem.PrintEx(printer); printer.Println();
        printer.Print("addProject = "); _AddProject.PrintEx(printer); printer.Println();
        printer.Print("addSolutionFolder = "); _AddSolutionFolder.PrintEx(printer); printer.Println();
        printer.Print("addReference = "); _AddReference.PrintEx(printer); printer.Println();
        printer.Print("copy = "); _Copy.PrintEx(printer); printer.Println();
        printer.Print("move = "); _Move.PrintEx(printer); printer.Println();
        printer.Print("remove = "); _Remove.PrintEx(printer); printer.Println();
        printer.Print("rename = "); _Rename.PrintEx(printer); printer.Println();
        printer.Print("exclude = "); _Exclude.PrintEx(printer); printer.Println();
        printer.Print("unloadProjects = "); _UnloadProjects.PrintEx(printer); printer.Println();
        printer.Print("reloadProjects = "); _ReloadProjects.PrintEx(printer); printer.Println();
        printer.Print("reloadProjectAndShowLog = "); _ReloadProjectAndShowLog.PrintEx(printer); printer.Println();
        printer.Print("editPropertiesSessions = "); _EditPropertiesSessions.PrintEx(printer); printer.Println();
        printer.Print("dumpProjectModelTask = "); _DumpProjectModelTask.PrintEx(printer); printer.Println();
        printer.Print("changeTargetFrameworkId = "); _ChangeTargetFrameworkId.PrintEx(printer); printer.Println();
        printer.Print("dotNetCoreReloading = "); _DotNetCoreReloading.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ProjectOutput : IPrintable, IEquatable<ProjectOutput> {
    //fields
    [NotNull] public string Tfm {get; private set;}
    [NotNull] public string ExePath {get; private set;}
    [NotNull] public string WorkingDirectory {get; private set;}
    
    //primary constructor
    public ProjectOutput(
      [NotNull] string tfm,
      [NotNull] string exePath,
      [NotNull] string workingDirectory
    )
    {
      Tfm = tfm;
      ExePath = exePath;
      WorkingDirectory = workingDirectory;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ProjectOutput> Read = (ctx, reader) => 
    {
      var tfm = reader.ReadString();
      var exePath = reader.ReadString();
      var workingDirectory = reader.ReadString();
      return new ProjectOutput(tfm, exePath, workingDirectory);
    };
    
    public static CtxWriteDelegate<ProjectOutput> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Tfm);
      writer.Write(value.ExePath);
      writer.Write(value.WorkingDirectory);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ProjectOutput) obj);
    }
    public bool Equals(ProjectOutput other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Tfm == other.Tfm && ExePath == other.ExePath && WorkingDirectory == other.WorkingDirectory;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Tfm.GetHashCode();
        __r = __r*31 + ExePath.GetHashCode();
        __r = __r*31 + WorkingDirectory.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ProjectOutput (");
      using (printer.IndentCookie()) {
        printer.Print("tfm = "); Tfm.PrintEx(printer); printer.Println();
        printer.Print("exePath = "); ExePath.PrintEx(printer); printer.Println();
        printer.Print("workingDirectory = "); WorkingDirectory.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ProjectOutputType {
    Exe,
    Dll,
    Other,
    DotNetCore
  }
  
  
  public class ProjectPropertiesHostModel : RdBindableBase {
    //fields
    [NotNull] public IViewableMap<string, ProjectModel> Projects { get { return _Projects; }}
    [NotNull] private readonly RdMap<string, ProjectModel> _Projects;
    
    //primary constructor
    private ProjectPropertiesHostModel(
      [NotNull] RdMap<string, ProjectModel> projects
    )
    {
      _Projects = projects;
    }
    //secondary constructor
    public ProjectPropertiesHostModel (
    ) : this (
      new RdMap<string, ProjectModel>()
    ) {}
    //statics
    
    public static CtxReadDelegate<ProjectPropertiesHostModel> Read = (ctx, reader) => 
    {
      var projects = RdMap<string, ProjectModel>.Read(ctx, reader);
      return new ProjectPropertiesHostModel(projects);
    };
    
    public static CtxWriteDelegate<ProjectPropertiesHostModel> Write = (ctx, writer, value) => 
    {
      RdMap<string, ProjectModel>.Write(ctx, writer, value._Projects);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Projects.BindEx(lifetime, this, "projects");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Projects.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ProjectPropertiesHostModel (");
      using (printer.IndentCookie()) {
        printer.Print("projects = "); _Projects.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ProjectPropertiesModel : IPrintable, IEquatable<ProjectPropertiesModel> {
    //fields
    public Guid Guid {get; private set;}
    [NotNull] public string Name {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public List<Guid> ProjectTypeGuids {get; private set;}
    [NotNull] public List<ProjectType> KnownProjectTypes {get; private set;}
    public ProjectOutputType OutputType {get; private set;}
    [CanBeNull] public string OutputPath {get; private set;}
    [CanBeNull] public string ActiveConfiguration {get; private set;}
    [CanBeNull] public string ActivePlatform {get; private set;}
    [NotNull] public List<string> TreePath {get; private set;}
    [NotNull] public string CurrentTargetFrameworkId {get; private set;}
    [NotNull] public List<string> TargetFrameworkIds {get; private set;}
    
    //primary constructor
    public ProjectPropertiesModel(
      Guid guid,
      [NotNull] string name,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] List<Guid> projectTypeGuids,
      [NotNull] List<ProjectType> knownProjectTypes,
      ProjectOutputType outputType,
      [CanBeNull] string outputPath,
      [CanBeNull] string activeConfiguration,
      [CanBeNull] string activePlatform,
      [NotNull] List<string> treePath,
      [NotNull] string currentTargetFrameworkId,
      [NotNull] List<string> targetFrameworkIds
    )
    {
      Guid = guid;
      Name = name;
      Icon = icon;
      ProjectTypeGuids = projectTypeGuids;
      KnownProjectTypes = knownProjectTypes;
      OutputType = outputType;
      OutputPath = outputPath;
      ActiveConfiguration = activeConfiguration;
      ActivePlatform = activePlatform;
      TreePath = treePath;
      CurrentTargetFrameworkId = currentTargetFrameworkId;
      TargetFrameworkIds = targetFrameworkIds;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<List<Guid>> ReadGuidList = Serializers.ReadGuid.List();
    public static CtxReadDelegate<List<ProjectType>> ReadProjectTypeList = new CtxReadDelegate<ProjectType>(Serializers.ReadEnum<ProjectType>).List();
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static CtxReadDelegate<ProjectPropertiesModel> Read = (ctx, reader) => 
    {
      var guid = reader.ReadGuid();
      var name = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var projectTypeGuids = ReadGuidList(ctx, reader);
      var knownProjectTypes = ReadProjectTypeList(ctx, reader);
      var outputType = (ProjectOutputType)reader.ReadInt();
      var outputPath = ReadStringNullable(ctx, reader);
      var activeConfiguration = ReadStringNullable(ctx, reader);
      var activePlatform = ReadStringNullable(ctx, reader);
      var treePath = ReadStringList(ctx, reader);
      var currentTargetFrameworkId = reader.ReadString();
      var targetFrameworkIds = ReadStringList(ctx, reader);
      return new ProjectPropertiesModel(guid, name, icon, projectTypeGuids, knownProjectTypes, outputType, outputPath, activeConfiguration, activePlatform, treePath, currentTargetFrameworkId, targetFrameworkIds);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<List<Guid>> WriteGuidList = Serializers.WriteGuid.List();
    public static CtxWriteDelegate<List<ProjectType>> WriteProjectTypeList = new CtxWriteDelegate<ProjectType>(Serializers.WriteEnum<ProjectType>).List();
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static CtxWriteDelegate<ProjectPropertiesModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Guid);
      writer.Write(value.Name);
      WriteIconNullable(ctx, writer, value.Icon);
      WriteGuidList(ctx, writer, value.ProjectTypeGuids);
      WriteProjectTypeList(ctx, writer, value.KnownProjectTypes);
      writer.Write((int)value.OutputType);
      WriteStringNullable(ctx, writer, value.OutputPath);
      WriteStringNullable(ctx, writer, value.ActiveConfiguration);
      WriteStringNullable(ctx, writer, value.ActivePlatform);
      WriteStringList(ctx, writer, value.TreePath);
      writer.Write(value.CurrentTargetFrameworkId);
      WriteStringList(ctx, writer, value.TargetFrameworkIds);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ProjectPropertiesModel) obj);
    }
    public bool Equals(ProjectPropertiesModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Guid == other.Guid && Name == other.Name && Equals(Icon, other.Icon) && ProjectTypeGuids.SequenceEqual(other.ProjectTypeGuids) && KnownProjectTypes.SequenceEqual(other.KnownProjectTypes) && OutputType == other.OutputType && Equals(OutputPath, other.OutputPath) && Equals(ActiveConfiguration, other.ActiveConfiguration) && Equals(ActivePlatform, other.ActivePlatform) && TreePath.SequenceEqual(other.TreePath) && CurrentTargetFrameworkId == other.CurrentTargetFrameworkId && TargetFrameworkIds.SequenceEqual(other.TargetFrameworkIds);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Guid.GetHashCode();
        __r = __r*31 + Name.GetHashCode();
        __r = __r*31 + (Icon != null ?Icon.GetHashCode() : 0);
        __r = __r*31 + CollectionUtil.GetHashCode(ProjectTypeGuids);
        __r = __r*31 + CollectionUtil.GetHashCode(KnownProjectTypes);
        __r = __r*31 + (int) OutputType;
        __r = __r*31 + (OutputPath != null ?OutputPath.GetHashCode() : 0);
        __r = __r*31 + (ActiveConfiguration != null ?ActiveConfiguration.GetHashCode() : 0);
        __r = __r*31 + (ActivePlatform != null ?ActivePlatform.GetHashCode() : 0);
        __r = __r*31 + CollectionUtil.GetHashCode(TreePath);
        __r = __r*31 + CurrentTargetFrameworkId.GetHashCode();
        __r = __r*31 + CollectionUtil.GetHashCode(TargetFrameworkIds);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ProjectPropertiesModel (");
      using (printer.IndentCookie()) {
        printer.Print("guid = "); Guid.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("projectTypeGuids = "); ProjectTypeGuids.PrintEx(printer); printer.Println();
        printer.Print("knownProjectTypes = "); KnownProjectTypes.PrintEx(printer); printer.Println();
        printer.Print("outputType = "); OutputType.PrintEx(printer); printer.Println();
        printer.Print("outputPath = "); OutputPath.PrintEx(printer); printer.Println();
        printer.Print("activeConfiguration = "); ActiveConfiguration.PrintEx(printer); printer.Println();
        printer.Print("activePlatform = "); ActivePlatform.PrintEx(printer); printer.Println();
        printer.Print("treePath = "); TreePath.PrintEx(printer); printer.Println();
        printer.Print("currentTargetFrameworkId = "); CurrentTargetFrameworkId.PrintEx(printer); printer.Println();
        printer.Print("targetFrameworkIds = "); TargetFrameworkIds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ProjectTargetFrameworkId : IPrintable, IEquatable<ProjectTargetFrameworkId> {
    //fields
    public int ProjectModelId {get; private set;}
    [NotNull] public string TargetFrameworkId {get; private set;}
    
    //primary constructor
    public ProjectTargetFrameworkId(
      int projectModelId,
      [NotNull] string targetFrameworkId
    )
    {
      ProjectModelId = projectModelId;
      TargetFrameworkId = targetFrameworkId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ProjectTargetFrameworkId> Read = (ctx, reader) => 
    {
      var projectModelId = reader.ReadInt();
      var targetFrameworkId = reader.ReadString();
      return new ProjectTargetFrameworkId(projectModelId, targetFrameworkId);
    };
    
    public static CtxWriteDelegate<ProjectTargetFrameworkId> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProjectModelId);
      writer.Write(value.TargetFrameworkId);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ProjectTargetFrameworkId) obj);
    }
    public bool Equals(ProjectTargetFrameworkId other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectModelId == other.ProjectModelId && TargetFrameworkId == other.TargetFrameworkId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + ProjectModelId.GetHashCode();
        __r = __r*31 + TargetFrameworkId.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ProjectTargetFrameworkId (");
      using (printer.IndentCookie()) {
        printer.Print("projectModelId = "); ProjectModelId.PrintEx(printer); printer.Println();
        printer.Print("targetFrameworkId = "); TargetFrameworkId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ProjectType {
    CSharp,
    VBasic,
    VCX,
    WebSite,
    WebApplication
  }
  
  
  public class PsiDebuggerHostModel : RdBindableBase {
    //fields
    [NotNull] public RdEndpoint<ResolveExpressionArgs, ResolveExpressionResult> ResolveExpression { get { return _ResolveExpression; }}
    [NotNull] private readonly RdEndpoint<ResolveExpressionArgs, ResolveExpressionResult> _ResolveExpression;
    [NotNull] public RdEndpoint<ResolveLocalSymbolArg, ResolveLocalSymbolResult> ResolveLocalSymbol { get { return _ResolveLocalSymbol; }}
    [NotNull] private readonly RdEndpoint<ResolveLocalSymbolArg, ResolveLocalSymbolResult> _ResolveLocalSymbol;
    
    //primary constructor
    private PsiDebuggerHostModel(
      [NotNull] RdEndpoint<ResolveExpressionArgs, ResolveExpressionResult> resolveExpression,
      [NotNull] RdEndpoint<ResolveLocalSymbolArg, ResolveLocalSymbolResult> resolveLocalSymbol
    )
    {
      _ResolveExpression = resolveExpression;
      _ResolveLocalSymbol = resolveLocalSymbol;
    }
    //secondary constructor
    public PsiDebuggerHostModel (
    ) : this (
      new RdEndpoint<ResolveExpressionArgs, ResolveExpressionResult>(),
      new RdEndpoint<ResolveLocalSymbolArg, ResolveLocalSymbolResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<ResolveExpressionResult> ReadResolveExpressionResultNullable = ResolveExpressionResult.Read.NullableClass();
    public static CtxReadDelegate<ResolveLocalSymbolResult> ReadResolveLocalSymbolResultNullable = ResolveLocalSymbolResult.Read.NullableClass();
    public static CtxReadDelegate<PsiDebuggerHostModel> Read = (ctx, reader) => 
    {
      var resolveExpression = RdEndpoint<ResolveExpressionArgs, ResolveExpressionResult>.Read(ctx, reader);
      var resolveLocalSymbol = RdEndpoint<ResolveLocalSymbolArg, ResolveLocalSymbolResult>.Read(ctx, reader);
      return new PsiDebuggerHostModel(resolveExpression, resolveLocalSymbol);
    };
    
    public static CtxWriteDelegate<ResolveExpressionResult> WriteResolveExpressionResultNullable = ResolveExpressionResult.Write.NullableClass();
    public static CtxWriteDelegate<ResolveLocalSymbolResult> WriteResolveLocalSymbolResultNullable = ResolveLocalSymbolResult.Write.NullableClass();
    public static CtxWriteDelegate<PsiDebuggerHostModel> Write = (ctx, writer, value) => 
    {
      RdEndpoint<ResolveExpressionArgs, ResolveExpressionResult>.Write(ctx, writer, value._ResolveExpression);
      RdEndpoint<ResolveLocalSymbolArg, ResolveLocalSymbolResult>.Write(ctx, writer, value._ResolveLocalSymbol);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _ResolveExpression.BindEx(lifetime, this, "resolveExpression");
      _ResolveLocalSymbol.BindEx(lifetime, this, "resolveLocalSymbol");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ResolveExpression.IdentifyEx(ids);
      _ResolveLocalSymbol.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PsiDebuggerHostModel (");
      using (printer.IndentCookie()) {
        printer.Print("resolveExpression = "); _ResolveExpression.PrintEx(printer); printer.Println();
        printer.Print("resolveLocalSymbol = "); _ResolveLocalSymbol.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class QuickDocElementInfo : IPrintable, IEquatable<QuickDocElementInfo> {
    //fields
    [NotNull] public string DescriptionHtml {get; private set;}
    
    //primary constructor
    public QuickDocElementInfo(
      [NotNull] string descriptionHtml
    )
    {
      DescriptionHtml = descriptionHtml;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<QuickDocElementInfo> Read = (ctx, reader) => 
    {
      var descriptionHtml = reader.ReadString();
      return new QuickDocElementInfo(descriptionHtml);
    };
    
    public static CtxWriteDelegate<QuickDocElementInfo> Write = (ctx, writer, value) => 
    {
      writer.Write(value.DescriptionHtml);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((QuickDocElementInfo) obj);
    }
    public bool Equals(QuickDocElementInfo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return DescriptionHtml == other.DescriptionHtml;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + DescriptionHtml.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("QuickDocElementInfo (");
      using (printer.IndentCookie()) {
        printer.Print("descriptionHtml = "); DescriptionHtml.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class QuickDocHostModel : RdBindableBase {
    //fields
    [NotNull] public IViewableMap<int, QuickDocSession> QuickDocSessions { get { return _QuickDocSessions; }}
    [NotNull] private readonly RdMap<int, QuickDocSession> _QuickDocSessions;
    
    //primary constructor
    private QuickDocHostModel(
      [NotNull] RdMap<int, QuickDocSession> quickDocSessions
    )
    {
      _QuickDocSessions = quickDocSessions;
    }
    //secondary constructor
    public QuickDocHostModel (
    ) : this (
      new RdMap<int, QuickDocSession>()
    ) {}
    //statics
    
    public static CtxReadDelegate<QuickDocHostModel> Read = (ctx, reader) => 
    {
      var quickDocSessions = RdMap<int, QuickDocSession>.Read(ctx, reader);
      return new QuickDocHostModel(quickDocSessions);
    };
    
    public static CtxWriteDelegate<QuickDocHostModel> Write = (ctx, writer, value) => 
    {
      RdMap<int, QuickDocSession>.Write(ctx, writer, value._QuickDocSessions);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _QuickDocSessions.BindEx(lifetime, this, "quickDocSessions");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _QuickDocSessions.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("QuickDocHostModel (");
      using (printer.IndentCookie()) {
        printer.Print("quickDocSessions = "); _QuickDocSessions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class QuickDocNavigationArgs : IPrintable, IEquatable<QuickDocNavigationArgs> {
    //fields
    [CanBeNull] public string Url {get; private set;}
    
    //primary constructor
    public QuickDocNavigationArgs(
      [CanBeNull] string url
    )
    {
      Url = url;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<QuickDocNavigationArgs> Read = (ctx, reader) => 
    {
      var url = ReadStringNullable(ctx, reader);
      return new QuickDocNavigationArgs(url);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<QuickDocNavigationArgs> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.Url);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((QuickDocNavigationArgs) obj);
    }
    public bool Equals(QuickDocNavigationArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Url, other.Url);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (Url != null ?Url.GetHashCode() : 0);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("QuickDocNavigationArgs (");
      using (printer.IndentCookie()) {
        printer.Print("url = "); Url.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class QuickDocSession : RdBindableBase {
    //fields
    [NotNull] public QuickDocElementInfo InitialInfo {get; private set;}
    [NotNull] public TextControlId TextControl {get; private set;}
    [NotNull] public RdEndpoint<string, QuickDocElementInfo> FetchInfoByLink { get { return _FetchInfoByLink; }}
    [NotNull] private readonly RdEndpoint<string, QuickDocElementInfo> _FetchInfoByLink;
    [NotNull] public ISink<QuickDocNavigationArgs> Navigate { get { return _Navigate; }}
    [NotNull] private readonly RdSignal<QuickDocNavigationArgs> _Navigate;
    
    //primary constructor
    private QuickDocSession(
      [NotNull] QuickDocElementInfo initialInfo,
      [NotNull] TextControlId textControl,
      [NotNull] RdEndpoint<string, QuickDocElementInfo> fetchInfoByLink,
      [NotNull] RdSignal<QuickDocNavigationArgs> navigate
    )
    {
      InitialInfo = initialInfo;
      TextControl = textControl;
      _FetchInfoByLink = fetchInfoByLink;
      _Navigate = navigate;
    }
    //secondary constructor
    public QuickDocSession (
      [NotNull] QuickDocElementInfo InitialInfo,
      [NotNull] TextControlId TextControl
    ) : this (
      InitialInfo,
      TextControl,
      new RdEndpoint<string, QuickDocElementInfo>(),
      new RdSignal<QuickDocNavigationArgs>()
    ) {}
    //statics
    
    public static CtxReadDelegate<QuickDocSession> Read = (ctx, reader) => 
    {
      var initialInfo = QuickDocElementInfo.Read(ctx, reader);
      var textControl = TextControlId.Read(ctx, reader);
      var fetchInfoByLink = RdEndpoint<string, QuickDocElementInfo>.Read(ctx, reader);
      var navigate = RdSignal<QuickDocNavigationArgs>.Read(ctx, reader);
      return new QuickDocSession(initialInfo, textControl, fetchInfoByLink, navigate);
    };
    
    public static CtxWriteDelegate<QuickDocSession> Write = (ctx, writer, value) => 
    {
      QuickDocElementInfo.Write(ctx, writer, value.InitialInfo);
      TextControlId.Write(ctx, writer, value.TextControl);
      RdEndpoint<string, QuickDocElementInfo>.Write(ctx, writer, value._FetchInfoByLink);
      RdSignal<QuickDocNavigationArgs>.Write(ctx, writer, value._Navigate);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _FetchInfoByLink.BindEx(lifetime, this, "fetchInfoByLink");
      _Navigate.BindEx(lifetime, this, "navigate");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _FetchInfoByLink.IdentifyEx(ids);
      _Navigate.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("QuickDocSession (");
      using (printer.IndentCookie()) {
        printer.Print("initialInfo = "); InitialInfo.PrintEx(printer); printer.Println();
        printer.Print("textControl = "); TextControl.PrintEx(printer); printer.Println();
        printer.Print("fetchInfoByLink = "); _FetchInfoByLink.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdAssemblyReferenceDescriptor : RdProjectModelItemDescriptor
   {
    //fields
    //primary constructor
    public RdAssemblyReferenceDescriptor(
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdAssemblyReferenceDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      return new RdAssemblyReferenceDescriptor(name, location);
    };
    
    public static new CtxWriteDelegate<RdAssemblyReferenceDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdAssemblyReferenceDescriptor) obj);
    }
    public bool Equals(RdAssemblyReferenceDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Name.GetHashCode();
        __r = __r*31 + Location.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdAssemblyReferenceDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCommandProcessor : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<string> CurrentCommand { get { return _CurrentCommand; }}
    [NotNull] private readonly RdProperty<string> _CurrentCommand;
    
    //primary constructor
    private RdCommandProcessor(
      [NotNull] RdProperty<string> currentCommand
    )
    {
      _CurrentCommand = currentCommand;
      currentCommand.OptimizeNested = true;
    }
    //secondary constructor
    public RdCommandProcessor (
    ) : this (
      new RdProperty<string>()
    ) {}
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<RdCommandProcessor> Read = (ctx, reader) => 
    {
      var currentCommand = RdProperty<string>.Read(ctx, reader);
      return new RdCommandProcessor(currentCommand);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<RdCommandProcessor> Write = (ctx, writer, value) => 
    {
      RdProperty<string>.Write(ctx, writer, value._CurrentCommand);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _CurrentCommand.BindEx(lifetime, this, "currentCommand");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _CurrentCommand.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdCommandProcessor (");
      using (printer.IndentCookie()) {
        printer.Print("currentCommand = "); _CurrentCommand.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdConfigurationAndPlatform : RdBindableBase {
    //fields
    [NotNull] public string Configuration {get; private set;}
    [NotNull] public string Platform {get; private set;}
    
    //primary constructor
    public RdConfigurationAndPlatform(
      [NotNull] string configuration,
      [NotNull] string platform
    )
    {
      Configuration = configuration;
      Platform = platform;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdConfigurationAndPlatform> Read = (ctx, reader) => 
    {
      var configuration = reader.ReadString();
      var platform = reader.ReadString();
      return new RdConfigurationAndPlatform(configuration, platform);
    };
    
    public static CtxWriteDelegate<RdConfigurationAndPlatform> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Configuration);
      writer.Write(value.Platform);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdConfigurationAndPlatform (");
      using (printer.IndentCookie()) {
        printer.Print("configuration = "); Configuration.PrintEx(printer); printer.Println();
        printer.Print("platform = "); Platform.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCreateFromTemplateCommand : IPrintable, IEquatable<RdCreateFromTemplateCommand> {
    //fields
    [NotNull] public string ItemName {get; private set;}
    [NotNull] public RdFileTemplate Template {get; private set;}
    public int ParentId {get; private set;}
    
    //primary constructor
    public RdCreateFromTemplateCommand(
      [NotNull] string itemName,
      [NotNull] RdFileTemplate template,
      int parentId
    )
    {
      ItemName = itemName;
      Template = template;
      ParentId = parentId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdCreateFromTemplateCommand> Read = (ctx, reader) => 
    {
      var itemName = reader.ReadString();
      var template = RdFileTemplate.Read(ctx, reader);
      var parentId = reader.ReadInt();
      return new RdCreateFromTemplateCommand(itemName, template, parentId);
    };
    
    public static CtxWriteDelegate<RdCreateFromTemplateCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemName);
      RdFileTemplate.Write(ctx, writer, value.Template);
      writer.Write(value.ParentId);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdCreateFromTemplateCommand) obj);
    }
    public bool Equals(RdCreateFromTemplateCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemName == other.ItemName && Equals(Template, other.Template) && ParentId == other.ParentId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + ItemName.GetHashCode();
        __r = __r*31 + Template.GetHashCode();
        __r = __r*31 + ParentId.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdCreateFromTemplateCommand (");
      using (printer.IndentCookie()) {
        printer.Print("itemName = "); ItemName.PrintEx(printer); printer.Println();
        printer.Print("template = "); Template.PrintEx(printer); printer.Println();
        printer.Print("parentId = "); ParentId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCustomLocation : RdProjectModelItemLocation
   {
    //fields
    [NotNull] public string CustomLocation {get; private set;}
    
    //primary constructor
    public RdCustomLocation(
      [NotNull] string customLocation
    )
    {
      CustomLocation = customLocation;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdCustomLocation> Read = (ctx, reader) => 
    {
      var customLocation = reader.ReadString();
      return new RdCustomLocation(customLocation);
    };
    
    public static new CtxWriteDelegate<RdCustomLocation> Write = (ctx, writer, value) => 
    {
      writer.Write(value.CustomLocation);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdCustomLocation) obj);
    }
    public bool Equals(RdCustomLocation other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return CustomLocation == other.CustomLocation;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CustomLocation.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdCustomLocation (");
      using (printer.IndentCookie()) {
        printer.Print("customLocation = "); CustomLocation.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDelta : IPrintable, IEquatable<RdDelta> {
    //fields
    [NotNull] public string Path {get; private set;}
    public RdDeltaType Type {get; private set;}
    
    //primary constructor
    public RdDelta(
      [NotNull] string path,
      RdDeltaType type
    )
    {
      Path = path;
      Type = type;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdDelta> Read = (ctx, reader) => 
    {
      var path = reader.ReadString();
      var type = (RdDeltaType)reader.ReadInt();
      return new RdDelta(path, type);
    };
    
    public static CtxWriteDelegate<RdDelta> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Path);
      writer.Write((int)value.Type);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdDelta) obj);
    }
    public bool Equals(RdDelta other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Path == other.Path && Type == other.Type;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Path.GetHashCode();
        __r = __r*31 + (int) Type;
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdDelta (");
      using (printer.IndentCookie()) {
        printer.Print("path = "); Path.PrintEx(printer); printer.Println();
        printer.Print("type = "); Type.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDeltaBatch : IPrintable, IEquatable<RdDeltaBatch> {
    //fields
    [NotNull] public List<RdDelta> Deltas {get; private set;}
    
    //primary constructor
    public RdDeltaBatch(
      [NotNull] List<RdDelta> deltas
    )
    {
      Deltas = deltas;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<RdDelta>> ReadRdDeltaList = RdDelta.Read.List();
    public static CtxReadDelegate<RdDeltaBatch> Read = (ctx, reader) => 
    {
      var deltas = ReadRdDeltaList(ctx, reader);
      return new RdDeltaBatch(deltas);
    };
    
    public static CtxWriteDelegate<List<RdDelta>> WriteRdDeltaList = RdDelta.Write.List();
    public static CtxWriteDelegate<RdDeltaBatch> Write = (ctx, writer, value) => 
    {
      WriteRdDeltaList(ctx, writer, value.Deltas);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdDeltaBatch) obj);
    }
    public bool Equals(RdDeltaBatch other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Deltas.SequenceEqual(other.Deltas);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(Deltas);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdDeltaBatch (");
      using (printer.IndentCookie()) {
        printer.Print("deltas = "); Deltas.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdDeltaType {
    Created,
    Deleted,
    Changed
  }
  
  
  public class RdDependencyDescriptor : RdProjectModelItemDescriptor
   {
    //fields
    public RdDependencyType Type {get; private set;}
    
    //primary constructor
    public RdDependencyDescriptor(
      RdDependencyType type,
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
      Type = type;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdDependencyDescriptor> Read = (ctx, reader) => 
    {
      var type = (RdDependencyType)reader.ReadInt();
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      return new RdDependencyDescriptor(type, name, location);
    };
    
    public static new CtxWriteDelegate<RdDependencyDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Type);
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdDependencyDescriptor) obj);
    }
    public bool Equals(RdDependencyDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Type == other.Type && Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (int) Type;
        __r = __r*31 + Name.GetHashCode();
        __r = __r*31 + Location.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdDependencyDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("type = "); Type.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdDependencyType {
    Dependency,
    Reference,
    Error
  }
  
  
  public class RdDiagnosticsHost : RdBindableBase {
    //fields
    [NotNull] public RdMemoryUsageIndicator MemoryUsageIndicator {get; private set;}
    [NotNull] public IViewableMap<string, RdSpecialPath> SpecialPaths { get { return _SpecialPaths; }}
    [NotNull] private readonly RdMap<string, RdSpecialPath> _SpecialPaths;
    [NotNull] public IRdProperty<bool> Recording { get { return _Recording; }}
    [NotNull] private readonly RdProperty<bool> _Recording;
    [NotNull] public IRdProperty<AssertMode> BackendAssertMode { get { return _BackendAssertMode; }}
    [NotNull] private readonly RdProperty<AssertMode> _BackendAssertMode;
    [NotNull] public ISource<string> AssertFromBackend { get { return _AssertFromBackend; }}
    [NotNull] private readonly RdSignal<string> _AssertFromBackend;
    
    //primary constructor
    private RdDiagnosticsHost(
      [NotNull] RdMemoryUsageIndicator memoryUsageIndicator,
      [NotNull] RdMap<string, RdSpecialPath> specialPaths,
      [NotNull] RdProperty<bool> recording,
      [NotNull] RdProperty<AssertMode> backendAssertMode,
      [NotNull] RdSignal<string> assertFromBackend
    )
    {
      MemoryUsageIndicator = memoryUsageIndicator;
      _SpecialPaths = specialPaths;
      _Recording = recording;
      _BackendAssertMode = backendAssertMode;
      _AssertFromBackend = assertFromBackend;
      recording.OptimizeNested = true;
      backendAssertMode.OptimizeNested = true;
    }
    //secondary constructor
    public RdDiagnosticsHost (
    ) : this (
      new RdMemoryUsageIndicator(),
      new RdMap<string, RdSpecialPath>(),
      new RdProperty<bool>(),
      new RdProperty<AssertMode>(),
      new RdSignal<string>()
    ) {}
    //statics
    
    public static CtxReadDelegate<AssertMode> ReadAssertMode = new CtxReadDelegate<AssertMode>(Serializers.ReadEnum<AssertMode>);
    public static CtxReadDelegate<RdDiagnosticsHost> Read = (ctx, reader) => 
    {
      var memoryUsageIndicator = RdMemoryUsageIndicator.Read(ctx, reader);
      var specialPaths = RdMap<string, RdSpecialPath>.Read(ctx, reader);
      var recording = RdProperty<bool>.Read(ctx, reader);
      var backendAssertMode = RdProperty<AssertMode>.Read(ctx, reader);
      var assertFromBackend = RdSignal<string>.Read(ctx, reader);
      return new RdDiagnosticsHost(memoryUsageIndicator, specialPaths, recording, backendAssertMode, assertFromBackend);
    };
    
    public static CtxWriteDelegate<AssertMode> WriteAssertMode = new CtxWriteDelegate<AssertMode>(Serializers.WriteEnum<AssertMode>);
    public static CtxWriteDelegate<RdDiagnosticsHost> Write = (ctx, writer, value) => 
    {
      RdMemoryUsageIndicator.Write(ctx, writer, value.MemoryUsageIndicator);
      RdMap<string, RdSpecialPath>.Write(ctx, writer, value._SpecialPaths);
      RdProperty<bool>.Write(ctx, writer, value._Recording);
      RdProperty<AssertMode>.Write(ctx, writer, value._BackendAssertMode);
      RdSignal<string>.Write(ctx, writer, value._AssertFromBackend);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      MemoryUsageIndicator.BindEx(lifetime, this, "memoryUsageIndicator");
      _SpecialPaths.BindEx(lifetime, this, "specialPaths");
      _Recording.BindEx(lifetime, this, "recording");
      _BackendAssertMode.BindEx(lifetime, this, "backendAssertMode");
      _AssertFromBackend.BindEx(lifetime, this, "assertFromBackend");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      MemoryUsageIndicator.IdentifyEx(ids);
      _SpecialPaths.IdentifyEx(ids);
      _Recording.IdentifyEx(ids);
      _BackendAssertMode.IdentifyEx(ids);
      _AssertFromBackend.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdDiagnosticsHost (");
      using (printer.IndentCookie()) {
        printer.Print("memoryUsageIndicator = "); MemoryUsageIndicator.PrintEx(printer); printer.Println();
        printer.Print("specialPaths = "); _SpecialPaths.PrintEx(printer); printer.Println();
        printer.Print("recording = "); _Recording.PrintEx(printer); printer.Println();
        printer.Print("backendAssertMode = "); _BackendAssertMode.PrintEx(printer); printer.Println();
        printer.Print("assertFromBackend = "); _AssertFromBackend.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditProjectItemPropertiesContent : RdEditPropertiesSessionContent
   {
    //fields
    [NotNull] public List<RdEditPropertySection> Sections {get; private set;}
    
    //primary constructor
    public RdEditProjectItemPropertiesContent(
      [NotNull] List<RdEditPropertySection> sections
    )
    {
      Sections = sections;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<RdEditPropertySection>> ReadRdEditPropertySectionList = RdEditPropertySection.Read.List();
    public static new CtxReadDelegate<RdEditProjectItemPropertiesContent> Read = (ctx, reader) => 
    {
      var sections = ReadRdEditPropertySectionList(ctx, reader);
      return new RdEditProjectItemPropertiesContent(sections);
    };
    
    public static CtxWriteDelegate<List<RdEditPropertySection>> WriteRdEditPropertySectionList = RdEditPropertySection.Write.List();
    public static new CtxWriteDelegate<RdEditProjectItemPropertiesContent> Write = (ctx, writer, value) => 
    {
      WriteRdEditPropertySectionList(ctx, writer, value.Sections);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Sections.BindEx(lifetime, this, "sections");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Sections.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditProjectItemPropertiesContent (");
      using (printer.IndentCookie()) {
        printer.Print("sections = "); Sections.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertiesMessageContent : RdEditPropertiesSessionContent
   {
    //fields
    [NotNull] public string Message {get; private set;}
    
    //primary constructor
    public RdEditPropertiesMessageContent(
      [NotNull] string message
    )
    {
      Message = message;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEditPropertiesMessageContent> Read = (ctx, reader) => 
    {
      var message = reader.ReadString();
      return new RdEditPropertiesMessageContent(message);
    };
    
    public static new CtxWriteDelegate<RdEditPropertiesMessageContent> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Message);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertiesMessageContent (");
      using (printer.IndentCookie()) {
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertiesSession : RdBindableBase {
    //fields
    public int ItemId {get; private set;}
    [NotNull] public IRdProperty<RdEditPropertiesSessionContent> Content { get { return _Content; }}
    [NotNull] private readonly RdProperty<RdEditPropertiesSessionContent> _Content;
    [NotNull] public IVoidSink Save { get { return _Save; }}
    [NotNull] private readonly RdVoidSignal _Save;
    
    //primary constructor
    private RdEditPropertiesSession(
      int itemId,
      [NotNull] RdProperty<RdEditPropertiesSessionContent> content,
      [NotNull] RdVoidSignal save
    )
    {
      ItemId = itemId;
      _Content = content;
      _Save = save;
    }
    //secondary constructor
    public RdEditPropertiesSession (
      int ItemId
    ) : this (
      ItemId,
      new RdProperty<RdEditPropertiesSessionContent>(),
      new RdVoidSignal()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdEditPropertiesSession> Read = (ctx, reader) => 
    {
      var itemId = reader.ReadInt();
      var content = RdProperty<RdEditPropertiesSessionContent>.Read(ctx, reader);
      var save = RdVoidSignal.Read(ctx, reader);
      return new RdEditPropertiesSession(itemId, content, save);
    };
    
    public static CtxWriteDelegate<RdEditPropertiesSession> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemId);
      RdProperty<RdEditPropertiesSessionContent>.Write(ctx, writer, value._Content);
      RdVoidSignal.Write(ctx, writer, value._Save);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Content.BindEx(lifetime, this, "content");
      _Save.BindEx(lifetime, this, "save");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Content.IdentifyEx(ids);
      _Save.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertiesSession (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
        printer.Print("content = "); _Content.PrintEx(printer); printer.Println();
        printer.Print("save = "); _Save.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdEditPropertiesSessionContent : RdBindableBase {
    //fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdEditPropertiesSessionContent> Read = (ctx, reader) => ctx.Serializers.Read<RdEditPropertiesSessionContent>(ctx, reader);
    
    public static CtxWriteDelegate<RdEditPropertiesSessionContent> Write = (ctx, writer, value) => ctx.Serializers.Write<RdEditPropertiesSessionContent>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public abstract class RdEditPropertyItem : RdBindableBase {
    //fields
    [NotNull] public string Text {get; private set;}
    
    //primary constructor
    protected RdEditPropertyItem(
      [NotNull] string text
    )
    {
      Text = text;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdEditPropertyItem> Read = (ctx, reader) => ctx.Serializers.Read<RdEditPropertyItem>(ctx, reader);
    
    public static CtxWriteDelegate<RdEditPropertyItem> Write = (ctx, writer, value) => ctx.Serializers.Write<RdEditPropertyItem>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdEditPropertyItemCheck : RdEditPropertyItem
   {
    //fields
    public bool ReadonlyValue {get; private set;}
    
    //primary constructor
    public RdEditPropertyItemCheck(
      bool readonlyValue,
      [NotNull] string text
    ) : base (
      text
     ) 
    {
      ReadonlyValue = readonlyValue;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEditPropertyItemCheck> Read = (ctx, reader) => 
    {
      var readonlyValue = reader.ReadBool();
      var text = reader.ReadString();
      return new RdEditPropertyItemCheck(readonlyValue, text);
    };
    
    public static new CtxWriteDelegate<RdEditPropertyItemCheck> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ReadonlyValue);
      writer.Write(value.Text);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertyItemCheck (");
      using (printer.IndentCookie()) {
        printer.Print("readonlyValue = "); ReadonlyValue.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertyItemCheckBox : RdEditPropertyItem
   {
    //fields
    public bool InitialValue {get; private set;}
    [NotNull] public IRdProperty<bool> Value { get { return _Value; }}
    [NotNull] private readonly RdProperty<bool> _Value;
    
    //primary constructor
    private RdEditPropertyItemCheckBox(
      bool initialValue,
      [NotNull] RdProperty<bool> value,
      [NotNull] string text
    ) : base (
      text
     ) 
    {
      InitialValue = initialValue;
      _Value = value;
      value.OptimizeNested = true;
    }
    //secondary constructor
    public RdEditPropertyItemCheckBox (
      bool InitialValue,
      [NotNull] string Text
    ) : this (
      InitialValue,
      new RdProperty<bool>(),
      Text
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdEditPropertyItemCheckBox> Read = (ctx, reader) => 
    {
      var initialValue = reader.ReadBool();
      var value = RdProperty<bool>.Read(ctx, reader);
      var text = reader.ReadString();
      return new RdEditPropertyItemCheckBox(initialValue, value, text);
    };
    
    public static new CtxWriteDelegate<RdEditPropertyItemCheckBox> Write = (ctx, writer, value) => 
    {
      writer.Write(value.InitialValue);
      RdProperty<bool>.Write(ctx, writer, value._Value);
      writer.Write(value.Text);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Value.BindEx(lifetime, this, "value");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Value.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertyItemCheckBox (");
      using (printer.IndentCookie()) {
        printer.Print("initialValue = "); InitialValue.PrintEx(printer); printer.Println();
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertyItemComboBox : RdEditPropertyItem
   {
    //fields
    [NotNull] public List<string> Values {get; private set;}
    [NotNull] public string InitialValue {get; private set;}
    [NotNull] public IRdProperty<string> Value { get { return _Value; }}
    [NotNull] private readonly RdProperty<string> _Value;
    
    //primary constructor
    private RdEditPropertyItemComboBox(
      [NotNull] List<string> values,
      [NotNull] string initialValue,
      [NotNull] RdProperty<string> value,
      [NotNull] string text
    ) : base (
      text
     ) 
    {
      Values = values;
      InitialValue = initialValue;
      _Value = value;
      value.OptimizeNested = true;
    }
    //secondary constructor
    public RdEditPropertyItemComboBox (
      [NotNull] List<string> Values,
      [NotNull] string InitialValue,
      [NotNull] string Text
    ) : this (
      Values,
      InitialValue,
      new RdProperty<string>(),
      Text
    ) {}
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static new CtxReadDelegate<RdEditPropertyItemComboBox> Read = (ctx, reader) => 
    {
      var values = ReadStringList(ctx, reader);
      var initialValue = reader.ReadString();
      var value = RdProperty<string>.Read(ctx, reader);
      var text = reader.ReadString();
      return new RdEditPropertyItemComboBox(values, initialValue, value, text);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static new CtxWriteDelegate<RdEditPropertyItemComboBox> Write = (ctx, writer, value) => 
    {
      WriteStringList(ctx, writer, value.Values);
      writer.Write(value.InitialValue);
      RdProperty<string>.Write(ctx, writer, value._Value);
      writer.Write(value.Text);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Value.BindEx(lifetime, this, "value");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Value.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertyItemComboBox (");
      using (printer.IndentCookie()) {
        printer.Print("values = "); Values.PrintEx(printer); printer.Println();
        printer.Print("initialValue = "); InitialValue.PrintEx(printer); printer.Println();
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertyItemText : RdEditPropertyItem
   {
    //fields
    [NotNull] public string ReadonlyValue {get; private set;}
    
    //primary constructor
    public RdEditPropertyItemText(
      [NotNull] string readonlyValue,
      [NotNull] string text
    ) : base (
      text
     ) 
    {
      ReadonlyValue = readonlyValue;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEditPropertyItemText> Read = (ctx, reader) => 
    {
      var readonlyValue = reader.ReadString();
      var text = reader.ReadString();
      return new RdEditPropertyItemText(readonlyValue, text);
    };
    
    public static new CtxWriteDelegate<RdEditPropertyItemText> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ReadonlyValue);
      writer.Write(value.Text);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertyItemText (");
      using (printer.IndentCookie()) {
        printer.Print("readonlyValue = "); ReadonlyValue.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertyItemTextBox : RdEditPropertyItem
   {
    //fields
    [NotNull] public string InitialValue {get; private set;}
    [NotNull] public IRdProperty<string> Value { get { return _Value; }}
    [NotNull] private readonly RdProperty<string> _Value;
    
    //primary constructor
    private RdEditPropertyItemTextBox(
      [NotNull] string initialValue,
      [NotNull] RdProperty<string> value,
      [NotNull] string text
    ) : base (
      text
     ) 
    {
      InitialValue = initialValue;
      _Value = value;
      value.OptimizeNested = true;
    }
    //secondary constructor
    public RdEditPropertyItemTextBox (
      [NotNull] string InitialValue,
      [NotNull] string Text
    ) : this (
      InitialValue,
      new RdProperty<string>(),
      Text
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdEditPropertyItemTextBox> Read = (ctx, reader) => 
    {
      var initialValue = reader.ReadString();
      var value = RdProperty<string>.Read(ctx, reader);
      var text = reader.ReadString();
      return new RdEditPropertyItemTextBox(initialValue, value, text);
    };
    
    public static new CtxWriteDelegate<RdEditPropertyItemTextBox> Write = (ctx, writer, value) => 
    {
      writer.Write(value.InitialValue);
      RdProperty<string>.Write(ctx, writer, value._Value);
      writer.Write(value.Text);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Value.BindEx(lifetime, this, "value");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Value.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertyItemTextBox (");
      using (printer.IndentCookie()) {
        printer.Print("initialValue = "); InitialValue.PrintEx(printer); printer.Println();
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditPropertySection : RdBindableBase {
    //fields
    [NotNull] public string Title {get; private set;}
    [NotNull] public List<RdEditPropertyItem> Items {get; private set;}
    
    //primary constructor
    public RdEditPropertySection(
      [NotNull] string title,
      [NotNull] List<RdEditPropertyItem> items
    )
    {
      Title = title;
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<RdEditPropertyItem>> ReadRdEditPropertyItemList = RdEditPropertyItem.Read.List();
    public static CtxReadDelegate<RdEditPropertySection> Read = (ctx, reader) => 
    {
      var title = reader.ReadString();
      var items = ReadRdEditPropertyItemList(ctx, reader);
      return new RdEditPropertySection(title, items);
    };
    
    public static CtxWriteDelegate<List<RdEditPropertyItem>> WriteRdEditPropertyItemList = RdEditPropertyItem.Write.List();
    public static CtxWriteDelegate<RdEditPropertySection> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Title);
      WriteRdEditPropertyItemList(ctx, writer, value.Items);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Items.BindEx(lifetime, this, "items");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Items.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditPropertySection (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEnsureWritableHandler : RdBindableBase {
    //fields
    [NotNull] public IRdCall<string, bool> IsWritable { get { return _IsWritable; }}
    [NotNull] private readonly RdCall<string, bool> _IsWritable;
    [NotNull] public IRdCall<MakeWritableRequest, MakeWritableResponse> MakeWritable { get { return _MakeWritable; }}
    [NotNull] private readonly RdCall<MakeWritableRequest, MakeWritableResponse> _MakeWritable;
    
    //primary constructor
    private RdEnsureWritableHandler(
      [NotNull] RdCall<string, bool> isWritable,
      [NotNull] RdCall<MakeWritableRequest, MakeWritableResponse> makeWritable
    )
    {
      _IsWritable = isWritable;
      _MakeWritable = makeWritable;
    }
    //secondary constructor
    public RdEnsureWritableHandler (
    ) : this (
      new RdCall<string, bool>(),
      new RdCall<MakeWritableRequest, MakeWritableResponse>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdEnsureWritableHandler> Read = (ctx, reader) => 
    {
      var isWritable = RdCall<string, bool>.Read(ctx, reader);
      var makeWritable = RdCall<MakeWritableRequest, MakeWritableResponse>.Read(ctx, reader);
      return new RdEnsureWritableHandler(isWritable, makeWritable);
    };
    
    public static CtxWriteDelegate<RdEnsureWritableHandler> Write = (ctx, writer, value) => 
    {
      RdCall<string, bool>.Write(ctx, writer, value._IsWritable);
      RdCall<MakeWritableRequest, MakeWritableResponse>.Write(ctx, writer, value._MakeWritable);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _IsWritable.BindEx(lifetime, this, "isWritable");
      _MakeWritable.BindEx(lifetime, this, "makeWritable");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _IsWritable.IdentifyEx(ids);
      _MakeWritable.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEnsureWritableHandler (");
      using (printer.IndentCookie()) {
        printer.Print("isWritable = "); _IsWritable.PrintEx(printer); printer.Println();
        printer.Print("makeWritable = "); _MakeWritable.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdFileSystemModel : RdBindableBase {
    //fields
    [NotNull] public IRdCall<string, RdOperationResult> CreateFile { get { return _CreateFile; }}
    [NotNull] private readonly RdCall<string, RdOperationResult> _CreateFile;
    [NotNull] public IRdCall<string, RdOperationResult> CreateDirectory { get { return _CreateDirectory; }}
    [NotNull] private readonly RdCall<string, RdOperationResult> _CreateDirectory;
    [NotNull] public IRdCall<string, RdOperationResult> Delete { get { return _Delete; }}
    [NotNull] private readonly RdCall<string, RdOperationResult> _Delete;
    [NotNull] public IRdCall<RdFromTo, RdOperationResult> Move { get { return _Move; }}
    [NotNull] private readonly RdCall<RdFromTo, RdOperationResult> _Move;
    [NotNull] public IRdCall<RdFromTo, RdOperationResult> Copy { get { return _Copy; }}
    [NotNull] private readonly RdCall<RdFromTo, RdOperationResult> _Copy;
    [NotNull] public IRdCall<RdRefreshRequest, RdVoid> RefreshPaths { get { return _RefreshPaths; }}
    [NotNull] private readonly RdCall<RdRefreshRequest, RdVoid> _RefreshPaths;
    [NotNull] public IRdCall<FilesToSave, bool> RefreshFiles { get { return _RefreshFiles; }}
    [NotNull] private readonly RdCall<FilesToSave, bool> _RefreshFiles;
    [NotNull] public ISink<RdDeltaBatch> Change { get { return _Change; }}
    [NotNull] private readonly RdSignal<RdDeltaBatch> _Change;
    [NotNull] public IViewableMap<string, string> ExternalRoots { get { return _ExternalRoots; }}
    [NotNull] private readonly RdMap<string, string> _ExternalRoots;
    
    //primary constructor
    private RdFileSystemModel(
      [NotNull] RdCall<string, RdOperationResult> createFile,
      [NotNull] RdCall<string, RdOperationResult> createDirectory,
      [NotNull] RdCall<string, RdOperationResult> delete,
      [NotNull] RdCall<RdFromTo, RdOperationResult> move,
      [NotNull] RdCall<RdFromTo, RdOperationResult> copy,
      [NotNull] RdCall<RdRefreshRequest, RdVoid> refreshPaths,
      [NotNull] RdCall<FilesToSave, bool> refreshFiles,
      [NotNull] RdSignal<RdDeltaBatch> change,
      [NotNull] RdMap<string, string> externalRoots
    )
    {
      _CreateFile = createFile;
      _CreateDirectory = createDirectory;
      _Delete = delete;
      _Move = move;
      _Copy = copy;
      _RefreshPaths = refreshPaths;
      _RefreshFiles = refreshFiles;
      _Change = change;
      _ExternalRoots = externalRoots;
      externalRoots.OptimizeNested = true;
    }
    //secondary constructor
    public RdFileSystemModel (
    ) : this (
      new RdCall<string, RdOperationResult>(),
      new RdCall<string, RdOperationResult>(),
      new RdCall<string, RdOperationResult>(),
      new RdCall<RdFromTo, RdOperationResult>(),
      new RdCall<RdFromTo, RdOperationResult>(),
      new RdCall<RdRefreshRequest, RdVoid>(),
      new RdCall<FilesToSave, bool>(),
      new RdSignal<RdDeltaBatch>(),
      new RdMap<string, string>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdFileSystemModel> Read = (ctx, reader) => 
    {
      var createFile = RdCall<string, RdOperationResult>.Read(ctx, reader);
      var createDirectory = RdCall<string, RdOperationResult>.Read(ctx, reader);
      var delete = RdCall<string, RdOperationResult>.Read(ctx, reader);
      var move = RdCall<RdFromTo, RdOperationResult>.Read(ctx, reader);
      var copy = RdCall<RdFromTo, RdOperationResult>.Read(ctx, reader);
      var refreshPaths = RdCall<RdRefreshRequest, RdVoid>.Read(ctx, reader);
      var refreshFiles = RdCall<FilesToSave, bool>.Read(ctx, reader);
      var change = RdSignal<RdDeltaBatch>.Read(ctx, reader);
      var externalRoots = RdMap<string, string>.Read(ctx, reader);
      return new RdFileSystemModel(createFile, createDirectory, delete, move, copy, refreshPaths, refreshFiles, change, externalRoots);
    };
    
    public static CtxWriteDelegate<RdFileSystemModel> Write = (ctx, writer, value) => 
    {
      RdCall<string, RdOperationResult>.Write(ctx, writer, value._CreateFile);
      RdCall<string, RdOperationResult>.Write(ctx, writer, value._CreateDirectory);
      RdCall<string, RdOperationResult>.Write(ctx, writer, value._Delete);
      RdCall<RdFromTo, RdOperationResult>.Write(ctx, writer, value._Move);
      RdCall<RdFromTo, RdOperationResult>.Write(ctx, writer, value._Copy);
      RdCall<RdRefreshRequest, RdVoid>.Write(ctx, writer, value._RefreshPaths);
      RdCall<FilesToSave, bool>.Write(ctx, writer, value._RefreshFiles);
      RdSignal<RdDeltaBatch>.Write(ctx, writer, value._Change);
      RdMap<string, string>.Write(ctx, writer, value._ExternalRoots);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _CreateFile.BindEx(lifetime, this, "createFile");
      _CreateDirectory.BindEx(lifetime, this, "createDirectory");
      _Delete.BindEx(lifetime, this, "delete");
      _Move.BindEx(lifetime, this, "move");
      _Copy.BindEx(lifetime, this, "copy");
      _RefreshPaths.BindEx(lifetime, this, "refreshPaths");
      _RefreshFiles.BindEx(lifetime, this, "refreshFiles");
      _Change.BindEx(lifetime, this, "change");
      _ExternalRoots.BindEx(lifetime, this, "externalRoots");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _CreateFile.IdentifyEx(ids);
      _CreateDirectory.IdentifyEx(ids);
      _Delete.IdentifyEx(ids);
      _Move.IdentifyEx(ids);
      _Copy.IdentifyEx(ids);
      _RefreshPaths.IdentifyEx(ids);
      _RefreshFiles.IdentifyEx(ids);
      _Change.IdentifyEx(ids);
      _ExternalRoots.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdFileSystemModel (");
      using (printer.IndentCookie()) {
        printer.Print("createFile = "); _CreateFile.PrintEx(printer); printer.Println();
        printer.Print("createDirectory = "); _CreateDirectory.PrintEx(printer); printer.Println();
        printer.Print("delete = "); _Delete.PrintEx(printer); printer.Println();
        printer.Print("move = "); _Move.PrintEx(printer); printer.Println();
        printer.Print("copy = "); _Copy.PrintEx(printer); printer.Println();
        printer.Print("refreshPaths = "); _RefreshPaths.PrintEx(printer); printer.Println();
        printer.Print("refreshFiles = "); _RefreshFiles.PrintEx(printer); printer.Println();
        printer.Print("change = "); _Change.PrintEx(printer); printer.Println();
        printer.Print("externalRoots = "); _ExternalRoots.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdFileTemplate : IPrintable, IEquatable<RdFileTemplate> {
    //fields
    public int Id {get; private set;}
    [NotNull] public string Name {get; private set;}
    [NotNull] public string Description {get; private set;}
    [NotNull] public string Group {get; private set;}
    [NotNull] public string DefaultFileName {get; private set;}
    [NotNull] public string DefaultFileExtension {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //primary constructor
    public RdFileTemplate(
      int id,
      [NotNull] string name,
      [NotNull] string description,
      [NotNull] string group,
      [NotNull] string defaultFileName,
      [NotNull] string defaultFileExtension,
      [NotNull] JetBrains.Rider.Model.Icon icon
    )
    {
      Id = id;
      Name = name;
      Description = description;
      Group = group;
      DefaultFileName = defaultFileName;
      DefaultFileExtension = defaultFileExtension;
      Icon = icon;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdFileTemplate> Read = (ctx, reader) => 
    {
      var id = reader.ReadInt();
      var name = reader.ReadString();
      var description = reader.ReadString();
      var group = reader.ReadString();
      var defaultFileName = reader.ReadString();
      var defaultFileExtension = reader.ReadString();
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      return new RdFileTemplate(id, name, description, group, defaultFileName, defaultFileExtension, icon);
    };
    
    public static CtxWriteDelegate<RdFileTemplate> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.Name);
      writer.Write(value.Description);
      writer.Write(value.Group);
      writer.Write(value.DefaultFileName);
      writer.Write(value.DefaultFileExtension);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdFileTemplate) obj);
    }
    public bool Equals(RdFileTemplate other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Name == other.Name && Description == other.Description && Group == other.Group && DefaultFileName == other.DefaultFileName && DefaultFileExtension == other.DefaultFileExtension && Equals(Icon, other.Icon);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Id.GetHashCode();
        __r = __r*31 + Name.GetHashCode();
        __r = __r*31 + Description.GetHashCode();
        __r = __r*31 + Group.GetHashCode();
        __r = __r*31 + DefaultFileName.GetHashCode();
        __r = __r*31 + DefaultFileExtension.GetHashCode();
        __r = __r*31 + Icon.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdFileTemplate (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("group = "); Group.PrintEx(printer); printer.Println();
        printer.Print("defaultFileName = "); DefaultFileName.PrintEx(printer); printer.Println();
        printer.Print("defaultFileExtension = "); DefaultFileExtension.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdFileTemplateModel : RdBindableBase {
    //fields
    [NotNull] public IViewableMap<int, RdFileTemplate> ItemTemplates { get { return _ItemTemplates; }}
    [NotNull] private readonly RdMap<int, RdFileTemplate> _ItemTemplates;
    [NotNull] public RdEndpoint<RdGetTemplatesCommand, RdGeTemplatesResult> GetTemplates { get { return _GetTemplates; }}
    [NotNull] private readonly RdEndpoint<RdGetTemplatesCommand, RdGeTemplatesResult> _GetTemplates;
    [NotNull] public RdEndpoint<RdCreateFromTemplateCommand, ProjectModelTaskResult> CreateFromTemplate { get { return _CreateFromTemplate; }}
    [NotNull] private readonly RdEndpoint<RdCreateFromTemplateCommand, ProjectModelTaskResult> _CreateFromTemplate;
    
    //primary constructor
    private RdFileTemplateModel(
      [NotNull] RdMap<int, RdFileTemplate> itemTemplates,
      [NotNull] RdEndpoint<RdGetTemplatesCommand, RdGeTemplatesResult> getTemplates,
      [NotNull] RdEndpoint<RdCreateFromTemplateCommand, ProjectModelTaskResult> createFromTemplate
    )
    {
      _ItemTemplates = itemTemplates;
      _GetTemplates = getTemplates;
      _CreateFromTemplate = createFromTemplate;
      itemTemplates.OptimizeNested = true;
    }
    //secondary constructor
    public RdFileTemplateModel (
    ) : this (
      new RdMap<int, RdFileTemplate>(),
      new RdEndpoint<RdGetTemplatesCommand, RdGeTemplatesResult>(),
      new RdEndpoint<RdCreateFromTemplateCommand, ProjectModelTaskResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdFileTemplateModel> Read = (ctx, reader) => 
    {
      var itemTemplates = RdMap<int, RdFileTemplate>.Read(ctx, reader);
      var getTemplates = RdEndpoint<RdGetTemplatesCommand, RdGeTemplatesResult>.Read(ctx, reader);
      var createFromTemplate = RdEndpoint<RdCreateFromTemplateCommand, ProjectModelTaskResult>.Read(ctx, reader);
      return new RdFileTemplateModel(itemTemplates, getTemplates, createFromTemplate);
    };
    
    public static CtxWriteDelegate<RdFileTemplateModel> Write = (ctx, writer, value) => 
    {
      RdMap<int, RdFileTemplate>.Write(ctx, writer, value._ItemTemplates);
      RdEndpoint<RdGetTemplatesCommand, RdGeTemplatesResult>.Write(ctx, writer, value._GetTemplates);
      RdEndpoint<RdCreateFromTemplateCommand, ProjectModelTaskResult>.Write(ctx, writer, value._CreateFromTemplate);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _ItemTemplates.BindEx(lifetime, this, "itemTemplates");
      _GetTemplates.BindEx(lifetime, this, "getTemplates");
      _CreateFromTemplate.BindEx(lifetime, this, "createFromTemplate");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ItemTemplates.IdentifyEx(ids);
      _GetTemplates.IdentifyEx(ids);
      _CreateFromTemplate.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdFileTemplateModel (");
      using (printer.IndentCookie()) {
        printer.Print("itemTemplates = "); _ItemTemplates.PrintEx(printer); printer.Println();
        printer.Print("getTemplates = "); _GetTemplates.PrintEx(printer); printer.Println();
        printer.Print("createFromTemplate = "); _CreateFromTemplate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdFindUsagesHost : RdBindableBase {
    //fields
    [NotNull] public ISource<RdHighlights> Highlights { get { return _Highlights; }}
    [NotNull] private readonly RdSignal<RdHighlights> _Highlights;
    [NotNull] public IViewableMap<int, RdFindUsagesSession> Sessions { get { return _Sessions; }}
    [NotNull] private readonly RdMap<int, RdFindUsagesSession> _Sessions;
    [NotNull] public IRdProperty<RdUsageGroupingRuleList> GroupingRules { get { return _GroupingRules; }}
    [NotNull] private readonly RdProperty<RdUsageGroupingRuleList> _GroupingRules;
    
    //primary constructor
    private RdFindUsagesHost(
      [NotNull] RdSignal<RdHighlights> highlights,
      [NotNull] RdMap<int, RdFindUsagesSession> sessions,
      [NotNull] RdProperty<RdUsageGroupingRuleList> groupingRules
    )
    {
      _Highlights = highlights;
      _Sessions = sessions;
      _GroupingRules = groupingRules;
    }
    //secondary constructor
    public RdFindUsagesHost (
    ) : this (
      new RdSignal<RdHighlights>(),
      new RdMap<int, RdFindUsagesSession>(),
      new RdProperty<RdUsageGroupingRuleList>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdFindUsagesHost> Read = (ctx, reader) => 
    {
      var highlights = RdSignal<RdHighlights>.Read(ctx, reader);
      var sessions = RdMap<int, RdFindUsagesSession>.Read(ctx, reader);
      var groupingRules = RdProperty<RdUsageGroupingRuleList>.Read(ctx, reader);
      return new RdFindUsagesHost(highlights, sessions, groupingRules);
    };
    
    public static CtxWriteDelegate<RdFindUsagesHost> Write = (ctx, writer, value) => 
    {
      RdSignal<RdHighlights>.Write(ctx, writer, value._Highlights);
      RdMap<int, RdFindUsagesSession>.Write(ctx, writer, value._Sessions);
      RdProperty<RdUsageGroupingRuleList>.Write(ctx, writer, value._GroupingRules);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Highlights.BindEx(lifetime, this, "highlights");
      _Sessions.BindEx(lifetime, this, "sessions");
      _GroupingRules.BindEx(lifetime, this, "groupingRules");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Highlights.IdentifyEx(ids);
      _Sessions.IdentifyEx(ids);
      _GroupingRules.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdFindUsagesHost (");
      using (printer.IndentCookie()) {
        printer.Print("highlights = "); _Highlights.PrintEx(printer); printer.Println();
        printer.Print("sessions = "); _Sessions.PrintEx(printer); printer.Println();
        printer.Print("groupingRules = "); _GroupingRules.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdFindUsagesSession : RdBindableBase {
    //fields
    [NotNull] public string Title {get; private set;}
    [NotNull] public RdUsageList Usages {get; private set;}
    [NotNull] public RdUsageTargetList Targets {get; private set;}
    
    //primary constructor
    public RdFindUsagesSession(
      [NotNull] string title,
      [NotNull] RdUsageList usages,
      [NotNull] RdUsageTargetList targets
    )
    {
      Title = title;
      Usages = usages;
      Targets = targets;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdFindUsagesSession> Read = (ctx, reader) => 
    {
      var title = reader.ReadString();
      var usages = RdUsageList.Read(ctx, reader);
      var targets = RdUsageTargetList.Read(ctx, reader);
      return new RdFindUsagesSession(title, usages, targets);
    };
    
    public static CtxWriteDelegate<RdFindUsagesSession> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Title);
      RdUsageList.Write(ctx, writer, value.Usages);
      RdUsageTargetList.Write(ctx, writer, value.Targets);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Usages.BindEx(lifetime, this, "usages");
      Targets.BindEx(lifetime, this, "targets");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Usages.IdentifyEx(ids);
      Targets.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdFindUsagesSession (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("usages = "); Usages.PrintEx(printer); printer.Println();
        printer.Print("targets = "); Targets.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdFrameworkFolderDescriptor : RdProjectModelItemDescriptor
   {
    //fields
    //primary constructor
    public RdFrameworkFolderDescriptor(
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdFrameworkFolderDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      return new RdFrameworkFolderDescriptor(name, location);
    };
    
    public static new CtxWriteDelegate<RdFrameworkFolderDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdFrameworkFolderDescriptor) obj);
    }
    public bool Equals(RdFrameworkFolderDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Name.GetHashCode();
        __r = __r*31 + Location.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdFrameworkFolderDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdFromTo : IPrintable, IEquatable<RdFromTo> {
    //fields
    [NotNull] public string From {get; private set;}
    [NotNull] public string To {get; private set;}
    public bool Overwrite {get; private set;}
    
    //primary constructor
    public RdFromTo(
      [NotNull] string from,
      [NotNull] string to,
      bool overwrite
    )
    {
      From = from;
      To = to;
      Overwrite = overwrite;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdFromTo> Read = (ctx, reader) => 
    {
      var from = reader.ReadString();
      var to = reader.ReadString();
      var overwrite = reader.ReadBool();
      return new RdFromTo(from, to, overwrite);
    };
    
    public static CtxWriteDelegate<RdFromTo> Write = (ctx, writer, value) => 
    {
      writer.Write(value.From);
      writer.Write(value.To);
      writer.Write(value.Overwrite);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdFromTo) obj);
    }
    public bool Equals(RdFromTo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return From == other.From && To == other.To && Overwrite == other.Overwrite;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + From.GetHashCode();
        __r = __r*31 + To.GetHashCode();
        __r = __r*31 + Overwrite.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdFromTo (");
      using (printer.IndentCookie()) {
        printer.Print("from = "); From.PrintEx(printer); printer.Println();
        printer.Print("to = "); To.PrintEx(printer); printer.Println();
        printer.Print("overwrite = "); Overwrite.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdGeTemplatesResult : IPrintable, IEquatable<RdGeTemplatesResult> {
    //fields
    [NotNull] public List<int> TemplateIds {get; private set;}
    
    //primary constructor
    public RdGeTemplatesResult(
      [NotNull] List<int> templateIds
    )
    {
      TemplateIds = templateIds;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static CtxReadDelegate<RdGeTemplatesResult> Read = (ctx, reader) => 
    {
      var templateIds = ReadIntList(ctx, reader);
      return new RdGeTemplatesResult(templateIds);
    };
    
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static CtxWriteDelegate<RdGeTemplatesResult> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.TemplateIds);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdGeTemplatesResult) obj);
    }
    public bool Equals(RdGeTemplatesResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return TemplateIds.SequenceEqual(other.TemplateIds);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(TemplateIds);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdGeTemplatesResult (");
      using (printer.IndentCookie()) {
        printer.Print("templateIds = "); TemplateIds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdGetTemplatesCommand : IPrintable, IEquatable<RdGetTemplatesCommand> {
    //fields
    public int ItemId {get; private set;}
    
    //primary constructor
    public RdGetTemplatesCommand(
      int itemId
    )
    {
      ItemId = itemId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdGetTemplatesCommand> Read = (ctx, reader) => 
    {
      var itemId = reader.ReadInt();
      return new RdGetTemplatesCommand(itemId);
    };
    
    public static CtxWriteDelegate<RdGetTemplatesCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemId);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdGetTemplatesCommand) obj);
    }
    public bool Equals(RdGetTemplatesCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemId == other.ItemId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + ItemId.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdGetTemplatesCommand (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdGutterExecutionRequest : IPrintable, IEquatable<RdGutterExecutionRequest> {
    //fields
    public int GutterId {get; private set;}
    public int Start {get; private set;}
    public int End {get; private set;}
    
    //primary constructor
    public RdGutterExecutionRequest(
      int gutterId,
      int start,
      int end
    )
    {
      GutterId = gutterId;
      Start = start;
      End = end;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdGutterExecutionRequest> Read = (ctx, reader) => 
    {
      var gutterId = reader.ReadInt();
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      return new RdGutterExecutionRequest(gutterId, start, end);
    };
    
    public static CtxWriteDelegate<RdGutterExecutionRequest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.GutterId);
      writer.Write(value.Start);
      writer.Write(value.End);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdGutterExecutionRequest) obj);
    }
    public bool Equals(RdGutterExecutionRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return GutterId == other.GutterId && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + GutterId.GetHashCode();
        __r = __r*31 + Start.GetHashCode();
        __r = __r*31 + End.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdGutterExecutionRequest (");
      using (printer.IndentCookie()) {
        printer.Print("gutterId = "); GutterId.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdHighlights : IPrintable, IEquatable<RdHighlights> {
    //fields
    [NotNull] public JetBrains.Rider.Model.TextControlId TextControlId {get; private set;}
    [NotNull] public List<RdLightUsage> Occurrences {get; private set;}
    
    //primary constructor
    public RdHighlights(
      [NotNull] JetBrains.Rider.Model.TextControlId textControlId,
      [NotNull] List<RdLightUsage> occurrences
    )
    {
      TextControlId = textControlId;
      Occurrences = occurrences;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<RdLightUsage>> ReadRdLightUsageList = RdLightUsage.Read.List();
    public static CtxReadDelegate<RdHighlights> Read = (ctx, reader) => 
    {
      var textControlId = JetBrains.Rider.Model.TextControlId.Read(ctx, reader);
      var occurrences = ReadRdLightUsageList(ctx, reader);
      return new RdHighlights(textControlId, occurrences);
    };
    
    public static CtxWriteDelegate<List<RdLightUsage>> WriteRdLightUsageList = RdLightUsage.Write.List();
    public static CtxWriteDelegate<RdHighlights> Write = (ctx, writer, value) => 
    {
      JetBrains.Rider.Model.TextControlId.Write(ctx, writer, value.TextControlId);
      WriteRdLightUsageList(ctx, writer, value.Occurrences);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdHighlights) obj);
    }
    public bool Equals(RdHighlights other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(TextControlId, other.TextControlId) && Occurrences.SequenceEqual(other.Occurrences);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + TextControlId.GetHashCode();
        __r = __r*31 + CollectionUtil.GetHashCode(Occurrences);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdHighlights (");
      using (printer.IndentCookie()) {
        printer.Print("textControlId = "); TextControlId.PrintEx(printer); printer.Println();
        printer.Print("occurrences = "); Occurrences.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdLightUsage : IPrintable, IEquatable<RdLightUsage> {
    //fields
    public int Start {get; private set;}
    public int End {get; private set;}
    public RdUsageKind Kind {get; private set;}
    
    //primary constructor
    public RdLightUsage(
      int start,
      int end,
      RdUsageKind kind
    )
    {
      Start = start;
      End = end;
      Kind = kind;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdLightUsage> Read = (ctx, reader) => 
    {
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      var kind = (RdUsageKind)reader.ReadInt();
      return new RdLightUsage(start, end, kind);
    };
    
    public static CtxWriteDelegate<RdLightUsage> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Start);
      writer.Write(value.End);
      writer.Write((int)value.Kind);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdLightUsage) obj);
    }
    public bool Equals(RdLightUsage other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Start == other.Start && End == other.End && Kind == other.Kind;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Start.GetHashCode();
        __r = __r*31 + End.GetHashCode();
        __r = __r*31 + (int) Kind;
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdLightUsage (");
      using (printer.IndentCookie()) {
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdLiveTemplateHost : RdBindableBase {
    //fields
    [NotNull] public ISource<RdLiveTemplateInitialData> ExecuteTemplate { get { return _ExecuteTemplate; }}
    [NotNull] private readonly RdSignal<RdLiveTemplateInitialData> _ExecuteTemplate;
    [NotNull] public RdEndpoint<RdLiveTemplateSnapshot, RdLiveTemplateLookup> RequestLookupItems { get { return _RequestLookupItems; }}
    [NotNull] private readonly RdEndpoint<RdLiveTemplateSnapshot, RdLiveTemplateLookup> _RequestLookupItems;
    
    //primary constructor
    private RdLiveTemplateHost(
      [NotNull] RdSignal<RdLiveTemplateInitialData> executeTemplate,
      [NotNull] RdEndpoint<RdLiveTemplateSnapshot, RdLiveTemplateLookup> requestLookupItems
    )
    {
      _ExecuteTemplate = executeTemplate;
      _RequestLookupItems = requestLookupItems;
    }
    //secondary constructor
    public RdLiveTemplateHost (
    ) : this (
      new RdSignal<RdLiveTemplateInitialData>(),
      new RdEndpoint<RdLiveTemplateSnapshot, RdLiveTemplateLookup>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdLiveTemplateHost> Read = (ctx, reader) => 
    {
      var executeTemplate = RdSignal<RdLiveTemplateInitialData>.Read(ctx, reader);
      var requestLookupItems = RdEndpoint<RdLiveTemplateSnapshot, RdLiveTemplateLookup>.Read(ctx, reader);
      return new RdLiveTemplateHost(executeTemplate, requestLookupItems);
    };
    
    public static CtxWriteDelegate<RdLiveTemplateHost> Write = (ctx, writer, value) => 
    {
      RdSignal<RdLiveTemplateInitialData>.Write(ctx, writer, value._ExecuteTemplate);
      RdEndpoint<RdLiveTemplateSnapshot, RdLiveTemplateLookup>.Write(ctx, writer, value._RequestLookupItems);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _ExecuteTemplate.BindEx(lifetime, this, "executeTemplate");
      _RequestLookupItems.BindEx(lifetime, this, "requestLookupItems");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ExecuteTemplate.IdentifyEx(ids);
      _RequestLookupItems.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdLiveTemplateHost (");
      using (printer.IndentCookie()) {
        printer.Print("executeTemplate = "); _ExecuteTemplate.PrintEx(printer); printer.Println();
        printer.Print("requestLookupItems = "); _RequestLookupItems.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdLiveTemplateInitialData : IPrintable, IEquatable<RdLiveTemplateInitialData> {
    //fields
    [NotNull] public TextControlId TextControl {get; private set;}
    [NotNull] public List<RdLiveTemplateVariable> Variables {get; private set;}
    
    //primary constructor
    public RdLiveTemplateInitialData(
      [NotNull] TextControlId textControl,
      [NotNull] List<RdLiveTemplateVariable> variables
    )
    {
      TextControl = textControl;
      Variables = variables;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<RdLiveTemplateVariable>> ReadRdLiveTemplateVariableList = RdLiveTemplateVariable.Read.List();
    public static CtxReadDelegate<RdLiveTemplateInitialData> Read = (ctx, reader) => 
    {
      var textControl = TextControlId.Read(ctx, reader);
      var variables = ReadRdLiveTemplateVariableList(ctx, reader);
      return new RdLiveTemplateInitialData(textControl, variables);
    };
    
    public static CtxWriteDelegate<List<RdLiveTemplateVariable>> WriteRdLiveTemplateVariableList = RdLiveTemplateVariable.Write.List();
    public static CtxWriteDelegate<RdLiveTemplateInitialData> Write = (ctx, writer, value) => 
    {
      TextControlId.Write(ctx, writer, value.TextControl);
      WriteRdLiveTemplateVariableList(ctx, writer, value.Variables);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdLiveTemplateInitialData) obj);
    }
    public bool Equals(RdLiveTemplateInitialData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(TextControl, other.TextControl) && Variables.SequenceEqual(other.Variables);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + TextControl.GetHashCode();
        __r = __r*31 + CollectionUtil.GetHashCode(Variables);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdLiveTemplateInitialData (");
      using (printer.IndentCookie()) {
        printer.Print("textControl = "); TextControl.PrintEx(printer); printer.Println();
        printer.Print("variables = "); Variables.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdLiveTemplateLookup : IPrintable, IEquatable<RdLiveTemplateLookup> {
    //fields
    [NotNull] public List<RdLiveTemplateLookupItem> Items {get; private set;}
    
    //primary constructor
    public RdLiveTemplateLookup(
      [NotNull] List<RdLiveTemplateLookupItem> items
    )
    {
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<RdLiveTemplateLookupItem>> ReadRdLiveTemplateLookupItemList = RdLiveTemplateLookupItem.Read.List();
    public static CtxReadDelegate<RdLiveTemplateLookup> Read = (ctx, reader) => 
    {
      var items = ReadRdLiveTemplateLookupItemList(ctx, reader);
      return new RdLiveTemplateLookup(items);
    };
    
    public static CtxWriteDelegate<List<RdLiveTemplateLookupItem>> WriteRdLiveTemplateLookupItemList = RdLiveTemplateLookupItem.Write.List();
    public static CtxWriteDelegate<RdLiveTemplateLookup> Write = (ctx, writer, value) => 
    {
      WriteRdLiveTemplateLookupItemList(ctx, writer, value.Items);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdLiveTemplateLookup) obj);
    }
    public bool Equals(RdLiveTemplateLookup other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Items.SequenceEqual(other.Items);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(Items);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdLiveTemplateLookup (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdLiveTemplateLookupItem : IPrintable, IEquatable<RdLiveTemplateLookupItem> {
    //fields
    [NotNull] public string DisplayName {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //primary constructor
    public RdLiveTemplateLookupItem(
      [NotNull] string displayName,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    )
    {
      DisplayName = displayName;
      Icon = icon;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<RdLiveTemplateLookupItem> Read = (ctx, reader) => 
    {
      var displayName = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      return new RdLiveTemplateLookupItem(displayName, icon);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<RdLiveTemplateLookupItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.DisplayName);
      WriteIconNullable(ctx, writer, value.Icon);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdLiveTemplateLookupItem) obj);
    }
    public bool Equals(RdLiveTemplateLookupItem other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return DisplayName == other.DisplayName && Equals(Icon, other.Icon);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + DisplayName.GetHashCode();
        __r = __r*31 + (Icon != null ?Icon.GetHashCode() : 0);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdLiveTemplateLookupItem (");
      using (printer.IndentCookie()) {
        printer.Print("displayName = "); DisplayName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdLiveTemplateMacro : IPrintable, IEquatable<RdLiveTemplateMacro> {
    //fields
    [NotNull] public string Name {get; private set;}
    [NotNull] public List<RdLiveTemplateMacroArg> Args {get; private set;}
    
    //primary constructor
    public RdLiveTemplateMacro(
      [NotNull] string name,
      [NotNull] List<RdLiveTemplateMacroArg> args
    )
    {
      Name = name;
      Args = args;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<RdLiveTemplateMacroArg>> ReadRdLiveTemplateMacroArgList = RdLiveTemplateMacroArg.Read.List();
    public static CtxReadDelegate<RdLiveTemplateMacro> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var args = ReadRdLiveTemplateMacroArgList(ctx, reader);
      return new RdLiveTemplateMacro(name, args);
    };
    
    public static CtxWriteDelegate<List<RdLiveTemplateMacroArg>> WriteRdLiveTemplateMacroArgList = RdLiveTemplateMacroArg.Write.List();
    public static CtxWriteDelegate<RdLiveTemplateMacro> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      WriteRdLiveTemplateMacroArgList(ctx, writer, value.Args);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdLiveTemplateMacro) obj);
    }
    public bool Equals(RdLiveTemplateMacro other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Args.SequenceEqual(other.Args);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Name.GetHashCode();
        __r = __r*31 + CollectionUtil.GetHashCode(Args);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdLiveTemplateMacro (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("args = "); Args.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdLiveTemplateMacroArg : IPrintable, IEquatable<RdLiveTemplateMacroArg> {
    //fields
    [NotNull] public string Type {get; private set;}
    [NotNull] public string Value {get; private set;}
    
    //primary constructor
    public RdLiveTemplateMacroArg(
      [NotNull] string type,
      [NotNull] string value
    )
    {
      Type = type;
      Value = value;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdLiveTemplateMacroArg> Read = (ctx, reader) => 
    {
      var type = reader.ReadString();
      var value = reader.ReadString();
      return new RdLiveTemplateMacroArg(type, value);
    };
    
    public static CtxWriteDelegate<RdLiveTemplateMacroArg> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Type);
      writer.Write(value.Value);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdLiveTemplateMacroArg) obj);
    }
    public bool Equals(RdLiveTemplateMacroArg other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Type == other.Type && Value == other.Value;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Type.GetHashCode();
        __r = __r*31 + Value.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdLiveTemplateMacroArg (");
      using (printer.IndentCookie()) {
        printer.Print("type = "); Type.PrintEx(printer); printer.Println();
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdLiveTemplateSnapshot : IPrintable, IEquatable<RdLiveTemplateSnapshot> {
    //fields
    public int CaretOffset {get; private set;}
    [NotNull] public List<RdLiveTemplateVariable> Variables {get; private set;}
    public int CurrentVariable {get; private set;}
    
    //primary constructor
    public RdLiveTemplateSnapshot(
      int caretOffset,
      [NotNull] List<RdLiveTemplateVariable> variables,
      int currentVariable
    )
    {
      CaretOffset = caretOffset;
      Variables = variables;
      CurrentVariable = currentVariable;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<RdLiveTemplateVariable>> ReadRdLiveTemplateVariableList = RdLiveTemplateVariable.Read.List();
    public static CtxReadDelegate<RdLiveTemplateSnapshot> Read = (ctx, reader) => 
    {
      var caretOffset = reader.ReadInt();
      var variables = ReadRdLiveTemplateVariableList(ctx, reader);
      var currentVariable = reader.ReadInt();
      return new RdLiveTemplateSnapshot(caretOffset, variables, currentVariable);
    };
    
    public static CtxWriteDelegate<List<RdLiveTemplateVariable>> WriteRdLiveTemplateVariableList = RdLiveTemplateVariable.Write.List();
    public static CtxWriteDelegate<RdLiveTemplateSnapshot> Write = (ctx, writer, value) => 
    {
      writer.Write(value.CaretOffset);
      WriteRdLiveTemplateVariableList(ctx, writer, value.Variables);
      writer.Write(value.CurrentVariable);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdLiveTemplateSnapshot) obj);
    }
    public bool Equals(RdLiveTemplateSnapshot other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return CaretOffset == other.CaretOffset && Variables.SequenceEqual(other.Variables) && CurrentVariable == other.CurrentVariable;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CaretOffset.GetHashCode();
        __r = __r*31 + CollectionUtil.GetHashCode(Variables);
        __r = __r*31 + CurrentVariable.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdLiveTemplateSnapshot (");
      using (printer.IndentCookie()) {
        printer.Print("caretOffset = "); CaretOffset.PrintEx(printer); printer.Println();
        printer.Print("variables = "); Variables.PrintEx(printer); printer.Println();
        printer.Print("currentVariable = "); CurrentVariable.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdLiveTemplateVariable : IPrintable, IEquatable<RdLiveTemplateVariable> {
    //fields
    [NotNull] public string Name {get; private set;}
    [NotNull] public string CurrentValue {get; private set;}
    public bool IsStopAt {get; private set;}
    [NotNull] public List<RdLiveTemplateVariableRange> Ranges {get; private set;}
    [NotNull] public RdLiveTemplateMacro Macro {get; private set;}
    
    //primary constructor
    public RdLiveTemplateVariable(
      [NotNull] string name,
      [NotNull] string currentValue,
      bool isStopAt,
      [NotNull] List<RdLiveTemplateVariableRange> ranges,
      [NotNull] RdLiveTemplateMacro macro
    )
    {
      Name = name;
      CurrentValue = currentValue;
      IsStopAt = isStopAt;
      Ranges = ranges;
      Macro = macro;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<RdLiveTemplateVariableRange>> ReadRdLiveTemplateVariableRangeList = RdLiveTemplateVariableRange.Read.List();
    public static CtxReadDelegate<RdLiveTemplateVariable> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var currentValue = reader.ReadString();
      var isStopAt = reader.ReadBool();
      var ranges = ReadRdLiveTemplateVariableRangeList(ctx, reader);
      var macro = RdLiveTemplateMacro.Read(ctx, reader);
      return new RdLiveTemplateVariable(name, currentValue, isStopAt, ranges, macro);
    };
    
    public static CtxWriteDelegate<List<RdLiveTemplateVariableRange>> WriteRdLiveTemplateVariableRangeList = RdLiveTemplateVariableRange.Write.List();
    public static CtxWriteDelegate<RdLiveTemplateVariable> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      writer.Write(value.CurrentValue);
      writer.Write(value.IsStopAt);
      WriteRdLiveTemplateVariableRangeList(ctx, writer, value.Ranges);
      RdLiveTemplateMacro.Write(ctx, writer, value.Macro);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdLiveTemplateVariable) obj);
    }
    public bool Equals(RdLiveTemplateVariable other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && CurrentValue == other.CurrentValue && IsStopAt == other.IsStopAt && Ranges.SequenceEqual(other.Ranges) && Equals(Macro, other.Macro);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Name.GetHashCode();
        __r = __r*31 + CurrentValue.GetHashCode();
        __r = __r*31 + IsStopAt.GetHashCode();
        __r = __r*31 + CollectionUtil.GetHashCode(Ranges);
        __r = __r*31 + Macro.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdLiveTemplateVariable (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("currentValue = "); CurrentValue.PrintEx(printer); printer.Println();
        printer.Print("isStopAt = "); IsStopAt.PrintEx(printer); printer.Println();
        printer.Print("ranges = "); Ranges.PrintEx(printer); printer.Println();
        printer.Print("macro = "); Macro.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdLiveTemplateVariableRange : IPrintable, IEquatable<RdLiveTemplateVariableRange> {
    //fields
    public int StartOffset {get; private set;}
    public int EndOffset {get; private set;}
    
    //primary constructor
    public RdLiveTemplateVariableRange(
      int startOffset,
      int endOffset
    )
    {
      StartOffset = startOffset;
      EndOffset = endOffset;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdLiveTemplateVariableRange> Read = (ctx, reader) => 
    {
      var startOffset = reader.ReadInt();
      var endOffset = reader.ReadInt();
      return new RdLiveTemplateVariableRange(startOffset, endOffset);
    };
    
    public static CtxWriteDelegate<RdLiveTemplateVariableRange> Write = (ctx, writer, value) => 
    {
      writer.Write(value.StartOffset);
      writer.Write(value.EndOffset);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdLiveTemplateVariableRange) obj);
    }
    public bool Equals(RdLiveTemplateVariableRange other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return StartOffset == other.StartOffset && EndOffset == other.EndOffset;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + StartOffset.GetHashCode();
        __r = __r*31 + EndOffset.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdLiveTemplateVariableRange (");
      using (printer.IndentCookie()) {
        printer.Print("startOffset = "); StartOffset.PrintEx(printer); printer.Println();
        printer.Print("endOffset = "); EndOffset.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdMakeWritableResultKind {
    SUCCESS,
    FAILURE
  }
  
  
  public class RdMarkupModel : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<bool> IsInitialized { get { return _IsInitialized; }}
    [NotNull] private readonly RdProperty<bool> _IsInitialized;
    [NotNull] public ISource<HighlighterList> HighlightersAdded { get { return _HighlightersAdded; }}
    [NotNull] private readonly RdSignal<HighlighterList> _HighlightersAdded;
    [NotNull] public ISource<HighlighterIdList> HighlightersRemoved { get { return _HighlightersRemoved; }}
    [NotNull] private readonly RdSignal<HighlighterIdList> _HighlightersRemoved;
    [NotNull] public IRdProperty<DaemonStateEnum> DaemonState { get { return _DaemonState; }}
    [NotNull] private readonly RdProperty<DaemonStateEnum> _DaemonState;
    [NotNull] public TooltipProviderModel TooltipProvider {get; private set;}
    [NotNull] public JetBrains.Rider.Model.GutterMarkActionActivator GutterMarkActionActivator {get; private set;}
    public bool IsDebugMode {get; private set;}
    [NotNull] public RdEndpoint<int, HighlighterList> DumpAllHighlighters { get { return _DumpAllHighlighters; }}
    [NotNull] private readonly RdEndpoint<int, HighlighterList> _DumpAllHighlighters;
    [NotNull] public RdEndpoint<int, MarkupDumpInfo> DumpMarkupInfo { get { return _DumpMarkupInfo; }}
    [NotNull] private readonly RdEndpoint<int, MarkupDumpInfo> _DumpMarkupInfo;
    
    //primary constructor
    private RdMarkupModel(
      [NotNull] RdProperty<bool> isInitialized,
      [NotNull] RdSignal<HighlighterList> highlightersAdded,
      [NotNull] RdSignal<HighlighterIdList> highlightersRemoved,
      [NotNull] RdProperty<DaemonStateEnum> daemonState,
      [NotNull] TooltipProviderModel tooltipProvider,
      [NotNull] JetBrains.Rider.Model.GutterMarkActionActivator gutterMarkActionActivator,
      bool isDebugMode,
      [NotNull] RdEndpoint<int, HighlighterList> dumpAllHighlighters,
      [NotNull] RdEndpoint<int, MarkupDumpInfo> dumpMarkupInfo
    )
    {
      _IsInitialized = isInitialized;
      _HighlightersAdded = highlightersAdded;
      _HighlightersRemoved = highlightersRemoved;
      _DaemonState = daemonState;
      TooltipProvider = tooltipProvider;
      GutterMarkActionActivator = gutterMarkActionActivator;
      IsDebugMode = isDebugMode;
      _DumpAllHighlighters = dumpAllHighlighters;
      _DumpMarkupInfo = dumpMarkupInfo;
      isInitialized.OptimizeNested = true;
      daemonState.OptimizeNested = true;
    }
    //secondary constructor
    public RdMarkupModel (
      bool IsDebugMode
    ) : this (
      new RdProperty<bool>(),
      new RdSignal<HighlighterList>(),
      new RdSignal<HighlighterIdList>(),
      new RdProperty<DaemonStateEnum>(),
      new TooltipProviderModel(),
      new JetBrains.Rider.Model.GutterMarkActionActivator(),
      IsDebugMode,
      new RdEndpoint<int, HighlighterList>(),
      new RdEndpoint<int, MarkupDumpInfo>()
    ) {}
    //statics
    
    public static CtxReadDelegate<DaemonStateEnum> ReadDaemonStateEnum = new CtxReadDelegate<DaemonStateEnum>(Serializers.ReadEnum<DaemonStateEnum>);
    public static CtxReadDelegate<RdMarkupModel> Read = (ctx, reader) => 
    {
      var isInitialized = RdProperty<bool>.Read(ctx, reader);
      var highlightersAdded = RdSignal<HighlighterList>.Read(ctx, reader);
      var highlightersRemoved = RdSignal<HighlighterIdList>.Read(ctx, reader);
      var daemonState = RdProperty<DaemonStateEnum>.Read(ctx, reader);
      var tooltipProvider = TooltipProviderModel.Read(ctx, reader);
      var gutterMarkActionActivator = JetBrains.Rider.Model.GutterMarkActionActivator.Read(ctx, reader);
      var isDebugMode = reader.ReadBool();
      var dumpAllHighlighters = RdEndpoint<int, HighlighterList>.Read(ctx, reader);
      var dumpMarkupInfo = RdEndpoint<int, MarkupDumpInfo>.Read(ctx, reader);
      return new RdMarkupModel(isInitialized, highlightersAdded, highlightersRemoved, daemonState, tooltipProvider, gutterMarkActionActivator, isDebugMode, dumpAllHighlighters, dumpMarkupInfo);
    };
    
    public static CtxWriteDelegate<DaemonStateEnum> WriteDaemonStateEnum = new CtxWriteDelegate<DaemonStateEnum>(Serializers.WriteEnum<DaemonStateEnum>);
    public static CtxWriteDelegate<RdMarkupModel> Write = (ctx, writer, value) => 
    {
      RdProperty<bool>.Write(ctx, writer, value._IsInitialized);
      RdSignal<HighlighterList>.Write(ctx, writer, value._HighlightersAdded);
      RdSignal<HighlighterIdList>.Write(ctx, writer, value._HighlightersRemoved);
      RdProperty<DaemonStateEnum>.Write(ctx, writer, value._DaemonState);
      TooltipProviderModel.Write(ctx, writer, value.TooltipProvider);
      JetBrains.Rider.Model.GutterMarkActionActivator.Write(ctx, writer, value.GutterMarkActionActivator);
      writer.Write(value.IsDebugMode);
      RdEndpoint<int, HighlighterList>.Write(ctx, writer, value._DumpAllHighlighters);
      RdEndpoint<int, MarkupDumpInfo>.Write(ctx, writer, value._DumpMarkupInfo);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _IsInitialized.BindEx(lifetime, this, "isInitialized");
      _HighlightersAdded.BindEx(lifetime, this, "highlightersAdded");
      _HighlightersRemoved.BindEx(lifetime, this, "highlightersRemoved");
      _DaemonState.BindEx(lifetime, this, "daemonState");
      TooltipProvider.BindEx(lifetime, this, "tooltipProvider");
      GutterMarkActionActivator.BindEx(lifetime, this, "gutterMarkActionActivator");
      _DumpAllHighlighters.BindEx(lifetime, this, "dumpAllHighlighters");
      _DumpMarkupInfo.BindEx(lifetime, this, "dumpMarkupInfo");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _IsInitialized.IdentifyEx(ids);
      _HighlightersAdded.IdentifyEx(ids);
      _HighlightersRemoved.IdentifyEx(ids);
      _DaemonState.IdentifyEx(ids);
      TooltipProvider.IdentifyEx(ids);
      GutterMarkActionActivator.IdentifyEx(ids);
      _DumpAllHighlighters.IdentifyEx(ids);
      _DumpMarkupInfo.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdMarkupModel (");
      using (printer.IndentCookie()) {
        printer.Print("isInitialized = "); _IsInitialized.PrintEx(printer); printer.Println();
        printer.Print("highlightersAdded = "); _HighlightersAdded.PrintEx(printer); printer.Println();
        printer.Print("highlightersRemoved = "); _HighlightersRemoved.PrintEx(printer); printer.Println();
        printer.Print("daemonState = "); _DaemonState.PrintEx(printer); printer.Println();
        printer.Print("tooltipProvider = "); TooltipProvider.PrintEx(printer); printer.Println();
        printer.Print("gutterMarkActionActivator = "); GutterMarkActionActivator.PrintEx(printer); printer.Println();
        printer.Print("isDebugMode = "); IsDebugMode.PrintEx(printer); printer.Println();
        printer.Print("dumpAllHighlighters = "); _DumpAllHighlighters.PrintEx(printer); printer.Println();
        printer.Print("dumpMarkupInfo = "); _DumpMarkupInfo.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdMemoryUsageIndicator : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<bool> IsEnable { get { return _IsEnable; }}
    [NotNull] private readonly RdProperty<bool> _IsEnable;
    [NotNull] public IRdProperty<RdMemoryUsageState> State { get { return _State; }}
    [NotNull] private readonly RdProperty<RdMemoryUsageState> _State;
    [NotNull] public IVoidSink GcCollect { get { return _GcCollect; }}
    [NotNull] private readonly RdVoidSignal _GcCollect;
    
    //primary constructor
    private RdMemoryUsageIndicator(
      [NotNull] RdProperty<bool> isEnable,
      [NotNull] RdProperty<RdMemoryUsageState> state,
      [NotNull] RdVoidSignal gcCollect
    )
    {
      _IsEnable = isEnable;
      _State = state;
      _GcCollect = gcCollect;
      isEnable.OptimizeNested = true;
    }
    //secondary constructor
    public RdMemoryUsageIndicator (
    ) : this (
      new RdProperty<bool>(),
      new RdProperty<RdMemoryUsageState>(),
      new RdVoidSignal()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdMemoryUsageIndicator> Read = (ctx, reader) => 
    {
      var isEnable = RdProperty<bool>.Read(ctx, reader);
      var state = RdProperty<RdMemoryUsageState>.Read(ctx, reader);
      var gcCollect = RdVoidSignal.Read(ctx, reader);
      return new RdMemoryUsageIndicator(isEnable, state, gcCollect);
    };
    
    public static CtxWriteDelegate<RdMemoryUsageIndicator> Write = (ctx, writer, value) => 
    {
      RdProperty<bool>.Write(ctx, writer, value._IsEnable);
      RdProperty<RdMemoryUsageState>.Write(ctx, writer, value._State);
      RdVoidSignal.Write(ctx, writer, value._GcCollect);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _IsEnable.BindEx(lifetime, this, "isEnable");
      _State.BindEx(lifetime, this, "state");
      _GcCollect.BindEx(lifetime, this, "gcCollect");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _IsEnable.IdentifyEx(ids);
      _State.IdentifyEx(ids);
      _GcCollect.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdMemoryUsageIndicator (");
      using (printer.IndentCookie()) {
        printer.Print("isEnable = "); _IsEnable.PrintEx(printer); printer.Println();
        printer.Print("state = "); _State.PrintEx(printer); printer.Println();
        printer.Print("gcCollect = "); _GcCollect.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdMemoryUsageState : RdBindableBase {
    //fields
    public long TotalMemory {get; private set;}
    [NotNull] public List<int> CollectionCount {get; private set;}
    
    //primary constructor
    public RdMemoryUsageState(
      long totalMemory,
      [NotNull] List<int> collectionCount
    )
    {
      TotalMemory = totalMemory;
      CollectionCount = collectionCount;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static CtxReadDelegate<RdMemoryUsageState> Read = (ctx, reader) => 
    {
      var totalMemory = reader.ReadLong();
      var collectionCount = ReadIntList(ctx, reader);
      return new RdMemoryUsageState(totalMemory, collectionCount);
    };
    
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static CtxWriteDelegate<RdMemoryUsageState> Write = (ctx, writer, value) => 
    {
      writer.Write(value.TotalMemory);
      WriteIntList(ctx, writer, value.CollectionCount);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdMemoryUsageState (");
      using (printer.IndentCookie()) {
        printer.Print("totalMemory = "); TotalMemory.PrintEx(printer); printer.Println();
        printer.Print("collectionCount = "); CollectionCount.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdMergeableUsage : RdUsageBase
   {
    //fields
    [NotNull] public IRdProperty<RdUsagePosition> Position { get { return _Position; }}
    [NotNull] private readonly RdProperty<RdUsagePosition> _Position;
    
    //primary constructor
    private RdMergeableUsage(
      [NotNull] RdProperty<RdUsagePosition> position,
      int index,
      [NotNull] string text,
      [NotNull] RdUsageAccessType accessType,
      [NotNull] RdProperty<bool> isValid,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] List<RdUsageGroup> groups
    ) : base (
      index,
      text,
      accessType,
      isValid,
      icon,
      groups
     ) 
    {
      _Position = position;
    }
    //secondary constructor
    public RdMergeableUsage (
      int Index,
      [NotNull] string Text,
      [NotNull] RdUsageAccessType AccessType,
      [CanBeNull] JetBrains.Rider.Model.Icon Icon,
      [NotNull] List<RdUsageGroup> Groups
    ) : this (
      new RdProperty<RdUsagePosition>(),
      Index,
      Text,
      AccessType,
      new RdProperty<bool>(),
      Icon,
      Groups
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<List<RdUsageGroup>> ReadRdUsageGroupList = RdUsageGroup.Read.List();
    public static new CtxReadDelegate<RdMergeableUsage> Read = (ctx, reader) => 
    {
      var position = RdProperty<RdUsagePosition>.Read(ctx, reader);
      var index = reader.ReadInt();
      var text = reader.ReadString();
      var accessType = RdUsageAccessType.Read(ctx, reader);
      var isValid = RdProperty<bool>.Read(ctx, reader);
      var icon = ReadIconNullable(ctx, reader);
      var groups = ReadRdUsageGroupList(ctx, reader);
      return new RdMergeableUsage(position, index, text, accessType, isValid, icon, groups);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<List<RdUsageGroup>> WriteRdUsageGroupList = RdUsageGroup.Write.List();
    public static new CtxWriteDelegate<RdMergeableUsage> Write = (ctx, writer, value) => 
    {
      RdProperty<RdUsagePosition>.Write(ctx, writer, value._Position);
      writer.Write(value.Index);
      writer.Write(value.Text);
      RdUsageAccessType.Write(ctx, writer, value.AccessType);
      RdProperty<bool>.Write(ctx, writer, value._IsValid);
      WriteIconNullable(ctx, writer, value.Icon);
      WriteRdUsageGroupList(ctx, writer, value.Groups);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Position.BindEx(lifetime, this, "position");
      AccessType.BindEx(lifetime, this, "accessType");
      _IsValid.BindEx(lifetime, this, "isValid");
      Groups.BindEx(lifetime, this, "groups");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Position.IdentifyEx(ids);
      AccessType.IdentifyEx(ids);
      _IsValid.IdentifyEx(ids);
      Groups.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdMergeableUsage (");
      using (printer.IndentCookie()) {
        printer.Print("position = "); _Position.PrintEx(printer); printer.Println();
        printer.Print("index = "); Index.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("accessType = "); AccessType.PrintEx(printer); printer.Println();
        printer.Print("isValid = "); _IsValid.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("groups = "); Groups.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNameLocation : RdProjectModelItemLocation
   {
    //fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdNameLocation> Read = (ctx, reader) => 
    {
      return new RdNameLocation();
    };
    
    public static new CtxWriteDelegate<RdNameLocation> Write = (ctx, writer, value) => 
    {
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNameLocation) obj);
    }
    public bool Equals(RdNameLocation other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNameLocation (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetBriefMetadata : RdBindableBase {
    //fields
    [NotNull] public string Id {get; private set;}
    [CanBeNull] public Uri IconUrl {get; private set;}
    [NotNull] public string InstalledVersion {get; private set;}
    [NotNull] public string LatestVersion {get; private set;}
    [NotNull] public string SourceName {get; private set;}
    
    //primary constructor
    public RdNuGetBriefMetadata(
      [NotNull] string id,
      [CanBeNull] Uri iconUrl,
      [NotNull] string installedVersion,
      [NotNull] string latestVersion,
      [NotNull] string sourceName
    )
    {
      Id = id;
      IconUrl = iconUrl;
      InstalledVersion = installedVersion;
      LatestVersion = latestVersion;
      SourceName = sourceName;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<Uri> ReadUriNullable = Serializers.ReadUri.NullableClass();
    public static CtxReadDelegate<RdNuGetBriefMetadata> Read = (ctx, reader) => 
    {
      var id = reader.ReadString();
      var iconUrl = ReadUriNullable(ctx, reader);
      var installedVersion = reader.ReadString();
      var latestVersion = reader.ReadString();
      var sourceName = reader.ReadString();
      return new RdNuGetBriefMetadata(id, iconUrl, installedVersion, latestVersion, sourceName);
    };
    
    public static CtxWriteDelegate<Uri> WriteUriNullable = Serializers.WriteUri.NullableClass();
    public static CtxWriteDelegate<RdNuGetBriefMetadata> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      WriteUriNullable(ctx, writer, value.IconUrl);
      writer.Write(value.InstalledVersion);
      writer.Write(value.LatestVersion);
      writer.Write(value.SourceName);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetBriefMetadata (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("iconUrl = "); IconUrl.PrintEx(printer); printer.Println();
        printer.Print("installedVersion = "); InstalledVersion.PrintEx(printer); printer.Println();
        printer.Print("latestVersion = "); LatestVersion.PrintEx(printer); printer.Println();
        printer.Print("sourceName = "); SourceName.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetCacheFolder : RdBindableBase {
    //fields
    [NotNull] public string Id {get; private set;}
    [NotNull] public string Title {get; private set;}
    [NotNull] public string Path {get; private set;}
    
    //primary constructor
    public RdNuGetCacheFolder(
      [NotNull] string id,
      [NotNull] string title,
      [NotNull] string path
    )
    {
      Id = id;
      Title = title;
      Path = path;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetCacheFolder> Read = (ctx, reader) => 
    {
      var id = reader.ReadString();
      var title = reader.ReadString();
      var path = reader.ReadString();
      return new RdNuGetCacheFolder(id, title, path);
    };
    
    public static CtxWriteDelegate<RdNuGetCacheFolder> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.Title);
      writer.Write(value.Path);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetCacheFolder (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("path = "); Path.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetCaches : RdBindableBase {
    //fields
    [NotNull] public IVoidSink Reload { get { return _Reload; }}
    [NotNull] private readonly RdVoidSignal _Reload;
    [NotNull] public IViewableMap<string, RdNuGetCacheFolder> Folders { get { return _Folders; }}
    [NotNull] private readonly RdMap<string, RdNuGetCacheFolder> _Folders;
    
    //primary constructor
    private RdNuGetCaches(
      [NotNull] RdVoidSignal reload,
      [NotNull] RdMap<string, RdNuGetCacheFolder> folders
    )
    {
      _Reload = reload;
      _Folders = folders;
    }
    //secondary constructor
    public RdNuGetCaches (
    ) : this (
      new RdVoidSignal(),
      new RdMap<string, RdNuGetCacheFolder>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdNuGetCaches> Read = (ctx, reader) => 
    {
      var reload = RdVoidSignal.Read(ctx, reader);
      var folders = RdMap<string, RdNuGetCacheFolder>.Read(ctx, reader);
      return new RdNuGetCaches(reload, folders);
    };
    
    public static CtxWriteDelegate<RdNuGetCaches> Write = (ctx, writer, value) => 
    {
      RdVoidSignal.Write(ctx, writer, value._Reload);
      RdMap<string, RdNuGetCacheFolder>.Write(ctx, writer, value._Folders);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Reload.BindEx(lifetime, this, "reload");
      _Folders.BindEx(lifetime, this, "folders");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Reload.IdentifyEx(ids);
      _Folders.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetCaches (");
      using (printer.IndentCookie()) {
        printer.Print("reload = "); _Reload.PrintEx(printer); printer.Println();
        printer.Print("folders = "); _Folders.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetChosenPackageView : RdBindableBase {
    //fields
    [CanBeNull] public RdNuGetPackageMetadata ChosenPackageMeta {get; private set;}
    [NotNull] public List<string> ChosenPackageVersions {get; private set;}
    
    //primary constructor
    public RdNuGetChosenPackageView(
      [CanBeNull] RdNuGetPackageMetadata chosenPackageMeta,
      [NotNull] List<string> chosenPackageVersions
    )
    {
      ChosenPackageMeta = chosenPackageMeta;
      ChosenPackageVersions = chosenPackageVersions;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetPackageMetadata> ReadRdNuGetPackageMetadataNullable = RdNuGetPackageMetadata.Read.NullableClass();
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static CtxReadDelegate<RdNuGetChosenPackageView> Read = (ctx, reader) => 
    {
      var chosenPackageMeta = ReadRdNuGetPackageMetadataNullable(ctx, reader);
      var chosenPackageVersions = ReadStringList(ctx, reader);
      return new RdNuGetChosenPackageView(chosenPackageMeta, chosenPackageVersions);
    };
    
    public static CtxWriteDelegate<RdNuGetPackageMetadata> WriteRdNuGetPackageMetadataNullable = RdNuGetPackageMetadata.Write.NullableClass();
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static CtxWriteDelegate<RdNuGetChosenPackageView> Write = (ctx, writer, value) => 
    {
      WriteRdNuGetPackageMetadataNullable(ctx, writer, value.ChosenPackageMeta);
      WriteStringList(ctx, writer, value.ChosenPackageVersions);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetChosenPackageView (");
      using (printer.IndentCookie()) {
        printer.Print("chosenPackageMeta = "); ChosenPackageMeta.PrintEx(printer); printer.Println();
        printer.Print("chosenPackageVersions = "); ChosenPackageVersions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetConfig : RdBindableBase {
    //fields
    [NotNull] public string ConfigFilePath {get; private set;}
    [CanBeNull] public string ActivePackageSourceName {get; private set;}
    [NotNull] public List<RdNuGetPackageSource> Sources {get; private set;}
    
    //primary constructor
    public RdNuGetConfig(
      [NotNull] string configFilePath,
      [CanBeNull] string activePackageSourceName,
      [NotNull] List<RdNuGetPackageSource> sources
    )
    {
      ConfigFilePath = configFilePath;
      ActivePackageSourceName = activePackageSourceName;
      Sources = sources;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<List<RdNuGetPackageSource>> ReadRdNuGetPackageSourceList = RdNuGetPackageSource.Read.List();
    public static CtxReadDelegate<RdNuGetConfig> Read = (ctx, reader) => 
    {
      var configFilePath = reader.ReadString();
      var activePackageSourceName = ReadStringNullable(ctx, reader);
      var sources = ReadRdNuGetPackageSourceList(ctx, reader);
      return new RdNuGetConfig(configFilePath, activePackageSourceName, sources);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<List<RdNuGetPackageSource>> WriteRdNuGetPackageSourceList = RdNuGetPackageSource.Write.List();
    public static CtxWriteDelegate<RdNuGetConfig> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ConfigFilePath);
      WriteStringNullable(ctx, writer, value.ActivePackageSourceName);
      WriteRdNuGetPackageSourceList(ctx, writer, value.Sources);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetConfig (");
      using (printer.IndentCookie()) {
        printer.Print("configFilePath = "); ConfigFilePath.PrintEx(printer); printer.Println();
        printer.Print("activePackageSourceName = "); ActivePackageSourceName.PrintEx(printer); printer.Println();
        printer.Print("sources = "); Sources.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdNuGetDependencyBehavior {
    Ignore,
    Lowest,
    HighestPatch,
    HighestMinor,
    Highest
  }
  
  
  public enum RdNuGetFileConflictAction {
    Prompt,
    IgnoreAll,
    OverwriteAll
  }
  
  
  public class RdNuGetFramework : IPrintable, IEquatable<RdNuGetFramework> {
    //fields
    [NotNull] public string Framework {get; private set;}
    [NotNull] public string Version {get; private set;}
    public bool HasProfile {get; private set;}
    [NotNull] public string Profile {get; private set;}
    [NotNull] public string DotNetFrameworkName {get; private set;}
    public bool IsPcl {get; private set;}
    public bool IsPackageBased {get; private set;}
    public bool AllFrameworkVersions {get; private set;}
    public bool IsUnsupported {get; private set;}
    public bool IsAgnostic {get; private set;}
    public bool IsAny {get; private set;}
    public bool IsSpecificFramework {get; private set;}
    
    //primary constructor
    public RdNuGetFramework(
      [NotNull] string framework,
      [NotNull] string version,
      bool hasProfile,
      [NotNull] string profile,
      [NotNull] string dotNetFrameworkName,
      bool isPcl,
      bool isPackageBased,
      bool allFrameworkVersions,
      bool isUnsupported,
      bool isAgnostic,
      bool isAny,
      bool isSpecificFramework
    )
    {
      Framework = framework;
      Version = version;
      HasProfile = hasProfile;
      Profile = profile;
      DotNetFrameworkName = dotNetFrameworkName;
      IsPcl = isPcl;
      IsPackageBased = isPackageBased;
      AllFrameworkVersions = allFrameworkVersions;
      IsUnsupported = isUnsupported;
      IsAgnostic = isAgnostic;
      IsAny = isAny;
      IsSpecificFramework = isSpecificFramework;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetFramework> Read = (ctx, reader) => 
    {
      var framework = reader.ReadString();
      var version = reader.ReadString();
      var hasProfile = reader.ReadBool();
      var profile = reader.ReadString();
      var dotNetFrameworkName = reader.ReadString();
      var isPcl = reader.ReadBool();
      var isPackageBased = reader.ReadBool();
      var allFrameworkVersions = reader.ReadBool();
      var isUnsupported = reader.ReadBool();
      var isAgnostic = reader.ReadBool();
      var isAny = reader.ReadBool();
      var isSpecificFramework = reader.ReadBool();
      return new RdNuGetFramework(framework, version, hasProfile, profile, dotNetFrameworkName, isPcl, isPackageBased, allFrameworkVersions, isUnsupported, isAgnostic, isAny, isSpecificFramework);
    };
    
    public static CtxWriteDelegate<RdNuGetFramework> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Framework);
      writer.Write(value.Version);
      writer.Write(value.HasProfile);
      writer.Write(value.Profile);
      writer.Write(value.DotNetFrameworkName);
      writer.Write(value.IsPcl);
      writer.Write(value.IsPackageBased);
      writer.Write(value.AllFrameworkVersions);
      writer.Write(value.IsUnsupported);
      writer.Write(value.IsAgnostic);
      writer.Write(value.IsAny);
      writer.Write(value.IsSpecificFramework);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetFramework) obj);
    }
    public bool Equals(RdNuGetFramework other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Framework == other.Framework && Version == other.Version && HasProfile == other.HasProfile && Profile == other.Profile && DotNetFrameworkName == other.DotNetFrameworkName && IsPcl == other.IsPcl && IsPackageBased == other.IsPackageBased && AllFrameworkVersions == other.AllFrameworkVersions && IsUnsupported == other.IsUnsupported && IsAgnostic == other.IsAgnostic && IsAny == other.IsAny && IsSpecificFramework == other.IsSpecificFramework;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Framework.GetHashCode();
        __r = __r*31 + Version.GetHashCode();
        __r = __r*31 + HasProfile.GetHashCode();
        __r = __r*31 + Profile.GetHashCode();
        __r = __r*31 + DotNetFrameworkName.GetHashCode();
        __r = __r*31 + IsPcl.GetHashCode();
        __r = __r*31 + IsPackageBased.GetHashCode();
        __r = __r*31 + AllFrameworkVersions.GetHashCode();
        __r = __r*31 + IsUnsupported.GetHashCode();
        __r = __r*31 + IsAgnostic.GetHashCode();
        __r = __r*31 + IsAny.GetHashCode();
        __r = __r*31 + IsSpecificFramework.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetFramework (");
      using (printer.IndentCookie()) {
        printer.Print("framework = "); Framework.PrintEx(printer); printer.Println();
        printer.Print("version = "); Version.PrintEx(printer); printer.Println();
        printer.Print("hasProfile = "); HasProfile.PrintEx(printer); printer.Println();
        printer.Print("profile = "); Profile.PrintEx(printer); printer.Println();
        printer.Print("dotNetFrameworkName = "); DotNetFrameworkName.PrintEx(printer); printer.Println();
        printer.Print("isPcl = "); IsPcl.PrintEx(printer); printer.Println();
        printer.Print("isPackageBased = "); IsPackageBased.PrintEx(printer); printer.Println();
        printer.Print("allFrameworkVersions = "); AllFrameworkVersions.PrintEx(printer); printer.Println();
        printer.Print("isUnsupported = "); IsUnsupported.PrintEx(printer); printer.Println();
        printer.Print("isAgnostic = "); IsAgnostic.PrintEx(printer); printer.Println();
        printer.Print("isAny = "); IsAny.PrintEx(printer); printer.Println();
        printer.Print("isSpecificFramework = "); IsSpecificFramework.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetHost : RdBindableBase {
    //fields
    [NotNull] public IVoidSink ClearCache { get { return _ClearCache; }}
    [NotNull] private readonly RdVoidSignal _ClearCache;
    [NotNull] public ISource<RdNuGetLogMessage> Log { get { return _Log; }}
    [NotNull] private readonly RdSignal<RdNuGetLogMessage> _Log;
    [NotNull] public ISource<string> ViewModelLog { get { return _ViewModelLog; }}
    [NotNull] private readonly RdSignal<string> _ViewModelLog;
    [NotNull] public ISource<JetBrains.Rider.Model.Notifications.RdNotificationEntry> Notify { get { return _Notify; }}
    [NotNull] private readonly RdSignal<JetBrains.Rider.Model.Notifications.RdNotificationEntry> _Notify;
    [NotNull] public RdEndpoint<RdNuGetInstallRequest, RdVoid> InstallPackage { get { return _InstallPackage; }}
    [NotNull] private readonly RdEndpoint<RdNuGetInstallRequest, RdVoid> _InstallPackage;
    [NotNull] public RdEndpoint<RdNuGetUninstallRequest, RdVoid> UninstallPackage { get { return _UninstallPackage; }}
    [NotNull] private readonly RdEndpoint<RdNuGetUninstallRequest, RdVoid> _UninstallPackage;
    [NotNull] public RdEndpoint<RdNuGetRestoreRequest, RdVoid> RestorePackages { get { return _RestorePackages; }}
    [NotNull] private readonly RdEndpoint<RdNuGetRestoreRequest, RdVoid> _RestorePackages;
    [NotNull] public RdEndpoint<RdNuGetUpgradeAllRequest, RdVoid> UpgradeAllPackages { get { return _UpgradeAllPackages; }}
    [NotNull] private readonly RdEndpoint<RdNuGetUpgradeAllRequest, RdVoid> _UpgradeAllPackages;
    [NotNull] public RdEndpoint<bool, RdVoid> UpdateViewModelForce { get { return _UpdateViewModelForce; }}
    [NotNull] private readonly RdEndpoint<bool, RdVoid> _UpdateViewModelForce;
    [NotNull] public IViewableMap<int, RdNuGetProjectInfo> ProjectInfos { get { return _ProjectInfos; }}
    [NotNull] private readonly RdMap<int, RdNuGetProjectInfo> _ProjectInfos;
    [NotNull] public IRdProperty<int> ContextProjectId { get { return _ContextProjectId; }}
    [NotNull] private readonly RdProperty<int> _ContextProjectId;
    [NotNull] public IRdProperty<string> SearchTerm { get { return _SearchTerm; }}
    [NotNull] private readonly RdProperty<string> _SearchTerm;
    [NotNull] public IRdProperty<RdNuGetPackages> InstalledPackages { get { return _InstalledPackages; }}
    [NotNull] private readonly RdProperty<RdNuGetPackages> _InstalledPackages;
    [NotNull] public IRdProperty<RdNuGetPackages> AvailablePackages { get { return _AvailablePackages; }}
    [NotNull] private readonly RdProperty<RdNuGetPackages> _AvailablePackages;
    [NotNull] public IRdProperty<RdNuGetBriefMetadata> ChosenPackage { get { return _ChosenPackage; }}
    [NotNull] private readonly RdProperty<RdNuGetBriefMetadata> _ChosenPackage;
    [NotNull] public IRdProperty<RdNuGetChosenPackageView> ChosenPackageView { get { return _ChosenPackageView; }}
    [NotNull] private readonly RdProperty<RdNuGetChosenPackageView> _ChosenPackageView;
    [NotNull] public IRdProperty<bool> IncludePrerelease { get { return _IncludePrerelease; }}
    [NotNull] private readonly RdProperty<bool> _IncludePrerelease;
    [NotNull] public IRdProperty<bool> IncludeUnlisted { get { return _IncludeUnlisted; }}
    [NotNull] private readonly RdProperty<bool> _IncludeUnlisted;
    [NotNull] public IRdProperty<RdNuGetDependencyBehavior> DependencyBehavior { get { return _DependencyBehavior; }}
    [NotNull] private readonly RdProperty<RdNuGetDependencyBehavior> _DependencyBehavior;
    [NotNull] public IRdProperty<RdNuGetFileConflictAction> FileConflictAction { get { return _FileConflictAction; }}
    [NotNull] private readonly RdProperty<RdNuGetFileConflictAction> _FileConflictAction;
    [NotNull] public IRdProperty<bool> RemoveDependencies { get { return _RemoveDependencies; }}
    [NotNull] private readonly RdProperty<bool> _RemoveDependencies;
    [NotNull] public IRdProperty<bool> ForceRemove { get { return _ForceRemove; }}
    [NotNull] private readonly RdProperty<bool> _ForceRemove;
    [NotNull] public IRdProperty<RdNuGetVersionConstraints> VersionConstraints { get { return _VersionConstraints; }}
    [NotNull] private readonly RdProperty<RdNuGetVersionConstraints> _VersionConstraints;
    [NotNull] public IRdProperty<bool> Enabled { get { return _Enabled; }}
    [NotNull] private readonly RdProperty<bool> _Enabled;
    [NotNull] public IVoidSource ReloadSources { get { return _ReloadSources; }}
    [NotNull] private readonly RdVoidSignal _ReloadSources;
    [NotNull] public RdNuGetSettings Settings {get; private set;}
    [NotNull] public IRdProperty<RdNuGetPackageSources> Sources { get { return _Sources; }}
    [NotNull] private readonly RdProperty<RdNuGetPackageSources> _Sources;
    [NotNull] public ISource<string> Status { get { return _Status; }}
    [NotNull] private readonly RdSignal<string> _Status;
    [NotNull] public IRdProperty<bool> IsLoaded { get { return _IsLoaded; }}
    [NotNull] private readonly RdProperty<bool> _IsLoaded;
    [NotNull] public RdNuGetCaches Caches {get; private set;}
    [NotNull] public RdNuGetStateInfo StateInfo {get; private set;}
    
    //primary constructor
    private RdNuGetHost(
      [NotNull] RdVoidSignal clearCache,
      [NotNull] RdSignal<RdNuGetLogMessage> log,
      [NotNull] RdSignal<string> viewModelLog,
      [NotNull] RdSignal<JetBrains.Rider.Model.Notifications.RdNotificationEntry> notify,
      [NotNull] RdEndpoint<RdNuGetInstallRequest, RdVoid> installPackage,
      [NotNull] RdEndpoint<RdNuGetUninstallRequest, RdVoid> uninstallPackage,
      [NotNull] RdEndpoint<RdNuGetRestoreRequest, RdVoid> restorePackages,
      [NotNull] RdEndpoint<RdNuGetUpgradeAllRequest, RdVoid> upgradeAllPackages,
      [NotNull] RdEndpoint<bool, RdVoid> updateViewModelForce,
      [NotNull] RdMap<int, RdNuGetProjectInfo> projectInfos,
      [NotNull] RdProperty<int> contextProjectId,
      [NotNull] RdProperty<string> searchTerm,
      [NotNull] RdProperty<RdNuGetPackages> installedPackages,
      [NotNull] RdProperty<RdNuGetPackages> availablePackages,
      [NotNull] RdProperty<RdNuGetBriefMetadata> chosenPackage,
      [NotNull] RdProperty<RdNuGetChosenPackageView> chosenPackageView,
      [NotNull] RdProperty<bool> includePrerelease,
      [NotNull] RdProperty<bool> includeUnlisted,
      [NotNull] RdProperty<RdNuGetDependencyBehavior> dependencyBehavior,
      [NotNull] RdProperty<RdNuGetFileConflictAction> fileConflictAction,
      [NotNull] RdProperty<bool> removeDependencies,
      [NotNull] RdProperty<bool> forceRemove,
      [NotNull] RdProperty<RdNuGetVersionConstraints> versionConstraints,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdVoidSignal reloadSources,
      [NotNull] RdNuGetSettings settings,
      [NotNull] RdProperty<RdNuGetPackageSources> sources,
      [NotNull] RdSignal<string> status,
      [NotNull] RdProperty<bool> isLoaded,
      [NotNull] RdNuGetCaches caches,
      [NotNull] RdNuGetStateInfo stateInfo
    )
    {
      _ClearCache = clearCache;
      _Log = log;
      _ViewModelLog = viewModelLog;
      _Notify = notify;
      _InstallPackage = installPackage;
      _UninstallPackage = uninstallPackage;
      _RestorePackages = restorePackages;
      _UpgradeAllPackages = upgradeAllPackages;
      _UpdateViewModelForce = updateViewModelForce;
      _ProjectInfos = projectInfos;
      _ContextProjectId = contextProjectId;
      _SearchTerm = searchTerm;
      _InstalledPackages = installedPackages;
      _AvailablePackages = availablePackages;
      _ChosenPackage = chosenPackage;
      _ChosenPackageView = chosenPackageView;
      _IncludePrerelease = includePrerelease;
      _IncludeUnlisted = includeUnlisted;
      _DependencyBehavior = dependencyBehavior;
      _FileConflictAction = fileConflictAction;
      _RemoveDependencies = removeDependencies;
      _ForceRemove = forceRemove;
      _VersionConstraints = versionConstraints;
      _Enabled = enabled;
      _ReloadSources = reloadSources;
      Settings = settings;
      _Sources = sources;
      _Status = status;
      _IsLoaded = isLoaded;
      Caches = caches;
      StateInfo = stateInfo;
      contextProjectId.OptimizeNested = true;
      searchTerm.OptimizeNested = true;
      includePrerelease.OptimizeNested = true;
      includeUnlisted.OptimizeNested = true;
      dependencyBehavior.OptimizeNested = true;
      fileConflictAction.OptimizeNested = true;
      removeDependencies.OptimizeNested = true;
      forceRemove.OptimizeNested = true;
      versionConstraints.OptimizeNested = true;
      enabled.OptimizeNested = true;
      isLoaded.OptimizeNested = true;
    }
    //secondary constructor
    public RdNuGetHost (
    ) : this (
      new RdVoidSignal(),
      new RdSignal<RdNuGetLogMessage>(),
      new RdSignal<string>(),
      new RdSignal<JetBrains.Rider.Model.Notifications.RdNotificationEntry>(),
      new RdEndpoint<RdNuGetInstallRequest, RdVoid>(),
      new RdEndpoint<RdNuGetUninstallRequest, RdVoid>(),
      new RdEndpoint<RdNuGetRestoreRequest, RdVoid>(),
      new RdEndpoint<RdNuGetUpgradeAllRequest, RdVoid>(),
      new RdEndpoint<bool, RdVoid>(),
      new RdMap<int, RdNuGetProjectInfo>(),
      new RdProperty<int>(),
      new RdProperty<string>(),
      new RdProperty<RdNuGetPackages>(),
      new RdProperty<RdNuGetPackages>(),
      new RdProperty<RdNuGetBriefMetadata>(),
      new RdProperty<RdNuGetChosenPackageView>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<RdNuGetDependencyBehavior>(),
      new RdProperty<RdNuGetFileConflictAction>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<RdNuGetVersionConstraints>(),
      new RdProperty<bool>(),
      new RdVoidSignal(),
      new RdNuGetSettings(),
      new RdProperty<RdNuGetPackageSources>(),
      new RdSignal<string>(),
      new RdProperty<bool>(),
      new RdNuGetCaches(),
      new RdNuGetStateInfo()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdNuGetDependencyBehavior> ReadRdNuGetDependencyBehavior = new CtxReadDelegate<RdNuGetDependencyBehavior>(Serializers.ReadEnum<RdNuGetDependencyBehavior>);
    public static CtxReadDelegate<RdNuGetFileConflictAction> ReadRdNuGetFileConflictAction = new CtxReadDelegate<RdNuGetFileConflictAction>(Serializers.ReadEnum<RdNuGetFileConflictAction>);
    public static CtxReadDelegate<RdNuGetVersionConstraints> ReadRdNuGetVersionConstraints = new CtxReadDelegate<RdNuGetVersionConstraints>(Serializers.ReadEnum<RdNuGetVersionConstraints>);
    public static CtxReadDelegate<RdNuGetHost> Read = (ctx, reader) => 
    {
      var clearCache = RdVoidSignal.Read(ctx, reader);
      var log = RdSignal<RdNuGetLogMessage>.Read(ctx, reader);
      var viewModelLog = RdSignal<string>.Read(ctx, reader);
      var notify = RdSignal<JetBrains.Rider.Model.Notifications.RdNotificationEntry>.Read(ctx, reader);
      var installPackage = RdEndpoint<RdNuGetInstallRequest, RdVoid>.Read(ctx, reader);
      var uninstallPackage = RdEndpoint<RdNuGetUninstallRequest, RdVoid>.Read(ctx, reader);
      var restorePackages = RdEndpoint<RdNuGetRestoreRequest, RdVoid>.Read(ctx, reader);
      var upgradeAllPackages = RdEndpoint<RdNuGetUpgradeAllRequest, RdVoid>.Read(ctx, reader);
      var updateViewModelForce = RdEndpoint<bool, RdVoid>.Read(ctx, reader);
      var projectInfos = RdMap<int, RdNuGetProjectInfo>.Read(ctx, reader);
      var contextProjectId = RdProperty<int>.Read(ctx, reader);
      var searchTerm = RdProperty<string>.Read(ctx, reader);
      var installedPackages = RdProperty<RdNuGetPackages>.Read(ctx, reader);
      var availablePackages = RdProperty<RdNuGetPackages>.Read(ctx, reader);
      var chosenPackage = RdProperty<RdNuGetBriefMetadata>.Read(ctx, reader);
      var chosenPackageView = RdProperty<RdNuGetChosenPackageView>.Read(ctx, reader);
      var includePrerelease = RdProperty<bool>.Read(ctx, reader);
      var includeUnlisted = RdProperty<bool>.Read(ctx, reader);
      var dependencyBehavior = RdProperty<RdNuGetDependencyBehavior>.Read(ctx, reader);
      var fileConflictAction = RdProperty<RdNuGetFileConflictAction>.Read(ctx, reader);
      var removeDependencies = RdProperty<bool>.Read(ctx, reader);
      var forceRemove = RdProperty<bool>.Read(ctx, reader);
      var versionConstraints = RdProperty<RdNuGetVersionConstraints>.Read(ctx, reader);
      var enabled = RdProperty<bool>.Read(ctx, reader);
      var reloadSources = RdVoidSignal.Read(ctx, reader);
      var settings = RdNuGetSettings.Read(ctx, reader);
      var sources = RdProperty<RdNuGetPackageSources>.Read(ctx, reader);
      var status = RdSignal<string>.Read(ctx, reader);
      var isLoaded = RdProperty<bool>.Read(ctx, reader);
      var caches = RdNuGetCaches.Read(ctx, reader);
      var stateInfo = RdNuGetStateInfo.Read(ctx, reader);
      return new RdNuGetHost(clearCache, log, viewModelLog, notify, installPackage, uninstallPackage, restorePackages, upgradeAllPackages, updateViewModelForce, projectInfos, contextProjectId, searchTerm, installedPackages, availablePackages, chosenPackage, chosenPackageView, includePrerelease, includeUnlisted, dependencyBehavior, fileConflictAction, removeDependencies, forceRemove, versionConstraints, enabled, reloadSources, settings, sources, status, isLoaded, caches, stateInfo);
    };
    
    public static CtxWriteDelegate<RdNuGetDependencyBehavior> WriteRdNuGetDependencyBehavior = new CtxWriteDelegate<RdNuGetDependencyBehavior>(Serializers.WriteEnum<RdNuGetDependencyBehavior>);
    public static CtxWriteDelegate<RdNuGetFileConflictAction> WriteRdNuGetFileConflictAction = new CtxWriteDelegate<RdNuGetFileConflictAction>(Serializers.WriteEnum<RdNuGetFileConflictAction>);
    public static CtxWriteDelegate<RdNuGetVersionConstraints> WriteRdNuGetVersionConstraints = new CtxWriteDelegate<RdNuGetVersionConstraints>(Serializers.WriteEnum<RdNuGetVersionConstraints>);
    public static CtxWriteDelegate<RdNuGetHost> Write = (ctx, writer, value) => 
    {
      RdVoidSignal.Write(ctx, writer, value._ClearCache);
      RdSignal<RdNuGetLogMessage>.Write(ctx, writer, value._Log);
      RdSignal<string>.Write(ctx, writer, value._ViewModelLog);
      RdSignal<JetBrains.Rider.Model.Notifications.RdNotificationEntry>.Write(ctx, writer, value._Notify);
      RdEndpoint<RdNuGetInstallRequest, RdVoid>.Write(ctx, writer, value._InstallPackage);
      RdEndpoint<RdNuGetUninstallRequest, RdVoid>.Write(ctx, writer, value._UninstallPackage);
      RdEndpoint<RdNuGetRestoreRequest, RdVoid>.Write(ctx, writer, value._RestorePackages);
      RdEndpoint<RdNuGetUpgradeAllRequest, RdVoid>.Write(ctx, writer, value._UpgradeAllPackages);
      RdEndpoint<bool, RdVoid>.Write(ctx, writer, value._UpdateViewModelForce);
      RdMap<int, RdNuGetProjectInfo>.Write(ctx, writer, value._ProjectInfos);
      RdProperty<int>.Write(ctx, writer, value._ContextProjectId);
      RdProperty<string>.Write(ctx, writer, value._SearchTerm);
      RdProperty<RdNuGetPackages>.Write(ctx, writer, value._InstalledPackages);
      RdProperty<RdNuGetPackages>.Write(ctx, writer, value._AvailablePackages);
      RdProperty<RdNuGetBriefMetadata>.Write(ctx, writer, value._ChosenPackage);
      RdProperty<RdNuGetChosenPackageView>.Write(ctx, writer, value._ChosenPackageView);
      RdProperty<bool>.Write(ctx, writer, value._IncludePrerelease);
      RdProperty<bool>.Write(ctx, writer, value._IncludeUnlisted);
      RdProperty<RdNuGetDependencyBehavior>.Write(ctx, writer, value._DependencyBehavior);
      RdProperty<RdNuGetFileConflictAction>.Write(ctx, writer, value._FileConflictAction);
      RdProperty<bool>.Write(ctx, writer, value._RemoveDependencies);
      RdProperty<bool>.Write(ctx, writer, value._ForceRemove);
      RdProperty<RdNuGetVersionConstraints>.Write(ctx, writer, value._VersionConstraints);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdVoidSignal.Write(ctx, writer, value._ReloadSources);
      RdNuGetSettings.Write(ctx, writer, value.Settings);
      RdProperty<RdNuGetPackageSources>.Write(ctx, writer, value._Sources);
      RdSignal<string>.Write(ctx, writer, value._Status);
      RdProperty<bool>.Write(ctx, writer, value._IsLoaded);
      RdNuGetCaches.Write(ctx, writer, value.Caches);
      RdNuGetStateInfo.Write(ctx, writer, value.StateInfo);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _ClearCache.BindEx(lifetime, this, "clearCache");
      _Log.BindEx(lifetime, this, "log");
      _ViewModelLog.BindEx(lifetime, this, "viewModelLog");
      _Notify.BindEx(lifetime, this, "notify");
      _InstallPackage.BindEx(lifetime, this, "installPackage");
      _UninstallPackage.BindEx(lifetime, this, "uninstallPackage");
      _RestorePackages.BindEx(lifetime, this, "restorePackages");
      _UpgradeAllPackages.BindEx(lifetime, this, "upgradeAllPackages");
      _UpdateViewModelForce.BindEx(lifetime, this, "updateViewModelForce");
      _ProjectInfos.BindEx(lifetime, this, "projectInfos");
      _ContextProjectId.BindEx(lifetime, this, "contextProjectId");
      _SearchTerm.BindEx(lifetime, this, "searchTerm");
      _InstalledPackages.BindEx(lifetime, this, "installedPackages");
      _AvailablePackages.BindEx(lifetime, this, "availablePackages");
      _ChosenPackage.BindEx(lifetime, this, "chosenPackage");
      _ChosenPackageView.BindEx(lifetime, this, "chosenPackageView");
      _IncludePrerelease.BindEx(lifetime, this, "includePrerelease");
      _IncludeUnlisted.BindEx(lifetime, this, "includeUnlisted");
      _DependencyBehavior.BindEx(lifetime, this, "dependencyBehavior");
      _FileConflictAction.BindEx(lifetime, this, "fileConflictAction");
      _RemoveDependencies.BindEx(lifetime, this, "removeDependencies");
      _ForceRemove.BindEx(lifetime, this, "forceRemove");
      _VersionConstraints.BindEx(lifetime, this, "versionConstraints");
      _Enabled.BindEx(lifetime, this, "enabled");
      _ReloadSources.BindEx(lifetime, this, "reloadSources");
      Settings.BindEx(lifetime, this, "settings");
      _Sources.BindEx(lifetime, this, "sources");
      _Status.BindEx(lifetime, this, "status");
      _IsLoaded.BindEx(lifetime, this, "isLoaded");
      Caches.BindEx(lifetime, this, "caches");
      StateInfo.BindEx(lifetime, this, "stateInfo");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ClearCache.IdentifyEx(ids);
      _Log.IdentifyEx(ids);
      _ViewModelLog.IdentifyEx(ids);
      _Notify.IdentifyEx(ids);
      _InstallPackage.IdentifyEx(ids);
      _UninstallPackage.IdentifyEx(ids);
      _RestorePackages.IdentifyEx(ids);
      _UpgradeAllPackages.IdentifyEx(ids);
      _UpdateViewModelForce.IdentifyEx(ids);
      _ProjectInfos.IdentifyEx(ids);
      _ContextProjectId.IdentifyEx(ids);
      _SearchTerm.IdentifyEx(ids);
      _InstalledPackages.IdentifyEx(ids);
      _AvailablePackages.IdentifyEx(ids);
      _ChosenPackage.IdentifyEx(ids);
      _ChosenPackageView.IdentifyEx(ids);
      _IncludePrerelease.IdentifyEx(ids);
      _IncludeUnlisted.IdentifyEx(ids);
      _DependencyBehavior.IdentifyEx(ids);
      _FileConflictAction.IdentifyEx(ids);
      _RemoveDependencies.IdentifyEx(ids);
      _ForceRemove.IdentifyEx(ids);
      _VersionConstraints.IdentifyEx(ids);
      _Enabled.IdentifyEx(ids);
      _ReloadSources.IdentifyEx(ids);
      Settings.IdentifyEx(ids);
      _Sources.IdentifyEx(ids);
      _Status.IdentifyEx(ids);
      _IsLoaded.IdentifyEx(ids);
      Caches.IdentifyEx(ids);
      StateInfo.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetHost (");
      using (printer.IndentCookie()) {
        printer.Print("clearCache = "); _ClearCache.PrintEx(printer); printer.Println();
        printer.Print("log = "); _Log.PrintEx(printer); printer.Println();
        printer.Print("viewModelLog = "); _ViewModelLog.PrintEx(printer); printer.Println();
        printer.Print("notify = "); _Notify.PrintEx(printer); printer.Println();
        printer.Print("installPackage = "); _InstallPackage.PrintEx(printer); printer.Println();
        printer.Print("uninstallPackage = "); _UninstallPackage.PrintEx(printer); printer.Println();
        printer.Print("restorePackages = "); _RestorePackages.PrintEx(printer); printer.Println();
        printer.Print("upgradeAllPackages = "); _UpgradeAllPackages.PrintEx(printer); printer.Println();
        printer.Print("updateViewModelForce = "); _UpdateViewModelForce.PrintEx(printer); printer.Println();
        printer.Print("projectInfos = "); _ProjectInfos.PrintEx(printer); printer.Println();
        printer.Print("contextProjectId = "); _ContextProjectId.PrintEx(printer); printer.Println();
        printer.Print("searchTerm = "); _SearchTerm.PrintEx(printer); printer.Println();
        printer.Print("installedPackages = "); _InstalledPackages.PrintEx(printer); printer.Println();
        printer.Print("availablePackages = "); _AvailablePackages.PrintEx(printer); printer.Println();
        printer.Print("chosenPackage = "); _ChosenPackage.PrintEx(printer); printer.Println();
        printer.Print("chosenPackageView = "); _ChosenPackageView.PrintEx(printer); printer.Println();
        printer.Print("includePrerelease = "); _IncludePrerelease.PrintEx(printer); printer.Println();
        printer.Print("includeUnlisted = "); _IncludeUnlisted.PrintEx(printer); printer.Println();
        printer.Print("dependencyBehavior = "); _DependencyBehavior.PrintEx(printer); printer.Println();
        printer.Print("fileConflictAction = "); _FileConflictAction.PrintEx(printer); printer.Println();
        printer.Print("removeDependencies = "); _RemoveDependencies.PrintEx(printer); printer.Println();
        printer.Print("forceRemove = "); _ForceRemove.PrintEx(printer); printer.Println();
        printer.Print("versionConstraints = "); _VersionConstraints.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("reloadSources = "); _ReloadSources.PrintEx(printer); printer.Println();
        printer.Print("settings = "); Settings.PrintEx(printer); printer.Println();
        printer.Print("sources = "); _Sources.PrintEx(printer); printer.Println();
        printer.Print("status = "); _Status.PrintEx(printer); printer.Println();
        printer.Print("isLoaded = "); _IsLoaded.PrintEx(printer); printer.Println();
        printer.Print("caches = "); Caches.PrintEx(printer); printer.Println();
        printer.Print("stateInfo = "); StateInfo.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetInstallRequest : IPrintable, IEquatable<RdNuGetInstallRequest> {
    //fields
    [NotNull] public RdNuGetProjects Projects {get; private set;}
    [NotNull] public string PackageId {get; private set;}
    [NotNull] public string PackageVersion {get; private set;}
    
    //primary constructor
    public RdNuGetInstallRequest(
      [NotNull] RdNuGetProjects projects,
      [NotNull] string packageId,
      [NotNull] string packageVersion
    )
    {
      Projects = projects;
      PackageId = packageId;
      PackageVersion = packageVersion;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetInstallRequest> Read = (ctx, reader) => 
    {
      var projects = RdNuGetProjects.Read(ctx, reader);
      var packageId = reader.ReadString();
      var packageVersion = reader.ReadString();
      return new RdNuGetInstallRequest(projects, packageId, packageVersion);
    };
    
    public static CtxWriteDelegate<RdNuGetInstallRequest> Write = (ctx, writer, value) => 
    {
      RdNuGetProjects.Write(ctx, writer, value.Projects);
      writer.Write(value.PackageId);
      writer.Write(value.PackageVersion);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetInstallRequest) obj);
    }
    public bool Equals(RdNuGetInstallRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Projects, other.Projects) && PackageId == other.PackageId && PackageVersion == other.PackageVersion;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Projects.GetHashCode();
        __r = __r*31 + PackageId.GetHashCode();
        __r = __r*31 + PackageVersion.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetInstallRequest (");
      using (printer.IndentCookie()) {
        printer.Print("projects = "); Projects.PrintEx(printer); printer.Println();
        printer.Print("packageId = "); PackageId.PrintEx(printer); printer.Println();
        printer.Print("packageVersion = "); PackageVersion.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdNuGetLogLevel {
    Exception,
    Error,
    FileConflict,
    Info,
    ProjectSystem,
    Warning,
    Debug,
    General,
    RiderError
  }
  
  
  public class RdNuGetLogMessage : IPrintable, IEquatable<RdNuGetLogMessage> {
    //fields
    public RdNuGetLogLevel Level {get; private set;}
    [NotNull] public string Text {get; private set;}
    
    //primary constructor
    public RdNuGetLogMessage(
      RdNuGetLogLevel level,
      [NotNull] string text
    )
    {
      Level = level;
      Text = text;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetLogMessage> Read = (ctx, reader) => 
    {
      var level = (RdNuGetLogLevel)reader.ReadInt();
      var text = reader.ReadString();
      return new RdNuGetLogMessage(level, text);
    };
    
    public static CtxWriteDelegate<RdNuGetLogMessage> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Level);
      writer.Write(value.Text);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetLogMessage) obj);
    }
    public bool Equals(RdNuGetLogMessage other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Level == other.Level && Text == other.Text;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (int) Level;
        __r = __r*31 + Text.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetLogMessage (");
      using (printer.IndentCookie()) {
        printer.Print("level = "); Level.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetPackageDependency : IPrintable, IEquatable<RdNuGetPackageDependency> {
    //fields
    [NotNull] public string Id {get; private set;}
    [CanBeNull] public RdNuGetVersionRange VersionRange {get; private set;}
    
    //primary constructor
    public RdNuGetPackageDependency(
      [NotNull] string id,
      [CanBeNull] RdNuGetVersionRange versionRange
    )
    {
      Id = id;
      VersionRange = versionRange;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetVersionRange> ReadRdNuGetVersionRangeNullable = RdNuGetVersionRange.Read.NullableClass();
    public static CtxReadDelegate<RdNuGetPackageDependency> Read = (ctx, reader) => 
    {
      var id = reader.ReadString();
      var versionRange = ReadRdNuGetVersionRangeNullable(ctx, reader);
      return new RdNuGetPackageDependency(id, versionRange);
    };
    
    public static CtxWriteDelegate<RdNuGetVersionRange> WriteRdNuGetVersionRangeNullable = RdNuGetVersionRange.Write.NullableClass();
    public static CtxWriteDelegate<RdNuGetPackageDependency> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      WriteRdNuGetVersionRangeNullable(ctx, writer, value.VersionRange);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetPackageDependency) obj);
    }
    public bool Equals(RdNuGetPackageDependency other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Equals(VersionRange, other.VersionRange);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Id.GetHashCode();
        __r = __r*31 + (VersionRange != null ?VersionRange.GetHashCode() : 0);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetPackageDependency (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("versionRange = "); VersionRange.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetPackageDependencyGroup : IPrintable, IEquatable<RdNuGetPackageDependencyGroup> {
    //fields
    [NotNull] public RdNuGetFramework TargetFramework {get; private set;}
    [NotNull] public List<RdNuGetPackageDependency> Packages {get; private set;}
    
    //primary constructor
    public RdNuGetPackageDependencyGroup(
      [NotNull] RdNuGetFramework targetFramework,
      [NotNull] List<RdNuGetPackageDependency> packages
    )
    {
      TargetFramework = targetFramework;
      Packages = packages;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<RdNuGetPackageDependency>> ReadRdNuGetPackageDependencyList = RdNuGetPackageDependency.Read.List();
    public static CtxReadDelegate<RdNuGetPackageDependencyGroup> Read = (ctx, reader) => 
    {
      var targetFramework = RdNuGetFramework.Read(ctx, reader);
      var packages = ReadRdNuGetPackageDependencyList(ctx, reader);
      return new RdNuGetPackageDependencyGroup(targetFramework, packages);
    };
    
    public static CtxWriteDelegate<List<RdNuGetPackageDependency>> WriteRdNuGetPackageDependencyList = RdNuGetPackageDependency.Write.List();
    public static CtxWriteDelegate<RdNuGetPackageDependencyGroup> Write = (ctx, writer, value) => 
    {
      RdNuGetFramework.Write(ctx, writer, value.TargetFramework);
      WriteRdNuGetPackageDependencyList(ctx, writer, value.Packages);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetPackageDependencyGroup) obj);
    }
    public bool Equals(RdNuGetPackageDependencyGroup other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(TargetFramework, other.TargetFramework) && Packages.SequenceEqual(other.Packages);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + TargetFramework.GetHashCode();
        __r = __r*31 + CollectionUtil.GetHashCode(Packages);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetPackageDependencyGroup (");
      using (printer.IndentCookie()) {
        printer.Print("targetFramework = "); TargetFramework.PrintEx(printer); printer.Println();
        printer.Print("packages = "); Packages.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetPackageIdentity : IPrintable, IEquatable<RdNuGetPackageIdentity> {
    //fields
    [NotNull] public string Id {get; private set;}
    [NotNull] public string Version {get; private set;}
    
    //primary constructor
    public RdNuGetPackageIdentity(
      [NotNull] string id,
      [NotNull] string version
    )
    {
      Id = id;
      Version = version;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetPackageIdentity> Read = (ctx, reader) => 
    {
      var id = reader.ReadString();
      var version = reader.ReadString();
      return new RdNuGetPackageIdentity(id, version);
    };
    
    public static CtxWriteDelegate<RdNuGetPackageIdentity> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.Version);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetPackageIdentity) obj);
    }
    public bool Equals(RdNuGetPackageIdentity other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Version == other.Version;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Id.GetHashCode();
        __r = __r*31 + Version.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetPackageIdentity (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("version = "); Version.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetPackageMetadata : IPrintable, IEquatable<RdNuGetPackageMetadata> {
    //fields
    [NotNull] public RdNuGetPackageIdentity Identity {get; private set;}
    [NotNull] public string Title {get; private set;}
    [NotNull] public string Summary {get; private set;}
    [NotNull] public string Description {get; private set;}
    [NotNull] public string Authors {get; private set;}
    [NotNull] public string Owners {get; private set;}
    [CanBeNull] public Uri IconUrl {get; private set;}
    [CanBeNull] public Uri LicenseUrl {get; private set;}
    [CanBeNull] public Uri ProjectUrl {get; private set;}
    [CanBeNull] public Uri ReportAbuseUrl {get; private set;}
    [NotNull] public string Tags {get; private set;}
    [CanBeNull] public long? DownloadCount {get; private set;}
    [NotNull] public List<RdNuGetPackageDependencyGroup> DependencySets {get; private set;}
    public bool RequireLicenseAcceptance {get; private set;}
    
    //primary constructor
    public RdNuGetPackageMetadata(
      [NotNull] RdNuGetPackageIdentity identity,
      [NotNull] string title,
      [NotNull] string summary,
      [NotNull] string description,
      [NotNull] string authors,
      [NotNull] string owners,
      [CanBeNull] Uri iconUrl,
      [CanBeNull] Uri licenseUrl,
      [CanBeNull] Uri projectUrl,
      [CanBeNull] Uri reportAbuseUrl,
      [NotNull] string tags,
      [CanBeNull] long? downloadCount,
      [NotNull] List<RdNuGetPackageDependencyGroup> dependencySets,
      bool requireLicenseAcceptance
    )
    {
      Identity = identity;
      Title = title;
      Summary = summary;
      Description = description;
      Authors = authors;
      Owners = owners;
      IconUrl = iconUrl;
      LicenseUrl = licenseUrl;
      ProjectUrl = projectUrl;
      ReportAbuseUrl = reportAbuseUrl;
      Tags = tags;
      DownloadCount = downloadCount;
      DependencySets = dependencySets;
      RequireLicenseAcceptance = requireLicenseAcceptance;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<Uri> ReadUriNullable = Serializers.ReadUri.NullableClass();
    public static CtxReadDelegate<long?> ReadLongNullable = Serializers.ReadLong.NullableStruct();
    public static CtxReadDelegate<List<RdNuGetPackageDependencyGroup>> ReadRdNuGetPackageDependencyGroupList = RdNuGetPackageDependencyGroup.Read.List();
    public static CtxReadDelegate<RdNuGetPackageMetadata> Read = (ctx, reader) => 
    {
      var identity = RdNuGetPackageIdentity.Read(ctx, reader);
      var title = reader.ReadString();
      var summary = reader.ReadString();
      var description = reader.ReadString();
      var authors = reader.ReadString();
      var owners = reader.ReadString();
      var iconUrl = ReadUriNullable(ctx, reader);
      var licenseUrl = ReadUriNullable(ctx, reader);
      var projectUrl = ReadUriNullable(ctx, reader);
      var reportAbuseUrl = ReadUriNullable(ctx, reader);
      var tags = reader.ReadString();
      var downloadCount = ReadLongNullable(ctx, reader);
      var dependencySets = ReadRdNuGetPackageDependencyGroupList(ctx, reader);
      var requireLicenseAcceptance = reader.ReadBool();
      return new RdNuGetPackageMetadata(identity, title, summary, description, authors, owners, iconUrl, licenseUrl, projectUrl, reportAbuseUrl, tags, downloadCount, dependencySets, requireLicenseAcceptance);
    };
    
    public static CtxWriteDelegate<Uri> WriteUriNullable = Serializers.WriteUri.NullableClass();
    public static CtxWriteDelegate<long?> WriteLongNullable = Serializers.WriteLong.NullableStruct();
    public static CtxWriteDelegate<List<RdNuGetPackageDependencyGroup>> WriteRdNuGetPackageDependencyGroupList = RdNuGetPackageDependencyGroup.Write.List();
    public static CtxWriteDelegate<RdNuGetPackageMetadata> Write = (ctx, writer, value) => 
    {
      RdNuGetPackageIdentity.Write(ctx, writer, value.Identity);
      writer.Write(value.Title);
      writer.Write(value.Summary);
      writer.Write(value.Description);
      writer.Write(value.Authors);
      writer.Write(value.Owners);
      WriteUriNullable(ctx, writer, value.IconUrl);
      WriteUriNullable(ctx, writer, value.LicenseUrl);
      WriteUriNullable(ctx, writer, value.ProjectUrl);
      WriteUriNullable(ctx, writer, value.ReportAbuseUrl);
      writer.Write(value.Tags);
      WriteLongNullable(ctx, writer, value.DownloadCount);
      WriteRdNuGetPackageDependencyGroupList(ctx, writer, value.DependencySets);
      writer.Write(value.RequireLicenseAcceptance);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetPackageMetadata) obj);
    }
    public bool Equals(RdNuGetPackageMetadata other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Identity, other.Identity) && Title == other.Title && Summary == other.Summary && Description == other.Description && Authors == other.Authors && Owners == other.Owners && Equals(IconUrl, other.IconUrl) && Equals(LicenseUrl, other.LicenseUrl) && Equals(ProjectUrl, other.ProjectUrl) && Equals(ReportAbuseUrl, other.ReportAbuseUrl) && Tags == other.Tags && Equals(DownloadCount, other.DownloadCount) && DependencySets.SequenceEqual(other.DependencySets) && RequireLicenseAcceptance == other.RequireLicenseAcceptance;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Identity.GetHashCode();
        __r = __r*31 + Title.GetHashCode();
        __r = __r*31 + Summary.GetHashCode();
        __r = __r*31 + Description.GetHashCode();
        __r = __r*31 + Authors.GetHashCode();
        __r = __r*31 + Owners.GetHashCode();
        __r = __r*31 + (IconUrl != null ?IconUrl.GetHashCode() : 0);
        __r = __r*31 + (LicenseUrl != null ?LicenseUrl.GetHashCode() : 0);
        __r = __r*31 + (ProjectUrl != null ?ProjectUrl.GetHashCode() : 0);
        __r = __r*31 + (ReportAbuseUrl != null ?ReportAbuseUrl.GetHashCode() : 0);
        __r = __r*31 + Tags.GetHashCode();
        __r = __r*31 + (DownloadCount != null ?DownloadCount.GetHashCode() : 0);
        __r = __r*31 + CollectionUtil.GetHashCode(DependencySets);
        __r = __r*31 + RequireLicenseAcceptance.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetPackageMetadata (");
      using (printer.IndentCookie()) {
        printer.Print("identity = "); Identity.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("summary = "); Summary.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("authors = "); Authors.PrintEx(printer); printer.Println();
        printer.Print("owners = "); Owners.PrintEx(printer); printer.Println();
        printer.Print("iconUrl = "); IconUrl.PrintEx(printer); printer.Println();
        printer.Print("licenseUrl = "); LicenseUrl.PrintEx(printer); printer.Println();
        printer.Print("projectUrl = "); ProjectUrl.PrintEx(printer); printer.Println();
        printer.Print("reportAbuseUrl = "); ReportAbuseUrl.PrintEx(printer); printer.Println();
        printer.Print("tags = "); Tags.PrintEx(printer); printer.Println();
        printer.Print("downloadCount = "); DownloadCount.PrintEx(printer); printer.Println();
        printer.Print("dependencySets = "); DependencySets.PrintEx(printer); printer.Println();
        printer.Print("requireLicenseAcceptance = "); RequireLicenseAcceptance.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetPackageSource : IPrintable, IEquatable<RdNuGetPackageSource> {
    //fields
    [NotNull] public string Name {get; private set;}
    [NotNull] public string Source {get; private set;}
    public bool IsOfficial {get; private set;}
    public bool IsMachineWide {get; private set;}
    public bool IsEnabled {get; private set;}
    [CanBeNull] public string UserName {get; private set;}
    [CanBeNull] public string Password {get; private set;}
    public bool IsPasswordClearText {get; private set;}
    public int ProtocolVersion {get; private set;}
    
    //primary constructor
    public RdNuGetPackageSource(
      [NotNull] string name,
      [NotNull] string source,
      bool isOfficial,
      bool isMachineWide,
      bool isEnabled,
      [CanBeNull] string userName,
      [CanBeNull] string password,
      bool isPasswordClearText,
      int protocolVersion
    )
    {
      Name = name;
      Source = source;
      IsOfficial = isOfficial;
      IsMachineWide = isMachineWide;
      IsEnabled = isEnabled;
      UserName = userName;
      Password = password;
      IsPasswordClearText = isPasswordClearText;
      ProtocolVersion = protocolVersion;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<RdNuGetPackageSource> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var source = reader.ReadString();
      var isOfficial = reader.ReadBool();
      var isMachineWide = reader.ReadBool();
      var isEnabled = reader.ReadBool();
      var userName = ReadStringNullable(ctx, reader);
      var password = ReadStringNullable(ctx, reader);
      var isPasswordClearText = reader.ReadBool();
      var protocolVersion = reader.ReadInt();
      return new RdNuGetPackageSource(name, source, isOfficial, isMachineWide, isEnabled, userName, password, isPasswordClearText, protocolVersion);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<RdNuGetPackageSource> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      writer.Write(value.Source);
      writer.Write(value.IsOfficial);
      writer.Write(value.IsMachineWide);
      writer.Write(value.IsEnabled);
      WriteStringNullable(ctx, writer, value.UserName);
      WriteStringNullable(ctx, writer, value.Password);
      writer.Write(value.IsPasswordClearText);
      writer.Write(value.ProtocolVersion);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetPackageSource) obj);
    }
    public bool Equals(RdNuGetPackageSource other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Source == other.Source && IsOfficial == other.IsOfficial && IsMachineWide == other.IsMachineWide && IsEnabled == other.IsEnabled && Equals(UserName, other.UserName) && Equals(Password, other.Password) && IsPasswordClearText == other.IsPasswordClearText && ProtocolVersion == other.ProtocolVersion;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Name.GetHashCode();
        __r = __r*31 + Source.GetHashCode();
        __r = __r*31 + IsOfficial.GetHashCode();
        __r = __r*31 + IsMachineWide.GetHashCode();
        __r = __r*31 + IsEnabled.GetHashCode();
        __r = __r*31 + (UserName != null ?UserName.GetHashCode() : 0);
        __r = __r*31 + (Password != null ?Password.GetHashCode() : 0);
        __r = __r*31 + IsPasswordClearText.GetHashCode();
        __r = __r*31 + ProtocolVersion.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetPackageSource (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("source = "); Source.PrintEx(printer); printer.Println();
        printer.Print("isOfficial = "); IsOfficial.PrintEx(printer); printer.Println();
        printer.Print("isMachineWide = "); IsMachineWide.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("userName = "); UserName.PrintEx(printer); printer.Println();
        printer.Print("password = "); Password.PrintEx(printer); printer.Println();
        printer.Print("isPasswordClearText = "); IsPasswordClearText.PrintEx(printer); printer.Println();
        printer.Print("protocolVersion = "); ProtocolVersion.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetPackageSourceModel : RdBindableBase {
    //fields
    [NotNull] public string Key {get; private set;}
    [NotNull] public string Url {get; private set;}
    [NotNull] public IRdProperty<bool> IsSelected { get { return _IsSelected; }}
    [NotNull] private readonly RdProperty<bool> _IsSelected;
    
    //primary constructor
    private RdNuGetPackageSourceModel(
      [NotNull] string key,
      [NotNull] string url,
      [NotNull] RdProperty<bool> isSelected
    )
    {
      Key = key;
      Url = url;
      _IsSelected = isSelected;
      isSelected.OptimizeNested = true;
    }
    //secondary constructor
    public RdNuGetPackageSourceModel (
      [NotNull] string Key,
      [NotNull] string Url
    ) : this (
      Key,
      Url,
      new RdProperty<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdNuGetPackageSourceModel> Read = (ctx, reader) => 
    {
      var key = reader.ReadString();
      var url = reader.ReadString();
      var isSelected = RdProperty<bool>.Read(ctx, reader);
      return new RdNuGetPackageSourceModel(key, url, isSelected);
    };
    
    public static CtxWriteDelegate<RdNuGetPackageSourceModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Key);
      writer.Write(value.Url);
      RdProperty<bool>.Write(ctx, writer, value._IsSelected);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _IsSelected.BindEx(lifetime, this, "isSelected");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _IsSelected.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetPackageSourceModel (");
      using (printer.IndentCookie()) {
        printer.Print("key = "); Key.PrintEx(printer); printer.Println();
        printer.Print("url = "); Url.PrintEx(printer); printer.Println();
        printer.Print("isSelected = "); _IsSelected.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetPackageSources : RdBindableBase {
    //fields
    [NotNull] public List<RdNuGetPackageSourceModel> Items {get; private set;}
    
    //primary constructor
    public RdNuGetPackageSources(
      [NotNull] List<RdNuGetPackageSourceModel> items
    )
    {
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<RdNuGetPackageSourceModel>> ReadRdNuGetPackageSourceModelList = RdNuGetPackageSourceModel.Read.List();
    public static CtxReadDelegate<RdNuGetPackageSources> Read = (ctx, reader) => 
    {
      var items = ReadRdNuGetPackageSourceModelList(ctx, reader);
      return new RdNuGetPackageSources(items);
    };
    
    public static CtxWriteDelegate<List<RdNuGetPackageSourceModel>> WriteRdNuGetPackageSourceModelList = RdNuGetPackageSourceModel.Write.List();
    public static CtxWriteDelegate<RdNuGetPackageSources> Write = (ctx, writer, value) => 
    {
      WriteRdNuGetPackageSourceModelList(ctx, writer, value.Items);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Items.BindEx(lifetime, this, "items");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Items.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetPackageSources (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetPackageVersionInfo : RdBindableBase {
    //fields
    [NotNull] public string Version {get; private set;}
    [CanBeNull] public long? DownloadCount {get; private set;}
    
    //primary constructor
    public RdNuGetPackageVersionInfo(
      [NotNull] string version,
      [CanBeNull] long? downloadCount
    )
    {
      Version = version;
      DownloadCount = downloadCount;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<long?> ReadLongNullable = Serializers.ReadLong.NullableStruct();
    public static CtxReadDelegate<RdNuGetPackageVersionInfo> Read = (ctx, reader) => 
    {
      var version = reader.ReadString();
      var downloadCount = ReadLongNullable(ctx, reader);
      return new RdNuGetPackageVersionInfo(version, downloadCount);
    };
    
    public static CtxWriteDelegate<long?> WriteLongNullable = Serializers.WriteLong.NullableStruct();
    public static CtxWriteDelegate<RdNuGetPackageVersionInfo> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Version);
      WriteLongNullable(ctx, writer, value.DownloadCount);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetPackageVersionInfo (");
      using (printer.IndentCookie()) {
        printer.Print("version = "); Version.PrintEx(printer); printer.Println();
        printer.Print("downloadCount = "); DownloadCount.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetPackages : RdBindableBase {
    //fields
    [NotNull] public string Title {get; private set;}
    [NotNull] public List<RdNuGetBriefMetadata> Items {get; private set;}
    
    //primary constructor
    public RdNuGetPackages(
      [NotNull] string title,
      [NotNull] List<RdNuGetBriefMetadata> items
    )
    {
      Title = title;
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<RdNuGetBriefMetadata>> ReadRdNuGetBriefMetadataList = RdNuGetBriefMetadata.Read.List();
    public static CtxReadDelegate<RdNuGetPackages> Read = (ctx, reader) => 
    {
      var title = reader.ReadString();
      var items = ReadRdNuGetBriefMetadataList(ctx, reader);
      return new RdNuGetPackages(title, items);
    };
    
    public static CtxWriteDelegate<List<RdNuGetBriefMetadata>> WriteRdNuGetBriefMetadataList = RdNuGetBriefMetadata.Write.List();
    public static CtxWriteDelegate<RdNuGetPackages> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Title);
      WriteRdNuGetBriefMetadataList(ctx, writer, value.Items);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Items.BindEx(lifetime, this, "items");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Items.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetPackages (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetProjectInfo : RdBindableBase {
    //fields
    [NotNull] public List<RdNuGetBriefMetadata> Packages {get; private set;}
    
    //primary constructor
    public RdNuGetProjectInfo(
      [NotNull] List<RdNuGetBriefMetadata> packages
    )
    {
      Packages = packages;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<RdNuGetBriefMetadata>> ReadRdNuGetBriefMetadataList = RdNuGetBriefMetadata.Read.List();
    public static CtxReadDelegate<RdNuGetProjectInfo> Read = (ctx, reader) => 
    {
      var packages = ReadRdNuGetBriefMetadataList(ctx, reader);
      return new RdNuGetProjectInfo(packages);
    };
    
    public static CtxWriteDelegate<List<RdNuGetBriefMetadata>> WriteRdNuGetBriefMetadataList = RdNuGetBriefMetadata.Write.List();
    public static CtxWriteDelegate<RdNuGetProjectInfo> Write = (ctx, writer, value) => 
    {
      WriteRdNuGetBriefMetadataList(ctx, writer, value.Packages);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Packages.BindEx(lifetime, this, "packages");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Packages.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetProjectInfo (");
      using (printer.IndentCookie()) {
        printer.Print("packages = "); Packages.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetProjects : IPrintable, IEquatable<RdNuGetProjects> {
    //fields
    [NotNull] public List<int> ProjectIds {get; private set;}
    
    //primary constructor
    public RdNuGetProjects(
      [NotNull] List<int> projectIds
    )
    {
      ProjectIds = projectIds;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static CtxReadDelegate<RdNuGetProjects> Read = (ctx, reader) => 
    {
      var projectIds = ReadIntList(ctx, reader);
      return new RdNuGetProjects(projectIds);
    };
    
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static CtxWriteDelegate<RdNuGetProjects> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.ProjectIds);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetProjects) obj);
    }
    public bool Equals(RdNuGetProjects other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectIds.SequenceEqual(other.ProjectIds);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(ProjectIds);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetProjects (");
      using (printer.IndentCookie()) {
        printer.Print("projectIds = "); ProjectIds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetRestoreRequest : IPrintable, IEquatable<RdNuGetRestoreRequest> {
    //fields
    public bool IsSilent {get; private set;}
    
    //primary constructor
    public RdNuGetRestoreRequest(
      bool isSilent
    )
    {
      IsSilent = isSilent;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetRestoreRequest> Read = (ctx, reader) => 
    {
      var isSilent = reader.ReadBool();
      return new RdNuGetRestoreRequest(isSilent);
    };
    
    public static CtxWriteDelegate<RdNuGetRestoreRequest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IsSilent);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetRestoreRequest) obj);
    }
    public bool Equals(RdNuGetRestoreRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IsSilent == other.IsSilent;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + IsSilent.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetRestoreRequest (");
      using (printer.IndentCookie()) {
        printer.Print("isSilent = "); IsSilent.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetSettings : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<string> Info { get { return _Info; }}
    [NotNull] private readonly RdProperty<string> _Info;
    [NotNull] public IVoidSink Reload { get { return _Reload; }}
    [NotNull] private readonly RdVoidSignal _Reload;
    [NotNull] public IViewableMap<string, RdNuGetConfig> Configs { get { return _Configs; }}
    [NotNull] private readonly RdMap<string, RdNuGetConfig> _Configs;
    
    //primary constructor
    private RdNuGetSettings(
      [NotNull] RdProperty<string> info,
      [NotNull] RdVoidSignal reload,
      [NotNull] RdMap<string, RdNuGetConfig> configs
    )
    {
      _Info = info;
      _Reload = reload;
      _Configs = configs;
      info.OptimizeNested = true;
    }
    //secondary constructor
    public RdNuGetSettings (
    ) : this (
      new RdProperty<string>(),
      new RdVoidSignal(),
      new RdMap<string, RdNuGetConfig>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdNuGetSettings> Read = (ctx, reader) => 
    {
      var info = RdProperty<string>.Read(ctx, reader);
      var reload = RdVoidSignal.Read(ctx, reader);
      var configs = RdMap<string, RdNuGetConfig>.Read(ctx, reader);
      return new RdNuGetSettings(info, reload, configs);
    };
    
    public static CtxWriteDelegate<RdNuGetSettings> Write = (ctx, writer, value) => 
    {
      RdProperty<string>.Write(ctx, writer, value._Info);
      RdVoidSignal.Write(ctx, writer, value._Reload);
      RdMap<string, RdNuGetConfig>.Write(ctx, writer, value._Configs);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Info.BindEx(lifetime, this, "info");
      _Reload.BindEx(lifetime, this, "reload");
      _Configs.BindEx(lifetime, this, "configs");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Info.IdentifyEx(ids);
      _Reload.IdentifyEx(ids);
      _Configs.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetSettings (");
      using (printer.IndentCookie()) {
        printer.Print("info = "); _Info.PrintEx(printer); printer.Println();
        printer.Print("reload = "); _Reload.PrintEx(printer); printer.Println();
        printer.Print("configs = "); _Configs.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetStateInfo : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<bool> IsRestoring { get { return _IsRestoring; }}
    [NotNull] private readonly RdProperty<bool> _IsRestoring;
    [NotNull] public IRdProperty<bool> IsFetching { get { return _IsFetching; }}
    [NotNull] private readonly RdProperty<bool> _IsFetching;
    [NotNull] public IRdProperty<int> InstalledPackagesQueueSize { get { return _InstalledPackagesQueueSize; }}
    [NotNull] private readonly RdProperty<int> _InstalledPackagesQueueSize;
    [NotNull] public IRdProperty<int> InstalledPackagesProcessorCount { get { return _InstalledPackagesProcessorCount; }}
    [NotNull] private readonly RdProperty<int> _InstalledPackagesProcessorCount;
    [NotNull] public IRdProperty<double> Progress { get { return _Progress; }}
    [NotNull] private readonly RdProperty<double> _Progress;
    [NotNull] public IRdProperty<int> TotalFetched { get { return _TotalFetched; }}
    [NotNull] private readonly RdProperty<int> _TotalFetched;
    
    //primary constructor
    private RdNuGetStateInfo(
      [NotNull] RdProperty<bool> isRestoring,
      [NotNull] RdProperty<bool> isFetching,
      [NotNull] RdProperty<int> installedPackagesQueueSize,
      [NotNull] RdProperty<int> installedPackagesProcessorCount,
      [NotNull] RdProperty<double> progress,
      [NotNull] RdProperty<int> totalFetched
    )
    {
      _IsRestoring = isRestoring;
      _IsFetching = isFetching;
      _InstalledPackagesQueueSize = installedPackagesQueueSize;
      _InstalledPackagesProcessorCount = installedPackagesProcessorCount;
      _Progress = progress;
      _TotalFetched = totalFetched;
      isRestoring.OptimizeNested = true;
      isFetching.OptimizeNested = true;
      installedPackagesQueueSize.OptimizeNested = true;
      installedPackagesProcessorCount.OptimizeNested = true;
      progress.OptimizeNested = true;
      totalFetched.OptimizeNested = true;
    }
    //secondary constructor
    public RdNuGetStateInfo (
    ) : this (
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<int>(),
      new RdProperty<int>(),
      new RdProperty<double>(),
      new RdProperty<int>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdNuGetStateInfo> Read = (ctx, reader) => 
    {
      var isRestoring = RdProperty<bool>.Read(ctx, reader);
      var isFetching = RdProperty<bool>.Read(ctx, reader);
      var installedPackagesQueueSize = RdProperty<int>.Read(ctx, reader);
      var installedPackagesProcessorCount = RdProperty<int>.Read(ctx, reader);
      var progress = RdProperty<double>.Read(ctx, reader);
      var totalFetched = RdProperty<int>.Read(ctx, reader);
      return new RdNuGetStateInfo(isRestoring, isFetching, installedPackagesQueueSize, installedPackagesProcessorCount, progress, totalFetched);
    };
    
    public static CtxWriteDelegate<RdNuGetStateInfo> Write = (ctx, writer, value) => 
    {
      RdProperty<bool>.Write(ctx, writer, value._IsRestoring);
      RdProperty<bool>.Write(ctx, writer, value._IsFetching);
      RdProperty<int>.Write(ctx, writer, value._InstalledPackagesQueueSize);
      RdProperty<int>.Write(ctx, writer, value._InstalledPackagesProcessorCount);
      RdProperty<double>.Write(ctx, writer, value._Progress);
      RdProperty<int>.Write(ctx, writer, value._TotalFetched);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _IsRestoring.BindEx(lifetime, this, "isRestoring");
      _IsFetching.BindEx(lifetime, this, "isFetching");
      _InstalledPackagesQueueSize.BindEx(lifetime, this, "installedPackagesQueueSize");
      _InstalledPackagesProcessorCount.BindEx(lifetime, this, "installedPackagesProcessorCount");
      _Progress.BindEx(lifetime, this, "progress");
      _TotalFetched.BindEx(lifetime, this, "totalFetched");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _IsRestoring.IdentifyEx(ids);
      _IsFetching.IdentifyEx(ids);
      _InstalledPackagesQueueSize.IdentifyEx(ids);
      _InstalledPackagesProcessorCount.IdentifyEx(ids);
      _Progress.IdentifyEx(ids);
      _TotalFetched.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetStateInfo (");
      using (printer.IndentCookie()) {
        printer.Print("isRestoring = "); _IsRestoring.PrintEx(printer); printer.Println();
        printer.Print("isFetching = "); _IsFetching.PrintEx(printer); printer.Println();
        printer.Print("installedPackagesQueueSize = "); _InstalledPackagesQueueSize.PrintEx(printer); printer.Println();
        printer.Print("installedPackagesProcessorCount = "); _InstalledPackagesProcessorCount.PrintEx(printer); printer.Println();
        printer.Print("progress = "); _Progress.PrintEx(printer); printer.Println();
        printer.Print("totalFetched = "); _TotalFetched.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetUninstallRequest : IPrintable, IEquatable<RdNuGetUninstallRequest> {
    //fields
    [NotNull] public RdNuGetProjects Projects {get; private set;}
    [NotNull] public string PackageId {get; private set;}
    
    //primary constructor
    public RdNuGetUninstallRequest(
      [NotNull] RdNuGetProjects projects,
      [NotNull] string packageId
    )
    {
      Projects = projects;
      PackageId = packageId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetUninstallRequest> Read = (ctx, reader) => 
    {
      var projects = RdNuGetProjects.Read(ctx, reader);
      var packageId = reader.ReadString();
      return new RdNuGetUninstallRequest(projects, packageId);
    };
    
    public static CtxWriteDelegate<RdNuGetUninstallRequest> Write = (ctx, writer, value) => 
    {
      RdNuGetProjects.Write(ctx, writer, value.Projects);
      writer.Write(value.PackageId);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetUninstallRequest) obj);
    }
    public bool Equals(RdNuGetUninstallRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Projects, other.Projects) && PackageId == other.PackageId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Projects.GetHashCode();
        __r = __r*31 + PackageId.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetUninstallRequest (");
      using (printer.IndentCookie()) {
        printer.Print("projects = "); Projects.PrintEx(printer); printer.Println();
        printer.Print("packageId = "); PackageId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNuGetUpgradeAllRequest : IPrintable, IEquatable<RdNuGetUpgradeAllRequest> {
    //fields
    [NotNull] public RdNuGetProjects Projects {get; private set;}
    
    //primary constructor
    public RdNuGetUpgradeAllRequest(
      [NotNull] RdNuGetProjects projects
    )
    {
      Projects = projects;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdNuGetUpgradeAllRequest> Read = (ctx, reader) => 
    {
      var projects = RdNuGetProjects.Read(ctx, reader);
      return new RdNuGetUpgradeAllRequest(projects);
    };
    
    public static CtxWriteDelegate<RdNuGetUpgradeAllRequest> Write = (ctx, writer, value) => 
    {
      RdNuGetProjects.Write(ctx, writer, value.Projects);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetUpgradeAllRequest) obj);
    }
    public bool Equals(RdNuGetUpgradeAllRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Projects, other.Projects);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Projects.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetUpgradeAllRequest (");
      using (printer.IndentCookie()) {
        printer.Print("projects = "); Projects.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdNuGetVersionConstraints {
    None,
    ExactMajor,
    ExactMinor,
    ExactPatch,
    ExactRelease
  }
  
  
  public class RdNuGetVersionRange : IPrintable, IEquatable<RdNuGetVersionRange> {
    //fields
    [CanBeNull] public string MinVersion {get; private set;}
    [CanBeNull] public string MaxVersion {get; private set;}
    
    //primary constructor
    public RdNuGetVersionRange(
      [CanBeNull] string minVersion,
      [CanBeNull] string maxVersion
    )
    {
      MinVersion = minVersion;
      MaxVersion = maxVersion;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<RdNuGetVersionRange> Read = (ctx, reader) => 
    {
      var minVersion = ReadStringNullable(ctx, reader);
      var maxVersion = ReadStringNullable(ctx, reader);
      return new RdNuGetVersionRange(minVersion, maxVersion);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<RdNuGetVersionRange> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.MinVersion);
      WriteStringNullable(ctx, writer, value.MaxVersion);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNuGetVersionRange) obj);
    }
    public bool Equals(RdNuGetVersionRange other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(MinVersion, other.MinVersion) && Equals(MaxVersion, other.MaxVersion);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (MinVersion != null ?MinVersion.GetHashCode() : 0);
        __r = __r*31 + (MaxVersion != null ?MaxVersion.GetHashCode() : 0);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNuGetVersionRange (");
      using (printer.IndentCookie()) {
        printer.Print("minVersion = "); MinVersion.PrintEx(printer); printer.Println();
        printer.Print("maxVersion = "); MaxVersion.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNullLocation : RdProjectModelItemLocation
   {
    //fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdNullLocation> Read = (ctx, reader) => 
    {
      return new RdNullLocation();
    };
    
    public static new CtxWriteDelegate<RdNullLocation> Write = (ctx, writer, value) => 
    {
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNullLocation) obj);
    }
    public bool Equals(RdNullLocation other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNullLocation (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdOperationResult : IPrintable, IEquatable<RdOperationResult> {
    //fields
    public bool Success {get; private set;}
    [CanBeNull] public string Error {get; private set;}
    
    //primary constructor
    public RdOperationResult(
      bool success,
      [CanBeNull] string error
    )
    {
      Success = success;
      Error = error;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<RdOperationResult> Read = (ctx, reader) => 
    {
      var success = reader.ReadBool();
      var error = ReadStringNullable(ctx, reader);
      return new RdOperationResult(success, error);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<RdOperationResult> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Success);
      WriteStringNullable(ctx, writer, value.Error);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdOperationResult) obj);
    }
    public bool Equals(RdOperationResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Success == other.Success && Equals(Error, other.Error);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Success.GetHashCode();
        __r = __r*31 + (Error != null ?Error.GetHashCode() : 0);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdOperationResult (");
      using (printer.IndentCookie()) {
        printer.Print("success = "); Success.PrintEx(printer); printer.Println();
        printer.Print("error = "); Error.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectDescriptor : RdProjectModelItemDescriptor
   {
    //fields
    public RdProjectState State {get; private set;}
    public bool DirectoryBased {get; private set;}
    
    //primary constructor
    public RdProjectDescriptor(
      RdProjectState state,
      bool directoryBased,
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
      State = state;
      DirectoryBased = directoryBased;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdProjectDescriptor> Read = (ctx, reader) => 
    {
      var state = (RdProjectState)reader.ReadInt();
      var directoryBased = reader.ReadBool();
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      return new RdProjectDescriptor(state, directoryBased, name, location);
    };
    
    public static new CtxWriteDelegate<RdProjectDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.State);
      writer.Write(value.DirectoryBased);
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectDescriptor) obj);
    }
    public bool Equals(RdProjectDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return State == other.State && DirectoryBased == other.DirectoryBased && Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (int) State;
        __r = __r*31 + DirectoryBased.GetHashCode();
        __r = __r*31 + Name.GetHashCode();
        __r = __r*31 + Location.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("state = "); State.PrintEx(printer); printer.Println();
        printer.Print("directoryBased = "); DirectoryBased.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectFileDescriptor : RdProjectModelItemDescriptor
   {
    //fields
    public bool IsInternal {get; private set;}
    
    //primary constructor
    public RdProjectFileDescriptor(
      bool isInternal,
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
      IsInternal = isInternal;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdProjectFileDescriptor> Read = (ctx, reader) => 
    {
      var isInternal = reader.ReadBool();
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      return new RdProjectFileDescriptor(isInternal, name, location);
    };
    
    public static new CtxWriteDelegate<RdProjectFileDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IsInternal);
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectFileDescriptor) obj);
    }
    public bool Equals(RdProjectFileDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IsInternal == other.IsInternal && Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + IsInternal.GetHashCode();
        __r = __r*31 + Name.GetHashCode();
        __r = __r*31 + Location.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectFileDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("isInternal = "); IsInternal.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectFolderDescriptor : RdProjectModelItemDescriptor
   {
    //fields
    public bool IsInternal {get; private set;}
    public bool AllowsNonExistence {get; private set;}
    
    //primary constructor
    public RdProjectFolderDescriptor(
      bool isInternal,
      bool allowsNonExistence,
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
      IsInternal = isInternal;
      AllowsNonExistence = allowsNonExistence;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdProjectFolderDescriptor> Read = (ctx, reader) => 
    {
      var isInternal = reader.ReadBool();
      var allowsNonExistence = reader.ReadBool();
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      return new RdProjectFolderDescriptor(isInternal, allowsNonExistence, name, location);
    };
    
    public static new CtxWriteDelegate<RdProjectFolderDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IsInternal);
      writer.Write(value.AllowsNonExistence);
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectFolderDescriptor) obj);
    }
    public bool Equals(RdProjectFolderDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IsInternal == other.IsInternal && AllowsNonExistence == other.AllowsNonExistence && Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + IsInternal.GetHashCode();
        __r = __r*31 + AllowsNonExistence.GetHashCode();
        __r = __r*31 + Name.GetHashCode();
        __r = __r*31 + Location.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectFolderDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("isInternal = "); IsInternal.PrintEx(printer); printer.Println();
        printer.Print("allowsNonExistence = "); AllowsNonExistence.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectModelItem : RdBindableBase {
    //fields
    [CanBeNull] public int? ParentId {get; private set;}
    [NotNull] public RdProjectModelItemDescriptor Descriptor {get; private set;}
    
    //primary constructor
    public RdProjectModelItem(
      [CanBeNull] int? parentId,
      [NotNull] RdProjectModelItemDescriptor descriptor
    )
    {
      ParentId = parentId;
      Descriptor = descriptor;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<int?> ReadIntNullable = Serializers.ReadInt.NullableStruct();
    public static CtxReadDelegate<RdProjectModelItem> Read = (ctx, reader) => 
    {
      var parentId = ReadIntNullable(ctx, reader);
      var descriptor = RdProjectModelItemDescriptor.Read(ctx, reader);
      return new RdProjectModelItem(parentId, descriptor);
    };
    
    public static CtxWriteDelegate<int?> WriteIntNullable = Serializers.WriteInt.NullableStruct();
    public static CtxWriteDelegate<RdProjectModelItem> Write = (ctx, writer, value) => 
    {
      WriteIntNullable(ctx, writer, value.ParentId);
      RdProjectModelItemDescriptor.Write(ctx, writer, value.Descriptor);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectModelItem (");
      using (printer.IndentCookie()) {
        printer.Print("parentId = "); ParentId.PrintEx(printer); printer.Println();
        printer.Print("descriptor = "); Descriptor.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdProjectModelItemDescriptor {
    //fields
    [NotNull] public string Name {get; private set;}
    [NotNull] public RdProjectModelItemLocation Location {get; private set;}
    
    //primary constructor
    protected RdProjectModelItemDescriptor(
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    )
    {
      Name = name;
      Location = location;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdProjectModelItemDescriptor> Read = (ctx, reader) => ctx.Serializers.Read<RdProjectModelItemDescriptor>(ctx, reader);
    
    public static CtxWriteDelegate<RdProjectModelItemDescriptor> Write = (ctx, writer, value) => ctx.Serializers.Write<RdProjectModelItemDescriptor>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public abstract class RdProjectModelItemLocation {
    //fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdProjectModelItemLocation> Read = (ctx, reader) => ctx.Serializers.Read<RdProjectModelItemLocation>(ctx, reader);
    
    public static CtxWriteDelegate<RdProjectModelItemLocation> Write = (ctx, writer, value) => ctx.Serializers.Write<RdProjectModelItemLocation>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdProjectModelSyncData : IPrintable, IEquatable<RdProjectModelSyncData> {
    //fields
    [NotNull] public List<string> ExcludedPaths {get; private set;}
    
    //primary constructor
    public RdProjectModelSyncData(
      [NotNull] List<string> excludedPaths
    )
    {
      ExcludedPaths = excludedPaths;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static CtxReadDelegate<RdProjectModelSyncData> Read = (ctx, reader) => 
    {
      var excludedPaths = ReadStringList(ctx, reader);
      return new RdProjectModelSyncData(excludedPaths);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static CtxWriteDelegate<RdProjectModelSyncData> Write = (ctx, writer, value) => 
    {
      WriteStringList(ctx, writer, value.ExcludedPaths);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectModelSyncData) obj);
    }
    public bool Equals(RdProjectModelSyncData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ExcludedPaths.SequenceEqual(other.ExcludedPaths);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(ExcludedPaths);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectModelSyncData (");
      using (printer.IndentCookie()) {
        printer.Print("excludedPaths = "); ExcludedPaths.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectModelView : RdBindableBase {
    //fields
    [NotNull] public IViewableMap<int, RdProjectModelItem> Items { get { return _Items; }}
    [NotNull] private readonly RdMap<int, RdProjectModelItem> _Items;
    [NotNull] public IRdProperty<bool> UpdateCookie { get { return _UpdateCookie; }}
    [NotNull] private readonly RdProperty<bool> _UpdateCookie;
    [NotNull] public ISource<int> UpdateView { get { return _UpdateView; }}
    [NotNull] private readonly RdSignal<int> _UpdateView;
    [NotNull] public ISource<RdProjectModelSyncData> Sync { get { return _Sync; }}
    [NotNull] private readonly RdSignal<RdProjectModelSyncData> _Sync;
    [NotNull] public RdEndpoint<int, bool> Expand { get { return _Expand; }}
    [NotNull] private readonly RdEndpoint<int, bool> _Expand;
    
    //primary constructor
    private RdProjectModelView(
      [NotNull] RdMap<int, RdProjectModelItem> items,
      [NotNull] RdProperty<bool> updateCookie,
      [NotNull] RdSignal<int> updateView,
      [NotNull] RdSignal<RdProjectModelSyncData> sync,
      [NotNull] RdEndpoint<int, bool> expand
    )
    {
      _Items = items;
      _UpdateCookie = updateCookie;
      _UpdateView = updateView;
      _Sync = sync;
      _Expand = expand;
      updateCookie.OptimizeNested = true;
    }
    //secondary constructor
    public RdProjectModelView (
    ) : this (
      new RdMap<int, RdProjectModelItem>(),
      new RdProperty<bool>(),
      new RdSignal<int>(),
      new RdSignal<RdProjectModelSyncData>(),
      new RdEndpoint<int, bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdProjectModelView> Read = (ctx, reader) => 
    {
      var items = RdMap<int, RdProjectModelItem>.Read(ctx, reader);
      var updateCookie = RdProperty<bool>.Read(ctx, reader);
      var updateView = RdSignal<int>.Read(ctx, reader);
      var sync = RdSignal<RdProjectModelSyncData>.Read(ctx, reader);
      var expand = RdEndpoint<int, bool>.Read(ctx, reader);
      return new RdProjectModelView(items, updateCookie, updateView, sync, expand);
    };
    
    public static CtxWriteDelegate<RdProjectModelView> Write = (ctx, writer, value) => 
    {
      RdMap<int, RdProjectModelItem>.Write(ctx, writer, value._Items);
      RdProperty<bool>.Write(ctx, writer, value._UpdateCookie);
      RdSignal<int>.Write(ctx, writer, value._UpdateView);
      RdSignal<RdProjectModelSyncData>.Write(ctx, writer, value._Sync);
      RdEndpoint<int, bool>.Write(ctx, writer, value._Expand);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Items.BindEx(lifetime, this, "items");
      _UpdateCookie.BindEx(lifetime, this, "updateCookie");
      _UpdateView.BindEx(lifetime, this, "updateView");
      _Sync.BindEx(lifetime, this, "sync");
      _Expand.BindEx(lifetime, this, "expand");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Items.IdentifyEx(ids);
      _UpdateCookie.IdentifyEx(ids);
      _UpdateView.IdentifyEx(ids);
      _Sync.IdentifyEx(ids);
      _Expand.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectModelView (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); _Items.PrintEx(printer); printer.Println();
        printer.Print("updateCookie = "); _UpdateCookie.PrintEx(printer); printer.Println();
        printer.Print("updateView = "); _UpdateView.PrintEx(printer); printer.Println();
        printer.Print("sync = "); _Sync.PrintEx(printer); printer.Println();
        printer.Print("expand = "); _Expand.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectReferenceDescriptor : RdProjectModelItemDescriptor
   {
    //fields
    //primary constructor
    public RdProjectReferenceDescriptor(
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdProjectReferenceDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      return new RdProjectReferenceDescriptor(name, location);
    };
    
    public static new CtxWriteDelegate<RdProjectReferenceDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectReferenceDescriptor) obj);
    }
    public bool Equals(RdProjectReferenceDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Name.GetHashCode();
        __r = __r*31 + Location.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectReferenceDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdProjectState {
    Loading,
    Reloading,
    Unloading,
    RestoringPackages,
    WithMissingPackages,
    WithErrors,
    WithWarnings,
    Ready
  }
  
  
  public class RdPsiElementRangeProvider : RdBindableBase {
    //fields
    [NotNull] public RdEndpoint<HyperlinkHighlightingArgs, HyperlinkHighlightingResult> GetElementRange { get { return _GetElementRange; }}
    [NotNull] private readonly RdEndpoint<HyperlinkHighlightingArgs, HyperlinkHighlightingResult> _GetElementRange;
    
    //primary constructor
    private RdPsiElementRangeProvider(
      [NotNull] RdEndpoint<HyperlinkHighlightingArgs, HyperlinkHighlightingResult> getElementRange
    )
    {
      _GetElementRange = getElementRange;
    }
    //secondary constructor
    public RdPsiElementRangeProvider (
    ) : this (
      new RdEndpoint<HyperlinkHighlightingArgs, HyperlinkHighlightingResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<HyperlinkHighlightingResult> ReadHyperlinkHighlightingResultNullable = HyperlinkHighlightingResult.Read.NullableClass();
    public static CtxReadDelegate<RdPsiElementRangeProvider> Read = (ctx, reader) => 
    {
      var getElementRange = RdEndpoint<HyperlinkHighlightingArgs, HyperlinkHighlightingResult>.Read(ctx, reader);
      return new RdPsiElementRangeProvider(getElementRange);
    };
    
    public static CtxWriteDelegate<HyperlinkHighlightingResult> WriteHyperlinkHighlightingResultNullable = HyperlinkHighlightingResult.Write.NullableClass();
    public static CtxWriteDelegate<RdPsiElementRangeProvider> Write = (ctx, writer, value) => 
    {
      RdEndpoint<HyperlinkHighlightingArgs, HyperlinkHighlightingResult>.Write(ctx, writer, value._GetElementRange);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _GetElementRange.BindEx(lifetime, this, "getElementRange");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _GetElementRange.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdPsiElementRangeProvider (");
      using (printer.IndentCookie()) {
        printer.Print("getElementRange = "); _GetElementRange.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdReferenceFolderDescriptor : RdProjectModelItemDescriptor
   {
    //fields
    public bool IsInternal {get; private set;}
    
    //primary constructor
    public RdReferenceFolderDescriptor(
      bool isInternal,
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
      IsInternal = isInternal;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdReferenceFolderDescriptor> Read = (ctx, reader) => 
    {
      var isInternal = reader.ReadBool();
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      return new RdReferenceFolderDescriptor(isInternal, name, location);
    };
    
    public static new CtxWriteDelegate<RdReferenceFolderDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IsInternal);
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdReferenceFolderDescriptor) obj);
    }
    public bool Equals(RdReferenceFolderDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IsInternal == other.IsInternal && Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + IsInternal.GetHashCode();
        __r = __r*31 + Name.GetHashCode();
        __r = __r*31 + Location.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdReferenceFolderDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("isInternal = "); IsInternal.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdRefreshRequest : IPrintable, IEquatable<RdRefreshRequest> {
    //fields
    [NotNull] public List<string> Paths {get; private set;}
    public bool Async {get; private set;}
    
    //primary constructor
    public RdRefreshRequest(
      [NotNull] List<string> paths,
      bool async
    )
    {
      Paths = paths;
      Async = async;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static CtxReadDelegate<RdRefreshRequest> Read = (ctx, reader) => 
    {
      var paths = ReadStringList(ctx, reader);
      var async = reader.ReadBool();
      return new RdRefreshRequest(paths, async);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static CtxWriteDelegate<RdRefreshRequest> Write = (ctx, writer, value) => 
    {
      WriteStringList(ctx, writer, value.Paths);
      writer.Write(value.Async);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdRefreshRequest) obj);
    }
    public bool Equals(RdRefreshRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Paths.SequenceEqual(other.Paths) && Async == other.Async;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(Paths);
        __r = __r*31 + Async.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdRefreshRequest (");
      using (printer.IndentCookie()) {
        printer.Print("paths = "); Paths.PrintEx(printer); printer.Println();
        printer.Print("async = "); Async.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdSolutionDescriptor : RdProjectModelItemDescriptor
   {
    //fields
    public RdSolutionState State {get; private set;}
    public int ProjectsCount {get; private set;}
    [NotNull] public List<string> Errors {get; private set;}
    
    //primary constructor
    public RdSolutionDescriptor(
      RdSolutionState state,
      int projectsCount,
      [NotNull] List<string> errors,
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
      State = state;
      ProjectsCount = projectsCount;
      Errors = errors;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static new CtxReadDelegate<RdSolutionDescriptor> Read = (ctx, reader) => 
    {
      var state = (RdSolutionState)reader.ReadInt();
      var projectsCount = reader.ReadInt();
      var errors = ReadStringList(ctx, reader);
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      return new RdSolutionDescriptor(state, projectsCount, errors, name, location);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static new CtxWriteDelegate<RdSolutionDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.State);
      writer.Write(value.ProjectsCount);
      WriteStringList(ctx, writer, value.Errors);
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdSolutionDescriptor) obj);
    }
    public bool Equals(RdSolutionDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return State == other.State && ProjectsCount == other.ProjectsCount && Errors.SequenceEqual(other.Errors) && Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (int) State;
        __r = __r*31 + ProjectsCount.GetHashCode();
        __r = __r*31 + CollectionUtil.GetHashCode(Errors);
        __r = __r*31 + Name.GetHashCode();
        __r = __r*31 + Location.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdSolutionDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("state = "); State.PrintEx(printer); printer.Println();
        printer.Print("projectsCount = "); ProjectsCount.PrintEx(printer); printer.Println();
        printer.Print("errors = "); Errors.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdSolutionFolderDescriptor : RdProjectModelItemDescriptor
   {
    //fields
    //primary constructor
    public RdSolutionFolderDescriptor(
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdSolutionFolderDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      return new RdSolutionFolderDescriptor(name, location);
    };
    
    public static new CtxWriteDelegate<RdSolutionFolderDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdSolutionFolderDescriptor) obj);
    }
    public bool Equals(RdSolutionFolderDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Name.GetHashCode();
        __r = __r*31 + Location.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdSolutionFolderDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdSolutionState {
    Loading,
    Reloading,
    Ready
  }
  
  
  public class RdSpecialPath : RdBindableBase {
    //fields
    [NotNull] public string Id {get; private set;}
    [NotNull] public string Description {get; private set;}
    [NotNull] public string FullPath {get; private set;}
    public RdSpecialPathKind Kind {get; private set;}
    
    //primary constructor
    public RdSpecialPath(
      [NotNull] string id,
      [NotNull] string description,
      [NotNull] string fullPath,
      RdSpecialPathKind kind
    )
    {
      Id = id;
      Description = description;
      FullPath = fullPath;
      Kind = kind;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdSpecialPath> Read = (ctx, reader) => 
    {
      var id = reader.ReadString();
      var description = reader.ReadString();
      var fullPath = reader.ReadString();
      var kind = (RdSpecialPathKind)reader.ReadInt();
      return new RdSpecialPath(id, description, fullPath, kind);
    };
    
    public static CtxWriteDelegate<RdSpecialPath> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.Description);
      writer.Write(value.FullPath);
      writer.Write((int)value.Kind);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdSpecialPath (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("fullPath = "); FullPath.PrintEx(printer); printer.Println();
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdSpecialPathKind {
    File,
    Folder
  }
  
  
  public class RdTextEditingGateway : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<JetBrains.Rider.Model.GatewayState> GatewayState { get { return _GatewayState; }}
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.GatewayState> _GatewayState;
    
    //primary constructor
    private RdTextEditingGateway(
      [NotNull] RdProperty<JetBrains.Rider.Model.GatewayState> gatewayState
    )
    {
      _GatewayState = gatewayState;
      gatewayState.OptimizeNested = true;
    }
    //secondary constructor
    public RdTextEditingGateway (
    ) : this (
      new RdProperty<JetBrains.Rider.Model.GatewayState>()
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.GatewayState> ReadGatewayState = new CtxReadDelegate<GatewayState>(Serializers.ReadEnum<GatewayState>);
    public static CtxReadDelegate<RdTextEditingGateway> Read = (ctx, reader) => 
    {
      var gatewayState = RdProperty<JetBrains.Rider.Model.GatewayState>.Read(ctx, reader);
      return new RdTextEditingGateway(gatewayState);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.GatewayState> WriteGatewayState = new CtxWriteDelegate<GatewayState>(Serializers.WriteEnum<GatewayState>);
    public static CtxWriteDelegate<RdTextEditingGateway> Write = (ctx, writer, value) => 
    {
      RdProperty<JetBrains.Rider.Model.GatewayState>.Write(ctx, writer, value._GatewayState);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _GatewayState.BindEx(lifetime, this, "gatewayState");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _GatewayState.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdTextEditingGateway (");
      using (printer.IndentCookie()) {
        printer.Print("gatewayState = "); _GatewayState.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdTextRange : IPrintable, IEquatable<RdTextRange> {
    //fields
    public int StartOffset {get; private set;}
    public int EndOffset {get; private set;}
    
    //primary constructor
    public RdTextRange(
      int startOffset,
      int endOffset
    )
    {
      StartOffset = startOffset;
      EndOffset = endOffset;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdTextRange> Read = (ctx, reader) => 
    {
      var startOffset = reader.ReadInt();
      var endOffset = reader.ReadInt();
      return new RdTextRange(startOffset, endOffset);
    };
    
    public static CtxWriteDelegate<RdTextRange> Write = (ctx, writer, value) => 
    {
      writer.Write(value.StartOffset);
      writer.Write(value.EndOffset);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdTextRange) obj);
    }
    public bool Equals(RdTextRange other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return StartOffset == other.StartOffset && EndOffset == other.EndOffset;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + StartOffset.GetHashCode();
        __r = __r*31 + EndOffset.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdTextRange (");
      using (printer.IndentCookie()) {
        printer.Print("startOffset = "); StartOffset.PrintEx(printer); printer.Println();
        printer.Print("endOffset = "); EndOffset.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdTypingAssistHost : RdBindableBase {
    //fields
    [NotNull] public RdEndpoint<TypeData, bool> EmulateType { get { return _EmulateType; }}
    [NotNull] private readonly RdEndpoint<TypeData, bool> _EmulateType;
    [NotNull] public ISink<TypeData> ReadonlyType { get { return _ReadonlyType; }}
    [NotNull] private readonly RdSignal<TypeData> _ReadonlyType;
    
    //primary constructor
    private RdTypingAssistHost(
      [NotNull] RdEndpoint<TypeData, bool> emulateType,
      [NotNull] RdSignal<TypeData> readonlyType
    )
    {
      _EmulateType = emulateType;
      _ReadonlyType = readonlyType;
    }
    //secondary constructor
    public RdTypingAssistHost (
    ) : this (
      new RdEndpoint<TypeData, bool>(),
      new RdSignal<TypeData>()
    ) {}
    //statics
    
    public static CtxReadDelegate<TypeData> ReadTypeDataNullable = TypeData.Read.NullableClass();
    public static CtxReadDelegate<RdTypingAssistHost> Read = (ctx, reader) => 
    {
      var emulateType = RdEndpoint<TypeData, bool>.Read(ctx, reader);
      var readonlyType = RdSignal<TypeData>.Read(ctx, reader);
      return new RdTypingAssistHost(emulateType, readonlyType);
    };
    
    public static CtxWriteDelegate<TypeData> WriteTypeDataNullable = TypeData.Write.NullableClass();
    public static CtxWriteDelegate<RdTypingAssistHost> Write = (ctx, writer, value) => 
    {
      RdEndpoint<TypeData, bool>.Write(ctx, writer, value._EmulateType);
      RdSignal<TypeData>.Write(ctx, writer, value._ReadonlyType);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _EmulateType.BindEx(lifetime, this, "emulateType");
      _ReadonlyType.BindEx(lifetime, this, "readonlyType");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _EmulateType.IdentifyEx(ids);
      _ReadonlyType.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdTypingAssistHost (");
      using (printer.IndentCookie()) {
        printer.Print("emulateType = "); _EmulateType.PrintEx(printer); printer.Println();
        printer.Print("readonlyType = "); _ReadonlyType.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUniTestLaunchMessage : IPrintable, IEquatable<RdUniTestLaunchMessage> {
    //fields
    [NotNull] public string Session {get; private set;}
    [NotNull] public string Message {get; private set;}
    
    //primary constructor
    public RdUniTestLaunchMessage(
      [NotNull] string session,
      [NotNull] string message
    )
    {
      Session = session;
      Message = message;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUniTestLaunchMessage> Read = (ctx, reader) => 
    {
      var session = reader.ReadString();
      var message = reader.ReadString();
      return new RdUniTestLaunchMessage(session, message);
    };
    
    public static CtxWriteDelegate<RdUniTestLaunchMessage> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Session);
      writer.Write(value.Message);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUniTestLaunchMessage) obj);
    }
    public bool Equals(RdUniTestLaunchMessage other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Session == other.Session && Message == other.Message;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Session.GetHashCode();
        __r = __r*31 + Message.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUniTestLaunchMessage (");
      using (printer.IndentCookie()) {
        printer.Print("session = "); Session.PrintEx(printer); printer.Println();
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestElement : IPrintable, IEquatable<RdUnitTestElement> {
    //fields
    public int ElementId {get; private set;}
    [NotNull] public string ElementFullId {get; private set;}
    [NotNull] public string FrameworkId {get; private set;}
    [CanBeNull] public Icon OwnIcon {get; private set;}
    public int ParentElementId {get; private set;}
    [NotNull] public List<int> ProjectIds {get; private set;}
    [NotNull] public string Presentation {get; private set;}
    
    //primary constructor
    public RdUnitTestElement(
      int elementId,
      [NotNull] string elementFullId,
      [NotNull] string frameworkId,
      [CanBeNull] Icon ownIcon,
      int parentElementId,
      [NotNull] List<int> projectIds,
      [NotNull] string presentation
    )
    {
      ElementId = elementId;
      ElementFullId = elementFullId;
      FrameworkId = frameworkId;
      OwnIcon = ownIcon;
      ParentElementId = parentElementId;
      ProjectIds = projectIds;
      Presentation = presentation;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<Icon> ReadIconNullable = Icon.Read.NullableClass();
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static CtxReadDelegate<RdUnitTestElement> Read = (ctx, reader) => 
    {
      var elementId = reader.ReadInt();
      var elementFullId = reader.ReadString();
      var frameworkId = reader.ReadString();
      var ownIcon = ReadIconNullable(ctx, reader);
      var parentElementId = reader.ReadInt();
      var projectIds = ReadIntList(ctx, reader);
      var presentation = reader.ReadString();
      return new RdUnitTestElement(elementId, elementFullId, frameworkId, ownIcon, parentElementId, projectIds, presentation);
    };
    
    public static CtxWriteDelegate<Icon> WriteIconNullable = Icon.Write.NullableClass();
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static CtxWriteDelegate<RdUnitTestElement> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ElementId);
      writer.Write(value.ElementFullId);
      writer.Write(value.FrameworkId);
      WriteIconNullable(ctx, writer, value.OwnIcon);
      writer.Write(value.ParentElementId);
      WriteIntList(ctx, writer, value.ProjectIds);
      writer.Write(value.Presentation);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestElement) obj);
    }
    public bool Equals(RdUnitTestElement other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ElementId == other.ElementId && ElementFullId == other.ElementFullId && FrameworkId == other.FrameworkId && Equals(OwnIcon, other.OwnIcon) && ParentElementId == other.ParentElementId && ProjectIds.SequenceEqual(other.ProjectIds) && Presentation == other.Presentation;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + ElementId.GetHashCode();
        __r = __r*31 + ElementFullId.GetHashCode();
        __r = __r*31 + FrameworkId.GetHashCode();
        __r = __r*31 + (OwnIcon != null ?OwnIcon.GetHashCode() : 0);
        __r = __r*31 + ParentElementId.GetHashCode();
        __r = __r*31 + CollectionUtil.GetHashCode(ProjectIds);
        __r = __r*31 + Presentation.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestElement (");
      using (printer.IndentCookie()) {
        printer.Print("elementId = "); ElementId.PrintEx(printer); printer.Println();
        printer.Print("elementFullId = "); ElementFullId.PrintEx(printer); printer.Println();
        printer.Print("frameworkId = "); FrameworkId.PrintEx(printer); printer.Println();
        printer.Print("ownIcon = "); OwnIcon.PrintEx(printer); printer.Println();
        printer.Print("parentElementId = "); ParentElementId.PrintEx(printer); printer.Println();
        printer.Print("projectIds = "); ProjectIds.PrintEx(printer); printer.Println();
        printer.Print("presentation = "); Presentation.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestElementList : IPrintable, IEquatable<RdUnitTestElementList> {
    //fields
    [NotNull] public List<int> ElementIds {get; private set;}
    
    //primary constructor
    public RdUnitTestElementList(
      [NotNull] List<int> elementIds
    )
    {
      ElementIds = elementIds;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static CtxReadDelegate<RdUnitTestElementList> Read = (ctx, reader) => 
    {
      var elementIds = ReadIntList(ctx, reader);
      return new RdUnitTestElementList(elementIds);
    };
    
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static CtxWriteDelegate<RdUnitTestElementList> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.ElementIds);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestElementList) obj);
    }
    public bool Equals(RdUnitTestElementList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ElementIds.SequenceEqual(other.ElementIds);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(ElementIds);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestElementList (");
      using (printer.IndentCookie()) {
        printer.Print("elementIds = "); ElementIds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestElementManager : RdBindableBase {
    //fields
    [NotNull] public ISource<RdUnitTestElementSet> ElementsUpdated { get { return _ElementsUpdated; }}
    [NotNull] private readonly RdSignal<RdUnitTestElementSet> _ElementsUpdated;
    [NotNull] public ISource<RdUnitTestElementList> ElementsRemoved { get { return _ElementsRemoved; }}
    [NotNull] private readonly RdSignal<RdUnitTestElementList> _ElementsRemoved;
    
    //primary constructor
    private RdUnitTestElementManager(
      [NotNull] RdSignal<RdUnitTestElementSet> elementsUpdated,
      [NotNull] RdSignal<RdUnitTestElementList> elementsRemoved
    )
    {
      _ElementsUpdated = elementsUpdated;
      _ElementsRemoved = elementsRemoved;
    }
    //secondary constructor
    public RdUnitTestElementManager (
    ) : this (
      new RdSignal<RdUnitTestElementSet>(),
      new RdSignal<RdUnitTestElementList>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdUnitTestElementManager> Read = (ctx, reader) => 
    {
      var elementsUpdated = RdSignal<RdUnitTestElementSet>.Read(ctx, reader);
      var elementsRemoved = RdSignal<RdUnitTestElementList>.Read(ctx, reader);
      return new RdUnitTestElementManager(elementsUpdated, elementsRemoved);
    };
    
    public static CtxWriteDelegate<RdUnitTestElementManager> Write = (ctx, writer, value) => 
    {
      RdSignal<RdUnitTestElementSet>.Write(ctx, writer, value._ElementsUpdated);
      RdSignal<RdUnitTestElementList>.Write(ctx, writer, value._ElementsRemoved);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _ElementsUpdated.BindEx(lifetime, this, "elementsUpdated");
      _ElementsRemoved.BindEx(lifetime, this, "elementsRemoved");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ElementsUpdated.IdentifyEx(ids);
      _ElementsRemoved.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestElementManager (");
      using (printer.IndentCookie()) {
        printer.Print("elementsUpdated = "); _ElementsUpdated.PrintEx(printer); printer.Println();
        printer.Print("elementsRemoved = "); _ElementsRemoved.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestElementManipulator : RdBindableBase {
    //fields
    [NotNull] public ISource<RdUnitTestElementManipulatorSimpleRequest> AddElements { get { return _AddElements; }}
    [NotNull] private readonly RdSignal<RdUnitTestElementManipulatorSimpleRequest> _AddElements;
    [NotNull] public ISource<RdUnitTestElementManipulatorSimpleRequest> RemoveElements { get { return _RemoveElements; }}
    [NotNull] private readonly RdSignal<RdUnitTestElementManipulatorSimpleRequest> _RemoveElements;
    [NotNull] public ISink<RdUnitTestNavigateToElementArgs> NavigateToElement { get { return _NavigateToElement; }}
    [NotNull] private readonly RdSignal<RdUnitTestNavigateToElementArgs> _NavigateToElement;
    [NotNull] public ISink<RdUnitTestNavigateToProjectArgs> NavigateToProject { get { return _NavigateToProject; }}
    [NotNull] private readonly RdSignal<RdUnitTestNavigateToProjectArgs> _NavigateToProject;
    [NotNull] public ISink<RdUnitTestElementManipulatorSelectionRequest> RunSelectedTests { get { return _RunSelectedTests; }}
    [NotNull] private readonly RdSignal<RdUnitTestElementManipulatorSelectionRequest> _RunSelectedTests;
    [NotNull] public ISink<RdUnitTestElementManipulatorSelectionRequest> DebugSelectedTests { get { return _DebugSelectedTests; }}
    [NotNull] private readonly RdSignal<RdUnitTestElementManipulatorSelectionRequest> _DebugSelectedTests;
    [NotNull] public ISink<RdUnitTestElementManipulatorSelectionRequest> ClearSelectedTests { get { return _ClearSelectedTests; }}
    [NotNull] private readonly RdSignal<RdUnitTestElementManipulatorSelectionRequest> _ClearSelectedTests;
    [NotNull] public ISink<RdUnitTestElementManipulatorSelectionRequest> RemoveSelectedTests { get { return _RemoveSelectedTests; }}
    [NotNull] private readonly RdSignal<RdUnitTestElementManipulatorSelectionRequest> _RemoveSelectedTests;
    [NotNull] public ISink<RdUnitTestElementManipulatorSelectionRequest> CreateNewSessionFromSelectedTests { get { return _CreateNewSessionFromSelectedTests; }}
    [NotNull] private readonly RdSignal<RdUnitTestElementManipulatorSelectionRequest> _CreateNewSessionFromSelectedTests;
    
    //primary constructor
    private RdUnitTestElementManipulator(
      [NotNull] RdSignal<RdUnitTestElementManipulatorSimpleRequest> addElements,
      [NotNull] RdSignal<RdUnitTestElementManipulatorSimpleRequest> removeElements,
      [NotNull] RdSignal<RdUnitTestNavigateToElementArgs> navigateToElement,
      [NotNull] RdSignal<RdUnitTestNavigateToProjectArgs> navigateToProject,
      [NotNull] RdSignal<RdUnitTestElementManipulatorSelectionRequest> runSelectedTests,
      [NotNull] RdSignal<RdUnitTestElementManipulatorSelectionRequest> debugSelectedTests,
      [NotNull] RdSignal<RdUnitTestElementManipulatorSelectionRequest> clearSelectedTests,
      [NotNull] RdSignal<RdUnitTestElementManipulatorSelectionRequest> removeSelectedTests,
      [NotNull] RdSignal<RdUnitTestElementManipulatorSelectionRequest> createNewSessionFromSelectedTests
    )
    {
      _AddElements = addElements;
      _RemoveElements = removeElements;
      _NavigateToElement = navigateToElement;
      _NavigateToProject = navigateToProject;
      _RunSelectedTests = runSelectedTests;
      _DebugSelectedTests = debugSelectedTests;
      _ClearSelectedTests = clearSelectedTests;
      _RemoveSelectedTests = removeSelectedTests;
      _CreateNewSessionFromSelectedTests = createNewSessionFromSelectedTests;
    }
    //secondary constructor
    public RdUnitTestElementManipulator (
    ) : this (
      new RdSignal<RdUnitTestElementManipulatorSimpleRequest>(),
      new RdSignal<RdUnitTestElementManipulatorSimpleRequest>(),
      new RdSignal<RdUnitTestNavigateToElementArgs>(),
      new RdSignal<RdUnitTestNavigateToProjectArgs>(),
      new RdSignal<RdUnitTestElementManipulatorSelectionRequest>(),
      new RdSignal<RdUnitTestElementManipulatorSelectionRequest>(),
      new RdSignal<RdUnitTestElementManipulatorSelectionRequest>(),
      new RdSignal<RdUnitTestElementManipulatorSelectionRequest>(),
      new RdSignal<RdUnitTestElementManipulatorSelectionRequest>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdUnitTestElementManipulator> Read = (ctx, reader) => 
    {
      var addElements = RdSignal<RdUnitTestElementManipulatorSimpleRequest>.Read(ctx, reader);
      var removeElements = RdSignal<RdUnitTestElementManipulatorSimpleRequest>.Read(ctx, reader);
      var navigateToElement = RdSignal<RdUnitTestNavigateToElementArgs>.Read(ctx, reader);
      var navigateToProject = RdSignal<RdUnitTestNavigateToProjectArgs>.Read(ctx, reader);
      var runSelectedTests = RdSignal<RdUnitTestElementManipulatorSelectionRequest>.Read(ctx, reader);
      var debugSelectedTests = RdSignal<RdUnitTestElementManipulatorSelectionRequest>.Read(ctx, reader);
      var clearSelectedTests = RdSignal<RdUnitTestElementManipulatorSelectionRequest>.Read(ctx, reader);
      var removeSelectedTests = RdSignal<RdUnitTestElementManipulatorSelectionRequest>.Read(ctx, reader);
      var createNewSessionFromSelectedTests = RdSignal<RdUnitTestElementManipulatorSelectionRequest>.Read(ctx, reader);
      return new RdUnitTestElementManipulator(addElements, removeElements, navigateToElement, navigateToProject, runSelectedTests, debugSelectedTests, clearSelectedTests, removeSelectedTests, createNewSessionFromSelectedTests);
    };
    
    public static CtxWriteDelegate<RdUnitTestElementManipulator> Write = (ctx, writer, value) => 
    {
      RdSignal<RdUnitTestElementManipulatorSimpleRequest>.Write(ctx, writer, value._AddElements);
      RdSignal<RdUnitTestElementManipulatorSimpleRequest>.Write(ctx, writer, value._RemoveElements);
      RdSignal<RdUnitTestNavigateToElementArgs>.Write(ctx, writer, value._NavigateToElement);
      RdSignal<RdUnitTestNavigateToProjectArgs>.Write(ctx, writer, value._NavigateToProject);
      RdSignal<RdUnitTestElementManipulatorSelectionRequest>.Write(ctx, writer, value._RunSelectedTests);
      RdSignal<RdUnitTestElementManipulatorSelectionRequest>.Write(ctx, writer, value._DebugSelectedTests);
      RdSignal<RdUnitTestElementManipulatorSelectionRequest>.Write(ctx, writer, value._ClearSelectedTests);
      RdSignal<RdUnitTestElementManipulatorSelectionRequest>.Write(ctx, writer, value._RemoveSelectedTests);
      RdSignal<RdUnitTestElementManipulatorSelectionRequest>.Write(ctx, writer, value._CreateNewSessionFromSelectedTests);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _AddElements.BindEx(lifetime, this, "addElements");
      _RemoveElements.BindEx(lifetime, this, "removeElements");
      _NavigateToElement.BindEx(lifetime, this, "navigateToElement");
      _NavigateToProject.BindEx(lifetime, this, "navigateToProject");
      _RunSelectedTests.BindEx(lifetime, this, "runSelectedTests");
      _DebugSelectedTests.BindEx(lifetime, this, "debugSelectedTests");
      _ClearSelectedTests.BindEx(lifetime, this, "clearSelectedTests");
      _RemoveSelectedTests.BindEx(lifetime, this, "removeSelectedTests");
      _CreateNewSessionFromSelectedTests.BindEx(lifetime, this, "createNewSessionFromSelectedTests");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _AddElements.IdentifyEx(ids);
      _RemoveElements.IdentifyEx(ids);
      _NavigateToElement.IdentifyEx(ids);
      _NavigateToProject.IdentifyEx(ids);
      _RunSelectedTests.IdentifyEx(ids);
      _DebugSelectedTests.IdentifyEx(ids);
      _ClearSelectedTests.IdentifyEx(ids);
      _RemoveSelectedTests.IdentifyEx(ids);
      _CreateNewSessionFromSelectedTests.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestElementManipulator (");
      using (printer.IndentCookie()) {
        printer.Print("addElements = "); _AddElements.PrintEx(printer); printer.Println();
        printer.Print("removeElements = "); _RemoveElements.PrintEx(printer); printer.Println();
        printer.Print("navigateToElement = "); _NavigateToElement.PrintEx(printer); printer.Println();
        printer.Print("navigateToProject = "); _NavigateToProject.PrintEx(printer); printer.Println();
        printer.Print("runSelectedTests = "); _RunSelectedTests.PrintEx(printer); printer.Println();
        printer.Print("debugSelectedTests = "); _DebugSelectedTests.PrintEx(printer); printer.Println();
        printer.Print("clearSelectedTests = "); _ClearSelectedTests.PrintEx(printer); printer.Println();
        printer.Print("removeSelectedTests = "); _RemoveSelectedTests.PrintEx(printer); printer.Println();
        printer.Print("createNewSessionFromSelectedTests = "); _CreateNewSessionFromSelectedTests.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestElementManipulatorSelectionRequest : IPrintable, IEquatable<RdUnitTestElementManipulatorSelectionRequest> {
    //fields
    [NotNull] public string SessionId {get; private set;}
    [NotNull] public RdUnitTestSelection Selection {get; private set;}
    
    //primary constructor
    public RdUnitTestElementManipulatorSelectionRequest(
      [NotNull] string sessionId,
      [NotNull] RdUnitTestSelection selection
    )
    {
      SessionId = sessionId;
      Selection = selection;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestElementManipulatorSelectionRequest> Read = (ctx, reader) => 
    {
      var sessionId = reader.ReadString();
      var selection = RdUnitTestSelection.Read(ctx, reader);
      return new RdUnitTestElementManipulatorSelectionRequest(sessionId, selection);
    };
    
    public static CtxWriteDelegate<RdUnitTestElementManipulatorSelectionRequest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.SessionId);
      RdUnitTestSelection.Write(ctx, writer, value.Selection);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestElementManipulatorSelectionRequest) obj);
    }
    public bool Equals(RdUnitTestElementManipulatorSelectionRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return SessionId == other.SessionId && Equals(Selection, other.Selection);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + SessionId.GetHashCode();
        __r = __r*31 + Selection.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestElementManipulatorSelectionRequest (");
      using (printer.IndentCookie()) {
        printer.Print("sessionId = "); SessionId.PrintEx(printer); printer.Println();
        printer.Print("selection = "); Selection.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestElementManipulatorSimpleRequest : IPrintable, IEquatable<RdUnitTestElementManipulatorSimpleRequest> {
    //fields
    [NotNull] public string SessionId {get; private set;}
    [NotNull] public List<int> ElementIds {get; private set;}
    
    //primary constructor
    public RdUnitTestElementManipulatorSimpleRequest(
      [NotNull] string sessionId,
      [NotNull] List<int> elementIds
    )
    {
      SessionId = sessionId;
      ElementIds = elementIds;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static CtxReadDelegate<RdUnitTestElementManipulatorSimpleRequest> Read = (ctx, reader) => 
    {
      var sessionId = reader.ReadString();
      var elementIds = ReadIntList(ctx, reader);
      return new RdUnitTestElementManipulatorSimpleRequest(sessionId, elementIds);
    };
    
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static CtxWriteDelegate<RdUnitTestElementManipulatorSimpleRequest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.SessionId);
      WriteIntList(ctx, writer, value.ElementIds);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestElementManipulatorSimpleRequest) obj);
    }
    public bool Equals(RdUnitTestElementManipulatorSimpleRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return SessionId == other.SessionId && ElementIds.SequenceEqual(other.ElementIds);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + SessionId.GetHashCode();
        __r = __r*31 + CollectionUtil.GetHashCode(ElementIds);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestElementManipulatorSimpleRequest (");
      using (printer.IndentCookie()) {
        printer.Print("sessionId = "); SessionId.PrintEx(printer); printer.Println();
        printer.Print("elementIds = "); ElementIds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestElementSet : IPrintable, IEquatable<RdUnitTestElementSet> {
    //fields
    [NotNull] public List<RdUnitTestElement> Elements {get; private set;}
    
    //primary constructor
    public RdUnitTestElementSet(
      [NotNull] List<RdUnitTestElement> elements
    )
    {
      Elements = elements;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<RdUnitTestElement>> ReadRdUnitTestElementList = RdUnitTestElement.Read.List();
    public static CtxReadDelegate<RdUnitTestElementSet> Read = (ctx, reader) => 
    {
      var elements = ReadRdUnitTestElementList(ctx, reader);
      return new RdUnitTestElementSet(elements);
    };
    
    public static CtxWriteDelegate<List<RdUnitTestElement>> WriteRdUnitTestElementList = RdUnitTestElement.Write.List();
    public static CtxWriteDelegate<RdUnitTestElementSet> Write = (ctx, writer, value) => 
    {
      WriteRdUnitTestElementList(ctx, writer, value.Elements);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestElementSet) obj);
    }
    public bool Equals(RdUnitTestElementSet other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Elements.SequenceEqual(other.Elements);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(Elements);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestElementSet (");
      using (printer.IndentCookie()) {
        printer.Print("elements = "); Elements.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestExplorerWindowService : RdBindableBase {
    //fields
    [NotNull] public ISource<RdUnitTestElementList> OpenInExplorer { get { return _OpenInExplorer; }}
    [NotNull] private readonly RdSignal<RdUnitTestElementList> _OpenInExplorer;
    
    //primary constructor
    private RdUnitTestExplorerWindowService(
      [NotNull] RdSignal<RdUnitTestElementList> openInExplorer
    )
    {
      _OpenInExplorer = openInExplorer;
    }
    //secondary constructor
    public RdUnitTestExplorerWindowService (
    ) : this (
      new RdSignal<RdUnitTestElementList>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdUnitTestExplorerWindowService> Read = (ctx, reader) => 
    {
      var openInExplorer = RdSignal<RdUnitTestElementList>.Read(ctx, reader);
      return new RdUnitTestExplorerWindowService(openInExplorer);
    };
    
    public static CtxWriteDelegate<RdUnitTestExplorerWindowService> Write = (ctx, writer, value) => 
    {
      RdSignal<RdUnitTestElementList>.Write(ctx, writer, value._OpenInExplorer);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _OpenInExplorer.BindEx(lifetime, this, "openInExplorer");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _OpenInExplorer.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestExplorerWindowService (");
      using (printer.IndentCookie()) {
        printer.Print("openInExplorer = "); _OpenInExplorer.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestHost : RdBindableBase {
    //fields
    [NotNull] public RdUnitTestElementManager ElementManager {get; private set;}
    [NotNull] public RdUnitTestExplorerWindowService ExplorerWindowService {get; private set;}
    [NotNull] public RdUnitTestSessionConductor SessionConductor {get; private set;}
    [NotNull] public RdUnitTestSessionManipulator SessionManipulator {get; private set;}
    [NotNull] public RdUnitTestElementManipulator ElementManipulator {get; private set;}
    [NotNull] public RdUnitTestResultManager ResultManager {get; private set;}
    [NotNull] public IRdProperty<RdUnitTestOptions> Options { get { return _Options; }}
    [NotNull] private readonly RdProperty<RdUnitTestOptions> _Options;
    [NotNull] public IRdProperty<bool> IsReady { get { return _IsReady; }}
    [NotNull] private readonly RdProperty<bool> _IsReady;
    
    //primary constructor
    private RdUnitTestHost(
      [NotNull] RdUnitTestElementManager elementManager,
      [NotNull] RdUnitTestExplorerWindowService explorerWindowService,
      [NotNull] RdUnitTestSessionConductor sessionConductor,
      [NotNull] RdUnitTestSessionManipulator sessionManipulator,
      [NotNull] RdUnitTestElementManipulator elementManipulator,
      [NotNull] RdUnitTestResultManager resultManager,
      [NotNull] RdProperty<RdUnitTestOptions> options,
      [NotNull] RdProperty<bool> isReady
    )
    {
      ElementManager = elementManager;
      ExplorerWindowService = explorerWindowService;
      SessionConductor = sessionConductor;
      SessionManipulator = sessionManipulator;
      ElementManipulator = elementManipulator;
      ResultManager = resultManager;
      _Options = options;
      _IsReady = isReady;
      isReady.OptimizeNested = true;
    }
    //secondary constructor
    public RdUnitTestHost (
    ) : this (
      new RdUnitTestElementManager(),
      new RdUnitTestExplorerWindowService(),
      new RdUnitTestSessionConductor(),
      new RdUnitTestSessionManipulator(),
      new RdUnitTestElementManipulator(),
      new RdUnitTestResultManager(),
      new RdProperty<RdUnitTestOptions>(),
      new RdProperty<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdUnitTestHost> Read = (ctx, reader) => 
    {
      var elementManager = RdUnitTestElementManager.Read(ctx, reader);
      var explorerWindowService = RdUnitTestExplorerWindowService.Read(ctx, reader);
      var sessionConductor = RdUnitTestSessionConductor.Read(ctx, reader);
      var sessionManipulator = RdUnitTestSessionManipulator.Read(ctx, reader);
      var elementManipulator = RdUnitTestElementManipulator.Read(ctx, reader);
      var resultManager = RdUnitTestResultManager.Read(ctx, reader);
      var options = RdProperty<RdUnitTestOptions>.Read(ctx, reader);
      var isReady = RdProperty<bool>.Read(ctx, reader);
      return new RdUnitTestHost(elementManager, explorerWindowService, sessionConductor, sessionManipulator, elementManipulator, resultManager, options, isReady);
    };
    
    public static CtxWriteDelegate<RdUnitTestHost> Write = (ctx, writer, value) => 
    {
      RdUnitTestElementManager.Write(ctx, writer, value.ElementManager);
      RdUnitTestExplorerWindowService.Write(ctx, writer, value.ExplorerWindowService);
      RdUnitTestSessionConductor.Write(ctx, writer, value.SessionConductor);
      RdUnitTestSessionManipulator.Write(ctx, writer, value.SessionManipulator);
      RdUnitTestElementManipulator.Write(ctx, writer, value.ElementManipulator);
      RdUnitTestResultManager.Write(ctx, writer, value.ResultManager);
      RdProperty<RdUnitTestOptions>.Write(ctx, writer, value._Options);
      RdProperty<bool>.Write(ctx, writer, value._IsReady);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      ElementManager.BindEx(lifetime, this, "elementManager");
      ExplorerWindowService.BindEx(lifetime, this, "explorerWindowService");
      SessionConductor.BindEx(lifetime, this, "sessionConductor");
      SessionManipulator.BindEx(lifetime, this, "sessionManipulator");
      ElementManipulator.BindEx(lifetime, this, "elementManipulator");
      ResultManager.BindEx(lifetime, this, "resultManager");
      _Options.BindEx(lifetime, this, "options");
      _IsReady.BindEx(lifetime, this, "isReady");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      ElementManager.IdentifyEx(ids);
      ExplorerWindowService.IdentifyEx(ids);
      SessionConductor.IdentifyEx(ids);
      SessionManipulator.IdentifyEx(ids);
      ElementManipulator.IdentifyEx(ids);
      ResultManager.IdentifyEx(ids);
      _Options.IdentifyEx(ids);
      _IsReady.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestHost (");
      using (printer.IndentCookie()) {
        printer.Print("elementManager = "); ElementManager.PrintEx(printer); printer.Println();
        printer.Print("explorerWindowService = "); ExplorerWindowService.PrintEx(printer); printer.Println();
        printer.Print("sessionConductor = "); SessionConductor.PrintEx(printer); printer.Println();
        printer.Print("sessionManipulator = "); SessionManipulator.PrintEx(printer); printer.Println();
        printer.Print("elementManipulator = "); ElementManipulator.PrintEx(printer); printer.Println();
        printer.Print("resultManager = "); ResultManager.PrintEx(printer); printer.Println();
        printer.Print("options = "); _Options.PrintEx(printer); printer.Println();
        printer.Print("isReady = "); _IsReady.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestNavigateToElementArgs : IPrintable, IEquatable<RdUnitTestNavigateToElementArgs> {
    //fields
    public int ElementId {get; private set;}
    public bool RequestFocus {get; private set;}
    
    //primary constructor
    public RdUnitTestNavigateToElementArgs(
      int elementId,
      bool requestFocus
    )
    {
      ElementId = elementId;
      RequestFocus = requestFocus;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestNavigateToElementArgs> Read = (ctx, reader) => 
    {
      var elementId = reader.ReadInt();
      var requestFocus = reader.ReadBool();
      return new RdUnitTestNavigateToElementArgs(elementId, requestFocus);
    };
    
    public static CtxWriteDelegate<RdUnitTestNavigateToElementArgs> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ElementId);
      writer.Write(value.RequestFocus);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestNavigateToElementArgs) obj);
    }
    public bool Equals(RdUnitTestNavigateToElementArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ElementId == other.ElementId && RequestFocus == other.RequestFocus;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + ElementId.GetHashCode();
        __r = __r*31 + RequestFocus.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestNavigateToElementArgs (");
      using (printer.IndentCookie()) {
        printer.Print("elementId = "); ElementId.PrintEx(printer); printer.Println();
        printer.Print("requestFocus = "); RequestFocus.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestNavigateToProjectArgs : IPrintable, IEquatable<RdUnitTestNavigateToProjectArgs> {
    //fields
    public int ProjectId {get; private set;}
    public bool RequestFocus {get; private set;}
    
    //primary constructor
    public RdUnitTestNavigateToProjectArgs(
      int projectId,
      bool requestFocus
    )
    {
      ProjectId = projectId;
      RequestFocus = requestFocus;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestNavigateToProjectArgs> Read = (ctx, reader) => 
    {
      var projectId = reader.ReadInt();
      var requestFocus = reader.ReadBool();
      return new RdUnitTestNavigateToProjectArgs(projectId, requestFocus);
    };
    
    public static CtxWriteDelegate<RdUnitTestNavigateToProjectArgs> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProjectId);
      writer.Write(value.RequestFocus);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestNavigateToProjectArgs) obj);
    }
    public bool Equals(RdUnitTestNavigateToProjectArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectId == other.ProjectId && RequestFocus == other.RequestFocus;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + ProjectId.GetHashCode();
        __r = __r*31 + RequestFocus.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestNavigateToProjectArgs (");
      using (printer.IndentCookie()) {
        printer.Print("projectId = "); ProjectId.PrintEx(printer); printer.Println();
        printer.Print("requestFocus = "); RequestFocus.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestOpenSessionArgs : IPrintable, IEquatable<RdUnitTestOpenSessionArgs> {
    //fields
    [NotNull] public string Session {get; private set;}
    public bool Activate {get; private set;}
    
    //primary constructor
    public RdUnitTestOpenSessionArgs(
      [NotNull] string session,
      bool activate
    )
    {
      Session = session;
      Activate = activate;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestOpenSessionArgs> Read = (ctx, reader) => 
    {
      var session = reader.ReadString();
      var activate = reader.ReadBool();
      return new RdUnitTestOpenSessionArgs(session, activate);
    };
    
    public static CtxWriteDelegate<RdUnitTestOpenSessionArgs> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Session);
      writer.Write(value.Activate);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestOpenSessionArgs) obj);
    }
    public bool Equals(RdUnitTestOpenSessionArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Session == other.Session && Activate == other.Activate;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Session.GetHashCode();
        __r = __r*31 + Activate.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestOpenSessionArgs (");
      using (printer.IndentCookie()) {
        printer.Print("session = "); Session.PrintEx(printer); printer.Println();
        printer.Print("activate = "); Activate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestOptions : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<bool> EnableLogging { get { return _EnableLogging; }}
    [NotNull] private readonly RdProperty<bool> _EnableLogging;
    [NotNull] public string LoggingDirectory {get; private set;}
    
    //primary constructor
    private RdUnitTestOptions(
      [NotNull] RdProperty<bool> enableLogging,
      [NotNull] string loggingDirectory
    )
    {
      _EnableLogging = enableLogging;
      LoggingDirectory = loggingDirectory;
      enableLogging.OptimizeNested = true;
    }
    //secondary constructor
    public RdUnitTestOptions (
      [NotNull] string LoggingDirectory
    ) : this (
      new RdProperty<bool>(),
      LoggingDirectory
    ) {}
    //statics
    
    public static CtxReadDelegate<RdUnitTestOptions> Read = (ctx, reader) => 
    {
      var enableLogging = RdProperty<bool>.Read(ctx, reader);
      var loggingDirectory = reader.ReadString();
      return new RdUnitTestOptions(enableLogging, loggingDirectory);
    };
    
    public static CtxWriteDelegate<RdUnitTestOptions> Write = (ctx, writer, value) => 
    {
      RdProperty<bool>.Write(ctx, writer, value._EnableLogging);
      writer.Write(value.LoggingDirectory);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _EnableLogging.BindEx(lifetime, this, "enableLogging");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _EnableLogging.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestOptions (");
      using (printer.IndentCookie()) {
        printer.Print("enableLogging = "); _EnableLogging.PrintEx(printer); printer.Println();
        printer.Print("loggingDirectory = "); LoggingDirectory.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestResult : IPrintable, IEquatable<RdUnitTestResult> {
    //fields
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    public RdUnitTestStatus Status {get; private set;}
    public bool Outdated {get; private set;}
    [NotNull] public string ShortMessage {get; private set;}
    public DateTime StartTime {get; private set;}
    public DateTime EndTime {get; private set;}
    public int Duration {get; private set;}
    public int ChildrenFailCount {get; private set;}
    
    //primary constructor
    public RdUnitTestResult(
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      RdUnitTestStatus status,
      bool outdated,
      [NotNull] string shortMessage,
      DateTime startTime,
      DateTime endTime,
      int duration,
      int childrenFailCount
    )
    {
      Icon = icon;
      Status = status;
      Outdated = outdated;
      ShortMessage = shortMessage;
      StartTime = startTime;
      EndTime = endTime;
      Duration = duration;
      ChildrenFailCount = childrenFailCount;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<RdUnitTestResult> Read = (ctx, reader) => 
    {
      var icon = ReadIconNullable(ctx, reader);
      var status = (RdUnitTestStatus)reader.ReadInt();
      var outdated = reader.ReadBool();
      var shortMessage = reader.ReadString();
      var startTime = reader.ReadDateTime();
      var endTime = reader.ReadDateTime();
      var duration = reader.ReadInt();
      var childrenFailCount = reader.ReadInt();
      return new RdUnitTestResult(icon, status, outdated, shortMessage, startTime, endTime, duration, childrenFailCount);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<RdUnitTestResult> Write = (ctx, writer, value) => 
    {
      WriteIconNullable(ctx, writer, value.Icon);
      writer.Write((int)value.Status);
      writer.Write(value.Outdated);
      writer.Write(value.ShortMessage);
      writer.Write(value.StartTime);
      writer.Write(value.EndTime);
      writer.Write(value.Duration);
      writer.Write(value.ChildrenFailCount);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestResult) obj);
    }
    public bool Equals(RdUnitTestResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Icon, other.Icon) && Status == other.Status && Outdated == other.Outdated && ShortMessage == other.ShortMessage && StartTime == other.StartTime && EndTime == other.EndTime && Duration == other.Duration && ChildrenFailCount == other.ChildrenFailCount;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (Icon != null ?Icon.GetHashCode() : 0);
        __r = __r*31 + (int) Status;
        __r = __r*31 + Outdated.GetHashCode();
        __r = __r*31 + ShortMessage.GetHashCode();
        __r = __r*31 + StartTime.GetHashCode();
        __r = __r*31 + EndTime.GetHashCode();
        __r = __r*31 + Duration.GetHashCode();
        __r = __r*31 + ChildrenFailCount.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestResult (");
      using (printer.IndentCookie()) {
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("status = "); Status.PrintEx(printer); printer.Println();
        printer.Print("outdated = "); Outdated.PrintEx(printer); printer.Println();
        printer.Print("shortMessage = "); ShortMessage.PrintEx(printer); printer.Println();
        printer.Print("startTime = "); StartTime.PrintEx(printer); printer.Println();
        printer.Print("endTime = "); EndTime.PrintEx(printer); printer.Println();
        printer.Print("duration = "); Duration.PrintEx(printer); printer.Println();
        printer.Print("childrenFailCount = "); ChildrenFailCount.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestResultData : IPrintable, IEquatable<RdUnitTestResultData> {
    //fields
    [NotNull] public string Title {get; private set;}
    [NotNull] public string ExceptionLines {get; private set;}
    [NotNull] public string OutputLines {get; private set;}
    
    //primary constructor
    public RdUnitTestResultData(
      [NotNull] string title,
      [NotNull] string exceptionLines,
      [NotNull] string outputLines
    )
    {
      Title = title;
      ExceptionLines = exceptionLines;
      OutputLines = outputLines;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestResultData> Read = (ctx, reader) => 
    {
      var title = reader.ReadString();
      var exceptionLines = reader.ReadString();
      var outputLines = reader.ReadString();
      return new RdUnitTestResultData(title, exceptionLines, outputLines);
    };
    
    public static CtxWriteDelegate<RdUnitTestResultData> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Title);
      writer.Write(value.ExceptionLines);
      writer.Write(value.OutputLines);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestResultData) obj);
    }
    public bool Equals(RdUnitTestResultData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Title == other.Title && ExceptionLines == other.ExceptionLines && OutputLines == other.OutputLines;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Title.GetHashCode();
        __r = __r*31 + ExceptionLines.GetHashCode();
        __r = __r*31 + OutputLines.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestResultData (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("exceptionLines = "); ExceptionLines.PrintEx(printer); printer.Println();
        printer.Print("outputLines = "); OutputLines.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestResultItem : IPrintable, IEquatable<RdUnitTestResultItem> {
    //fields
    [NotNull] public string Session {get; private set;}
    public int ElementId {get; private set;}
    [NotNull] public RdUnitTestResult Result {get; private set;}
    
    //primary constructor
    public RdUnitTestResultItem(
      [NotNull] string session,
      int elementId,
      [NotNull] RdUnitTestResult result
    )
    {
      Session = session;
      ElementId = elementId;
      Result = result;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestResultItem> Read = (ctx, reader) => 
    {
      var session = reader.ReadString();
      var elementId = reader.ReadInt();
      var result = RdUnitTestResult.Read(ctx, reader);
      return new RdUnitTestResultItem(session, elementId, result);
    };
    
    public static CtxWriteDelegate<RdUnitTestResultItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Session);
      writer.Write(value.ElementId);
      RdUnitTestResult.Write(ctx, writer, value.Result);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestResultItem) obj);
    }
    public bool Equals(RdUnitTestResultItem other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Session == other.Session && ElementId == other.ElementId && Equals(Result, other.Result);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Session.GetHashCode();
        __r = __r*31 + ElementId.GetHashCode();
        __r = __r*31 + Result.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestResultItem (");
      using (printer.IndentCookie()) {
        printer.Print("session = "); Session.PrintEx(printer); printer.Println();
        printer.Print("elementId = "); ElementId.PrintEx(printer); printer.Println();
        printer.Print("result = "); Result.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestResultList : IPrintable, IEquatable<RdUnitTestResultList> {
    //fields
    [NotNull] public List<RdUnitTestResultItem> Items {get; private set;}
    
    //primary constructor
    public RdUnitTestResultList(
      [NotNull] List<RdUnitTestResultItem> items
    )
    {
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<RdUnitTestResultItem>> ReadRdUnitTestResultItemList = RdUnitTestResultItem.Read.List();
    public static CtxReadDelegate<RdUnitTestResultList> Read = (ctx, reader) => 
    {
      var items = ReadRdUnitTestResultItemList(ctx, reader);
      return new RdUnitTestResultList(items);
    };
    
    public static CtxWriteDelegate<List<RdUnitTestResultItem>> WriteRdUnitTestResultItemList = RdUnitTestResultItem.Write.List();
    public static CtxWriteDelegate<RdUnitTestResultList> Write = (ctx, writer, value) => 
    {
      WriteRdUnitTestResultItemList(ctx, writer, value.Items);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestResultList) obj);
    }
    public bool Equals(RdUnitTestResultList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Items.SequenceEqual(other.Items);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(Items);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestResultList (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestResultManager : RdBindableBase {
    //fields
    [NotNull] public ISource<RdUnitTestResultList> ResultUpdated { get { return _ResultUpdated; }}
    [NotNull] private readonly RdSignal<RdUnitTestResultList> _ResultUpdated;
    
    //primary constructor
    private RdUnitTestResultManager(
      [NotNull] RdSignal<RdUnitTestResultList> resultUpdated
    )
    {
      _ResultUpdated = resultUpdated;
    }
    //secondary constructor
    public RdUnitTestResultManager (
    ) : this (
      new RdSignal<RdUnitTestResultList>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdUnitTestResultManager> Read = (ctx, reader) => 
    {
      var resultUpdated = RdSignal<RdUnitTestResultList>.Read(ctx, reader);
      return new RdUnitTestResultManager(resultUpdated);
    };
    
    public static CtxWriteDelegate<RdUnitTestResultManager> Write = (ctx, writer, value) => 
    {
      RdSignal<RdUnitTestResultList>.Write(ctx, writer, value._ResultUpdated);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _ResultUpdated.BindEx(lifetime, this, "resultUpdated");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ResultUpdated.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestResultManager (");
      using (printer.IndentCookie()) {
        printer.Print("resultUpdated = "); _ResultUpdated.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestSelection : IPrintable, IEquatable<RdUnitTestSelection> {
    //fields
    [NotNull] public List<int> ElementIds {get; private set;}
    [NotNull] public List<int> ProjectIds {get; private set;}
    
    //primary constructor
    public RdUnitTestSelection(
      [NotNull] List<int> elementIds,
      [NotNull] List<int> projectIds
    )
    {
      ElementIds = elementIds;
      ProjectIds = projectIds;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static CtxReadDelegate<RdUnitTestSelection> Read = (ctx, reader) => 
    {
      var elementIds = ReadIntList(ctx, reader);
      var projectIds = ReadIntList(ctx, reader);
      return new RdUnitTestSelection(elementIds, projectIds);
    };
    
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static CtxWriteDelegate<RdUnitTestSelection> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.ElementIds);
      WriteIntList(ctx, writer, value.ProjectIds);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestSelection) obj);
    }
    public bool Equals(RdUnitTestSelection other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ElementIds.SequenceEqual(other.ElementIds) && ProjectIds.SequenceEqual(other.ProjectIds);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(ElementIds);
        __r = __r*31 + CollectionUtil.GetHashCode(ProjectIds);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestSelection (");
      using (printer.IndentCookie()) {
        printer.Print("elementIds = "); ElementIds.PrintEx(printer); printer.Println();
        printer.Print("projectIds = "); ProjectIds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestSessionConductor : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<string> ActiveSession { get { return _ActiveSession; }}
    [NotNull] private readonly RdProperty<string> _ActiveSession;
    [NotNull] public ISource<RdUnitTestSessionDescriptor> CreateSession { get { return _CreateSession; }}
    [NotNull] private readonly RdSignal<RdUnitTestSessionDescriptor> _CreateSession;
    [NotNull] public ISource<RdUnitTestOpenSessionArgs> OpenSession { get { return _OpenSession; }}
    [NotNull] private readonly RdSignal<RdUnitTestOpenSessionArgs> _OpenSession;
    [NotNull] public ISource<string> CloseSession { get { return _CloseSession; }}
    [NotNull] private readonly RdSignal<string> _CloseSession;
    
    //primary constructor
    private RdUnitTestSessionConductor(
      [NotNull] RdProperty<string> activeSession,
      [NotNull] RdSignal<RdUnitTestSessionDescriptor> createSession,
      [NotNull] RdSignal<RdUnitTestOpenSessionArgs> openSession,
      [NotNull] RdSignal<string> closeSession
    )
    {
      _ActiveSession = activeSession;
      _CreateSession = createSession;
      _OpenSession = openSession;
      _CloseSession = closeSession;
      activeSession.OptimizeNested = true;
    }
    //secondary constructor
    public RdUnitTestSessionConductor (
    ) : this (
      new RdProperty<string>(),
      new RdSignal<RdUnitTestSessionDescriptor>(),
      new RdSignal<RdUnitTestOpenSessionArgs>(),
      new RdSignal<string>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdUnitTestSessionConductor> Read = (ctx, reader) => 
    {
      var activeSession = RdProperty<string>.Read(ctx, reader);
      var createSession = RdSignal<RdUnitTestSessionDescriptor>.Read(ctx, reader);
      var openSession = RdSignal<RdUnitTestOpenSessionArgs>.Read(ctx, reader);
      var closeSession = RdSignal<string>.Read(ctx, reader);
      return new RdUnitTestSessionConductor(activeSession, createSession, openSession, closeSession);
    };
    
    public static CtxWriteDelegate<RdUnitTestSessionConductor> Write = (ctx, writer, value) => 
    {
      RdProperty<string>.Write(ctx, writer, value._ActiveSession);
      RdSignal<RdUnitTestSessionDescriptor>.Write(ctx, writer, value._CreateSession);
      RdSignal<RdUnitTestOpenSessionArgs>.Write(ctx, writer, value._OpenSession);
      RdSignal<string>.Write(ctx, writer, value._CloseSession);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _ActiveSession.BindEx(lifetime, this, "activeSession");
      _CreateSession.BindEx(lifetime, this, "createSession");
      _OpenSession.BindEx(lifetime, this, "openSession");
      _CloseSession.BindEx(lifetime, this, "closeSession");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ActiveSession.IdentifyEx(ids);
      _CreateSession.IdentifyEx(ids);
      _OpenSession.IdentifyEx(ids);
      _CloseSession.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestSessionConductor (");
      using (printer.IndentCookie()) {
        printer.Print("activeSession = "); _ActiveSession.PrintEx(printer); printer.Println();
        printer.Print("createSession = "); _CreateSession.PrintEx(printer); printer.Println();
        printer.Print("openSession = "); _OpenSession.PrintEx(printer); printer.Println();
        printer.Print("closeSession = "); _CloseSession.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestSessionDescriptor : IPrintable, IEquatable<RdUnitTestSessionDescriptor> {
    //fields
    [NotNull] public string Id {get; private set;}
    [NotNull] public string Title {get; private set;}
    
    //primary constructor
    public RdUnitTestSessionDescriptor(
      [NotNull] string id,
      [NotNull] string title
    )
    {
      Id = id;
      Title = title;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestSessionDescriptor> Read = (ctx, reader) => 
    {
      var id = reader.ReadString();
      var title = reader.ReadString();
      return new RdUnitTestSessionDescriptor(id, title);
    };
    
    public static CtxWriteDelegate<RdUnitTestSessionDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.Title);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestSessionDescriptor) obj);
    }
    public bool Equals(RdUnitTestSessionDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Title == other.Title;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Id.GetHashCode();
        __r = __r*31 + Title.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestSessionDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestSessionManipulator : RdBindableBase {
    //fields
    [NotNull] public IVoidSink EnsureSessionsAreOpened { get { return _EnsureSessionsAreOpened; }}
    [NotNull] private readonly RdVoidSignal _EnsureSessionsAreOpened;
    [NotNull] public ISink<string> Rerun { get { return _Rerun; }}
    [NotNull] private readonly RdSignal<string> _Rerun;
    [NotNull] public ISink<string> Abort { get { return _Abort; }}
    [NotNull] private readonly RdSignal<string> _Abort;
    [NotNull] public ISink<string> Close { get { return _Close; }}
    [NotNull] private readonly RdSignal<string> _Close;
    [NotNull] public ISource<RdUniTestLaunchMessage> LogLaunchMessage { get { return _LogLaunchMessage; }}
    [NotNull] private readonly RdSignal<RdUniTestLaunchMessage> _LogLaunchMessage;
    [NotNull] public IVoidSink CloseAll { get { return _CloseAll; }}
    [NotNull] private readonly RdVoidSignal _CloseAll;
    [NotNull] public IViewableMap<string, RdUnitTestSelection> Selection { get { return _Selection; }}
    [NotNull] private readonly RdMap<string, RdUnitTestSelection> _Selection;
    [NotNull] public ISource<RdUnitTestShowResultDataArgs> ShowResultData { get { return _ShowResultData; }}
    [NotNull] private readonly RdSignal<RdUnitTestShowResultDataArgs> _ShowResultData;
    [NotNull] public ISink<int> RunTestsForProjectId { get { return _RunTestsForProjectId; }}
    [NotNull] private readonly RdSignal<int> _RunTestsForProjectId;
    
    //primary constructor
    private RdUnitTestSessionManipulator(
      [NotNull] RdVoidSignal ensureSessionsAreOpened,
      [NotNull] RdSignal<string> rerun,
      [NotNull] RdSignal<string> abort,
      [NotNull] RdSignal<string> close,
      [NotNull] RdSignal<RdUniTestLaunchMessage> logLaunchMessage,
      [NotNull] RdVoidSignal closeAll,
      [NotNull] RdMap<string, RdUnitTestSelection> selection,
      [NotNull] RdSignal<RdUnitTestShowResultDataArgs> showResultData,
      [NotNull] RdSignal<int> runTestsForProjectId
    )
    {
      _EnsureSessionsAreOpened = ensureSessionsAreOpened;
      _Rerun = rerun;
      _Abort = abort;
      _Close = close;
      _LogLaunchMessage = logLaunchMessage;
      _CloseAll = closeAll;
      _Selection = selection;
      _ShowResultData = showResultData;
      _RunTestsForProjectId = runTestsForProjectId;
      selection.OptimizeNested = true;
    }
    //secondary constructor
    public RdUnitTestSessionManipulator (
    ) : this (
      new RdVoidSignal(),
      new RdSignal<string>(),
      new RdSignal<string>(),
      new RdSignal<string>(),
      new RdSignal<RdUniTestLaunchMessage>(),
      new RdVoidSignal(),
      new RdMap<string, RdUnitTestSelection>(),
      new RdSignal<RdUnitTestShowResultDataArgs>(),
      new RdSignal<int>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdUnitTestSessionManipulator> Read = (ctx, reader) => 
    {
      var ensureSessionsAreOpened = RdVoidSignal.Read(ctx, reader);
      var rerun = RdSignal<string>.Read(ctx, reader);
      var abort = RdSignal<string>.Read(ctx, reader);
      var close = RdSignal<string>.Read(ctx, reader);
      var logLaunchMessage = RdSignal<RdUniTestLaunchMessage>.Read(ctx, reader);
      var closeAll = RdVoidSignal.Read(ctx, reader);
      var selection = RdMap<string, RdUnitTestSelection>.Read(ctx, reader);
      var showResultData = RdSignal<RdUnitTestShowResultDataArgs>.Read(ctx, reader);
      var runTestsForProjectId = RdSignal<int>.Read(ctx, reader);
      return new RdUnitTestSessionManipulator(ensureSessionsAreOpened, rerun, abort, close, logLaunchMessage, closeAll, selection, showResultData, runTestsForProjectId);
    };
    
    public static CtxWriteDelegate<RdUnitTestSessionManipulator> Write = (ctx, writer, value) => 
    {
      RdVoidSignal.Write(ctx, writer, value._EnsureSessionsAreOpened);
      RdSignal<string>.Write(ctx, writer, value._Rerun);
      RdSignal<string>.Write(ctx, writer, value._Abort);
      RdSignal<string>.Write(ctx, writer, value._Close);
      RdSignal<RdUniTestLaunchMessage>.Write(ctx, writer, value._LogLaunchMessage);
      RdVoidSignal.Write(ctx, writer, value._CloseAll);
      RdMap<string, RdUnitTestSelection>.Write(ctx, writer, value._Selection);
      RdSignal<RdUnitTestShowResultDataArgs>.Write(ctx, writer, value._ShowResultData);
      RdSignal<int>.Write(ctx, writer, value._RunTestsForProjectId);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _EnsureSessionsAreOpened.BindEx(lifetime, this, "ensureSessionsAreOpened");
      _Rerun.BindEx(lifetime, this, "rerun");
      _Abort.BindEx(lifetime, this, "abort");
      _Close.BindEx(lifetime, this, "close");
      _LogLaunchMessage.BindEx(lifetime, this, "logLaunchMessage");
      _CloseAll.BindEx(lifetime, this, "closeAll");
      _Selection.BindEx(lifetime, this, "selection");
      _ShowResultData.BindEx(lifetime, this, "showResultData");
      _RunTestsForProjectId.BindEx(lifetime, this, "runTestsForProjectId");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _EnsureSessionsAreOpened.IdentifyEx(ids);
      _Rerun.IdentifyEx(ids);
      _Abort.IdentifyEx(ids);
      _Close.IdentifyEx(ids);
      _LogLaunchMessage.IdentifyEx(ids);
      _CloseAll.IdentifyEx(ids);
      _Selection.IdentifyEx(ids);
      _ShowResultData.IdentifyEx(ids);
      _RunTestsForProjectId.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestSessionManipulator (");
      using (printer.IndentCookie()) {
        printer.Print("ensureSessionsAreOpened = "); _EnsureSessionsAreOpened.PrintEx(printer); printer.Println();
        printer.Print("rerun = "); _Rerun.PrintEx(printer); printer.Println();
        printer.Print("abort = "); _Abort.PrintEx(printer); printer.Println();
        printer.Print("close = "); _Close.PrintEx(printer); printer.Println();
        printer.Print("logLaunchMessage = "); _LogLaunchMessage.PrintEx(printer); printer.Println();
        printer.Print("closeAll = "); _CloseAll.PrintEx(printer); printer.Println();
        printer.Print("selection = "); _Selection.PrintEx(printer); printer.Println();
        printer.Print("showResultData = "); _ShowResultData.PrintEx(printer); printer.Println();
        printer.Print("runTestsForProjectId = "); _RunTestsForProjectId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestShowResultDataArgs : IPrintable, IEquatable<RdUnitTestShowResultDataArgs> {
    //fields
    [NotNull] public string SessionId {get; private set;}
    [CanBeNull] public RdUnitTestResultData ResultData {get; private set;}
    
    //primary constructor
    public RdUnitTestShowResultDataArgs(
      [NotNull] string sessionId,
      [CanBeNull] RdUnitTestResultData resultData
    )
    {
      SessionId = sessionId;
      ResultData = resultData;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestResultData> ReadRdUnitTestResultDataNullable = RdUnitTestResultData.Read.NullableClass();
    public static CtxReadDelegate<RdUnitTestShowResultDataArgs> Read = (ctx, reader) => 
    {
      var sessionId = reader.ReadString();
      var resultData = ReadRdUnitTestResultDataNullable(ctx, reader);
      return new RdUnitTestShowResultDataArgs(sessionId, resultData);
    };
    
    public static CtxWriteDelegate<RdUnitTestResultData> WriteRdUnitTestResultDataNullable = RdUnitTestResultData.Write.NullableClass();
    public static CtxWriteDelegate<RdUnitTestShowResultDataArgs> Write = (ctx, writer, value) => 
    {
      writer.Write(value.SessionId);
      WriteRdUnitTestResultDataNullable(ctx, writer, value.ResultData);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestShowResultDataArgs) obj);
    }
    public bool Equals(RdUnitTestShowResultDataArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return SessionId == other.SessionId && Equals(ResultData, other.ResultData);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + SessionId.GetHashCode();
        __r = __r*31 + (ResultData != null ?ResultData.GetHashCode() : 0);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestShowResultDataArgs (");
      using (printer.IndentCookie()) {
        printer.Print("sessionId = "); SessionId.PrintEx(printer); printer.Println();
        printer.Print("resultData = "); ResultData.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdUnitTestStatus {
    None,
    Unknown,
    Inconclusive,
    Ignored,
    Success,
    Failed,
    Aborted,
    Pending,
    Running
  }
  
  
  public class RdUnloadProjectDescriptor : RdProjectModelItemDescriptor
   {
    //fields
    public RdUnloadProjectState State {get; private set;}
    public bool DirectoryBased {get; private set;}
    
    //primary constructor
    public RdUnloadProjectDescriptor(
      RdUnloadProjectState state,
      bool directoryBased,
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
      State = state;
      DirectoryBased = directoryBased;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdUnloadProjectDescriptor> Read = (ctx, reader) => 
    {
      var state = (RdUnloadProjectState)reader.ReadInt();
      var directoryBased = reader.ReadBool();
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      return new RdUnloadProjectDescriptor(state, directoryBased, name, location);
    };
    
    public static new CtxWriteDelegate<RdUnloadProjectDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.State);
      writer.Write(value.DirectoryBased);
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnloadProjectDescriptor) obj);
    }
    public bool Equals(RdUnloadProjectDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return State == other.State && DirectoryBased == other.DirectoryBased && Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (int) State;
        __r = __r*31 + DirectoryBased.GetHashCode();
        __r = __r*31 + Name.GetHashCode();
        __r = __r*31 + Location.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnloadProjectDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("state = "); State.PrintEx(printer); printer.Println();
        printer.Print("directoryBased = "); DirectoryBased.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdUnloadProjectState {
    LoadFailed,
    Unloaded,
    Reloading
  }
  
  
  public class RdUnresolvedReferenceDescriptor : RdProjectModelItemDescriptor
   {
    //fields
    [NotNull] public string Reason {get; private set;}
    
    //primary constructor
    public RdUnresolvedReferenceDescriptor(
      [NotNull] string reason,
      [NotNull] string name,
      [NotNull] RdProjectModelItemLocation location
    ) : base (
      name,
      location
     ) 
    {
      Reason = reason;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdUnresolvedReferenceDescriptor> Read = (ctx, reader) => 
    {
      var reason = reader.ReadString();
      var name = reader.ReadString();
      var location = RdProjectModelItemLocation.Read(ctx, reader);
      return new RdUnresolvedReferenceDescriptor(reason, name, location);
    };
    
    public static new CtxWriteDelegate<RdUnresolvedReferenceDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Reason);
      writer.Write(value.Name);
      RdProjectModelItemLocation.Write(ctx, writer, value.Location);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnresolvedReferenceDescriptor) obj);
    }
    public bool Equals(RdUnresolvedReferenceDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Reason == other.Reason && Name == other.Name && Equals(Location, other.Location);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Reason.GetHashCode();
        __r = __r*31 + Name.GetHashCode();
        __r = __r*31 + Location.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnresolvedReferenceDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("reason = "); Reason.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUsage : RdUsageBase
   {
    //fields
    [NotNull] public ModelRichText DisplayName {get; private set;}
    
    //primary constructor
    private RdUsage(
      [NotNull] ModelRichText displayName,
      int index,
      [NotNull] string text,
      [NotNull] RdUsageAccessType accessType,
      [NotNull] RdProperty<bool> isValid,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] List<RdUsageGroup> groups
    ) : base (
      index,
      text,
      accessType,
      isValid,
      icon,
      groups
     ) 
    {
      DisplayName = displayName;
    }
    //secondary constructor
    public RdUsage (
      [NotNull] ModelRichText DisplayName,
      int Index,
      [NotNull] string Text,
      [NotNull] RdUsageAccessType AccessType,
      [CanBeNull] JetBrains.Rider.Model.Icon Icon,
      [NotNull] List<RdUsageGroup> Groups
    ) : this (
      DisplayName,
      Index,
      Text,
      AccessType,
      new RdProperty<bool>(),
      Icon,
      Groups
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<List<RdUsageGroup>> ReadRdUsageGroupList = RdUsageGroup.Read.List();
    public static new CtxReadDelegate<RdUsage> Read = (ctx, reader) => 
    {
      var displayName = ModelRichText.Read(ctx, reader);
      var index = reader.ReadInt();
      var text = reader.ReadString();
      var accessType = RdUsageAccessType.Read(ctx, reader);
      var isValid = RdProperty<bool>.Read(ctx, reader);
      var icon = ReadIconNullable(ctx, reader);
      var groups = ReadRdUsageGroupList(ctx, reader);
      return new RdUsage(displayName, index, text, accessType, isValid, icon, groups);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<List<RdUsageGroup>> WriteRdUsageGroupList = RdUsageGroup.Write.List();
    public static new CtxWriteDelegate<RdUsage> Write = (ctx, writer, value) => 
    {
      ModelRichText.Write(ctx, writer, value.DisplayName);
      writer.Write(value.Index);
      writer.Write(value.Text);
      RdUsageAccessType.Write(ctx, writer, value.AccessType);
      RdProperty<bool>.Write(ctx, writer, value._IsValid);
      WriteIconNullable(ctx, writer, value.Icon);
      WriteRdUsageGroupList(ctx, writer, value.Groups);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      AccessType.BindEx(lifetime, this, "accessType");
      _IsValid.BindEx(lifetime, this, "isValid");
      Groups.BindEx(lifetime, this, "groups");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      AccessType.IdentifyEx(ids);
      _IsValid.IdentifyEx(ids);
      Groups.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsage (");
      using (printer.IndentCookie()) {
        printer.Print("displayName = "); DisplayName.PrintEx(printer); printer.Println();
        printer.Print("index = "); Index.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("accessType = "); AccessType.PrintEx(printer); printer.Println();
        printer.Print("isValid = "); _IsValid.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("groups = "); Groups.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUsageAccessType : RdBindableBase {
    //fields
    public bool IsAccessedForReading {get; private set;}
    public bool IsAccessedForWriting {get; private set;}
    
    //primary constructor
    public RdUsageAccessType(
      bool isAccessedForReading,
      bool isAccessedForWriting
    )
    {
      IsAccessedForReading = isAccessedForReading;
      IsAccessedForWriting = isAccessedForWriting;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUsageAccessType> Read = (ctx, reader) => 
    {
      var isAccessedForReading = reader.ReadBool();
      var isAccessedForWriting = reader.ReadBool();
      return new RdUsageAccessType(isAccessedForReading, isAccessedForWriting);
    };
    
    public static CtxWriteDelegate<RdUsageAccessType> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IsAccessedForReading);
      writer.Write(value.IsAccessedForWriting);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsageAccessType (");
      using (printer.IndentCookie()) {
        printer.Print("isAccessedForReading = "); IsAccessedForReading.PrintEx(printer); printer.Println();
        printer.Print("isAccessedForWriting = "); IsAccessedForWriting.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdUsageBase : RdBindableBase {
    //fields
    public int Index {get; private set;}
    [NotNull] public string Text {get; private set;}
    [NotNull] public RdUsageAccessType AccessType {get; private set;}
    [NotNull] public IRdProperty<bool> IsValid { get { return _IsValid; }}
    [NotNull] protected readonly RdProperty<bool> _IsValid;
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public List<RdUsageGroup> Groups {get; private set;}
    
    //primary constructor
    protected RdUsageBase(
      int index,
      [NotNull] string text,
      [NotNull] RdUsageAccessType accessType,
      [NotNull] RdProperty<bool> isValid,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] List<RdUsageGroup> groups
    )
    {
      Index = index;
      Text = text;
      AccessType = accessType;
      _IsValid = isValid;
      Icon = icon;
      Groups = groups;
      isValid.OptimizeNested = true;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUsageBase> Read = (ctx, reader) => ctx.Serializers.Read<RdUsageBase>(ctx, reader);
    
    public static CtxWriteDelegate<RdUsageBase> Write = (ctx, writer, value) => ctx.Serializers.Write<RdUsageBase>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdUsageGroup : RdBindableBase {
    //fields
    [NotNull] public string GroupingRuleName {get; private set;}
    [NotNull] public string Text {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //primary constructor
    public RdUsageGroup(
      [NotNull] string groupingRuleName,
      [NotNull] string text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    )
    {
      GroupingRuleName = groupingRuleName;
      Text = text;
      Icon = icon;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<RdUsageGroup> Read = (ctx, reader) => 
    {
      var groupingRuleName = reader.ReadString();
      var text = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      return new RdUsageGroup(groupingRuleName, text, icon);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<RdUsageGroup> Write = (ctx, writer, value) => 
    {
      writer.Write(value.GroupingRuleName);
      writer.Write(value.Text);
      WriteIconNullable(ctx, writer, value.Icon);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsageGroup (");
      using (printer.IndentCookie()) {
        printer.Print("groupingRuleName = "); GroupingRuleName.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUsageGroupNavigationData : IPrintable, IEquatable<RdUsageGroupNavigationData> {
    //fields
    public int UsageIndex {get; private set;}
    [NotNull] public string GroupingRuleName {get; private set;}
    public bool RequestFocus {get; private set;}
    
    //primary constructor
    public RdUsageGroupNavigationData(
      int usageIndex,
      [NotNull] string groupingRuleName,
      bool requestFocus
    )
    {
      UsageIndex = usageIndex;
      GroupingRuleName = groupingRuleName;
      RequestFocus = requestFocus;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUsageGroupNavigationData> Read = (ctx, reader) => 
    {
      var usageIndex = reader.ReadInt();
      var groupingRuleName = reader.ReadString();
      var requestFocus = reader.ReadBool();
      return new RdUsageGroupNavigationData(usageIndex, groupingRuleName, requestFocus);
    };
    
    public static CtxWriteDelegate<RdUsageGroupNavigationData> Write = (ctx, writer, value) => 
    {
      writer.Write(value.UsageIndex);
      writer.Write(value.GroupingRuleName);
      writer.Write(value.RequestFocus);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUsageGroupNavigationData) obj);
    }
    public bool Equals(RdUsageGroupNavigationData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return UsageIndex == other.UsageIndex && GroupingRuleName == other.GroupingRuleName && RequestFocus == other.RequestFocus;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + UsageIndex.GetHashCode();
        __r = __r*31 + GroupingRuleName.GetHashCode();
        __r = __r*31 + RequestFocus.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsageGroupNavigationData (");
      using (printer.IndentCookie()) {
        printer.Print("usageIndex = "); UsageIndex.PrintEx(printer); printer.Println();
        printer.Print("groupingRuleName = "); GroupingRuleName.PrintEx(printer); printer.Println();
        printer.Print("requestFocus = "); RequestFocus.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUsageGroupingRule : RdBindableBase {
    //fields
    [NotNull] public string GroupingRuleName {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    public bool IsSeparable {get; private set;}
    [NotNull] public IRdProperty<bool> Enabled { get { return _Enabled; }}
    [NotNull] private readonly RdProperty<bool> _Enabled;
    public bool IsNavigateable {get; private set;}
    public bool Configurable {get; private set;}
    public bool PriorityDependsOnUsages {get; private set;}
    
    //primary constructor
    private RdUsageGroupingRule(
      [NotNull] string groupingRuleName,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      bool isSeparable,
      [NotNull] RdProperty<bool> enabled,
      bool isNavigateable,
      bool configurable,
      bool priorityDependsOnUsages
    )
    {
      GroupingRuleName = groupingRuleName;
      Icon = icon;
      IsSeparable = isSeparable;
      _Enabled = enabled;
      IsNavigateable = isNavigateable;
      Configurable = configurable;
      PriorityDependsOnUsages = priorityDependsOnUsages;
      enabled.OptimizeNested = true;
    }
    //secondary constructor
    public RdUsageGroupingRule (
      [NotNull] string GroupingRuleName,
      [CanBeNull] JetBrains.Rider.Model.Icon Icon,
      bool IsSeparable,
      bool IsNavigateable,
      bool Configurable,
      bool PriorityDependsOnUsages
    ) : this (
      GroupingRuleName,
      Icon,
      IsSeparable,
      new RdProperty<bool>(),
      IsNavigateable,
      Configurable,
      PriorityDependsOnUsages
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<RdUsageGroupingRule> Read = (ctx, reader) => 
    {
      var groupingRuleName = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var isSeparable = reader.ReadBool();
      var enabled = RdProperty<bool>.Read(ctx, reader);
      var isNavigateable = reader.ReadBool();
      var configurable = reader.ReadBool();
      var priorityDependsOnUsages = reader.ReadBool();
      return new RdUsageGroupingRule(groupingRuleName, icon, isSeparable, enabled, isNavigateable, configurable, priorityDependsOnUsages);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<RdUsageGroupingRule> Write = (ctx, writer, value) => 
    {
      writer.Write(value.GroupingRuleName);
      WriteIconNullable(ctx, writer, value.Icon);
      writer.Write(value.IsSeparable);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      writer.Write(value.IsNavigateable);
      writer.Write(value.Configurable);
      writer.Write(value.PriorityDependsOnUsages);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Enabled.BindEx(lifetime, this, "enabled");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Enabled.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsageGroupingRule (");
      using (printer.IndentCookie()) {
        printer.Print("groupingRuleName = "); GroupingRuleName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("isSeparable = "); IsSeparable.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("isNavigateable = "); IsNavigateable.PrintEx(printer); printer.Println();
        printer.Print("configurable = "); Configurable.PrintEx(printer); printer.Println();
        printer.Print("priorityDependsOnUsages = "); PriorityDependsOnUsages.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUsageGroupingRuleList : RdBindableBase {
    //fields
    [NotNull] public List<RdUsageGroupingRule> Items {get; private set;}
    
    //primary constructor
    public RdUsageGroupingRuleList(
      [NotNull] List<RdUsageGroupingRule> items
    )
    {
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<RdUsageGroupingRule>> ReadRdUsageGroupingRuleList = RdUsageGroupingRule.Read.List();
    public static CtxReadDelegate<RdUsageGroupingRuleList> Read = (ctx, reader) => 
    {
      var items = ReadRdUsageGroupingRuleList(ctx, reader);
      return new RdUsageGroupingRuleList(items);
    };
    
    public static CtxWriteDelegate<List<RdUsageGroupingRule>> WriteRdUsageGroupingRuleList = RdUsageGroupingRule.Write.List();
    public static CtxWriteDelegate<RdUsageGroupingRuleList> Write = (ctx, writer, value) => 
    {
      WriteRdUsageGroupingRuleList(ctx, writer, value.Items);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Items.BindEx(lifetime, this, "items");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Items.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsageGroupingRuleList (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdUsageKind {
    Target,
    ReadUsage,
    WriteUsage,
    Navigation,
    Other
  }
  
  
  public class RdUsageList : RdBindableBase {
    //fields
    [NotNull] public List<RdUsageBase> Items {get; private set;}
    [NotNull] public RdEndpoint<RdUsageNavigationData, RdVoid> NavigateTo { get { return _NavigateTo; }}
    [NotNull] private readonly RdEndpoint<RdUsageNavigationData, RdVoid> _NavigateTo;
    [NotNull] public RdEndpoint<RdUsageGroupNavigationData, RdVoid> NavigateToGroup { get { return _NavigateToGroup; }}
    [NotNull] private readonly RdEndpoint<RdUsageGroupNavigationData, RdVoid> _NavigateToGroup;
    [NotNull] public RdEndpoint<int, RdVoid> UpdateItem { get { return _UpdateItem; }}
    [NotNull] private readonly RdEndpoint<int, RdVoid> _UpdateItem;
    
    //primary constructor
    private RdUsageList(
      [NotNull] List<RdUsageBase> items,
      [NotNull] RdEndpoint<RdUsageNavigationData, RdVoid> navigateTo,
      [NotNull] RdEndpoint<RdUsageGroupNavigationData, RdVoid> navigateToGroup,
      [NotNull] RdEndpoint<int, RdVoid> updateItem
    )
    {
      Items = items;
      _NavigateTo = navigateTo;
      _NavigateToGroup = navigateToGroup;
      _UpdateItem = updateItem;
    }
    //secondary constructor
    public RdUsageList (
      [NotNull] List<RdUsageBase> Items
    ) : this (
      Items,
      new RdEndpoint<RdUsageNavigationData, RdVoid>(),
      new RdEndpoint<RdUsageGroupNavigationData, RdVoid>(),
      new RdEndpoint<int, RdVoid>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<RdUsageBase>> ReadRdUsageBaseList = RdUsageBase.Read.List();
    public static CtxReadDelegate<RdUsageList> Read = (ctx, reader) => 
    {
      var items = ReadRdUsageBaseList(ctx, reader);
      var navigateTo = RdEndpoint<RdUsageNavigationData, RdVoid>.Read(ctx, reader);
      var navigateToGroup = RdEndpoint<RdUsageGroupNavigationData, RdVoid>.Read(ctx, reader);
      var updateItem = RdEndpoint<int, RdVoid>.Read(ctx, reader);
      return new RdUsageList(items, navigateTo, navigateToGroup, updateItem);
    };
    
    public static CtxWriteDelegate<List<RdUsageBase>> WriteRdUsageBaseList = RdUsageBase.Write.List();
    public static CtxWriteDelegate<RdUsageList> Write = (ctx, writer, value) => 
    {
      WriteRdUsageBaseList(ctx, writer, value.Items);
      RdEndpoint<RdUsageNavigationData, RdVoid>.Write(ctx, writer, value._NavigateTo);
      RdEndpoint<RdUsageGroupNavigationData, RdVoid>.Write(ctx, writer, value._NavigateToGroup);
      RdEndpoint<int, RdVoid>.Write(ctx, writer, value._UpdateItem);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Items.BindEx(lifetime, this, "items");
      _NavigateTo.BindEx(lifetime, this, "navigateTo");
      _NavigateToGroup.BindEx(lifetime, this, "navigateToGroup");
      _UpdateItem.BindEx(lifetime, this, "updateItem");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Items.IdentifyEx(ids);
      _NavigateTo.IdentifyEx(ids);
      _NavigateToGroup.IdentifyEx(ids);
      _UpdateItem.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsageList (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
        printer.Print("navigateTo = "); _NavigateTo.PrintEx(printer); printer.Println();
        printer.Print("navigateToGroup = "); _NavigateToGroup.PrintEx(printer); printer.Println();
        printer.Print("updateItem = "); _UpdateItem.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUsageNavigationData : IPrintable, IEquatable<RdUsageNavigationData> {
    //fields
    public int Index {get; private set;}
    public bool RequestFocus {get; private set;}
    
    //primary constructor
    public RdUsageNavigationData(
      int index,
      bool requestFocus
    )
    {
      Index = index;
      RequestFocus = requestFocus;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUsageNavigationData> Read = (ctx, reader) => 
    {
      var index = reader.ReadInt();
      var requestFocus = reader.ReadBool();
      return new RdUsageNavigationData(index, requestFocus);
    };
    
    public static CtxWriteDelegate<RdUsageNavigationData> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Index);
      writer.Write(value.RequestFocus);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUsageNavigationData) obj);
    }
    public bool Equals(RdUsageNavigationData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Index == other.Index && RequestFocus == other.RequestFocus;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Index.GetHashCode();
        __r = __r*31 + RequestFocus.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsageNavigationData (");
      using (printer.IndentCookie()) {
        printer.Print("index = "); Index.PrintEx(printer); printer.Println();
        printer.Print("requestFocus = "); RequestFocus.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUsagePosition : RdBindableBase {
    //fields
    public int Line {get; private set;}
    public int Column {get; private set;}
    public int OccurrenceRangeStartOffset {get; private set;}
    public int OccurrenceRangeEndOffset {get; private set;}
    public int StartOffset {get; private set;}
    public int EndOffset {get; private set;}
    [NotNull] public string DocumentMoniker {get; private set;}
    
    //primary constructor
    public RdUsagePosition(
      int line,
      int column,
      int occurrenceRangeStartOffset,
      int occurrenceRangeEndOffset,
      int startOffset,
      int endOffset,
      [NotNull] string documentMoniker
    )
    {
      Line = line;
      Column = column;
      OccurrenceRangeStartOffset = occurrenceRangeStartOffset;
      OccurrenceRangeEndOffset = occurrenceRangeEndOffset;
      StartOffset = startOffset;
      EndOffset = endOffset;
      DocumentMoniker = documentMoniker;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUsagePosition> Read = (ctx, reader) => 
    {
      var line = reader.ReadInt();
      var column = reader.ReadInt();
      var occurrenceRangeStartOffset = reader.ReadInt();
      var occurrenceRangeEndOffset = reader.ReadInt();
      var startOffset = reader.ReadInt();
      var endOffset = reader.ReadInt();
      var documentMoniker = reader.ReadString();
      return new RdUsagePosition(line, column, occurrenceRangeStartOffset, occurrenceRangeEndOffset, startOffset, endOffset, documentMoniker);
    };
    
    public static CtxWriteDelegate<RdUsagePosition> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Line);
      writer.Write(value.Column);
      writer.Write(value.OccurrenceRangeStartOffset);
      writer.Write(value.OccurrenceRangeEndOffset);
      writer.Write(value.StartOffset);
      writer.Write(value.EndOffset);
      writer.Write(value.DocumentMoniker);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsagePosition (");
      using (printer.IndentCookie()) {
        printer.Print("line = "); Line.PrintEx(printer); printer.Println();
        printer.Print("column = "); Column.PrintEx(printer); printer.Println();
        printer.Print("occurrenceRangeStartOffset = "); OccurrenceRangeStartOffset.PrintEx(printer); printer.Println();
        printer.Print("occurrenceRangeEndOffset = "); OccurrenceRangeEndOffset.PrintEx(printer); printer.Println();
        printer.Print("startOffset = "); StartOffset.PrintEx(printer); printer.Println();
        printer.Print("endOffset = "); EndOffset.PrintEx(printer); printer.Println();
        printer.Print("documentMoniker = "); DocumentMoniker.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUsageTarget : RdBindableBase {
    //fields
    public int Index {get; private set;}
    [NotNull] public string ShortName {get; private set;}
    [NotNull] public string FullName {get; private set;}
    [NotNull] public IRdProperty<bool> IsValid { get { return _IsValid; }}
    [NotNull] private readonly RdProperty<bool> _IsValid;
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //primary constructor
    private RdUsageTarget(
      int index,
      [NotNull] string shortName,
      [NotNull] string fullName,
      [NotNull] RdProperty<bool> isValid,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    )
    {
      Index = index;
      ShortName = shortName;
      FullName = fullName;
      _IsValid = isValid;
      Icon = icon;
      isValid.OptimizeNested = true;
    }
    //secondary constructor
    public RdUsageTarget (
      int Index,
      [NotNull] string ShortName,
      [NotNull] string FullName,
      [CanBeNull] JetBrains.Rider.Model.Icon Icon
    ) : this (
      Index,
      ShortName,
      FullName,
      new RdProperty<bool>(),
      Icon
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<RdUsageTarget> Read = (ctx, reader) => 
    {
      var index = reader.ReadInt();
      var shortName = reader.ReadString();
      var fullName = reader.ReadString();
      var isValid = RdProperty<bool>.Read(ctx, reader);
      var icon = ReadIconNullable(ctx, reader);
      return new RdUsageTarget(index, shortName, fullName, isValid, icon);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<RdUsageTarget> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Index);
      writer.Write(value.ShortName);
      writer.Write(value.FullName);
      RdProperty<bool>.Write(ctx, writer, value._IsValid);
      WriteIconNullable(ctx, writer, value.Icon);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _IsValid.BindEx(lifetime, this, "isValid");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _IsValid.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsageTarget (");
      using (printer.IndentCookie()) {
        printer.Print("index = "); Index.PrintEx(printer); printer.Println();
        printer.Print("shortName = "); ShortName.PrintEx(printer); printer.Println();
        printer.Print("fullName = "); FullName.PrintEx(printer); printer.Println();
        printer.Print("isValid = "); _IsValid.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUsageTargetList : RdBindableBase {
    //fields
    [CanBeNull] public string Title {get; private set;}
    [NotNull] public List<RdUsageTarget> Items {get; private set;}
    [NotNull] public RdEndpoint<RdUsageTargetNavigationData, RdVoid> NavigateTo { get { return _NavigateTo; }}
    [NotNull] private readonly RdEndpoint<RdUsageTargetNavigationData, RdVoid> _NavigateTo;
    [NotNull] public RdEndpoint<int, RdVoid> UpdateItem { get { return _UpdateItem; }}
    [NotNull] private readonly RdEndpoint<int, RdVoid> _UpdateItem;
    
    //primary constructor
    private RdUsageTargetList(
      [CanBeNull] string title,
      [NotNull] List<RdUsageTarget> items,
      [NotNull] RdEndpoint<RdUsageTargetNavigationData, RdVoid> navigateTo,
      [NotNull] RdEndpoint<int, RdVoid> updateItem
    )
    {
      Title = title;
      Items = items;
      _NavigateTo = navigateTo;
      _UpdateItem = updateItem;
    }
    //secondary constructor
    public RdUsageTargetList (
      [CanBeNull] string Title,
      [NotNull] List<RdUsageTarget> Items
    ) : this (
      Title,
      Items,
      new RdEndpoint<RdUsageTargetNavigationData, RdVoid>(),
      new RdEndpoint<int, RdVoid>()
    ) {}
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<List<RdUsageTarget>> ReadRdUsageTargetList = RdUsageTarget.Read.List();
    public static CtxReadDelegate<RdUsageTargetList> Read = (ctx, reader) => 
    {
      var title = ReadStringNullable(ctx, reader);
      var items = ReadRdUsageTargetList(ctx, reader);
      var navigateTo = RdEndpoint<RdUsageTargetNavigationData, RdVoid>.Read(ctx, reader);
      var updateItem = RdEndpoint<int, RdVoid>.Read(ctx, reader);
      return new RdUsageTargetList(title, items, navigateTo, updateItem);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<List<RdUsageTarget>> WriteRdUsageTargetList = RdUsageTarget.Write.List();
    public static CtxWriteDelegate<RdUsageTargetList> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.Title);
      WriteRdUsageTargetList(ctx, writer, value.Items);
      RdEndpoint<RdUsageTargetNavigationData, RdVoid>.Write(ctx, writer, value._NavigateTo);
      RdEndpoint<int, RdVoid>.Write(ctx, writer, value._UpdateItem);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Items.BindEx(lifetime, this, "items");
      _NavigateTo.BindEx(lifetime, this, "navigateTo");
      _UpdateItem.BindEx(lifetime, this, "updateItem");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Items.IdentifyEx(ids);
      _NavigateTo.IdentifyEx(ids);
      _UpdateItem.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsageTargetList (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
        printer.Print("navigateTo = "); _NavigateTo.PrintEx(printer); printer.Println();
        printer.Print("updateItem = "); _UpdateItem.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUsageTargetNavigationData : IPrintable, IEquatable<RdUsageTargetNavigationData> {
    //fields
    public int Index {get; private set;}
    public bool RequestFocus {get; private set;}
    
    //primary constructor
    public RdUsageTargetNavigationData(
      int index,
      bool requestFocus
    )
    {
      Index = index;
      RequestFocus = requestFocus;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUsageTargetNavigationData> Read = (ctx, reader) => 
    {
      var index = reader.ReadInt();
      var requestFocus = reader.ReadBool();
      return new RdUsageTargetNavigationData(index, requestFocus);
    };
    
    public static CtxWriteDelegate<RdUsageTargetNavigationData> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Index);
      writer.Write(value.RequestFocus);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUsageTargetNavigationData) obj);
    }
    public bool Equals(RdUsageTargetNavigationData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Index == other.Index && RequestFocus == other.RequestFocus;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Index.GetHashCode();
        __r = __r*31 + RequestFocus.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUsageTargetNavigationData (");
      using (printer.IndentCookie()) {
        printer.Print("index = "); Index.PrintEx(printer); printer.Println();
        printer.Print("requestFocus = "); RequestFocus.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ReloadAndShowLogCommand : IPrintable, IEquatable<ReloadAndShowLogCommand> {
    //fields
    public int ProjectId {get; private set;}
    
    //primary constructor
    public ReloadAndShowLogCommand(
      int projectId
    )
    {
      ProjectId = projectId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ReloadAndShowLogCommand> Read = (ctx, reader) => 
    {
      var projectId = reader.ReadInt();
      return new ReloadAndShowLogCommand(projectId);
    };
    
    public static CtxWriteDelegate<ReloadAndShowLogCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProjectId);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ReloadAndShowLogCommand) obj);
    }
    public bool Equals(ReloadAndShowLogCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectId == other.ProjectId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + ProjectId.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ReloadAndShowLogCommand (");
      using (printer.IndentCookie()) {
        printer.Print("projectId = "); ProjectId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ReloadCommand : IPrintable, IEquatable<ReloadCommand> {
    //fields
    [NotNull] public List<int> ProjectIds {get; private set;}
    
    //primary constructor
    public ReloadCommand(
      [NotNull] List<int> projectIds
    )
    {
      ProjectIds = projectIds;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static CtxReadDelegate<ReloadCommand> Read = (ctx, reader) => 
    {
      var projectIds = ReadIntList(ctx, reader);
      return new ReloadCommand(projectIds);
    };
    
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static CtxWriteDelegate<ReloadCommand> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.ProjectIds);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ReloadCommand) obj);
    }
    public bool Equals(ReloadCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectIds.SequenceEqual(other.ProjectIds);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(ProjectIds);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ReloadCommand (");
      using (printer.IndentCookie()) {
        printer.Print("projectIds = "); ProjectIds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RemoveCommand : IPrintable, IEquatable<RemoveCommand> {
    //fields
    public int ItemId {get; private set;}
    
    //primary constructor
    public RemoveCommand(
      int itemId
    )
    {
      ItemId = itemId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RemoveCommand> Read = (ctx, reader) => 
    {
      var itemId = reader.ReadInt();
      return new RemoveCommand(itemId);
    };
    
    public static CtxWriteDelegate<RemoveCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemId);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RemoveCommand) obj);
    }
    public bool Equals(RemoveCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemId == other.ItemId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + ItemId.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RemoveCommand (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RenameItemCommand : IPrintable, IEquatable<RenameItemCommand> {
    //fields
    public int ItemId {get; private set;}
    [NotNull] public string ItemName {get; private set;}
    
    //primary constructor
    public RenameItemCommand(
      int itemId,
      [NotNull] string itemName
    )
    {
      ItemId = itemId;
      ItemName = itemName;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RenameItemCommand> Read = (ctx, reader) => 
    {
      var itemId = reader.ReadInt();
      var itemName = reader.ReadString();
      return new RenameItemCommand(itemId, itemName);
    };
    
    public static CtxWriteDelegate<RenameItemCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ItemId);
      writer.Write(value.ItemName);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RenameItemCommand) obj);
    }
    public bool Equals(RenameItemCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemId == other.ItemId && ItemName == other.ItemName;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + ItemId.GetHashCode();
        __r = __r*31 + ItemName.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RenameItemCommand (");
      using (printer.IndentCookie()) {
        printer.Print("itemId = "); ItemId.PrintEx(printer); printer.Println();
        printer.Print("itemName = "); ItemName.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ResolveExpressionArgs : IPrintable, IEquatable<ResolveExpressionArgs> {
    //fields
    [NotNull] public EditableEntityId DocumentId {get; private set;}
    public int Offset {get; private set;}
    public bool SideEffectsAllowed {get; private set;}
    
    //primary constructor
    public ResolveExpressionArgs(
      [NotNull] EditableEntityId documentId,
      int offset,
      bool sideEffectsAllowed
    )
    {
      DocumentId = documentId;
      Offset = offset;
      SideEffectsAllowed = sideEffectsAllowed;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ResolveExpressionArgs> Read = (ctx, reader) => 
    {
      var documentId = EditableEntityId.Read(ctx, reader);
      var offset = reader.ReadInt();
      var sideEffectsAllowed = reader.ReadBool();
      return new ResolveExpressionArgs(documentId, offset, sideEffectsAllowed);
    };
    
    public static CtxWriteDelegate<ResolveExpressionArgs> Write = (ctx, writer, value) => 
    {
      EditableEntityId.Write(ctx, writer, value.DocumentId);
      writer.Write(value.Offset);
      writer.Write(value.SideEffectsAllowed);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ResolveExpressionArgs) obj);
    }
    public bool Equals(ResolveExpressionArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(DocumentId, other.DocumentId) && Offset == other.Offset && SideEffectsAllowed == other.SideEffectsAllowed;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + DocumentId.GetHashCode();
        __r = __r*31 + Offset.GetHashCode();
        __r = __r*31 + SideEffectsAllowed.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ResolveExpressionArgs (");
      using (printer.IndentCookie()) {
        printer.Print("documentId = "); DocumentId.PrintEx(printer); printer.Println();
        printer.Print("offset = "); Offset.PrintEx(printer); printer.Println();
        printer.Print("sideEffectsAllowed = "); SideEffectsAllowed.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ResolveExpressionResult : IPrintable, IEquatable<ResolveExpressionResult> {
    //fields
    [NotNull] public RdTextRange TextRange {get; private set;}
    [CanBeNull] public string Expression {get; private set;}
    [CanBeNull] public string DisplayText {get; private set;}
    
    //primary constructor
    public ResolveExpressionResult(
      [NotNull] RdTextRange textRange,
      [CanBeNull] string expression,
      [CanBeNull] string displayText
    )
    {
      TextRange = textRange;
      Expression = expression;
      DisplayText = displayText;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<ResolveExpressionResult> Read = (ctx, reader) => 
    {
      var textRange = RdTextRange.Read(ctx, reader);
      var expression = ReadStringNullable(ctx, reader);
      var displayText = ReadStringNullable(ctx, reader);
      return new ResolveExpressionResult(textRange, expression, displayText);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<ResolveExpressionResult> Write = (ctx, writer, value) => 
    {
      RdTextRange.Write(ctx, writer, value.TextRange);
      WriteStringNullable(ctx, writer, value.Expression);
      WriteStringNullable(ctx, writer, value.DisplayText);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ResolveExpressionResult) obj);
    }
    public bool Equals(ResolveExpressionResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(TextRange, other.TextRange) && Equals(Expression, other.Expression) && Equals(DisplayText, other.DisplayText);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + TextRange.GetHashCode();
        __r = __r*31 + (Expression != null ?Expression.GetHashCode() : 0);
        __r = __r*31 + (DisplayText != null ?DisplayText.GetHashCode() : 0);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ResolveExpressionResult (");
      using (printer.IndentCookie()) {
        printer.Print("textRange = "); TextRange.PrintEx(printer); printer.Println();
        printer.Print("expression = "); Expression.PrintEx(printer); printer.Println();
        printer.Print("displayText = "); DisplayText.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ResolveLocalSymbolArg : IPrintable, IEquatable<ResolveLocalSymbolArg> {
    //fields
    [NotNull] public EditableEntityId DocumentId {get; private set;}
    public int Offset {get; private set;}
    [NotNull] public string Name {get; private set;}
    
    //primary constructor
    public ResolveLocalSymbolArg(
      [NotNull] EditableEntityId documentId,
      int offset,
      [NotNull] string name
    )
    {
      DocumentId = documentId;
      Offset = offset;
      Name = name;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ResolveLocalSymbolArg> Read = (ctx, reader) => 
    {
      var documentId = EditableEntityId.Read(ctx, reader);
      var offset = reader.ReadInt();
      var name = reader.ReadString();
      return new ResolveLocalSymbolArg(documentId, offset, name);
    };
    
    public static CtxWriteDelegate<ResolveLocalSymbolArg> Write = (ctx, writer, value) => 
    {
      EditableEntityId.Write(ctx, writer, value.DocumentId);
      writer.Write(value.Offset);
      writer.Write(value.Name);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ResolveLocalSymbolArg) obj);
    }
    public bool Equals(ResolveLocalSymbolArg other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(DocumentId, other.DocumentId) && Offset == other.Offset && Name == other.Name;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + DocumentId.GetHashCode();
        __r = __r*31 + Offset.GetHashCode();
        __r = __r*31 + Name.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ResolveLocalSymbolArg (");
      using (printer.IndentCookie()) {
        printer.Print("documentId = "); DocumentId.PrintEx(printer); printer.Println();
        printer.Print("offset = "); Offset.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ResolveLocalSymbolResult : IPrintable, IEquatable<ResolveLocalSymbolResult> {
    //fields
    public int DeclarationOffset {get; private set;}
    
    //primary constructor
    public ResolveLocalSymbolResult(
      int declarationOffset
    )
    {
      DeclarationOffset = declarationOffset;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ResolveLocalSymbolResult> Read = (ctx, reader) => 
    {
      var declarationOffset = reader.ReadInt();
      return new ResolveLocalSymbolResult(declarationOffset);
    };
    
    public static CtxWriteDelegate<ResolveLocalSymbolResult> Write = (ctx, writer, value) => 
    {
      writer.Write(value.DeclarationOffset);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ResolveLocalSymbolResult) obj);
    }
    public bool Equals(ResolveLocalSymbolResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return DeclarationOffset == other.DeclarationOffset;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + DeclarationOffset.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ResolveLocalSymbolResult (");
      using (printer.IndentCookie()) {
        printer.Print("declarationOffset = "); DeclarationOffset.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RiderBrowseMode {
    None,
    Declaration,
    TypeDeclaration,
    Implementation
  }
  
  
  public class RunnableProject : IPrintable, IEquatable<RunnableProject> {
    //fields
    [NotNull] public string Name {get; private set;}
    [NotNull] public string FullName {get; private set;}
    [NotNull] public string ProjectFilePath {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    public RunnableProjectKind Kind {get; private set;}
    public bool RunWithDefaultArguments {get; private set;}
    [NotNull] public List<ProjectOutput> ProjectOutputs {get; private set;}
    [NotNull] public List<string> DefaultArguments {get; private set;}
    
    //primary constructor
    public RunnableProject(
      [NotNull] string name,
      [NotNull] string fullName,
      [NotNull] string projectFilePath,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      RunnableProjectKind kind,
      bool runWithDefaultArguments,
      [NotNull] List<ProjectOutput> projectOutputs,
      [NotNull] List<string> defaultArguments
    )
    {
      Name = name;
      FullName = fullName;
      ProjectFilePath = projectFilePath;
      Icon = icon;
      Kind = kind;
      RunWithDefaultArguments = runWithDefaultArguments;
      ProjectOutputs = projectOutputs;
      DefaultArguments = defaultArguments;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<List<ProjectOutput>> ReadProjectOutputList = ProjectOutput.Read.List();
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static CtxReadDelegate<RunnableProject> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var fullName = reader.ReadString();
      var projectFilePath = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var kind = (RunnableProjectKind)reader.ReadInt();
      var runWithDefaultArguments = reader.ReadBool();
      var projectOutputs = ReadProjectOutputList(ctx, reader);
      var defaultArguments = ReadStringList(ctx, reader);
      return new RunnableProject(name, fullName, projectFilePath, icon, kind, runWithDefaultArguments, projectOutputs, defaultArguments);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<List<ProjectOutput>> WriteProjectOutputList = ProjectOutput.Write.List();
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static CtxWriteDelegate<RunnableProject> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      writer.Write(value.FullName);
      writer.Write(value.ProjectFilePath);
      WriteIconNullable(ctx, writer, value.Icon);
      writer.Write((int)value.Kind);
      writer.Write(value.RunWithDefaultArguments);
      WriteProjectOutputList(ctx, writer, value.ProjectOutputs);
      WriteStringList(ctx, writer, value.DefaultArguments);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RunnableProject) obj);
    }
    public bool Equals(RunnableProject other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && FullName == other.FullName && ProjectFilePath == other.ProjectFilePath && Equals(Icon, other.Icon) && Kind == other.Kind && RunWithDefaultArguments == other.RunWithDefaultArguments && ProjectOutputs.SequenceEqual(other.ProjectOutputs) && DefaultArguments.SequenceEqual(other.DefaultArguments);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Name.GetHashCode();
        __r = __r*31 + FullName.GetHashCode();
        __r = __r*31 + ProjectFilePath.GetHashCode();
        __r = __r*31 + (Icon != null ?Icon.GetHashCode() : 0);
        __r = __r*31 + (int) Kind;
        __r = __r*31 + RunWithDefaultArguments.GetHashCode();
        __r = __r*31 + CollectionUtil.GetHashCode(ProjectOutputs);
        __r = __r*31 + CollectionUtil.GetHashCode(DefaultArguments);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RunnableProject (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("fullName = "); FullName.PrintEx(printer); printer.Println();
        printer.Print("projectFilePath = "); ProjectFilePath.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
        printer.Print("runWithDefaultArguments = "); RunWithDefaultArguments.PrintEx(printer); printer.Println();
        printer.Print("projectOutputs = "); ProjectOutputs.PrintEx(printer); printer.Println();
        printer.Print("defaultArguments = "); DefaultArguments.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RunnableProjectKind {
    None,
    Console,
    DotNetCore,
    Web
  }
  
  
  public class RunnableProjectsModel : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<bool> IsReady { get { return _IsReady; }}
    [NotNull] private readonly RdProperty<bool> _IsReady;
    [NotNull] public IViewableMap<string, RunnableProject> Projects { get { return _Projects; }}
    [NotNull] private readonly RdMap<string, RunnableProject> _Projects;
    
    //primary constructor
    private RunnableProjectsModel(
      [NotNull] RdProperty<bool> isReady,
      [NotNull] RdMap<string, RunnableProject> projects
    )
    {
      _IsReady = isReady;
      _Projects = projects;
      isReady.OptimizeNested = true;
      projects.OptimizeNested = true;
    }
    //secondary constructor
    public RunnableProjectsModel (
    ) : this (
      new RdProperty<bool>(),
      new RdMap<string, RunnableProject>()
    ) {}
    //statics
    
    public static CtxReadDelegate<RunnableProjectsModel> Read = (ctx, reader) => 
    {
      var isReady = RdProperty<bool>.Read(ctx, reader);
      var projects = RdMap<string, RunnableProject>.Read(ctx, reader);
      return new RunnableProjectsModel(isReady, projects);
    };
    
    public static CtxWriteDelegate<RunnableProjectsModel> Write = (ctx, writer, value) => 
    {
      RdProperty<bool>.Write(ctx, writer, value._IsReady);
      RdMap<string, RunnableProject>.Write(ctx, writer, value._Projects);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _IsReady.BindEx(lifetime, this, "isReady");
      _Projects.BindEx(lifetime, this, "projects");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _IsReady.IdentifyEx(ids);
      _Projects.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RunnableProjectsModel (");
      using (printer.IndentCookie()) {
        printer.Print("isReady = "); _IsReady.PrintEx(printer); printer.Println();
        printer.Print("projects = "); _Projects.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ScrollKind {
    Center,
    UpperHalf,
    LowerHalf,
    Smart,
    Relative
  }
  
  
  public class ScrollingInfo : IPrintable, IEquatable<ScrollingInfo> {
    //fields
    public ScrollKind Kind {get; private set;}
    [CanBeNull] public int? DocOffset {get; private set;}
    
    //primary constructor
    public ScrollingInfo(
      ScrollKind kind,
      [CanBeNull] int? docOffset
    )
    {
      Kind = kind;
      DocOffset = docOffset;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<int?> ReadIntNullable = Serializers.ReadInt.NullableStruct();
    public static CtxReadDelegate<ScrollingInfo> Read = (ctx, reader) => 
    {
      var kind = (ScrollKind)reader.ReadInt();
      var docOffset = ReadIntNullable(ctx, reader);
      return new ScrollingInfo(kind, docOffset);
    };
    
    public static CtxWriteDelegate<int?> WriteIntNullable = Serializers.WriteInt.NullableStruct();
    public static CtxWriteDelegate<ScrollingInfo> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Kind);
      WriteIntNullable(ctx, writer, value.DocOffset);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ScrollingInfo) obj);
    }
    public bool Equals(ScrollingInfo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Kind == other.Kind && Equals(DocOffset, other.DocOffset);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (int) Kind;
        __r = __r*31 + (DocOffset != null ?DocOffset.GetHashCode() : 0);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ScrollingInfo (");
      using (printer.IndentCookie()) {
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
        printer.Print("docOffset = "); DocOffset.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SearchItemData : IPrintable, IEquatable<SearchItemData> {
    //fields
    [NotNull] public Icon IconId {get; private set;}
    public int Id {get; private set;}
    [NotNull] public string ShortName {get; private set;}
    [NotNull] public ModelRichText DisplayText {get; private set;}
    [CanBeNull] public string GlyphText {get; private set;}
    [CanBeNull] public Icon GlyphIconId {get; private set;}
    
    //primary constructor
    public SearchItemData(
      [NotNull] Icon iconId,
      int id,
      [NotNull] string shortName,
      [NotNull] ModelRichText displayText,
      [CanBeNull] string glyphText,
      [CanBeNull] Icon glyphIconId
    )
    {
      IconId = iconId;
      Id = id;
      ShortName = shortName;
      DisplayText = displayText;
      GlyphText = glyphText;
      GlyphIconId = glyphIconId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<Icon> ReadIconNullable = Icon.Read.NullableClass();
    public static CtxReadDelegate<SearchItemData> Read = (ctx, reader) => 
    {
      var iconId = Icon.Read(ctx, reader);
      var id = reader.ReadInt();
      var shortName = reader.ReadString();
      var displayText = ModelRichText.Read(ctx, reader);
      var glyphText = ReadStringNullable(ctx, reader);
      var glyphIconId = ReadIconNullable(ctx, reader);
      return new SearchItemData(iconId, id, shortName, displayText, glyphText, glyphIconId);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<Icon> WriteIconNullable = Icon.Write.NullableClass();
    public static CtxWriteDelegate<SearchItemData> Write = (ctx, writer, value) => 
    {
      Icon.Write(ctx, writer, value.IconId);
      writer.Write(value.Id);
      writer.Write(value.ShortName);
      ModelRichText.Write(ctx, writer, value.DisplayText);
      WriteStringNullable(ctx, writer, value.GlyphText);
      WriteIconNullable(ctx, writer, value.GlyphIconId);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SearchItemData) obj);
    }
    public bool Equals(SearchItemData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(IconId, other.IconId) && Id == other.Id && ShortName == other.ShortName && Equals(DisplayText, other.DisplayText) && Equals(GlyphText, other.GlyphText) && Equals(GlyphIconId, other.GlyphIconId);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + IconId.GetHashCode();
        __r = __r*31 + Id.GetHashCode();
        __r = __r*31 + ShortName.GetHashCode();
        __r = __r*31 + DisplayText.GetHashCode();
        __r = __r*31 + (GlyphText != null ?GlyphText.GetHashCode() : 0);
        __r = __r*31 + (GlyphIconId != null ?GlyphIconId.GetHashCode() : 0);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SearchItemData (");
      using (printer.IndentCookie()) {
        printer.Print("iconId = "); IconId.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("shortName = "); ShortName.PrintEx(printer); printer.Println();
        printer.Print("displayText = "); DisplayText.PrintEx(printer); printer.Println();
        printer.Print("glyphText = "); GlyphText.PrintEx(printer); printer.Println();
        printer.Print("glyphIconId = "); GlyphIconId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SearchPopup : RdBindableBase {
    //fields
    public GotoKind CurrentPopupKind {get; private set;}
    [NotNull] public ISink<SearchItemData> ItemExecutedSignal { get { return _ItemExecutedSignal; }}
    [NotNull] private readonly RdSignal<SearchItemData> _ItemExecutedSignal;
    [NotNull] public IRdProperty<SearchSessionTuple> CurrentSearchSession { get { return _CurrentSearchSession; }}
    [NotNull] private readonly RdProperty<SearchSessionTuple> _CurrentSearchSession;
    
    //primary constructor
    private SearchPopup(
      GotoKind currentPopupKind,
      [NotNull] RdSignal<SearchItemData> itemExecutedSignal,
      [NotNull] RdProperty<SearchSessionTuple> currentSearchSession
    )
    {
      CurrentPopupKind = currentPopupKind;
      _ItemExecutedSignal = itemExecutedSignal;
      _CurrentSearchSession = currentSearchSession;
      currentSearchSession.Async = true;
    }
    //secondary constructor
    public SearchPopup (
      GotoKind CurrentPopupKind
    ) : this (
      CurrentPopupKind,
      new RdSignal<SearchItemData>(),
      new RdProperty<SearchSessionTuple>()
    ) {}
    //statics
    
    public static CtxReadDelegate<SearchSessionTuple> ReadSearchSessionTupleNullable = SearchSessionTuple.Read.NullableClass();
    public static CtxReadDelegate<SearchPopup> Read = (ctx, reader) => 
    {
      var currentPopupKind = (GotoKind)reader.ReadInt();
      var itemExecutedSignal = RdSignal<SearchItemData>.Read(ctx, reader);
      var currentSearchSession = RdProperty<SearchSessionTuple>.Read(ctx, reader);
      return new SearchPopup(currentPopupKind, itemExecutedSignal, currentSearchSession);
    };
    
    public static CtxWriteDelegate<SearchSessionTuple> WriteSearchSessionTupleNullable = SearchSessionTuple.Write.NullableClass();
    public static CtxWriteDelegate<SearchPopup> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.CurrentPopupKind);
      RdSignal<SearchItemData>.Write(ctx, writer, value._ItemExecutedSignal);
      RdProperty<SearchSessionTuple>.Write(ctx, writer, value._CurrentSearchSession);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _ItemExecutedSignal.BindEx(lifetime, this, "itemExecutedSignal");
      _CurrentSearchSession.BindEx(lifetime, this, "currentSearchSession");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ItemExecutedSignal.IdentifyEx(ids);
      _CurrentSearchSession.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SearchPopup (");
      using (printer.IndentCookie()) {
        printer.Print("currentPopupKind = "); CurrentPopupKind.PrintEx(printer); printer.Println();
        printer.Print("itemExecutedSignal = "); _ItemExecutedSignal.PrintEx(printer); printer.Println();
        printer.Print("currentSearchSession = "); _CurrentSearchSession.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SearchSessionTuple : RdBindableBase {
    //fields
    public int Key {get; private set;}
    [NotNull] public GotoSearchSession Session {get; private set;}
    
    //primary constructor
    public SearchSessionTuple(
      int key,
      [NotNull] GotoSearchSession session
    )
    {
      Key = key;
      Session = session;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SearchSessionTuple> Read = (ctx, reader) => 
    {
      var key = reader.ReadInt();
      var session = GotoSearchSession.Read(ctx, reader);
      return new SearchSessionTuple(key, session);
    };
    
    public static CtxWriteDelegate<SearchSessionTuple> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Key);
      GotoSearchSession.Write(ctx, writer, value.Session);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Session.BindEx(lifetime, this, "session");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Session.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SearchSessionTuple (");
      using (printer.IndentCookie()) {
        printer.Print("key = "); Key.PrintEx(printer); printer.Println();
        printer.Print("session = "); Session.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SelectionRange : IPrintable, IEquatable<SelectionRange> {
    //fields
    public int SelectionAnchor {get; private set;}
    public int ActivePosition {get; private set;}
    
    //primary constructor
    public SelectionRange(
      int selectionAnchor,
      int activePosition
    )
    {
      SelectionAnchor = selectionAnchor;
      ActivePosition = activePosition;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SelectionRange> Read = (ctx, reader) => 
    {
      var selectionAnchor = reader.ReadInt();
      var activePosition = reader.ReadInt();
      return new SelectionRange(selectionAnchor, activePosition);
    };
    
    public static CtxWriteDelegate<SelectionRange> Write = (ctx, writer, value) => 
    {
      writer.Write(value.SelectionAnchor);
      writer.Write(value.ActivePosition);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SelectionRange) obj);
    }
    public bool Equals(SelectionRange other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return SelectionAnchor == other.SelectionAnchor && ActivePosition == other.ActivePosition;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + SelectionAnchor.GetHashCode();
        __r = __r*31 + ActivePosition.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SelectionRange (");
      using (printer.IndentCookie()) {
        printer.Print("selectionAnchor = "); SelectionAnchor.PrintEx(printer); printer.Println();
        printer.Print("activePosition = "); ActivePosition.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SessionStartDescriptor : IPrintable, IEquatable<SessionStartDescriptor> {
    //fields
    [NotNull] public string Name {get; private set;}
    [NotNull] public string ExecutablePath {get; private set;}
    [NotNull] public string WorkingDirPath {get; private set;}
    [NotNull] public string CommandLineArgs {get; private set;}
    [NotNull] public List<StringPair> EnvironmentVariables {get; private set;}
    public bool RedirectOutput {get; private set;}
    public bool IsCoreClr {get; private set;}
    
    //primary constructor
    public SessionStartDescriptor(
      [NotNull] string name,
      [NotNull] string executablePath,
      [NotNull] string workingDirPath,
      [NotNull] string commandLineArgs,
      [NotNull] List<StringPair> environmentVariables,
      bool redirectOutput,
      bool isCoreClr
    )
    {
      Name = name;
      ExecutablePath = executablePath;
      WorkingDirPath = workingDirPath;
      CommandLineArgs = commandLineArgs;
      EnvironmentVariables = environmentVariables;
      RedirectOutput = redirectOutput;
      IsCoreClr = isCoreClr;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<StringPair>> ReadStringPairList = StringPair.Read.List();
    public static CtxReadDelegate<SessionStartDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var executablePath = reader.ReadString();
      var workingDirPath = reader.ReadString();
      var commandLineArgs = reader.ReadString();
      var environmentVariables = ReadStringPairList(ctx, reader);
      var redirectOutput = reader.ReadBool();
      var isCoreClr = reader.ReadBool();
      return new SessionStartDescriptor(name, executablePath, workingDirPath, commandLineArgs, environmentVariables, redirectOutput, isCoreClr);
    };
    
    public static CtxWriteDelegate<List<StringPair>> WriteStringPairList = StringPair.Write.List();
    public static CtxWriteDelegate<SessionStartDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      writer.Write(value.ExecutablePath);
      writer.Write(value.WorkingDirPath);
      writer.Write(value.CommandLineArgs);
      WriteStringPairList(ctx, writer, value.EnvironmentVariables);
      writer.Write(value.RedirectOutput);
      writer.Write(value.IsCoreClr);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SessionStartDescriptor) obj);
    }
    public bool Equals(SessionStartDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && ExecutablePath == other.ExecutablePath && WorkingDirPath == other.WorkingDirPath && CommandLineArgs == other.CommandLineArgs && EnvironmentVariables.SequenceEqual(other.EnvironmentVariables) && RedirectOutput == other.RedirectOutput && IsCoreClr == other.IsCoreClr;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Name.GetHashCode();
        __r = __r*31 + ExecutablePath.GetHashCode();
        __r = __r*31 + WorkingDirPath.GetHashCode();
        __r = __r*31 + CommandLineArgs.GetHashCode();
        __r = __r*31 + CollectionUtil.GetHashCode(EnvironmentVariables);
        __r = __r*31 + RedirectOutput.GetHashCode();
        __r = __r*31 + IsCoreClr.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SessionStartDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("executablePath = "); ExecutablePath.PrintEx(printer); printer.Println();
        printer.Print("workingDirPath = "); WorkingDirPath.PrintEx(printer); printer.Println();
        printer.Print("commandLineArgs = "); CommandLineArgs.PrintEx(printer); printer.Println();
        printer.Print("environmentVariables = "); EnvironmentVariables.PrintEx(printer); printer.Println();
        printer.Print("redirectOutput = "); RedirectOutput.PrintEx(printer); printer.Println();
        printer.Print("isCoreClr = "); IsCoreClr.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum SessionState {
    FullItemsPrepared,
    ReturnedNull
  }
  
  
  public enum ShouldBeShown {
    Show,
    DoNotShow
  }
  
  
  public class SignatureItem : IPrintable, IEquatable<SignatureItem> {
    //fields
    [NotNull] public string Text {get; private set;}
    public bool IsDeprecated {get; private set;}
    [NotNull] public List<int> StartParamOffsets {get; private set;}
    [NotNull] public List<int> EndParamOffsets {get; private set;}
    
    //primary constructor
    public SignatureItem(
      [NotNull] string text,
      bool isDeprecated,
      [NotNull] List<int> startParamOffsets,
      [NotNull] List<int> endParamOffsets
    )
    {
      Text = text;
      IsDeprecated = isDeprecated;
      StartParamOffsets = startParamOffsets;
      EndParamOffsets = endParamOffsets;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static CtxReadDelegate<SignatureItem> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      var isDeprecated = reader.ReadBool();
      var startParamOffsets = ReadIntList(ctx, reader);
      var endParamOffsets = ReadIntList(ctx, reader);
      return new SignatureItem(text, isDeprecated, startParamOffsets, endParamOffsets);
    };
    
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static CtxWriteDelegate<SignatureItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
      writer.Write(value.IsDeprecated);
      WriteIntList(ctx, writer, value.StartParamOffsets);
      WriteIntList(ctx, writer, value.EndParamOffsets);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SignatureItem) obj);
    }
    public bool Equals(SignatureItem other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Text == other.Text && IsDeprecated == other.IsDeprecated && StartParamOffsets.SequenceEqual(other.StartParamOffsets) && EndParamOffsets.SequenceEqual(other.EndParamOffsets);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Text.GetHashCode();
        __r = __r*31 + IsDeprecated.GetHashCode();
        __r = __r*31 + CollectionUtil.GetHashCode(StartParamOffsets);
        __r = __r*31 + CollectionUtil.GetHashCode(EndParamOffsets);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SignatureItem (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("isDeprecated = "); IsDeprecated.PrintEx(printer); printer.Println();
        printer.Print("startParamOffsets = "); StartParamOffsets.PrintEx(printer); printer.Println();
        printer.Print("endParamOffsets = "); EndParamOffsets.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class SignatureListBase {
    //fields
    [CanBeNull] public int? MatchedSignature {get; private set;}
    public int CurrentParamIndex {get; private set;}
    [NotNull] public List<int> DisabledSignatures {get; private set;}
    
    //primary constructor
    protected SignatureListBase(
      [CanBeNull] int? matchedSignature,
      int currentParamIndex,
      [NotNull] List<int> disabledSignatures
    )
    {
      MatchedSignature = matchedSignature;
      CurrentParamIndex = currentParamIndex;
      DisabledSignatures = disabledSignatures;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SignatureListBase> Read = (ctx, reader) => ctx.Serializers.Read<SignatureListBase>(ctx, reader);
    
    public static CtxWriteDelegate<SignatureListBase> Write = (ctx, writer, value) => ctx.Serializers.Write<SignatureListBase>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class Solution : RdBindableBase {
    //fields
    [NotNull] public JetBrains.Rider.Model.SolutionProperties SolutionProperties {get; private set;}
    [NotNull] public JetBrains.Rider.Model.SolutionOpenStrategy SolutionOpenStrategy {get; private set;}
    [NotNull] public RdProjectModelView ProjectModelView {get; private set;}
    [NotNull] public JetBrains.Rider.Model.ProjectModelTasks ProjectModelTasks {get; private set;}
    [NotNull] public RdFileTemplateModel FileTemplateModel {get; private set;}
    [NotNull] public JetBrains.Rider.Model.ProjectPropertiesHostModel ProjectPropertiesHostModel {get; private set;}
    [NotNull] public JetBrains.Rider.Model.SolutionLifecycle SolutionLifecycle {get; private set;}
    [NotNull] public IViewableMap<GotoKind, SearchPopup> SearchPopups { get { return _SearchPopups; }}
    [NotNull] private readonly RdMap<GotoKind, SearchPopup> _SearchPopups;
    [NotNull] public EditableEntityCollection Editors {get; private set;}
    [NotNull] public JetBrains.Rider.Model.RunnableProjectsModel RunnableProjectsModel {get; private set;}
    [NotNull] public RdTypingAssistHost TypingAssistHost {get; private set;}
    [NotNull] public JetBrains.Rider.Model.ActionPopupSession ActionPopupSession {get; private set;}
    [NotNull] public RdFindUsagesHost FindUsagesHost {get; private set;}
    [NotNull] public JetBrains.Rider.Model.CodeStructureTree CodeStructureTree {get; private set;}
    [NotNull] public RdNuGetHost NuGetHost {get; private set;}
    [NotNull] public RdUnitTestHost UnitTestHost {get; private set;}
    [NotNull] public QuickDocHostModel QuickDocHost {get; private set;}
    [NotNull] public JetBrains.Rider.Model.SolutionAnalysisModel SolutionAnalysisModel {get; private set;}
    [NotNull] public ISource<Navigation> Navigate { get { return _Navigate; }}
    [NotNull] private readonly RdSignal<Navigation> _Navigate;
    [NotNull] public JetBrains.Rider.Model.StackTraceFilterProvider StackTraceFilterProvider {get; private set;}
    [NotNull] public JetBrains.Rider.Model.BreakpointHelperHost BreakpointHelperHost {get; private set;}
    [NotNull] public DebuggerWorkerConnectionHelperModel DebuggerWorkerConnectionHelper {get; private set;}
    [NotNull] public PsiDebuggerHostModel PsiDebuggerHost {get; private set;}
    [NotNull] public DebuggerSessionsHostModel DebuggerSessionsHost {get; private set;}
    [NotNull] public JetBrains.Rider.Model.TodoModel TodoModel {get; private set;}
    [NotNull] public RdPsiElementRangeProvider PsiElementRangeProvider {get; private set;}
    [NotNull] public RdEnsureWritableHandler FrontendEnsureWritableHandler {get; private set;}
    [NotNull] public JetBrains.Rider.Model.DebugCompletionProvider DebugCompletionProvider {get; private set;}
    [NotNull] public RdDiagnosticsHost DiagnosticsHost {get; private set;}
    [NotNull] public RdFileSystemModel FileSystemModel {get; private set;}
    [NotNull] public RdLiveTemplateHost LiveTemplateHost {get; private set;}
    [NotNull] public RdTextEditingGateway TextEditingGateway {get; private set;}
    [NotNull] public IViewableMap<int, string> IconStrings { get { return _IconStrings; }}
    [NotNull] private readonly RdMap<int, string> _IconStrings;
    [NotNull] public IRdProperty<HighlighterRegistryModel> HighlighterRegistry { get { return _HighlighterRegistry; }}
    [NotNull] private readonly RdProperty<HighlighterRegistryModel> _HighlighterRegistry;
    [NotNull] public IRdProperty<bool> IsLoaded { get { return _IsLoaded; }}
    [NotNull] private readonly RdProperty<bool> _IsLoaded;
    [NotNull] public IRdProperty<bool> IsLoading { get { return _IsLoading; }}
    [NotNull] private readonly RdProperty<bool> _IsLoading;
    [NotNull] public IRdProperty<bool> IsDotNetCoreReady { get { return _IsDotNetCoreReady; }}
    [NotNull] private readonly RdProperty<bool> _IsDotNetCoreReady;
    [NotNull] public ISink<bool> InvalidateCaches { get { return _InvalidateCaches; }}
    [NotNull] private readonly RdSignal<bool> _InvalidateCaches;
    
    //primary constructor
    private Solution(
      [NotNull] JetBrains.Rider.Model.SolutionProperties solutionProperties,
      [NotNull] JetBrains.Rider.Model.SolutionOpenStrategy solutionOpenStrategy,
      [NotNull] RdProjectModelView projectModelView,
      [NotNull] JetBrains.Rider.Model.ProjectModelTasks projectModelTasks,
      [NotNull] RdFileTemplateModel fileTemplateModel,
      [NotNull] JetBrains.Rider.Model.ProjectPropertiesHostModel projectPropertiesHostModel,
      [NotNull] JetBrains.Rider.Model.SolutionLifecycle solutionLifecycle,
      [NotNull] RdMap<GotoKind, SearchPopup> searchPopups,
      [NotNull] EditableEntityCollection editors,
      [NotNull] JetBrains.Rider.Model.RunnableProjectsModel runnableProjectsModel,
      [NotNull] RdTypingAssistHost typingAssistHost,
      [NotNull] JetBrains.Rider.Model.ActionPopupSession actionPopupSession,
      [NotNull] RdFindUsagesHost findUsagesHost,
      [NotNull] JetBrains.Rider.Model.CodeStructureTree codeStructureTree,
      [NotNull] RdNuGetHost nuGetHost,
      [NotNull] RdUnitTestHost unitTestHost,
      [NotNull] QuickDocHostModel quickDocHost,
      [NotNull] JetBrains.Rider.Model.SolutionAnalysisModel solutionAnalysisModel,
      [NotNull] RdSignal<Navigation> navigate,
      [NotNull] JetBrains.Rider.Model.StackTraceFilterProvider stackTraceFilterProvider,
      [NotNull] JetBrains.Rider.Model.BreakpointHelperHost breakpointHelperHost,
      [NotNull] DebuggerWorkerConnectionHelperModel debuggerWorkerConnectionHelper,
      [NotNull] PsiDebuggerHostModel psiDebuggerHost,
      [NotNull] DebuggerSessionsHostModel debuggerSessionsHost,
      [NotNull] JetBrains.Rider.Model.TodoModel todoModel,
      [NotNull] RdPsiElementRangeProvider psiElementRangeProvider,
      [NotNull] RdEnsureWritableHandler frontendEnsureWritableHandler,
      [NotNull] JetBrains.Rider.Model.DebugCompletionProvider debugCompletionProvider,
      [NotNull] RdDiagnosticsHost diagnosticsHost,
      [NotNull] RdFileSystemModel fileSystemModel,
      [NotNull] RdLiveTemplateHost liveTemplateHost,
      [NotNull] RdTextEditingGateway textEditingGateway,
      [NotNull] RdMap<int, string> iconStrings,
      [NotNull] RdProperty<HighlighterRegistryModel> highlighterRegistry,
      [NotNull] RdProperty<bool> isLoaded,
      [NotNull] RdProperty<bool> isLoading,
      [NotNull] RdProperty<bool> isDotNetCoreReady,
      [NotNull] RdSignal<bool> invalidateCaches
    )
    {
      SolutionProperties = solutionProperties;
      SolutionOpenStrategy = solutionOpenStrategy;
      ProjectModelView = projectModelView;
      ProjectModelTasks = projectModelTasks;
      FileTemplateModel = fileTemplateModel;
      ProjectPropertiesHostModel = projectPropertiesHostModel;
      SolutionLifecycle = solutionLifecycle;
      _SearchPopups = searchPopups;
      Editors = editors;
      RunnableProjectsModel = runnableProjectsModel;
      TypingAssistHost = typingAssistHost;
      ActionPopupSession = actionPopupSession;
      FindUsagesHost = findUsagesHost;
      CodeStructureTree = codeStructureTree;
      NuGetHost = nuGetHost;
      UnitTestHost = unitTestHost;
      QuickDocHost = quickDocHost;
      SolutionAnalysisModel = solutionAnalysisModel;
      _Navigate = navigate;
      StackTraceFilterProvider = stackTraceFilterProvider;
      BreakpointHelperHost = breakpointHelperHost;
      DebuggerWorkerConnectionHelper = debuggerWorkerConnectionHelper;
      PsiDebuggerHost = psiDebuggerHost;
      DebuggerSessionsHost = debuggerSessionsHost;
      TodoModel = todoModel;
      PsiElementRangeProvider = psiElementRangeProvider;
      FrontendEnsureWritableHandler = frontendEnsureWritableHandler;
      DebugCompletionProvider = debugCompletionProvider;
      DiagnosticsHost = diagnosticsHost;
      FileSystemModel = fileSystemModel;
      LiveTemplateHost = liveTemplateHost;
      TextEditingGateway = textEditingGateway;
      _IconStrings = iconStrings;
      _HighlighterRegistry = highlighterRegistry;
      _IsLoaded = isLoaded;
      _IsLoading = isLoading;
      _IsDotNetCoreReady = isDotNetCoreReady;
      _InvalidateCaches = invalidateCaches;
      iconStrings.OptimizeNested = true;
      isLoaded.OptimizeNested = true;
      isLoading.OptimizeNested = true;
      isDotNetCoreReady.OptimizeNested = true;
    }
    //secondary constructor
    public Solution (
      [NotNull] JetBrains.Rider.Model.SolutionOpenStrategy SolutionOpenStrategy
    ) : this (
      new JetBrains.Rider.Model.SolutionProperties(),
      SolutionOpenStrategy,
      new RdProjectModelView(),
      new JetBrains.Rider.Model.ProjectModelTasks(),
      new RdFileTemplateModel(),
      new JetBrains.Rider.Model.ProjectPropertiesHostModel(),
      new JetBrains.Rider.Model.SolutionLifecycle(),
      new RdMap<GotoKind, SearchPopup>(),
      new EditableEntityCollection(),
      new JetBrains.Rider.Model.RunnableProjectsModel(),
      new RdTypingAssistHost(),
      new JetBrains.Rider.Model.ActionPopupSession(),
      new RdFindUsagesHost(),
      new JetBrains.Rider.Model.CodeStructureTree(),
      new RdNuGetHost(),
      new RdUnitTestHost(),
      new QuickDocHostModel(),
      new JetBrains.Rider.Model.SolutionAnalysisModel(),
      new RdSignal<Navigation>(),
      new JetBrains.Rider.Model.StackTraceFilterProvider(),
      new JetBrains.Rider.Model.BreakpointHelperHost(),
      new DebuggerWorkerConnectionHelperModel(),
      new PsiDebuggerHostModel(),
      new DebuggerSessionsHostModel(),
      new JetBrains.Rider.Model.TodoModel(),
      new RdPsiElementRangeProvider(),
      new RdEnsureWritableHandler(),
      new JetBrains.Rider.Model.DebugCompletionProvider(),
      new RdDiagnosticsHost(),
      new RdFileSystemModel(),
      new RdLiveTemplateHost(),
      new RdTextEditingGateway(),
      new RdMap<int, string>(),
      new RdProperty<HighlighterRegistryModel>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdSignal<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<GotoKind> ReadGotoKind = new CtxReadDelegate<GotoKind>(Serializers.ReadEnum<GotoKind>);
    public static CtxReadDelegate<Solution> Read = (ctx, reader) => 
    {
      var solutionProperties = JetBrains.Rider.Model.SolutionProperties.Read(ctx, reader);
      var solutionOpenStrategy = JetBrains.Rider.Model.SolutionOpenStrategy.Read(ctx, reader);
      var projectModelView = RdProjectModelView.Read(ctx, reader);
      var projectModelTasks = JetBrains.Rider.Model.ProjectModelTasks.Read(ctx, reader);
      var fileTemplateModel = RdFileTemplateModel.Read(ctx, reader);
      var projectPropertiesHostModel = JetBrains.Rider.Model.ProjectPropertiesHostModel.Read(ctx, reader);
      var solutionLifecycle = JetBrains.Rider.Model.SolutionLifecycle.Read(ctx, reader);
      var searchPopups = RdMap<GotoKind, SearchPopup>.Read(ctx, reader);
      var editors = EditableEntityCollection.Read(ctx, reader);
      var runnableProjectsModel = JetBrains.Rider.Model.RunnableProjectsModel.Read(ctx, reader);
      var typingAssistHost = RdTypingAssistHost.Read(ctx, reader);
      var actionPopupSession = JetBrains.Rider.Model.ActionPopupSession.Read(ctx, reader);
      var findUsagesHost = RdFindUsagesHost.Read(ctx, reader);
      var codeStructureTree = JetBrains.Rider.Model.CodeStructureTree.Read(ctx, reader);
      var nuGetHost = RdNuGetHost.Read(ctx, reader);
      var unitTestHost = RdUnitTestHost.Read(ctx, reader);
      var quickDocHost = QuickDocHostModel.Read(ctx, reader);
      var solutionAnalysisModel = JetBrains.Rider.Model.SolutionAnalysisModel.Read(ctx, reader);
      var navigate = RdSignal<Navigation>.Read(ctx, reader);
      var stackTraceFilterProvider = JetBrains.Rider.Model.StackTraceFilterProvider.Read(ctx, reader);
      var breakpointHelperHost = JetBrains.Rider.Model.BreakpointHelperHost.Read(ctx, reader);
      var debuggerWorkerConnectionHelper = DebuggerWorkerConnectionHelperModel.Read(ctx, reader);
      var psiDebuggerHost = PsiDebuggerHostModel.Read(ctx, reader);
      var debuggerSessionsHost = DebuggerSessionsHostModel.Read(ctx, reader);
      var todoModel = JetBrains.Rider.Model.TodoModel.Read(ctx, reader);
      var psiElementRangeProvider = RdPsiElementRangeProvider.Read(ctx, reader);
      var frontendEnsureWritableHandler = RdEnsureWritableHandler.Read(ctx, reader);
      var debugCompletionProvider = JetBrains.Rider.Model.DebugCompletionProvider.Read(ctx, reader);
      var diagnosticsHost = RdDiagnosticsHost.Read(ctx, reader);
      var fileSystemModel = RdFileSystemModel.Read(ctx, reader);
      var liveTemplateHost = RdLiveTemplateHost.Read(ctx, reader);
      var textEditingGateway = RdTextEditingGateway.Read(ctx, reader);
      var iconStrings = RdMap<int, string>.Read(ctx, reader);
      var highlighterRegistry = RdProperty<HighlighterRegistryModel>.Read(ctx, reader);
      var isLoaded = RdProperty<bool>.Read(ctx, reader);
      var isLoading = RdProperty<bool>.Read(ctx, reader);
      var isDotNetCoreReady = RdProperty<bool>.Read(ctx, reader);
      var invalidateCaches = RdSignal<bool>.Read(ctx, reader);
      return new Solution(solutionProperties, solutionOpenStrategy, projectModelView, projectModelTasks, fileTemplateModel, projectPropertiesHostModel, solutionLifecycle, searchPopups, editors, runnableProjectsModel, typingAssistHost, actionPopupSession, findUsagesHost, codeStructureTree, nuGetHost, unitTestHost, quickDocHost, solutionAnalysisModel, navigate, stackTraceFilterProvider, breakpointHelperHost, debuggerWorkerConnectionHelper, psiDebuggerHost, debuggerSessionsHost, todoModel, psiElementRangeProvider, frontendEnsureWritableHandler, debugCompletionProvider, diagnosticsHost, fileSystemModel, liveTemplateHost, textEditingGateway, iconStrings, highlighterRegistry, isLoaded, isLoading, isDotNetCoreReady, invalidateCaches);
    };
    
    public static CtxWriteDelegate<GotoKind> WriteGotoKind = new CtxWriteDelegate<GotoKind>(Serializers.WriteEnum<GotoKind>);
    public static CtxWriteDelegate<Solution> Write = (ctx, writer, value) => 
    {
      JetBrains.Rider.Model.SolutionProperties.Write(ctx, writer, value.SolutionProperties);
      JetBrains.Rider.Model.SolutionOpenStrategy.Write(ctx, writer, value.SolutionOpenStrategy);
      RdProjectModelView.Write(ctx, writer, value.ProjectModelView);
      JetBrains.Rider.Model.ProjectModelTasks.Write(ctx, writer, value.ProjectModelTasks);
      RdFileTemplateModel.Write(ctx, writer, value.FileTemplateModel);
      JetBrains.Rider.Model.ProjectPropertiesHostModel.Write(ctx, writer, value.ProjectPropertiesHostModel);
      JetBrains.Rider.Model.SolutionLifecycle.Write(ctx, writer, value.SolutionLifecycle);
      RdMap<GotoKind, SearchPopup>.Write(ctx, writer, value._SearchPopups);
      EditableEntityCollection.Write(ctx, writer, value.Editors);
      JetBrains.Rider.Model.RunnableProjectsModel.Write(ctx, writer, value.RunnableProjectsModel);
      RdTypingAssistHost.Write(ctx, writer, value.TypingAssistHost);
      JetBrains.Rider.Model.ActionPopupSession.Write(ctx, writer, value.ActionPopupSession);
      RdFindUsagesHost.Write(ctx, writer, value.FindUsagesHost);
      JetBrains.Rider.Model.CodeStructureTree.Write(ctx, writer, value.CodeStructureTree);
      RdNuGetHost.Write(ctx, writer, value.NuGetHost);
      RdUnitTestHost.Write(ctx, writer, value.UnitTestHost);
      QuickDocHostModel.Write(ctx, writer, value.QuickDocHost);
      JetBrains.Rider.Model.SolutionAnalysisModel.Write(ctx, writer, value.SolutionAnalysisModel);
      RdSignal<Navigation>.Write(ctx, writer, value._Navigate);
      JetBrains.Rider.Model.StackTraceFilterProvider.Write(ctx, writer, value.StackTraceFilterProvider);
      JetBrains.Rider.Model.BreakpointHelperHost.Write(ctx, writer, value.BreakpointHelperHost);
      DebuggerWorkerConnectionHelperModel.Write(ctx, writer, value.DebuggerWorkerConnectionHelper);
      PsiDebuggerHostModel.Write(ctx, writer, value.PsiDebuggerHost);
      DebuggerSessionsHostModel.Write(ctx, writer, value.DebuggerSessionsHost);
      JetBrains.Rider.Model.TodoModel.Write(ctx, writer, value.TodoModel);
      RdPsiElementRangeProvider.Write(ctx, writer, value.PsiElementRangeProvider);
      RdEnsureWritableHandler.Write(ctx, writer, value.FrontendEnsureWritableHandler);
      JetBrains.Rider.Model.DebugCompletionProvider.Write(ctx, writer, value.DebugCompletionProvider);
      RdDiagnosticsHost.Write(ctx, writer, value.DiagnosticsHost);
      RdFileSystemModel.Write(ctx, writer, value.FileSystemModel);
      RdLiveTemplateHost.Write(ctx, writer, value.LiveTemplateHost);
      RdTextEditingGateway.Write(ctx, writer, value.TextEditingGateway);
      RdMap<int, string>.Write(ctx, writer, value._IconStrings);
      RdProperty<HighlighterRegistryModel>.Write(ctx, writer, value._HighlighterRegistry);
      RdProperty<bool>.Write(ctx, writer, value._IsLoaded);
      RdProperty<bool>.Write(ctx, writer, value._IsLoading);
      RdProperty<bool>.Write(ctx, writer, value._IsDotNetCoreReady);
      RdSignal<bool>.Write(ctx, writer, value._InvalidateCaches);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      SolutionProperties.BindEx(lifetime, this, "solutionProperties");
      SolutionOpenStrategy.BindEx(lifetime, this, "solutionOpenStrategy");
      ProjectModelView.BindEx(lifetime, this, "projectModelView");
      ProjectModelTasks.BindEx(lifetime, this, "projectModelTasks");
      FileTemplateModel.BindEx(lifetime, this, "fileTemplateModel");
      ProjectPropertiesHostModel.BindEx(lifetime, this, "projectPropertiesHostModel");
      SolutionLifecycle.BindEx(lifetime, this, "solutionLifecycle");
      _SearchPopups.BindEx(lifetime, this, "searchPopups");
      Editors.BindEx(lifetime, this, "editors");
      RunnableProjectsModel.BindEx(lifetime, this, "runnableProjectsModel");
      TypingAssistHost.BindEx(lifetime, this, "typingAssistHost");
      ActionPopupSession.BindEx(lifetime, this, "actionPopupSession");
      FindUsagesHost.BindEx(lifetime, this, "findUsagesHost");
      CodeStructureTree.BindEx(lifetime, this, "codeStructureTree");
      NuGetHost.BindEx(lifetime, this, "nuGetHost");
      UnitTestHost.BindEx(lifetime, this, "unitTestHost");
      QuickDocHost.BindEx(lifetime, this, "quickDocHost");
      SolutionAnalysisModel.BindEx(lifetime, this, "solutionAnalysisModel");
      _Navigate.BindEx(lifetime, this, "navigate");
      StackTraceFilterProvider.BindEx(lifetime, this, "stackTraceFilterProvider");
      BreakpointHelperHost.BindEx(lifetime, this, "breakpointHelperHost");
      DebuggerWorkerConnectionHelper.BindEx(lifetime, this, "debuggerWorkerConnectionHelper");
      PsiDebuggerHost.BindEx(lifetime, this, "psiDebuggerHost");
      DebuggerSessionsHost.BindEx(lifetime, this, "debuggerSessionsHost");
      TodoModel.BindEx(lifetime, this, "todoModel");
      PsiElementRangeProvider.BindEx(lifetime, this, "psiElementRangeProvider");
      FrontendEnsureWritableHandler.BindEx(lifetime, this, "frontendEnsureWritableHandler");
      DebugCompletionProvider.BindEx(lifetime, this, "debugCompletionProvider");
      DiagnosticsHost.BindEx(lifetime, this, "diagnosticsHost");
      FileSystemModel.BindEx(lifetime, this, "fileSystemModel");
      LiveTemplateHost.BindEx(lifetime, this, "liveTemplateHost");
      TextEditingGateway.BindEx(lifetime, this, "textEditingGateway");
      _IconStrings.BindEx(lifetime, this, "iconStrings");
      _HighlighterRegistry.BindEx(lifetime, this, "highlighterRegistry");
      _IsLoaded.BindEx(lifetime, this, "isLoaded");
      _IsLoading.BindEx(lifetime, this, "isLoading");
      _IsDotNetCoreReady.BindEx(lifetime, this, "isDotNetCoreReady");
      _InvalidateCaches.BindEx(lifetime, this, "invalidateCaches");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      SolutionProperties.IdentifyEx(ids);
      SolutionOpenStrategy.IdentifyEx(ids);
      ProjectModelView.IdentifyEx(ids);
      ProjectModelTasks.IdentifyEx(ids);
      FileTemplateModel.IdentifyEx(ids);
      ProjectPropertiesHostModel.IdentifyEx(ids);
      SolutionLifecycle.IdentifyEx(ids);
      _SearchPopups.IdentifyEx(ids);
      Editors.IdentifyEx(ids);
      RunnableProjectsModel.IdentifyEx(ids);
      TypingAssistHost.IdentifyEx(ids);
      ActionPopupSession.IdentifyEx(ids);
      FindUsagesHost.IdentifyEx(ids);
      CodeStructureTree.IdentifyEx(ids);
      NuGetHost.IdentifyEx(ids);
      UnitTestHost.IdentifyEx(ids);
      QuickDocHost.IdentifyEx(ids);
      SolutionAnalysisModel.IdentifyEx(ids);
      _Navigate.IdentifyEx(ids);
      StackTraceFilterProvider.IdentifyEx(ids);
      BreakpointHelperHost.IdentifyEx(ids);
      DebuggerWorkerConnectionHelper.IdentifyEx(ids);
      PsiDebuggerHost.IdentifyEx(ids);
      DebuggerSessionsHost.IdentifyEx(ids);
      TodoModel.IdentifyEx(ids);
      PsiElementRangeProvider.IdentifyEx(ids);
      FrontendEnsureWritableHandler.IdentifyEx(ids);
      DebugCompletionProvider.IdentifyEx(ids);
      DiagnosticsHost.IdentifyEx(ids);
      FileSystemModel.IdentifyEx(ids);
      LiveTemplateHost.IdentifyEx(ids);
      TextEditingGateway.IdentifyEx(ids);
      _IconStrings.IdentifyEx(ids);
      _HighlighterRegistry.IdentifyEx(ids);
      _IsLoaded.IdentifyEx(ids);
      _IsLoading.IdentifyEx(ids);
      _IsDotNetCoreReady.IdentifyEx(ids);
      _InvalidateCaches.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("Solution (");
      using (printer.IndentCookie()) {
        printer.Print("solutionProperties = "); SolutionProperties.PrintEx(printer); printer.Println();
        printer.Print("solutionOpenStrategy = "); SolutionOpenStrategy.PrintEx(printer); printer.Println();
        printer.Print("projectModelView = "); ProjectModelView.PrintEx(printer); printer.Println();
        printer.Print("projectModelTasks = "); ProjectModelTasks.PrintEx(printer); printer.Println();
        printer.Print("fileTemplateModel = "); FileTemplateModel.PrintEx(printer); printer.Println();
        printer.Print("projectPropertiesHostModel = "); ProjectPropertiesHostModel.PrintEx(printer); printer.Println();
        printer.Print("solutionLifecycle = "); SolutionLifecycle.PrintEx(printer); printer.Println();
        printer.Print("searchPopups = "); _SearchPopups.PrintEx(printer); printer.Println();
        printer.Print("editors = "); Editors.PrintEx(printer); printer.Println();
        printer.Print("runnableProjectsModel = "); RunnableProjectsModel.PrintEx(printer); printer.Println();
        printer.Print("typingAssistHost = "); TypingAssistHost.PrintEx(printer); printer.Println();
        printer.Print("actionPopupSession = "); ActionPopupSession.PrintEx(printer); printer.Println();
        printer.Print("findUsagesHost = "); FindUsagesHost.PrintEx(printer); printer.Println();
        printer.Print("codeStructureTree = "); CodeStructureTree.PrintEx(printer); printer.Println();
        printer.Print("nuGetHost = "); NuGetHost.PrintEx(printer); printer.Println();
        printer.Print("unitTestHost = "); UnitTestHost.PrintEx(printer); printer.Println();
        printer.Print("quickDocHost = "); QuickDocHost.PrintEx(printer); printer.Println();
        printer.Print("solutionAnalysisModel = "); SolutionAnalysisModel.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
        printer.Print("stackTraceFilterProvider = "); StackTraceFilterProvider.PrintEx(printer); printer.Println();
        printer.Print("breakpointHelperHost = "); BreakpointHelperHost.PrintEx(printer); printer.Println();
        printer.Print("debuggerWorkerConnectionHelper = "); DebuggerWorkerConnectionHelper.PrintEx(printer); printer.Println();
        printer.Print("psiDebuggerHost = "); PsiDebuggerHost.PrintEx(printer); printer.Println();
        printer.Print("debuggerSessionsHost = "); DebuggerSessionsHost.PrintEx(printer); printer.Println();
        printer.Print("todoModel = "); TodoModel.PrintEx(printer); printer.Println();
        printer.Print("psiElementRangeProvider = "); PsiElementRangeProvider.PrintEx(printer); printer.Println();
        printer.Print("frontendEnsureWritableHandler = "); FrontendEnsureWritableHandler.PrintEx(printer); printer.Println();
        printer.Print("debugCompletionProvider = "); DebugCompletionProvider.PrintEx(printer); printer.Println();
        printer.Print("diagnosticsHost = "); DiagnosticsHost.PrintEx(printer); printer.Println();
        printer.Print("fileSystemModel = "); FileSystemModel.PrintEx(printer); printer.Println();
        printer.Print("liveTemplateHost = "); LiveTemplateHost.PrintEx(printer); printer.Println();
        printer.Print("textEditingGateway = "); TextEditingGateway.PrintEx(printer); printer.Println();
        printer.Print("iconStrings = "); _IconStrings.PrintEx(printer); printer.Println();
        printer.Print("highlighterRegistry = "); _HighlighterRegistry.PrintEx(printer); printer.Println();
        printer.Print("isLoaded = "); _IsLoaded.PrintEx(printer); printer.Println();
        printer.Print("isLoading = "); _IsLoading.PrintEx(printer); printer.Println();
        printer.Print("isDotNetCoreReady = "); _IsDotNetCoreReady.PrintEx(printer); printer.Println();
        printer.Print("invalidateCaches = "); _InvalidateCaches.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum SolutionAnalysisAction {
    ReanalyzeAll,
    GotoPrevious,
    GotoNext
  }
  
  
  public class SolutionAnalysisError : IPrintable, IEquatable<SolutionAnalysisError> {
    //fields
    [NotNull] public string Text {get; private set;}
    public int Offset {get; private set;}
    
    //primary constructor
    public SolutionAnalysisError(
      [NotNull] string text,
      int offset
    )
    {
      Text = text;
      Offset = offset;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SolutionAnalysisError> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      var offset = reader.ReadInt();
      return new SolutionAnalysisError(text, offset);
    };
    
    public static CtxWriteDelegate<SolutionAnalysisError> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
      writer.Write(value.Offset);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SolutionAnalysisError) obj);
    }
    public bool Equals(SolutionAnalysisError other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Text == other.Text && Offset == other.Offset;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Text.GetHashCode();
        __r = __r*31 + Offset.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisError (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("offset = "); Offset.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionAnalysisErrorListWithIgnore : RdBindableBase {
    //fields
    [NotNull] public List<SolutionAnalysisErrorWithIgnore> Errors {get; private set;}
    
    //primary constructor
    public SolutionAnalysisErrorListWithIgnore(
      [NotNull] List<SolutionAnalysisErrorWithIgnore> errors
    )
    {
      Errors = errors;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<SolutionAnalysisErrorWithIgnore>> ReadSolutionAnalysisErrorWithIgnoreList = SolutionAnalysisErrorWithIgnore.Read.List();
    public static CtxReadDelegate<SolutionAnalysisErrorListWithIgnore> Read = (ctx, reader) => 
    {
      var errors = ReadSolutionAnalysisErrorWithIgnoreList(ctx, reader);
      return new SolutionAnalysisErrorListWithIgnore(errors);
    };
    
    public static CtxWriteDelegate<List<SolutionAnalysisErrorWithIgnore>> WriteSolutionAnalysisErrorWithIgnoreList = SolutionAnalysisErrorWithIgnore.Write.List();
    public static CtxWriteDelegate<SolutionAnalysisErrorListWithIgnore> Write = (ctx, writer, value) => 
    {
      WriteSolutionAnalysisErrorWithIgnoreList(ctx, writer, value.Errors);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Errors.BindEx(lifetime, this, "errors");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Errors.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisErrorListWithIgnore (");
      using (printer.IndentCookie()) {
        printer.Print("errors = "); Errors.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionAnalysisErrorWithIgnore : RdBindableBase {
    //fields
    [NotNull] public string Text {get; private set;}
    public int Offset {get; private set;}
    public bool Ignored {get; private set;}
    
    //primary constructor
    public SolutionAnalysisErrorWithIgnore(
      [NotNull] string text,
      int offset,
      bool ignored
    )
    {
      Text = text;
      Offset = offset;
      Ignored = ignored;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SolutionAnalysisErrorWithIgnore> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      var offset = reader.ReadInt();
      var ignored = reader.ReadBool();
      return new SolutionAnalysisErrorWithIgnore(text, offset, ignored);
    };
    
    public static CtxWriteDelegate<SolutionAnalysisErrorWithIgnore> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
      writer.Write(value.Offset);
      writer.Write(value.Ignored);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisErrorWithIgnore (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("offset = "); Offset.PrintEx(printer); printer.Println();
        printer.Print("ignored = "); Ignored.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionAnalysisErrors : RdBindableBase {
    //fields
    [NotNull] public string FileName {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public IRdProperty<int> NotHiddenErrorCount { get { return _NotHiddenErrorCount; }}
    [NotNull] private readonly RdProperty<int> _NotHiddenErrorCount;
    [NotNull] public IRdProperty<int> TotalErrorCount { get { return _TotalErrorCount; }}
    [NotNull] private readonly RdProperty<int> _TotalErrorCount;
    [NotNull] public IRdProperty<SolutionAnalysisErrorListWithIgnore> Errors { get { return _Errors; }}
    [NotNull] private readonly RdProperty<SolutionAnalysisErrorListWithIgnore> _Errors;
    [NotNull] public IRdProperty<bool> RequireUpdates { get { return _RequireUpdates; }}
    [NotNull] private readonly RdProperty<bool> _RequireUpdates;
    [NotNull] public ISink<SolutionAnalysisNavigation> NavigateToError { get { return _NavigateToError; }}
    [NotNull] private readonly RdSignal<SolutionAnalysisNavigation> _NavigateToError;
    [NotNull] public ISink<SolutionAnalysisIgnore> IgnoreIssues { get { return _IgnoreIssues; }}
    [NotNull] private readonly RdSignal<SolutionAnalysisIgnore> _IgnoreIssues;
    
    //primary constructor
    private SolutionAnalysisErrors(
      [NotNull] string fileName,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<int> notHiddenErrorCount,
      [NotNull] RdProperty<int> totalErrorCount,
      [NotNull] RdProperty<SolutionAnalysisErrorListWithIgnore> errors,
      [NotNull] RdProperty<bool> requireUpdates,
      [NotNull] RdSignal<SolutionAnalysisNavigation> navigateToError,
      [NotNull] RdSignal<SolutionAnalysisIgnore> ignoreIssues
    )
    {
      FileName = fileName;
      Icon = icon;
      _NotHiddenErrorCount = notHiddenErrorCount;
      _TotalErrorCount = totalErrorCount;
      _Errors = errors;
      _RequireUpdates = requireUpdates;
      _NavigateToError = navigateToError;
      _IgnoreIssues = ignoreIssues;
      notHiddenErrorCount.OptimizeNested = true;
      totalErrorCount.OptimizeNested = true;
      requireUpdates.OptimizeNested = true;
    }
    //secondary constructor
    public SolutionAnalysisErrors (
      [NotNull] string FileName,
      [CanBeNull] JetBrains.Rider.Model.Icon Icon
    ) : this (
      FileName,
      Icon,
      new RdProperty<int>(),
      new RdProperty<int>(),
      new RdProperty<SolutionAnalysisErrorListWithIgnore>(),
      new RdProperty<bool>(),
      new RdSignal<SolutionAnalysisNavigation>(),
      new RdSignal<SolutionAnalysisIgnore>()
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<SolutionAnalysisErrors> Read = (ctx, reader) => 
    {
      var fileName = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var notHiddenErrorCount = RdProperty<int>.Read(ctx, reader);
      var totalErrorCount = RdProperty<int>.Read(ctx, reader);
      var errors = RdProperty<SolutionAnalysisErrorListWithIgnore>.Read(ctx, reader);
      var requireUpdates = RdProperty<bool>.Read(ctx, reader);
      var navigateToError = RdSignal<SolutionAnalysisNavigation>.Read(ctx, reader);
      var ignoreIssues = RdSignal<SolutionAnalysisIgnore>.Read(ctx, reader);
      return new SolutionAnalysisErrors(fileName, icon, notHiddenErrorCount, totalErrorCount, errors, requireUpdates, navigateToError, ignoreIssues);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<SolutionAnalysisErrors> Write = (ctx, writer, value) => 
    {
      writer.Write(value.FileName);
      WriteIconNullable(ctx, writer, value.Icon);
      RdProperty<int>.Write(ctx, writer, value._NotHiddenErrorCount);
      RdProperty<int>.Write(ctx, writer, value._TotalErrorCount);
      RdProperty<SolutionAnalysisErrorListWithIgnore>.Write(ctx, writer, value._Errors);
      RdProperty<bool>.Write(ctx, writer, value._RequireUpdates);
      RdSignal<SolutionAnalysisNavigation>.Write(ctx, writer, value._NavigateToError);
      RdSignal<SolutionAnalysisIgnore>.Write(ctx, writer, value._IgnoreIssues);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _NotHiddenErrorCount.BindEx(lifetime, this, "notHiddenErrorCount");
      _TotalErrorCount.BindEx(lifetime, this, "totalErrorCount");
      _Errors.BindEx(lifetime, this, "errors");
      _RequireUpdates.BindEx(lifetime, this, "requireUpdates");
      _NavigateToError.BindEx(lifetime, this, "navigateToError");
      _IgnoreIssues.BindEx(lifetime, this, "ignoreIssues");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _NotHiddenErrorCount.IdentifyEx(ids);
      _TotalErrorCount.IdentifyEx(ids);
      _Errors.IdentifyEx(ids);
      _RequireUpdates.IdentifyEx(ids);
      _NavigateToError.IdentifyEx(ids);
      _IgnoreIssues.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisErrors (");
      using (printer.IndentCookie()) {
        printer.Print("fileName = "); FileName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("notHiddenErrorCount = "); _NotHiddenErrorCount.PrintEx(printer); printer.Println();
        printer.Print("totalErrorCount = "); _TotalErrorCount.PrintEx(printer); printer.Println();
        printer.Print("errors = "); _Errors.PrintEx(printer); printer.Println();
        printer.Print("requireUpdates = "); _RequireUpdates.PrintEx(printer); printer.Println();
        printer.Print("navigateToError = "); _NavigateToError.PrintEx(printer); printer.Println();
        printer.Print("ignoreIssues = "); _IgnoreIssues.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionAnalysisIconState : IPrintable, IEquatable<SolutionAnalysisIconState> {
    //fields
    [NotNull] public List<Icon> Icons {get; private set;}
    [NotNull] public string Text {get; private set;}
    [NotNull] public string Tooltip {get; private set;}
    
    //primary constructor
    public SolutionAnalysisIconState(
      [NotNull] List<Icon> icons,
      [NotNull] string text,
      [NotNull] string tooltip
    )
    {
      Icons = icons;
      Text = text;
      Tooltip = tooltip;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<Icon>> ReadIconList = Icon.Read.List();
    public static CtxReadDelegate<SolutionAnalysisIconState> Read = (ctx, reader) => 
    {
      var icons = ReadIconList(ctx, reader);
      var text = reader.ReadString();
      var tooltip = reader.ReadString();
      return new SolutionAnalysisIconState(icons, text, tooltip);
    };
    
    public static CtxWriteDelegate<List<Icon>> WriteIconList = Icon.Write.List();
    public static CtxWriteDelegate<SolutionAnalysisIconState> Write = (ctx, writer, value) => 
    {
      WriteIconList(ctx, writer, value.Icons);
      writer.Write(value.Text);
      writer.Write(value.Tooltip);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SolutionAnalysisIconState) obj);
    }
    public bool Equals(SolutionAnalysisIconState other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Icons.SequenceEqual(other.Icons) && Text == other.Text && Tooltip == other.Tooltip;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(Icons);
        __r = __r*31 + Text.GetHashCode();
        __r = __r*31 + Tooltip.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisIconState (");
      using (printer.IndentCookie()) {
        printer.Print("icons = "); Icons.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); Tooltip.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionAnalysisIgnore : IPrintable, IEquatable<SolutionAnalysisIgnore> {
    //fields
    [NotNull] public List<SolutionAnalysisError> Issues {get; private set;}
    public bool Ignore {get; private set;}
    
    //primary constructor
    public SolutionAnalysisIgnore(
      [NotNull] List<SolutionAnalysisError> issues,
      bool ignore
    )
    {
      Issues = issues;
      Ignore = ignore;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<SolutionAnalysisError>> ReadSolutionAnalysisErrorList = SolutionAnalysisError.Read.List();
    public static CtxReadDelegate<SolutionAnalysisIgnore> Read = (ctx, reader) => 
    {
      var issues = ReadSolutionAnalysisErrorList(ctx, reader);
      var ignore = reader.ReadBool();
      return new SolutionAnalysisIgnore(issues, ignore);
    };
    
    public static CtxWriteDelegate<List<SolutionAnalysisError>> WriteSolutionAnalysisErrorList = SolutionAnalysisError.Write.List();
    public static CtxWriteDelegate<SolutionAnalysisIgnore> Write = (ctx, writer, value) => 
    {
      WriteSolutionAnalysisErrorList(ctx, writer, value.Issues);
      writer.Write(value.Ignore);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SolutionAnalysisIgnore) obj);
    }
    public bool Equals(SolutionAnalysisIgnore other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Issues.SequenceEqual(other.Issues) && Ignore == other.Ignore;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(Issues);
        __r = __r*31 + Ignore.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisIgnore (");
      using (printer.IndentCookie()) {
        printer.Print("issues = "); Issues.PrintEx(printer); printer.Println();
        printer.Print("ignore = "); Ignore.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionAnalysisModel : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<SolutionAnalysisState> State { get { return _State; }}
    [NotNull] private readonly RdProperty<SolutionAnalysisState> _State;
    [NotNull] public ISink<bool> SetEnabled { get { return _SetEnabled; }}
    [NotNull] private readonly RdSignal<bool> _SetEnabled;
    [NotNull] public ISink<bool> SetPaused { get { return _SetPaused; }}
    [NotNull] private readonly RdSignal<bool> _SetPaused;
    [NotNull] public IRdProperty<bool> Ready { get { return _Ready; }}
    [NotNull] private readonly RdProperty<bool> _Ready;
    [NotNull] public IViewableMap<int, SolutionAnalysisErrors> FileErrors { get { return _FileErrors; }}
    [NotNull] private readonly RdMap<int, SolutionAnalysisErrors> _FileErrors;
    [NotNull] public ISource<SolutionAnalysisIconState> IconState { get { return _IconState; }}
    [NotNull] private readonly RdSignal<SolutionAnalysisIconState> _IconState;
    [NotNull] public ISink<SolutionAnalysisAction> RunAction { get { return _RunAction; }}
    [NotNull] private readonly RdSignal<SolutionAnalysisAction> _RunAction;
    [NotNull] public ISink<SolutionAnalysisProjectModelIgnore> IgnoreErrorsByProjectModel { get { return _IgnoreErrorsByProjectModel; }}
    [NotNull] private readonly RdSignal<SolutionAnalysisProjectModelIgnore> _IgnoreErrorsByProjectModel;
    
    //primary constructor
    private SolutionAnalysisModel(
      [NotNull] RdProperty<SolutionAnalysisState> state,
      [NotNull] RdSignal<bool> setEnabled,
      [NotNull] RdSignal<bool> setPaused,
      [NotNull] RdProperty<bool> ready,
      [NotNull] RdMap<int, SolutionAnalysisErrors> fileErrors,
      [NotNull] RdSignal<SolutionAnalysisIconState> iconState,
      [NotNull] RdSignal<SolutionAnalysisAction> runAction,
      [NotNull] RdSignal<SolutionAnalysisProjectModelIgnore> ignoreErrorsByProjectModel
    )
    {
      _State = state;
      _SetEnabled = setEnabled;
      _SetPaused = setPaused;
      _Ready = ready;
      _FileErrors = fileErrors;
      _IconState = iconState;
      _RunAction = runAction;
      _IgnoreErrorsByProjectModel = ignoreErrorsByProjectModel;
      ready.OptimizeNested = true;
    }
    //secondary constructor
    public SolutionAnalysisModel (
    ) : this (
      new RdProperty<SolutionAnalysisState>(),
      new RdSignal<bool>(),
      new RdSignal<bool>(),
      new RdProperty<bool>(),
      new RdMap<int, SolutionAnalysisErrors>(),
      new RdSignal<SolutionAnalysisIconState>(),
      new RdSignal<SolutionAnalysisAction>(),
      new RdSignal<SolutionAnalysisProjectModelIgnore>()
    ) {}
    //statics
    
    public static CtxReadDelegate<SolutionAnalysisAction> ReadSolutionAnalysisAction = new CtxReadDelegate<SolutionAnalysisAction>(Serializers.ReadEnum<SolutionAnalysisAction>);
    public static CtxReadDelegate<SolutionAnalysisModel> Read = (ctx, reader) => 
    {
      var state = RdProperty<SolutionAnalysisState>.Read(ctx, reader);
      var setEnabled = RdSignal<bool>.Read(ctx, reader);
      var setPaused = RdSignal<bool>.Read(ctx, reader);
      var ready = RdProperty<bool>.Read(ctx, reader);
      var fileErrors = RdMap<int, SolutionAnalysisErrors>.Read(ctx, reader);
      var iconState = RdSignal<SolutionAnalysisIconState>.Read(ctx, reader);
      var runAction = RdSignal<SolutionAnalysisAction>.Read(ctx, reader);
      var ignoreErrorsByProjectModel = RdSignal<SolutionAnalysisProjectModelIgnore>.Read(ctx, reader);
      return new SolutionAnalysisModel(state, setEnabled, setPaused, ready, fileErrors, iconState, runAction, ignoreErrorsByProjectModel);
    };
    
    public static CtxWriteDelegate<SolutionAnalysisAction> WriteSolutionAnalysisAction = new CtxWriteDelegate<SolutionAnalysisAction>(Serializers.WriteEnum<SolutionAnalysisAction>);
    public static CtxWriteDelegate<SolutionAnalysisModel> Write = (ctx, writer, value) => 
    {
      RdProperty<SolutionAnalysisState>.Write(ctx, writer, value._State);
      RdSignal<bool>.Write(ctx, writer, value._SetEnabled);
      RdSignal<bool>.Write(ctx, writer, value._SetPaused);
      RdProperty<bool>.Write(ctx, writer, value._Ready);
      RdMap<int, SolutionAnalysisErrors>.Write(ctx, writer, value._FileErrors);
      RdSignal<SolutionAnalysisIconState>.Write(ctx, writer, value._IconState);
      RdSignal<SolutionAnalysisAction>.Write(ctx, writer, value._RunAction);
      RdSignal<SolutionAnalysisProjectModelIgnore>.Write(ctx, writer, value._IgnoreErrorsByProjectModel);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _State.BindEx(lifetime, this, "state");
      _SetEnabled.BindEx(lifetime, this, "setEnabled");
      _SetPaused.BindEx(lifetime, this, "setPaused");
      _Ready.BindEx(lifetime, this, "ready");
      _FileErrors.BindEx(lifetime, this, "fileErrors");
      _IconState.BindEx(lifetime, this, "iconState");
      _RunAction.BindEx(lifetime, this, "runAction");
      _IgnoreErrorsByProjectModel.BindEx(lifetime, this, "ignoreErrorsByProjectModel");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _State.IdentifyEx(ids);
      _SetEnabled.IdentifyEx(ids);
      _SetPaused.IdentifyEx(ids);
      _Ready.IdentifyEx(ids);
      _FileErrors.IdentifyEx(ids);
      _IconState.IdentifyEx(ids);
      _RunAction.IdentifyEx(ids);
      _IgnoreErrorsByProjectModel.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisModel (");
      using (printer.IndentCookie()) {
        printer.Print("state = "); _State.PrintEx(printer); printer.Println();
        printer.Print("setEnabled = "); _SetEnabled.PrintEx(printer); printer.Println();
        printer.Print("setPaused = "); _SetPaused.PrintEx(printer); printer.Println();
        printer.Print("ready = "); _Ready.PrintEx(printer); printer.Println();
        printer.Print("fileErrors = "); _FileErrors.PrintEx(printer); printer.Println();
        printer.Print("iconState = "); _IconState.PrintEx(printer); printer.Println();
        printer.Print("runAction = "); _RunAction.PrintEx(printer); printer.Println();
        printer.Print("ignoreErrorsByProjectModel = "); _IgnoreErrorsByProjectModel.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionAnalysisNavigation : IPrintable, IEquatable<SolutionAnalysisNavigation> {
    //fields
    public int Offset {get; private set;}
    public bool Activate {get; private set;}
    
    //primary constructor
    public SolutionAnalysisNavigation(
      int offset,
      bool activate
    )
    {
      Offset = offset;
      Activate = activate;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SolutionAnalysisNavigation> Read = (ctx, reader) => 
    {
      var offset = reader.ReadInt();
      var activate = reader.ReadBool();
      return new SolutionAnalysisNavigation(offset, activate);
    };
    
    public static CtxWriteDelegate<SolutionAnalysisNavigation> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Offset);
      writer.Write(value.Activate);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SolutionAnalysisNavigation) obj);
    }
    public bool Equals(SolutionAnalysisNavigation other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Offset == other.Offset && Activate == other.Activate;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Offset.GetHashCode();
        __r = __r*31 + Activate.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisNavigation (");
      using (printer.IndentCookie()) {
        printer.Print("offset = "); Offset.PrintEx(printer); printer.Println();
        printer.Print("activate = "); Activate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionAnalysisProjectModelIgnore : IPrintable, IEquatable<SolutionAnalysisProjectModelIgnore> {
    //fields
    [NotNull] public List<int> NodeIDs {get; private set;}
    
    //primary constructor
    public SolutionAnalysisProjectModelIgnore(
      [NotNull] List<int> nodeIDs
    )
    {
      NodeIDs = nodeIDs;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static CtxReadDelegate<SolutionAnalysisProjectModelIgnore> Read = (ctx, reader) => 
    {
      var nodeIDs = ReadIntList(ctx, reader);
      return new SolutionAnalysisProjectModelIgnore(nodeIDs);
    };
    
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static CtxWriteDelegate<SolutionAnalysisProjectModelIgnore> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.NodeIDs);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SolutionAnalysisProjectModelIgnore) obj);
    }
    public bool Equals(SolutionAnalysisProjectModelIgnore other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return NodeIDs.SequenceEqual(other.NodeIDs);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(NodeIDs);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisProjectModelIgnore (");
      using (printer.IndentCookie()) {
        printer.Print("nodeIDs = "); NodeIDs.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionAnalysisState : RdBindableBase {
    //fields
    public bool Enabled {get; private set;}
    public bool Paused {get; private set;}
    
    //primary constructor
    public SolutionAnalysisState(
      bool enabled,
      bool paused
    )
    {
      Enabled = enabled;
      Paused = paused;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SolutionAnalysisState> Read = (ctx, reader) => 
    {
      var enabled = reader.ReadBool();
      var paused = reader.ReadBool();
      return new SolutionAnalysisState(enabled, paused);
    };
    
    public static CtxWriteDelegate<SolutionAnalysisState> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Enabled);
      writer.Write(value.Paused);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionAnalysisState (");
      using (printer.IndentCookie()) {
        printer.Print("enabled = "); Enabled.PrintEx(printer); printer.Println();
        printer.Print("paused = "); Paused.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionLifecycle : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<LoadResult> SolutionLoadedCachesReady { get { return _SolutionLoadedCachesReady; }}
    [NotNull] private readonly RdProperty<LoadResult> _SolutionLoadedCachesReady;
    [NotNull] public IRdProperty<bool> IsReadyForTyping { get { return _IsReadyForTyping; }}
    [NotNull] private readonly RdProperty<bool> _IsReadyForTyping;
    [NotNull] public IRdProperty<bool> IsProjectModelReady { get { return _IsProjectModelReady; }}
    [NotNull] private readonly RdProperty<bool> _IsProjectModelReady;
    
    //primary constructor
    private SolutionLifecycle(
      [NotNull] RdProperty<LoadResult> solutionLoadedCachesReady,
      [NotNull] RdProperty<bool> isReadyForTyping,
      [NotNull] RdProperty<bool> isProjectModelReady
    )
    {
      _SolutionLoadedCachesReady = solutionLoadedCachesReady;
      _IsReadyForTyping = isReadyForTyping;
      _IsProjectModelReady = isProjectModelReady;
      isReadyForTyping.OptimizeNested = true;
      isProjectModelReady.OptimizeNested = true;
    }
    //secondary constructor
    public SolutionLifecycle (
    ) : this (
      new RdProperty<LoadResult>(),
      new RdProperty<bool>(),
      new RdProperty<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<SolutionLifecycle> Read = (ctx, reader) => 
    {
      var solutionLoadedCachesReady = RdProperty<LoadResult>.Read(ctx, reader);
      var isReadyForTyping = RdProperty<bool>.Read(ctx, reader);
      var isProjectModelReady = RdProperty<bool>.Read(ctx, reader);
      return new SolutionLifecycle(solutionLoadedCachesReady, isReadyForTyping, isProjectModelReady);
    };
    
    public static CtxWriteDelegate<SolutionLifecycle> Write = (ctx, writer, value) => 
    {
      RdProperty<LoadResult>.Write(ctx, writer, value._SolutionLoadedCachesReady);
      RdProperty<bool>.Write(ctx, writer, value._IsReadyForTyping);
      RdProperty<bool>.Write(ctx, writer, value._IsProjectModelReady);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _SolutionLoadedCachesReady.BindEx(lifetime, this, "solutionLoadedCachesReady");
      _IsReadyForTyping.BindEx(lifetime, this, "isReadyForTyping");
      _IsProjectModelReady.BindEx(lifetime, this, "isProjectModelReady");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _SolutionLoadedCachesReady.IdentifyEx(ids);
      _IsReadyForTyping.IdentifyEx(ids);
      _IsProjectModelReady.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionLifecycle (");
      using (printer.IndentCookie()) {
        printer.Print("solutionLoadedCachesReady = "); _SolutionLoadedCachesReady.PrintEx(printer); printer.Println();
        printer.Print("isReadyForTyping = "); _IsReadyForTyping.PrintEx(printer); printer.Println();
        printer.Print("isProjectModelReady = "); _IsProjectModelReady.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class SolutionOpenStrategy : RdBindableBase {
    //fields
    [NotNull] public string SolutionFilePath {get; private set;}
    public bool RestorePackages {get; private set;}
    
    //primary constructor
    protected SolutionOpenStrategy(
      [NotNull] string solutionFilePath,
      bool restorePackages
    )
    {
      SolutionFilePath = solutionFilePath;
      RestorePackages = restorePackages;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SolutionOpenStrategy> Read = (ctx, reader) => ctx.Serializers.Read<SolutionOpenStrategy>(ctx, reader);
    
    public static CtxWriteDelegate<SolutionOpenStrategy> Write = (ctx, writer, value) => ctx.Serializers.Write<SolutionOpenStrategy>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class SolutionProperties : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<RdConfigurationAndPlatform> ActiveConfigurationPlatform { get { return _ActiveConfigurationPlatform; }}
    [NotNull] private readonly RdProperty<RdConfigurationAndPlatform> _ActiveConfigurationPlatform;
    [NotNull] public IRdProperty<ConfigurationPlatformCollection> ConfigurationsAndPlatformsCollection { get { return _ConfigurationsAndPlatformsCollection; }}
    [NotNull] private readonly RdProperty<ConfigurationPlatformCollection> _ConfigurationsAndPlatformsCollection;
    
    //primary constructor
    private SolutionProperties(
      [NotNull] RdProperty<RdConfigurationAndPlatform> activeConfigurationPlatform,
      [NotNull] RdProperty<ConfigurationPlatformCollection> configurationsAndPlatformsCollection
    )
    {
      _ActiveConfigurationPlatform = activeConfigurationPlatform;
      _ConfigurationsAndPlatformsCollection = configurationsAndPlatformsCollection;
    }
    //secondary constructor
    public SolutionProperties (
    ) : this (
      new RdProperty<RdConfigurationAndPlatform>(),
      new RdProperty<ConfigurationPlatformCollection>()
    ) {}
    //statics
    
    public static CtxReadDelegate<SolutionProperties> Read = (ctx, reader) => 
    {
      var activeConfigurationPlatform = RdProperty<RdConfigurationAndPlatform>.Read(ctx, reader);
      var configurationsAndPlatformsCollection = RdProperty<ConfigurationPlatformCollection>.Read(ctx, reader);
      return new SolutionProperties(activeConfigurationPlatform, configurationsAndPlatformsCollection);
    };
    
    public static CtxWriteDelegate<SolutionProperties> Write = (ctx, writer, value) => 
    {
      RdProperty<RdConfigurationAndPlatform>.Write(ctx, writer, value._ActiveConfigurationPlatform);
      RdProperty<ConfigurationPlatformCollection>.Write(ctx, writer, value._ConfigurationsAndPlatformsCollection);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _ActiveConfigurationPlatform.BindEx(lifetime, this, "activeConfigurationPlatform");
      _ConfigurationsAndPlatformsCollection.BindEx(lifetime, this, "configurationsAndPlatformsCollection");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ActiveConfigurationPlatform.IdentifyEx(ids);
      _ConfigurationsAndPlatformsCollection.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionProperties (");
      using (printer.IndentCookie()) {
        printer.Print("activeConfigurationPlatform = "); _ActiveConfigurationPlatform.PrintEx(printer); printer.Println();
        printer.Print("configurationsAndPlatformsCollection = "); _ConfigurationsAndPlatformsCollection.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SourcePositionInfo : IPrintable, IEquatable<SourcePositionInfo> {
    //fields
    [NotNull] public string File {get; private set;}
    public int Line {get; private set;}
    
    //primary constructor
    public SourcePositionInfo(
      [NotNull] string file,
      int line
    )
    {
      File = file;
      Line = line;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SourcePositionInfo> Read = (ctx, reader) => 
    {
      var file = reader.ReadString();
      var line = reader.ReadInt();
      return new SourcePositionInfo(file, line);
    };
    
    public static CtxWriteDelegate<SourcePositionInfo> Write = (ctx, writer, value) => 
    {
      writer.Write(value.File);
      writer.Write(value.Line);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SourcePositionInfo) obj);
    }
    public bool Equals(SourcePositionInfo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return File == other.File && Line == other.Line;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + File.GetHashCode();
        __r = __r*31 + Line.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SourcePositionInfo (");
      using (printer.IndentCookie()) {
        printer.Print("file = "); File.PrintEx(printer); printer.Println();
        printer.Print("line = "); Line.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class StackTraceFileHyperlinkHighlighter : StackTraceHyperlinkHighlighterBase
   {
    //fields
    [NotNull] public string FilePath {get; private set;}
    public int Line {get; private set;}
    
    //primary constructor
    public StackTraceFileHyperlinkHighlighter(
      [NotNull] string filePath,
      int line,
      bool includeInOccurenceNavigation,
      int id,
      int registryKey,
      int start,
      int end
    ) : base (
      includeInOccurenceNavigation,
      id,
      registryKey,
      start,
      end
     ) 
    {
      FilePath = filePath;
      Line = line;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<StackTraceFileHyperlinkHighlighter> Read = (ctx, reader) => 
    {
      var filePath = reader.ReadString();
      var line = reader.ReadInt();
      var includeInOccurenceNavigation = reader.ReadBool();
      var id = reader.ReadInt();
      var registryKey = reader.ReadInt();
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      return new StackTraceFileHyperlinkHighlighter(filePath, line, includeInOccurenceNavigation, id, registryKey, start, end);
    };
    
    public static new CtxWriteDelegate<StackTraceFileHyperlinkHighlighter> Write = (ctx, writer, value) => 
    {
      writer.Write(value.FilePath);
      writer.Write(value.Line);
      writer.Write(value.IncludeInOccurenceNavigation);
      writer.Write(value.Id);
      writer.Write(value.RegistryKey);
      writer.Write(value.Start);
      writer.Write(value.End);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((StackTraceFileHyperlinkHighlighter) obj);
    }
    public bool Equals(StackTraceFileHyperlinkHighlighter other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return FilePath == other.FilePath && Line == other.Line && IncludeInOccurenceNavigation == other.IncludeInOccurenceNavigation && Id == other.Id && RegistryKey == other.RegistryKey && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + FilePath.GetHashCode();
        __r = __r*31 + Line.GetHashCode();
        __r = __r*31 + IncludeInOccurenceNavigation.GetHashCode();
        __r = __r*31 + Id.GetHashCode();
        __r = __r*31 + RegistryKey.GetHashCode();
        __r = __r*31 + Start.GetHashCode();
        __r = __r*31 + End.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("StackTraceFileHyperlinkHighlighter (");
      using (printer.IndentCookie()) {
        printer.Print("filePath = "); FilePath.PrintEx(printer); printer.Println();
        printer.Print("line = "); Line.PrintEx(printer); printer.Println();
        printer.Print("includeInOccurenceNavigation = "); IncludeInOccurenceNavigation.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("registryKey = "); RegistryKey.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class StackTraceFilterProvider : RdBindableBase {
    //fields
    [NotNull] public RdEndpoint<string, StackTraceFilterResult> ApplyFilter { get { return _ApplyFilter; }}
    [NotNull] private readonly RdEndpoint<string, StackTraceFilterResult> _ApplyFilter;
    [NotNull] public ISink<StackTraceNavigationPoint> Navigate { get { return _Navigate; }}
    [NotNull] private readonly RdSignal<StackTraceNavigationPoint> _Navigate;
    
    //primary constructor
    private StackTraceFilterProvider(
      [NotNull] RdEndpoint<string, StackTraceFilterResult> applyFilter,
      [NotNull] RdSignal<StackTraceNavigationPoint> navigate
    )
    {
      _ApplyFilter = applyFilter;
      _Navigate = navigate;
      applyFilter.Async = true;
    }
    //secondary constructor
    public StackTraceFilterProvider (
    ) : this (
      new RdEndpoint<string, StackTraceFilterResult>(),
      new RdSignal<StackTraceNavigationPoint>()
    ) {}
    //statics
    
    public static CtxReadDelegate<StackTraceFilterProvider> Read = (ctx, reader) => 
    {
      var applyFilter = RdEndpoint<string, StackTraceFilterResult>.Read(ctx, reader);
      var navigate = RdSignal<StackTraceNavigationPoint>.Read(ctx, reader);
      return new StackTraceFilterProvider(applyFilter, navigate);
    };
    
    public static CtxWriteDelegate<StackTraceFilterProvider> Write = (ctx, writer, value) => 
    {
      RdEndpoint<string, StackTraceFilterResult>.Write(ctx, writer, value._ApplyFilter);
      RdSignal<StackTraceNavigationPoint>.Write(ctx, writer, value._Navigate);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _ApplyFilter.BindEx(lifetime, this, "applyFilter");
      _Navigate.BindEx(lifetime, this, "navigate");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ApplyFilter.IdentifyEx(ids);
      _Navigate.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("StackTraceFilterProvider (");
      using (printer.IndentCookie()) {
        printer.Print("applyFilter = "); _ApplyFilter.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class StackTraceFilterResult : IPrintable, IEquatable<StackTraceFilterResult> {
    //fields
    [NotNull] public List<StackTraceHighlighter> Highlighters {get; private set;}
    
    //primary constructor
    public StackTraceFilterResult(
      [NotNull] List<StackTraceHighlighter> highlighters
    )
    {
      Highlighters = highlighters;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<StackTraceHighlighter>> ReadStackTraceHighlighterList = StackTraceHighlighter.Read.List();
    public static CtxReadDelegate<StackTraceFilterResult> Read = (ctx, reader) => 
    {
      var highlighters = ReadStackTraceHighlighterList(ctx, reader);
      return new StackTraceFilterResult(highlighters);
    };
    
    public static CtxWriteDelegate<List<StackTraceHighlighter>> WriteStackTraceHighlighterList = StackTraceHighlighter.Write.List();
    public static CtxWriteDelegate<StackTraceFilterResult> Write = (ctx, writer, value) => 
    {
      WriteStackTraceHighlighterList(ctx, writer, value.Highlighters);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((StackTraceFilterResult) obj);
    }
    public bool Equals(StackTraceFilterResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Highlighters.SequenceEqual(other.Highlighters);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(Highlighters);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("StackTraceFilterResult (");
      using (printer.IndentCookie()) {
        printer.Print("highlighters = "); Highlighters.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class StackTraceHighlighter : LightweightHighlighter
   {
    //fields
    //primary constructor
    protected StackTraceHighlighter(
      int id,
      int registryKey,
      int start,
      int end
    ) : base (
      id,
      registryKey,
      start,
      end
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<StackTraceHighlighter> Read = (ctx, reader) => ctx.Serializers.Read<StackTraceHighlighter>(ctx, reader);
    
    public static new CtxWriteDelegate<StackTraceHighlighter> Write = (ctx, writer, value) => ctx.Serializers.Write<StackTraceHighlighter>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class StackTraceHyperlinkHighlighter : StackTraceHyperlinkHighlighterBase
   {
    //fields
    //primary constructor
    public StackTraceHyperlinkHighlighter(
      bool includeInOccurenceNavigation,
      int id,
      int registryKey,
      int start,
      int end
    ) : base (
      includeInOccurenceNavigation,
      id,
      registryKey,
      start,
      end
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<StackTraceHyperlinkHighlighter> Read = (ctx, reader) => 
    {
      var includeInOccurenceNavigation = reader.ReadBool();
      var id = reader.ReadInt();
      var registryKey = reader.ReadInt();
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      return new StackTraceHyperlinkHighlighter(includeInOccurenceNavigation, id, registryKey, start, end);
    };
    
    public static new CtxWriteDelegate<StackTraceHyperlinkHighlighter> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IncludeInOccurenceNavigation);
      writer.Write(value.Id);
      writer.Write(value.RegistryKey);
      writer.Write(value.Start);
      writer.Write(value.End);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((StackTraceHyperlinkHighlighter) obj);
    }
    public bool Equals(StackTraceHyperlinkHighlighter other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IncludeInOccurenceNavigation == other.IncludeInOccurenceNavigation && Id == other.Id && RegistryKey == other.RegistryKey && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + IncludeInOccurenceNavigation.GetHashCode();
        __r = __r*31 + Id.GetHashCode();
        __r = __r*31 + RegistryKey.GetHashCode();
        __r = __r*31 + Start.GetHashCode();
        __r = __r*31 + End.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("StackTraceHyperlinkHighlighter (");
      using (printer.IndentCookie()) {
        printer.Print("includeInOccurenceNavigation = "); IncludeInOccurenceNavigation.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("registryKey = "); RegistryKey.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class StackTraceHyperlinkHighlighterBase : StackTraceHighlighter
   {
    //fields
    public bool IncludeInOccurenceNavigation {get; private set;}
    
    //primary constructor
    protected StackTraceHyperlinkHighlighterBase(
      bool includeInOccurenceNavigation,
      int id,
      int registryKey,
      int start,
      int end
    ) : base (
      id,
      registryKey,
      start,
      end
     ) 
    {
      IncludeInOccurenceNavigation = includeInOccurenceNavigation;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<StackTraceHyperlinkHighlighterBase> Read = (ctx, reader) => ctx.Serializers.Read<StackTraceHyperlinkHighlighterBase>(ctx, reader);
    
    public static new CtxWriteDelegate<StackTraceHyperlinkHighlighterBase> Write = (ctx, writer, value) => ctx.Serializers.Write<StackTraceHyperlinkHighlighterBase>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class StackTraceIdentifierHighlighter : StackTraceHighlighter
   {
    //fields
    //primary constructor
    public StackTraceIdentifierHighlighter(
      int id,
      int registryKey,
      int start,
      int end
    ) : base (
      id,
      registryKey,
      start,
      end
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<StackTraceIdentifierHighlighter> Read = (ctx, reader) => 
    {
      var id = reader.ReadInt();
      var registryKey = reader.ReadInt();
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      return new StackTraceIdentifierHighlighter(id, registryKey, start, end);
    };
    
    public static new CtxWriteDelegate<StackTraceIdentifierHighlighter> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.RegistryKey);
      writer.Write(value.Start);
      writer.Write(value.End);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((StackTraceIdentifierHighlighter) obj);
    }
    public bool Equals(StackTraceIdentifierHighlighter other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && RegistryKey == other.RegistryKey && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Id.GetHashCode();
        __r = __r*31 + RegistryKey.GetHashCode();
        __r = __r*31 + Start.GetHashCode();
        __r = __r*31 + End.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("StackTraceIdentifierHighlighter (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("registryKey = "); RegistryKey.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class StackTraceNavigationPoint : IPrintable, IEquatable<StackTraceNavigationPoint> {
    //fields
    [NotNull] public string Line {get; private set;}
    [NotNull] public StackTraceHyperlinkHighlighter Hyperlink {get; private set;}
    
    //primary constructor
    public StackTraceNavigationPoint(
      [NotNull] string line,
      [NotNull] StackTraceHyperlinkHighlighter hyperlink
    )
    {
      Line = line;
      Hyperlink = hyperlink;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<StackTraceNavigationPoint> Read = (ctx, reader) => 
    {
      var line = reader.ReadString();
      var hyperlink = StackTraceHyperlinkHighlighter.Read(ctx, reader);
      return new StackTraceNavigationPoint(line, hyperlink);
    };
    
    public static CtxWriteDelegate<StackTraceNavigationPoint> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Line);
      StackTraceHyperlinkHighlighter.Write(ctx, writer, value.Hyperlink);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((StackTraceNavigationPoint) obj);
    }
    public bool Equals(StackTraceNavigationPoint other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Line == other.Line && Equals(Hyperlink, other.Hyperlink);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Line.GetHashCode();
        __r = __r*31 + Hyperlink.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("StackTraceNavigationPoint (");
      using (printer.IndentCookie()) {
        printer.Print("line = "); Line.PrintEx(printer); printer.Println();
        printer.Print("hyperlink = "); Hyperlink.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class StringPair : IPrintable, IEquatable<StringPair> {
    //fields
    [NotNull] public string First {get; private set;}
    [NotNull] public string Second {get; private set;}
    
    //primary constructor
    public StringPair(
      [NotNull] string first,
      [NotNull] string second
    )
    {
      First = first;
      Second = second;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<StringPair> Read = (ctx, reader) => 
    {
      var first = reader.ReadString();
      var second = reader.ReadString();
      return new StringPair(first, second);
    };
    
    public static CtxWriteDelegate<StringPair> Write = (ctx, writer, value) => 
    {
      writer.Write(value.First);
      writer.Write(value.Second);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((StringPair) obj);
    }
    public bool Equals(StringPair other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return First == other.First && Second == other.Second;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + First.GetHashCode();
        __r = __r*31 + Second.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("StringPair (");
      using (printer.IndentCookie()) {
        printer.Print("first = "); First.PrintEx(printer); printer.Println();
        printer.Print("second = "); Second.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TextControlId : IPrintable, IEquatable<TextControlId> {
    //fields
    [NotNull] public EditableEntityId DocumentId {get; private set;}
    public int TabIndex {get; private set;}
    
    //primary constructor
    public TextControlId(
      [NotNull] EditableEntityId documentId,
      int tabIndex
    )
    {
      DocumentId = documentId;
      TabIndex = tabIndex;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<TextControlId> Read = (ctx, reader) => 
    {
      var documentId = EditableEntityId.Read(ctx, reader);
      var tabIndex = reader.ReadInt();
      return new TextControlId(documentId, tabIndex);
    };
    
    public static CtxWriteDelegate<TextControlId> Write = (ctx, writer, value) => 
    {
      EditableEntityId.Write(ctx, writer, value.DocumentId);
      writer.Write(value.TabIndex);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((TextControlId) obj);
    }
    public bool Equals(TextControlId other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(DocumentId, other.DocumentId) && TabIndex == other.TabIndex;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + DocumentId.GetHashCode();
        __r = __r*31 + TabIndex.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("TextControlId (");
      using (printer.IndentCookie()) {
        printer.Print("documentId = "); DocumentId.PrintEx(printer); printer.Println();
        printer.Print("tabIndex = "); TabIndex.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TextControlModel : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<SelectionRange> Selection { get { return _Selection; }}
    [NotNull] private readonly RdProperty<SelectionRange> _Selection;
    [NotNull] public IRdProperty<JetBrains.Rider.Model.VisibleRange> VisibleRange { get { return _VisibleRange; }}
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.VisibleRange> _VisibleRange;
    [NotNull] public EditableEntityId Content {get; private set;}
    [NotNull] public IRdProperty<int> TabSize { get { return _TabSize; }}
    [NotNull] private readonly RdProperty<int> _TabSize;
    [NotNull] public IRdProperty<int> RightMargin { get { return _RightMargin; }}
    [NotNull] private readonly RdProperty<int> _RightMargin;
    [NotNull] public IRdProperty<bool> UseTab { get { return _UseTab; }}
    [NotNull] private readonly RdProperty<bool> _UseTab;
    [NotNull] public IRdProperty<int> IndentSize { get { return _IndentSize; }}
    [NotNull] private readonly RdProperty<int> _IndentSize;
    [NotNull] public IRdProperty<int> SpaceWidth { get { return _SpaceWidth; }}
    [NotNull] private readonly RdProperty<int> _SpaceWidth;
    [NotNull] public IRdProperty<ErrorStripeIndicatorStateEnum> IndicatorState { get { return _IndicatorState; }}
    [NotNull] private readonly RdProperty<ErrorStripeIndicatorStateEnum> _IndicatorState;
    [NotNull] public ISource<ScrollingInfo> Scrolling { get { return _Scrolling; }}
    [NotNull] private readonly RdSignal<ScrollingInfo> _Scrolling;
    [NotNull] public IRdProperty<bool> IsVisible { get { return _IsVisible; }}
    [NotNull] private readonly RdProperty<bool> _IsVisible;
    
    //primary constructor
    private TextControlModel(
      [NotNull] RdProperty<SelectionRange> selection,
      [NotNull] RdProperty<JetBrains.Rider.Model.VisibleRange> visibleRange,
      [NotNull] EditableEntityId content,
      [NotNull] RdProperty<int> tabSize,
      [NotNull] RdProperty<int> rightMargin,
      [NotNull] RdProperty<bool> useTab,
      [NotNull] RdProperty<int> indentSize,
      [NotNull] RdProperty<int> spaceWidth,
      [NotNull] RdProperty<ErrorStripeIndicatorStateEnum> indicatorState,
      [NotNull] RdSignal<ScrollingInfo> scrolling,
      [NotNull] RdProperty<bool> isVisible
    )
    {
      _Selection = selection;
      _VisibleRange = visibleRange;
      Content = content;
      _TabSize = tabSize;
      _RightMargin = rightMargin;
      _UseTab = useTab;
      _IndentSize = indentSize;
      _SpaceWidth = spaceWidth;
      _IndicatorState = indicatorState;
      _Scrolling = scrolling;
      _IsVisible = isVisible;
      selection.OptimizeNested = true;
      tabSize.OptimizeNested = true;
      rightMargin.OptimizeNested = true;
      useTab.OptimizeNested = true;
      indentSize.OptimizeNested = true;
      spaceWidth.OptimizeNested = true;
      indicatorState.OptimizeNested = true;
      isVisible.OptimizeNested = true;
    }
    //secondary constructor
    public TextControlModel (
      [NotNull] EditableEntityId Content
    ) : this (
      new RdProperty<SelectionRange>(),
      new RdProperty<JetBrains.Rider.Model.VisibleRange>(),
      Content,
      new RdProperty<int>(),
      new RdProperty<int>(),
      new RdProperty<bool>(),
      new RdProperty<int>(),
      new RdProperty<int>(),
      new RdProperty<ErrorStripeIndicatorStateEnum>(),
      new RdSignal<ScrollingInfo>(),
      new RdProperty<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<ErrorStripeIndicatorStateEnum> ReadErrorStripeIndicatorStateEnum = new CtxReadDelegate<ErrorStripeIndicatorStateEnum>(Serializers.ReadEnum<ErrorStripeIndicatorStateEnum>);
    public static CtxReadDelegate<TextControlModel> Read = (ctx, reader) => 
    {
      var selection = RdProperty<SelectionRange>.Read(ctx, reader);
      var visibleRange = RdProperty<JetBrains.Rider.Model.VisibleRange>.Read(ctx, reader);
      var content = EditableEntityId.Read(ctx, reader);
      var tabSize = RdProperty<int>.Read(ctx, reader);
      var rightMargin = RdProperty<int>.Read(ctx, reader);
      var useTab = RdProperty<bool>.Read(ctx, reader);
      var indentSize = RdProperty<int>.Read(ctx, reader);
      var spaceWidth = RdProperty<int>.Read(ctx, reader);
      var indicatorState = RdProperty<ErrorStripeIndicatorStateEnum>.Read(ctx, reader);
      var scrolling = RdSignal<ScrollingInfo>.Read(ctx, reader);
      var isVisible = RdProperty<bool>.Read(ctx, reader);
      return new TextControlModel(selection, visibleRange, content, tabSize, rightMargin, useTab, indentSize, spaceWidth, indicatorState, scrolling, isVisible);
    };
    
    public static CtxWriteDelegate<ErrorStripeIndicatorStateEnum> WriteErrorStripeIndicatorStateEnum = new CtxWriteDelegate<ErrorStripeIndicatorStateEnum>(Serializers.WriteEnum<ErrorStripeIndicatorStateEnum>);
    public static CtxWriteDelegate<TextControlModel> Write = (ctx, writer, value) => 
    {
      RdProperty<SelectionRange>.Write(ctx, writer, value._Selection);
      RdProperty<JetBrains.Rider.Model.VisibleRange>.Write(ctx, writer, value._VisibleRange);
      EditableEntityId.Write(ctx, writer, value.Content);
      RdProperty<int>.Write(ctx, writer, value._TabSize);
      RdProperty<int>.Write(ctx, writer, value._RightMargin);
      RdProperty<bool>.Write(ctx, writer, value._UseTab);
      RdProperty<int>.Write(ctx, writer, value._IndentSize);
      RdProperty<int>.Write(ctx, writer, value._SpaceWidth);
      RdProperty<ErrorStripeIndicatorStateEnum>.Write(ctx, writer, value._IndicatorState);
      RdSignal<ScrollingInfo>.Write(ctx, writer, value._Scrolling);
      RdProperty<bool>.Write(ctx, writer, value._IsVisible);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Selection.BindEx(lifetime, this, "selection");
      _VisibleRange.BindEx(lifetime, this, "visibleRange");
      _TabSize.BindEx(lifetime, this, "tabSize");
      _RightMargin.BindEx(lifetime, this, "rightMargin");
      _UseTab.BindEx(lifetime, this, "useTab");
      _IndentSize.BindEx(lifetime, this, "indentSize");
      _SpaceWidth.BindEx(lifetime, this, "spaceWidth");
      _IndicatorState.BindEx(lifetime, this, "indicatorState");
      _Scrolling.BindEx(lifetime, this, "scrolling");
      _IsVisible.BindEx(lifetime, this, "isVisible");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Selection.IdentifyEx(ids);
      _VisibleRange.IdentifyEx(ids);
      _TabSize.IdentifyEx(ids);
      _RightMargin.IdentifyEx(ids);
      _UseTab.IdentifyEx(ids);
      _IndentSize.IdentifyEx(ids);
      _SpaceWidth.IdentifyEx(ids);
      _IndicatorState.IdentifyEx(ids);
      _Scrolling.IdentifyEx(ids);
      _IsVisible.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TextControlModel (");
      using (printer.IndentCookie()) {
        printer.Print("selection = "); _Selection.PrintEx(printer); printer.Println();
        printer.Print("visibleRange = "); _VisibleRange.PrintEx(printer); printer.Println();
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("tabSize = "); _TabSize.PrintEx(printer); printer.Println();
        printer.Print("rightMargin = "); _RightMargin.PrintEx(printer); printer.Println();
        printer.Print("useTab = "); _UseTab.PrintEx(printer); printer.Println();
        printer.Print("indentSize = "); _IndentSize.PrintEx(printer); printer.Println();
        printer.Print("spaceWidth = "); _SpaceWidth.PrintEx(printer); printer.Println();
        printer.Print("indicatorState = "); _IndicatorState.PrintEx(printer); printer.Println();
        printer.Print("scrolling = "); _Scrolling.PrintEx(printer); printer.Println();
        printer.Print("isVisible = "); _IsVisible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TextControlSnapshot : IPrintable, IEquatable<TextControlSnapshot> {
    //fields
    [NotNull] public SelectionRange Selection {get; private set;}
    
    //primary constructor
    public TextControlSnapshot(
      [NotNull] SelectionRange selection
    )
    {
      Selection = selection;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<TextControlSnapshot> Read = (ctx, reader) => 
    {
      var selection = SelectionRange.Read(ctx, reader);
      return new TextControlSnapshot(selection);
    };
    
    public static CtxWriteDelegate<TextControlSnapshot> Write = (ctx, writer, value) => 
    {
      SelectionRange.Write(ctx, writer, value.Selection);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((TextControlSnapshot) obj);
    }
    public bool Equals(TextControlSnapshot other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Selection, other.Selection);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Selection.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("TextControlSnapshot (");
      using (printer.IndentCookie()) {
        printer.Print("selection = "); Selection.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TextControlTuple : RdBindableBase {
    //fields
    [NotNull] public TextControlId Id {get; private set;}
    [NotNull] public LastFocusedTextControl TextControl {get; private set;}
    
    //primary constructor
    private TextControlTuple(
      [NotNull] TextControlId id,
      [NotNull] LastFocusedTextControl textControl
    )
    {
      Id = id;
      TextControl = textControl;
    }
    //secondary constructor
    public TextControlTuple (
      [NotNull] TextControlId Id
    ) : this (
      Id,
      new LastFocusedTextControl()
    ) {}
    //statics
    
    public static CtxReadDelegate<TextControlTuple> Read = (ctx, reader) => 
    {
      var id = TextControlId.Read(ctx, reader);
      var textControl = LastFocusedTextControl.Read(ctx, reader);
      return new TextControlTuple(id, textControl);
    };
    
    public static CtxWriteDelegate<TextControlTuple> Write = (ctx, writer, value) => 
    {
      TextControlId.Write(ctx, writer, value.Id);
      LastFocusedTextControl.Write(ctx, writer, value.TextControl);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      TextControl.BindEx(lifetime, this, "textControl");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      TextControl.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TextControlTuple (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("textControl = "); TextControl.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TextControlsCollection : RdBindableBase {
    //fields
    [NotNull] public IViewableMap<TextControlId, TextControlModel> TextControls { get { return _TextControls; }}
    [NotNull] private readonly RdMap<TextControlId, TextControlModel> _TextControls;
    
    //primary constructor
    private TextControlsCollection(
      [NotNull] RdMap<TextControlId, TextControlModel> textControls
    )
    {
      _TextControls = textControls;
    }
    //secondary constructor
    public TextControlsCollection (
    ) : this (
      new RdMap<TextControlId, TextControlModel>()
    ) {}
    //statics
    
    public static CtxReadDelegate<TextControlsCollection> Read = (ctx, reader) => 
    {
      var textControls = RdMap<TextControlId, TextControlModel>.Read(ctx, reader);
      return new TextControlsCollection(textControls);
    };
    
    public static CtxWriteDelegate<TextControlsCollection> Write = (ctx, writer, value) => 
    {
      RdMap<TextControlId, TextControlModel>.Write(ctx, writer, value._TextControls);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _TextControls.BindEx(lifetime, this, "textControls");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _TextControls.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TextControlsCollection (");
      using (printer.IndentCookie()) {
        printer.Print("textControls = "); _TextControls.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ToUpdate : IPrintable, IEquatable<ToUpdate> {
    //fields
    [NotNull] public List<AdvancedPresentation> UpdatedItems {get; private set;}
    
    //primary constructor
    public ToUpdate(
      [NotNull] List<AdvancedPresentation> updatedItems
    )
    {
      UpdatedItems = updatedItems;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<AdvancedPresentation>> ReadAdvancedPresentationList = AdvancedPresentation.Read.List();
    public static CtxReadDelegate<ToUpdate> Read = (ctx, reader) => 
    {
      var updatedItems = ReadAdvancedPresentationList(ctx, reader);
      return new ToUpdate(updatedItems);
    };
    
    public static CtxWriteDelegate<List<AdvancedPresentation>> WriteAdvancedPresentationList = AdvancedPresentation.Write.List();
    public static CtxWriteDelegate<ToUpdate> Write = (ctx, writer, value) => 
    {
      WriteAdvancedPresentationList(ctx, writer, value.UpdatedItems);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ToUpdate) obj);
    }
    public bool Equals(ToUpdate other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return UpdatedItems.SequenceEqual(other.UpdatedItems);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(UpdatedItems);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ToUpdate (");
      using (printer.IndentCookie()) {
        printer.Print("updatedItems = "); UpdatedItems.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum TodoIconStyle {
    None,
    Edit,
    Error,
    Info,
    Question,
    Warning
  }
  
  
  public class TodoItem : RdBindableBase {
    //fields
    public int Start {get; private set;}
    public int End {get; private set;}
    [NotNull] public string PatternId {get; private set;}
    
    //primary constructor
    public TodoItem(
      int start,
      int end,
      [NotNull] string patternId
    )
    {
      Start = start;
      End = end;
      PatternId = patternId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<TodoItem> Read = (ctx, reader) => 
    {
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      var patternId = reader.ReadString();
      return new TodoItem(start, end, patternId);
    };
    
    public static CtxWriteDelegate<TodoItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Start);
      writer.Write(value.End);
      writer.Write(value.PatternId);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TodoItem (");
      using (printer.IndentCookie()) {
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
        printer.Print("patternId = "); PatternId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TodoItems : RdBindableBase {
    //fields
    [NotNull] public List<TodoItem> Values {get; private set;}
    
    //primary constructor
    public TodoItems(
      [NotNull] List<TodoItem> values
    )
    {
      Values = values;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<TodoItem>> ReadTodoItemList = TodoItem.Read.List();
    public static CtxReadDelegate<TodoItems> Read = (ctx, reader) => 
    {
      var values = ReadTodoItemList(ctx, reader);
      return new TodoItems(values);
    };
    
    public static CtxWriteDelegate<List<TodoItem>> WriteTodoItemList = TodoItem.Write.List();
    public static CtxWriteDelegate<TodoItems> Write = (ctx, writer, value) => 
    {
      WriteTodoItemList(ctx, writer, value.Values);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Values.BindEx(lifetime, this, "values");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Values.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TodoItems (");
      using (printer.IndentCookie()) {
        printer.Print("values = "); Values.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TodoModel : RdBindableBase {
    //fields
    [NotNull] public IViewableMap<string, JetBrains.Rider.Model.TodoItems> TodoItems { get { return _TodoItems; }}
    [NotNull] private readonly RdMap<string, JetBrains.Rider.Model.TodoItems> _TodoItems;
    [NotNull] public IRdProperty<JetBrains.Rider.Model.TodoPatterns> TodoPatterns { get { return _TodoPatterns; }}
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.TodoPatterns> _TodoPatterns;
    
    //primary constructor
    private TodoModel(
      [NotNull] RdMap<string, JetBrains.Rider.Model.TodoItems> todoItems,
      [NotNull] RdProperty<JetBrains.Rider.Model.TodoPatterns> todoPatterns
    )
    {
      _TodoItems = todoItems;
      _TodoPatterns = todoPatterns;
      todoItems.Async = true;
    }
    //secondary constructor
    public TodoModel (
    ) : this (
      new RdMap<string, JetBrains.Rider.Model.TodoItems>(),
      new RdProperty<JetBrains.Rider.Model.TodoPatterns>()
    ) {}
    //statics
    
    public static CtxReadDelegate<TodoModel> Read = (ctx, reader) => 
    {
      var todoItems = RdMap<string, JetBrains.Rider.Model.TodoItems>.Read(ctx, reader);
      var todoPatterns = RdProperty<JetBrains.Rider.Model.TodoPatterns>.Read(ctx, reader);
      return new TodoModel(todoItems, todoPatterns);
    };
    
    public static CtxWriteDelegate<TodoModel> Write = (ctx, writer, value) => 
    {
      RdMap<string, JetBrains.Rider.Model.TodoItems>.Write(ctx, writer, value._TodoItems);
      RdProperty<JetBrains.Rider.Model.TodoPatterns>.Write(ctx, writer, value._TodoPatterns);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _TodoItems.BindEx(lifetime, this, "todoItems");
      _TodoPatterns.BindEx(lifetime, this, "todoPatterns");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _TodoItems.IdentifyEx(ids);
      _TodoPatterns.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TodoModel (");
      using (printer.IndentCookie()) {
        printer.Print("todoItems = "); _TodoItems.PrintEx(printer); printer.Println();
        printer.Print("todoPatterns = "); _TodoPatterns.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TodoPattern : RdBindableBase {
    //fields
    [NotNull] public string Pattern {get; private set;}
    public bool CaseSensitive {get; private set;}
    public TodoIconStyle IconStyle {get; private set;}
    [NotNull] public RgbColor Color {get; private set;}
    
    //primary constructor
    public TodoPattern(
      [NotNull] string pattern,
      bool caseSensitive,
      TodoIconStyle iconStyle,
      [NotNull] RgbColor color
    )
    {
      Pattern = pattern;
      CaseSensitive = caseSensitive;
      IconStyle = iconStyle;
      Color = color;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<TodoPattern> Read = (ctx, reader) => 
    {
      var pattern = reader.ReadString();
      var caseSensitive = reader.ReadBool();
      var iconStyle = (TodoIconStyle)reader.ReadInt();
      var color = RgbColor.Read(ctx, reader);
      return new TodoPattern(pattern, caseSensitive, iconStyle, color);
    };
    
    public static CtxWriteDelegate<TodoPattern> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Pattern);
      writer.Write(value.CaseSensitive);
      writer.Write((int)value.IconStyle);
      RgbColor.Write(ctx, writer, value.Color);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TodoPattern (");
      using (printer.IndentCookie()) {
        printer.Print("pattern = "); Pattern.PrintEx(printer); printer.Println();
        printer.Print("caseSensitive = "); CaseSensitive.PrintEx(printer); printer.Println();
        printer.Print("iconStyle = "); IconStyle.PrintEx(printer); printer.Println();
        printer.Print("color = "); Color.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TodoPatterns : RdBindableBase {
    //fields
    [NotNull] public List<TodoPattern> Patterns {get; private set;}
    
    //primary constructor
    public TodoPatterns(
      [NotNull] List<TodoPattern> patterns
    )
    {
      Patterns = patterns;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<TodoPattern>> ReadTodoPatternList = TodoPattern.Read.List();
    public static CtxReadDelegate<TodoPatterns> Read = (ctx, reader) => 
    {
      var patterns = ReadTodoPatternList(ctx, reader);
      return new TodoPatterns(patterns);
    };
    
    public static CtxWriteDelegate<List<TodoPattern>> WriteTodoPatternList = TodoPattern.Write.List();
    public static CtxWriteDelegate<TodoPatterns> Write = (ctx, writer, value) => 
    {
      WriteTodoPatternList(ctx, writer, value.Patterns);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Patterns.BindEx(lifetime, this, "patterns");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Patterns.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TodoPatterns (");
      using (printer.IndentCookie()) {
        printer.Print("patterns = "); Patterns.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ToolWindowNavigation : Navigation
   {
    //fields
    [NotNull] public JetBrains.Rider.Model.TextControlId TextControlId {get; private set;}
    [NotNull] public string ToolWindowId {get; private set;}
    
    //primary constructor
    public ToolWindowNavigation(
      [NotNull] JetBrains.Rider.Model.TextControlId textControlId,
      [NotNull] string toolWindowId
    )
    {
      TextControlId = textControlId;
      ToolWindowId = toolWindowId;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ToolWindowNavigation> Read = (ctx, reader) => 
    {
      var textControlId = JetBrains.Rider.Model.TextControlId.Read(ctx, reader);
      var toolWindowId = reader.ReadString();
      return new ToolWindowNavigation(textControlId, toolWindowId);
    };
    
    public static new CtxWriteDelegate<ToolWindowNavigation> Write = (ctx, writer, value) => 
    {
      JetBrains.Rider.Model.TextControlId.Write(ctx, writer, value.TextControlId);
      writer.Write(value.ToolWindowId);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ToolWindowNavigation) obj);
    }
    public bool Equals(ToolWindowNavigation other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(TextControlId, other.TextControlId) && ToolWindowId == other.ToolWindowId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + TextControlId.GetHashCode();
        __r = __r*31 + ToolWindowId.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ToolWindowNavigation (");
      using (printer.IndentCookie()) {
        printer.Print("textControlId = "); TextControlId.PrintEx(printer); printer.Println();
        printer.Print("toolWindowId = "); ToolWindowId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TooltipProviderModel : RdBindableBase {
    //fields
    [NotNull] public RdEndpoint<int, string> GetTooltip { get { return _GetTooltip; }}
    [NotNull] private readonly RdEndpoint<int, string> _GetTooltip;
    
    //primary constructor
    private TooltipProviderModel(
      [NotNull] RdEndpoint<int, string> getTooltip
    )
    {
      _GetTooltip = getTooltip;
      getTooltip.Async = true;
    }
    //secondary constructor
    public TooltipProviderModel (
    ) : this (
      new RdEndpoint<int, string>()
    ) {}
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<TooltipProviderModel> Read = (ctx, reader) => 
    {
      var getTooltip = RdEndpoint<int, string>.Read(ctx, reader);
      return new TooltipProviderModel(getTooltip);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<TooltipProviderModel> Write = (ctx, writer, value) => 
    {
      RdEndpoint<int, string>.Write(ctx, writer, value._GetTooltip);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _GetTooltip.BindEx(lifetime, this, "getTooltip");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _GetTooltip.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TooltipProviderModel (");
      using (printer.IndentCookie()) {
        printer.Print("getTooltip = "); _GetTooltip.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TypeData : IPrintable, IEquatable<TypeData> {
    //fields
    public char TypedChar {get; private set;}
    public bool IsCompletionTerminator {get; private set;}
    public int Timestamp {get; private set;}
    
    //primary constructor
    public TypeData(
      char typedChar,
      bool isCompletionTerminator,
      int timestamp
    )
    {
      TypedChar = typedChar;
      IsCompletionTerminator = isCompletionTerminator;
      Timestamp = timestamp;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<TypeData> Read = (ctx, reader) => 
    {
      var typedChar = reader.ReadChar();
      var isCompletionTerminator = reader.ReadBool();
      var timestamp = reader.ReadInt();
      return new TypeData(typedChar, isCompletionTerminator, timestamp);
    };
    
    public static CtxWriteDelegate<TypeData> Write = (ctx, writer, value) => 
    {
      writer.Write(value.TypedChar);
      writer.Write(value.IsCompletionTerminator);
      writer.Write(value.Timestamp);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((TypeData) obj);
    }
    public bool Equals(TypeData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return TypedChar == other.TypedChar && IsCompletionTerminator == other.IsCompletionTerminator && Timestamp == other.Timestamp;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + TypedChar.GetHashCode();
        __r = __r*31 + IsCompletionTerminator.GetHashCode();
        __r = __r*31 + Timestamp.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("TypeData (");
      using (printer.IndentCookie()) {
        printer.Print("typedChar = "); TypedChar.PrintEx(printer); printer.Println();
        printer.Print("isCompletionTerminator = "); IsCompletionTerminator.PrintEx(printer); printer.Println();
        printer.Print("timestamp = "); Timestamp.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class UnloadCommand : IPrintable, IEquatable<UnloadCommand> {
    //fields
    [NotNull] public List<int> ProjectIds {get; private set;}
    
    //primary constructor
    public UnloadCommand(
      [NotNull] List<int> projectIds
    )
    {
      ProjectIds = projectIds;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static CtxReadDelegate<UnloadCommand> Read = (ctx, reader) => 
    {
      var projectIds = ReadIntList(ctx, reader);
      return new UnloadCommand(projectIds);
    };
    
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static CtxWriteDelegate<UnloadCommand> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.ProjectIds);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((UnloadCommand) obj);
    }
    public bool Equals(UnloadCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectIds.SequenceEqual(other.ProjectIds);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(ProjectIds);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("UnloadCommand (");
      using (printer.IndentCookie()) {
        printer.Print("projectIds = "); ProjectIds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class UpdateSignatureList : SignatureListBase
   {
    //fields
    public int LBracketOffset {get; private set;}
    
    //primary constructor
    public UpdateSignatureList(
      int lBracketOffset,
      [CanBeNull] int? matchedSignature,
      int currentParamIndex,
      [NotNull] List<int> disabledSignatures
    ) : base (
      matchedSignature,
      currentParamIndex,
      disabledSignatures
     ) 
    {
      LBracketOffset = lBracketOffset;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<int?> ReadIntNullable = Serializers.ReadInt.NullableStruct();
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static new CtxReadDelegate<UpdateSignatureList> Read = (ctx, reader) => 
    {
      var lBracketOffset = reader.ReadInt();
      var matchedSignature = ReadIntNullable(ctx, reader);
      var currentParamIndex = reader.ReadInt();
      var disabledSignatures = ReadIntList(ctx, reader);
      return new UpdateSignatureList(lBracketOffset, matchedSignature, currentParamIndex, disabledSignatures);
    };
    
    public static CtxWriteDelegate<int?> WriteIntNullable = Serializers.WriteInt.NullableStruct();
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static new CtxWriteDelegate<UpdateSignatureList> Write = (ctx, writer, value) => 
    {
      writer.Write(value.LBracketOffset);
      WriteIntNullable(ctx, writer, value.MatchedSignature);
      writer.Write(value.CurrentParamIndex);
      WriteIntList(ctx, writer, value.DisabledSignatures);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((UpdateSignatureList) obj);
    }
    public bool Equals(UpdateSignatureList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return LBracketOffset == other.LBracketOffset && Equals(MatchedSignature, other.MatchedSignature) && CurrentParamIndex == other.CurrentParamIndex && DisabledSignatures.SequenceEqual(other.DisabledSignatures);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + LBracketOffset.GetHashCode();
        __r = __r*31 + (MatchedSignature != null ?MatchedSignature.GetHashCode() : 0);
        __r = __r*31 + CurrentParamIndex.GetHashCode();
        __r = __r*31 + CollectionUtil.GetHashCode(DisabledSignatures);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("UpdateSignatureList (");
      using (printer.IndentCookie()) {
        printer.Print("lBracketOffset = "); LBracketOffset.PrintEx(printer); printer.Println();
        printer.Print("matchedSignature = "); MatchedSignature.PrintEx(printer); printer.Println();
        printer.Print("currentParamIndex = "); CurrentParamIndex.PrintEx(printer); printer.Println();
        printer.Print("disabledSignatures = "); DisabledSignatures.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class VisibleRange : RdBindableBase {
    //fields
    public int StartOffset {get; private set;}
    public int EndOffset {get; private set;}
    
    //primary constructor
    public VisibleRange(
      int startOffset,
      int endOffset
    )
    {
      StartOffset = startOffset;
      EndOffset = endOffset;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<VisibleRange> Read = (ctx, reader) => 
    {
      var startOffset = reader.ReadInt();
      var endOffset = reader.ReadInt();
      return new VisibleRange(startOffset, endOffset);
    };
    
    public static CtxWriteDelegate<VisibleRange> Write = (ctx, writer, value) => 
    {
      writer.Write(value.StartOffset);
      writer.Write(value.EndOffset);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("VisibleRange (");
      using (printer.IndentCookie()) {
        printer.Print("startOffset = "); StartOffset.PrintEx(printer); printer.Println();
        printer.Print("endOffset = "); EndOffset.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
