using System;
using System.Linq;
using System.Collections.Generic;
using JetBrains.Application;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.Tooltips
{
  
  
  [ShellComponent]
  public class TooltipsModel : RdBindableBase {
    //fields
    [NotNull] public ISource<TooltipDescriptor> Message { get { return _Message; }}
    [NotNull] private readonly RdSignal<TooltipDescriptor> _Message;
    
    //primary constructor
    public TooltipsModel(
      [NotNull] RdSignal<TooltipDescriptor> message
    )
    {
      _Message = message;
    }
    //secondary constructor
    //statics
    
    private void Register(ISerializers serializers)
    {
      serializers.RegisterEnum<TooltipType>();
      serializers.Register(TooltipDescriptor.Read, TooltipDescriptor.Write);
    }
    
    public TooltipsModel(Lifetime lifetime, IProtocol protocol) : this (
      new RdSignal<TooltipDescriptor>().Static(1051)
    )
    {
      Register(protocol.Serializers);
      Bind(lifetime, protocol, GetType().Name);
    }
    //init method
    protected override void Init(Lifetime lifetime) {
      _Message.BindEx(lifetime, this, "message");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Message.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TooltipsModel (");
      using (printer.IndentCookie()) {
        printer.Print("message = "); _Message.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TooltipDescriptor : IPrintable, IEquatable<TooltipDescriptor> {
    //fields
    public TooltipType Type {get; private set;}
    [NotNull] public string Text {get; private set;}
    [NotNull] public List<JetBrains.Rider.Model.UiContext.ContextPair> Timestamps {get; private set;}
    
    //primary constructor
    public TooltipDescriptor(
      TooltipType type,
      [NotNull] string text,
      [NotNull] List<JetBrains.Rider.Model.UiContext.ContextPair> timestamps
    )
    {
      Type = type;
      Text = text;
      Timestamps = timestamps;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<JetBrains.Rider.Model.UiContext.ContextPair>> ReadContextPairList = JetBrains.Rider.Model.UiContext.ContextPair.Read.List();
    public static CtxReadDelegate<TooltipDescriptor> Read = (ctx, reader) => 
    {
      var type = (TooltipType)reader.ReadInt();
      var text = reader.ReadString();
      var timestamps = ReadContextPairList(ctx, reader);
      return new TooltipDescriptor(type, text, timestamps);
    };
    
    public static CtxWriteDelegate<List<JetBrains.Rider.Model.UiContext.ContextPair>> WriteContextPairList = JetBrains.Rider.Model.UiContext.ContextPair.Write.List();
    public static CtxWriteDelegate<TooltipDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Type);
      writer.Write(value.Text);
      WriteContextPairList(ctx, writer, value.Timestamps);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((TooltipDescriptor) obj);
    }
    public bool Equals(TooltipDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Type == other.Type && Text == other.Text && Timestamps.SequenceEqual(other.Timestamps);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (int) Type;
        __r = __r*31 + Text.GetHashCode();
        __r = __r*31 + CollectionUtil.GetHashCode(Timestamps);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("TooltipDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("type = "); Type.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("timestamps = "); Timestamps.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum TooltipType {
    ERROR,
    INFO
  }
}
