/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserDialog;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browser.MessageBoxCellRenderer;
import org.jetbrains.idea.svn.dialogs.browser.OpeningExpander;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class CopyOptionsDialog
extends DialogWrapper {
    private final SVNURL myURL;
    private EditorTextField myCommitMessage;
    private final Project myProject;
    private JTextField myNameField;
    private JLabel myURLLabel;
    private RepositoryBrowserComponent myBrowser;
    private JLabel myTargetURL;
    private JComboBox myMessagesBox;
    private JPanel myMainPanel;

    public CopyOptionsDialog(String title, Project project, RepositoryTreeNode root, RepositoryTreeNode node, boolean copy) {
        super(project, true);
        this.myProject = project;
        this.myURL = node.getURL();
        this.createUI();
        if (copy) {
            this.myTargetURL.setForeground(FileStatus.ADDED.getColor());
            this.setOKButtonText("Copy");
        } else {
            this.myTargetURL.setForeground(FileStatus.MODIFIED.getColor());
            this.setOKButtonText("Move");
        }
        this.myURLLabel.setText(this.myURL.toString());
        TreeNode[] path = node.getSelfPath();
        TreeNode[] subPath = new TreeNode[path.length - 1];
        System.arraycopy(path, 1, subPath, 0, path.length - 1);
        this.myBrowser.setRepositoryURL(root.getURL(), false, new OpeningExpander.Factory(subPath, (RepositoryTreeNode)(node.getParent() instanceof RepositoryTreeNode ? node.getParent() : null)));
        this.myBrowser.addChangeListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                CopyOptionsDialog.this.update();
            }
        });
        this.myNameField.setText(SVNPathUtil.tail((String)this.myURL.getPath()));
        this.myNameField.selectAll();
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                CopyOptionsDialog.this.update();
            }
        });
        ArrayList messages = VcsConfiguration.getInstance((Project)this.myProject).getRecentMessages();
        Collections.reverse(messages);
        Object[] model = messages.toArray();
        this.myMessagesBox.setModel(new DefaultComboBoxModel<Object>(model));
        this.myMessagesBox.setRenderer(new MessageBoxCellRenderer());
        String lastMessage = VcsConfiguration.getInstance((Project)this.myProject).getLastNonEmptyCommitMessage();
        if (lastMessage != null) {
            this.myCommitMessage.setText(lastMessage);
            this.myCommitMessage.selectAll();
        }
        this.myMessagesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item = CopyOptionsDialog.this.myMessagesBox.getSelectedItem();
                if (item != null) {
                    CopyOptionsDialog.this.myCommitMessage.setText(item.toString());
                    CopyOptionsDialog.this.myCommitMessage.selectAll();
                }
            }
        });
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myBrowser);
        this.setTitle(title);
        this.init();
        this.update();
    }

    private void createUI() {
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myBrowser = new RepositoryBrowserComponent(SvnVcs.getInstance(this.myProject));
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RepositoryBrowserDialog.MkDirAction(this.myBrowser){

            @Override
            public void update(AnActionEvent e) {
                super.update(e);
                e.getPresentation().setText("New Remote Folder...");
            }
        });
        group.add((AnAction)new RepositoryBrowserDialog.DeleteAction(this.myBrowser));
        group.add((AnAction)new RepositoryBrowserDialog.RefreshAction(this.myBrowser));
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("", (ActionGroup)group);
        final JPopupMenu component = popupMenu.getComponent();
        this.myBrowser.getRepositoryTree().addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                component.show(comp, x, y);
            }
        });
        Splitter splitter = new Splitter(true);
        splitter.setProportion(0.7f);
        JPanel wrapper = this.createBrowserPartWrapper();
        splitter.setFirstComponent((JComponent)wrapper);
        JPanel commitMessageWrapper = this.createCommitMessageWrapper();
        splitter.setSecondComponent((JComponent)commitMessageWrapper);
        this.myMainPanel.add((Component)splitter, "Center");
        JPanel recentMessagesWrapper = new JPanel(new BorderLayout());
        recentMessagesWrapper.add((Component)new JLabel("Recent Messages:"), "North");
        this.myMessagesBox = new JComboBox();
        recentMessagesWrapper.add((Component)this.myMessagesBox, "South");
        recentMessagesWrapper.setBorder((Border)JBUI.Borders.emptyTop((int)4));
        this.myMainPanel.add((Component)recentMessagesWrapper, "South");
    }

    private JPanel createCommitMessageWrapper() {
        JPanel commitMessageWrapper = new JPanel(new BorderLayout());
        commitMessageWrapper.add((Component)new JLabel("Commit Message:"), "North");
        this.myCommitMessage = CommitMessage.createCommitTextEditor((Project)this.myProject, (boolean)true);
        commitMessageWrapper.add((Component)this.myCommitMessage, "Center");
        return commitMessageWrapper;
    }

    private JPanel createBrowserPartWrapper() {
        JPanel wrapper = new JPanel(new GridBagLayout());
        GridBag gridBag = new GridBag().setDefaultAnchor(18).setDefaultFill(0).setDefaultInsets((Insets)JBUI.insets((int)1)).setDefaultWeightX(1.0).setDefaultWeightY(0.0);
        gridBag.nextLine().next();
        gridBag.weightx(0.0);
        wrapper.add((Component)new JLabel("Source URL:"), gridBag);
        gridBag.next();
        gridBag.fillCellHorizontally();
        this.myURLLabel = new JLabel();
        this.myURLLabel.setFont(this.myURLLabel.getFont().deriveFont(1));
        wrapper.add((Component)this.myURLLabel, gridBag);
        gridBag.nextLine().next();
        gridBag.weightx(0.0);
        gridBag.pady(4);
        wrapper.add((Component)new JLabel("Target Location:"), gridBag);
        gridBag.nextLine().next();
        gridBag.fillCell();
        gridBag.weighty(1.0);
        gridBag.coverLine(2);
        wrapper.add((Component)this.myBrowser, gridBag);
        gridBag.nextLine().next();
        gridBag.weightx(0.0);
        gridBag.pady(4);
        wrapper.add((Component)new JLabel("Target Name:"), gridBag);
        gridBag.next();
        gridBag.fillCellHorizontally();
        this.myNameField = new JTextField();
        wrapper.add((Component)this.myNameField, gridBag);
        gridBag.nextLine().next();
        gridBag.weightx(0.0);
        gridBag.pady(2);
        wrapper.add((Component)new JLabel("Target URL:"), gridBag);
        gridBag.next();
        gridBag.fillCellHorizontally();
        this.myTargetURL = new JLabel();
        this.myTargetURL.setFont(this.myTargetURL.getFont().deriveFont(1));
        wrapper.add((Component)this.myTargetURL, gridBag);
        return wrapper;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "svn4idea.copy.options";
    }

    public String getCommitMessage() {
        return this.myCommitMessage.getText();
    }

    public SVNURL getSourceURL() {
        return this.myURL;
    }

    public String getName() {
        return this.myNameField.getText();
    }

    @Nullable
    public SVNURL getTargetURL() {
        if (this.getOKAction().isEnabled()) {
            try {
                return SVNURL.parseURIEncoded((String)this.myTargetURL.getText());
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public RepositoryTreeNode getTargetParentNode() {
        return this.myBrowser.getSelectedNode();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private void update() {
        RepositoryTreeNode baseNode = this.myBrowser.getSelectedNode();
        if (baseNode == null) {
            this.myTargetURL.setText("");
            this.getOKAction().setEnabled(false);
            return;
        }
        SVNURL baseURL = baseNode.getURL();
        String name = this.myNameField.getText();
        if (name == null || "".equals(name)) {
            this.getOKAction().setEnabled(false);
            return;
        }
        try {
            baseURL = baseURL.appendPath(this.myNameField.getText(), false);
        }
        catch (SVNException e) {
            this.getOKAction().setEnabled(false);
            return;
        }
        this.myTargetURL.setText(baseURL.toString());
        this.getOKAction().setEnabled(!this.myURL.toString().equals(this.myTargetURL.getText()));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }
}

