/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.QuickMerge;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;
import org.tmatesoft.svn.core.SVNURL;

public class LookForBranchOriginTask
extends BaseMergeTask {
    private final boolean myFromSource;
    @NotNull
    private final Consumer<SvnBranchPointsCalculator.WrapperInvertor> myCallback;

    public LookForBranchOriginTask(@NotNull QuickMerge mergeProcess, boolean fromSource, @NotNull Consumer<SvnBranchPointsCalculator.WrapperInvertor> callback) {
        if (mergeProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeProcess", "org/jetbrains/idea/svn/integrate/LookForBranchOriginTask", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/idea/svn/integrate/LookForBranchOriginTask", "<init>"));
        }
        super(mergeProcess);
        this.myFromSource = fromSource;
        this.myCallback = callback;
    }

    @Override
    public void run() throws VcsException {
        SVNURL repoUrl = this.myMergeContext.getWcInfo().getRootInfo().getRepositoryUrlUrl();
        String sourceUrl = this.myFromSource ? this.myMergeContext.getSourceUrl() : this.myMergeContext.getWcInfo().getRootUrl();
        String targetUrl = this.myFromSource ? this.myMergeContext.getWcInfo().getRootUrl() : this.myMergeContext.getSourceUrl();
        SvnBranchPointsCalculator.WrapperInvertor copyPoint = this.myMergeContext.getVcs().getSvnBranchPointsCalculator().calculateCopyPoint(repoUrl, sourceUrl, targetUrl);
        if (copyPoint != null) {
            this.myCallback.consume((Object)copyPoint);
        } else {
            this.myMergeProcess.end("Merge start wasn't found", true);
        }
    }
}

