/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.client;

import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.ItemRemovable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NameValueTableModel
extends AbstractTableModel
implements ItemRemovable,
EditableModel {
    private final List<String> names = new ArrayList<String>();
    private final List<String> values = new ArrayList<String>();
    private static final String EMPTY = "";
    @NonNls
    private static final String NAME = "Name";
    @NonNls
    private static final String VALUE = "Value";
    private final List<String> immutableHeaders = new ArrayList<String>();
    private final List<String> immutableHeadersExceptions = new ArrayList<String>();

    @Override
    public int getRowCount() {
        return this.names.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        List<String> list = columnIndex == 0 ? this.names : this.values;
        return list.get(rowIndex);
    }

    @Override
    public String getColumnName(int column) {
        return column == 0 ? NAME : VALUE;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        List<String> list = columnIndex == 0 ? this.names : this.values;
        String value = String.valueOf(aValue);
        if (rowIndex < list.size()) {
            list.set(rowIndex, value);
            if (this.names.get(rowIndex).trim().equals(EMPTY) && rowIndex != 0) {
                this.names.remove(rowIndex);
                this.values.remove(rowIndex);
            }
        } else {
            if (aValue == null || value.trim().equals(EMPTY)) {
                return;
            }
            this.addPropertyRow(EMPTY, EMPTY);
            list.set(rowIndex, value);
        }
        this.fireTableDataChanged();
    }

    public void addProperty(@NotNull @NonNls String name, @NotNull @NonNls String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ws/rest/client/NameValueTableModel", "addProperty"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ws/rest/client/NameValueTableModel", "addProperty"));
        }
        if (this.names.contains(name)) {
            int index = this.getIndexByName(name);
            this.values.set(index, value);
            this.fireTableRowsUpdated(index, index);
        } else {
            this.addPropertyRow(name, value);
        }
    }

    public void addPropertyRow(String name, String value) {
        this.names.add(name);
        this.values.add(value);
        this.fireTableRowsInserted(this.names.size() - 1, this.names.size() - 1);
    }

    public void clear() {
        this.names.clear();
        this.values.clear();
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column == 0 && row != 0 && (this.names.isEmpty() || this.names.get(0) == null || this.names.get(0).trim().length() == 0)) {
            return false;
        }
        if (row >= this.names.size()) {
            return column == 0;
        }
        if (column == 0) {
            return !this.immutableHeaders.contains(this.names.get(row));
        }
        if (this.immutableHeadersExceptions.contains(this.names.get(row))) {
            return true;
        }
        if (this.immutableHeaders.contains(this.names.get(row))) {
            return false;
        }
        return !this.names.get(row).trim().equals(EMPTY);
    }

    @NotNull
    public String getName(int index) {
        String string = index < this.names.size() ? this.names.get(index) : EMPTY;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/client/NameValueTableModel", "getName"));
        }
        return string;
    }

    @NotNull
    public String getValue(int index) {
        String string = index < this.values.size() ? this.values.get(index) : EMPTY;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/client/NameValueTableModel", "getValue"));
        }
        return string;
    }

    public int getElementsCount() {
        return this.names.size();
    }

    public void setImmutableFields(List<String> headerNames) {
        this.immutableHeaders.clear();
        this.immutableHeaders.addAll(headerNames);
    }

    public void setImmutableFields(String ... fields) {
        this.setImmutableFields(Arrays.asList(fields));
    }

    public void setImmutableHeaderExceptions(List<String> headerNames) {
        this.immutableHeadersExceptions.clear();
        this.immutableHeadersExceptions.addAll(headerNames);
    }

    public void setImmutableHeaderExceptions(String ... fields) {
        this.setImmutableHeaderExceptions(Arrays.asList(fields));
    }

    public int getIndexByName(String name) {
        for (int i = 0; i < this.names.size(); ++i) {
            if (!this.names.get(i).equals(name)) continue;
            return i;
        }
        return -1;
    }

    public void addRow() {
        this.names.add(EMPTY);
        this.values.add(EMPTY);
        int i = this.getElementsCount() - 1;
        this.fireTableRowsInserted(i, i);
    }

    public void exchangeRows(int oldIndex, int newIndex) {
        Collections.swap(this.names, oldIndex, newIndex);
        Collections.swap(this.values, oldIndex, newIndex);
        this.fireTableRowsUpdated(Math.min(oldIndex, newIndex), Math.max(oldIndex, newIndex));
    }

    public boolean canExchangeRows(int oldIndex, int newIndex) {
        return true;
    }

    public void removeRow(int idx) {
        if (idx >= this.names.size()) {
            return;
        }
        this.names.remove(idx);
        this.values.remove(idx);
        this.fireTableRowsDeleted(idx, idx);
    }
}

