/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlSerializer {
    private static final SerializationFilter TRUE_FILTER = new SerializationFilter(){

        @Override
        public boolean accepts(@NotNull Accessor accessor, @NotNull Object bean) {
            if (accessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/XmlSerializer$1", "accepts"));
            }
            if (bean == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/util/xmlb/XmlSerializer$1", "accepts"));
            }
            return true;
        }
    };

    private XmlSerializer() {
    }

    public static Element serialize(@NotNull Object object) throws XmlSerializationException {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/xmlb/XmlSerializer", "serialize"));
        }
        return XmlSerializer.serialize(object, TRUE_FILTER);
    }

    @NotNull
    public static Element serialize(@NotNull Object object, @Nullable SerializationFilter filter) throws XmlSerializationException {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/xmlb/XmlSerializer", "serialize"));
        }
        Element element = XmlSerializerImpl.serialize(object, filter == null ? TRUE_FILTER : filter);
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializer", "serialize"));
        }
        return element;
    }

    @Nullable
    public static Element serializeIfNotDefault(@NotNull Object object, @Nullable SerializationFilter filter) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/xmlb/XmlSerializer", "serializeIfNotDefault"));
        }
        return XmlSerializerImpl.serializeIfNotDefault(object, filter == null ? TRUE_FILTER : filter);
    }

    @NotNull
    public static <T> T deserialize(Document document, Class<T> aClass) throws XmlSerializationException {
        T t = XmlSerializer.deserialize(document.getRootElement(), aClass);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializer", "deserialize"));
        }
        return t;
    }

    @NotNull
    public static <T> T deserialize(@NotNull Element element, @NotNull Class<T> aClass) throws XmlSerializationException {
        Object object;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/XmlSerializer", "deserialize"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/XmlSerializer", "deserialize"));
        }
        try {
            NotNullDeserializeBinding binding = (NotNullDeserializeBinding)XmlSerializerImpl.getMainBinding(aClass, aClass, null);
            object = binding.deserialize(null, element);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException("Cannot deserialize class " + aClass.getName(), e);
        }
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializer", "deserialize"));
        }
        return (T)object;
    }

    public static <T> T[] deserialize(Element[] elements, Class<T> aClass) throws XmlSerializationException {
        Object[] result = (Object[])Array.newInstance(aClass, elements.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = XmlSerializer.deserialize(elements[i], aClass);
        }
        return result;
    }

    @NotNull
    public static <T> T deserialize(@NotNull URL url, Class<T> aClass) throws XmlSerializationException {
        T t;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/xmlb/XmlSerializer", "deserialize"));
        }
        try {
            Document document = JDOMUtil.loadDocument(url);
            document = JDOMXIncluder.resolve(document, url.toExternalForm());
            t = XmlSerializer.deserialize(document.getRootElement(), aClass);
        }
        catch (IOException e) {
            throw new XmlSerializationException(e);
        }
        catch (JDOMException e) {
            throw new XmlSerializationException(e);
        }
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializer", "deserialize"));
        }
        return t;
    }

    public static void deserializeInto(@NotNull Object bean, @NotNull Element element) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        XmlSerializer.deserializeInto(bean, element, null);
    }

    public static void deserializeInto(@NotNull Object bean, @NotNull Element element, @Nullable Set<String> accessorNameTracker) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        try {
            Class<?> clazz = bean.getClass();
            ((BeanBinding)XmlSerializerImpl.getMainBinding(clazz, clazz, null)).deserializeInto(bean, element, accessorNameTracker);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException(e);
        }
    }

    public static void serializeInto(Object bean, Element element) {
        XmlSerializer.serializeInto(bean, element, null);
    }

    public static void serializeInto(@NotNull Object bean, @NotNull Element element, @Nullable SerializationFilter filter) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/util/xmlb/XmlSerializer", "serializeInto"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/XmlSerializer", "serializeInto"));
        }
        if (filter == null) {
            filter = TRUE_FILTER;
        }
        try {
            Binding binding = XmlSerializerImpl.getBinding(bean.getClass());
            assert (binding instanceof BeanBinding);
            ((BeanBinding)binding).serializeInto(bean, element, filter);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException(e);
        }
    }
}

