/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.Pair;
import com.intellij.reference.SoftReference;
import com.intellij.util.xmlb.ArrayBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.CollectionBinding;
import com.intellij.util.xmlb.CompactCollectionBinding;
import com.intellij.util.xmlb.JDOMElementBinding;
import com.intellij.util.xmlb.MapBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.annotations.CollectionBean;
import java.lang.ref.Reference;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlSerializerImpl {
    private static Reference<Map<Pair<Type, MutableAccessor>, Binding>> ourBindings;

    @NotNull
    static Element serialize(@NotNull Object object, @NotNull SerializationFilter filter) throws XmlSerializationException {
        Element element;
        Binding binding;
        block8: {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/xmlb/XmlSerializerImpl", "serialize"));
            }
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/xmlb/XmlSerializerImpl", "serialize"));
            }
            Class<?> aClass = object.getClass();
            binding = XmlSerializerImpl.getClassBinding(aClass, aClass, null);
            if (!(binding instanceof BeanBinding)) break block8;
            Element element2 = ((BeanBinding)binding).serialize(object, true, filter);
            if (element2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "serialize"));
            }
            return element2;
        }
        try {
            element = (Element)binding.serialize(object, null, filter);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException("Can't serialize instance of " + object.getClass(), e);
        }
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "serialize"));
        }
        return element;
    }

    @Nullable
    static Element serializeIfNotDefault(@NotNull Object object, @NotNull SerializationFilter filter) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/xmlb/XmlSerializerImpl", "serializeIfNotDefault"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/xmlb/XmlSerializerImpl", "serializeIfNotDefault"));
        }
        Class<?> aClass = object.getClass();
        return (Element)XmlSerializerImpl.getMainBinding(aClass, aClass, null).serialize(object, null, filter);
    }

    @Nullable
    public static Binding getBinding(@NotNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/xmlb/XmlSerializerImpl", "getBinding"));
        }
        return XmlSerializerImpl.getClassBinding(XmlSerializerImpl.typeToClass(type), type, null);
    }

    @Nullable
    static Binding getBinding(@NotNull MutableAccessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/XmlSerializerImpl", "getBinding"));
        }
        Type type = accessor.getGenericType();
        return XmlSerializerImpl.getClassBinding(XmlSerializerImpl.typeToClass(type), type, accessor);
    }

    @NotNull
    static Class<?> typeToClass(@NotNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/xmlb/XmlSerializerImpl", "typeToClass"));
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "typeToClass"));
            }
            return clazz;
        }
        if (type instanceof TypeVariable) {
            Type bound = ((TypeVariable)type).getBounds()[0];
            Class clazz = bound instanceof Class ? (Class)bound : (Class)((ParameterizedType)bound).getRawType();
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "typeToClass"));
            }
            return clazz;
        }
        if (type instanceof WildcardType) {
            Class clazz = (Class)((WildcardType)type).getUpperBounds()[0];
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "typeToClass"));
            }
            return clazz;
        }
        Class clazz = (Class)((ParameterizedType)type).getRawType();
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "typeToClass"));
        }
        return clazz;
    }

    @Nullable
    static synchronized Binding getClassBinding(@NotNull Class<?> aClass, @NotNull Type originalType, @Nullable MutableAccessor accessor) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/XmlSerializerImpl", "getClassBinding"));
        }
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "com/intellij/util/xmlb/XmlSerializerImpl", "getClassBinding"));
        }
        if (aClass.isPrimitive() || aClass == String.class || aClass == Integer.class || aClass == Long.class || aClass == Boolean.class || aClass == Double.class || aClass == Float.class || aClass.isEnum() || Date.class.isAssignableFrom(aClass)) {
            return null;
        }
        return XmlSerializerImpl.getMainBinding(aClass, originalType, accessor);
    }

    @NotNull
    static synchronized Binding getMainBinding(@NotNull Class<?> aClass, @NotNull Type originalType, @Nullable MutableAccessor accessor) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/XmlSerializerImpl", "getMainBinding"));
        }
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "com/intellij/util/xmlb/XmlSerializerImpl", "getMainBinding"));
        }
        Pair<Type, MutableAccessor> key = Pair.create(originalType, accessor);
        Map<Pair<Type, MutableAccessor>, Binding> map = XmlSerializerImpl.getBindingCacheMap();
        Binding binding = map.get(key);
        if (binding == null) {
            binding = XmlSerializerImpl.getNonCachedClassBinding(aClass, accessor, originalType);
            if (binding == null) {
                binding = new BeanBinding(aClass, accessor);
            }
            map.put(key, binding);
            try {
                binding.init(originalType);
            }
            catch (XmlSerializationException e) {
                map.remove(key);
                throw e;
            }
        }
        Binding binding2 = binding;
        if (binding2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getMainBinding"));
        }
        return binding2;
    }

    @NotNull
    private static Map<Pair<Type, MutableAccessor>, Binding> getBindingCacheMap() {
        Map<Pair<Type, MutableAccessor>, Binding> map = SoftReference.dereference(ourBindings);
        if (map == null) {
            map = new ConcurrentHashMap<Pair<Type, MutableAccessor>, Binding>();
            ourBindings = new java.lang.ref.SoftReference<Map<Pair<Type, MutableAccessor>, Binding>>(map);
        }
        Map<Pair<Type, MutableAccessor>, Binding> map2 = map;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getBindingCacheMap"));
        }
        return map2;
    }

    @Nullable
    public static Binding getNonCachedClassBinding(@NotNull Class<?> aClass, @Nullable MutableAccessor accessor, @NotNull Type originalType) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
        }
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
        }
        if (aClass.isArray()) {
            if (Element.class.isAssignableFrom(aClass.getComponentType())) {
                assert (accessor != null);
                return new JDOMElementBinding(accessor);
            }
            return new ArrayBinding(aClass, accessor);
        }
        if (Collection.class.isAssignableFrom(aClass) && originalType instanceof ParameterizedType) {
            CollectionBean listBean;
            if (accessor != null && (listBean = accessor.getAnnotation(CollectionBean.class)) != null) {
                return new CompactCollectionBinding(accessor);
            }
            return new CollectionBinding((ParameterizedType)originalType, accessor);
        }
        if (accessor != null) {
            if (Map.class.isAssignableFrom(aClass) && originalType instanceof ParameterizedType) {
                return new MapBinding(accessor);
            }
            if (Element.class.isAssignableFrom(aClass)) {
                return new JDOMElementBinding(accessor);
            }
            if (JDOMExternalizableStringList.class == aClass) {
                return new CompactCollectionBinding(accessor);
            }
        }
        return null;
    }

    @Nullable
    static Object convert(@Nullable String value, @NotNull Class<?> valueClass) {
        if (valueClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueClass", "com/intellij/util/xmlb/XmlSerializerImpl", "convert"));
        }
        if (value == null) {
            return null;
        }
        if (valueClass == String.class) {
            return value;
        }
        if (valueClass == Integer.TYPE || valueClass == Integer.class) {
            return Integer.parseInt(value);
        }
        if (valueClass == Boolean.TYPE || valueClass == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (valueClass == Double.TYPE || valueClass == Double.class) {
            return Double.parseDouble(value);
        }
        if (valueClass == Float.TYPE || valueClass == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (valueClass == Long.TYPE || valueClass == Long.class) {
            return Long.parseLong(value);
        }
        if (valueClass.isEnum()) {
            for (Object enumConstant : valueClass.getEnumConstants()) {
                if (!enumConstant.toString().equals(value)) continue;
                return enumConstant;
            }
            return null;
        }
        if (Date.class.isAssignableFrom(valueClass)) {
            try {
                return new Date(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                return new Date(0L);
            }
        }
        return value;
    }

    static void doSet(@NotNull Object host, @Nullable String value, @NotNull MutableAccessor accessor, @NotNull Class<?> valueClass) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/xmlb/XmlSerializerImpl", "doSet"));
        }
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/XmlSerializerImpl", "doSet"));
        }
        if (valueClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueClass", "com/intellij/util/xmlb/XmlSerializerImpl", "doSet"));
        }
        if (value == null) {
            accessor.set(host, null);
        } else if (valueClass == String.class) {
            accessor.set(host, value);
        } else if (valueClass == Integer.TYPE) {
            accessor.setInt(host, Integer.parseInt(value));
        } else if (valueClass == Boolean.TYPE) {
            accessor.setBoolean(host, Boolean.parseBoolean(value));
        } else if (valueClass == Double.TYPE) {
            accessor.setDouble(host, Double.parseDouble(value));
        } else if (valueClass == Float.TYPE) {
            accessor.setFloat(host, Float.parseFloat(value));
        } else if (valueClass == Long.TYPE) {
            accessor.setLong(host, Long.parseLong(value));
        } else if (valueClass == Short.TYPE) {
            accessor.setShort(host, Short.parseShort(value));
        } else if (valueClass.isEnum()) {
            Object deserializedValue = null;
            for (Object enumConstant : valueClass.getEnumConstants()) {
                if (!enumConstant.toString().equals(value)) continue;
                deserializedValue = enumConstant;
            }
            accessor.set(host, deserializedValue);
        } else if (Date.class.isAssignableFrom(valueClass)) {
            try {
                accessor.set(host, new Date(Long.parseLong(value)));
            }
            catch (NumberFormatException e) {
                accessor.set(host, new Date(0L));
            }
        } else {
            Object deserializedValue = value;
            if (valueClass == Boolean.class) {
                deserializedValue = Boolean.parseBoolean(value);
            } else if (valueClass == Integer.class) {
                deserializedValue = Integer.parseInt(value);
            } else if (valueClass == Short.class) {
                deserializedValue = Short.parseShort(value);
            } else if (valueClass == Long.class) {
                deserializedValue = Long.parseLong(value);
            } else if (valueClass == Double.class) {
                deserializedValue = Double.parseDouble(value);
            } else if (valueClass == Float.class) {
                deserializedValue = Float.valueOf(Float.parseFloat(value));
            }
            accessor.set(host, deserializedValue);
        }
    }

    @NotNull
    static String convertToString(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/xmlb/XmlSerializerImpl", "convertToString"));
        }
        if (value instanceof Date) {
            String string = Long.toString(((Date)value).getTime());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "convertToString"));
            }
            return string;
        }
        String string = value.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "convertToString"));
        }
        return string;
    }

    @NotNull
    static String getTextValue(@NotNull Element element, @NotNull String defaultText) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/XmlSerializerImpl", "getTextValue"));
        }
        if (defaultText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultText", "com/intellij/util/xmlb/XmlSerializerImpl", "getTextValue"));
        }
        List content = element.getContent();
        int size = content.size();
        StringBuilder builder = null;
        for (int i = 0; i < size; ++i) {
            Content child = (Content)content.get(i);
            if (!(child instanceof Text)) continue;
            String value = child.getValue();
            if (builder == null && i == size - 1) {
                String string = value;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getTextValue"));
                }
                return string;
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(value);
        }
        String string = builder == null ? defaultText : builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getTextValue"));
        }
        return string;
    }
}

