/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.coretext;

import com.sun.javafx.font.DisposerRecord;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.Glyph;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.PrismFontStrike;
import com.sun.javafx.font.coretext.CGAffineTransform;
import com.sun.javafx.font.coretext.CGRect;
import com.sun.javafx.font.coretext.CTFontFile;
import com.sun.javafx.font.coretext.CTGlyph;
import com.sun.javafx.font.coretext.CTStrikeDisposer;
import com.sun.javafx.font.coretext.OS;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.transform.BaseTransform;

class CTFontStrike
extends PrismFontStrike<CTFontFile> {
    private long fontRef;
    CGAffineTransform matrix;
    static final float SUBPIXEL4_SIZE = 12.0f;
    static final float SUBPIXEL3_SIZE = 18.0f;
    static final float SUBPIXEL2_SIZE = 34.0f;
    private static final boolean SUBPIXEL;

    CTFontStrike(CTFontFile fontResource, float size, BaseTransform graphicsTransform, int aaMode, FontStrikeDesc desc) {
        super(fontResource, size, graphicsTransform, aaMode, desc);
        float maxDim = PrismFontFactory.getFontSizeLimit();
        if (graphicsTransform.isTranslateOrIdentity()) {
            this.drawShapes = size > maxDim;
        } else {
            BaseTransform tx2d = this.getTransform();
            this.matrix = new CGAffineTransform();
            this.matrix.a = tx2d.getMxx();
            this.matrix.b = -tx2d.getMyx();
            this.matrix.c = -tx2d.getMxy();
            this.matrix.d = tx2d.getMyy();
            if (Math.abs(this.matrix.a * (double)size) > (double)maxDim || Math.abs(this.matrix.b * (double)size) > (double)maxDim || Math.abs(this.matrix.c * (double)size) > (double)maxDim || Math.abs(this.matrix.d * (double)size) > (double)maxDim) {
                this.drawShapes = true;
            }
        }
        long psNameRef = OS.CFStringCreate(fontResource.getPSName());
        if (psNameRef != 0L) {
            this.fontRef = OS.CTFontCreateWithName(psNameRef, size, this.matrix);
            OS.CFRelease(psNameRef);
        }
        if (this.fontRef == 0L && PrismFontFactory.debugFonts) {
            System.err.println("Failed to create CTFont for " + this);
        }
    }

    long getFontRef() {
        return this.fontRef;
    }

    @Override
    protected DisposerRecord createDisposer(FontStrikeDesc desc) {
        CTFontFile fontResource = (CTFontFile)this.getFontResource();
        return new CTStrikeDisposer(fontResource, desc, this.fontRef);
    }

    @Override
    protected Glyph createGlyph(int glyphCode) {
        return new CTGlyph(this, glyphCode, this.drawShapes);
    }

    @Override
    public int getQuantizedPosition(Point2D point) {
        if (SUBPIXEL && this.matrix == null) {
            if (this.getSize() < 12.0f) {
                float subPixelX = point.x;
                point.x = (int)point.x;
                subPixelX -= point.x;
                point.y = Math.round(point.y);
                if (subPixelX >= 0.75f) {
                    return 3;
                }
                if (subPixelX >= 0.5f) {
                    return 2;
                }
                if (subPixelX >= 0.25f) {
                    return 1;
                }
                return 0;
            }
            if (this.getAAMode() == 0) {
                if (this.getSize() < 18.0f) {
                    float subPixelX = point.x;
                    point.x = (int)point.x;
                    subPixelX -= point.x;
                    point.y = Math.round(point.y);
                    if (subPixelX >= 0.66f) {
                        return 2;
                    }
                    if (subPixelX >= 0.33f) {
                        return 1;
                    }
                    return 0;
                }
                if (this.getSize() < 34.0f) {
                    float subPixelX = point.x;
                    point.x = (int)point.x;
                    subPixelX -= point.x;
                    point.y = Math.round(point.y);
                    if (subPixelX >= 0.5f) {
                        return 1;
                    }
                }
                return 0;
            }
        }
        return super.getQuantizedPosition(point);
    }

    float getSubPixelPosition(int index) {
        if (index == 0) {
            return 0.0f;
        }
        float size = this.getSize();
        if (size < 12.0f) {
            if (index == 3) {
                return 0.75f;
            }
            if (index == 2) {
                return 0.5f;
            }
            if (index == 1) {
                return 0.25f;
            }
            return 0.0f;
        }
        if (this.getAAMode() == 1) {
            return 0.0f;
        }
        if (size < 18.0f) {
            if (index == 2) {
                return 0.66f;
            }
            if (index == 1) {
                return 0.33f;
            }
            return 0.0f;
        }
        if (size < 34.0f && index == 1) {
            return 0.5f;
        }
        return 0.0f;
    }

    boolean isSubPixelGlyph() {
        return SUBPIXEL && this.matrix == null;
    }

    @Override
    protected Path2D createGlyphOutline(int glyphCode) {
        CTFontFile fontResource = (CTFontFile)this.getFontResource();
        return fontResource.getGlyphOutline(glyphCode, this.getSize());
    }

    CGRect getBBox(int glyphCode) {
        CTFontFile fontResource = (CTFontFile)this.getFontResource();
        return fontResource.getBBox(glyphCode, this.getSize());
    }

    static {
        int mode = PrismFontFactory.getFontFactory().getSubPixelMode();
        SUBPIXEL = (mode & 1) != 0;
    }
}

