/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.behavior.TextBinding;
import com.sun.javafx.scene.control.skin.ContextMenuContent;
import com.sun.javafx.scene.text.HitInfo;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.tk.Toolkit;
import java.text.Bidi;
import java.text.BreakIterator;
import java.util.function.Consumer;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.OverrunStyle;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.Mnemonic;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextBoundsType;

public class Utils {
    static final Text helper = new Text();
    static final double DEFAULT_WRAPPING_WIDTH = helper.getWrappingWidth();
    static final double DEFAULT_LINE_SPACING = helper.getLineSpacing();
    static final String DEFAULT_TEXT = helper.getText();
    static final TextBoundsType DEFAULT_BOUNDS_TYPE = helper.getBoundsType();
    static final TextLayout layout = Toolkit.getToolkit().getTextLayoutFactory().createLayout();
    private static BreakIterator charIterator = null;

    static double getAscent(Font font, TextBoundsType boundsType) {
        layout.setContent("", font.impl_getNativeFont());
        layout.setWrapWidth(0.0f);
        layout.setLineSpacing(0.0f);
        if (boundsType == TextBoundsType.LOGICAL_VERTICAL_CENTER) {
            layout.setBoundsType(16384);
        } else {
            layout.setBoundsType(0);
        }
        return -layout.getBounds().getMinY();
    }

    static double getLineHeight(Font font, TextBoundsType boundsType) {
        layout.setContent("", font.impl_getNativeFont());
        layout.setWrapWidth(0.0f);
        layout.setLineSpacing(0.0f);
        if (boundsType == TextBoundsType.LOGICAL_VERTICAL_CENTER) {
            layout.setBoundsType(16384);
        } else {
            layout.setBoundsType(0);
        }
        return layout.getLines()[0].getBounds().getHeight();
    }

    static double computeTextWidth(Font font, String text, double wrappingWidth) {
        layout.setContent(text != null ? text : "", font.impl_getNativeFont());
        layout.setWrapWidth((float)wrappingWidth);
        return layout.getBounds().getWidth();
    }

    static double computeTextHeight(Font font, String text, double wrappingWidth, TextBoundsType boundsType) {
        return Utils.computeTextHeight(font, text, wrappingWidth, 0.0, boundsType);
    }

    static double computeTextHeight(Font font, String text, double wrappingWidth, double lineSpacing, TextBoundsType boundsType) {
        layout.setContent(text != null ? text : "", font.impl_getNativeFont());
        layout.setWrapWidth((float)wrappingWidth);
        layout.setLineSpacing((float)lineSpacing);
        if (boundsType == TextBoundsType.LOGICAL_VERTICAL_CENTER) {
            layout.setBoundsType(16384);
        } else {
            layout.setBoundsType(0);
        }
        return layout.getBounds().getHeight();
    }

    static int computeTruncationIndex(Font font, String text, double width) {
        helper.setText(text);
        helper.setFont(font);
        helper.setWrappingWidth(0.0);
        helper.setLineSpacing(0.0);
        Bounds bounds = helper.getLayoutBounds();
        Point2D endPoint = new Point2D(width - 2.0, bounds.getMinY() + bounds.getHeight() / 2.0);
        int index = helper.impl_hitTestChar(endPoint).getCharIndex();
        helper.setWrappingWidth(DEFAULT_WRAPPING_WIDTH);
        helper.setLineSpacing(DEFAULT_LINE_SPACING);
        helper.setText(DEFAULT_TEXT);
        return index;
    }

    static String computeClippedText(Font font, String text, double width, OverrunStyle type, String ellipsisString) {
        String ellipsis;
        if (font == null) {
            throw new IllegalArgumentException("Must specify a font");
        }
        OverrunStyle style = type == null || type == OverrunStyle.CLIP ? OverrunStyle.ELLIPSIS : type;
        String string = ellipsis = type == OverrunStyle.CLIP ? "" : ellipsisString;
        if (text == null || "".equals(text)) {
            return text;
        }
        double stringWidth = Utils.computeTextWidth(font, text, 0.0);
        if (stringWidth - width < (double)0.001f) {
            return text;
        }
        double ellipsisWidth = Utils.computeTextWidth(font, ellipsis, 0.0);
        double availableWidth = width - ellipsisWidth;
        if (width < ellipsisWidth) {
            return "";
        }
        boolean complexLayout = false;
        if (style == OverrunStyle.ELLIPSIS || style == OverrunStyle.WORD_ELLIPSIS || style == OverrunStyle.LEADING_ELLIPSIS || style == OverrunStyle.LEADING_WORD_ELLIPSIS) {
            String substring;
            boolean fullTrim;
            int stepValue;
            boolean wordTrim;
            boolean bl = wordTrim = style == OverrunStyle.WORD_ELLIPSIS || style == OverrunStyle.LEADING_WORD_ELLIPSIS;
            if (style == OverrunStyle.ELLIPSIS && !new Bidi(text, 0).isMixed()) {
                int hit = Utils.computeTruncationIndex(font, text, width - ellipsisWidth);
                if (hit < 0 || hit >= text.length()) {
                    return text;
                }
                return text.substring(0, hit) + ellipsis;
            }
            double total = 0.0;
            int whitespaceIndex = -1;
            int index = 0;
            int start = style == OverrunStyle.LEADING_ELLIPSIS || style == OverrunStyle.LEADING_WORD_ELLIPSIS ? text.length() - 1 : 0;
            int end = start == 0 ? text.length() - 1 : 0;
            int n = stepValue = start == 0 ? 1 : -1;
            boolean done = start == 0 ? start > end : start < end;
            int i = start;
            while (!done) {
                index = i;
                char c = text.charAt(index);
                total = Utils.computeTextWidth(font, start == 0 ? text.substring(0, i + 1) : text.substring(i, start + 1), 0.0);
                if (Character.isWhitespace(c)) {
                    whitespaceIndex = index;
                }
                if (total > availableWidth) break;
                done = start == 0 ? i >= end : i <= end;
                i += stepValue;
            }
            boolean bl2 = fullTrim = !wordTrim || whitespaceIndex == -1;
            String string2 = start == 0 ? text.substring(0, fullTrim ? index : whitespaceIndex) : (substring = text.substring((fullTrim ? index : whitespaceIndex) + 1));
            assert (!text.equals(substring));
            if (style == OverrunStyle.ELLIPSIS || style == OverrunStyle.WORD_ELLIPSIS) {
                return substring + ellipsis;
            }
            return ellipsis + substring;
        }
        int leadingIndex = 0;
        int trailingIndex = 0;
        int leadingWhitespace = -1;
        int trailingWhitespace = -1;
        leadingIndex = -1;
        trailingIndex = -1;
        double total = 0.0;
        for (int i = 0; i <= text.length() - 1; ++i) {
            char c = text.charAt(i);
            if ((total += Utils.computeTextWidth(font, "" + c, 0.0)) > availableWidth) break;
            leadingIndex = i;
            if (Character.isWhitespace(c)) {
                leadingWhitespace = leadingIndex;
            }
            int index = text.length() - 1 - i;
            c = text.charAt(index);
            if ((total += Utils.computeTextWidth(font, "" + c, 0.0)) > availableWidth) break;
            trailingIndex = index;
            if (!Character.isWhitespace(c)) continue;
            trailingWhitespace = trailingIndex;
        }
        if (leadingIndex < 0) {
            return ellipsis;
        }
        if (style == OverrunStyle.CENTER_ELLIPSIS) {
            if (trailingIndex < 0) {
                return text.substring(0, leadingIndex + 1) + ellipsis;
            }
            return text.substring(0, leadingIndex + 1) + ellipsis + text.substring(trailingIndex);
        }
        boolean leadingIndexIsLastLetterInWord = Character.isWhitespace(text.charAt(leadingIndex + 1));
        int index = leadingWhitespace == -1 || leadingIndexIsLastLetterInWord ? leadingIndex + 1 : leadingWhitespace;
        String leading = text.substring(0, index);
        if (trailingIndex < 0) {
            return leading + ellipsis;
        }
        boolean trailingIndexIsFirstLetterInWord = Character.isWhitespace(text.charAt(trailingIndex - 1));
        index = trailingWhitespace == -1 || trailingIndexIsFirstLetterInWord ? trailingIndex : trailingWhitespace + 1;
        String trailing = text.substring(index);
        return leading + ellipsis + trailing;
    }

    static String computeClippedWrappedText(Font font, String text, double width, double height, OverrunStyle truncationStyle, String ellipsisString, TextBoundsType boundsType) {
        Point2D endPoint;
        int hit;
        if (font == null) {
            throw new IllegalArgumentException("Must specify a font");
        }
        String ellipsis = truncationStyle == OverrunStyle.CLIP ? "" : ellipsisString;
        int eLen = ellipsis.length();
        double eWidth = Utils.computeTextWidth(font, ellipsis, 0.0);
        double eHeight = Utils.computeTextHeight(font, ellipsis, 0.0, boundsType);
        if (width < eWidth || height < eHeight) {
            return text;
        }
        helper.setText(text);
        helper.setFont(font);
        helper.setWrappingWidth((int)Math.ceil(width));
        helper.setBoundsType(boundsType);
        helper.setLineSpacing(0.0);
        boolean leading = truncationStyle == OverrunStyle.LEADING_ELLIPSIS || truncationStyle == OverrunStyle.LEADING_WORD_ELLIPSIS;
        boolean center = truncationStyle == OverrunStyle.CENTER_ELLIPSIS || truncationStyle == OverrunStyle.CENTER_WORD_ELLIPSIS;
        boolean trailing = !leading && !center;
        boolean wordTrim = truncationStyle == OverrunStyle.WORD_ELLIPSIS || truncationStyle == OverrunStyle.LEADING_WORD_ELLIPSIS || truncationStyle == OverrunStyle.CENTER_WORD_ELLIPSIS;
        String result = text;
        int len = result != null ? result.length() : 0;
        int centerLen = -1;
        Point2D centerPoint = null;
        if (center) {
            centerPoint = new Point2D((width - eWidth) / 2.0, height / 2.0 - helper.getBaselineOffset());
        }
        if ((hit = helper.impl_hitTestChar(endPoint = new Point2D(0.0, height - helper.getBaselineOffset())).getCharIndex()) >= len) {
            helper.setBoundsType(TextBoundsType.LOGICAL);
            return text;
        }
        if (center) {
            hit = helper.impl_hitTestChar(centerPoint).getCharIndex();
        }
        if (hit > 0 && hit < len) {
            int brInd;
            int ind;
            if (center || trailing) {
                ind = hit;
                if (center) {
                    if (wordTrim) {
                        brInd = Utils.lastBreakCharIndex(text, ind + 1);
                        if (brInd >= 0) {
                            ind = brInd + 1;
                        } else {
                            brInd = Utils.firstBreakCharIndex(text, ind);
                            if (brInd >= 0) {
                                ind = brInd + 1;
                            }
                        }
                    }
                    centerLen = ind + eLen;
                }
                result = result.substring(0, ind) + ellipsis;
            }
            if (leading || center) {
                ind = Math.max(0, len - hit - 10);
                if (ind > 0 && wordTrim) {
                    brInd = Utils.lastBreakCharIndex(text, ind + 1);
                    if (brInd >= 0) {
                        ind = brInd + 1;
                    } else {
                        brInd = Utils.firstBreakCharIndex(text, ind);
                        if (brInd >= 0) {
                            ind = brInd + 1;
                        }
                    }
                }
                result = center ? result + text.substring(ind) : ellipsis + text.substring(ind);
            }
            while (true) {
                int brInd2;
                int ind2;
                helper.setText(result);
                int hit2 = helper.impl_hitTestChar(endPoint).getCharIndex();
                if (center && hit2 < centerLen) {
                    if (hit2 > 0 && result.charAt(hit2 - 1) == '\n') {
                        --hit2;
                    }
                    result = text.substring(0, hit2) + ellipsis;
                    break;
                }
                if (hit2 <= 0 || hit2 >= result.length()) break;
                if (leading) {
                    ind2 = eLen + 1;
                    if (wordTrim && (brInd2 = Utils.firstBreakCharIndex(result, ind2)) >= 0) {
                        ind2 = brInd2 + 1;
                    }
                    result = ellipsis + result.substring(ind2);
                    continue;
                }
                if (center) {
                    ind2 = centerLen + 1;
                    if (wordTrim && (brInd2 = Utils.firstBreakCharIndex(result, ind2)) >= 0) {
                        ind2 = brInd2 + 1;
                    }
                    result = result.substring(0, centerLen) + result.substring(ind2);
                    continue;
                }
                ind2 = result.length() - eLen - 1;
                if (wordTrim && (brInd2 = Utils.lastBreakCharIndex(result, ind2)) >= 0) {
                    ind2 = brInd2;
                }
                result = result.substring(0, ind2) + ellipsis;
            }
        }
        helper.setWrappingWidth(DEFAULT_WRAPPING_WIDTH);
        helper.setLineSpacing(DEFAULT_LINE_SPACING);
        helper.setText(DEFAULT_TEXT);
        helper.setBoundsType(DEFAULT_BOUNDS_TYPE);
        return result;
    }

    private static int firstBreakCharIndex(String str, int start) {
        char[] chars = str.toCharArray();
        for (int i = start; i < chars.length; ++i) {
            if (!Utils.isPreferredBreakCharacter(chars[i])) continue;
            return i;
        }
        return -1;
    }

    private static int lastBreakCharIndex(String str, int start) {
        char[] chars = str.toCharArray();
        for (int i = start; i >= 0; --i) {
            if (!Utils.isPreferredBreakCharacter(chars[i])) continue;
            return i;
        }
        return -1;
    }

    private static boolean isPreferredBreakCharacter(char ch) {
        if (Character.isWhitespace(ch)) {
            return true;
        }
        switch (ch) {
            case '.': 
            case ':': 
            case ';': {
                return true;
            }
        }
        return false;
    }

    private static boolean requiresComplexLayout(Font font, String string) {
        return false;
    }

    static int computeStartOfWord(Font font, String text, int index) {
        if ("".equals(text) || index < 0) {
            return 0;
        }
        if (text.length() <= index) {
            return text.length();
        }
        if (Character.isWhitespace(text.charAt(index))) {
            return index;
        }
        boolean complexLayout = Utils.requiresComplexLayout(font, text);
        if (complexLayout) {
            return 0;
        }
        int i = index;
        while (--i >= 0) {
            if (!Character.isWhitespace(text.charAt(i))) continue;
            return i + 1;
        }
        return 0;
    }

    static int computeEndOfWord(Font font, String text, int index) {
        if (text.equals("") || index < 0) {
            return 0;
        }
        if (text.length() <= index) {
            return text.length();
        }
        if (Character.isWhitespace(text.charAt(index))) {
            return index;
        }
        boolean complexLayout = Utils.requiresComplexLayout(font, text);
        if (complexLayout) {
            return text.length();
        }
        int i = index;
        while (++i < text.length()) {
            if (!Character.isWhitespace(text.charAt(i))) continue;
            return i;
        }
        return text.length();
    }

    public static double boundedSize(double value, double min, double max) {
        return Math.min(Math.max(value, min), Math.max(min, max));
    }

    static void addMnemonics(ContextMenu popup, Scene scene) {
        Utils.addMnemonics(popup, scene, false);
    }

    static void addMnemonics(ContextMenu popup, Scene scene, boolean initialState) {
        if (!PlatformUtil.isMac()) {
            ContextMenuContent cmContent = (ContextMenuContent)popup.getSkin().getNode();
            for (int i = 0; i < popup.getItems().size(); ++i) {
                TextBinding bindings;
                int mnemonicIndex;
                MenuItem menuitem = (MenuItem)popup.getItems().get(i);
                if (!menuitem.isMnemonicParsing() || (mnemonicIndex = (bindings = new TextBinding(menuitem.getText())).getMnemonicIndex()) < 0) continue;
                KeyCombination mnemonicKeyCombo = bindings.getMnemonicKeyCombination();
                Mnemonic myMnemonic = new Mnemonic(cmContent.getLabelAt(i), mnemonicKeyCombo);
                scene.addMnemonic(myMnemonic);
                cmContent.getLabelAt(i).impl_setShowMnemonics(initialState);
            }
        }
    }

    static void removeMnemonics(ContextMenu popup, Scene scene) {
        if (!PlatformUtil.isMac()) {
            ContextMenuContent cmContent = (ContextMenuContent)popup.getSkin().getNode();
            for (int i = 0; i < popup.getItems().size(); ++i) {
                TextBinding bindings;
                int mnemonicIndex;
                MenuItem menuitem = (MenuItem)popup.getItems().get(i);
                if (!menuitem.isMnemonicParsing() || (mnemonicIndex = (bindings = new TextBinding(menuitem.getText())).getMnemonicIndex()) < 0) continue;
                KeyCombination mnemonicKeyCombo = bindings.getMnemonicKeyCombination();
                ObservableList mnemonicsList = (ObservableList)scene.getMnemonics().get(mnemonicKeyCombo);
                if (mnemonicsList == null) continue;
                for (int j = 0; j < mnemonicsList.size(); ++j) {
                    if (((Mnemonic)mnemonicsList.get(j)).getNode() != cmContent.getLabelAt(i)) continue;
                    mnemonicsList.remove(j);
                }
            }
        }
    }

    static double computeXOffset(double width, double contentWidth, HPos hpos) {
        if (hpos == null) {
            return 0.0;
        }
        switch (hpos) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (width - contentWidth) / 2.0;
            }
            case RIGHT: {
                return width - contentWidth;
            }
        }
        return 0.0;
    }

    static double computeYOffset(double height, double contentHeight, VPos vpos) {
        if (vpos == null) {
            return 0.0;
        }
        switch (vpos) {
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (height - contentHeight) / 2.0;
            }
            case BOTTOM: {
                return height - contentHeight;
            }
        }
        return 0.0;
    }

    public static boolean isTwoLevelFocus() {
        return Platform.isSupported(ConditionalFeature.TWO_LEVEL_FOCUS);
    }

    public static int getHitInsertionIndex(HitInfo hit, String text) {
        int charIndex = hit.getCharIndex();
        if (text != null && !hit.isLeading()) {
            if (charIterator == null) {
                charIterator = BreakIterator.getCharacterInstance();
            }
            charIterator.setText(text);
            int next = charIterator.following(charIndex);
            charIndex = next == -1 ? hit.getInsertionIndex() : next;
        }
        return charIndex;
    }

    public static <T> void executeOnceWhenPropertyIsNonNull(final ObservableValue<T> p, final Consumer<T> consumer) {
        if (p == null) {
            return;
        }
        T value = p.getValue();
        if (value != null) {
            consumer.accept(value);
        } else {
            InvalidationListener listener = new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    Object value = p.getValue();
                    if (value != null) {
                        p.removeListener(this);
                        consumer.accept(value);
                    }
                }
            };
            p.addListener(listener);
        }
    }
}

