/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.glass.ui.Screen;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.sg.prism.EffectFilter;
import com.sun.javafx.sg.prism.NGGroup;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGShape;
import com.sun.javafx.sg.prism.NodePath;
import com.sun.javafx.sg.prism.RegionImageCache;
import com.sun.javafx.tk.Toolkit;
import com.sun.prism.BasicStroke;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.RTTexture;
import com.sun.prism.Texture;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.paint.Paint;
import com.sun.scenario.effect.Offset;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderImage;
import javafx.scene.layout.BorderRepeat;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.LinearGradient;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

public class NGRegion
extends NGGroup {
    private static final Affine2D SCRATCH_AFFINE = new Affine2D();
    private static final Rectangle TEMP_RECT = new Rectangle();
    private static WeakHashMap<Screen, RegionImageCache> imageCacheMap = new WeakHashMap();
    private static final int CACHE_SLICE_V = 1;
    private static final int CACHE_SLICE_H = 2;
    private Background background = Background.EMPTY;
    private Insets backgroundInsets = Insets.EMPTY;
    private Border border = Border.EMPTY;
    private List<CornerRadii> normalizedFillCorners;
    private List<CornerRadii> normalizedStrokeCorners;
    private Shape shape;
    private NGShape ngShape;
    private boolean scaleShape = true;
    private boolean centerShape = true;
    private boolean cacheShape = false;
    private float opaqueTop = Float.NaN;
    private float opaqueRight = Float.NaN;
    private float opaqueBottom = Float.NaN;
    private float opaqueLeft = Float.NaN;
    private float width;
    private float height;
    private int cacheMode;
    private Integer cacheKey;
    private static final Offset nopEffect = new Offset(0, 0, null);
    private EffectFilter nopEffectFilter;

    static Paint getPlatformPaint(javafx.scene.paint.Paint paint) {
        return (Paint)Toolkit.getPaintAccessor().getPlatformPaint(paint);
    }

    public void updateShape(Object shape, boolean scaleShape, boolean positionShape, boolean cacheShape) {
        this.ngShape = shape == null ? null : (NGShape)((javafx.scene.shape.Shape)shape).impl_getPeer();
        this.shape = shape == null ? null : this.ngShape.getShape();
        this.scaleShape = scaleShape;
        this.centerShape = positionShape;
        this.cacheShape = cacheShape;
        this.invalidateOpaqueRegion();
        this.cacheKey = null;
        this.visualsChanged();
    }

    public void setSize(float width, float height) {
        this.width = width;
        this.height = height;
        this.invalidateOpaqueRegion();
        this.cacheKey = null;
        if (this.background != null && this.background.isFillPercentageBased()) {
            this.backgroundInsets = null;
        }
    }

    public void imagesUpdated() {
        this.visualsChanged();
    }

    public void updateBorder(Border b) {
        Border old = this.border;
        Border border = this.border = b == null ? Border.EMPTY : b;
        if (!this.border.getOutsets().equals(old.getOutsets())) {
            this.geometryChanged();
        } else {
            this.visualsChanged();
        }
    }

    public void updateStrokeCorners(List<CornerRadii> normalizedStrokeCorners) {
        this.normalizedStrokeCorners = normalizedStrokeCorners;
    }

    private CornerRadii getNormalizedStrokeRadii(int index) {
        return this.normalizedStrokeCorners == null ? this.border.getStrokes().get(index).getRadii() : this.normalizedStrokeCorners.get(index);
    }

    public void updateBackground(Background b) {
        Background old = this.background;
        this.background = b == null ? Background.EMPTY : b;
        List<BackgroundFill> fills = this.background.getFills();
        this.cacheMode = 0;
        if (!(PrismSettings.disableRegionCaching || fills.isEmpty() || this.shape != null && !this.cacheShape)) {
            this.cacheMode = 3;
            int max = fills.size();
            for (int i = 0; i < max && this.cacheMode != 0; ++i) {
                BackgroundFill fill = fills.get(i);
                javafx.scene.paint.Paint paint = fill.getFill();
                if (this.shape == null) {
                    if (paint instanceof LinearGradient) {
                        LinearGradient linear = (LinearGradient)paint;
                        if (linear.getStartX() != linear.getEndX()) {
                            this.cacheMode &= 0xFFFFFFFD;
                        }
                        if (linear.getStartY() == linear.getEndY()) continue;
                        this.cacheMode &= 0xFFFFFFFE;
                        continue;
                    }
                    if (paint instanceof Color) continue;
                    this.cacheMode = 0;
                    continue;
                }
                if (!(paint instanceof ImagePattern)) continue;
                this.cacheMode = 0;
            }
        }
        this.backgroundInsets = null;
        this.cacheKey = null;
        if (!this.background.getOutsets().equals(old.getOutsets())) {
            this.geometryChanged();
        } else {
            this.visualsChanged();
        }
    }

    public void updateFillCorners(List<CornerRadii> normalizedFillCorners) {
        this.normalizedFillCorners = normalizedFillCorners;
    }

    private CornerRadii getNormalizedFillRadii(int index) {
        return this.normalizedFillCorners == null ? this.background.getFills().get(index).getRadii() : this.normalizedFillCorners.get(index);
    }

    public void setOpaqueInsets(float top, float right, float bottom, float left) {
        this.opaqueTop = top;
        this.opaqueRight = right;
        this.opaqueBottom = bottom;
        this.opaqueLeft = left;
        this.invalidateOpaqueRegion();
    }

    @Override
    public void clearDirtyTree() {
        super.clearDirtyTree();
        if (this.ngShape != null) {
            this.ngShape.clearDirtyTree();
        }
    }

    private RegionImageCache getImageCache(Graphics g) {
        RTTexture tex;
        Screen screen = g.getAssociatedScreen();
        RegionImageCache cache = imageCacheMap.get(screen);
        if (cache != null && (tex = cache.getBackingStore()).isSurfaceLost()) {
            imageCacheMap.remove(screen);
            cache = null;
        }
        if (cache == null) {
            cache = new RegionImageCache(g.getResourceFactory());
            imageCacheMap.put(screen, cache);
        }
        return cache;
    }

    private Integer getCacheKey(int w, int h) {
        if (this.cacheKey == null) {
            int key = 31 * w;
            key = key * 37 + h;
            key = key * 47 + this.background.hashCode();
            if (this.shape != null) {
                key = key * 73 + this.shape.hashCode();
            }
            this.cacheKey = key;
        }
        return this.cacheKey;
    }

    @Override
    protected boolean supportsOpaqueRegions() {
        return true;
    }

    @Override
    protected boolean hasOpaqueRegion() {
        return super.hasOpaqueRegion() && !Float.isNaN(this.opaqueTop) && !Float.isNaN(this.opaqueRight) && !Float.isNaN(this.opaqueBottom) && !Float.isNaN(this.opaqueLeft);
    }

    @Override
    protected RectBounds computeOpaqueRegion(RectBounds opaqueRegion) {
        return (RectBounds)opaqueRegion.deriveWithNewBounds(this.opaqueLeft, this.opaqueTop, 0.0f, this.width - this.opaqueRight, this.height - this.opaqueBottom, 0.0f);
    }

    @Override
    protected NGNode.RenderRootResult computeRenderRoot(NodePath path, RectBounds dirtyRegion, int cullingIndex, BaseTransform tx, GeneralTransform3D pvTx) {
        NGNode.RenderRootResult result = super.computeRenderRoot(path, dirtyRegion, cullingIndex, tx, pvTx);
        if (result == NGNode.RenderRootResult.NO_RENDER_ROOT) {
            result = this.computeNodeRenderRoot(path, dirtyRegion, cullingIndex, tx, pvTx);
        }
        return result;
    }

    @Override
    protected boolean hasVisuals() {
        return !this.border.isEmpty() || !this.background.isEmpty();
    }

    @Override
    protected boolean hasOverlappingContents() {
        return true;
    }

    @Override
    protected void renderContent(Graphics g) {
        if (!g.getTransformNoClone().is2D() && this.isContentBounds2D()) {
            assert (this.getEffectFilter() == null);
            if (this.nopEffectFilter == null) {
                this.nopEffectFilter = new EffectFilter(nopEffect, this);
            }
            this.nopEffectFilter.render(g);
            return;
        }
        if (this.shape != null) {
            this.renderAsShape(g);
        } else if (this.width > 0.0f && this.height > 0.0f) {
            this.renderAsRectangle(g);
        }
        super.renderContent(g);
    }

    private void renderAsShape(Graphics g) {
        if (!this.background.isEmpty()) {
            RegionImageCache imageCache;
            Insets outsets = this.background.getOutsets();
            Shape outsetShape = this.resizeShape((float)(-outsets.getTop()), (float)(-outsets.getRight()), (float)(-outsets.getBottom()), (float)(-outsets.getLeft()));
            RectBounds outsetShapeBounds = outsetShape.getBounds();
            int textureWidth = Math.round(outsetShapeBounds.getWidth());
            int textureHeight = Math.round(outsetShapeBounds.getHeight());
            boolean border = true;
            RTTexture cached = null;
            Rectangle rect = null;
            if (this.cacheMode != 0 && g.getTransformNoClone().isTranslateOrIdentity() && (imageCache = this.getImageCache(g)).isImageCachable(textureWidth, textureHeight)) {
                Integer key = this.getCacheKey(textureWidth, textureHeight);
                rect = TEMP_RECT;
                rect.setBounds(0, 0, textureWidth + 1, textureHeight + 1);
                boolean render = imageCache.getImageLocation(key, rect, this.background, this.shape, g);
                if (!rect.isEmpty()) {
                    cached = imageCache.getBackingStore();
                }
                if (cached != null && render) {
                    Graphics cachedGraphics = cached.createGraphics();
                    cachedGraphics.translate((float)rect.x - outsetShapeBounds.getMinX(), (float)rect.y - outsetShapeBounds.getMinY());
                    this.renderBackgroundShape(cachedGraphics);
                    if (PulseLogger.PULSE_LOGGING_ENABLED) {
                        PulseLogger.incrementCounter("Rendering region shape image to cache");
                    }
                }
            }
            if (cached != null) {
                float dstX1 = outsetShapeBounds.getMinX();
                float dstY1 = outsetShapeBounds.getMinY();
                float dstX2 = outsetShapeBounds.getMaxX();
                float dstY2 = outsetShapeBounds.getMaxY();
                float srcX1 = rect.x;
                float srcY1 = rect.y;
                float srcX2 = srcX1 + (float)textureWidth;
                float srcY2 = srcY1 + (float)textureHeight;
                g.drawTexture(cached, dstX1, dstY1, dstX2, dstY2, srcX1, srcY1, srcX2, srcY2);
                if (PulseLogger.PULSE_LOGGING_ENABLED) {
                    PulseLogger.incrementCounter("Cached region shape image used");
                }
            } else {
                this.renderBackgroundShape(g);
            }
        }
        if (!this.border.isEmpty()) {
            List<BorderStroke> strokes = this.border.getStrokes();
            int max = strokes.size();
            for (int i = 0; i < max; ++i) {
                BorderStroke stroke = strokes.get(i);
                this.setBorderStyle(g, stroke, -1.0, false);
                Insets insets = stroke.getInsets();
                g.draw(this.resizeShape((float)insets.getTop(), (float)insets.getRight(), (float)insets.getBottom(), (float)insets.getLeft()));
            }
        }
    }

    private void renderBackgroundShape(Graphics g) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.incrementCounter("NGRegion renderBackgroundShape slow path");
            PulseLogger.addMessage("Slow shape path for " + this.getName());
        }
        List<BackgroundFill> fills = this.background.getFills();
        int max = fills.size();
        for (int i = 0; i < max; ++i) {
            BackgroundFill fill = fills.get(i);
            Paint paint = NGRegion.getPlatformPaint(fill.getFill());
            assert (paint != null);
            g.setPaint(paint);
            Insets insets = fill.getInsets();
            g.fill(this.resizeShape((float)insets.getTop(), (float)insets.getRight(), (float)insets.getBottom(), (float)insets.getLeft()));
        }
        List<BackgroundImage> images = this.background.getImages();
        int max2 = images.size();
        for (int i = 0; i < max2; ++i) {
            BackgroundImage image = images.get(i);
            Image prismImage = (Image)image.getImage().impl_getPlatformImage();
            if (prismImage == null) continue;
            Shape translatedShape = this.resizeShape(0.0f, 0.0f, 0.0f, 0.0f);
            RectBounds bounds = translatedShape.getBounds();
            com.sun.prism.paint.ImagePattern pattern = image.getSize().isCover() ? new com.sun.prism.paint.ImagePattern(prismImage, bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight(), false, false) : new com.sun.prism.paint.ImagePattern(prismImage, bounds.getMinX(), bounds.getMinY(), prismImage.getWidth(), prismImage.getHeight(), false, false);
            g.setPaint(pattern);
            g.fill(translatedShape);
        }
    }

    private void renderAsRectangle(Graphics g) {
        if (!this.background.isEmpty()) {
            this.renderBackgroundRectangle(g);
        }
        if (!this.border.isEmpty()) {
            this.renderBorderRectangle(g);
        }
    }

    private void renderBackgroundRectangle(Graphics g) {
        RegionImageCache imageCache;
        if (this.backgroundInsets == null) {
            this.updateBackgroundInsets();
        }
        double leftInset = this.backgroundInsets.getLeft() + 1.0;
        double rightInset = this.backgroundInsets.getRight() + 1.0;
        double topInset = this.backgroundInsets.getTop() + 1.0;
        double bottomInset = this.backgroundInsets.getBottom() + 1.0;
        int cacheWidth = this.roundUp(this.width);
        if ((this.cacheMode & 2) != 0) {
            cacheWidth = Math.min(cacheWidth, (int)(leftInset + rightInset));
        }
        int cacheHeight = this.roundUp(this.height);
        if ((this.cacheMode & 1) != 0) {
            cacheHeight = Math.min(cacheHeight, (int)(topInset + bottomInset));
        }
        Insets outsets = this.background.getOutsets();
        int outsetsTop = this.roundUp(outsets.getTop());
        int outsetsRight = this.roundUp(outsets.getRight());
        int outsetsBottom = this.roundUp(outsets.getBottom());
        int outsetsLeft = this.roundUp(outsets.getLeft());
        int textureWidth = outsetsLeft + cacheWidth + outsetsRight;
        int textureHeight = outsetsTop + cacheHeight + outsetsBottom;
        boolean cache = this.background.getFills().size() > 1 && this.cacheMode != 0 && g.getTransformNoClone().isTranslateOrIdentity();
        boolean border = true;
        RTTexture cached = null;
        Rectangle rect = null;
        if (cache && (imageCache = this.getImageCache(g)).isImageCachable(textureWidth, textureHeight)) {
            Integer key = this.getCacheKey(textureWidth, textureHeight);
            rect = TEMP_RECT;
            rect.setBounds(0, 0, textureWidth + 1, textureHeight + 1);
            boolean render = imageCache.getImageLocation(key, rect, this.background, this.shape, g);
            if (!rect.isEmpty()) {
                cached = imageCache.getBackingStore();
            }
            if (cached != null && render) {
                Graphics cacheGraphics = cached.createGraphics();
                cacheGraphics.translate(rect.x + outsetsLeft, rect.y + outsetsTop);
                this.renderBackgroundRectanglesDirectly(cacheGraphics, cacheWidth, cacheHeight);
                if (PulseLogger.PULSE_LOGGING_ENABLED) {
                    PulseLogger.incrementCounter("Rendering region background image to cache");
                }
            }
        }
        if (cached != null) {
            this.renderBackgroundRectangleFromCache(g, cached, rect, textureWidth, textureHeight, topInset, rightInset, bottomInset, leftInset, outsetsTop, outsetsRight, outsetsBottom, outsetsLeft);
        } else {
            this.renderBackgroundRectanglesDirectly(g, this.width, this.height);
        }
        List<BackgroundImage> images = this.background.getImages();
        int max = images.size();
        for (int i = 0; i < max; ++i) {
            double tileY;
            double tileX;
            double position;
            double tileHeight;
            double tileWidth;
            double h;
            BackgroundImage image = images.get(i);
            Image prismImage = (Image)image.getImage().impl_getPlatformImage();
            if (prismImage == null) continue;
            int imgUnscaledWidth = (int)image.getImage().getWidth();
            int imgUnscaledHeight = (int)image.getImage().getHeight();
            int imgWidth = prismImage.getWidth();
            int imgHeight = prismImage.getHeight();
            if (imgWidth == 0 || imgHeight == 0) continue;
            BackgroundSize size = image.getSize();
            if (size.isCover()) {
                float scale = Math.max(this.width / (float)imgWidth, this.height / (float)imgHeight);
                Texture texture = g.getResourceFactory().getCachedTexture(prismImage, Texture.WrapMode.CLAMP_TO_EDGE);
                g.drawTexture(texture, 0.0f, 0.0f, this.width, this.height, 0.0f, 0.0f, this.width / scale, this.height / scale);
                texture.unlock();
                continue;
            }
            double w = size.isWidthAsPercentage() ? size.getWidth() * (double)this.width : size.getWidth();
            double d = h = size.isHeightAsPercentage() ? size.getHeight() * (double)this.height : size.getHeight();
            if (size.isContain()) {
                float scaleX = this.width / (float)imgUnscaledWidth;
                float scaleY = this.height / (float)imgUnscaledHeight;
                float scale = Math.min(scaleX, scaleY);
                tileWidth = Math.ceil(scale * (float)imgUnscaledWidth);
                tileHeight = Math.ceil(scale * (float)imgUnscaledHeight);
            } else if (size.getWidth() >= 0.0 && size.getHeight() >= 0.0) {
                tileWidth = w;
                tileHeight = h;
            } else if (w >= 0.0) {
                tileWidth = w;
                double scale = tileWidth / (double)imgUnscaledWidth;
                tileHeight = (double)imgUnscaledHeight * scale;
            } else if (h >= 0.0) {
                tileHeight = h;
                double scale = tileHeight / (double)imgUnscaledHeight;
                tileWidth = (double)imgUnscaledWidth * scale;
            } else {
                tileWidth = imgUnscaledWidth;
                tileHeight = imgUnscaledHeight;
            }
            BackgroundPosition pos = image.getPosition();
            if (pos.getHorizontalSide() == Side.LEFT) {
                position = pos.getHorizontalPosition();
                tileX = pos.isHorizontalAsPercentage() ? position * (double)this.width - position * tileWidth : position;
            } else if (pos.isHorizontalAsPercentage()) {
                position = 1.0 - pos.getHorizontalPosition();
                tileX = position * (double)this.width - position * tileWidth;
            } else {
                tileX = (double)this.width - tileWidth - pos.getHorizontalPosition();
            }
            if (pos.getVerticalSide() == Side.TOP) {
                position = pos.getVerticalPosition();
                tileY = pos.isVerticalAsPercentage() ? position * (double)this.height - position * tileHeight : position;
            } else if (pos.isVerticalAsPercentage()) {
                position = 1.0 - pos.getVerticalPosition();
                tileY = position * (double)this.height - position * tileHeight;
            } else {
                tileY = (double)this.height - tileHeight - pos.getVerticalPosition();
            }
            this.paintTiles(g, prismImage, image.getRepeatX(), image.getRepeatY(), pos.getHorizontalSide(), pos.getVerticalSide(), 0.0f, 0.0f, this.width, this.height, 0, 0, imgWidth, imgHeight, (float)tileX, (float)tileY, (float)tileWidth, (float)tileHeight);
        }
    }

    private void renderBackgroundRectangleFromCache(Graphics g, RTTexture cached, Rectangle rect, int textureWidth, int textureHeight, double topInset, double rightInset, double bottomInset, double leftInset, int outsetsTop, int outsetsRight, int outsetsBottom, int outsetsLeft) {
        double fraction;
        float pad = 0.49609375f;
        float dstWidth = (float)outsetsLeft + this.width + (float)outsetsRight;
        float dstHeight = (float)outsetsTop + this.height + (float)outsetsBottom;
        boolean sameWidth = (float)textureWidth == dstWidth;
        boolean sameHeight = (float)textureHeight == dstHeight;
        float dstX1 = (float)(-outsetsLeft) - 0.49609375f;
        float dstY1 = (float)(-outsetsTop) - 0.49609375f;
        float dstX2 = this.width + (float)outsetsRight + 0.49609375f;
        float dstY2 = this.height + (float)outsetsBottom + 0.49609375f;
        float srcX1 = (float)rect.x - 0.49609375f;
        float srcY1 = (float)rect.y - 0.49609375f;
        float srcX2 = (float)(rect.x + textureWidth) + 0.49609375f;
        float srcY2 = (float)(rect.y + textureHeight) + 0.49609375f;
        double adjustedLeftInset = leftInset;
        double adjustedRightInset = rightInset;
        double adjustedTopInset = topInset;
        double adjustedBottomInset = bottomInset;
        if (leftInset + rightInset > (double)this.width) {
            fraction = (double)this.width / (leftInset + rightInset);
            adjustedLeftInset *= fraction;
            adjustedRightInset *= fraction;
        }
        if (topInset + bottomInset > (double)this.height) {
            fraction = (double)this.height / (topInset + bottomInset);
            adjustedTopInset *= fraction;
            adjustedBottomInset *= fraction;
        }
        if (sameWidth && sameHeight) {
            g.drawTexture(cached, dstX1, dstY1, dstX2, dstY2, srcX1, srcY1, srcX2, srcY2);
        } else if (sameHeight) {
            float left = 0.49609375f + (float)(adjustedLeftInset + (double)outsetsLeft);
            float right = 0.49609375f + (float)(adjustedRightInset + (double)outsetsRight);
            float dstLeftX = dstX1 + left;
            float dstRightX = dstX2 - right;
            float srcLeftX = srcX1 + left;
            float srcRightX = srcX2 - right;
            g.drawTexture3SliceH(cached, dstX1, dstY1, dstX2, dstY2, srcX1, srcY1, srcX2, srcY2, dstLeftX, dstRightX, srcLeftX, srcRightX);
        } else if (sameWidth) {
            float top = 0.49609375f + (float)(adjustedTopInset + (double)outsetsTop);
            float bottom = 0.49609375f + (float)(adjustedBottomInset + (double)outsetsBottom);
            float dstTopY = dstY1 + top;
            float dstBottomY = dstY2 - bottom;
            float srcTopY = srcY1 + top;
            float srcBottomY = srcY2 - bottom;
            g.drawTexture3SliceV(cached, dstX1, dstY1, dstX2, dstY2, srcX1, srcY1, srcX2, srcY2, dstTopY, dstBottomY, srcTopY, srcBottomY);
        } else {
            float left = 0.49609375f + (float)(adjustedLeftInset + (double)outsetsLeft);
            float top = 0.49609375f + (float)(adjustedTopInset + (double)outsetsTop);
            float right = 0.49609375f + (float)(adjustedRightInset + (double)outsetsRight);
            float bottom = 0.49609375f + (float)(adjustedBottomInset + (double)outsetsBottom);
            float dstLeftX = dstX1 + left;
            float dstRightX = dstX2 - right;
            float srcLeftX = srcX1 + left;
            float srcRightX = srcX2 - right;
            float dstTopY = dstY1 + top;
            float dstBottomY = dstY2 - bottom;
            float srcTopY = srcY1 + top;
            float srcBottomY = srcY2 - bottom;
            g.drawTexture9Slice(cached, dstX1, dstY1, dstX2, dstY2, srcX1, srcY1, srcX2, srcY2, dstLeftX, dstTopY, dstRightX, dstBottomY, srcLeftX, srcTopY, srcRightX, srcBottomY);
        }
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.incrementCounter("Cached region background image used");
        }
    }

    private void renderBackgroundRectanglesDirectly(Graphics g, float width, float height) {
        List<BackgroundFill> fills = this.background.getFills();
        int max = fills.size();
        for (int i = 0; i < max; ++i) {
            BackgroundFill fill = fills.get(i);
            Insets insets = fill.getInsets();
            float t = (float)insets.getTop();
            float l = (float)insets.getLeft();
            float b = (float)insets.getBottom();
            float r = (float)insets.getRight();
            float w = width - l - r;
            float h = height - t - b;
            if (!(w > 0.0f) || !(h > 0.0f)) continue;
            Paint paint = NGRegion.getPlatformPaint(fill.getFill());
            g.setPaint(paint);
            CornerRadii radii = this.getNormalizedFillRadii(i);
            if (radii.isUniform() && (PlatformImpl.isCaspian() || PlatformUtil.isEmbedded() || PlatformUtil.isIOS() || !(radii.getTopLeftHorizontalRadius() > 0.0) || !(radii.getTopLeftHorizontalRadius() <= 4.0))) {
                float tlhr = (float)radii.getTopLeftHorizontalRadius();
                float tlvr = (float)radii.getTopLeftVerticalRadius();
                if (tlhr == 0.0f && tlvr == 0.0f) {
                    g.fillRect(l, t, w, h);
                    continue;
                }
                float arcWidth = tlhr + tlhr;
                float arcHeight = tlvr + tlvr;
                if (arcWidth > w) {
                    arcWidth = w;
                }
                if (arcHeight > h) {
                    arcHeight = h;
                }
                g.fillRoundRect(l, t, w, h, arcWidth, arcHeight);
                continue;
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.incrementCounter("NGRegion renderBackgrounds slow path");
                PulseLogger.addMessage("Slow background path for " + this.getName());
            }
            g.fill(this.createPath(width, height, t, l, b, r, radii));
        }
    }

    private void renderBorderRectangle(Graphics g) {
        int i;
        List<BorderImage> images = this.border.getImages();
        List strokes = images.isEmpty() ? this.border.getStrokes() : Collections.emptyList();
        int max = strokes.size();
        for (i = 0; i < max; ++i) {
            BorderStroke stroke = (BorderStroke)strokes.get(i);
            BorderWidths widths = stroke.getWidths();
            CornerRadii radii = this.getNormalizedStrokeRadii(i);
            Insets insets = stroke.getInsets();
            javafx.scene.paint.Paint topStroke = stroke.getTopStroke();
            javafx.scene.paint.Paint rightStroke = stroke.getRightStroke();
            javafx.scene.paint.Paint bottomStroke = stroke.getBottomStroke();
            javafx.scene.paint.Paint leftStroke = stroke.getLeftStroke();
            float topInset = (float)insets.getTop();
            float rightInset = (float)insets.getRight();
            float bottomInset = (float)insets.getBottom();
            float leftInset = (float)insets.getLeft();
            float topWidth = (float)(widths.isTopAsPercentage() ? (double)this.height * widths.getTop() : widths.getTop());
            float rightWidth = (float)(widths.isRightAsPercentage() ? (double)this.width * widths.getRight() : widths.getRight());
            float bottomWidth = (float)(widths.isBottomAsPercentage() ? (double)this.height * widths.getBottom() : widths.getBottom());
            float leftWidth = (float)(widths.isLeftAsPercentage() ? (double)this.width * widths.getLeft() : widths.getLeft());
            BorderStrokeStyle topStyle = stroke.getTopStyle();
            BorderStrokeStyle rightStyle = stroke.getRightStyle();
            BorderStrokeStyle bottomStyle = stroke.getBottomStyle();
            BorderStrokeStyle leftStyle = stroke.getLeftStyle();
            StrokeType topType = topStyle.getType();
            StrokeType rightType = rightStyle.getType();
            StrokeType bottomType = bottomStyle.getType();
            StrokeType leftType = leftStyle.getType();
            float t = topInset + (topType == StrokeType.OUTSIDE ? -topWidth / 2.0f : (topType == StrokeType.INSIDE ? topWidth / 2.0f : 0.0f));
            float l = leftInset + (leftType == StrokeType.OUTSIDE ? -leftWidth / 2.0f : (leftType == StrokeType.INSIDE ? leftWidth / 2.0f : 0.0f));
            float b = bottomInset + (bottomType == StrokeType.OUTSIDE ? -bottomWidth / 2.0f : (bottomType == StrokeType.INSIDE ? bottomWidth / 2.0f : 0.0f));
            float r = rightInset + (rightType == StrokeType.OUTSIDE ? -rightWidth / 2.0f : (rightType == StrokeType.INSIDE ? rightWidth / 2.0f : 0.0f));
            float radius = (float)radii.getTopLeftHorizontalRadius();
            if (stroke.isStrokeUniform()) {
                if (topStroke instanceof Color && ((Color)topStroke).getOpacity() == 0.0 || topStyle == BorderStrokeStyle.NONE) continue;
                float w = this.width - l - r;
                float h = this.height - t - b;
                double di = 2.0 * radii.getTopLeftHorizontalRadius();
                double circle = di * Math.PI;
                double totalLineLength = circle + 2.0 * ((double)w - di) + 2.0 * ((double)h - di);
                if (!(w >= 0.0f) || !(h >= 0.0f)) continue;
                this.setBorderStyle(g, stroke, totalLineLength, true);
                if (radii.isUniform() && radius == 0.0f) {
                    g.drawRect(l, t, w, h);
                    continue;
                }
                if (radii.isUniform()) {
                    float ar = radius + radius;
                    if (ar > w) {
                        ar = w;
                    }
                    if (ar > h) {
                        ar = h;
                    }
                    g.drawRoundRect(l, t, w, h, ar, ar);
                    continue;
                }
                g.draw(this.createPath(this.width, this.height, t, l, b, r, radii));
                continue;
            }
            if (radii.isUniform() && radius == 0.0f) {
                if (!(topStroke instanceof Color && ((Color)topStroke).getOpacity() == 0.0 || topStyle == BorderStrokeStyle.NONE)) {
                    g.setPaint(NGRegion.getPlatformPaint(topStroke));
                    if (BorderStrokeStyle.SOLID == topStyle) {
                        g.fillRect(leftInset, topInset, this.width - leftInset - rightInset, topWidth);
                    } else {
                        g.setStroke(this.createStroke(topStyle, topWidth, this.width, true));
                        g.drawLine(l, t, this.width - r, t);
                    }
                }
                if (!(rightStroke instanceof Color && ((Color)rightStroke).getOpacity() == 0.0 || rightStyle == BorderStrokeStyle.NONE)) {
                    g.setPaint(NGRegion.getPlatformPaint(rightStroke));
                    if (BorderStrokeStyle.SOLID == rightStyle) {
                        g.fillRect(this.width - rightInset - rightWidth, topInset, rightWidth, this.height - topInset - bottomInset);
                    } else {
                        g.setStroke(this.createStroke(rightStyle, rightWidth, this.height, true));
                        g.drawLine(this.width - r, t, this.width - r, this.height - b);
                    }
                }
                if (!(bottomStroke instanceof Color && ((Color)bottomStroke).getOpacity() == 0.0 || bottomStyle == BorderStrokeStyle.NONE)) {
                    g.setPaint(NGRegion.getPlatformPaint(bottomStroke));
                    if (BorderStrokeStyle.SOLID == bottomStyle) {
                        g.fillRect(leftInset, this.height - bottomInset - bottomWidth, this.width - leftInset - rightInset, bottomWidth);
                    } else {
                        g.setStroke(this.createStroke(bottomStyle, bottomWidth, this.width, true));
                        g.drawLine(l, this.height - b, this.width - r, this.height - b);
                    }
                }
                if (leftStroke instanceof Color && ((Color)leftStroke).getOpacity() == 0.0 || leftStyle == BorderStrokeStyle.NONE) continue;
                g.setPaint(NGRegion.getPlatformPaint(leftStroke));
                if (BorderStrokeStyle.SOLID == leftStyle) {
                    g.fillRect(leftInset, topInset, leftWidth, this.height - topInset - bottomInset);
                    continue;
                }
                g.setStroke(this.createStroke(leftStyle, leftWidth, this.height, true));
                g.drawLine(l, t, l, this.height - b);
                continue;
            }
            Path2D[] paths = this.createPaths(t, l, b, r, radii);
            if (topStyle != BorderStrokeStyle.NONE) {
                double rsum = radii.getTopLeftHorizontalRadius() + radii.getTopRightHorizontalRadius();
                double topLineLength = (double)this.width + rsum * -0.21460183660255172;
                g.setStroke(this.createStroke(topStyle, topWidth, topLineLength, true));
                g.setPaint(NGRegion.getPlatformPaint(topStroke));
                g.draw(paths[0]);
            }
            if (rightStyle != BorderStrokeStyle.NONE) {
                double rsum = radii.getTopRightVerticalRadius() + radii.getBottomRightVerticalRadius();
                double rightLineLength = (double)this.height + rsum * -0.21460183660255172;
                g.setStroke(this.createStroke(rightStyle, rightWidth, rightLineLength, true));
                g.setPaint(NGRegion.getPlatformPaint(rightStroke));
                g.draw(paths[1]);
            }
            if (bottomStyle != BorderStrokeStyle.NONE) {
                double rsum = radii.getBottomLeftHorizontalRadius() + radii.getBottomRightHorizontalRadius();
                double bottomLineLength = (double)this.width + rsum * -0.21460183660255172;
                g.setStroke(this.createStroke(bottomStyle, bottomWidth, bottomLineLength, true));
                g.setPaint(NGRegion.getPlatformPaint(bottomStroke));
                g.draw(paths[2]);
            }
            if (leftStyle == BorderStrokeStyle.NONE) continue;
            double rsum = radii.getTopLeftVerticalRadius() + radii.getBottomLeftVerticalRadius();
            double leftLineLength = (double)this.height + rsum * -0.21460183660255172;
            g.setStroke(this.createStroke(leftStyle, leftWidth, leftLineLength, true));
            g.setPaint(NGRegion.getPlatformPaint(leftStroke));
            g.draw(paths[3]);
        }
        max = images.size();
        for (i = 0; i < max; ++i) {
            BorderImage ib = images.get(i);
            Image prismImage = (Image)ib.getImage().impl_getPlatformImage();
            if (prismImage == null) continue;
            int imgWidth = prismImage.getWidth();
            int imgHeight = prismImage.getHeight();
            float imgScale = prismImage.getPixelScale();
            BorderWidths widths = ib.getWidths();
            Insets insets = ib.getInsets();
            BorderWidths slices = ib.getSlices();
            int topInset = (int)Math.round(insets.getTop());
            int rightInset = (int)Math.round(insets.getRight());
            int bottomInset = (int)Math.round(insets.getBottom());
            int leftInset = (int)Math.round(insets.getLeft());
            int topWidth = this.widthSize(widths.isTopAsPercentage(), widths.getTop(), this.height);
            int rightWidth = this.widthSize(widths.isRightAsPercentage(), widths.getRight(), this.width);
            int bottomWidth = this.widthSize(widths.isBottomAsPercentage(), widths.getBottom(), this.height);
            int leftWidth = this.widthSize(widths.isLeftAsPercentage(), widths.getLeft(), this.width);
            int topSlice = this.sliceSize(slices.isTopAsPercentage(), slices.getTop(), imgHeight, imgScale);
            int rightSlice = this.sliceSize(slices.isRightAsPercentage(), slices.getRight(), imgWidth, imgScale);
            int bottomSlice = this.sliceSize(slices.isBottomAsPercentage(), slices.getBottom(), imgHeight, imgScale);
            int leftSlice = this.sliceSize(slices.isLeftAsPercentage(), slices.getLeft(), imgWidth, imgScale);
            if ((float)(leftInset + leftWidth + rightInset + rightWidth) > this.width || (float)(topInset + topWidth + bottomInset + bottomWidth) > this.height) continue;
            int centerMinX = leftInset + leftWidth;
            int centerMinY = topInset + topWidth;
            int centerW = Math.round(this.width) - rightInset - rightWidth - centerMinX;
            int centerH = Math.round(this.height) - bottomInset - bottomWidth - centerMinY;
            int centerMaxX = centerW + centerMinX;
            int centerMaxY = centerH + centerMinY;
            int centerSliceWidth = imgWidth - leftSlice - rightSlice;
            int centerSliceHeight = imgHeight - topSlice - bottomSlice;
            this.paintTiles(g, prismImage, BorderRepeat.STRETCH, BorderRepeat.STRETCH, Side.LEFT, Side.TOP, (float)leftInset, (float)topInset, (float)leftWidth, (float)topWidth, 0, 0, leftSlice, topSlice, 0.0f, 0.0f, (float)leftWidth, (float)topWidth);
            float tileWidth = ib.getRepeatX() == BorderRepeat.STRETCH ? (float)centerW : (float)(topSlice > 0 ? centerSliceWidth * topWidth / topSlice : 0);
            float tileHeight = topWidth;
            this.paintTiles(g, prismImage, ib.getRepeatX(), BorderRepeat.STRETCH, Side.LEFT, Side.TOP, (float)centerMinX, (float)topInset, (float)centerW, (float)topWidth, leftSlice, 0, centerSliceWidth, topSlice, ((float)centerW - tileWidth) / 2.0f, 0.0f, tileWidth, tileHeight);
            this.paintTiles(g, prismImage, BorderRepeat.STRETCH, BorderRepeat.STRETCH, Side.LEFT, Side.TOP, (float)centerMaxX, (float)topInset, (float)rightWidth, (float)topWidth, imgWidth - rightSlice, 0, rightSlice, topSlice, 0.0f, 0.0f, (float)rightWidth, (float)topWidth);
            tileWidth = leftWidth;
            tileHeight = ib.getRepeatY() == BorderRepeat.STRETCH ? (float)centerH : (float)(leftSlice > 0 ? leftWidth * centerSliceHeight / leftSlice : 0);
            this.paintTiles(g, prismImage, BorderRepeat.STRETCH, ib.getRepeatY(), Side.LEFT, Side.TOP, (float)leftInset, (float)centerMinY, (float)leftWidth, (float)centerH, 0, topSlice, leftSlice, centerSliceHeight, 0.0f, ((float)centerH - tileHeight) / 2.0f, tileWidth, tileHeight);
            tileWidth = rightWidth;
            tileHeight = ib.getRepeatY() == BorderRepeat.STRETCH ? (float)centerH : (float)(rightSlice > 0 ? rightWidth * centerSliceHeight / rightSlice : 0);
            this.paintTiles(g, prismImage, BorderRepeat.STRETCH, ib.getRepeatY(), Side.LEFT, Side.TOP, (float)centerMaxX, (float)centerMinY, (float)rightWidth, (float)centerH, imgWidth - rightSlice, topSlice, rightSlice, centerSliceHeight, 0.0f, ((float)centerH - tileHeight) / 2.0f, tileWidth, tileHeight);
            this.paintTiles(g, prismImage, BorderRepeat.STRETCH, BorderRepeat.STRETCH, Side.LEFT, Side.TOP, (float)leftInset, (float)centerMaxY, (float)leftWidth, (float)bottomWidth, 0, imgHeight - bottomSlice, leftSlice, bottomSlice, 0.0f, 0.0f, (float)leftWidth, (float)bottomWidth);
            tileWidth = ib.getRepeatX() == BorderRepeat.STRETCH ? (float)centerW : (float)(bottomSlice > 0 ? centerSliceWidth * bottomWidth / bottomSlice : 0);
            tileHeight = bottomWidth;
            this.paintTiles(g, prismImage, ib.getRepeatX(), BorderRepeat.STRETCH, Side.LEFT, Side.TOP, (float)centerMinX, (float)centerMaxY, (float)centerW, (float)bottomWidth, leftSlice, imgHeight - bottomSlice, centerSliceWidth, bottomSlice, ((float)centerW - tileWidth) / 2.0f, 0.0f, tileWidth, tileHeight);
            this.paintTiles(g, prismImage, BorderRepeat.STRETCH, BorderRepeat.STRETCH, Side.LEFT, Side.TOP, (float)centerMaxX, (float)centerMaxY, (float)rightWidth, (float)bottomWidth, imgWidth - rightSlice, imgHeight - bottomSlice, rightSlice, bottomSlice, 0.0f, 0.0f, (float)rightWidth, (float)bottomWidth);
            if (!ib.isFilled()) continue;
            float imgW = ib.getRepeatX() == BorderRepeat.STRETCH ? (float)centerW : (float)centerSliceWidth;
            float imgH = ib.getRepeatY() == BorderRepeat.STRETCH ? (float)centerH : (float)centerSliceHeight;
            this.paintTiles(g, prismImage, ib.getRepeatX(), ib.getRepeatY(), Side.LEFT, Side.TOP, (float)centerMinX, (float)centerMinY, (float)centerW, (float)centerH, leftSlice, topSlice, centerSliceWidth, centerSliceHeight, 0.0f, 0.0f, imgW, imgH);
        }
    }

    private void updateBackgroundInsets() {
        float top = 0.0f;
        float right = 0.0f;
        float bottom = 0.0f;
        float left = 0.0f;
        List<BackgroundFill> fills = this.background.getFills();
        int max = fills.size();
        for (int i = 0; i < max; ++i) {
            BackgroundFill fill = fills.get(i);
            Insets insets = fill.getInsets();
            CornerRadii radii = this.getNormalizedFillRadii(i);
            top = (float)Math.max((double)top, insets.getTop() + Math.max(radii.getTopLeftVerticalRadius(), radii.getTopRightVerticalRadius()));
            right = (float)Math.max((double)right, insets.getRight() + Math.max(radii.getTopRightHorizontalRadius(), radii.getBottomRightHorizontalRadius()));
            bottom = (float)Math.max((double)bottom, insets.getBottom() + Math.max(radii.getBottomRightVerticalRadius(), radii.getBottomLeftVerticalRadius()));
            left = (float)Math.max((double)left, insets.getLeft() + Math.max(radii.getTopLeftHorizontalRadius(), radii.getBottomLeftHorizontalRadius()));
        }
        this.backgroundInsets = new Insets(this.roundUp(top), this.roundUp(right), this.roundUp(bottom), this.roundUp(left));
    }

    private int widthSize(boolean isPercent, double sliceSize, float objSize) {
        return (int)Math.round(isPercent ? sliceSize * (double)objSize : sliceSize);
    }

    private int sliceSize(boolean isPercent, double sliceSize, float objSize, float scale) {
        if (isPercent) {
            sliceSize *= (double)objSize;
        }
        if (sliceSize > (double)objSize) {
            sliceSize = objSize;
        }
        return (int)Math.round(sliceSize * (double)scale);
    }

    private int roundUp(double d) {
        return d - (double)((int)d) == 0.0 ? (int)d : (int)(d + 1.0);
    }

    private BasicStroke createStroke(BorderStrokeStyle sb, double strokeWidth, double lineLength, boolean forceCentered) {
        BasicStroke bs;
        int type;
        int cap = sb.getLineCap() == StrokeLineCap.BUTT ? 0 : (sb.getLineCap() == StrokeLineCap.SQUARE ? 2 : 1);
        int join = sb.getLineJoin() == StrokeLineJoin.BEVEL ? 2 : (sb.getLineJoin() == StrokeLineJoin.MITER ? 0 : 1);
        if (forceCentered) {
            type = 0;
        } else if (this.scaleShape) {
            type = 1;
        } else {
            switch (sb.getType()) {
                case INSIDE: {
                    type = 1;
                    break;
                }
                case OUTSIDE: {
                    type = 2;
                    break;
                }
                default: {
                    type = 0;
                }
            }
        }
        if (sb == BorderStrokeStyle.NONE) {
            throw new AssertionError((Object)"Should never have been asked to draw a border with NONE");
        }
        if (strokeWidth <= 0.0) {
            bs = new BasicStroke((float)strokeWidth, cap, join, (float)sb.getMiterLimit());
        } else if (sb.getDashArray().size() > 0) {
            float dashOffset;
            double[] array;
            List<Double> dashArray = sb.getDashArray();
            if (dashArray == BorderStrokeStyle.DOTTED.getDashArray()) {
                if (lineLength > 0.0) {
                    double remainder = lineLength % (strokeWidth * 2.0);
                    double numSpaces = lineLength / (strokeWidth * 2.0);
                    double spaceWidth = strokeWidth * 2.0 + remainder / numSpaces;
                    array = new double[]{0.0, spaceWidth};
                    dashOffset = 0.0f;
                } else {
                    array = new double[]{0.0, strokeWidth * 2.0};
                    dashOffset = 0.0f;
                }
            } else if (dashArray == BorderStrokeStyle.DASHED.getDashArray()) {
                if (lineLength > 0.0) {
                    double dashLength = strokeWidth * 2.0;
                    double gapLength = strokeWidth * 1.4;
                    double segmentLength = dashLength + gapLength;
                    double divided = lineLength / segmentLength;
                    double numSegments = (int)divided;
                    if (numSegments > 0.0) {
                        double dashCumulative = numSegments * dashLength;
                        gapLength = (lineLength - dashCumulative) / numSegments;
                    }
                    array = new double[]{dashLength, gapLength};
                    dashOffset = (float)(dashLength * 0.6);
                } else {
                    array = new double[]{2.0 * strokeWidth, 1.4 * strokeWidth};
                    dashOffset = 0.0f;
                }
            } else {
                array = new double[dashArray.size()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = dashArray.get(i);
                }
                dashOffset = (float)sb.getDashOffset();
            }
            bs = new BasicStroke(type, (float)strokeWidth, cap, join, (float)sb.getMiterLimit(), array, dashOffset);
        } else {
            bs = new BasicStroke(type, (float)strokeWidth, cap, join, (float)sb.getMiterLimit());
        }
        return bs;
    }

    private void setBorderStyle(Graphics g, BorderStroke sb, double length, boolean forceCentered) {
        BorderWidths widths = sb.getWidths();
        BorderStrokeStyle bs = sb.getTopStyle();
        double sbWidth = widths.isTopAsPercentage() ? (double)this.height * widths.getTop() : widths.getTop();
        Paint sbFill = NGRegion.getPlatformPaint(sb.getTopStroke());
        if (bs == null) {
            bs = sb.getLeftStyle();
            sbWidth = widths.isLeftAsPercentage() ? (double)this.width * widths.getLeft() : widths.getLeft();
            sbFill = NGRegion.getPlatformPaint(sb.getLeftStroke());
            if (bs == null) {
                bs = sb.getBottomStyle();
                sbWidth = widths.isBottomAsPercentage() ? (double)this.height * widths.getBottom() : widths.getBottom();
                sbFill = NGRegion.getPlatformPaint(sb.getBottomStroke());
                if (bs == null) {
                    bs = sb.getRightStyle();
                    sbWidth = widths.isRightAsPercentage() ? (double)this.width * widths.getRight() : widths.getRight();
                    sbFill = NGRegion.getPlatformPaint(sb.getRightStroke());
                }
            }
        }
        if (bs == null || bs == BorderStrokeStyle.NONE) {
            return;
        }
        g.setStroke(this.createStroke(bs, sbWidth, length, forceCentered));
        g.setPaint(sbFill);
    }

    private void doCorner(Path2D path, CornerRadii radii, float x, float y, int quadrant, float tstart, float tend, boolean newPath) {
        float dy1;
        float dx1;
        float dy0;
        float dx0;
        float vr;
        float hr;
        switch (quadrant & 3) {
            case 0: {
                hr = (float)radii.getTopLeftHorizontalRadius();
                vr = (float)radii.getTopLeftVerticalRadius();
                dx0 = 0.0f;
                dy0 = vr;
                dx1 = hr;
                dy1 = 0.0f;
                break;
            }
            case 1: {
                hr = (float)radii.getTopRightHorizontalRadius();
                vr = (float)radii.getTopRightVerticalRadius();
                dx0 = -hr;
                dy0 = 0.0f;
                dx1 = 0.0f;
                dy1 = vr;
                break;
            }
            case 2: {
                hr = (float)radii.getBottomRightHorizontalRadius();
                vr = (float)radii.getBottomRightVerticalRadius();
                dx0 = 0.0f;
                dy0 = -vr;
                dx1 = -hr;
                dy1 = 0.0f;
                break;
            }
            case 3: {
                hr = (float)radii.getBottomLeftHorizontalRadius();
                vr = (float)radii.getBottomLeftVerticalRadius();
                dx0 = hr;
                dy0 = 0.0f;
                dx1 = 0.0f;
                dy1 = -vr;
                break;
            }
            default: {
                return;
            }
        }
        if (hr > 0.0f && vr > 0.0f) {
            path.appendOvalQuadrant(x + dx0, y + dy0, x, y, x + dx1, y + dy1, tstart, tend, newPath ? Path2D.CornerPrefix.MOVE_THEN_CORNER : Path2D.CornerPrefix.LINE_THEN_CORNER);
        } else if (newPath) {
            path.moveTo(x, y);
        } else {
            path.lineTo(x, y);
        }
    }

    private Path2D createPath(float width, float height, float t, float l, float bo, float ro, CornerRadii radii) {
        float r = width - ro;
        float b = height - bo;
        Path2D path = new Path2D();
        this.doCorner(path, radii, l, t, 0, 0.0f, 1.0f, true);
        this.doCorner(path, radii, r, t, 1, 0.0f, 1.0f, false);
        this.doCorner(path, radii, r, b, 2, 0.0f, 1.0f, false);
        this.doCorner(path, radii, l, b, 3, 0.0f, 1.0f, false);
        path.closePath();
        return path;
    }

    private Path2D makeRoundedEdge(CornerRadii radii, float x0, float y0, float x1, float y1, int quadrant) {
        Path2D path = new Path2D();
        this.doCorner(path, radii, x0, y0, quadrant, 0.5f, 1.0f, true);
        this.doCorner(path, radii, x1, y1, quadrant + 1, 0.0f, 0.5f, false);
        return path;
    }

    private Path2D[] createPaths(float t, float l, float bo, float ro, CornerRadii radii) {
        float r = this.width - ro;
        float b = this.height - bo;
        return new Path2D[]{this.makeRoundedEdge(radii, l, t, r, t, 0), this.makeRoundedEdge(radii, r, t, r, b, 1), this.makeRoundedEdge(radii, r, b, l, b, 2), this.makeRoundedEdge(radii, l, b, l, t, 3)};
    }

    private Shape resizeShape(float topOffset, float rightOffset, float bottomOffset, float leftOffset) {
        RectBounds bounds = this.shape.getBounds();
        if (this.scaleShape) {
            SCRATCH_AFFINE.setToIdentity();
            SCRATCH_AFFINE.translate(leftOffset, topOffset);
            float w = this.width - leftOffset - rightOffset;
            float h = this.height - topOffset - bottomOffset;
            SCRATCH_AFFINE.scale(w / bounds.getWidth(), h / bounds.getHeight());
            if (this.centerShape) {
                SCRATCH_AFFINE.translate(-bounds.getMinX(), -bounds.getMinY());
            }
            return SCRATCH_AFFINE.createTransformedShape(this.shape);
        }
        if (this.centerShape) {
            float boundsWidth = bounds.getWidth();
            float boundsHeight = bounds.getHeight();
            float newW = boundsWidth - leftOffset - rightOffset;
            float newH = boundsHeight - topOffset - bottomOffset;
            SCRATCH_AFFINE.setToIdentity();
            SCRATCH_AFFINE.translate(leftOffset + (this.width - boundsWidth) / 2.0f - bounds.getMinX(), topOffset + (this.height - boundsHeight) / 2.0f - bounds.getMinY());
            if (newH != boundsHeight || newW != boundsWidth) {
                SCRATCH_AFFINE.translate(bounds.getMinX(), bounds.getMinY());
                SCRATCH_AFFINE.scale(newW / boundsWidth, newH / boundsHeight);
                SCRATCH_AFFINE.translate(-bounds.getMinX(), -bounds.getMinY());
            }
            return SCRATCH_AFFINE.createTransformedShape(this.shape);
        }
        if (topOffset != 0.0f || rightOffset != 0.0f || bottomOffset != 0.0f || leftOffset != 0.0f) {
            float newW = bounds.getWidth() - leftOffset - rightOffset;
            float newH = bounds.getHeight() - topOffset - bottomOffset;
            SCRATCH_AFFINE.setToIdentity();
            SCRATCH_AFFINE.translate(leftOffset, topOffset);
            SCRATCH_AFFINE.translate(bounds.getMinX(), bounds.getMinY());
            SCRATCH_AFFINE.scale(newW / bounds.getWidth(), newH / bounds.getHeight());
            SCRATCH_AFFINE.translate(-bounds.getMinX(), -bounds.getMinY());
            return SCRATCH_AFFINE.createTransformedShape(this.shape);
        }
        return this.shape;
    }

    private void paintTiles(Graphics g, Image img, BorderRepeat repeatX, BorderRepeat repeatY, Side horizontalSide, Side verticalSide, float regionX, float regionY, float regionWidth, float regionHeight, int srcX, int srcY, int srcW, int srcH, float tileX, float tileY, float tileWidth, float tileHeight) {
        BackgroundRepeat rx = null;
        BackgroundRepeat ry = null;
        switch (repeatX) {
            case REPEAT: {
                rx = BackgroundRepeat.REPEAT;
                break;
            }
            case STRETCH: {
                rx = BackgroundRepeat.NO_REPEAT;
                break;
            }
            case ROUND: {
                rx = BackgroundRepeat.ROUND;
                break;
            }
            case SPACE: {
                rx = BackgroundRepeat.SPACE;
            }
        }
        switch (repeatY) {
            case REPEAT: {
                ry = BackgroundRepeat.REPEAT;
                break;
            }
            case STRETCH: {
                ry = BackgroundRepeat.NO_REPEAT;
                break;
            }
            case ROUND: {
                ry = BackgroundRepeat.ROUND;
                break;
            }
            case SPACE: {
                ry = BackgroundRepeat.SPACE;
            }
        }
        this.paintTiles(g, img, rx, ry, horizontalSide, verticalSide, regionX, regionY, regionWidth, regionHeight, srcX, srcY, srcW, srcH, tileX, tileY, tileWidth, tileHeight);
    }

    private void paintTiles(Graphics g, Image img, BackgroundRepeat repeatX, BackgroundRepeat repeatY, Side horizontalSide, Side verticalSide, float regionX, float regionY, float regionWidth, float regionHeight, int srcX, int srcY, int srcW, int srcH, float tileX, float tileY, float tileWidth, float tileHeight) {
        if (regionWidth <= 0.0f || regionHeight <= 0.0f || srcW <= 0 || srcH <= 0) {
            return;
        }
        assert (srcX >= 0 && srcY >= 0 && srcW > 0 && srcH > 0);
        if (tileX == 0.0f && tileY == 0.0f && repeatX == BackgroundRepeat.REPEAT && repeatY == BackgroundRepeat.REPEAT) {
            if (srcX != 0 || srcY != 0 || srcW != img.getWidth() || srcH != img.getHeight()) {
                img = img.createSubImage(srcX, srcY, srcW, srcH);
            }
            g.setPaint(new com.sun.prism.paint.ImagePattern(img, 0.0f, 0.0f, tileWidth, tileHeight, false, false));
            g.fillRect(regionX, regionY, regionWidth, regionHeight);
        } else {
            float yIncrement;
            int countY;
            float remainder;
            float xIncrement;
            int countX;
            float mod;
            if (repeatX == BackgroundRepeat.SPACE && regionWidth < tileWidth * 2.0f) {
                repeatX = BackgroundRepeat.NO_REPEAT;
            }
            if (repeatY == BackgroundRepeat.SPACE && regionHeight < tileHeight * 2.0f) {
                repeatY = BackgroundRepeat.NO_REPEAT;
            }
            if (repeatX == BackgroundRepeat.REPEAT) {
                float offsetX = 0.0f;
                if (tileX != 0.0f) {
                    mod = tileX % tileWidth;
                    offsetX = tileX = mod == 0.0f ? 0.0f : (tileX < 0.0f ? mod : mod - tileWidth);
                }
                countX = (int)Math.max(1.0, Math.ceil((regionWidth - offsetX) / tileWidth));
                xIncrement = horizontalSide == Side.RIGHT ? -tileWidth : tileWidth;
            } else if (repeatX == BackgroundRepeat.SPACE) {
                tileX = 0.0f;
                countX = (int)(regionWidth / tileWidth);
                remainder = regionWidth % tileWidth;
                xIncrement = tileWidth + remainder / (float)(countX - 1);
            } else if (repeatX == BackgroundRepeat.ROUND) {
                tileX = 0.0f;
                countX = (int)(regionWidth / tileWidth);
                xIncrement = tileWidth = regionWidth / (float)((int)(regionWidth / tileWidth));
            } else {
                countX = 1;
                float f = xIncrement = horizontalSide == Side.RIGHT ? -tileWidth : tileWidth;
            }
            if (repeatY == BackgroundRepeat.REPEAT) {
                float offsetY = 0.0f;
                if (tileY != 0.0f) {
                    mod = tileY % tileHeight;
                    offsetY = tileY = mod == 0.0f ? 0.0f : (tileY < 0.0f ? mod : mod - tileHeight);
                }
                countY = (int)Math.max(1.0, Math.ceil((regionHeight - offsetY) / tileHeight));
                yIncrement = verticalSide == Side.BOTTOM ? -tileHeight : tileHeight;
            } else if (repeatY == BackgroundRepeat.SPACE) {
                tileY = 0.0f;
                countY = (int)(regionHeight / tileHeight);
                remainder = regionHeight % tileHeight;
                yIncrement = tileHeight + remainder / (float)(countY - 1);
            } else if (repeatY == BackgroundRepeat.ROUND) {
                tileY = 0.0f;
                countY = (int)(regionHeight / tileHeight);
                yIncrement = tileHeight = regionHeight / (float)((int)(regionHeight / tileHeight));
            } else {
                countY = 1;
                yIncrement = verticalSide == Side.BOTTOM ? -tileHeight : tileHeight;
            }
            Texture texture = g.getResourceFactory().getCachedTexture(img, Texture.WrapMode.CLAMP_TO_EDGE);
            int srcX2 = srcX + srcW;
            int srcY2 = srcY + srcH;
            float regionX2 = regionX + regionWidth;
            float regionY2 = regionY + regionHeight;
            float dstY = regionY + tileY;
            for (int y = 0; y < countY; ++y) {
                float dstY2 = dstY + tileHeight;
                float dstX = regionX + tileX;
                for (int x = 0; x < countX; ++x) {
                    float dy2;
                    float dy1;
                    float dstX2 = dstX + tileWidth;
                    boolean skipRender = false;
                    float dx1 = dstX < regionX ? regionX : dstX;
                    float f = dy1 = dstY < regionY ? regionY : dstY;
                    if (dx1 > regionX2 || dy1 > regionY2) {
                        skipRender = true;
                    }
                    float dx2 = dstX2 > regionX2 ? regionX2 : dstX2;
                    float f2 = dy2 = dstY2 > regionY2 ? regionY2 : dstY2;
                    if (dx2 < regionX || dy2 < regionY) {
                        skipRender = true;
                    }
                    if (!skipRender) {
                        float sx1 = dstX < regionX ? (float)srcX + (float)srcW * (-tileX / tileWidth) : (float)srcX;
                        float sy1 = dstY < regionY ? (float)srcY + (float)srcH * (-tileY / tileHeight) : (float)srcY;
                        float sx2 = dstX2 > regionX2 ? (float)srcX2 - (float)srcW * ((dstX2 - regionX2) / tileWidth) : (float)srcX2;
                        float sy2 = dstY2 > regionY2 ? (float)srcY2 - (float)srcH * ((dstY2 - regionY2) / tileHeight) : (float)srcY2;
                        g.drawTexture(texture, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2);
                    }
                    dstX += xIncrement;
                }
                dstY += yIncrement;
            }
            texture.unlock();
        }
    }

    final Border getBorder() {
        return this.border;
    }

    final Background getBackground() {
        return this.background;
    }

    final float getWidth() {
        return this.width;
    }

    final float getHeight() {
        return this.height;
    }
}

