/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.theme;

import com.sun.javafx.util.Utils;
import com.sun.javafx.webkit.Accessor;
import com.sun.javafx.webkit.theme.RenderThemeImpl;
import com.sun.javafx.webkit.theme.Renderer;
import com.sun.webkit.graphics.Ref;
import com.sun.webkit.graphics.ScrollBarTheme;
import com.sun.webkit.graphics.WCGraphicsContext;
import com.sun.webkit.graphics.WCSize;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.Observable;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollBar;

public final class ScrollBarThemeImpl
extends ScrollBarTheme {
    private static final Logger log = Logger.getLogger(ScrollBarThemeImpl.class.getName());
    private WeakReference<ScrollBar> testSBRef = new WeakReference<Object>(null);
    private boolean thicknessInitialized = false;
    private final Accessor accessor;
    private final RenderThemeImpl.Pool<ScrollBarWidget> pool;

    public ScrollBarThemeImpl(final Accessor accessor) {
        this.accessor = accessor;
        this.pool = new RenderThemeImpl.Pool<ScrollBarWidget>(sb -> accessor.removeChild((Node)sb), ScrollBarWidget.class);
        accessor.addViewListener(new RenderThemeImpl.ViewListener(this.pool, accessor){

            @Override
            public void invalidated(Observable ov) {
                super.invalidated(ov);
                ScrollBarWidget testSB = new ScrollBarWidget();
                accessor.addChild(testSB);
                ScrollBarThemeImpl.this.testSBRef = new WeakReference<ScrollBarWidget>(testSB);
            }
        });
    }

    private static Orientation convertOrientation(int orientation) {
        return orientation == 1 ? Orientation.VERTICAL : Orientation.HORIZONTAL;
    }

    private void adjustScrollBar(ScrollBar sb, int w, int h, int orientation) {
        Orientation current = ScrollBarThemeImpl.convertOrientation(orientation);
        if (current != sb.getOrientation()) {
            sb.setOrientation(current);
        }
        if (current == Orientation.VERTICAL) {
            w = ScrollBarTheme.getThickness();
        } else {
            h = ScrollBarTheme.getThickness();
        }
        if ((double)w != sb.getWidth() || (double)h != sb.getHeight()) {
            sb.resize(w, h);
        }
    }

    private void adjustScrollBar(ScrollBar sb, int w, int h, int orientation, int value, int visibleSize, int totalSize) {
        this.adjustScrollBar(sb, w, h, orientation);
        boolean disable = totalSize <= visibleSize;
        sb.setDisable(disable);
        if (disable) {
            return;
        }
        if (value < 0) {
            value = 0;
        } else if (value > totalSize - visibleSize) {
            value = totalSize - visibleSize;
        }
        if (sb.getMax() != (double)totalSize || sb.getVisibleAmount() != (double)visibleSize) {
            sb.setValue(0.0);
            sb.setMax(totalSize);
            sb.setVisibleAmount(visibleSize);
        }
        if (totalSize > visibleSize) {
            float factor = (float)totalSize / (float)(totalSize - visibleSize);
            if (sb.getValue() != (double)((float)value * factor)) {
                sb.setValue((float)value * factor);
            }
        }
    }

    @Override
    protected Ref createWidget(long id, int w, int h, int orientation, int value, int visibleSize, int totalSize) {
        ScrollBarWidget sb = this.pool.get(id);
        if (sb == null) {
            sb = new ScrollBarWidget();
            this.pool.put(id, sb, this.accessor.getPage().getUpdateContentCycleID());
            this.accessor.addChild(sb);
        }
        this.adjustScrollBar(sb, w, h, orientation, value, visibleSize, totalSize);
        return new ScrollBarRef(sb);
    }

    @Override
    public void paint(WCGraphicsContext g, Ref sbRef, int x, int y, int pressedPart, int hoveredPart) {
        ScrollBar sb = (ScrollBar)((ScrollBarRef)sbRef).asControl();
        if (sb == null) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "[{0}, {1} {2}x{3}], {4}", new Object[]{x, y, sb.getWidth(), sb.getHeight(), sb.getOrientation() == Orientation.VERTICAL ? "VERTICAL" : "HORIZONTAL"});
        }
        g.saveState();
        g.translate(x, y);
        Renderer.getRenderer().render(sb, g);
        g.restoreState();
    }

    @Override
    public WCSize getWidgetSize(Ref widget) {
        ScrollBar sb = (ScrollBar)((ScrollBarRef)widget).asControl();
        if (sb != null) {
            return new WCSize((float)sb.getWidth(), (float)sb.getHeight());
        }
        return new WCSize(0.0f, 0.0f);
    }

    @Override
    protected int hitTest(int w, int h, int orientation, int value, int visibleSize, int totalSize, int x, int y) {
        int incBtnY;
        int thumbY;
        int trackY;
        int trackX;
        int incBtnX;
        int thumbX;
        ScrollBar testSB;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "[{0}, {1} {2}x{3}], {4}", new Object[]{x, y, w, h, orientation == 1 ? "VERTICAL" : "HORIZONTAL"});
        }
        if ((testSB = (ScrollBar)this.testSBRef.get()) == null) {
            return 0;
        }
        Node thumb = ScrollBarThemeImpl.getThumb(testSB);
        Node track = ScrollBarThemeImpl.getTrack(testSB);
        Node decButton = ScrollBarThemeImpl.getDecButton(testSB);
        Node incButton = ScrollBarThemeImpl.getIncButton(testSB);
        this.adjustScrollBar(testSB, w, h, orientation, value, visibleSize, totalSize);
        if (orientation == 1) {
            incBtnX = thumbX = x;
            trackX = thumbX;
            trackY = y - (int)decButton.getLayoutBounds().getHeight();
            thumbY = trackY - this.thumbPosition();
            incBtnY = trackY - (int)track.getLayoutBounds().getHeight();
        } else {
            incBtnY = thumbY = y;
            trackY = thumbY;
            trackX = x - (int)decButton.getLayoutBounds().getWidth();
            thumbX = trackX - this.thumbPosition();
            incBtnX = trackX - (int)track.getLayoutBounds().getWidth();
        }
        if (thumb != null && thumb.isVisible() && thumb.contains(thumbX, thumbY)) {
            log.finer("thumb");
            return 8;
        }
        if (track != null && track.isVisible() && track.contains(trackX, trackY)) {
            if (orientation == 1 && this.thumbPosition() >= trackY || orientation == 0 && this.thumbPosition() >= trackX) {
                log.finer("back track");
                return 4;
            }
            if (orientation == 1 && this.thumbPosition() < trackY || orientation == 0 && this.thumbPosition() < trackX) {
                log.finer("forward track");
                return 16;
            }
        } else {
            if (decButton != null && decButton.isVisible() && decButton.contains(x, y)) {
                log.finer("back button");
                return 1;
            }
            if (incButton != null && incButton.isVisible() && incButton.contains(incBtnX, incBtnY)) {
                log.finer("forward button");
                return 2;
            }
        }
        log.finer("no part");
        return 0;
    }

    private int thumbPosition() {
        ScrollBar testSB = (ScrollBar)this.testSBRef.get();
        if (testSB == null) {
            return 0;
        }
        Node thumb = ScrollBarThemeImpl.getThumb(testSB);
        if (thumb == null) {
            return 0;
        }
        double thumbLength = testSB.getOrientation() == Orientation.VERTICAL ? thumb.getLayoutBounds().getHeight() : thumb.getLayoutBounds().getWidth();
        Node track = ScrollBarThemeImpl.getTrack(testSB);
        double trackLength = testSB.getOrientation() == Orientation.VERTICAL ? track.getLayoutBounds().getHeight() : track.getLayoutBounds().getWidth();
        double clampedValue = Utils.clamp(testSB.getMin(), testSB.getValue(), testSB.getMax());
        double range = testSB.getMax() - testSB.getMin();
        return (int)Math.round(range > 0.0 ? (trackLength - thumbLength) * (clampedValue - testSB.getMin()) / range : 0.0);
    }

    @Override
    protected int getThumbLength(int w, int h, int orientation, int value, int visibleSize, int totalSize) {
        ScrollBar testSB = (ScrollBar)this.testSBRef.get();
        if (testSB == null) {
            return 0;
        }
        Node thumb = ScrollBarThemeImpl.getThumb(testSB);
        if (thumb == null) {
            return 0;
        }
        this.adjustScrollBar(testSB, w, h, orientation, value, visibleSize, totalSize);
        double len = 0.0;
        len = orientation == 1 ? thumb.getLayoutBounds().getHeight() : thumb.getLayoutBounds().getWidth();
        log.log(Level.FINEST, "thumb length: {0}", len);
        return (int)len;
    }

    @Override
    protected int getTrackPosition(int w, int h, int orientation) {
        ScrollBar testSB = (ScrollBar)this.testSBRef.get();
        if (testSB == null) {
            return 0;
        }
        Node decButton = ScrollBarThemeImpl.getDecButton(testSB);
        if (decButton == null) {
            return 0;
        }
        this.adjustScrollBar(testSB, w, h, orientation);
        double pos = 0.0;
        pos = orientation == 1 ? decButton.getLayoutBounds().getHeight() : decButton.getLayoutBounds().getWidth();
        log.log(Level.FINEST, "track position: {0}", pos);
        return (int)pos;
    }

    @Override
    protected int getTrackLength(int w, int h, int orientation) {
        ScrollBar testSB = (ScrollBar)this.testSBRef.get();
        if (testSB == null) {
            return 0;
        }
        Node track = ScrollBarThemeImpl.getTrack(testSB);
        if (track == null) {
            return 0;
        }
        this.adjustScrollBar(testSB, w, h, orientation);
        double len = 0.0;
        len = orientation == 1 ? track.getLayoutBounds().getHeight() : track.getLayoutBounds().getWidth();
        log.log(Level.FINEST, "track length: {0}", len);
        return (int)len;
    }

    @Override
    protected int getThumbPosition(int w, int h, int orientation, int value, int visibleSize, int totalSize) {
        ScrollBar testSB = (ScrollBar)this.testSBRef.get();
        if (testSB == null) {
            return 0;
        }
        this.adjustScrollBar(testSB, w, h, orientation, value, visibleSize, totalSize);
        int pos = this.thumbPosition();
        log.log(Level.FINEST, "thumb position: {0}", pos);
        return pos;
    }

    private void initializeThickness() {
        if (!this.thicknessInitialized) {
            ScrollBar testSB = (ScrollBar)this.testSBRef.get();
            if (testSB == null) {
                return;
            }
            int thickness = (int)testSB.prefWidth(-1.0);
            if (thickness != 0 && ScrollBarTheme.getThickness() != thickness) {
                ScrollBarTheme.setThickness(thickness);
            }
            this.thicknessInitialized = true;
        }
    }

    private static Node getThumb(ScrollBar scrollBar) {
        return ScrollBarThemeImpl.findNode(scrollBar, "thumb");
    }

    private static Node getTrack(ScrollBar scrollBar) {
        return ScrollBarThemeImpl.findNode(scrollBar, "track");
    }

    private static Node getIncButton(ScrollBar scrollBar) {
        return ScrollBarThemeImpl.findNode(scrollBar, "increment-button");
    }

    private static Node getDecButton(ScrollBar scrollBar) {
        return ScrollBarThemeImpl.findNode(scrollBar, "decrement-button");
    }

    private static Node findNode(ScrollBar scrollBar, String styleclass) {
        for (Node n : scrollBar.getChildrenUnmodifiable()) {
            if (!n.getStyleClass().contains(styleclass)) continue;
            return n;
        }
        return null;
    }

    private static final class ScrollBarRef
    extends Ref {
        private final WeakReference<ScrollBarWidget> sbRef;

        private ScrollBarRef(ScrollBarWidget sb) {
            this.sbRef = new WeakReference<ScrollBarWidget>(sb);
        }

        private Control asControl() {
            return (Control)this.sbRef.get();
        }
    }

    private final class ScrollBarWidget
    extends ScrollBar
    implements RenderThemeImpl.Widget {
        private ScrollBarWidget() {
            this.setOrientation(Orientation.VERTICAL);
            this.setMin(0.0);
            this.setManaged(false);
        }

        @Override
        public void impl_updatePeer() {
            super.impl_updatePeer();
            ScrollBarThemeImpl.this.initializeThickness();
        }

        @Override
        public RenderThemeImpl.WidgetType getType() {
            return RenderThemeImpl.WidgetType.SCROLLBAR;
        }

        @Override
        protected void layoutChildren() {
            super.layoutChildren();
            ScrollBarThemeImpl.this.initializeThickness();
        }
    }
}

