/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.embed.EmbeddedSceneInterface;
import com.sun.javafx.embed.EmbeddedStageInterface;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.stage.EmbeddedWindow;
import com.sun.javafx.tk.Toolkit;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;
import javafx.embed.swing.InputMethodSupport;
import javafx.embed.swing.SwingCursors;
import javafx.embed.swing.SwingDnD;
import javafx.embed.swing.SwingEvents;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Scene;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import sun.awt.AppContext;
import sun.awt.CausedFocusEvent;
import sun.awt.SunToolkit;
import sun.awt.UngrabEvent;
import sun.java2d.SunGraphics2D;
import sun.util.logging.PlatformLogger;

public class JFXPanel
extends JComponent {
    private static final PlatformLogger log = PlatformLogger.getLogger(JFXPanel.class.getName());
    private static AtomicInteger instanceCount = new AtomicInteger(0);
    private static PlatformImpl.FinishListener finishListener;
    private HostContainer hostContainer;
    private volatile EmbeddedWindow stage;
    private volatile Scene scene;
    private SwingDnD dnd;
    private EmbeddedStageInterface stagePeer;
    private EmbeddedSceneInterface scenePeer;
    private int pWidth;
    private int pHeight;
    private int scaleFactor = 1;
    private volatile int pPreferredWidth = -1;
    private volatile int pPreferredHeight = -1;
    private volatile int screenX = 0;
    private volatile int screenY = 0;
    private BufferedImage pixelsIm;
    private volatile float opacity = 1.0f;
    private AtomicInteger disableCount = new AtomicInteger(0);
    private boolean isCapturingMouse = false;
    private final AWTEventListener ungrabListener = event -> {
        if (event instanceof UngrabEvent) {
            SwingFXUtils.runOnFxThread(() -> {
                if (this.stagePeer != null) {
                    this.stagePeer.focusUngrab();
                }
            });
        }
        if (event instanceof MouseEvent && event.getID() == 501 && event.getSource() instanceof Component) {
            Window eventWindow;
            Window jfxPanelWindow = SwingUtilities.getWindowAncestor(this);
            Component source = (Component)event.getSource();
            Window window = eventWindow = source instanceof Window ? (Window)source : SwingUtilities.getWindowAncestor(source);
            if (jfxPanelWindow == eventWindow) {
                SwingFXUtils.runOnFxThread(() -> {
                    if (this.stagePeer != null) {
                        this.stagePeer.focusUngrab();
                    }
                });
            }
        }
    };

    private synchronized void registerFinishListener() {
        if (instanceCount.getAndIncrement() > 0) {
            return;
        }
        finishListener = new PlatformImpl.FinishListener(){

            @Override
            public void idle(boolean implicitExit) {
            }

            @Override
            public void exitCalled() {
            }
        };
        PlatformImpl.addListener(finishListener);
    }

    private synchronized void deregisterFinishListener() {
        if (instanceCount.decrementAndGet() > 0) {
            return;
        }
        PlatformImpl.removeListener(finishListener);
        finishListener = null;
    }

    private static synchronized void initFx() {
        AccessController.doPrivileged(() -> {
            System.setProperty("glass.win.uiScale", "100%");
            System.setProperty("glass.win.renderScale", "100%");
            return null;
        });
        PlatformImpl.startup(() -> {});
    }

    public JFXPanel() {
        JFXPanel.initFx();
        this.hostContainer = new HostContainer();
        this.enableEvents(231485L);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
    }

    public Scene getScene() {
        return this.scene;
    }

    public void setScene(Scene newScene) {
        if (Toolkit.getToolkit().isFxUserThread()) {
            this.setSceneImpl(newScene);
        } else {
            CountDownLatch initLatch = new CountDownLatch(1);
            Platform.runLater(() -> {
                this.setSceneImpl(newScene);
                initLatch.countDown();
            });
            try {
                initLatch.await();
            }
            catch (InterruptedException z) {
                z.printStackTrace(System.err);
            }
        }
    }

    private void setSceneImpl(Scene newScene) {
        if (this.stage != null && newScene == null) {
            this.stage.hide();
            this.stage = null;
        }
        this.scene = newScene;
        if (this.stage == null && newScene != null) {
            this.stage = new EmbeddedWindow(this.hostContainer);
        }
        if (this.stage != null) {
            this.stage.setScene(newScene);
            if (!this.stage.isShowing()) {
                this.stage.show();
            }
        }
    }

    @Override
    public final void setOpaque(boolean opaque) {
        if (!opaque) {
            super.setOpaque(opaque);
        }
    }

    @Override
    public final boolean isOpaque() {
        return false;
    }

    private void sendMouseEventToFX(MouseEvent e) {
        boolean secondaryBtnDown;
        if (this.scenePeer == null || !this.isFxEnabled()) {
            return;
        }
        switch (e.getID()) {
            case 501: 
            case 502: 
            case 506: {
                if (e.getButton() <= 3) break;
                return;
            }
        }
        int extModifiers = e.getModifiersEx();
        boolean primaryBtnDown = (extModifiers & 0x400) != 0;
        boolean middleBtnDown = (extModifiers & 0x800) != 0;
        boolean bl = secondaryBtnDown = (extModifiers & 0x1000) != 0;
        if (e.getID() == 506) {
            if (!this.isCapturingMouse) {
                return;
            }
        } else if (e.getID() == 501) {
            this.isCapturingMouse = true;
        } else if (e.getID() == 502) {
            if (!this.isCapturingMouse) {
                return;
            }
            this.isCapturingMouse = primaryBtnDown || middleBtnDown || secondaryBtnDown;
        } else if (e.getID() == 500) {
            return;
        }
        boolean popupTrigger = false;
        if (e.getID() == 501 || e.getID() == 502) {
            popupTrigger = e.isPopupTrigger();
        }
        this.scenePeer.mouseEvent(SwingEvents.mouseIDToEmbedMouseType(e.getID()), SwingEvents.mouseButtonToEmbedMouseButton(e.getButton(), extModifiers), primaryBtnDown, middleBtnDown, secondaryBtnDown, e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), (extModifiers & 0x40) != 0, (extModifiers & 0x80) != 0, (extModifiers & 0x200) != 0, (extModifiers & 0x100) != 0, SwingEvents.getWheelRotation(e), popupTrigger);
        if (e.isPopupTrigger()) {
            this.scenePeer.menuEvent(e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), false);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501 && e.getButton() == 1 && !this.hasFocus()) {
            this.requestFocus();
        }
        this.sendMouseEventToFX(e);
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        this.sendMouseEventToFX(e);
        super.processMouseMotionEvent(e);
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e) {
        this.sendMouseEventToFX(e);
        super.processMouseWheelEvent(e);
    }

    private void sendKeyEventToFX(KeyEvent e) {
        char[] cArray;
        if (this.scenePeer == null || !this.isFxEnabled()) {
            return;
        }
        if (e.getKeyChar() == '\uffff') {
            cArray = new char[]{};
        } else {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = SwingEvents.keyCharToEmbedKeyChar(e.getKeyChar());
        }
        char[] chars = cArray;
        this.scenePeer.keyEvent(SwingEvents.keyIDToEmbedKeyType(e.getID()), e.getKeyCode(), chars, SwingEvents.keyModifiersToEmbedKeyModifiers(e.getModifiersEx()));
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        this.sendKeyEventToFX(e);
        super.processKeyEvent(e);
    }

    private void sendResizeEventToFX() {
        if (this.stagePeer != null) {
            this.stagePeer.setSize(this.pWidth, this.pHeight);
        }
        if (this.scenePeer != null) {
            this.scenePeer.setSize(this.pWidth, this.pHeight);
        }
    }

    @Override
    protected void processComponentEvent(ComponentEvent e) {
        switch (e.getID()) {
            case 101: {
                this.updateComponentSize();
                break;
            }
            case 100: {
                if (!this.updateScreenLocation()) break;
                this.sendMoveEventToFX();
                break;
            }
        }
        super.processComponentEvent(e);
    }

    private void updateComponentSize() {
        int oldWidth = this.pWidth;
        int oldHeight = this.pHeight;
        this.pWidth = Math.max(0, this.getWidth());
        this.pHeight = Math.max(0, this.getHeight());
        if (this.getBorder() != null) {
            Insets i = this.getBorder().getBorderInsets(this);
            this.pWidth -= i.left + i.right;
            this.pHeight -= i.top + i.bottom;
        }
        if (oldWidth != this.pWidth || oldHeight != this.pHeight) {
            this.resizePixelBuffer(this.scaleFactor);
            this.sendResizeEventToFX();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateScreenLocation() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.isShowing()) {
                Point p = this.getLocationOnScreen();
                this.screenX = p.x;
                this.screenY = p.y;
                return true;
            }
        }
        return false;
    }

    private void sendMoveEventToFX() {
        if (this.stagePeer == null) {
            return;
        }
        this.stagePeer.setLocation(this.screenX, this.screenY);
    }

    @Override
    protected void processHierarchyBoundsEvent(HierarchyEvent e) {
        if (e.getID() == 1401 && this.updateScreenLocation()) {
            this.sendMoveEventToFX();
        }
        super.processHierarchyBoundsEvent(e);
    }

    @Override
    protected void processHierarchyEvent(HierarchyEvent e) {
        if ((e.getChangeFlags() & 4L) != 0L && this.updateScreenLocation()) {
            this.sendMoveEventToFX();
        }
        super.processHierarchyEvent(e);
    }

    private void sendFocusEventToFX(FocusEvent e) {
        int focusCause;
        if (this.stage == null || this.stagePeer == null || !this.isFxEnabled()) {
            return;
        }
        boolean focused = e.getID() == 1004;
        int n = focusCause = focused ? 0 : 3;
        if (focused && e instanceof CausedFocusEvent) {
            CausedFocusEvent ce = (CausedFocusEvent)e;
            if (ce.getCause() == CausedFocusEvent.Cause.TRAVERSAL_FORWARD) {
                focusCause = 1;
            } else if (ce.getCause() == CausedFocusEvent.Cause.TRAVERSAL_BACKWARD) {
                focusCause = 2;
            }
        }
        this.stagePeer.setFocused(focused, focusCause);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        this.sendFocusEventToFX(e);
        super.processFocusEvent(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizePixelBuffer(int newScaleFactor) {
        if (this.pWidth <= 0 || this.pHeight <= 0) {
            this.pixelsIm = null;
        } else {
            BufferedImage oldIm = this.pixelsIm;
            this.pixelsIm = new BufferedImage(this.pWidth * newScaleFactor, this.pHeight * newScaleFactor, 2);
            if (oldIm != null) {
                double ratio = newScaleFactor / this.scaleFactor;
                int oldW = (int)Math.round((double)oldIm.getWidth() * ratio);
                int oldH = (int)Math.round((double)oldIm.getHeight() * ratio);
                Graphics g = this.pixelsIm.getGraphics();
                try {
                    g.drawImage(oldIm, 0, 0, oldW, oldH, null);
                }
                finally {
                    g.dispose();
                }
            }
        }
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent e) {
        if (e.getID() == 1100) {
            this.sendInputMethodEventToFX(e);
        }
        super.processInputMethodEvent(e);
    }

    private void sendInputMethodEventToFX(InputMethodEvent e) {
        String t = InputMethodSupport.getTextForEvent(e);
        this.scenePeer.inputMethodEvent(javafx.scene.input.InputMethodEvent.INPUT_METHOD_TEXT_CHANGED, InputMethodSupport.inputMethodEventComposed(t, e.getCommittedCharacterCount()), t.substring(0, e.getCommittedCharacterCount()), e.getCaret().getInsertionIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        if (this.scenePeer == null || this.pixelsIm == null) {
            return;
        }
        DataBufferInt dataBuf = (DataBufferInt)this.pixelsIm.getRaster().getDataBuffer();
        int[] pixelsData = dataBuf.getData();
        IntBuffer buf = IntBuffer.wrap(pixelsData);
        if (!this.scenePeer.getPixels(buf, this.pWidth, this.pHeight)) {
            // empty if block
        }
        Graphics gg = null;
        try {
            gg = g.create();
            if (this.opacity < 1.0f && gg instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)gg;
                AlphaComposite c = AlphaComposite.getInstance(3, this.opacity);
                g2d.setComposite(c);
            }
            if (this.getBorder() != null) {
                Insets i = this.getBorder().getBorderInsets(this);
                gg.translate(i.left, i.top);
            }
            gg.drawImage(this.pixelsIm, 0, 0, this.pWidth, this.pHeight, null);
            int newScaleFactor = this.scaleFactor;
            if (g instanceof SunGraphics2D) {
                newScaleFactor = ((SunGraphics2D)g).surfaceData.getDefaultScale();
            }
            if (this.scaleFactor != newScaleFactor) {
                this.resizePixelBuffer(newScaleFactor);
                this.scenePeer.setPixelScaleFactor(newScaleFactor);
                this.scaleFactor = newScaleFactor;
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        finally {
            if (gg != null) {
                gg.dispose();
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet() || this.scenePeer == null) {
            return super.getPreferredSize();
        }
        return new Dimension(this.pPreferredWidth, this.pPreferredHeight);
    }

    private boolean isFxEnabled() {
        return this.disableCount.get() == 0;
    }

    private void setFxEnabled(boolean enabled) {
        if (!enabled) {
            if (this.disableCount.incrementAndGet() == 1 && this.dnd != null) {
                this.dnd.removeNotify();
            }
        } else {
            if (this.disableCount.get() == 0) {
                return;
            }
            if (this.disableCount.decrementAndGet() == 0 && this.dnd != null) {
                this.dnd.addNotify();
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.registerFinishListener();
        AccessController.doPrivileged(() -> {
            this.getToolkit().addAWTEventListener(this.ungrabListener, -2147483632L);
            return null;
        });
        this.updateComponentSize();
        SwingFXUtils.runOnFxThread(() -> {
            if (this.stage != null && !this.stage.isShowing()) {
                this.stage.show();
                this.sendMoveEventToFX();
            }
        });
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (this.scenePeer == null) {
            return null;
        }
        return new InputMethodSupport.InputMethodRequestsAdapter(this.scenePeer.getInputMethodRequests());
    }

    @Override
    public void removeNotify() {
        SwingFXUtils.runOnFxThread(() -> {
            if (this.stage != null && this.stage.isShowing()) {
                this.stage.hide();
            }
        });
        this.pixelsIm = null;
        this.pWidth = 0;
        this.pHeight = 0;
        super.removeNotify();
        AccessController.doPrivileged(() -> {
            this.getToolkit().removeAWTEventListener(this.ungrabListener);
            return null;
        });
        this.getInputContext().removeNotify(this);
        this.deregisterFinishListener();
    }

    private void invokeOnClientEDT(Runnable r) {
        AppContext context = SunToolkit.targetToAppContext(this);
        if (context == null) {
            if (log.isLoggable(PlatformLogger.Level.FINE)) {
                log.fine("null AppContext encountered!");
            }
            return;
        }
        SunToolkit.postEvent(context, new InvocationEvent((Object)this, r));
    }

    private class HostContainer
    implements HostInterface {
        private HostContainer() {
        }

        @Override
        public void setEmbeddedStage(EmbeddedStageInterface embeddedStage) {
            JFXPanel.this.stagePeer = embeddedStage;
            if (JFXPanel.this.stagePeer == null) {
                return;
            }
            if (JFXPanel.this.pWidth > 0 && JFXPanel.this.pHeight > 0) {
                JFXPanel.this.stagePeer.setSize(JFXPanel.this.pWidth, JFXPanel.this.pHeight);
            }
            JFXPanel.this.invokeOnClientEDT(() -> {
                if (JFXPanel.this.isFocusOwner()) {
                    JFXPanel.this.stagePeer.setFocused(true, 0);
                }
            });
            JFXPanel.this.sendMoveEventToFX();
        }

        @Override
        public void setEmbeddedScene(EmbeddedSceneInterface embeddedScene) {
            if (JFXPanel.this.scenePeer == embeddedScene) {
                return;
            }
            JFXPanel.this.scenePeer = embeddedScene;
            if (JFXPanel.this.scenePeer == null) {
                JFXPanel.this.invokeOnClientEDT(() -> {
                    if (JFXPanel.this.dnd != null) {
                        JFXPanel.this.dnd.removeNotify();
                        JFXPanel.this.dnd = null;
                    }
                });
                return;
            }
            if (JFXPanel.this.pWidth > 0 && JFXPanel.this.pHeight > 0) {
                JFXPanel.this.scenePeer.setSize(JFXPanel.this.pWidth, JFXPanel.this.pHeight);
            }
            JFXPanel.this.scenePeer.setPixelScaleFactor(JFXPanel.this.scaleFactor);
            JFXPanel.this.invokeOnClientEDT(() -> {
                JFXPanel.this.dnd = new SwingDnD(JFXPanel.this, JFXPanel.this.scenePeer);
                JFXPanel.this.dnd.addNotify();
                if (JFXPanel.this.scenePeer != null) {
                    JFXPanel.this.scenePeer.setDragStartListener(JFXPanel.this.dnd.getDragStartListener());
                }
            });
        }

        @Override
        public boolean requestFocus() {
            return JFXPanel.this.requestFocusInWindow();
        }

        @Override
        public boolean traverseFocusOut(boolean forward) {
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            if (forward) {
                kfm.focusNextComponent(JFXPanel.this);
            } else {
                kfm.focusPreviousComponent(JFXPanel.this);
            }
            return true;
        }

        @Override
        public void setPreferredSize(int width, int height) {
            JFXPanel.this.invokeOnClientEDT(() -> {
                JFXPanel.this.pPreferredWidth = width;
                JFXPanel.this.pPreferredHeight = height;
                JFXPanel.this.revalidate();
            });
        }

        @Override
        public void repaint() {
            JFXPanel.this.invokeOnClientEDT(() -> JFXPanel.this.repaint());
        }

        @Override
        public void setEnabled(boolean enabled) {
            JFXPanel.this.setFxEnabled(enabled);
        }

        @Override
        public void setCursor(CursorFrame cursorFrame) {
            Cursor cursor = this.getPlatformCursor(cursorFrame);
            JFXPanel.this.invokeOnClientEDT(() -> JFXPanel.this.setCursor(cursor));
        }

        private Cursor getPlatformCursor(CursorFrame cursorFrame) {
            Cursor cachedPlatformCursor = cursorFrame.getPlatformCursor(Cursor.class);
            if (cachedPlatformCursor != null) {
                return cachedPlatformCursor;
            }
            Cursor platformCursor = SwingCursors.embedCursorToCursor(cursorFrame);
            cursorFrame.setPlatforCursor(Cursor.class, platformCursor);
            return platformCursor;
        }

        @Override
        public boolean grabFocus() {
            if (PlatformUtil.isLinux()) {
                return true;
            }
            JFXPanel.this.invokeOnClientEDT(() -> {
                Window window = SwingUtilities.getWindowAncestor(JFXPanel.this);
                if (window != null && JFXPanel.this.getToolkit() instanceof SunToolkit) {
                    ((SunToolkit)JFXPanel.this.getToolkit()).grab(window);
                }
            });
            return true;
        }

        @Override
        public void ungrabFocus() {
            if (PlatformUtil.isLinux()) {
                return;
            }
            JFXPanel.this.invokeOnClientEDT(() -> {
                Window window = SwingUtilities.getWindowAncestor(JFXPanel.this);
                if (window != null && JFXPanel.this.getToolkit() instanceof SunToolkit) {
                    ((SunToolkit)JFXPanel.this.getToolkit()).ungrab(window);
                }
            });
        }
    }
}

