/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import sun.awt.image.BufferedImageDevice;

public class BufferedImageGraphicsConfig
extends GraphicsConfiguration {
    private static final int numconfigs = 12;
    private static BufferedImageGraphicsConfig[] standardConfigs = new BufferedImageGraphicsConfig[12];
    private static BufferedImageGraphicsConfig[] scaledConfigs = new BufferedImageGraphicsConfig[12];
    GraphicsDevice gd;
    ColorModel model;
    Raster raster;
    int width;
    int height;
    private final double scaleX;
    private final double scaleY;

    public static BufferedImageGraphicsConfig getConfig(BufferedImage bufferedImage) {
        return BufferedImageGraphicsConfig.getConfig(bufferedImage, 1.0, 1.0);
    }

    public static BufferedImageGraphicsConfig getConfig(BufferedImage bufferedImage, double d, double d2) {
        BufferedImageGraphicsConfig bufferedImageGraphicsConfig;
        BufferedImageGraphicsConfig[] bufferedImageGraphicsConfigArray;
        int n = bufferedImage.getType();
        BufferedImageGraphicsConfig[] bufferedImageGraphicsConfigArray2 = bufferedImageGraphicsConfigArray = d == 1.0 && d2 == 1.0 ? standardConfigs : scaledConfigs;
        if (n > 0 && n < 12 && (bufferedImageGraphicsConfig = bufferedImageGraphicsConfigArray[n]) != null && bufferedImageGraphicsConfig.scaleX == d && bufferedImageGraphicsConfig.scaleY == d2) {
            return bufferedImageGraphicsConfig;
        }
        bufferedImageGraphicsConfig = new BufferedImageGraphicsConfig(bufferedImage, null, d, d2);
        if (n > 0 && n < 12) {
            bufferedImageGraphicsConfigArray[n] = bufferedImageGraphicsConfig;
        }
        return bufferedImageGraphicsConfig;
    }

    public BufferedImageGraphicsConfig(BufferedImage bufferedImage, Component component) {
        this(bufferedImage, component, 1.0, 1.0);
    }

    public BufferedImageGraphicsConfig(BufferedImage bufferedImage, Component component, double d, double d2) {
        if (component == null) {
            this.gd = new BufferedImageDevice(this);
        } else {
            Graphics2D graphics2D = (Graphics2D)component.getGraphics();
            this.gd = graphics2D.getDeviceConfiguration().getDevice();
        }
        this.model = bufferedImage.getColorModel();
        this.raster = bufferedImage.getRaster().createCompatibleWritableRaster(1, 1);
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        this.scaleX = d;
        this.scaleY = d2;
    }

    @Override
    public GraphicsDevice getDevice() {
        return this.gd;
    }

    @Override
    public BufferedImage createCompatibleImage(int n, int n2) {
        WritableRaster writableRaster = this.raster.createCompatibleWritableRaster(n, n2);
        return new BufferedImage(this.model, writableRaster, this.model.isAlphaPremultiplied(), null);
    }

    @Override
    public ColorModel getColorModel() {
        return this.model;
    }

    @Override
    public ColorModel getColorModel(int n) {
        if (this.model.getTransparency() == n) {
            return this.model;
        }
        switch (n) {
            case 1: {
                return new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                return ColorModel.getRGBdefault();
            }
        }
        return null;
    }

    @Override
    public AffineTransform getDefaultTransform() {
        return AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
    }

    @Override
    public AffineTransform getNormalizingTransform() {
        return new AffineTransform();
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(0, 0, this.width, this.height);
    }
}

