/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.util.ArrayDeque;
import java.util.Arrays;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinUtils;

final class IntArrayCache
implements MarlinConst {
    private final int arraySize;
    private final ArrayDeque<int[]> intArrays;
    private int getOp = 0;
    private int createOp = 0;
    private int returnOp = 0;

    void dumpStats() {
        if (this.getOp > 0) {
            MarlinUtils.logInfo("IntArrayCache[" + this.arraySize + "]: get: " + this.getOp + " created: " + this.createOp + " - returned: " + this.returnOp + " :: cache size: " + this.intArrays.size());
        }
    }

    IntArrayCache(int n) {
        this.arraySize = n;
        this.intArrays = new ArrayDeque(6);
    }

    int[] getArray() {
        int[] nArray;
        if (DO_STATS) {
            ++this.getOp;
        }
        if ((nArray = this.intArrays.pollLast()) != null) {
            return nArray;
        }
        if (DO_STATS) {
            ++this.createOp;
        }
        return new int[this.arraySize];
    }

    void putDirtyArray(int[] nArray, int n) {
        if (n != this.arraySize) {
            if (DO_CHECKS) {
                MarlinUtils.logInfo("ArrayCache: bad length = " + n);
            }
            return;
        }
        if (DO_STATS) {
            ++this.returnOp;
        }
        this.intArrays.addLast(nArray);
    }

    void putArray(int[] nArray, int n, int n2, int n3) {
        if (n != this.arraySize) {
            if (DO_CHECKS) {
                MarlinUtils.logInfo("ArrayCache: bad length = " + n);
            }
            return;
        }
        if (DO_STATS) {
            ++this.returnOp;
        }
        IntArrayCache.fill(nArray, n2, n3, 0);
        this.intArrays.addLast(nArray);
    }

    static void fill(int[] nArray, int n, int n2, int n3) {
        if (n2 != 0) {
            Arrays.fill(nArray, n, n2, n3);
        }
        if (DO_CHECKS) {
            IntArrayCache.check(nArray, n, n2, n3);
        }
    }

    static void check(int[] nArray, int n, int n2, int n3) {
        if (DO_CHECKS) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == n3) continue;
                MarlinUtils.logException("Invalid value at: " + i + " = " + nArray[i] + " from: " + n + " to: " + n2 + "\n" + Arrays.toString(nArray), new Throwable());
                Arrays.fill(nArray, n3);
                return;
            }
        }
    }
}

