/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoFactory;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionWorker {
    @NonNls
    private static final String AT = "at";
    private static final String AT_PREFIX = "at ";
    private static final String STANDALONE_AT = " at ";
    private final Project myProject;
    private Filter.Result myResult;
    private PsiClass[] myClasses;
    private PsiFile[] myFiles;
    private String myMethod;
    private Trinity<TextRange, TextRange, TextRange> myInfo;
    private final ExceptionInfoCache myCache;

    public ExceptionWorker(@NotNull ExceptionInfoCache cache) {
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/execution/filters/ExceptionWorker", "<init>"));
        }
        this.myClasses = PsiClass.EMPTY_ARRAY;
        this.myFiles = PsiFile.EMPTY_ARRAY;
        this.myProject = cache.getProject();
        this.myCache = cache;
    }

    public Filter.Result execute(String line, int textEndOffset) {
        Filter.Result result;
        ArrayList<VirtualFile> virtualFiles;
        this.myResult = null;
        this.myInfo = ExceptionWorker.parseExceptionLine(line);
        if (this.myInfo == null) {
            return null;
        }
        this.myMethod = ((TextRange)this.myInfo.getSecond()).substring(line);
        String fileAndLine = ((TextRange)this.myInfo.third).substring(line).trim();
        int colonIndex = fileAndLine.lastIndexOf(58);
        if (colonIndex < 0) {
            return null;
        }
        int lineNumber = ExceptionWorker.getLineNumber(fileAndLine.substring(colonIndex + 1));
        if (lineNumber < 0) {
            return null;
        }
        Pair<PsiClass[], PsiFile[]> pair = this.myCache.resolveClass(((TextRange)this.myInfo.first).substring(line).trim());
        this.myClasses = (PsiClass[])pair.first;
        this.myFiles = (PsiFile[])pair.second;
        if (this.myFiles.length == 0) {
            this.myFiles = PsiShortNamesCache.getInstance((Project)this.myProject).getFilesByName(fileAndLine.substring(0, colonIndex).trim());
        }
        if (this.myFiles.length == 0) {
            return null;
        }
        int textStartOffset = textEndOffset - line.length();
        int highlightStartOffset = textStartOffset + ((TextRange)this.myInfo.third).getStartOffset();
        int highlightEndOffset = textStartOffset + ((TextRange)this.myInfo.third).getEndOffset();
        ProjectFileIndex index = ProjectRootManager.getInstance(this.myProject).getFileIndex();
        ArrayList<VirtualFile> virtualFilesInLibraries = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> virtualFilesInContent = new ArrayList<VirtualFile>();
        for (PsiFile file : this.myFiles) {
            VirtualFile virtualFile2 = file.getVirtualFile();
            if (index.isInContent(virtualFile2)) {
                virtualFilesInContent.add(virtualFile2);
                continue;
            }
            virtualFilesInLibraries.add(virtualFile2);
        }
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
        if (virtualFilesInContent.isEmpty()) {
            Color libTextColor = UIUtil.getInactiveTextColor();
            attributes = attributes.clone();
            attributes.setForegroundColor(libTextColor);
            attributes.setEffectColor(libTextColor);
            virtualFiles = virtualFilesInLibraries;
        } else {
            virtualFiles = virtualFilesInContent;
        }
        HyperlinkInfo linkInfo = HyperlinkInfoFactory.getInstance().createMultipleFilesHyperlinkInfo(virtualFiles, lineNumber - 1, this.myProject);
        this.myResult = result = new Filter.Result(highlightStartOffset, highlightEndOffset, linkInfo, attributes);
        return result;
    }

    private static int getLineNumber(String lineString) {
        if (lineString.isEmpty() || lineString.length() > 9 || !Character.isDigit(lineString.charAt(0))) {
            return -1;
        }
        try {
            return Integer.parseInt(lineString);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public Filter.Result getResult() {
        return this.myResult;
    }

    public PsiClass getPsiClass() {
        return (PsiClass)ArrayUtil.getFirstElement((Object[])this.myClasses);
    }

    public String getMethod() {
        return this.myMethod;
    }

    public PsiFile getFile() {
        return (PsiFile)ArrayUtil.getFirstElement((Object[])this.myFiles);
    }

    public Trinity<TextRange, TextRange, TextRange> getInfo() {
        return this.myInfo;
    }

    @Nullable
    static Trinity<TextRange, TextRange, TextRange> parseExceptionLine(String line) {
        int startIdx;
        if (line.startsWith(AT_PREFIX)) {
            startIdx = 0;
        } else {
            startIdx = line.indexOf(STANDALONE_AT);
            if (startIdx < 0) {
                startIdx = line.indexOf(AT_PREFIX);
            }
            if (startIdx < 0) {
                startIdx = -1;
            }
        }
        int rParenIdx = -1;
        int rParenCandidate = line.lastIndexOf(41);
        while (rParenCandidate > 0) {
            if (Character.isDigit(line.charAt(rParenCandidate - 1))) {
                rParenIdx = rParenCandidate;
            }
            rParenCandidate = line.lastIndexOf(41, rParenCandidate - 1);
        }
        if (rParenIdx < 0) {
            return null;
        }
        int lParenIdx = line.lastIndexOf(40, rParenIdx);
        if (lParenIdx < 0) {
            return null;
        }
        int dotIdx = line.lastIndexOf(46, lParenIdx);
        if (dotIdx < 0 || dotIdx < startIdx) {
            return null;
        }
        int moduleIdx = line.indexOf(47);
        int classNameIdx = moduleIdx > -1 && moduleIdx < lParenIdx && moduleIdx < dotIdx ? moduleIdx + 1 : startIdx + 1 + (startIdx >= 0 ? AT.length() : 0);
        return Trinity.create((Object)new TextRange(classNameIdx, ExceptionWorker.handleSpaces(line, dotIdx, -1)), (Object)new TextRange(ExceptionWorker.handleSpaces(line, dotIdx + 1, 1), ExceptionWorker.handleSpaces(line, lParenIdx, -1)), (Object)new TextRange(lParenIdx + 1, rParenIdx));
    }

    private static int handleSpaces(String line, int pos, int delta) {
        char c;
        int len = line.length();
        while (pos >= 0 && pos < len && Character.isSpaceChar(c = line.charAt(pos))) {
            pos += delta;
        }
        return pos;
    }
}

