/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CharsetEP
implements PatchEP {
    private static final Key<Map<String, String>> ourName = Key.create((String)"Charset");
    private final Project myProject;
    private final String myBaseDir;

    public CharsetEP(Project project) {
        this.myProject = project;
        this.myBaseDir = this.myProject.getBaseDir().getPath();
    }

    @Override
    @NotNull
    public String getName() {
        if ("com.intellij.openapi.diff.impl.patch.CharsetEP" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/patch/CharsetEP", "getName"));
        }
        return "com.intellij.openapi.diff.impl.patch.CharsetEP";
    }

    @Override
    public CharSequence provideContent(@NotNull String path2, CommitContext commitContext) {
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/diff/impl/patch/CharsetEP", "provideContent"));
        }
        File file = new File(this.myBaseDir, path2);
        VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        return vf == null ? null : vf.getCharset().name();
    }

    @Override
    public void consumeContent(@NotNull String path2, @NotNull CharSequence content, CommitContext commitContext) {
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/diff/impl/patch/CharsetEP", "consumeContent"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/diff/impl/patch/CharsetEP", "consumeContent"));
        }
    }

    @Override
    public void consumeContentBeforePatchApplied(@NotNull String path2, @NotNull CharSequence content, CommitContext commitContext) {
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/diff/impl/patch/CharsetEP", "consumeContentBeforePatchApplied"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/diff/impl/patch/CharsetEP", "consumeContentBeforePatchApplied"));
        }
        if (commitContext == null) {
            return;
        }
        Map<String, String> map = commitContext.getUserData(ourName);
        if (map == null) {
            map = new HashMap<String, String>();
            commitContext.putUserData(ourName, map);
        }
        File file = new File(this.myBaseDir, path2);
        map.put(FilePathsHelper.convertPath(file.getPath()), content.toString());
    }

    public static String getCharset(String path2, CommitContext commitContext) {
        if (commitContext == null) {
            return null;
        }
        Map<String, String> userData = commitContext.getUserData(ourName);
        return userData == null ? null : userData.get(FilePathsHelper.convertPath(path2));
    }
}

