/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBList;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathEditor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.ui.PathEditor");
    public static final Color INVALID_COLOR = new JBColor(new Color(210, 0, 0), (Color)JBColor.RED);
    protected JPanel myPanel;
    private JBList myList;
    private final DefaultListModel myModel;
    private final Set<VirtualFile> myAllFiles = new com.intellij.util.containers.HashSet();
    private boolean myModified = false;
    protected boolean myEnabled = false;
    private final FileChooserDescriptor myDescriptor;
    private VirtualFile myAddBaseDir;

    public PathEditor(FileChooserDescriptor descriptor) {
        this.myDescriptor = descriptor;
        this.myModel = this.createListModel();
    }

    public void setAddBaseDir(@Nullable VirtualFile addBaseDir) {
        this.myAddBaseDir = addBaseDir;
    }

    protected void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    protected void setModified(boolean modified) {
        this.myModified = modified;
    }

    public boolean isModified() {
        return this.myModified;
    }

    public VirtualFile[] getRoots() {
        int count = this.getRowCount();
        if (count == 0) {
            return VirtualFile.EMPTY_ARRAY;
        }
        VirtualFile[] roots = new VirtualFile[count];
        for (int i = 0; i < count; ++i) {
            roots[i] = this.getValueAt(i);
        }
        return roots;
    }

    public void resetPath(@NotNull List<VirtualFile> paths) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/openapi/projectRoots/ui/PathEditor", "resetPath"));
        }
        this.keepSelectionState();
        this.clearList();
        this.setEnabled(true);
        for (VirtualFile file : paths) {
            this.addElement(file);
        }
        this.setModified(false);
    }

    public JComponent createComponent() {
        this.myList = new JBList((ListModel)this.getListModel());
        this.myList.setCellRenderer(this.createListCellRenderer(this.myList));
        TreeUIHelper.getInstance().installListSpeedSearch(this.myList, new Convertor<Object, String>(){

            public String convert(Object file) {
                return ((VirtualFile)file).getPresentableUrl();
            }
        });
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator(this.myList).disableUpDownActions().setAddActionUpdater(new AnActionButtonUpdater(){

            @Override
            public boolean isEnabled(AnActionEvent e) {
                return PathEditor.this.myEnabled;
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            @Override
            public boolean isEnabled(AnActionEvent e) {
                return PathEditor.this.isRemoveActionEnabled(PathEditor.this.getSelectedRoots());
            }
        }).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Object[] added = PathEditor.this.doAddItems();
                if (added.length > 0) {
                    PathEditor.this.setModified(true);
                }
                PathEditor.this.requestDefaultFocus();
                PathEditor.this.setSelectedRoots(added);
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int[] indices = PathEditor.this.myList.getSelectedIndices();
                PathEditor.this.doRemoveItems(indices, PathEditor.this.myList);
            }
        });
        this.addToolbarButtons(toolbarDecorator);
        this.myPanel = toolbarDecorator.createPanel();
        this.myPanel.setBorder(null);
        return this.myPanel;
    }

    protected void addToolbarButtons(ToolbarDecorator toolbarDecorator) {
    }

    protected boolean isRemoveActionEnabled(Object[] values) {
        return values.length > 0 && this.myEnabled;
    }

    protected VirtualFile[] doAddItems() {
        Project project = CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(this.myPanel));
        VirtualFile[] files = FileChooser.chooseFiles(this.myDescriptor, this.myPanel, project, this.myAddBaseDir);
        if (files.length == 0) {
            return VirtualFile.EMPTY_ARRAY;
        }
        files = this.adjustAddedFileSet(this.myPanel, files);
        ArrayList<VirtualFile> added = new ArrayList<VirtualFile>(files.length);
        for (VirtualFile vFile : files) {
            if (!this.addElement(vFile)) continue;
            added.add(vFile);
        }
        return VfsUtilCore.toVirtualFileArray(added);
    }

    protected void doRemoveItems(int[] indices, JList list) {
        List removedItems = ListUtil.removeIndices(list, indices);
        this.itemsRemoved(removedItems);
    }

    protected DefaultListModel createListModel() {
        return new DefaultListModel();
    }

    protected ListCellRenderer createListCellRenderer(JBList list) {
        return new PathCellRenderer();
    }

    protected void itemsRemoved(List removedItems) {
        this.myAllFiles.removeAll(removedItems);
        if (removedItems.size() > 0) {
            this.setModified(true);
        }
        this.requestDefaultFocus();
    }

    protected VirtualFile[] adjustAddedFileSet(Component component, VirtualFile[] files) {
        return files;
    }

    protected boolean isUrlInserted() {
        if (this.getRowCount() > 0) {
            return ((VirtualFile)this.getListModel().lastElement()).getFileSystem() instanceof HttpFileSystem;
        }
        return false;
    }

    protected void requestDefaultFocus() {
        if (this.myList != null) {
            this.myList.requestFocus();
        }
    }

    public void addPaths(VirtualFile ... paths) {
        boolean added = false;
        this.keepSelectionState();
        for (VirtualFile path2 : paths) {
            if (!this.addElement(path2)) continue;
            added = true;
        }
        if (added) {
            this.setModified(true);
        }
    }

    public void removePaths(VirtualFile ... paths) {
        HashSet<VirtualFile> pathsSet = new HashSet<VirtualFile>(Arrays.asList(paths));
        int size = this.getRowCount();
        TIntArrayList indicesToRemove = new TIntArrayList(paths.length);
        for (int idx = 0; idx < size; ++idx) {
            VirtualFile path2 = this.getValueAt(idx);
            if (!pathsSet.contains(path2)) continue;
            indicesToRemove.add(idx);
        }
        List list = ListUtil.removeIndices(this.myList, indicesToRemove.toNativeArray());
        this.itemsRemoved(list);
    }

    protected boolean addElement(VirtualFile item) {
        if (item == null) {
            return false;
        }
        if (this.myAllFiles.contains(item)) {
            return false;
        }
        if (this.isUrlInserted()) {
            this.getListModel().insertElementAt(item, this.getRowCount() - 1);
        } else {
            this.getListModel().addElement(item);
        }
        this.myAllFiles.add(item);
        return true;
    }

    protected DefaultListModel getListModel() {
        return this.myModel;
    }

    protected void setSelectedRoots(Object[] roots) {
        ArrayList<Object> rootsList = new ArrayList<Object>(roots.length);
        for (Object root : roots) {
            if (root == null) continue;
            rootsList.add(root);
        }
        this.myList.getSelectionModel().clearSelection();
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            VirtualFile currObject = this.getValueAt(i);
            LOG.assertTrue(currObject != null);
            if (!rootsList.contains(currObject)) continue;
            this.myList.getSelectionModel().addSelectionInterval(i, i);
        }
    }

    private void keepSelectionState() {
        Object[] selectedItems = this.getSelectedRoots();
        if (selectedItems != null) {
            SwingUtilities.invokeLater(() -> this.setSelectedRoots(selectedItems));
        }
    }

    protected Object[] getSelectedRoots() {
        return this.myList.getSelectedValues();
    }

    protected int getRowCount() {
        return this.getListModel().getSize();
    }

    protected VirtualFile getValueAt(int row) {
        return (VirtualFile)this.getListModel().get(row);
    }

    public void clearList() {
        this.getListModel().clear();
        this.myAllFiles.clear();
        this.setModified(true);
    }

    private static boolean isJarFile(final VirtualFile file) {
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            public Boolean compute() {
                VirtualFile tempFile = file;
                if (file.getFileSystem() instanceof JarFileSystem && file.getParent() == null) {
                    String path2 = file.getPath().substring(0, file.getPath().length() - "!/".length());
                    tempFile = LocalFileSystem.getInstance().findFileByPath(path2);
                }
                if (tempFile != null && !tempFile.isDirectory()) {
                    return tempFile.getFileType().equals(FileTypes.ARCHIVE);
                }
                return Boolean.FALSE;
            }
        });
    }

    private static Icon getIconForRoot(Object projectRoot) {
        if (projectRoot instanceof VirtualFile) {
            VirtualFile file = (VirtualFile)projectRoot;
            if (!file.isValid()) {
                return AllIcons.Nodes.PpInvalid;
            }
            if (file.getFileSystem() instanceof HttpFileSystem) {
                return PlatformIcons.WEB_ICON;
            }
            if (PathEditor.isJarFile(file)) {
                return PlatformIcons.JAR_ICON;
            }
            return PlatformIcons.FILE_ICON;
        }
        return AllIcons.Nodes.EmptyNode;
    }

    protected static class PathCellRenderer
    extends DefaultListCellRenderer {
        protected PathCellRenderer() {
        }

        protected String getItemText(Object value) {
            return value instanceof VirtualFile ? ((VirtualFile)value).getPresentableUrl() : "UNKNOWN OBJECT";
        }

        protected Icon getItemIcon(Object value) {
            return PathEditor.getIconForRoot(value);
        }

        @Override
        public final Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, this.getItemText(value), index, isSelected, cellHasFocus);
            if (isSelected) {
                this.setForeground(UIUtil.getListSelectionForeground());
            } else if (value instanceof VirtualFile && !((VirtualFile)value).isValid()) {
                this.setForeground(INVALID_COLOR);
            }
            this.setIcon(this.getItemIcon(value));
            return this;
        }
    }
}

