/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.popup.util;

import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseStep;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseListPopupStep<T>
extends BaseStep<T>
implements ListPopupStep<T> {
    private String myTitle;
    private List<T> myValues;
    private List<Icon> myIcons;
    private int myDefaultOptionIndex;

    @SafeVarargs
    public BaseListPopupStep(@Nullable String title, T ... values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/openapi/ui/popup/util/BaseListPopupStep", "<init>"));
        }
        this(title, values, new Icon[0]);
    }

    public BaseListPopupStep(@Nullable String title, List<? extends T> values) {
        this(title, values, (List<Icon>)new ArrayList<Icon>());
    }

    public BaseListPopupStep(@Nullable String title, T[] values, Icon[] icons) {
        this(title, Arrays.asList(values), Arrays.asList(icons));
    }

    public BaseListPopupStep(@Nullable String aTitle, @NotNull List<? extends T> aValues, Icon aSameIcon) {
        if (aValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aValues", "com/intellij/openapi/ui/popup/util/BaseListPopupStep", "<init>"));
        }
        this.myDefaultOptionIndex = -1;
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (int i = 0; i < aValues.size(); ++i) {
            icons.add(aSameIcon);
        }
        this.init(aTitle, aValues, icons);
    }

    public BaseListPopupStep(@Nullable String title, @NotNull List<? extends T> values, List<Icon> icons) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/openapi/ui/popup/util/BaseListPopupStep", "<init>"));
        }
        this.myDefaultOptionIndex = -1;
        this.init(title, values, icons);
    }

    protected BaseListPopupStep() {
        this.myDefaultOptionIndex = -1;
    }

    protected final void init(@Nullable String title, @NotNull List<? extends T> values, @Nullable List<Icon> icons) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/openapi/ui/popup/util/BaseListPopupStep", "init"));
        }
        this.myTitle = title;
        this.myValues = new ArrayList<T>(values);
        this.myIcons = icons;
    }

    @Override
    @Nullable
    public final String getTitle() {
        return this.myTitle;
    }

    @Override
    @NotNull
    public final List<T> getValues() {
        List<T> list = this.myValues;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/popup/util/BaseListPopupStep", "getValues"));
        }
        return list;
    }

    @Override
    public PopupStep onChosen(T selectedValue, boolean finalChoice) {
        return FINAL_CHOICE;
    }

    @Override
    public Icon getIconFor(T value) {
        int index = this.myValues.indexOf(value);
        if (index != -1 && this.myIcons != null && index < this.myIcons.size()) {
            return this.myIcons.get(index);
        }
        return null;
    }

    @Nullable
    public Color getBackgroundFor(T value) {
        return null;
    }

    @Nullable
    public Color getForegroundFor(T value) {
        return null;
    }

    @Override
    @NotNull
    public String getTextFor(T value) {
        String string = value.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/popup/util/BaseListPopupStep", "getTextFor"));
        }
        return string;
    }

    @Override
    @Nullable
    public ListSeparator getSeparatorAbove(T value) {
        return null;
    }

    @Override
    public boolean isSelectable(T value) {
        return true;
    }

    @Override
    public boolean hasSubstep(T selectedValue) {
        return false;
    }

    @Override
    public void canceled() {
    }

    public void setDefaultOptionIndex(int aDefaultOptionIndex) {
        this.myDefaultOptionIndex = aDefaultOptionIndex;
    }

    @Override
    public int getDefaultOptionIndex() {
        return this.myDefaultOptionIndex;
    }
}

