/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RefResolveService
extends AbstractProjectComponent {
    public static final boolean ENABLED = Boolean.getBoolean("ref.back");

    public RefResolveService(Project project) {
        super(project);
    }

    public static RefResolveService getInstance(Project project) {
        return project.getComponent(RefResolveService.class);
    }

    @Nullable(value="null means the service has not resolved all files and is not ready yet")
    public abstract int[] getBackwardIds(@NotNull VirtualFileWithId var1);

    @NotNull
    public abstract GlobalSearchScope restrictByBackwardIds(@NotNull VirtualFile var1, @NotNull GlobalSearchScope var2);

    public abstract boolean queue(@NotNull Collection<VirtualFile> var1, @NotNull Object var2);

    public abstract boolean isUpToDate();

    public abstract int getQueueSize();

    public abstract void addListener(@NotNull Disposable var1, @NotNull Listener var2);

    public static abstract class Listener {
        public void fileResolved(@NotNull VirtualFile virtualFile2) {
            if (virtualFile2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/RefResolveService$Listener", "fileResolved"));
            }
        }

        public void allFilesResolved() {
        }
    }
}

