/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StubBase<T extends PsiElement>
extends ObjectStubBase<StubElement>
implements StubElement<T> {
    private List<StubElement> myChildren;
    private final IStubElementType myElementType;
    private volatile T myPsi;
    private static final AtomicFieldUpdater<StubBase, PsiElement> ourPsiUpdater = AtomicFieldUpdater.forFieldOfType(StubBase.class, PsiElement.class);

    protected StubBase(StubElement parent, IStubElementType elementType) {
        super(parent);
        this.myElementType = elementType;
        if (parent != null) {
            if (((StubBase)parent).myChildren == null) {
                ((StubBase)parent).myChildren = new SmartList();
            }
            ((StubBase)parent).myChildren.add(this);
        }
    }

    @Override
    public StubElement getParentStub() {
        return (StubElement)this.myParent;
    }

    @Override
    @NotNull
    public List<StubElement> getChildrenStubs() {
        List list = (List)ObjectUtils.chooseNotNull(this.myChildren, Collections.emptyList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubBase", "getChildrenStubs"));
        }
        return list;
    }

    @Override
    @Nullable
    public <P extends PsiElement> StubElement<P> findChildStubByType(@NotNull IStubElementType<?, P> elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/psi/stubs/StubBase", "findChildStubByType"));
        }
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int size = childrenStubs.size();
        for (int i = 0; i < size; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (childStub.getStubType() != elementType) continue;
            return childStub;
        }
        return null;
    }

    public void setPsi(@NotNull T psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/psi/stubs/StubBase", "setPsi"));
        }
        this.myPsi = psi;
    }

    @Nullable
    final T getCachedPsi() {
        return this.myPsi;
    }

    @Override
    public T getPsi() {
        Object psi = this.myPsi;
        if (psi != null) {
            return psi;
        }
        psi = this.getStubType().createPsi(this);
        return (T)(ourPsiUpdater.compareAndSet((Object)this, null, psi) ? psi : (PsiElement)ObjectUtils.assertNotNull(this.myPsi));
    }

    @Override
    @NotNull
    public <E extends PsiElement> E[] getChildrenByType(@NotNull IElementType elementType, E[] array) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/psi/stubs/StubBase", "getChildrenByType"));
        }
        int count = this.countChildren(elementType);
        array = (PsiElement[])ArrayUtil.ensureExactSize((int)count, (Object[])array);
        if (count == 0) {
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubBase", "getChildrenByType"));
            }
            return array;
        }
        this.fillFilteredChildren(elementType, (PsiElement[])array);
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubBase", "getChildrenByType"));
        }
        return array;
    }

    @Override
    @NotNull
    public <E extends PsiElement> E[] getChildrenByType(@NotNull TokenSet filter, E[] array) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/psi/stubs/StubBase", "getChildrenByType"));
        }
        int count = this.countChildren(filter);
        array = (PsiElement[])ArrayUtil.ensureExactSize((int)count, (Object[])array);
        if (count == 0) {
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubBase", "getChildrenByType"));
            }
            return array;
        }
        this.fillFilteredChildren(filter, (PsiElement[])array);
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubBase", "getChildrenByType"));
        }
        return array;
    }

    @Override
    @NotNull
    public <E extends PsiElement> E[] getChildrenByType(@NotNull IElementType elementType, @NotNull ArrayFactory<E> f) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/psi/stubs/StubBase", "getChildrenByType"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/psi/stubs/StubBase", "getChildrenByType"));
        }
        int count = this.countChildren(elementType);
        PsiElement[] result = (PsiElement[])f.create(count);
        if (count > 0) {
            this.fillFilteredChildren(elementType, result);
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubBase", "getChildrenByType"));
        }
        return result;
    }

    private int countChildren(IElementType elementType) {
        int count = 0;
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (childStub.getStubType() != elementType) continue;
            ++count;
        }
        return count;
    }

    private int countChildren(TokenSet types) {
        int count = 0;
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (!types.contains(childStub.getStubType())) continue;
            ++count;
        }
        return count;
    }

    private <E extends PsiElement> void fillFilteredChildren(IElementType type, E[] result) {
        int count = 0;
        for (StubElement childStub : this.getChildrenStubs()) {
            if (childStub.getStubType() != type) continue;
            result[count++] = childStub.getPsi();
        }
        assert (count == result.length);
    }

    private <E extends PsiElement> void fillFilteredChildren(TokenSet set, E[] result) {
        int count = 0;
        for (StubElement childStub : this.getChildrenStubs()) {
            if (!set.contains(childStub.getStubType())) continue;
            result[count++] = childStub.getPsi();
        }
        assert (count == result.length);
    }

    @Override
    @NotNull
    public <E extends PsiElement> E[] getChildrenByType(@NotNull TokenSet filter, @NotNull ArrayFactory<E> f) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/psi/stubs/StubBase", "getChildrenByType"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/psi/stubs/StubBase", "getChildrenByType"));
        }
        int count = this.countChildren(filter);
        PsiElement[] array = (PsiElement[])f.create(count);
        if (count == 0) {
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubBase", "getChildrenByType"));
            }
            return array;
        }
        this.fillFilteredChildren(filter, array);
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubBase", "getChildrenByType"));
        }
        return array;
    }

    @Override
    @Nullable
    public <E extends PsiElement> E getParentStubOfType(@NotNull Class<E> parentClass) {
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/psi/stubs/StubBase", "getParentStubOfType"));
        }
        for (StubElement parent = (StubElement)this.myParent; parent != null; parent = parent.getParentStub()) {
            Object psi = parent.getPsi();
            if (!parentClass.isInstance(psi)) continue;
            return (E)psi;
        }
        return null;
    }

    @Override
    public IStubElementType getStubType() {
        return this.myElementType;
    }

    public Project getProject() {
        return this.getPsi().getProject();
    }

    public String printTree() {
        StringBuilder builder = new StringBuilder();
        this.printTree(builder, 0);
        return builder.toString();
    }

    private void printTree(StringBuilder builder, int nestingLevel) {
        for (int i = 0; i < nestingLevel; ++i) {
            builder.append("  ");
        }
        builder.append(this.toString()).append('\n');
        for (StubElement child : this.getChildrenStubs()) {
            ((StubBase)child).printTree(builder, nestingLevel + 1);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

