/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FindClassUtil {
    @NotNull
    public static Collection<Module> findModulesWithClass(@NotNull Project project, @NonNls @NotNull String qualifiedName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/util/FindClassUtil", "findModulesWithClass"));
        }
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/util/FindClassUtil", "findModulesWithClass"));
        }
        GlobalSearchScope allScope = GlobalSearchScope.allScope(project);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass[] possibleClasses = facade.findClasses(qualifiedName, allScope);
        if (possibleClasses.length == 0) {
            List<Module> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/FindClassUtil", "findModulesWithClass"));
            }
            return list;
        }
        LinkedHashSet relevantModules = ContainerUtil.newLinkedHashSet();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        for (PsiClass aClass : possibleClasses) {
            VirtualFile classFile = aClass.getContainingFile().getVirtualFile();
            for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(classFile)) {
                relevantModules.add(orderEntry.getOwnerModule());
            }
        }
        LinkedHashSet linkedHashSet = relevantModules;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/FindClassUtil", "findModulesWithClass"));
        }
        return linkedHashSet;
    }
}

