/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.ui.ComponentSettings;
import com.intellij.ui.InputSource;
import com.intellij.ui.components.Adjuster;
import com.intellij.ui.components.DefaultScrollBarUI;
import com.intellij.ui.components.FinelyAdjustable;
import com.intellij.ui.components.Interpolable;
import com.intellij.ui.components.Interpolator;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.MacScrollBarUI;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.RegionPainter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ScrollBarUI;
import org.intellij.lang.annotations.JdkConstants;

public class JBScrollBar
extends JScrollBar
implements IdeGlassPane.TopComponent,
Interpolable,
FinelyAdjustable {
    public static final Key<RegionPainter<Object>> TRACK = Key.create((String)"JB_SCROLL_BAR_TRACK");
    private static final double THRESHOLD = 1.00001;
    private static final boolean SUPPORTED_JAVA = SystemInfo.isJetbrainsJvm || SystemInfo.isJavaVersionAtLeast((String)"1.9");
    private final Interpolator myInterpolator = new Interpolator(this::getValue, this::setCurrentValue);
    private final Adjuster myAdjuster = new Adjuster((Consumer<Integer>)((Consumer)delta -> this.setValue(this.getTargetValue() + delta)));
    private boolean isUnitIncrementSet;
    private boolean isBlockIncrementSet;

    public JBScrollBar() {
        this(1);
    }

    public JBScrollBar(@JdkConstants.AdjustableOrientation int orientation) {
        this(orientation, 0, 10, 0, 100);
    }

    public JBScrollBar(@JdkConstants.AdjustableOrientation int orientation, int value, int extent, int min, int max) {
        super(orientation, value, extent, min, max);
        if (SystemProperties.isTrueSmoothScrollingEnabled()) {
            this.setModel(new Model(value, extent, min, max));
        }
        this.putClientProperty("JScrollBar.fastWheelScrolling", Boolean.TRUE);
    }

    @Override
    public void updateUI() {
        ScrollBarUI ui = this.getUI();
        if (ui instanceof DefaultScrollBarUI) {
            return;
        }
        this.setUI(JBScrollBar.createUI(this));
    }

    public static ScrollBarUI createUI(JComponent c) {
        return SystemInfo.isMac ? new MacScrollBarUI() : new DefaultScrollBarUI();
    }

    @Override
    public int getUnitIncrement(int direction) {
        JViewport viewport = this.getViewport();
        if (viewport != null) {
            Font font;
            Scrollable scrollable = this.getScrollableViewToCalculateIncrement(viewport.getView());
            if (scrollable != null) {
                return scrollable.getScrollableUnitIncrement(viewport.getViewRect(), this.orientation, direction);
            }
            if (!this.isUnitIncrementSet && (font = JBScrollBar.getViewFont(viewport)) != null) {
                return font.getSize();
            }
        }
        return super.getUnitIncrement(direction);
    }

    @Override
    public void setUnitIncrement(int increment) {
        this.isUnitIncrementSet = true;
        super.setUnitIncrement(increment);
    }

    @Override
    public int getBlockIncrement(int direction) {
        JViewport viewport = this.getViewport();
        if (viewport != null) {
            Scrollable scrollable = this.getScrollableViewToCalculateIncrement(viewport.getView());
            if (scrollable != null) {
                return scrollable.getScrollableBlockIncrement(viewport.getViewRect(), this.orientation, direction);
            }
            if (!this.isBlockIncrementSet) {
                Dimension size = viewport.getExtentSize();
                return this.orientation == 0 ? size.width : size.height;
            }
        }
        return super.getBlockIncrement(direction);
    }

    @Override
    public void setBlockIncrement(int increment) {
        this.isBlockIncrementSet = true;
        super.setBlockIncrement(increment);
    }

    @Override
    public boolean canBePreprocessed(MouseEvent event) {
        return JBScrollPane.canBePreprocessed(event, this);
    }

    @Override
    public void setValue(int value) {
        InputSource source;
        ComponentSettings settings;
        JBScrollPane pane;
        JViewport viewport;
        Container parent = this.getParent();
        if (parent instanceof JBScrollPane && (viewport = (pane = (JBScrollPane)parent).getViewport()) != null && (settings = ComponentSettings.getInstance()).isTrueSmoothScrollingEligibleFor(viewport.getView()) && settings.isInterpolationEligibleFor(this) && settings.isInterpolationEnabledFor(source = pane.getInputSource(this.getValueIsAdjusting()))) {
            this.myInterpolator.setTarget(value, pane.getInitialDelay(source));
            return;
        }
        super.setValue(value);
    }

    @Override
    public void setCurrentValue(int value) {
        super.setValue(value);
        this.myAdjuster.reset();
    }

    @Override
    public int getTargetValue() {
        return this.myInterpolator.getTarget();
    }

    @Override
    public void adjustValue(double delta) {
        this.myAdjuster.adjustValue(delta);
    }

    public boolean handleMouseWheelEvent(MouseWheelEvent event) {
        if (0 != event.getScrollType()) {
            return false;
        }
        if (event.isShiftDown() == (this.orientation == 1)) {
            return false;
        }
        ComponentSettings settings = ComponentSettings.getInstance();
        if (!settings.isTrueSmoothScrollingEligibleFor(this)) {
            return false;
        }
        double delta = this.getDelta(event);
        if (delta == 0.0 || !Double.isFinite(delta)) {
            return false;
        }
        int value = this.getTargetValue();
        double minDelta = (double)this.getMinimum() - (double)value;
        double maxDelta = (double)this.getMaximum() - (double)this.getVisibleAmount() - (double)value;
        this.adjustValue(Math.max(minDelta, Math.min(maxDelta, delta)));
        event.consume();
        return true;
    }

    private JViewport getViewport() {
        Container parent = this.getParent();
        if (parent instanceof JScrollPane) {
            JScrollPane pane = (JScrollPane)parent;
            return pane.getViewport();
        }
        return null;
    }

    private static Font getViewFont(JViewport viewport) {
        if (viewport == null) {
            return null;
        }
        Component view = viewport.getView();
        return view == null ? null : view.getFont();
    }

    private Scrollable getScrollableViewToCalculateIncrement(Component view) {
        return view instanceof JTable || view instanceof Scrollable && this.orientation == 1 ? (Scrollable)((Object)view) : null;
    }

    private static double boundDelta(double minDelta, double maxDelta, double delta) {
        return Math.max(minDelta, Math.min(maxDelta, delta));
    }

    static boolean hasDelta(MouseWheelEvent event) {
        double rotation = event.getPreciseWheelRotation();
        if (rotation == 0.0 || !Double.isFinite(rotation)) {
            return false;
        }
        ComponentSettings settings = ComponentSettings.getInstance();
        if (SUPPORTED_JAVA && settings.isPixelPerfectScrollingEnabled()) {
            if (SystemInfo.isMac && Registry.is((String)"ide.scroll.precise.rotation.mac")) {
                return true;
            }
            if (SystemInfo.isWindows && Registry.is((String)"ide.scroll.precise.rotation.windows")) {
                return true;
            }
        }
        return settings.isHighPrecisionScrollingEnabled();
    }

    private double getDelta(MouseWheelEvent event) {
        double rotation = event.getPreciseWheelRotation();
        ComponentSettings settings = ComponentSettings.getInstance();
        if (SUPPORTED_JAVA && settings.isPixelPerfectScrollingEnabled()) {
            if (SystemInfo.isMac && Registry.is((String)"ide.scroll.precise.rotation.mac")) {
                return 10.0 * rotation;
            }
            if (SystemInfo.isWindows && Registry.is((String)"ide.scroll.precise.rotation.windows")) {
                JViewport viewport = this.getViewport();
                Font font = viewport == null ? null : JBScrollBar.getViewFont(viewport);
                int size = font == null ? JBUI.scale((int)10) : font.getSize();
                return (double)size * rotation * (double)event.getScrollAmount();
            }
        }
        if (settings.isHighPrecisionScrollingEnabled()) {
            int direction = rotation < 0.0 ? -1 : 1;
            int unitIncrement = this.getUnitIncrement(direction);
            double delta = (double)unitIncrement * rotation * (double)event.getScrollAmount();
            if (-1.00001 > delta && delta > 1.00001) {
                return delta;
            }
            double blockIncrement = this.getBlockIncrement(direction);
            return JBScrollBar.boundDelta(-blockIncrement, blockIncrement, delta);
        }
        return 0.0;
    }

    private static final class Model
    extends DefaultBoundedRangeModel {
        private Model(int value, int extent, int min, int max) {
            super(value, extent, min, max);
        }

        @Override
        protected void fireStateChanged() {
            if (this.getValueIsAdjusting() && ComponentSettings.getInstance().isInterpolationEnabledFor(InputSource.SCROLLBAR)) {
                Object[] listeners = this.listenerList.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    ChangeListener listener;
                    if (listeners[i] != ChangeListener.class || (listener = (ChangeListener)listeners[i + 1]).getClass().getName().contains("ScrollBarUI")) continue;
                    if (this.changeEvent == null) {
                        this.changeEvent = new ChangeEvent(this);
                    }
                    listener.stateChanged(this.changeEvent);
                }
            } else {
                super.fireStateChanged();
            }
        }
    }
}

