/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.components.ZoomableViewport;
import com.intellij.ui.components.ZoomingDelegate;
import com.intellij.ui.table.JBTable;
import com.intellij.util.MethodInvocator;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseWheelEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.RepaintManager;
import javax.swing.Scrollable;
import javax.swing.Timer;
import javax.swing.ViewportLayout;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import org.jetbrains.annotations.Nullable;

public class JBViewport
extends JViewport
implements ZoomableViewport {
    private static final MethodInvocator ourCanUseWindowBlitterMethod = new MethodInvocator(JViewport.class, "canUseWindowBlitter", new Class[0]);
    private static final MethodInvocator ourGetPaintManagerMethod = new MethodInvocator(RepaintManager.class, "getPaintManager", new Class[0]);
    private static final MethodInvocator ourGetUseTrueDoubleBufferingMethod = new MethodInvocator(JRootPane.class, "getUseTrueDoubleBuffering", new Class[0]);
    private static final RegistryValue CAPABILITIES_DEBUG = Registry.get((String)"idea.true.smooth.scrolling.debug");
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup("scrolling-capabilities-debug");
    private static final int NOTIFICATION_TIMEOUT = 1500;
    private Notification myPreviousNotification;
    private static final ViewportLayout ourLayoutManager = new ViewportLayout(){

        @Override
        public void layoutContainer(Container parent) {
            JViewport viewport;
            Component view;
            if (parent instanceof JViewport && (view = (viewport = (JViewport)parent).getView()) != null) {
                Container grand = viewport.getParent();
                if (grand instanceof JScrollPane) {
                    JBViewport.doLayout((JScrollPane)grand, viewport, view);
                } else {
                    super.layoutContainer(parent);
                }
            }
        }
    };
    private StatusText myEmptyText;
    private boolean myPaintingNow;
    private ZoomingDelegate myZoomer;
    private volatile boolean myBackgroundRequested;
    private boolean myUpdateViewPosition;
    private final ViewPosition myViewX = new ViewPosition();
    private final ViewPosition myViewY = new ViewPosition();

    public JBViewport() {
        this.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component child = e.getChild();
                if (child instanceof JBTable) {
                    JBViewport.this.myEmptyText = ((ComponentWithEmptyText)((Object)child)).getEmptyText();
                    JBViewport.this.myEmptyText.attachTo(JBViewport.this, child);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component child = e.getChild();
                if (child instanceof JBTable) {
                    ((ComponentWithEmptyText)((Object)child)).getEmptyText().attachTo(child);
                    JBViewport.this.myEmptyText = null;
                }
            }
        });
    }

    @Override
    public void setViewPosition(Point p) {
        if (CAPABILITIES_DEBUG.asBoolean() && !p.equals(this.getViewPosition()) && !this.isInsideLogToolWindow()) {
            this.checkScrollingCapabilities();
        }
        if (this.myUpdateViewPosition) {
            return;
        }
        this.myViewX.set(p.x);
        this.myViewY.set(p.y);
        super.setViewPosition(p);
    }

    void updateViewPosition(MouseWheelEvent event) {
        Component view = this.getView();
        if (view == null) {
            return;
        }
        if (event.isShiftDown() ? !this.myViewX.update(view, event, view.getWidth() - this.getWidth()) : !this.myViewY.update(view, event, view.getHeight() - this.getHeight())) {
            return;
        }
        try {
            this.myUpdateViewPosition = true;
            super.setViewPosition(new Point(this.myViewX.get(), this.myViewY.get()));
        }
        finally {
            this.myUpdateViewPosition = false;
        }
    }

    private static double getAbsoluteDelta(Component view, MouseWheelEvent event) {
        int unitSizeInPixels = 10;
        if (!SystemInfo.isMac) {
            Font font = view.getFont();
            unitSizeInPixels = font != null ? font.getSize() : JBUI.scale((int)10);
            unitSizeInPixels *= event.getScrollAmount();
        }
        return (double)unitSizeInPixels * event.getPreciseWheelRotation();
    }

    private boolean isInsideLogToolWindow() {
        Container parent3;
        Container parent2;
        Container parent1 = this.getParent();
        if (parent1 instanceof JScrollPane && (parent2 = parent1.getParent()) instanceof JPanel && (parent3 = parent2.getParent()) instanceof JPanel) {
            return parent3.getClass().getName().startsWith("com.intellij.notification.EventLogToolWindowFactory");
        }
        return false;
    }

    private void checkScrollingCapabilities() {
        if (this.myPreviousNotification == null || this.myPreviousNotification.isExpired()) {
            if (!Boolean.TRUE.equals(JBViewport.isWindowBlitterAvailableFor(this))) {
                this.myPreviousNotification = JBViewport.notify("Scrolling: cannot use window blitter");
            } else if (!Boolean.TRUE.equals(JBViewport.isTrueDoubleBufferingAvailableFor(this))) {
                this.myPreviousNotification = JBViewport.notify("Scrolling: cannot use true double buffering");
            }
        }
    }

    @Nullable
    private static Boolean isWindowBlitterAvailableFor(JViewport viewport) {
        if (ourCanUseWindowBlitterMethod.isAvailable()) {
            return (Boolean)ourCanUseWindowBlitterMethod.invoke((Object)viewport, new Object[0]);
        }
        return null;
    }

    @Nullable
    private static Boolean isTrueDoubleBufferingAvailableFor(JComponent component) {
        if (ourGetPaintManagerMethod.isAvailable()) {
            JRootPane rootPane;
            Object paintManager = ourGetPaintManagerMethod.invoke((Object)RepaintManager.currentManager(component), new Object[0]);
            if (!"javax.swing.BufferStrategyPaintManager".equals(paintManager.getClass().getName())) {
                return false;
            }
            if (ourGetUseTrueDoubleBufferingMethod.isAvailable() && (rootPane = component.getRootPane()) != null) {
                return (Boolean)ourGetUseTrueDoubleBufferingMethod.invoke((Object)rootPane, new Object[0]);
            }
        }
        return null;
    }

    private static Notification notify(String message) {
        Notification notification = NOTIFICATION_GROUP.createNotification(message, NotificationType.INFORMATION);
        notification.notify(null);
        Timer timer = new Timer(1500, event -> notification.expire());
        timer.setRepeats(false);
        timer.start();
        return notification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Color getBackground() {
        Component child;
        Color color = super.getBackground();
        if (!this.myBackgroundRequested && EventQueue.isDispatchThread() && Registry.is((String)"ide.scroll.background.auto") && (!this.isBackgroundSet() || color instanceof UIResource) && (child = this.getView()) != null) {
            try {
                this.myBackgroundRequested = true;
                Color color2 = child.getBackground();
                return color2;
            }
            finally {
                this.myBackgroundRequested = false;
            }
        }
        return color;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return ourLayoutManager;
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
    }

    @Override
    public void paint(Graphics g) {
        this.myPaintingNow = true;
        if (this.myZoomer != null && this.myZoomer.isActive()) {
            this.myZoomer.paint(g);
        } else {
            super.paint(g);
            if (this.myEmptyText != null) {
                this.myEmptyText.paint(this, g);
            }
        }
        this.myPaintingNow = false;
    }

    @Override
    @Nullable
    public Magnificator getMagnificator() {
        return (Magnificator)UIUtil.getClientProperty((Object)this.getView(), Magnificator.CLIENT_PROPERTY_KEY);
    }

    @Override
    public void magnificationStarted(Point at) {
        this.myZoomer = new ZoomingDelegate((JComponent)this.getView(), this);
        this.myZoomer.magnificationStarted(at);
    }

    @Override
    public void magnificationFinished(double magnification) {
        this.myZoomer.magnificationFinished(magnification);
        this.myZoomer = null;
    }

    @Override
    public void magnify(double magnification) {
        this.myZoomer.magnify(magnification);
    }

    public boolean isPaintingNow() {
        return this.myPaintingNow;
    }

    @Override
    public void scrollRectToVisible(Rectangle bounds) {
        Component view = this.getView();
        if (view instanceof JComponent && !this.isAutoscroll(bounds)) {
            JBInsets.addTo((Rectangle)bounds, (Insets)JBViewport.getViewInsets((JComponent)view));
        }
        super.scrollRectToVisible(bounds);
    }

    private boolean isAutoscroll(Rectangle bounds) {
        if ((bounds.x == -bounds.width || bounds.x == this.getWidth()) && bounds.y + bounds.height + bounds.y == this.getHeight()) {
            return true;
        }
        return (bounds.y == -bounds.height || bounds.y == this.getHeight()) && bounds.x + bounds.width + bounds.x == this.getWidth();
    }

    private static JBScrollPane.Alignment getAlignment(JScrollBar bar) {
        if (bar != null && bar.isVisible() && !bar.isOpaque()) {
            return (JBScrollPane.Alignment)((Object)UIUtil.getClientProperty((Object)bar, JBScrollPane.Alignment.class));
        }
        return null;
    }

    private static boolean isAlignmentNeeded(JComponent view, boolean horizontal) {
        return (!SystemInfo.isMac || horizontal && Registry.is((String)"mac.scroll.horizontal.gap")) && (view instanceof JList || view instanceof JTree || !SystemInfo.isMac && Registry.is((String)"ide.scroll.align.component"));
    }

    static Insets getViewInsets(JComponent view) {
        Border border = view.getBorder();
        if (border instanceof ViewBorder) {
            ViewBorder vb = (ViewBorder)border;
            JBInsets insets = JBUI.emptyInsets();
            vb.addViewInsets(view, (Insets)insets);
            return insets;
        }
        return null;
    }

    private static void doLayout(JScrollPane pane, JViewport viewport, Component view) {
        int maxY;
        JBViewport.updateBorder(view);
        Dimension actualSize = viewport.getSize();
        Dimension extentSize = viewport.toViewCoordinates(actualSize);
        Dimension viewPreferredSize = view.getPreferredSize();
        Dimension viewSize = new Dimension(viewPreferredSize);
        Point viewPosition = viewport.getViewPosition();
        Scrollable scrollable = null;
        if (view instanceof Scrollable) {
            scrollable = (Scrollable)((Object)view);
            if (scrollable.getScrollableTracksViewportWidth()) {
                viewSize.width = actualSize.width;
            }
            if (scrollable.getScrollableTracksViewportHeight()) {
                viewSize.height = actualSize.height;
            }
        }
        int maxX = viewSize.width - extentSize.width;
        if (scrollable == null || pane.getComponentOrientation().isLeftToRight()) {
            if (viewPosition.x > maxX) {
                viewPosition.x = Math.max(0, maxX);
            }
        } else {
            int n = viewPosition.x = maxX < 0 ? maxX : Math.max(0, Math.min(maxX, viewPosition.x));
        }
        if (viewPosition.y > (maxY = viewSize.height - extentSize.height)) {
            viewPosition.y = Math.max(0, maxY);
        }
        if (scrollable == null) {
            if (viewPosition.x == 0 && actualSize.width > viewPreferredSize.width) {
                viewSize.width = actualSize.width;
            }
            if (viewPosition.y == 0 && actualSize.height > viewPreferredSize.height) {
                viewSize.height = actualSize.height;
            }
        }
        if (!(view instanceof TypingTarget)) {
            if (31 == pane.getHorizontalScrollBarPolicy()) {
                viewPosition.x = 0;
                viewSize.width = extentSize.width;
            }
            if (21 == pane.getVerticalScrollBarPolicy()) {
                viewPosition.y = 0;
                viewSize.height = extentSize.height;
            }
        }
        viewport.setViewPosition(viewPosition);
        viewport.setViewSize(viewSize);
    }

    private static void updateBorder(Component view) {
        if (view instanceof JTable) {
            return;
        }
        if (view instanceof JComponent) {
            JComponent component = (JComponent)view;
            Border border = component.getBorder();
            if (border instanceof ViewBorder) {
                return;
            }
            component.setBorder(border == null || border instanceof UIResource ? new ResourceViewBorder(border) : new ViewBorder(border));
        }
    }

    private static final class ViewPosition {
        private int myValue;
        private int myDirection;
        private double myAccumulator;

        private ViewPosition() {
        }

        int get() {
            return this.myValue;
        }

        void set(int newValue) {
            this.myValue = newValue;
            this.myAccumulator = newValue;
        }

        boolean update(Component view, MouseWheelEvent event, int max) {
            int old = this.myValue;
            int reset = 0;
            if (max > 0) {
                int direction;
                double delta = JBViewport.getAbsoluteDelta(view, event);
                if (delta == 0.0 || !Double.isFinite(delta)) {
                    return false;
                }
                int n = direction = delta < 0.0 ? -1 : 1;
                if (direction != this.myDirection) {
                    this.myAccumulator = this.myValue;
                }
                this.myDirection = direction;
                this.myAccumulator += delta;
                this.myValue = (int)this.myAccumulator;
                if (0 <= this.myValue && this.myValue <= max) {
                    return this.myValue != old;
                }
                if (this.myValue > max) {
                    reset = max;
                }
            }
            this.set(reset);
            return reset != old;
        }
    }

    private static class ViewBorder
    extends AbstractBorder {
        private final Insets myInsets = JBUI.emptyInsets();
        private final Border myBorder;

        ViewBorder(Border border) {
            this.myBorder = border;
        }

        @Override
        public Insets getBorderInsets(Component view, Insets insets) {
            Insets inner;
            if (insets == null) {
                insets = JBUI.emptyInsets();
            } else {
                insets.set(0, 0, 0, 0);
            }
            if (this.myBorder != null && (inner = this.myBorder.getBorderInsets(view)) != null) {
                insets.set(inner.top, inner.left, inner.bottom, inner.right);
            }
            if (view instanceof JComponent) {
                this.addViewInsets((JComponent)view, insets);
            }
            if (!this.myInsets.equals(insets)) {
                this.myInsets.set(insets.top, insets.left, insets.bottom, insets.right);
                if (view instanceof JComponent) {
                    JTree tree;
                    TreeUI ui;
                    JComponent component = (JComponent)view;
                    if (component instanceof JTree && (ui = (tree = (JTree)component).getUI()) instanceof BasicTreeUI) {
                        BasicTreeUI basic = (BasicTreeUI)ui;
                        basic.setLeftChildIndent(basic.getLeftChildIndent());
                    }
                    component.revalidate();
                } else {
                    view.invalidate();
                    view.repaint();
                }
            }
            return insets;
        }

        @Override
        public void paintBorder(Component view, Graphics g, int x, int y, int width, int height) {
            if (this.myBorder != null) {
                this.myBorder.paintBorder(view, g, x, y, width, height);
            }
        }

        private void addViewInsets(JComponent view, Insets insets) {
            JViewport viewport;
            Container grand;
            Container parent;
            if (this == view.getBorder() && (parent = view.getParent()) instanceof JViewport && (grand = (viewport = (JViewport)parent).getParent()) instanceof JScrollPane) {
                JScrollPane pane = (JScrollPane)grand;
                if (viewport == pane.getViewport() || viewport == pane.getColumnHeader()) {
                    JScrollBar vsb = pane.getVerticalScrollBar();
                    JBScrollPane.Alignment va = JBViewport.getAlignment(vsb);
                    if (va == JBScrollPane.Alignment.LEFT) {
                        insets.left += vsb.getWidth();
                    } else if (va == JBScrollPane.Alignment.RIGHT && JBViewport.isAlignmentNeeded(view, false)) {
                        insets.right += vsb.getWidth();
                    }
                }
                if (viewport == pane.getViewport() || viewport == pane.getRowHeader()) {
                    JScrollBar hsb = pane.getHorizontalScrollBar();
                    JBScrollPane.Alignment ha = JBViewport.getAlignment(hsb);
                    if (ha == JBScrollPane.Alignment.TOP) {
                        insets.top += hsb.getHeight();
                    } else if (ha == JBScrollPane.Alignment.BOTTOM && JBViewport.isAlignmentNeeded(view, true)) {
                        insets.bottom += hsb.getHeight();
                    }
                }
            }
        }
    }

    private static class ResourceViewBorder
    extends ViewBorder
    implements UIResource {
        ResourceViewBorder(Border border) {
            super(border);
        }
    }
}

