/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.ui.ComponentSettings;
import com.intellij.ui.InputSource;
import com.intellij.ui.components.Adjuster;
import com.intellij.ui.components.FinelyAdjustable;
import com.intellij.ui.components.Interpolable;
import com.intellij.ui.components.Interpolator;
import com.intellij.ui.components.MouseWheelEventEx;
import com.intellij.ui.components.SmoothBoundedRangeModel;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.reflect.Field;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import org.jetbrains.annotations.Nullable;

public class SmoothScrollPane
extends JScrollPane {
    private static final Logger LOG = Logger.getInstance(SmoothScrollPane.class);
    private static final double EPSILON = 1.0E-5;
    private static final RegistryValue SCROLLBAR_DELAY = Registry.get((String)"idea.true.smooth.scrolling.interpolation.scrollbar.delay");
    private static final RegistryValue PRECISION_TOUCHPAD_DELAY = Registry.get((String)"idea.true.smooth.scrolling.interpolation.precision.touchpad.delay");
    private static final RegistryValue MOUSE_WHEEL_MIN_DELAY = Registry.get((String)"idea.true.smooth.scrolling.interpolation.mouse.wheel.delay.min");
    private static final RegistryValue MOUSE_WHEEL_MAX_DELAY = Registry.get((String)"idea.true.smooth.scrolling.interpolation.mouse.wheel.delay.max");
    private static final RegistryValue DEFAULT_DELAY = Registry.get((String)"idea.true.smooth.scrolling.interpolation.other.delay");
    private InputSource myInputSource = InputSource.UNKNOWN;
    private double myWheelRotation;

    public SmoothScrollPane() {
    }

    public SmoothScrollPane(Component view) {
        super(view);
    }

    public SmoothScrollPane(int vsbPolicy, int hsbPolicy) {
        super(vsbPolicy, hsbPolicy);
    }

    public SmoothScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e) {
        boolean hasAbsoluteDelta = ComponentSettings.getInstance().isPixelPerfectScrollingEnabled() && MouseWheelEventEx.getAbsoluteDelta(e) != 0.0;
        this.myInputSource = hasAbsoluteDelta ? InputSource.PRECISION_TOUCHPAD : InputSource.MOUSE_WHEEL;
        this.myWheelRotation = e.getPreciseWheelRotation();
        super.processMouseWheelEvent(e);
        this.myInputSource = InputSource.UNKNOWN;
    }

    @Override
    public JScrollBar createVerticalScrollBar() {
        return new SmoothScrollBar(1);
    }

    @Override
    public JScrollBar createHorizontalScrollBar() {
        return new SmoothScrollBar(0);
    }

    @Override
    public void setUI(ScrollPaneUI ui) {
        super.setUI(ui);
        if (ui instanceof BasicScrollPaneUI) {
            try {
                Field field = BasicScrollPaneUI.class.getDeclaredField("mouseScrollListener");
                field.setAccessible(true);
                Object value = field.get(ui);
                if (value instanceof MouseWheelListener) {
                    MouseWheelListener oldListener = (MouseWheelListener)value;
                    MouseWheelListener newListener = e -> this.handleMouseWheelEvent(e, oldListener);
                    field.set(ui, newListener);
                    this.removeMouseWheelListener(oldListener);
                    this.addMouseWheelListener(newListener);
                }
            }
            catch (Exception exception) {
                LOG.warn((Throwable)exception);
            }
        }
    }

    private void handleMouseWheelEvent(MouseWheelEvent e, MouseWheelListener delegate) {
        ComponentSettings settings = ComponentSettings.getInstance();
        if (settings.isTrueSmoothScrollingEligibleFor(this) && settings.isHighPrecisionScrollingEnabled() && this.isWheelScrollingEnabled() && e.getScrollType() == 0) {
            this.mouseWheelMoved(e);
            e.consume();
        } else {
            delegate.mouseWheelMoved(e);
        }
    }

    private void mouseWheelMoved(MouseWheelEvent e) {
        JScrollBar scrollbar = e.isShiftDown() ? this.getHorizontalScrollBar() : this.getVerticalScrollBar();
        double delta = MouseWheelEventEx.getAbsoluteDelta(e);
        if (delta == 0.0) {
            delta = this.getRelativeDelta(e, scrollbar);
        }
        int value = scrollbar instanceof Interpolable ? ((Interpolable)((Object)scrollbar)).getTargetValue() : scrollbar.getValue();
        double minDelta = (double)scrollbar.getMinimum() - (double)value;
        double maxDelta = (double)scrollbar.getMaximum() - (double)scrollbar.getModel().getExtent() - (double)value;
        double boundedDelta = Math.max(minDelta, Math.min(delta, maxDelta));
        if (scrollbar instanceof FinelyAdjustable) {
            ((FinelyAdjustable)((Object)scrollbar)).adjustValue(boundedDelta);
        } else {
            scrollbar.setValue(value + (int)Math.round(boundedDelta));
        }
    }

    private double getRelativeDelta(MouseWheelEvent e, JScrollBar scrollbar) {
        JViewport viewport = this.getViewport();
        double rotation = e.getPreciseWheelRotation();
        int direction = rotation < 0.0 ? -1 : 1;
        int unitIncrement = SmoothScrollPane.getUnitIncrement(viewport, scrollbar, direction);
        double delta = rotation * (double)e.getScrollAmount() * (double)unitIncrement;
        boolean adjustDelta = Math.abs(rotation) < 1.00001;
        int blockIncrement = SmoothScrollPane.getBlockIncrement(viewport, scrollbar, direction);
        return adjustDelta ? Math.max(-((double)blockIncrement), Math.min(delta, (double)blockIncrement)) : delta;
    }

    private static int getUnitIncrement(JViewport viewport, JScrollBar scrollbar, int direction) {
        Scrollable scrollable = SmoothScrollPane.getScrollable(viewport);
        if (scrollable == null) {
            return scrollbar.getUnitIncrement(direction);
        }
        Rectangle r = new Rectangle(new Point(0, 0), viewport.getViewSize());
        return scrollable.getScrollableUnitIncrement(r, scrollbar.getOrientation(), 1);
    }

    private static int getBlockIncrement(JViewport viewport, JScrollBar scrollbar, int direction) {
        Scrollable scrollable = SmoothScrollPane.getScrollable(viewport);
        Rectangle r = new Rectangle(new Point(0, 0), viewport.getViewSize());
        return scrollable == null ? scrollbar.getBlockIncrement(direction) : scrollable.getScrollableBlockIncrement(r, scrollbar.getOrientation(), 1);
    }

    @Nullable
    private static Scrollable getScrollable(JViewport viewport) {
        return viewport != null && viewport.getView() instanceof Scrollable ? (Scrollable)((Object)viewport.getView()) : null;
    }

    public InputSource getInputSource(boolean valueIsAdjusting) {
        return valueIsAdjusting ? InputSource.SCROLLBAR : this.myInputSource;
    }

    public int getInitialDelay(InputSource source) {
        switch (source) {
            case SCROLLBAR: {
                return SCROLLBAR_DELAY.asInteger();
            }
            case PRECISION_TOUCHPAD: {
                return PRECISION_TOUCHPAD_DELAY.asInteger();
            }
            case MOUSE_WHEEL: {
                return Math.max(MOUSE_WHEEL_MIN_DELAY.asInteger(), Math.min((int)Math.round(Math.abs(this.myWheelRotation) * (double)MOUSE_WHEEL_MAX_DELAY.asInteger()), MOUSE_WHEEL_MAX_DELAY.asInteger()));
            }
        }
        return DEFAULT_DELAY.asInteger();
    }

    protected class SmoothScrollBar
    extends JScrollPane.ScrollBar
    implements Interpolable,
    FinelyAdjustable {
        private final Interpolator myInterpolator;
        private final Adjuster myAdjuster;

        protected SmoothScrollBar(int orientation) {
            super(SmoothScrollPane.this, orientation);
            this.myInterpolator = new Interpolator(this::getValue, this::setCurrentValue);
            this.myAdjuster = new Adjuster((Consumer<Integer>)((Consumer)delta -> this.setValue(this.getTargetValue() + delta)));
            if (SystemProperties.isTrueSmoothScrollingEnabled()) {
                this.setModel(new SmoothBoundedRangeModel(this));
            }
        }

        @Override
        public void setValue(int value) {
            ComponentSettings settings = ComponentSettings.getInstance();
            InputSource source = SmoothScrollPane.this.getInputSource(this.getValueIsAdjusting());
            if (settings.isTrueSmoothScrollingEligibleFor(SmoothScrollPane.this.getViewport().getView()) && settings.isInterpolationEligibleFor(this) && settings.isInterpolationEnabledFor(source)) {
                this.myInterpolator.setTarget(value, SmoothScrollPane.this.getInitialDelay(source));
            } else {
                super.setValue(value);
            }
        }

        @Override
        public void setCurrentValue(int value) {
            super.setValue(value);
            this.myAdjuster.reset();
        }

        @Override
        public int getTargetValue() {
            return this.myInterpolator.getTarget();
        }

        @Override
        public void adjustValue(double delta) {
            this.myAdjuster.adjustValue(delta);
        }
    }
}

