/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextWrapper;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.ShelvedChange;
import org.jetbrains.idea.perforce.merge.PerforceMergeProvider;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/perforce/actions/BrowseShelfAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "Perforce"})
public final class BrowseShelfAction
extends DumbAwareAction {
    private static final Logger LOG;
    public static final Companion Companion;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        e.getPresentation().setEnabledAndVisible(!BrowseShelfAction.Companion.getShelvedChanges(project, e).isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project!!");
        Project project2 = e.getProject();
        if (project2 == null) {
            Intrinsics.throwNpe();
        }
        Companion.browseShelf(project, BrowseShelfAction.Companion.getShelvedChanges(project2, e));
    }

    public BrowseShelfAction() {
        super("Browse Perforce Shelf...");
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.actions.BrowseShelfAction");
    }

    @JvmStatic
    public static final void browseShelf(@NotNull Project project, @NotNull List<? extends ShelvedChange> shelvedChanges) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(shelvedChanges, (String)"shelvedChanges");
        Companion.browseShelf(project, shelvedChanges);
    }

    @JvmStatic
    @NotNull
    public static final MultiMap<Pair<P4Connection, Long>, String> groupByChangeList(@NotNull List<? extends ShelvedChange> selected) {
        Intrinsics.checkParameterIsNotNull(selected, (String)"selected");
        return Companion.groupByChangeList(selected);
    }

    @VisibleForTesting
    @JvmStatic
    public static final void unshelveChanges(@NotNull List<? extends ShelvedChange> selected, @NotNull Project project, boolean delete) {
        Intrinsics.checkParameterIsNotNull(selected, (String)"selected");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Companion.unshelveChanges(selected, project, delete);
    }

    @JvmStatic
    public static final void deleteFromShelf(@NotNull MultiMap<Pair<P4Connection, Long>, String> paths, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull(paths, (String)"paths");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Companion.deleteFromShelf(paths, project);
    }

    @JvmStatic
    public static final void deleteFromShelf(@NotNull List<? extends ShelvedChange> changes, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Companion.deleteFromShelf(changes, project);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J0\u0010\u000f\u001a\u00020\t2\u001e\u0010\u0010\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u0012\u0004\u0012\u00020\u00150\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001e\u0010\u000f\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000bH\u0007J0\u0010\u0017\u001a\u00020\t2\u001e\u0010\u0010\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u0012\u0004\u0012\u00020\u00150\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J.\u0010\u001b\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u0012\u0004\u0012\u00020\u00150\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J0\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\"H\u0002J&\u0010#\u001a\u00020\t2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0007R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006&"}, d2={"Lorg/jetbrains/idea/perforce/actions/BrowseShelfAction$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "browseShelf", "", "project", "Lcom/intellij/openapi/project/Project;", "shelvedChanges", "", "Lorg/jetbrains/idea/perforce/application/ShelvedChange;", "deleteFromShelf", "paths", "Lcom/intellij/util/containers/MultiMap;", "Lkotlin/Pair;", "Lorg/jetbrains/idea/perforce/perforce/connections/P4Connection;", "", "", "changes", "doUnshelve", "getShelvedChanges", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "groupByChangeList", "selected", "handleUnshelveException", "connection", "unshelveException", "Lcom/intellij/openapi/vcs/VcsException;", "specs", "", "unshelveChanges", "delete", "", "Perforce"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void browseShelf(@NotNull Project project, @NotNull List<? extends ShelvedChange> shelvedChanges) {
            Object inclusionListener;
            void destination$iv$iv;
            Ref.ObjectRef $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull(shelvedChanges, (String)"shelvedChanges");
            Iterable iterable = shelvedChanges;
            void var5_4 = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ShelvedChange shelvedChange = (ShelvedChange)((Object)item$iv$iv);
                void var13_9 = destination$iv$iv;
                Change change = it.toIdeaChange(project);
                var13_9.add(change);
            }
            List changes = (List)destination$iv$iv;
            DialogBuilder dialogBuilder = new DialogBuilder(project);
            $receiver$iv$iv = new Ref.ObjectRef();
            $receiver$iv$iv.element = null;
            ChangesBrowser browser2 = new ChangesBrowser(project, CollectionsKt.emptyList(), changes, (ChangeList)null, true, false, new Runnable(inclusionListener){
                final /* synthetic */ Ref.ObjectRef $inclusionListener;

                public final void run() {
                    block0: {
                        Runnable runnable = (Runnable)this.$inclusionListener.element;
                        if (runnable == null) break block0;
                        runnable.run();
                    }
                }
                {
                    this.$inclusionListener = objectRef;
                }
            }, ChangesBrowser.MyUseCase.COMMITTED_CHANGES, (VirtualFile)null);
            ChangesTreeList changesTreeList = browser2.getViewer();
            Intrinsics.checkExpressionValueIsNotNull((Object)changesTreeList, (String)"browser.viewer");
            ChangesTreeList changeViewer = changesTreeList;
            inclusionListener.element = new Runnable(dialogBuilder, changeViewer){
                final /* synthetic */ DialogBuilder $dialogBuilder;
                final /* synthetic */ ChangesTreeList $changeViewer;

                public final void run() {
                    Collection collection = this.$changeViewer.getIncludedChanges();
                    DialogBuilder dialogBuilder = this.$dialogBuilder;
                    boolean bl = !collection.isEmpty();
                    dialogBuilder.setOkActionEnabled(bl);
                }
                {
                    this.$dialogBuilder = dialogBuilder;
                    this.$changeViewer = changesTreeList;
                }
            };
            browser2.setChangesToDisplay(changes);
            browser2.addToolbarAction((AnAction)new DumbAwareAction(changeViewer, project, "Unshelve", "Unshelve selected changes to the default changelist", AllIcons.Vcs.Unshelve){
                final /* synthetic */ ChangesTreeList $changeViewer;
                final /* synthetic */ Project $project;

                public void update(@NotNull AnActionEvent e) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    e.getPresentation().setEnabled(!this.$changeViewer.getIncludedChanges().isEmpty());
                }

                /*
                 * WARNING - void declaration
                 */
                public void actionPerformed(@NotNull AnActionEvent e) {
                    List list;
                    void destination$iv$iv;
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    FileDocumentManager.getInstance().saveAllDocuments();
                    Iterable iterable = this.$changeViewer.getIncludedChanges();
                    Companion companion = BrowseShelfAction.Companion;
                    void var3_4 = $receiver$iv;
                    Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it;
                        Change change = (Change)item$iv$iv;
                        list = destination$iv$iv;
                        void v0 = it;
                        if (v0 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.idea.perforce.application.ShelvedChange.IdeaChange");
                        }
                        ShelvedChange shelvedChange = ((ShelvedChange.IdeaChange)v0).getOriginal();
                        list.add(shelvedChange);
                    }
                    list = (List)destination$iv$iv;
                    companion.unshelveChanges(list, this.$project, false);
                }
                {
                    this.$changeViewer = $captured_local_variable$0;
                    this.$project = $captured_local_variable$1;
                    super($super_call_param$2, $super_call_param$3, $super_call_param$4);
                }
            });
            dialogBuilder.setTitle("Perforce Shelved Changes");
            dialogBuilder.setActionDescriptors(new DialogBuilder.ActionDescriptor[]{(DialogBuilder.ActionDescriptor)new DialogBuilder.OkActionDescriptor(), (DialogBuilder.ActionDescriptor)new DialogBuilder.CloseDialogAction()});
            dialogBuilder.getOkAction().setText("Unshelve and Delete");
            dialogBuilder.setOkOperation(new Runnable(changeViewer, project, dialogBuilder){
                final /* synthetic */ ChangesTreeList $changeViewer;
                final /* synthetic */ Project $project;
                final /* synthetic */ DialogBuilder $dialogBuilder;

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    FileDocumentManager.getInstance().saveAllDocuments();
                    Collection selected = this.$changeViewer.getIncludedChanges();
                    if (!selected.isEmpty()) {
                        List list;
                        void destination$iv$iv;
                        void $receiver$iv$iv;
                        void $receiver$iv;
                        Iterable iterable = selected;
                        Companion companion = BrowseShelfAction.Companion;
                        void var3_4 = $receiver$iv;
                        Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                        for (T item$iv$iv : $receiver$iv$iv) {
                            void it;
                            Change change = (Change)item$iv$iv;
                            list = destination$iv$iv;
                            void v0 = it;
                            if (v0 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.idea.perforce.application.ShelvedChange.IdeaChange");
                            }
                            ShelvedChange shelvedChange = ((ShelvedChange.IdeaChange)v0).getOriginal();
                            list.add(shelvedChange);
                        }
                        list = (List)destination$iv$iv;
                        companion.unshelveChanges(list, this.$project, true);
                        this.$dialogBuilder.getDialogWrapper().close(0);
                    }
                }
                {
                    this.$changeViewer = changesTreeList;
                    this.$project = project;
                    this.$dialogBuilder = dialogBuilder;
                }
            });
            dialogBuilder.setCenterPanel((JComponent)browser2);
            dialogBuilder.setPreferredFocusComponent(browser2.getPreferredFocusedComponent());
            dialogBuilder.showNotModal();
            inclusionListener = null;
        }

        private final List<ShelvedChange> getShelvedChanges(Project project, AnActionEvent e) {
            LocalChangeList selectedChangeList;
            ChangeList[] lists = VcsContextWrapper.createInstanceOn((AnActionEvent)e).getSelectedChangeLists();
            ChangeList changeList = lists != null ? (ChangeList)ArraysKt.singleOrNull((Object[])lists) : null;
            if (!(changeList instanceof LocalChangeList)) {
                changeList = null;
            }
            if ((selectedChangeList = (LocalChangeList)changeList) != null && project != null) {
                return PerforceManager.getInstance(project).getShelf().getShelvedChanges(selectedChangeList);
            }
            return CollectionsKt.emptyList();
        }

        @JvmStatic
        @NotNull
        public final MultiMap<Pair<P4Connection, Long>, String> groupByChangeList(@NotNull List<? extends ShelvedChange> selected) {
            Intrinsics.checkParameterIsNotNull(selected, (String)"selected");
            MultiMap paths = MultiMap.create();
            for (ShelvedChange shelvedChange : selected) {
                paths.putValue((Object)TuplesKt.to((Object)shelvedChange.getConnection(), (Object)shelvedChange.getChangeList()), (Object)shelvedChange.getDepotPath());
            }
            MultiMap multiMap = paths;
            Intrinsics.checkExpressionValueIsNotNull((Object)multiMap, (String)"paths");
            return multiMap;
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        @JvmStatic
        public final void unshelveChanges(@NotNull List<? extends ShelvedChange> selected, @NotNull Project project, boolean delete) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull(selected, (String)"selected");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            MultiMap<Pair<P4Connection, Long>, String> paths = this.groupByChangeList(selected);
            this.doUnshelve(paths, project);
            if (delete) {
                this.deleteFromShelf(paths, project);
            }
            Iterable iterable = selected;
            Iterator iterator = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ShelvedChange shelvedChange = (ShelvedChange)((Object)item$iv$iv);
                void var16_12 = destination$iv$iv;
                File file = it.getFile();
                FilePath filePath = file != null ? VcsUtil.getFilePath((File)file) : (FilePath)null;
                var16_12.add(filePath);
            }
            List dirtyFiles = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
            $receiver$iv = dirtyFiles;
            for (Object element$iv : $receiver$iv) {
                FilePath it = (FilePath)element$iv;
                VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(it.getPath());
                if (file == null) continue;
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{file});
            }
            VcsDirtyScopeManager.getInstance((Project)project).filePathsDirty((Collection)dirtyFiles, (Collection)CollectionsKt.emptyList());
        }

        /*
         * WARNING - void declaration
         */
        private final void doUnshelve(MultiMap<Pair<P4Connection, Long>, String> paths, Project project) {
            Iterator iterator = paths.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                Pair pair = (Pair)entry2.getKey();
                Object object = entry;
                Collection specs = (Collection)object.getValue();
                Pair pair2 = pair;
                object = (P4Connection)pair2.component1();
                long l = ((Number)pair2.component2()).longValue();
                pair2 = null;
                try {
                    void changeList;
                    void connection;
                    PerforceRunner.getInstance(project).unshelve((P4Connection)connection, (long)changeList, specs);
                }
                catch (VcsException e) {
                    AbstractVcsHelper.getInstance((Project)project).showError(e, "Unshelve");
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void handleUnshelveException(P4Connection connection, VcsException unshelveException, Project project, Collection<String> specs) {
            String msg = unshelveException.getMessage();
            if (StringsKt.contains$default((CharSequence)msg, (CharSequence)"needs resolve", (boolean)false, (int)2, null)) {
                LinkedHashSet<VirtualFile> toResolve;
                try {
                    LinkedHashSet<VirtualFile> linkedHashSet = PerforceRunner.getInstance(project).getResolvedWithConflicts(connection, specs);
                    Intrinsics.checkExpressionValueIsNotNull(linkedHashSet, (String)"PerforceRunner.getInstan\u2026flicts(connection, specs)");
                    toResolve = linkedHashSet;
                }
                catch (VcsException resolveException) {
                    AbstractVcsHelper.getInstance((Project)project).showError(unshelveException, "Unshelve");
                    AbstractVcsHelper.getInstance((Project)project).showError(resolveException, "Unshelve");
                    return;
                }
                Collection resolveException = toResolve;
                if (!resolveException.isEmpty()) {
                    void $receiver$iv;
                    resolveException = toResolve;
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    void v1 = $receiver$iv;
                    if (v1 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    Collection thisCollection$iv = (Collection)v1;
                    VirtualFile[] virtualFileArray = thisCollection$iv.toArray(new VirtualFile[thisCollection$iv.size()]);
                    if (virtualFileArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    Object[] objectArray = virtualFileArray;
                    VirtualFile[] virtualFileArray2 = (VirtualFile[])objectArray;
                    VfsUtil.markDirtyAndRefresh((boolean)bl3, (boolean)bl2, (boolean)bl, (VirtualFile[])Arrays.copyOf(virtualFileArray2, virtualFileArray2.length));
                    this.getLOG().info((Throwable)unshelveException);
                    new PerforceMergeProvider(project).showMergeDialog(CollectionsKt.toList((Iterable)toResolve));
                    return;
                }
            }
            AbstractVcsHelper.getInstance((Project)project).showError(unshelveException, "Unshelve");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void deleteFromShelf(@NotNull MultiMap<Pair<P4Connection, Long>, String> paths, @NotNull Project project) {
            Intrinsics.checkParameterIsNotNull(paths, (String)"paths");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Iterator iterator = paths.entrySet().iterator();
            while (iterator.hasNext()) {
                void connection;
                Map.Entry entry;
                Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                Pair pair = (Pair)entry2.getKey();
                Object object = entry;
                Collection specs = (Collection)object.getValue();
                Pair pair2 = pair;
                object = (P4Connection)pair2.component1();
                long l = ((Number)pair2.component2()).longValue();
                pair2 = null;
                try {
                    void changeList;
                    PerforceRunner.getInstance(project).deleteFromShelf((P4Connection)connection, (long)changeList, specs);
                }
                catch (VcsException e) {
                    this.handleUnshelveException((P4Connection)connection, e, project, specs);
                }
            }
        }

        @JvmStatic
        public final void deleteFromShelf(@NotNull List<? extends ShelvedChange> changes, @NotNull Project project) {
            Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.deleteFromShelf(this.groupByChangeList(changes), project);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

