/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ClientRootsCache;
import org.jetbrains.idea.perforce.application.ConnectionDiagnoseRefresher;
import org.jetbrains.idea.perforce.application.ConnectionInfo;
import org.jetbrains.idea.perforce.application.P4ConfigConnectionDiagnoseDialog;
import org.jetbrains.idea.perforce.application.P4RootsInformation;
import org.jetbrains.idea.perforce.application.PerforceClientRootsChecker;
import org.jetbrains.idea.perforce.application.PerforceInfoAndClient;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4ConfigHelper;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionCalculator;
import org.jetbrains.idea.perforce.perforce.connections.P4ParametersConnection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionProblemsNotifier;
import org.jetbrains.idea.perforce.perforce.connections.PerforceMultipleConnections;
import org.jetbrains.idea.perforce.perforce.connections.SingletonConnection;
import org.jetbrains.idea.perforce.perforce.login.LoginPerformerImpl;
import org.jetbrains.idea.perforce.perforce.login.LoginState;
import org.jetbrains.idea.perforce.perforce.login.LoginSupport;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

public class ConfigPanel {
    private JTextField m_port;
    private JTextField m_client;
    private JTextField m_user;
    private JCheckBox m_showCmds;
    private TextFieldWithBrowseButton m_pathToExec;
    private JPanel myPanel;
    private HyperlinkLabel myOutputFileLabel;
    private JComboBox myCharset;
    private JButton myTestConnectionButton;
    private final Project myProject;
    private JCheckBox myShowBranchingHistory;
    private JCheckBox myIsEnabled;
    private JCheckBox myUseLogin;
    private JTextField myServerTimeoutField;
    private TextFieldWithBrowseButton myP4VPathField;
    private JCheckBox myUsePerforceJobs;
    private JCheckBox myShowIntegratedChangelistsInCheckBox;
    private JRadioButton myUseP4CONFIGOrDefaultRadioButton;
    private JRadioButton myUseConnectionParametersRadioButton;
    private JLabel myPOrtLabel;
    private JLabel myUserLabel;
    private JLabel myClientLabel;
    private JLabel myCharsetLabel;
    private JCheckBox mySwitchToOffline;
    private JPanel myConfigSettingsPanel;
    private JBLabel myP4ConfigWarningLabel;
    @NonNls
    private static final String CHARSET_ISO8859_1 = "iso8859-1";
    @NonNls
    private static final String CHARSET_ISO8859_15 = "iso8859-15";
    @NonNls
    private static final String CHARSET_eucjp = "eucjp";
    @NonNls
    private static final String CHARSET_shiftjis = "shiftjis";
    @NonNls
    private static final String CHARSET_winansi = "winansi";
    @NonNls
    private static final String CHARSET_macosroman = "macosroman";
    @NonNls
    private static final String CHARSET_utf8 = "utf8";

    public ConfigPanel(final Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.myUseConnectionParametersRadioButton);
        bg.add(this.myUseP4CONFIGOrDefaultRadioButton);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigPanel.this.reenableConnectPane();
            }
        };
        this.myUseConnectionParametersRadioButton.addActionListener(actionListener);
        this.myUseP4CONFIGOrDefaultRadioButton.addActionListener(actionListener);
        this.myTestConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isEmpty = PerforceLoginManager.getInstance(ConfigPanel.this.myProject).getNotifier().isEmpty();
                PerforceSettings settings = new PerforceSettings(ConfigPanel.this.myProject);
                settings.setCanGoOffline(false);
                ConfigPanel.this.applyImpl(settings);
                TestPerforceConnectionManager connectionManager = new TestPerforceConnectionManager(ConfigPanel.this.myProject, !settings.useP4CONFIG);
                TestLoginManager testLoginManager = new TestLoginManager(ConfigPanel.this.myProject, settings, connectionManager);
                PerforceRunner runner = new PerforceRunner(connectionManager, settings, testLoginManager);
                if (settings.useP4CONFIG) {
                    ConnectionTestDataProvider connectionTestDataProvider = new ConnectionTestDataProvider(ConfigPanel.this.myProject, connectionManager, runner);
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> connectionTestDataProvider.refresh(), "Test Connection", false, ConfigPanel.this.myProject);
                    P4ConfigConnectionDiagnoseDialog dialog = new P4ConfigConnectionDiagnoseDialog(ConfigPanel.this.myProject, connectionTestDataProvider);
                    dialog.show();
                } else {
                    connectionManager.setSingletonConnection(new SingletonConnection(project, settings));
                    PerforceClientRootsChecker[] checker = new PerforceClientRootsChecker[1];
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                        Map<VirtualFile, P4Connection> allConnections = connectionManager.getAllConnections();
                        ClientRootsCache cache = ClientRootsCache.getClientRootsCache(project);
                        Map<P4Connection, ConnectionInfo> info = PerforceInfoAndClient.calculateInfos(allConnections.values(), runner, cache);
                        checker[0] = new PerforceClientRootsChecker(info, allConnections);
                    }, "Test Connection", false, ConfigPanel.this.myProject);
                    PerforceConnectionProblemsNotifier.showSingleConnectionState(project, checker[0]);
                }
                if (!isEmpty) {
                    ConfigPanel.this.refreshAuthenticationState();
                }
            }
        });
        this.m_pathToExec.addBrowseFolderListener(PerforceBundle.message((String)"dialog.title.path.to.p4.exe", (Object[])new Object[0]), PerforceBundle.message((String)"dialog.description.path.to.p4.exe", (Object[])new Object[0]), project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor();
        this.myP4VPathField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(PerforceBundle.message((String)"dialog.title.path.to.p4.exe", (Object[])new Object[0]), PerforceBundle.message((String)"dialog.description.path.to.p4v.exe", (Object[])new Object[0]), (ComponentWithBrowseButton)this.myP4VPathField, project, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            protected VirtualFile getInitialFile() {
                VirtualFile file = super.getInitialFile();
                if (file == null && SystemInfo.isMac) {
                    return LocalFileSystem.getInstance().refreshAndFindFileByPath("/Applications/p4v.app");
                }
                return file;
            }

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "org/jetbrains/idea/perforce/perforce/ConfigPanel$3", "onFileChosen"));
                }
                String trim = chosenFile.getPath();
                if (SystemInfo.isMac && trim.endsWith("/p4v.app")) {
                    String actualPath = trim + "/Contents/MacOS/p4v";
                    VirtualFile actualFile = LocalFileSystem.getInstance().findFileByPath(actualPath);
                    if (actualFile != null) {
                        super.onFileChosen(actualFile);
                        return;
                    }
                }
                super.onFileChosen(chosenFile);
            }
        });
        this.reenableConnectPane();
        if (this.myProject.isDefault()) {
            this.hideProjectSpecificControls();
        }
        this.myP4ConfigWarningLabel.setVisible(!P4ConfigHelper.hasP4ConfigSettingInEnvironment());
        this.myP4ConfigWarningLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
    }

    private void hideProjectSpecificControls() {
        this.myIsEnabled.setVisible(false);
        this.myConfigSettingsPanel.setVisible(false);
        this.myTestConnectionButton.setVisible(false);
    }

    private void refreshAuthenticationState() {
        PerforceConnectionManager.getInstance(this.myProject).updateConnections();
    }

    private void reenableConnectPane() {
        boolean useP4Conf = this.myUseP4CONFIGOrDefaultRadioButton.isSelected();
        this.m_port.setEnabled(!useP4Conf);
        this.m_client.setEnabled(!useP4Conf);
        this.m_user.setEnabled(!useP4Conf);
        this.myCharset.setEnabled(!useP4Conf);
        this.myUserLabel.setEnabled(!useP4Conf);
        this.myPOrtLabel.setEnabled(!useP4Conf);
        this.myClientLabel.setEnabled(!useP4Conf);
        this.myCharsetLabel.setEnabled(!useP4Conf);
        this.myTestConnectionButton.setEnabled(!this.myProject.isDefault() || !useP4Conf);
    }

    public void resetFrom(PerforceSettings settings) {
        this.myUseP4CONFIGOrDefaultRadioButton.setSelected(settings.useP4CONFIG);
        this.myUseConnectionParametersRadioButton.setSelected(!settings.useP4CONFIG);
        this.m_port.setText(settings.port);
        this.m_client.setText(settings.client);
        this.m_user.setText(settings.user);
        this.m_showCmds.setSelected(settings.showCmds);
        this.m_pathToExec.setText(settings.pathToExec);
        this.myP4VPathField.setText(settings.PATH_TO_P4V);
        final File dumpFile = PerforceRunner.getDumpFile();
        if (dumpFile.exists()) {
            this.myOutputFileLabel.setHyperlinkText("'", dumpFile.getAbsolutePath(), "'");
        } else {
            this.myOutputFileLabel.setText("'" + dumpFile.getAbsolutePath() + "'");
        }
        this.myOutputFileLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    ShowFilePathAction.openFile((File)dumpFile);
                }
            }
        });
        this.myShowBranchingHistory.setSelected(settings.SHOW_BRANCHES_HISTORY);
        this.myUseLogin.setSelected(settings.USE_LOGIN);
        this.myServerTimeoutField.setText(Integer.toString(settings.SERVER_TIMEOUT / 1000));
        this.myUsePerforceJobs.setSelected(settings.USE_PERFORCE_JOBS);
        this.mySwitchToOffline.setSelected(settings.myCanGoOffline);
        this.myShowIntegratedChangelistsInCheckBox.setSelected(settings.SHOW_INTEGRATED_IN_COMMITTED_CHANGES);
        this.myCharset.removeAllItems();
        this.myCharset.addItem(PerforceSettings.CHARSET_NONE);
        this.myCharset.addItem(CHARSET_ISO8859_1);
        this.myCharset.addItem(CHARSET_ISO8859_15);
        this.myCharset.addItem(CHARSET_eucjp);
        this.myCharset.addItem(CHARSET_shiftjis);
        this.myCharset.addItem(CHARSET_winansi);
        this.myCharset.addItem(CHARSET_macosroman);
        this.myCharset.addItem(CHARSET_utf8);
        this.myIsEnabled.setSelected(settings.ENABLED);
        this.myCharset.setSelectedItem(settings.CHARSET);
        this.reenableConnectPane();
    }

    public void applyTo(PerforceSettings settings) {
        this.applyImpl(settings);
        if (settings.ENABLED != this.myIsEnabled.isSelected()) {
            if (this.myIsEnabled.isSelected()) {
                settings.enable();
            } else {
                settings.disable(true);
            }
        }
    }

    private void applyImpl(PerforceSettings settings) {
        settings.useP4CONFIG = this.myUseP4CONFIGOrDefaultRadioButton.isSelected();
        settings.port = this.m_port.getText();
        settings.client = this.m_client.getText();
        settings.user = this.m_user.getText();
        settings.showCmds = this.m_showCmds.isSelected();
        boolean execChanged = !Comparing.equal((String)settings.pathToExec, (String)this.m_pathToExec.getText());
        settings.pathToExec = this.m_pathToExec.getText();
        if (execChanged) {
            PerforceManager.getInstance(this.myProject).resetClientVersion();
        }
        settings.PATH_TO_P4V = this.myP4VPathField.getText();
        settings.CHARSET = (String)this.myCharset.getSelectedItem();
        settings.SHOW_BRANCHES_HISTORY = this.myShowBranchingHistory.isSelected();
        settings.USE_LOGIN = this.myUseLogin.isSelected();
        try {
            settings.SERVER_TIMEOUT = Integer.parseInt(this.myServerTimeoutField.getText()) * 1000;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        settings.USE_PERFORCE_JOBS = this.myUsePerforceJobs.isSelected();
        settings.myCanGoOffline = this.mySwitchToOffline.isSelected();
        settings.SHOW_INTEGRATED_IN_COMMITTED_CHANGES = this.myShowIntegratedChangelistsInCheckBox.isSelected();
    }

    public boolean equalsToSettings(PerforceSettings settings) {
        if (this.connectionPartDiffer(settings)) {
            return false;
        }
        if (!Integer.toString(settings.SERVER_TIMEOUT / 1000).equals(this.myServerTimeoutField.getText())) {
            return false;
        }
        if (settings.showCmds != this.m_showCmds.isSelected()) {
            return false;
        }
        if (settings.SHOW_BRANCHES_HISTORY != this.myShowBranchingHistory.isSelected()) {
            return false;
        }
        if (!Comparing.equal((String)settings.pathToExec, (String)this.m_pathToExec.getText().trim())) {
            return false;
        }
        if (!Comparing.equal((String)settings.PATH_TO_P4V, (String)this.myP4VPathField.getText().trim())) {
            return false;
        }
        if (!Comparing.equal((Object)settings.USE_PERFORCE_JOBS, (Object)this.myUsePerforceJobs.isSelected())) {
            return false;
        }
        if (!Comparing.equal((Object)settings.myCanGoOffline, (Object)this.mySwitchToOffline.isSelected())) {
            return false;
        }
        if (!Comparing.equal((Object)settings.SHOW_INTEGRATED_IN_COMMITTED_CHANGES, (Object)this.myShowIntegratedChangelistsInCheckBox.isSelected())) {
            return false;
        }
        return Comparing.equal((Object)settings.CHARSET, (Object)this.myCharset.getSelectedItem());
    }

    private boolean connectionPartDiffer(PerforceSettings settings) {
        if (settings.useP4CONFIG != this.myUseP4CONFIGOrDefaultRadioButton.isSelected()) {
            return true;
        }
        if (settings.USE_LOGIN != this.myUseLogin.isSelected()) {
            return true;
        }
        if (!Comparing.equal((String)settings.port, (String)this.m_port.getText().trim())) {
            return true;
        }
        if (!Comparing.equal((String)settings.client, (String)this.m_client.getText().trim())) {
            return true;
        }
        if (!Comparing.equal((String)settings.user, (String)this.m_user.getText().trim())) {
            return true;
        }
        return settings.ENABLED != this.myIsEnabled.isSelected();
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JBLabel jBLabel;
        JRadioButton jRadioButton;
        JComboBox jComboBox;
        JLabel jLabel;
        JTextField jTextField;
        JLabel jLabel2;
        JTextField jTextField2;
        JLabel jLabel3;
        JTextField jTextField3;
        JLabel jLabel4;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JTextField jTextField4;
        JCheckBox jCheckBox4;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JButton jButton;
        JCheckBox jCheckBox5;
        HyperlinkLabel hyperlinkLabel;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myIsEnabled = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("org/jetbrains/idea/perforce/PerforceBundle").getString("checkbox.configure.perforce.is.enabled"));
        jPanel3.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel4).setVisible(true);
        jPanel3.add((Component)jPanel4, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.m_showCmds = jCheckBox6 = new JCheckBox();
        jCheckBox6.setHorizontalAlignment(2);
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("org/jetbrains/idea/perforce/PerforceBundle").getString("checkbox.configure.perforce.log.commands"));
        jPanel5.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutputFileLabel = hyperlinkLabel = new HyperlinkLabel();
        jPanel5.add((Component)hyperlinkLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel6).setVisible(true);
        jPanel3.add((Component)jPanel6, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myUseLogin = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("org/jetbrains/idea/perforce/PerforceBundle").getString("checkbox.configure.perforce.use.login.authentication"));
        jPanel6.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTestConnectionButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("org/jetbrains/idea/perforce/PerforceBundle").getString("button.text.test.connection"));
        jPanel6.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 5, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel7, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("org/jetbrains/idea/perforce/PerforceBundle").getString("label.configure.perforce.path.to.p4.exe"));
        jPanel7.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Path to P4V executable:");
        jPanel7.add((Component)jLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.m_pathToExec = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel7.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myP4VPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel7.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myShowBranchingHistory = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("org/jetbrains/idea/perforce/PerforceBundle").getString("checkbox.configure.perforce.show.branching.history"));
        ((Component)jCheckBox4).setVisible(true);
        jPanel3.add((Component)jCheckBox4, new GridConstraints(6, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 5, 0, 0), -1, -1, false, false));
        ((Component)jPanel8).setVisible(true);
        jPanel3.add((Component)jPanel8, new GridConstraints(8, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("org/jetbrains/idea/perforce/PerforceBundle").getString("server.timeout"));
        jPanel8.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel8.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myServerTimeoutField = jTextField4 = new JTextField();
        jTextField4.setColumns(8);
        jPanel8.add((Component)jTextField4, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("org/jetbrains/idea/perforce/PerforceBundle").getString("configure.perforce.timeout.seconds"));
        jPanel8.add((Component)jLabel8, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShowIntegratedChangelistsInCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("org/jetbrains/idea/perforce/PerforceBundle").getString("checkbox.configure.perforce.show.integrated.changelists"));
        jPanel3.add((Component)jCheckBox3, new GridConstraints(7, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.mySwitchToOffline = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Switch to offline mode automatically if Perforce is unavailable");
        ((Component)jCheckBox2).setVisible(true);
        jPanel3.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myConfigSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("org/jetbrains/idea/perforce/PerforceBundle").getString("border.configure.perforce.config.settings"), (int)0, (int)0, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseConnectionParametersRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Use connection parameters:");
        jPanel9.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel10, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 3));
        this.myPOrtLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("org/jetbrains/idea/perforce/PerforceBundle").getString("label.configure.perforce.port"));
        jLabel4.setHorizontalAlignment(10);
        jPanel10.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.m_port = jTextField3 = new JTextField();
        jPanel10.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        this.myClientLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("org/jetbrains/idea/perforce/PerforceBundle").getString("label.configure.perforce.client"));
        jLabel3.setHorizontalAlignment(10);
        jLabel3.setHorizontalTextPosition(11);
        jPanel10.add((Component)jLabel3, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.m_client = jTextField2 = new JTextField();
        jPanel10.add((Component)jTextField2, new GridConstraints(0, 3, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        this.myUserLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/jetbrains/idea/perforce/PerforceBundle").getString("label.configure.perforce.user"));
        jLabel2.setHorizontalAlignment(10);
        jPanel10.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.m_user = jTextField = new JTextField();
        jPanel10.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        this.myCharsetLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/idea/perforce/PerforceBundle").getString("combobox.configure.perforce.charset"));
        jPanel10.add((Component)jLabel, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCharset = jComboBox = new JComboBox();
        jPanel10.add(jComboBox, new GridConstraints(1, 3, 1, 1, 8, 1, 7, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel9.add((Component)spacer3, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel11, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseP4CONFIGOrDefaultRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("org/jetbrains/idea/perforce/PerforceBundle").getString("checkbox.configure.perforce.use.p4config"));
        jPanel11.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myP4ConfigWarningLabel = jBLabel = new JBLabel();
        jBLabel.setText("No P4CONFIG environment variable!");
        jPanel11.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        Spacer spacer4 = new Spacer();
        jPanel2.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel2.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myUsePerforceJobs = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/jetbrains/idea/perforce/PerforceBundle").getString("perforce.use.perforce.jobs"));
        ((Component)jCheckBox).setVisible(true);
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel4.setLabelFor(jTextField3);
        jLabel3.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class TestPerforceConnectionManager
    implements PerforceConnectionManagerI {
        private final Project myProject;
        private SingletonConnection mySingletonConnection;
        private final boolean mySingleton;
        private PerforceMultipleConnections myMc;

        public TestPerforceConnectionManager(Project project, boolean singleton) {
            this.myProject = project;
            this.mySingleton = singleton;
        }

        public void setSingletonConnection(SingletonConnection singletonConnection) {
            this.mySingletonConnection = singletonConnection;
        }

        public void setMc(PerforceMultipleConnections mc) {
            this.myMc = mc;
        }

        @Override
        public PerforceMultipleConnections getMultipleConnectionObject() {
            return this.myMc;
        }

        @Override
        @NotNull
        public Map<VirtualFile, P4Connection> getAllConnections() {
            if (this.mySingleton) {
                LinkedHashMap result = ContainerUtil.newLinkedHashMap();
                for (VirtualFile root : ProjectLevelVcsManager.getInstance((Project)this.myProject).getRootsUnderVcs((AbstractVcs)PerforceVcs.getInstance(this.myProject))) {
                    result.put(root, this.mySingletonConnection);
                }
                LinkedHashMap linkedHashMap = result;
                if (linkedHashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/ConfigPanel$TestPerforceConnectionManager", "getAllConnections"));
                }
                return linkedHashMap;
            }
            Map<VirtualFile, P4Connection> map = this.myMc.getAllConnections();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/ConfigPanel$TestPerforceConnectionManager", "getAllConnections"));
            }
            return map;
        }

        @Override
        public P4Connection getConnectionForFile(@NotNull File file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/perforce/ConfigPanel$TestPerforceConnectionManager", "getConnectionForFile"));
            }
            if (this.mySingleton) {
                return this.mySingletonConnection;
            }
            VirtualFile vf = PerforceConnectionManager.findNearestLiveParentFor(file);
            if (vf == null) {
                return null;
            }
            return this.myMc.getConnection(vf);
        }

        @Override
        public P4Connection getConnectionForFile(@NotNull P4File file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/perforce/ConfigPanel$TestPerforceConnectionManager", "getConnectionForFile"));
            }
            if (this.mySingleton) {
                return this.mySingletonConnection;
            }
            return this.getConnectionForFile(file.getLocalFile());
        }

        @Override
        public P4Connection getConnectionForFile(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/perforce/ConfigPanel$TestPerforceConnectionManager", "getConnectionForFile"));
            }
            if (this.mySingleton) {
                return this.mySingletonConnection;
            }
            return this.myMc.getConnection(file);
        }

        @Override
        public boolean isSingletonConnectionUsed() {
            return this.mySingleton;
        }

        @Override
        public void updateConnections() {
        }

        @Override
        public boolean isUnderProjectConnections(@NotNull File file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/perforce/ConfigPanel$TestPerforceConnectionManager", "isUnderProjectConnections"));
            }
            return true;
        }
    }

    private static class TestLoginManager
    implements LoginSupport {
        private final Project myProject;
        private final PerforceSettings mySettings;
        private final PerforceConnectionManagerI myConnectionManagerI;

        private TestLoginManager(Project project, PerforceSettings settings, PerforceConnectionManagerI connectionManagerI) {
            this.myProject = project;
            this.mySettings = settings;
            this.myConnectionManagerI = connectionManagerI;
        }

        @Override
        public boolean silentLogin(P4Connection connection) throws VcsException {
            LoginState login;
            String password = connection instanceof P4ParametersConnection ? ((P4ParametersConnection)connection).getParameters().getPassword() : this.mySettings.getPasswd();
            LoginPerformerImpl loginPerformer = new LoginPerformerImpl(this.myProject, connection, this.myConnectionManagerI);
            if (password != null && loginPerformer.login(password).isSuccess()) {
                return true;
            }
            do {
                if ((password = this.mySettings.requestForPassword(this.mySettings.useP4CONFIG ? connection : null)) != null) continue;
                return false;
            } while (!(login = loginPerformer.login(password)).isSuccess());
            PerforceConnectionManager.getInstance(this.myProject).updateConnections();
            return true;
        }

        @Override
        public void notLogged(P4Connection connection) {
        }
    }

    private static class ConnectionTestDataProvider
    implements ConnectionDiagnoseRefresher {
        private final Project myProject;
        private final TestPerforceConnectionManager myConnectionManager;
        private final PerforceRunner myRunner;
        private PerforceClientRootsChecker myChecker = new PerforceClientRootsChecker();
        private Map<P4Connection, ConnectionInfo> myInfo = Collections.emptyMap();
        private PerforceMultipleConnections myMc;

        public ConnectionTestDataProvider(Project project, TestPerforceConnectionManager connectionManager, PerforceRunner runner) {
            this.myProject = project;
            this.myConnectionManager = connectionManager;
            this.myRunner = runner;
        }

        @Override
        public void refresh() {
            P4ConnectionCalculator calculator = new P4ConnectionCalculator(this.myProject);
            calculator.execute();
            this.myMc = calculator.getMultipleConnections();
            Map<VirtualFile, P4Connection> map = this.myMc.getAllConnections();
            this.myConnectionManager.setMc(this.myMc);
            this.myInfo = PerforceInfoAndClient.recalculateInfos(this.myInfo, map.values(), (PerforceRunner)this.myRunner, (ClientRootsCache)ClientRootsCache.getClientRootsCache((Project)this.myProject)).newInfo;
            this.myChecker = new PerforceClientRootsChecker(this.myInfo, map);
        }

        @Override
        public PerforceMultipleConnections getMultipleConnections() {
            return this.myMc;
        }

        @Override
        public P4RootsInformation getP4RootsInformation() {
            return this.myChecker;
        }
    }
}

