/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coding;

import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u0015J\u0006\u0010\u0016\u001a\u00020\u0011J\u0006\u0010\u0017\u001a\u00020\u0018J\u0012\u0010\u0019\u001a\u00020\u00112\b\b\u0002\u0010\u0019\u001a\u00020\u0006H\u0007J\u0019\u0010\u001a\u001a\u00020\u00112\u000e\b\u0004\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u001cH\u0086\bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u000e\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0018J\b\u0010#\u001a\u00020\u0006H\u0016J\u0006\u0010$\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006&"}, d2={"Lcom/intellij/coding/CodeTextBuilder;", "", "()V", "buf", "Ljava/lang/StringBuilder;", "currentIndent", "", "indentStack", "Ljava/util/LinkedList;", "indentation", "getIndentation", "()Ljava/lang/String;", "setIndentation", "(Ljava/lang/String;)V", "text", "getText", "addSuffixToTheListLine", "", "suffix", "", "addText", "", "clearAll", "getCurrentIndentationState", "Lcom/intellij/coding/CodeTextBuilder$IndentationState;", "indent", "indenting", "block", "Lkotlin/Function0;", "isEmpty", "", "isNotEmpty", "removeSuffixFromTheLastLine", "returnToIndentation", "state", "toString", "unindent", "IndentationState", "database-scripting"})
public final class CodeTextBuilder {
    @NotNull
    private String indentation = "\t";
    private String currentIndent = "";
    private final LinkedList<String> indentStack = new LinkedList();
    private final StringBuilder buf = new StringBuilder(1024);

    @NotNull
    public final String getIndentation() {
        return this.indentation;
    }

    public final void setIndentation(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.indentation = string;
    }

    @NotNull
    public final String getText() {
        String string = this.buf.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buf.toString()");
        return string;
    }

    @NotNull
    public String toString() {
        return this.getText();
    }

    @JvmOverloads
    public final void indent(@NotNull String indent) {
        Intrinsics.checkParameterIsNotNull((Object)indent, (String)"indent");
        this.indentStack.push(this.currentIndent);
        this.currentIndent = this.currentIndent + indent;
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void indent$default(CodeTextBuilder codeTextBuilder, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: indent");
        }
        if ((n & 1) != 0) {
            string = codeTextBuilder.indentation;
        }
        codeTextBuilder.indent(string);
    }

    @JvmOverloads
    public final void indent() {
        CodeTextBuilder.indent$default(this, null, 1, null);
    }

    public final void unindent() {
        if (this.indentStack.isEmpty()) {
            throw (Throwable)new IllegalStateException("Unmatched unindent.");
        }
        String string = this.indentStack.pop();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"indentStack.pop()");
        this.currentIndent = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void indenting(@NotNull Function0<Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        CodeTextBuilder.indent$default(this, null, 1, null);
        try {
            block.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.unindent();
            InlineMarker.finallyEnd((int)1);
        }
    }

    @NotNull
    public final IndentationState getCurrentIndentationState() {
        return new IndentationState(this.indentStack.size(), this.currentIndent);
    }

    /*
     * WARNING - void declaration
     */
    public final void returnToIndentation(@NotNull IndentationState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        int d = this.indentStack.size() - state.getStackPosition();
        if (d > 0) {
            int n = 1;
            int n2 = d;
            if (n <= n2) {
                while (true) {
                    void i2;
                    this.indentStack.pop();
                    if (i2 == n2) break;
                    ++i2;
                }
            }
            this.currentIndent = state.getCurrentIndent();
        }
        if (d < 0) {
            throw (Throwable)new IllegalStateException("Unmatched return-to-indentation operation");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addText(@Nullable CharSequence text) {
        int n;
        if (text == null) {
            return;
        }
        this.buf.append(this.currentIndent);
        int pos = this.buf.length();
        this.buf.append(text);
        while (this.buf.charAt(this.buf.length() - 1) == '\n') {
            this.buf.deleteCharAt(this.buf.length() - 1);
        }
        int n2 = this.buf.length() - 1;
        if (n2 >= (n = pos)) {
            while (true) {
                void i2;
                char c;
                if ((c = this.buf.charAt((int)i2)) == '\n') {
                    this.buf.insert((int)(i2 + true), this.currentIndent);
                }
                if (i2 == n) break;
                --i2;
            }
        }
        this.buf.append('\n');
    }

    public final void addSuffixToTheListLine(char suffix) {
        int k;
        for (k = this.buf.length(); k > 0 && CharsKt.isWhitespace((char)this.buf.charAt(k - 1)); --k) {
        }
        this.buf.insert(k, suffix);
    }

    public final void removeSuffixFromTheLastLine(char suffix) {
        int k;
        for (k = this.buf.length() - 1; k >= 0 && CharsKt.isWhitespace((char)this.buf.charAt(k)); --k) {
        }
        if (k >= 0 && this.buf.charAt(k) == suffix) {
            this.buf.delete(k, k + 1);
        }
    }

    public final boolean isEmpty() {
        CharSequence charSequence = this.buf;
        return charSequence.length() == 0;
    }

    public final boolean isNotEmpty() {
        CharSequence charSequence = this.buf;
        return charSequence.length() > 0;
    }

    public final void clearAll() {
        this.indentStack.clear();
        this.currentIndent = "";
        this.buf.delete(0, this.buf.length());
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/intellij/coding/CodeTextBuilder$IndentationState;", "", "stackPosition", "", "currentIndent", "", "(ILjava/lang/String;)V", "getCurrentIndent", "()Ljava/lang/String;", "getStackPosition", "()I", "component1", "component2", "copy", "database-scripting"})
    public static final class IndentationState {
        private final int stackPosition;
        @NotNull
        private final String currentIndent;

        public final int getStackPosition() {
            return this.stackPosition;
        }

        @NotNull
        public final String getCurrentIndent() {
            return this.currentIndent;
        }

        public IndentationState(int stackPosition, @NotNull String currentIndent) {
            Intrinsics.checkParameterIsNotNull((Object)currentIndent, (String)"currentIndent");
            this.stackPosition = stackPosition;
            this.currentIndent = currentIndent;
        }

        public final int component1() {
            return this.stackPosition;
        }

        @NotNull
        public final String component2() {
            return this.currentIndent;
        }

        @NotNull
        public final IndentationState copy(int stackPosition, @NotNull String currentIndent) {
            Intrinsics.checkParameterIsNotNull((Object)currentIndent, (String)"currentIndent");
            return new IndentationState(stackPosition, currentIndent);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ IndentationState copy$default(IndentationState indentationState, int n, String string, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n2 & 1) != 0) {
                n = indentationState.stackPosition;
            }
            if ((n2 & 2) != 0) {
                string = indentationState.currentIndent;
            }
            return indentationState.copy(n, string);
        }

        public String toString() {
            return "IndentationState(stackPosition=" + this.stackPosition + ", currentIndent=" + this.currentIndent + ")";
        }

        public int hashCode() {
            String string = this.currentIndent;
            return this.stackPosition * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IndentationState)) break block3;
                    IndentationState indentationState = (IndentationState)object;
                    if (!(this.stackPosition == indentationState.stackPosition) || !Intrinsics.areEqual((Object)this.currentIndent, (Object)indentationState.currentIndent)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

