/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.access;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DbCredentialManager;
import com.intellij.database.access.DbCredentialManagerKt;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0007J\"\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004J!\u0010\f\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\r2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\"\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0007\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/access/DbCredentialManager;", "", "()V", "createServiceName", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "prefix", "get", "Lcom/intellij/credentialStore/Credentials;", "getAsync", "Ljava/util/concurrent/CompletionStage;", "getPasswordAsString", "Lorg/jetbrains/annotations/NotNull;", "getPasswordAsStringAsync", "set", "", "credentials", "memoryOnly", "", "database-impl"})
public final class DbCredentialManager {
    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @Nullable
    public final Credentials get(@NotNull LocalDataSource dataSource, @Nullable String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dataSource), (String)"dataSource");
        CredentialAttributes attributes = new CredentialAttributes(this.createServiceName(dataSource, prefix), dataSource.getUsername(), null, false, 12, null);
        PasswordSafe credentialStore = PasswordSafe.getInstance();
        Credentials credentials = credentialStore.get(attributes);
        if (credentials != null) {
            Credentials credentials2 = credentials;
            Credentials it = credentials2;
            return it;
        }
        Logger logger = DbCredentialManagerKt.access$getLOG$p();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            String string = prefix;
            if (string == null) {
                string = DbCredentialManagerKt.access$getDB_PWD$p();
            }
            CredentialAttributes oldKey = CredentialStoreKt.toOldKey(DatabaseCredentials.class, (String)stringBuilder.append(string).append(dataSource.getUniqueId()).toString());
            Credentials credentials3 = credentialStore.get(oldKey);
            if (credentials3 != null) {
                Credentials credentials4 = credentials3;
                Credentials it = credentials4;
                credentialStore.set(oldKey, (Credentials)null);
                Credentials credentials5 = new Credentials(dataSource.getUsername(), it.getPassword());
                credentialStore.set(attributes, credentials5);
                return credentials5;
            }
        }
        catch (ProcessCanceledException e$iv) {
        }
        catch (Throwable e$iv) {
            void $receiver$iv;
            $receiver$iv.error(e$iv);
        }
        return null;
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ Credentials get$default(DbCredentialManager dbCredentialManager, LocalDataSource localDataSource, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: get");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return dbCredentialManager.get(localDataSource, string);
    }

    @JvmOverloads
    @Nullable
    public final Credentials get(@NotNull LocalDataSource dataSource) {
        return DbCredentialManager.get$default(this, dataSource, null, 2, null);
    }

    @NotNull
    public final CompletionStage<Credentials> getAsync(@NotNull LocalDataSource dataSource, @Nullable String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dataSource), (String)"dataSource");
        CredentialAttributes attributes = new CredentialAttributes(this.createServiceName(dataSource, prefix), dataSource.getUsername(), null, false, 12, null);
        PasswordSafe credentialStore = PasswordSafe.getInstance();
        CompletionStage completionStage = CompletableFuture.supplyAsync(AsyncUtil.captureIndicator(new Supplier<T>(credentialStore, attributes){
            final /* synthetic */ PasswordSafe $credentialStore;
            final /* synthetic */ CredentialAttributes $attributes;

            @Nullable
            public final Credentials get() {
                return this.$credentialStore.get(this.$attributes);
            }
            {
                this.$credentialStore = passwordSafe;
                this.$attributes = credentialAttributes;
            }
        }), AsyncUtil.POOL_EXECUTOR).thenCompose(new Function<Credentials, CompletionStage<Credentials>>(prefix, dataSource, credentialStore, attributes){
            final /* synthetic */ String $prefix;
            final /* synthetic */ LocalDataSource $dataSource;
            final /* synthetic */ PasswordSafe $credentialStore;
            final /* synthetic */ CredentialAttributes $attributes;

            public final CompletableFuture<Credentials> apply(@Nullable Credentials creds) {
                if (creds != null) {
                    return CompletableFuture.completedFuture(creds);
                }
                StringBuilder stringBuilder = new StringBuilder();
                String string = this.$prefix;
                if (string == null) {
                    string = DbCredentialManagerKt.access$getDB_PWD$p();
                }
                CredentialAttributes oldKey = CredentialStoreKt.toOldKey(DatabaseCredentials.class, (String)stringBuilder.append(string).append(this.$dataSource.getUniqueId()).toString());
                return CompletableFuture.supplyAsync(AsyncUtil.captureIndicator(new Supplier<T>(this, oldKey){
                    final /* synthetic */ getAsync.2 this$0;
                    final /* synthetic */ CredentialAttributes $oldKey;

                    @Nullable
                    public final Credentials get() {
                        return this.this$0.$credentialStore.get(this.$oldKey);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$oldKey = credentialAttributes;
                    }
                }), AsyncUtil.POOL_EXECUTOR).thenApply(new Function<Credentials, Credentials>(this, oldKey){
                    final /* synthetic */ getAsync.2 this$0;
                    final /* synthetic */ CredentialAttributes $oldKey;

                    @Nullable
                    public final Credentials apply(@Nullable Credentials oldCreds) {
                        if (oldCreds == null) {
                            return null;
                        }
                        this.this$0.$credentialStore.set(this.$oldKey, (Credentials)null);
                        Credentials credentials = new Credentials(this.this$0.$dataSource.getUsername(), oldCreds.getPassword());
                        this.this$0.$credentialStore.set(this.this$0.$attributes, credentials);
                        return credentials;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$oldKey = credentialAttributes;
                    }
                });
            }
            {
                this.$prefix = string;
                this.$dataSource = localDataSource;
                this.$credentialStore = passwordSafe;
                this.$attributes = credentialAttributes;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"supplyAsync(captureIndic\u2026credentials\n      }\n    }");
        return completionStage;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ CompletionStage getAsync$default(DbCredentialManager dbCredentialManager, LocalDataSource localDataSource, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAsync");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return dbCredentialManager.getAsync(localDataSource, string);
    }

    @Nullable
    public final String getPasswordAsString(@NotNull LocalDataSource dataSource, @Nullable String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dataSource), (String)"dataSource");
        Credentials credentials = this.get(dataSource, prefix);
        return credentials != null ? credentials.getPasswordAsString() : null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ String getPasswordAsString$default(DbCredentialManager dbCredentialManager, LocalDataSource localDataSource, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getPasswordAsString");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return dbCredentialManager.getPasswordAsString(localDataSource, string);
    }

    @NotNull
    public final CompletionStage<String> getPasswordAsStringAsync(@NotNull LocalDataSource dataSource, @Nullable String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dataSource), (String)"dataSource");
        CompletionStage<String> completionStage = this.getAsync(dataSource, prefix).thenApply(getPasswordAsStringAsync.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(completionStage, (String)"getAsync(dataSource, pre\u2026?.getPasswordAsString() }");
        return completionStage;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ CompletionStage getPasswordAsStringAsync$default(DbCredentialManager dbCredentialManager, LocalDataSource localDataSource, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getPasswordAsStringAsync");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return dbCredentialManager.getPasswordAsStringAsync(localDataSource, string);
    }

    @JvmOverloads
    public final void set(@NotNull LocalDataSource dataSource, @Nullable Credentials credentials, boolean memoryOnly, @Nullable String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dataSource), (String)"dataSource");
        CredentialAttributes attributes = new CredentialAttributes(this.createServiceName(dataSource, prefix), dataSource.getUsername(), null, false, 12, null);
        PasswordSafe.getInstance().set(attributes, credentials, memoryOnly);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void set$default(DbCredentialManager dbCredentialManager, LocalDataSource localDataSource, Credentials credentials, boolean bl, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: set");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        dbCredentialManager.set(localDataSource, credentials, bl, string);
    }

    @JvmOverloads
    public final void set(@NotNull LocalDataSource dataSource, @Nullable Credentials credentials, boolean memoryOnly) {
        DbCredentialManager.set$default(this, dataSource, credentials, memoryOnly, null, 8, null);
    }

    @JvmOverloads
    public final void set(@NotNull LocalDataSource dataSource, @Nullable Credentials credentials) {
        DbCredentialManager.set$default(this, dataSource, credentials, false, null, 12, null);
    }

    private final String createServiceName(LocalDataSource dataSource, String prefix) {
        return CredentialAttributesKt.SERVICE_NAME_PREFIX + " DB \u2014 " + (prefix == null ? "" : String.valueOf(prefix)) + dataSource.getUniqueId();
    }
}

