/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.ui.AssignColorDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignColorAction
extends AnAction
implements DumbAware {
    public AssignColorAction() {
        super("Color Settings...");
    }

    public void update(AnActionEvent e) {
        DatabaseView view2 = (DatabaseView)((Object)DatabaseView.DATABASE_VIEW_KEY.getData(e.getDataContext()));
        boolean enabled = view2 != null && !view2.getTreeBuilder().getSelectedElements(DbElement.class).isEmpty();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        DatabaseView view2 = (DatabaseView)((Object)DatabaseView.DATABASE_VIEW_KEY.getData(e.getDataContext()));
        if (view2 == null) {
            return;
        }
        Set selectedElements = view2.getTreeBuilder().getSelectedElements(DbElement.class);
        Project project = view2.getProject();
        AssignColorDialog dialog = new AssignColorDialog(project, new ArrayList<DbElement>(selectedElements));
        if (dialog.showAndGet()) {
            AssignColorAction.updateOpenFileEditors(project);
            AssignColorAction.updateDatabaseToolwindow(project);
        }
    }

    private static void updateOpenFileEditors(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/AssignColorAction", "updateOpenFileEditors"));
        }
        FileEditorManagerEx managerEx = FileEditorManagerEx.getInstanceEx((Project)project);
        for (VirtualFile file : managerEx.getOpenFiles()) {
            managerEx.updateFilePresentation(file);
            if (!DbConsoleRootType.isConsoleFile(file) && !DbImplUtil.isDatabaseVirtualFile(file) && JdbcConsoleProvider.getAttachedConsole(project, file) == null) continue;
            for (FileEditor editor : managerEx.getEditors(file)) {
                JComponent component = editor instanceof TextEditor ? ((EditorEx)((TextEditor)editor).getEditor()).getPermanentHeaderComponent() : editor.getComponent();
                AssignColorAction.updateColors(project, file, component);
            }
        }
    }

    private static void updateDatabaseToolwindow(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/AssignColorAction", "updateDatabaseToolwindow"));
        }
        for (JdbcConsole console : JdbcConsole.getActiveConsoles(project)) {
            AssignColorAction.updateColors(project, console.getLanguageConsole().getVirtualFile(), console.getContent().getComponent());
        }
    }

    private static void updateColors(@NotNull Project project, @NotNull VirtualFile file, @Nullable JComponent root2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/AssignColorAction", "updateColors"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/actions/AssignColorAction", "updateColors"));
        }
        for (EditorHeaderComponent component : UIUtil.uiTraverser((Component)root2).filter(EditorHeaderComponent.class)) {
            DatabaseEditorHelper.updateToolbarColor(project, file, (JComponent)component);
        }
    }
}

