/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.dbimport.ImportDialog;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dbimport.csv.CsvInputType;
import com.intellij.database.dbimport.ui.AbstractImportPanel;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.DbRefactoringHelper;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportAction
extends DumbAwareAction {
    private static final int CHAR_COUNT = 0x100000;

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/ImportAction", "update"));
        }
        Set<DbElement> elements = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
        DbElement element = (DbElement)ContainerUtil.getFirstItem(elements);
        boolean isOneElement = elements.size() == 1;
        boolean schemaExists = DatabaseView.getLowestSchema(element) != null;
        boolean canConnect = DbImplUtil.canConnectToAndModify(element);
        boolean hasImportType = element != null && ImportType.of(element) != null;
        e.getPresentation().setEnabledAndVisible(hasImportType && isOneElement && schemaExists && canConnect);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/ImportAction", "actionPerformed"));
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        DbElement element = (DbElement)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class));
        if (element == null) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, true, true, true, false);
        FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null, file -> ImportAction.showDialog(project, element, file));
    }

    public static void showDialog(@NotNull Project project, @NotNull DbElement element, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/ImportAction", "showDialog"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/actions/ImportAction", "showDialog"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/actions/ImportAction", "showDialog"));
        }
        VirtualFile realFile = ImportAction.getFile(file);
        ImportAction.showDialog(project, element, realFile.getName(), new CsvInputType(realFile, 0x100000));
    }

    public static void showDialog(@NotNull Project project, @NotNull DbElement element, @NotNull String name, @NotNull InputType type) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/ImportAction", "showDialog"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/actions/ImportAction", "showDialog"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/actions/ImportAction", "showDialog"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/actions/ImportAction", "showDialog"));
        }
        ErrorHandler handler = new ErrorHandler();
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(element);
        try {
            ImportAction.showPreviewDialog(name, type, dialect, element);
        }
        catch (Exception ex) {
            handler.addError(null, (Throwable)ex);
            DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification("Import", handler.getSummary(), NotificationType.ERROR, null).notify(project);
        }
    }

    private static void showPreviewDialog(@NotNull String name, @NotNull InputType inputType, @NotNull DatabaseDialectEx dialect, @NotNull DbElement consumer) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/actions/ImportAction", "showPreviewDialog"));
        }
        if (inputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputType", "com/intellij/database/actions/ImportAction", "showPreviewDialog"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/actions/ImportAction", "showPreviewDialog"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/actions/ImportAction", "showPreviewDialog"));
        }
        Disposable disposable = Disposer.newDisposable();
        ImportType type = ImportType.of(consumer);
        DatabaseEditorContext editorContext = DbRefactoringHelper.createContext((DasObject)consumer, null);
        if (editorContext == null) {
            return;
        }
        DeModel model = AbstractDbRefactoringDialog.createModel(editorContext);
        DbNamespaceImpl namespace = DatabaseView.getLowestSchema(consumer);
        DasModel dasModel = consumer.getDataSource().getModel();
        DeNamespace deNamespace = ImportAction.getNamespace(model, dasModel, (DasNamespace)(namespace == null ? dasModel.getCurrentRootNamespace() : namespace));
        boolean created = ((ImportType)((Object)ObjectUtils.assertNotNull((Object)((Object)type)))).isTableCreated();
        DatabaseEditorCapabilities.TableEditorCaps caps = dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(created);
        ImportEditorContext context = new ImportEditorContext(editorContext, caps, consumer, model, name, (ImportType)((Object)ObjectUtils.assertNotNull((Object)((Object)type))), disposable, inputType, deNamespace);
        ImportDialog dialog = new ImportDialog(context);
        Disposer.register((Disposable)disposable, (Disposable)dialog.getDisposable());
        dialog.show();
    }

    @NotNull
    private static VirtualFile getFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/actions/ImportAction", "getFile"));
        }
        VirtualFile root2 = JarFileSystem.getInstance().getJarRootForLocalFile(file);
        if (root2 == null) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction", "getFile"));
            }
            return virtualFile;
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{root2});
        VirtualFile realFile = ImportAction.find(root2.getChildren(), "csv", "txt");
        VirtualFile virtualFile = realFile == null ? file : realFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction", "getFile"));
        }
        return virtualFile;
    }

    @Nullable
    private static VirtualFile find(VirtualFile[] files, String ... extensions) {
        if (extensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "com/intellij/database/actions/ImportAction", "find"));
        }
        if (files == null) {
            return null;
        }
        for (String extension : extensions) {
            VirtualFile fileWithExtension = (VirtualFile)ContainerUtil.find((Object[])files, file -> StringUtil.equalsIgnoreCase((CharSequence)file.getExtension(), (CharSequence)extension));
            if (fileWithExtension == null || fileWithExtension.isDirectory()) continue;
            return fileWithExtension;
        }
        return (VirtualFile)ContainerUtil.find((Object[])files, file -> !file.isDirectory());
    }

    @Nullable
    private static DeNamespace getNamespace(@NotNull DeModel model, @NotNull DasModel dasModel, @Nullable DasNamespace namespace) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/actions/ImportAction", "getNamespace"));
        }
        if (dasModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dasModel", "com/intellij/database/actions/ImportAction", "getNamespace"));
        }
        return namespace == null ? null : (DeNamespace)model.getExportHelper().exportDeep(dasModel, (DasObject)namespace, false);
    }

    public static class ImportEditorContext
    extends DatabaseEditorContext {
        private final DatabaseEditorCapabilities.TableEditorCaps myCaps;
        private final ImportManager myManager;
        private final DbElement myElement;
        private final DeModel myModel;
        private final String myName;
        private final ImportType myType;
        private final Disposable myDisposable;
        private final DeNamespace myNamespace;
        private final List<DbTable> myTables;
        private final InputType myInput;
        private String myTableName;

        public ImportEditorContext(@NotNull DatabaseEditorContext context, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull DbElement element, @NotNull DeModel model, @NotNull String name, @NotNull ImportType type, @NotNull Disposable disposable, @NotNull InputType input, @Nullable DeNamespace namespace) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (caps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            super(context.getProject(), context.getDialect(), context.getModel(), context.getDataSource(), context.getVirtualFile());
            this.myCaps = caps;
            this.myManager = ImportManager.of(context.getDialect(), this.getDataSource() == null ? null : this.getDataSource().getDatabaseProductVersion());
            this.myElement = element;
            this.myModel = model;
            this.myName = name;
            this.myType = type;
            this.myDisposable = disposable;
            this.myNamespace = namespace;
            this.myInput = input;
            this.myTables = this.getContextTables();
        }

        @NotNull
        public InputType getInputType() {
            InputType inputType = this.myInput;
            if (inputType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getInputType"));
            }
            return inputType;
        }

        @NotNull
        public DbElement getElement() {
            DbElement dbElement = this.myElement;
            if (dbElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getElement"));
            }
            return dbElement;
        }

        @NotNull
        public ImportType getImportType() {
            ImportType importType = this.myType;
            if (importType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getImportType"));
            }
            return importType;
        }

        @Override
        @NotNull
        public DeModel getModel() {
            DeModel deModel = this.myModel;
            if (deModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getModel"));
            }
            return deModel;
        }

        @Nullable
        public DeNamespace getNamespace() {
            return this.myNamespace;
        }

        @NotNull
        public Disposable getDisposable() {
            Disposable disposable = this.myDisposable;
            if (disposable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getDisposable"));
            }
            return disposable;
        }

        @NotNull
        public ImportManager getManager() {
            ImportManager importManager = this.myManager;
            if (importManager == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getManager"));
            }
            return importManager;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getName"));
            }
            return string;
        }

        @NotNull
        public DatabaseEditorCapabilities.TableEditorCaps getCaps() {
            DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = this.myCaps;
            if (tableEditorCaps == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getCaps"));
            }
            return tableEditorCaps;
        }

        @NotNull
        public String getTableName() {
            String string = this.myTableName == null ? (this.myTableName = this.getTableNameInternal()) : this.myTableName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getTableName"));
            }
            return string;
        }

        public boolean isTableExists(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/actions/ImportAction$ImportEditorContext", "isTableExists"));
            }
            return ContainerUtil.exists(this.myTables, (Condition)DasUtil.byName((String)name));
        }

        @NotNull
        private String getTableNameInternal() {
            String name;
            if (this.myType.isTableCreated()) {
                String string = this.myElement.getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getTableNameInternal"));
                }
                return string;
            }
            String result = name = FileUtil.getNameWithoutExtension((String)this.myName);
            int index = 1;
            while (this.isTableExists(result)) {
                result = name + "_" + index++;
            }
            String string = result;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getTableNameInternal"));
            }
            return string;
        }

        @NotNull
        private List<DbTable> getContextTables() {
            DbNamespaceImpl namespace = DatabaseView.getLowestSchema(this.myElement);
            if (namespace == null || this.myElement instanceof DbTable) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getContextTables"));
                }
                return list;
            }
            List list = ((JBTreeTraverser)DasUtil.dasTraverser().withRoot((Object)namespace)).filter(DbTable.class).toList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getContextTables"));
            }
            return list;
        }
    }

    public static interface InputType {
        @NotNull
        public ReaderTask.Input createInput(@NotNull ImportInfo var1) throws IOException;

        @NotNull
        public AbstractImportPanel getImportPanel(@NotNull ImportEditorContext var1, @NotNull Runnable var2) throws Exception;

        @Nullable
        public DatabaseSystem getProducerSystem();

        @NotNull
        public String getDialogTitle();

        @NotNull
        public DatabaseDialectEx getDialect();

        @NotNull
        public DeTable createNewTable(@NotNull ImportEditorContext var1, @NotNull DataGrid var2);
    }
}

