/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.util.OpenSourceUtil;
import icons.DatabaseIcons;
import org.jetbrains.annotations.NotNull;

public class OpenTableEditorAction
extends AnAction
implements DumbAware {
    public OpenTableEditorAction() {
        super(DatabaseMessages.message((String)"action.text.open.database.table", (Object[])new Object[]{StringUtil.capitalize((String)DbPresentation.getPresentableName((ObjectKind)ObjectKind.TABLE, (DatabaseDialect)GenericDialect.INSTANCE))}), null, DatabaseIcons.Table);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/OpenTableEditorAction", "update"));
        }
        Navigatable data = (Navigatable)CommonDataKeys.NAVIGATABLE.getData(e.getDataContext());
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        Presentation presentation = e.getPresentation();
        VirtualFile vFile = null;
        DbElement element = null;
        boolean dbFile = false;
        if (project != null && data instanceof OpenFileDescriptor) {
            vFile = ((OpenFileDescriptor)data).getFile();
            dbFile = DbImplUtil.isDatabaseVirtualFile(vFile);
            element = DbImplUtil.findElement(project, vFile);
        } else if (data instanceof DbNodeDescriptor.DbElementNavigatable) {
            element = ((DbNodeDescriptor.DbElementNavigatable)data).getElement();
            dbFile = true;
        }
        if (project != null && dbFile) {
            boolean enabled = element != null && (vFile == null || FileEditorProviderManager.getInstance().getProviders(project, vFile).length > 0);
            String typeName = StringUtil.capitalize((String)(element == null ? "object" : element.getTypeName()));
            presentation.setText(DatabaseMessages.message((String)"action.text.open.database.table", (Object[])new Object[]{typeName}));
            presentation.setEnabled(enabled);
        } else if (data instanceof PsiElement && !(data instanceof DbElement)) {
            presentation.setText(DatabaseMessages.message((String)"action.text.open.sql.table", (Object[])new Object[0]));
            presentation.setEnabled(true);
        } else {
            presentation.setEnabled(false);
        }
        presentation.setVisible(presentation.isEnabled() || ActionPlaces.isToolbarPlace((String)e.getPlace()));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/OpenTableEditorAction", "actionPerformed"));
        }
        OpenSourceUtil.navigate((boolean)true, (Navigatable[])((Navigatable[])CommonDataKeys.NAVIGATABLE_ARRAY.getData(e.getDataContext())));
    }
}

