/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.EditorWindowImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.reference.SoftReference;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import java.awt.Color;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcConsoleProvider
extends PersistenceConsoleProvider {
    private static final FileAttribute ATTACHED_DATASOURCE_ATTR = new FileAttribute("datasource_uuid", 1 + (FSRecords.persistentAttributesList ? 1 : 0), FSRecords.persistentAttributesList);
    private static final Key<WeakReference<JdbcConsole>> JDBC_CONSOLE = Key.create((String)"JDBC_CONSOLE");

    public boolean hasRunners(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/console/JdbcConsoleProvider", "hasRunners"));
        }
        return false;
    }

    public boolean hasRunners(@NotNull PsiElement element, @Nullable Editor editor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/console/JdbcConsoleProvider", "hasRunners"));
        }
        PsiFile file = element.getContainingFile();
        if (DbImplUtil.getDataSourcesForExec(file, true, false).isEmpty()) {
            return false;
        }
        return JdbcConsoleProvider.isSqlAtPlace(file, JdbcConsoleProvider.elementAt(file, element, editor));
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/console/JdbcConsoleProvider", "getRunners"));
        }
        List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcConsoleProvider", "getRunners"));
        }
        return list;
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull PsiElement element, @Nullable Editor editor) {
        PsiElement elementAt;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/console/JdbcConsoleProvider", "getRunners"));
        }
        PsiFile file = element.getContainingFile();
        if (!JdbcConsoleProvider.isSqlAtPlace(file, elementAt = JdbcConsoleProvider.elementAt(file, element, editor))) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcConsoleProvider", "getRunners"));
            }
            return list;
        }
        List<PersistenceConsoleProvider.Runner> list = JdbcConsoleProvider.getRunners(JdbcConsoleProvider.findScriptModel(file, elementAt, editor), true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcConsoleProvider", "getRunners"));
        }
        return list;
    }

    public static List<PersistenceConsoleProvider.Runner> getRunners(@Nullable Info info, boolean ignoreForced) {
        if (info == null || info.model.statements().isEmpty()) {
            return Collections.emptyList();
        }
        Project project = info.originalFile.getProject();
        JBIterable<DbDataSource> dataSources = DbImplUtil.getDataSourcesForExec(info.file, ignoreForced, false);
        if (dataSources.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet allowedIds = ContainerUtil.newHashSet();
        for (DbDataSource source : dataSources) {
            allowedIds.add(source.getUniqueId());
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (JdbcConsole console : JdbcConsole.getActiveConsoles(project)) {
            if (!allowedIds.contains(console.getDataSource().getUniqueId())) continue;
            result.add(new MyConsoleRunner(console, info));
        }
        for (DbDataSource dataSource : dataSources) {
            if (!DbImplUtil.canConnectTo((DbElement)dataSource)) continue;
            result.add(new MyQueryRunner(dataSource, info.file.getText(), info));
        }
        return result;
    }

    @Nullable
    public static Info findScriptModel(@NotNull PsiFile file, @NotNull PsiElement elementAt, @Nullable Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/console/JdbcConsoleProvider", "findScriptModel"));
        }
        if (elementAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementAt", "com/intellij/database/console/JdbcConsoleProvider", "findScriptModel"));
        }
        TextRange selectionRange = ScriptModelUtil.getSelectionForConsole(editor);
        Project project = file.getProject();
        DocumentWindow documentWindow = InjectedLanguageUtil.getDocumentWindow((PsiElement)elementAt);
        if (documentWindow != null && elementAt.getContainingFile() instanceof SqlFile) {
            return JdbcConsoleProvider.findScriptModelInInjection(project, file, elementAt, editor, selectionRange, (DocumentWindowImpl)documentWindow);
        }
        return JdbcConsoleProvider.findScriptModelNoInject(project, file, editor, selectionRange);
    }

    @Nullable
    private static Info findScriptModelNoInject(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull TextRange selectionRange) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/JdbcConsoleProvider", "findScriptModelNoInject"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/console/JdbcConsoleProvider", "findScriptModelNoInject"));
        }
        if (selectionRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionRange", "com/intellij/database/console/JdbcConsoleProvider", "findScriptModelNoInject"));
        }
        JdbcConsole console = JdbcConsole.getConsole(file.getProject(), file.getVirtualFile());
        ScriptModel model = console != null ? console.getScriptModel() : SqlPsiFacade.getInstance((Project)project).createScriptModel(file);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return null;
        }
        ScriptModel m = ScriptModelUtil.adjustModelForSelection(model, document, selectionRange);
        return new Info(file, file, m, (EditorEx)editor, null);
    }

    @Nullable
    private static Info findScriptModelInInjection(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement elementAt, @Nullable Editor editor, @NotNull TextRange selection0, @NotNull DocumentWindowImpl documentWindow) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/JdbcConsoleProvider", "findScriptModelInInjection"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/console/JdbcConsoleProvider", "findScriptModelInInjection"));
        }
        if (elementAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementAt", "com/intellij/database/console/JdbcConsoleProvider", "findScriptModelInInjection"));
        }
        if (selection0 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection0", "com/intellij/database/console/JdbcConsoleProvider", "findScriptModelInInjection"));
        }
        if (documentWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentWindow", "com/intellij/database/console/JdbcConsoleProvider", "findScriptModelInInjection"));
        }
        SqlFile sqlFile = (SqlFile)ObjectUtils.tryCast((Object)elementAt.getContainingFile(), SqlFile.class);
        if (sqlFile == null) {
            return null;
        }
        TextRange selectionInj = editor instanceof EditorWindow || editor == null ? selection0 : EditorUtil.getSelectionInAnyMode((Editor)InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)sqlFile));
        int unescStart = -1;
        int unescEnd = -1;
        SyntaxTraverser s = (SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)sqlFile)).withTraversal(TreeTraversal.LEAVES_DFS);
        StringBuilder unescaped = new StringBuilder();
        int count = s.traverse().size();
        int[] injectedOffsets = new int[count + 1];
        int[] copyOffsets = new int[count + 1];
        copyOffsets[0] = 0;
        injectedOffsets[0] = 0;
        int i2 = 1;
        for (PsiElement e : s) {
            String leafText = InjectedLanguageUtil.getUnescapedLeafText((PsiElement)e, (boolean)false);
            if (leafText == null) continue;
            TextRange r = e.getTextRange();
            if (r.contains(selectionInj.getStartOffset())) {
                unescStart = unescaped.length() + Math.max(leafText.length(), selectionInj.getStartOffset() - r.getStartOffset());
            }
            if (r.contains(selectionInj.getEndOffset())) {
                unescEnd = unescaped.length() + Math.max(leafText.length(), selectionInj.getEndOffset() - r.getStartOffset());
            }
            unescaped.append(leafText);
            injectedOffsets[i2] = r.getEndOffset();
            copyOffsets[i2] = unescaped.length();
            ++i2;
        }
        if (unescStart < 0 || unescEnd < 0) {
            return null;
        }
        TextRange selectionRange = TextRange.create((int)unescStart, (int)unescEnd);
        SqlFile subFile = (SqlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.sql", (Language)sqlFile.getSqlLanguage(), (CharSequence)unescaped.toString(), true, false);
        LightVirtualFile subVirtualFile = (LightVirtualFile)ObjectUtils.assertNotNull((Object)((LightVirtualFile)subFile.getVirtualFile()));
        subVirtualFile.setOriginalFile(PsiUtilCore.getVirtualFile((PsiElement)sqlFile));
        if (editor != null && editor instanceof EditorImpl) {
            editor = EditorWindowImpl.create((DocumentWindowImpl)documentWindow, (EditorImpl)((EditorImpl)editor), (PsiFile)sqlFile);
        }
        ScriptModel model = SqlPsiFacade.getInstance((Project)project).createScriptModel((PsiFile)subFile);
        ScriptModel m = ScriptModelUtil.adjustModelForSelection(model, (Document)documentWindow, selectionRange);
        return new Info(file, (PsiFile)subFile, m, (EditorEx)editor, (NotNullFunction<PsiElement, TextRange>)((NotNullFunction)dom -> JdbcConsoleProvider.calcRangeInInjected(dom, copyOffsets, injectedOffsets)));
    }

    @NotNull
    private static TextRange calcRangeInInjected(PsiElement e, int[] copy, int[] injected) {
        TextRange range = e.getTextRange();
        int i1 = Arrays.binarySearch(copy, range.getStartOffset());
        int i2 = Arrays.binarySearch(copy, range.getEndOffset());
        if (i1 < 0 || i2 < 0) {
            throw new IndexOutOfBoundsException(range + " not found in " + Arrays.toString(copy));
        }
        TextRange textRange = TextRange.create((int)injected[i1], (int)injected[i2]);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcConsoleProvider", "calcRangeInInjected"));
        }
        return textRange;
    }

    public static void chooseStatements(final @NotNull Info info, @Nullable String nothingToRunText, boolean allowOutsideOption, final @NotNull Consumer<ScriptModel<?>> consumer) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/console/JdbcConsoleProvider", "chooseStatements"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/console/JdbcConsoleProvider", "chooseStatements"));
        }
        DatabaseSettings settings = DatabaseSettings.getSettings();
        boolean noUI = nothingToRunText == null;
        final LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        for (ScriptModel.StatementIt it : info.model.statements()) {
            if (map.values().contains(it.range())) continue;
            long offset = it.rangeOffset();
            map.put((PsiElement)it.object(), offset > 0L ? it.range().shiftRight((int)offset) : it.range());
        }
        boolean modelAtCaret = info.model.isAtPosition();
        boolean mapEmptyOrBatches = JBIterable.from(map.keySet()).filter(modelAtCaret ? Conditions.not((Condition)Conditions.instanceOf((Class[])new Class[]{SqlBatchBlock.class, SqlFile.class})) : Conditions.alwaysTrue()).isEmpty();
        if (mapEmptyOrBatches) {
            boolean doDefault = true;
            int option = allowOutsideOption ? settings.executeOutsideOption : -1;
            TextRange range = info.model.getTextRange();
            ScriptModel m = info.model.subModel(null, false);
            if (modelAtCaret && !m.statements().isEmpty()) {
                TextRange tailRange;
                ScriptModel m1;
                TextRange r;
                if (option == 1) {
                    doDefault = false;
                } else if (option == 2) {
                    consumer.consume((Object)m);
                    doDefault = false;
                } else if (option == 3 && (r = (TextRange)m.statements().transform(ScriptModelUtil.TO_RANGE).last()) != null && range.getStartOffset() < r.getEndOffset() && !(m1 = m.subModel(tailRange = TextRange.create((int)range.getStartOffset(), (int)r.getEndOffset()), false)).statements().isEmpty()) {
                    consumer.consume((Object)m1);
                    doDefault = false;
                }
            }
            if (!doDefault) {
                return;
            }
            if (noUI) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (info == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/console/JdbcConsoleProvider", "lambda$chooseStatements$1"));
                }
                HintManager.getInstance().showErrorHint((Editor)info.editor, nothingToRunText);
            });
        } else if (!modelAtCaret) {
            consumer.consume(info.model);
        } else {
            PsiElement element;
            int option = settings.executeInsideOption;
            boolean doDefault = true;
            if (option == 2 || option == 1 && noUI) {
                element = (PsiElement)JBIterable.from(JdbcConsoleProvider.smallToLarge(map)).filter(Conditions.instanceOf(SqlStatement.class)).first();
                consumer.consume((Object)info.model.subModel((TextRange)map.get(element), false));
                doDefault = false;
            } else if (option == 3) {
                element = (PsiElement)JBIterable.from(JdbcConsoleProvider.smallToLarge(map)).filter(Conditions.instanceOf(SqlStatement.class)).last();
                consumer.consume((Object)info.model.subModel((TextRange)map.get(element), false));
                doDefault = false;
            } else if (option == 4) {
                element = (PsiElement)JBIterable.from(JdbcConsoleProvider.smallToLarge(map)).filter(Conditions.instanceOf((Class[])new Class[]{SqlStatement.class, SqlBatchBlock.class})).last();
                consumer.consume((Object)info.model.subModel((TextRange)map.get(element), false));
                doDefault = false;
            } else if (option == 5) {
                ScriptModel m = info.model.subModel(null, false);
                consumer.consume((Object)m);
                doDefault = false;
            } else if (map.size() == 1) {
                consumer.consume((Object)info.model.subModel((TextRange)ContainerUtil.getFirstItem(map.values()), false));
                doDefault = false;
            }
            if (!doDefault) {
                return;
            }
            Pass<PsiElement> pass = new Pass<PsiElement>(){

                public void pass(PsiElement element) {
                    consumer.consume((Object)info.model.subModel((TextRange)map.get(element), false));
                }
            };
            IntroduceTargetChooser.showChooser((Editor)info.editor, JdbcConsoleProvider.smallToLarge(map), (Pass)pass, expression -> StringUtil.first((String)expression.getText().replaceAll("\\s+", " "), (int)50, (boolean)true), (String)"Statements", (NotNullFunction)((NotNullFunction)ObjectUtils.notNull(info.ranger, (Object)ScopeHighlighter.NATURAL_RANGER)));
        }
    }

    @NotNull
    private static List<PsiElement> smallToLarge(@NotNull Map<PsiElement, TextRange> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/database/console/JdbcConsoleProvider", "smallToLarge"));
        }
        List list = ContainerUtil.reverse((List)ContainerUtil.newArrayList(map.keySet()));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcConsoleProvider", "smallToLarge"));
        }
        return list;
    }

    public static boolean isSqlAtPlace(@Nullable PsiFile file, Editor editor) {
        return JdbcConsoleProvider.isSqlAtPlace(file, JdbcConsoleProvider.elementAt(file, null, editor));
    }

    private static boolean isSqlAtPlace(@Nullable PsiFile file, PsiElement elementAt) {
        boolean isInjected = elementAt != null && InjectedLanguageUtil.getDocumentWindow((PsiElement)elementAt) != null;
        return isInjected && PsiTreeUtil.getContextOfType((PsiElement)elementAt, (Class[])new Class[]{SqlFile.class}) != null || file instanceof SqlFile || file != null && file.getFileType() == SqlFileType.INSTANCE;
    }

    @Contract(value="null, _, _->null; _, null, null->null")
    public static PsiElement elementAt(@Nullable PsiFile file, PsiElement element, Editor editor) {
        int offset;
        int n = offset = file == null ? -1 : JdbcConsoleProvider.getOffset(element, editor);
        if (offset < 0) {
            return null;
        }
        PsiElement e = InjectedLanguageUtil.findElementAtNoCommit((PsiFile)file, (int)offset);
        return e != null || offset == 0 ? e : InjectedLanguageUtil.findElementAtNoCommit((PsiFile)file, (int)(offset - 1));
    }

    static int getOffset(@Nullable PsiElement element, @Nullable Editor editor) {
        if (editor != null) {
            return editor.getCaretModel().getOffset();
        }
        if (element != null) {
            return element.getTextRange().getStartOffset();
        }
        return -1;
    }

    public static void doRunQueryInConsole(JdbcConsole console, Info info) {
        JdbcConsoleProvider.chooseStatements(info, "Nothing to run", true, scriptModel -> {
            FileDocumentManager.getInstance().saveAllDocuments();
            if (console.beforeExecuteQueries((ScriptModel<?>)scriptModel)) {
                VirtualFile file = info.editor.getVirtualFile();
                SearchPath before = null;
                try {
                    DatabaseFamilyId familyId;
                    Language language = console.getLanguageConsole().getLanguage();
                    DatabaseFamilyId databaseFamilyId = familyId = language instanceof SqlLanguageDialect ? ((SqlLanguageDialect)language).getDatabaseDialect().getFamilyId() : null;
                    if (DbImplUtil.isDatabaseVirtualFile(file) && (familyId == null || !familyId.isPostgres())) {
                        before = JdbcConsoleProvider.ensureSearchPath(console, SearchPath.of(DatabaseEditorHelper.dbSrcSearchPath(console.getProject(), file, false)));
                    }
                    console.executeQueries((Editor)info.editor, (ScriptModel<?>)scriptModel);
                }
                finally {
                    JdbcConsoleProvider.ensureSearchPath(console, before);
                }
            }
        });
    }

    @Nullable
    private static SearchPath ensureSearchPath(@NotNull JdbcConsole console, @Nullable SearchPath searchPath) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/JdbcConsoleProvider", "ensureSearchPath"));
        }
        SearchPath currentPath = console.getSearchPath();
        if (searchPath != null && !searchPath.equals(currentPath)) {
            console.switchSchema(searchPath, false);
        }
        return currentPath;
    }

    private static void runInnerInner(@NotNull JdbcConsole console, @NotNull Info info) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/JdbcConsoleProvider", "runInnerInner"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/console/JdbcConsoleProvider", "runInnerInner"));
        }
        if (info.editor != null) {
            PsiFile topPsi = InjectedLanguageUtil.getTopLevelFile((PsiElement)info.originalFile);
            VirtualFile virtualFile = (VirtualFile)ObjectUtils.notNull((Object)PsiUtilCore.getVirtualFile((PsiElement)topPsi));
            JdbcConsoleProvider.attachConsole(console.getProject(), console, virtualFile);
        }
        JdbcConsoleProvider.doRunQueryInConsole(console, info);
    }

    public static void attachConsole(@NotNull Project project, @Nullable JdbcConsole console, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/JdbcConsoleProvider", "attachConsole"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/console/JdbcConsoleProvider", "attachConsole"));
        }
        if (DbConsoleRootType.isConsoleFile(file)) {
            return;
        }
        TransactionGuard.submitTransaction((Disposable)project, () -> {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/console/JdbcConsoleProvider", "lambda$attachConsole$4"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/JdbcConsoleProvider", "lambda$attachConsole$4"));
            }
            JDBC_CONSOLE.set((UserDataHolder)file, (Object)(console == null ? null : new WeakReference<JdbcConsole>(console)));
            JdbcConsoleProvider.setAttachedDataSourceId(file, console == null ? null : console.getDataSource().getUniqueId());
            FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{file});
            DatabaseEditorHelper.configureAttachedConsoleToolbar(project, console, file);
        });
    }

    @Nullable
    public static JdbcConsole getAttachedConsole(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        JdbcConsole console = project == null ? null : (JdbcConsole)SoftReference.dereference((Reference)((Reference)JDBC_CONSOLE.get((UserDataHolder)virtualFile)));
        return console != null && console.isValid() ? console : null;
    }

    private static void setAttachedDataSourceId(@NotNull VirtualFile file, @Nullable String uniqueId) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/console/JdbcConsoleProvider", "setAttachedDataSourceId"));
        }
        DbImplUtil.writeVFSAttributeSafe(file, ATTACHED_DATASOURCE_ATTR, uniqueId);
    }

    @Nullable
    public static String getAttachedDataSourceId(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/console/JdbcConsoleProvider", "getAttachedDataSourceId"));
        }
        return DbImplUtil.readVFSAttributeSafe(file, ATTACHED_DATASOURCE_ATTR);
    }

    @Nullable
    private static Color getRunnerColor(@NotNull DbDataSource o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/console/JdbcConsoleProvider", "getRunnerColor"));
        }
        DatabaseColorManager.LocalColors state = (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(o.getProject()).getState();
        boolean useColors = state.useColors && state.inDatabaseView;
        return useColors ? DatabaseColorManager.getColor((DbElement)o) : null;
    }

    public static class Info {
        public final PsiFile originalFile;
        public final PsiFile file;
        public final ScriptModel<?> model;
        public final EditorEx editor;
        public final NotNullFunction<PsiElement, TextRange> ranger;

        public Info(PsiFile originalFile, PsiFile file, ScriptModel<?> model, EditorEx editor, NotNullFunction<PsiElement, TextRange> ranger) {
            this.originalFile = originalFile;
            this.file = file;
            this.model = model;
            this.editor = editor;
            this.ranger = ranger;
        }
    }

    public static class MyConsoleRunner
    extends PersistenceConsoleProvider.Runner {
        private final JdbcConsole myConsole;
        private final Info myInfo;
        private final Color myColor;

        public MyConsoleRunner(@NotNull JdbcConsole console, Info info) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/JdbcConsoleProvider$MyConsoleRunner", "<init>"));
            }
            this.myConsole = console;
            this.myInfo = info;
            this.myColor = DatabaseColorManager.getColor(console.getProject(), console.getLanguageConsole().getVirtualFile(), false);
        }

        public String getDisplayName() {
            return this.myConsole.getTitle();
        }

        public Icon getIcon() {
            return this.myConsole.getDataSource().getIcon(0);
        }

        @Nullable
        public Color getColor() {
            return this.myColor;
        }

        public boolean isAlreadyRunning() {
            return true;
        }

        public void run() {
            if (!this.myConsole.isValid()) {
                return;
            }
            if (this.myInfo.editor instanceof EditorWindow && !((EditorWindow)this.myInfo.editor).isValid()) {
                return;
            }
            JdbcConsoleProvider.runInnerInner(this.myConsole, this.myInfo);
        }
    }

    public static class MyQueryRunner
    extends PersistenceConsoleProvider.Runner {
        private final DbDataSource myDataSource;
        private final CharSequence myText;
        private final Info myInfo;
        private final Color myColor;

        public MyQueryRunner(@NotNull DbDataSource dataSource, CharSequence text, Info info) {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/JdbcConsoleProvider$MyQueryRunner", "<init>"));
            }
            this.myDataSource = dataSource;
            this.myText = text;
            this.myInfo = info;
            this.myColor = JdbcConsoleProvider.getRunnerColor(this.myDataSource);
        }

        public String getDisplayName() {
            return this.myDataSource.getName();
        }

        public Icon getIcon() {
            return this.myDataSource.getIcon();
        }

        @Nullable
        public Color getColor() {
            return this.myColor;
        }

        public boolean isAlreadyRunning() {
            return false;
        }

        public void run() {
            this.runInner(this.myDataSource, this.myText);
        }

        protected void runInner(@NotNull DbDataSource dataSource, @Nullable CharSequence text) {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/JdbcConsoleProvider$MyQueryRunner", "runInner"));
            }
            JdbcConsole console = JdbcConsole.newConsole(dataSource.getProject()).fromDataSource((DatabaseSystem)dataSource).forFile(DatabaseEditorHelper.createNewConsoleVirtualFile((DatabaseSystem)dataSource)).withQuery(text).buildAndShow(false);
            JdbcConsoleProvider.runInnerInner(console, this.myInfo);
        }
    }
}

