/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryDomain
extends Domain {
    private final Cardinality.ElementsCardinality myCardinality;
    private final long myUpperBound;
    private final long myDefaultValue;
    private final boolean myNarrowable;

    public BinaryDomain(@NotNull String name, @NotNull ConversionPoint descriptor, long upperBound) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/domain/BinaryDomain", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/BinaryDomain", "<init>"));
        }
        this(name, descriptor, upperBound, -1L, false);
    }

    /*
     * WARNING - void declaration
     */
    public BinaryDomain(@NotNull String name, @NotNull ConversionPoint descriptor, long upperBound, long defaultValue, boolean bl) {
        void narrowable;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/domain/BinaryDomain", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/BinaryDomain", "<init>"));
        }
        this(name, descriptor, PhysicalDomainType.BINARY, upperBound, defaultValue, (boolean)narrowable);
    }

    /*
     * WARNING - void declaration
     */
    public BinaryDomain(@NotNull String name, @NotNull ConversionPoint descriptor, @NotNull PhysicalDomainType type, long upperBound, long defaultValue, boolean bl) {
        void narrowable;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/domain/BinaryDomain", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/BinaryDomain", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/data/types/domain/BinaryDomain", "<init>"));
        }
        super(descriptor, type, name);
        this.myUpperBound = upperBound;
        this.myDefaultValue = defaultValue;
        this.myNarrowable = narrowable;
        this.myCardinality = new Cardinality.ElementsCardinality(this.myUpperBound);
    }

    public long getUpperBound() {
        return this.myUpperBound;
    }

    @Override
    @NotNull
    public Cardinality cardinality() {
        Cardinality.ElementsCardinality elementsCardinality = this.myCardinality;
        if (elementsCardinality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/BinaryDomain", "cardinality"));
        }
        return elementsCardinality;
    }

    @Override
    @NotNull
    public Compatibility getCompatibility(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/BinaryDomain", "getCompatibility"));
        }
        Compatibility compatibility = domain instanceof BinaryDomain ? (((BinaryDomain)domain).getUpperBound() <= this.getUpperBound() ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.compatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType())) : Compatibility.uncompatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType());
        if (compatibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/BinaryDomain", "getCompatibility"));
        }
        return compatibility;
    }

    @Override
    @Nullable
    public Object trim(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/domain/BinaryDomain", "trim"));
        }
        return o instanceof byte[] && this.getUpperBound() > 0L ? (Object)Arrays.copyOf((byte[])o, (int)Math.min(this.getUpperBound(), (long)((byte[])o).length)) : o;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/BinaryDomain", "narrow"));
        }
        BinaryDomain binaryDomain = this.myNarrowable && domain instanceof BinaryDomain ? new BinaryDomain(this.simpleName(), this.getPoint(), Math.min(((BinaryDomain)domain).getUpperBound(), this.getUpperBound()), this.myDefaultValue, true) : this;
        if (binaryDomain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/BinaryDomain", "narrow"));
        }
        return binaryDomain;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/data/types/domain/BinaryDomain", "narrow"));
        }
        BinaryDomain binaryDomain = this.myNarrowable ? new BinaryDomain(this.simpleName(), this.getPoint(), Math.min((long)provider.getSize(), this.myUpperBound), this.myDefaultValue, true) : this;
        if (binaryDomain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/BinaryDomain", "narrow"));
        }
        return binaryDomain;
    }

    @Override
    @NotNull
    public String name() {
        String string = this.myNarrowable && this.myDefaultValue != this.getUpperBound() && this.getUpperBound() > 0L ? this.simpleName() + "(" + this.getUpperBound() + ")" : super.name();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/BinaryDomain", "name"));
        }
        return string;
    }

    protected long getDefaultValue() {
        return this.myDefaultValue;
    }

    protected boolean isNarrowable() {
        return this.myNarrowable;
    }
}

