/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.CustomNumber2Domain;
import com.intellij.database.data.types.domain.Number2Domain;
import org.jetbrains.annotations.NotNull;

public class OraNumber2Domain
extends CustomNumber2Domain {
    private static final int UNSPECIFIED_SCALE = -127;
    private static final int UNSPECIFIED_PRECISION = 0;

    public OraNumber2Domain(@NotNull String name, @NotNull ConversionPoint point, int maxPrecision, int maxScale, boolean narrowable) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/domain/OraNumber2Domain", "<init>"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/database/data/types/domain/OraNumber2Domain", "<init>"));
        }
        super(name, point, maxPrecision, maxScale, narrowable);
    }

    public OraNumber2Domain(@NotNull Number2Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/OraNumber2Domain", "<init>"));
        }
        super(domain);
    }

    @Override
    @NotNull
    protected Number2Domain narrowFromDomain(@NotNull Number2Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/OraNumber2Domain", "narrowFromDomain"));
        }
        OraNumber2Domain oraNumber2Domain = new OraNumber2Domain(domain);
        if (oraNumber2Domain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/OraNumber2Domain", "narrowFromDomain"));
        }
        return oraNumber2Domain;
    }

    @Override
    protected boolean isNotSpecified() {
        return this.getMaxScale() == -127 && this.getMaxPrecision() == 0;
    }
}

