/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.util.ErrorHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncUtil {
    public static final Executor POOL_EXECUTOR = command -> ApplicationManager.getApplication().executeOnPooledThread(command);
    public static final Executor EDT_EXECUTOR = command -> UIUtil.invokeLaterIfNeeded((Runnable)command);
    public static final Executor NON_EDT_EXECUTOR = command -> {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            POOL_EXECUTOR.execute(command);
        } else {
            command.run();
        }
    };
    private static final Logger LOG = Logger.getInstance(AsyncUtil.class);
    private static final Key<Boolean> ASYNC_FRIENDLY = Key.create((String)"ASYNC_FRIENDLY");

    public static Executor transactionExecutor(@NotNull Disposable d) {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/intellij/database/dataSource/AsyncUtil", "transactionExecutor"));
        }
        return command -> {
            if (d == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/intellij/database/dataSource/AsyncUtil", "lambda$transactionExecutor$3"));
            }
            TransactionGuard.submitTransaction((Disposable)d, (Runnable)command);
        };
    }

    @NotNull
    public static <T, U> Function<T, U> captureIndicator(@NotNull Function<T, U> foo) {
        if (foo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foo", "com/intellij/database/dataSource/AsyncUtil", "captureIndicator"));
        }
        ProgressIndicator indicator = AsyncUtil.getAsyncFriendlyIndicator();
        Function<Object, Object> function = x -> {
            if (foo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foo", "com/intellij/database/dataSource/AsyncUtil", "lambda$captureIndicator$5"));
            }
            return AsyncUtil.underProgress(() -> {
                if (foo == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foo", "com/intellij/database/dataSource/AsyncUtil", "lambda$null$4"));
                }
                return foo.apply(x);
            }, indicator);
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/AsyncUtil", "captureIndicator"));
        }
        return function;
    }

    @NotNull
    public static <T> Supplier<T> captureIndicator(@NotNull Supplier<T> foo) {
        if (foo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foo", "com/intellij/database/dataSource/AsyncUtil", "captureIndicator"));
        }
        ProgressIndicator indicator = AsyncUtil.getAsyncFriendlyIndicator();
        Supplier<Object> supplier = () -> {
            if (foo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foo", "com/intellij/database/dataSource/AsyncUtil", "lambda$captureIndicator$7"));
            }
            return AsyncUtil.underProgress(() -> AsyncUtil.lambda$null$6((Supplier)foo), indicator);
        };
        if (supplier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/AsyncUtil", "captureIndicator"));
        }
        return supplier;
    }

    @Nullable
    public static ProgressIndicator getAsyncFriendlyIndicator() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (AsyncUtil.isAsyncFriendly(indicator)) {
            return indicator;
        }
        LOG.warn("Expected async friendly progress indicator, got " + indicator);
        return new EmptyProgressIndicator();
    }

    public static void rethrowUnwrapped(@NotNull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/AsyncUtil", "rethrowUnwrapped"));
        }
        Throwable tmp = e;
        while (tmp != null && (tmp instanceof CompletionException || tmp instanceof ExecutionException) && e.getCause() != null) {
            tmp = e.getCause();
        }
        ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
    }

    public static boolean isAsyncFriendly(@Nullable ProgressIndicator indicator) {
        return indicator == null || indicator instanceof EmptyProgressIndicator || indicator instanceof UserDataHolder && ASYNC_FRIENDLY.get((UserDataHolder)indicator) == Boolean.TRUE;
    }

    public static <T extends ProgressIndicator> T markAsyncFriendly(@Nullable T indicator, boolean friendly) {
        if (indicator instanceof UserDataHolder) {
            ASYNC_FRIENDLY.set((UserDataHolder)indicator, (Object)(friendly ? Boolean.TRUE : null));
        }
        return indicator;
    }

    public static <T> CompletionStage<T> supplyAsync(@NotNull Supplier<CompletionStage<T>> s, @NotNull Executor e) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/dataSource/AsyncUtil", "supplyAsync"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/AsyncUtil", "supplyAsync"));
        }
        return CompletableFuture.completedFuture(null).thenComposeAsync(AsyncUtil.captureIndicator((T x) -> {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/dataSource/AsyncUtil", "lambda$supplyAsync$8"));
            }
            return (CompletionStage)s.get();
        }), e);
    }

    public static <T> T underProgress(@NotNull Computable<T> r, @Nullable ProgressIndicator indicator) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/dataSource/AsyncUtil", "underProgress"));
        }
        Ref res = Ref.create();
        AsyncUtil.underProgress(() -> {
            if (r == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/dataSource/AsyncUtil", "lambda$underProgress$9"));
            }
            res.set(r.compute());
        }, indicator);
        return (T)res.get();
    }

    public static void underProgress(@NotNull Runnable r, @Nullable ProgressIndicator indicator) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/dataSource/AsyncUtil", "underProgress"));
        }
        if (indicator != null) {
            indicator.checkCanceled();
        }
        ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            if (r == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/dataSource/AsyncUtil", "lambda$underProgress$10"));
            }
            r.run();
        }, indicator);
    }

    @NotNull
    public static <T> CompletionStage<T> runTask(@NotNull Computable<CompletionStage<T>> r, @NotNull ProgressIndicatorEx indicator) {
        CompletionStage<Object> res;
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/dataSource/AsyncUtil", "runTask"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/AsyncUtil", "runTask"));
        }
        indicator.start();
        try {
            res = AsyncUtil.underProgress(r, (ProgressIndicator)indicator);
        }
        catch (Throwable th) {
            indicator.stop();
            indicator.processFinish();
            CompletableFuture<T> completableFuture = AsyncUtil.exceptional(th);
            if (completableFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/AsyncUtil", "runTask"));
            }
            return completableFuture;
        }
        res.whenComplete((t, throwable) -> {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/AsyncUtil", "lambda$runTask$11"));
            }
            indicator.stop();
            indicator.processFinish();
        });
        CompletionStage<Object> completionStage = res;
        if (completionStage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/AsyncUtil", "runTask"));
        }
        return completionStage;
    }

    public static ProgressIndicatorEx createBackgroundIndicator(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/AsyncUtil", "createBackgroundIndicator"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/AsyncUtil", "createBackgroundIndicator"));
        }
        return (ProgressIndicatorEx)AsyncUtil.markAsyncFriendly(new BackgroundableProcessIndicator(project, name, PerformInBackgroundOption.ALWAYS_BACKGROUND, CommonBundle.getCancelButtonText(), CommonBundle.getCancelButtonText(), true), true);
    }

    public static <T> CompletableFuture<T> cancelled() {
        CompletableFuture res = new CompletableFuture();
        res.cancel(false);
        return res;
    }

    public static <T> CompletableFuture<T> exceptional(@NotNull Throwable th) {
        if (th == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "th", "com/intellij/database/dataSource/AsyncUtil", "exceptional"));
        }
        CompletableFuture res = new CompletableFuture();
        res.completeExceptionally(th);
        return res;
    }

    public static boolean isCancellation(@Nullable Throwable e) {
        return e instanceof ProcessCanceledException || e instanceof CancellationException || (e instanceof CompletionException || e instanceof ExecutionException) && AsyncUtil.isCancellation(e.getCause());
    }

    public static void addUnhandledError(@NotNull ErrorHandler errorHandler, @Nullable Throwable e, @NotNull String name, @NotNull DatabaseFamilyId familyId) {
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/intellij/database/dataSource/AsyncUtil", "addUnhandledError"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/AsyncUtil", "addUnhandledError"));
        }
        if (familyId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyId", "com/intellij/database/dataSource/AsyncUtil", "addUnhandledError"));
        }
        if (e != null && !AsyncUtil.isCancellation(e)) {
            errorHandler.addError(JdbcEngine.getErrorMessage(e, name, familyId), e);
        }
    }

    private static /* synthetic */ Object lambda$null$6(@NotNull Supplier foo) {
        if (foo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foo", "com/intellij/database/dataSource/AsyncUtil", "lambda$null$6"));
        }
        return foo.get();
    }
}

