/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceOptionsEditor;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DefaultsInstaller;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.Case;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.dbm.common.IntrospectionScopes;
import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeHelper;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.HintHint;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.UI;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceOptionsPanel {
    private static final String SCHEMA_LOADING_ERROR = "SCHEMA_LOADING_ERROR";
    private static final String ASTERISK = "*";
    private final DataSourceConfigurable myDialog;
    private JPanel myRootPanel;
    private JPanel myTablePanel;
    private JBCheckBox myLegacyIntrospector;
    private JEditorPane myObjectFilterHelp;
    private RawCommandLineEditor myObjectFilterField;
    private DataSourceOptionsEditor myOptionsPanel;
    private JPanel myOptionsPanelComponent;
    private JPanel myTableWrapper;
    private ComboBox<DBIntrospectionOptions.SourceLoading> mySourceLoading;
    private JPanel mySourceLoadingPanel;
    private final TreeTable mySchemasTable;
    private final JBLoadingPanel myLoadingPanel;
    private final DefaultsInstaller myDefaultsInstaller;
    private Object mySavedKey;
    @NotNull
    private MultiMap<String, String> myAllSchemaNames;
    private static final DataKey<DataSourceOptionsPanel> OPTIONS_PANEL = DataKey.create((String)"OPTIONS_PANEL");
    private static final DefaultActionGroup TABLE_POPUP = new DefaultActionGroup(new AnAction[]{new AnAction("Refresh", "Refresh Schemas", AllIcons.Actions.Refresh){

        public void actionPerformed(AnActionEvent e) {
            DataSourceOptionsPanel panel = (DataSourceOptionsPanel)OPTIONS_PANEL.getData(e.getDataContext());
            if (panel == null) {
                return;
            }
            panel.refreshSchemas(panel.getTitle(), true);
        }
    }});

    public DataSourceOptionsPanel(@NotNull DataSourceConfigurable dialog) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/dataSource/DataSourceOptionsPanel", "<init>"));
        }
        this.myAllSchemaNames = new MultiMap();
        this.myDialog = dialog;
        this.myOptionsPanel = new DataSourceOptionsEditor(dialog);
        this.myLoadingPanel = new JBLoadingPanel(new BorderLayout(), this.myDialog){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return new Dimension(size.width, size.height / 3 * 2);
            }
        };
        EventDispatcher myEventDispatcher = EventDispatcher.create(CheckboxTreeListener.class);
        final CheckboxTreeHelper helper = new CheckboxTreeHelper(CheckboxTreeHelper.DEFAULT_POLICY, myEventDispatcher);
        this.mySchemasTable = new TreeTableView(DataSourceOptionsPanel.emptyModel()){

            public void setModel(TreeTableModel treeTableModel) {
                super.setModel(treeTableModel);
                helper.initTree((Tree)this.getTree(), (JComponent)((Object)this), new CheckboxTreeBase.CheckboxTreeCellRendererBase(){

                    public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                        if (value instanceof CheckedTreeNode) {
                            ColoredTreeCellRenderer renderer = this.getTextRenderer();
                            renderer.append(value.toString());
                            this.getCheckbox().setSelected(((CheckedTreeNode)value).isChecked());
                            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)DataSourceOptionsPanel.this.mySchemasTable, (SimpleColoredComponent)renderer, (boolean)false, (boolean)selected);
                        }
                    }
                });
                this.getTree().setRootVisible(true);
            }
        };
        this.$$$setupUI$$$();
        this.mySourceLoading.setModel((ComboBoxModel)new EnumComboBoxModel(DBIntrospectionOptions.SourceLoading.class));
        this.mySourceLoading.setRenderer((ListCellRenderer)new ListCellRendererWrapper<DBIntrospectionOptions.SourceLoading>(){

            public void customize(JList list, DBIntrospectionOptions.SourceLoading value, int index, boolean selected, boolean hasFocus) {
                String text = "None";
                if (value == DBIntrospectionOptions.SourceLoading.USER_AND_SYSTEM_SOURCES) {
                    text = "All schemas";
                }
                if (value == DBIntrospectionOptions.SourceLoading.USER_SOURCES) {
                    text = "Except system schemas";
                }
                this.setText(text);
            }
        });
        this.mySourceLoadingPanel.setVisible(DbSrcStorage.isEnabled());
        this.myRootPanel.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        this.mySchemasTable.setTableHeader(null);
        this.myLoadingPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.mySchemasTable));
        this.myLoadingPanel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)1, (int)1, (int)1, (int)1));
        this.myTablePanel.add((Component)this.myLoadingPanel, "Center");
        LocalDataSource dataSource = (LocalDataSource)((Object)this.myDialog.getDataSource());
        this.myDefaultsInstaller = new DefaultsInstaller(dataSource);
        this.myObjectFilterField.setText(StringUtil.notNullize((String)dataSource.getTablePattern()));
        this.myObjectFilterHelp.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                RegExHelpPopup.createRegExLinkRunnable((Component)this.myRootPanel, null).run();
            }
        });
        this.myLegacyIntrospector.setVisible(DBIntrospectorFactory.hasModerIntrospector(GenericIntrospectorLegacyModelUtils.findRdbms(DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource))));
        this.myLegacyIntrospector.setSelected(dataSource.useLegacyIntrospector());
        this.mySourceLoading.setSelectedItem((Object)dataSource.getSourceLoading());
        this.myDefaultsInstaller.setIntrospectionScope(dataSource.getIntrospectionScope());
        this.myDefaultsInstaller.setDefaultSchemas(dataSource.getResolveScope());
        this.setupTableView();
        this.myTableWrapper.setBorder(IdeBorderFactory.createEmptyBorder((int)6, (int)0, (int)4, (int)0));
    }

    public void setSourceLoading(@NotNull DBIntrospectionOptions.SourceLoading mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/database/dataSource/DataSourceOptionsPanel", "setSourceLoading"));
        }
        this.mySourceLoading.setSelectedItem((Object)mode);
    }

    @NotNull
    private static ListTreeTableModelOnColumns emptyModel() {
        ListTreeTableModelOnColumns listTreeTableModelOnColumns = new ListTreeTableModelOnColumns(null, DataSourceOptionsPanel.getColumns());
        if (listTreeTableModelOnColumns == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel", "emptyModel"));
        }
        return listTreeTableModelOnColumns;
    }

    @NotNull
    private static ColumnInfo[] getColumns() {
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new TreeColumnInfo("Resolve Unqualified References")};
        if (columnInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel", "getColumns"));
        }
        return columnInfoArray;
    }

    private void setupTableView() {
        new TreeTableSpeedSearch(this.mySchemasTable);
        boolean visible = !this.getNamespaces().isEmpty();
        this.mySchemasTable.setVisible(visible);
        this.mySchemasTable.setSelectionMode(0);
        this.mySchemasTable.setCellSelectionEnabled(true);
        this.mySchemasTable.getEmptyText().setText("");
        if (!visible) {
            return;
        }
        PopupHandler.installPopupHandler((JComponent)this.mySchemasTable, (ActionGroup)TABLE_POPUP, (String)"unknown", (ActionManager)ActionManager.getInstance());
        DataManager.registerDataProvider((JComponent)this.mySchemasTable, dataId -> OPTIONS_PANEL.getName().equals(dataId) ? this : null);
        new UiNotifyConnector((Component)this.myRootPanel, new Activatable(){

            public void showNotify() {
                ApplicationManager.getApplication().invokeLater(() -> DataSourceOptionsPanel.this.refreshSchemas(DataSourceOptionsPanel.this.getTitle(), false));
            }

            public void hideNotify() {
            }
        });
    }

    @NotNull
    private String getTitle() {
        String string = StringUtil.join(this.getNamespaces(), kind -> StringUtil.capitalize((String)StringUtil.pluralize((String)DbPresentation.getPresentableName((ObjectKind)kind, (DatabaseDialect)this.getDialect()))), (String)" and ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel", "getTitle"));
        }
        return string;
    }

    @NotNull
    private Set<ObjectKind> getNamespaces() {
        Set set = this.getDialect().getMetaModel().getNamespaces();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel", "getNamespaces"));
        }
        return set;
    }

    @NotNull
    private DatabaseDialectEx getDialect() {
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect((RawConnectionConfig)this.myDialog.getDataSource()), (Object)GenericDialect.INSTANCE);
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel", "getDialect"));
        }
        return databaseDialectEx;
    }

    public void refreshSchemas(String columnTitle, boolean force) {
        boolean emptyProps;
        LocalDataSource tempDataSource = this.myDialog.getTempDataSourceForConnection();
        boolean bl = emptyProps = StringUtil.isEmptyOrSpaces((String)tempDataSource.getDriverClass()) || StringUtil.isEmptyOrSpaces((String)tempDataSource.getUrl());
        if (emptyProps) {
            this.mySchemasTable.setModel((TreeTableModel)DataSourceOptionsPanel.emptyModel());
            this.mySchemasTable.getEmptyText().setText("No " + columnTitle);
            return;
        }
        Object newSavedUrl = this.myDialog.createKey(tempDataSource);
        if (!force && Comparing.equal((Object)this.mySavedKey, (Object)newSavedUrl)) {
            return;
        }
        this.mySchemasTable.getEmptyText().setText("");
        this.mySavedKey = newSavedUrl;
        Ref currentCatalogRef = Ref.create();
        Project project = this.myDialog.getProject();
        this.myLoadingPanel.startLoading();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ErrorHandler errorHandler = new ErrorHandler();
            DatabaseConnectionManager.getInstance().performJdbcOperationAsync(project, tempDataSource, errorHandler, (connection, indicator) -> {
                if (!Comparing.equal((Object)this.mySavedKey, (Object)newSavedUrl)) {
                    return AsyncUtil.cancelled();
                }
                this.mySavedKey = this.myDialog.createKey(tempDataSource);
                this.myAllSchemaNames = this.loadSchemaNamesAndSetIntrospectionScopeByDefault(connection, (LocalDataSource)((Object)((Object)((Object)this.myDialog.getDataSource()))));
                DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(tempDataSource);
                if (dialect.getFamilyId().isMysql()) {
                    boolean toInvert = true;
                    MultiMap inverted = MultiMap.createLinked();
                    for (Map.Entry entry : this.myAllSchemaNames.entrySet()) {
                        Collection db = (Collection)entry.getValue();
                        if (db.isEmpty()) continue;
                        if (!JBIterable.from((Iterable)db).filter(x -> DataSourceOptionsPanel.realName(x)).isEmpty()) {
                            toInvert = false;
                            break;
                        }
                        inverted.putValue((Object)ASTERISK, entry.getKey());
                    }
                    if (toInvert) {
                        this.myAllSchemaNames = inverted;
                    }
                }
                Case casing = dialect.getCasing(ObjectKind.SCHEMA, null).choose(true);
                this.myDefaultsInstaller.setupIntrospectionScopeByDefault(connection, casing.apply(this.myDialog.getUserName()));
                currentCatalogRef.set((Object)connection.getCatalog());
                return null;
            }).whenCompleteAsync((r, e) -> {
                if (Disposer.isDisposed((Disposable)this.myDialog)) {
                    return;
                }
                if (!Comparing.equal((Object)this.mySavedKey, (Object)this.myDialog.createKey(tempDataSource))) {
                    return;
                }
                this.myLoadingPanel.stopLoading();
                AsyncUtil.addUnhandledError(errorHandler, e, this.myDialog.getNameValue(), DbImplUtil.getDatabaseDialect(tempDataSource).getFamilyId());
                String emptyText = errorHandler.hasErrors() ? "Error Loading " + columnTitle : "No " + columnTitle + " Found";
                this.mySchemasTable.getEmptyText().setText(emptyText);
                if (tempDataSource.getFirstSync() == ThreeState.YES) {
                    tempDataSource.setFirstSync(ThreeState.NO);
                }
                this.mySchemasTable.setModel(this.createModel(this.myAllSchemaNames));
                if (errorHandler.hasErrors()) {
                    this.myDialog.getController().showErrorNotification((Configurable)this.myDialog, SCHEMA_LOADING_ERROR, "Error", errorHandler.getSummary(), new Object[0]);
                } else {
                    this.myDialog.updateDatabaseInfo(tempDataSource);
                    this.myDialog.showErrorNotification(null, SCHEMA_LOADING_ERROR);
                }
            }, AsyncUtil.EDT_EXECUTOR);
        });
    }

    @NotNull
    private TreeTableModel createModel(@NotNull MultiMap<String, String> schemas2) {
        if (schemas2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemas", "com/intellij/database/dataSource/DataSourceOptionsPanel", "createModel"));
        }
        if (schemas2.isEmpty()) {
            ListTreeTableModelOnColumns listTreeTableModelOnColumns = DataSourceOptionsPanel.emptyModel();
            if (listTreeTableModelOnColumns == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel", "createModel"));
            }
            return listTreeTableModelOnColumns;
        }
        boolean singleRoot = this.getNamespaces().size() == 1;
        MyCheckedTreeNode root2 = new MyCheckedTreeNode((Couple<String>)Couple.of((Object)ASTERISK, (Object)ASTERISK));
        for (Map.Entry e : schemas2.entrySet()) {
            String database = (String)e.getKey();
            if (ASTERISK.equals(database) && ((Collection)e.getValue()).size() == 1 && ASTERISK.equals(ContainerUtil.getFirstItem((Collection)((Collection)e.getValue())))) continue;
            MyCheckedTreeNode db = new MyCheckedTreeNode((Couple<String>)Couple.of((Object)database, (Object)ASTERISK), true);
            if (!singleRoot) {
                root2.add((MutableTreeNode)((Object)db));
            }
            for (String schema : (Collection)e.getValue()) {
                if (!DataSourceOptionsPanel.realName(schema)) continue;
                (singleRoot ? root2 : db).add((MutableTreeNode)((Object)new MyCheckedTreeNode((Couple<String>)Couple.of((Object)database, (Object)schema))));
            }
        }
        ListTreeTableModelOnColumns listTreeTableModelOnColumns = new ListTreeTableModelOnColumns((TreeNode)((Object)root2), DataSourceOptionsPanel.getColumns());
        if (listTreeTableModelOnColumns == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel", "createModel"));
        }
        return listTreeTableModelOnColumns;
    }

    private static boolean realName(@Nullable String name) {
        return !StringUtil.isEmpty((String)name) && !ASTERISK.equals(name);
    }

    @NotNull
    public MultiMap<String, String> loadSchemaNamesAndSetIntrospectionScopeByDefault(@NotNull Connection connection, @NotNull LocalDataSource dataSource) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DataSourceOptionsPanel", "loadSchemaNamesAndSetIntrospectionScopeByDefault"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceOptionsPanel", "loadSchemaNamesAndSetIntrospectionScopeByDefault"));
        }
        DatabaseMetaData metaData = connection.getMetaData();
        dataSource.refreshDatabaseInfo(metaData);
        MultiMap result = MultiMap.createLinkedSet();
        DatabaseMetaDataWrapper meta = DatabaseMetaDataWrapper.create(connection, metaData, new ErrorHandler(), DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource));
        for (DatabaseMetaDataWrapper.Schema schema : JBIterable.once(meta.schemas(true))) {
            result.putValue((Object)StringUtil.notNullize((String)schema.database), (Object)StringUtil.notNullize((String)schema.schema));
        }
        for (String d : result.keySet()) {
            result.putValue((Object)d, (Object)ASTERISK);
        }
        result.putValue((Object)ASTERISK, (Object)ASTERISK);
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel", "loadSchemaNamesAndSetIntrospectionScopeByDefault"));
        }
        return multiMap;
    }

    public JPanel getComponent() {
        return this.myRootPanel;
    }

    public void saveData(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceOptionsPanel", "saveData"));
        }
        dataSource.setResolveScope(this.myDefaultsInstaller.getDefaultSchemas());
        dataSource.setTablePattern(StringUtil.nullize((String)this.myObjectFilterField.getText()));
        dataSource.setUseLegacyIntrospector(this.myLegacyIntrospector.isSelected());
        dataSource.setSourceLoading((DBIntrospectionOptions.SourceLoading)((Object)ObjectUtils.chooseNotNull((Object)((Object)((DBIntrospectionOptions.SourceLoading)((Object)this.mySourceLoading.getSelectedItem()))), (Object)((Object)DBIntrospectionOptions.SourceLoading.NO_SOURCES))));
        this.myOptionsPanel.saveData(dataSource);
    }

    public void reset(LocalDataSource source) {
        this.myOptionsPanel.reset(source);
        this.mySourceLoading.setSelectedItem((Object)source.getSourceLoading());
        this.myDefaultsInstaller.setDefaultSchemas(source.getResolveScope());
    }

    private void createUIComponents() {
        this.myObjectFilterField = new RawCommandLineEditor(s -> JBIterable.of((Object[])s.split("\\|\\|")).transform(StringUtil.TRIMMER).toList(), strings -> StringUtil.join((Iterable)JBIterable.from((Iterable)strings).transform(StringUtil.TRIMMER), (String)"||"));
        this.myObjectFilterField.setDialogCaption("Object Filter");
        this.myObjectFilterHelp = IdeTooltipManager.initPane((String)"", (HintHint)new HintHint(), null);
        this.myObjectFilterHelp.setEditable(false);
        NonOpaquePanel.setTransparent((JComponent)this.myObjectFilterHelp);
        this.myObjectFilterHelp.setBorder(null);
        this.myObjectFilterHelp.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        StyleSheet sheet = ((HTMLDocument)this.myObjectFilterHelp.getDocument()).getStyleSheet();
        sheet.addRule("a { color: #" + ColorUtil.toHex((Color)UI.getColor((String)"link.foreground")) + " }");
        sheet.addRule("ol { margin: 0px; padding-left: 10px; padding-bottom: 4px; list-style-type:none; }");
        sheet.addRule(UIUtil.displayPropertiesToCSS((Font)JBUI.Fonts.smallFont(), (Color)UIUtil.getLabelDisabledForeground()));
        this.myObjectFilterHelp.setText("<html>A &lt;pattern&gt; or a list of &lt;type&gt;:[-]&lt;pattern&gt; separated by ||. Where:<ol>  <li>&lt;type&gt; is a <b>table</b>, <b>view</b>, <b>mview</b>, <b>sequence</b>, <b>routine</b>, <b>package</b> or <b>synonym</b>,</li>  <li>&lt;pattern&gt is a <a href=\"#help\">regular expression</a>; prepend with - (minus) for exclusion.</li></ol>Examples: <b>table:CUR_.*</b> or <b>table:-OLD_.*||routine:DO.*||view:V_.*</b></html>");
        this.myObjectFilterHelp.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)4, (int)4, (int)4));
        this.myOptionsPanelComponent = this.myOptionsPanel.getComponent();
    }

    @Nullable
    private static Couple<String> databaseAndSchema(@NotNull DefaultMutableTreeNode o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/dataSource/DataSourceOptionsPanel", "databaseAndSchema"));
        }
        return (Couple)ObjectUtils.tryCast((Object)o.getUserObject(), Couple.class);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myRootPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JEditorPane jEditorPane = this.myObjectFilterHelp;
        jPanel5.add((Component)jEditorPane, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 0, null, new Dimension(150, 50), null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Object filter:");
        jBLabel.setDisplayedMnemonic('F');
        jBLabel.setDisplayedMnemonicIndex(7);
        jPanel5.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        RawCommandLineEditor rawCommandLineEditor = this.myObjectFilterField;
        jPanel5.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel6 = this.myOptionsPanelComponent;
        jPanel5.add((Component)jPanel6, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myTableWrapper = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTablePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Resolve unqualified references:");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLegacyIntrospector = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Introspect using JDBC metadata");
        jBCheckBox.setMnemonic('M');
        jBCheckBox.setDisplayedMnemonicIndex(22);
        jPanel4.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.mySourceLoadingPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 8, 2, 3, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Load sources for");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.mySourceLoading = comboBox = new ComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        comboBox.setModel(defaultComboBoxModel);
        jPanel.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        jBLabel.setLabelFor((Component)rawCommandLineEditor);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private class MyCheckedTreeNode
    extends CheckedTreeNode {
        private final boolean myDb;

        public MyCheckedTreeNode(Couple<String> s) {
            this(s, false);
        }

        public MyCheckedTreeNode(Couple<String> s, boolean db) {
            super(s);
            this.myDb = db;
        }

        public boolean isChecked() {
            return DataSourceOptionsPanel.this.myDefaultsInstaller.getDefaultSchemas().containsSchema((Couple<String>)DataSourceOptionsPanel.databaseAndSchema((DefaultMutableTreeNode)((Object)this)));
        }

        public void setChecked(boolean checked) {
            Couple couple = DataSourceOptionsPanel.databaseAndSchema((DefaultMutableTreeNode)((Object)this));
            if (couple == null) {
                return;
            }
            String first = (String)couple.first;
            String second = (String)couple.second;
            MultiMap<String, String> map = DataSourceOptionsPanel.this.myDefaultsInstaller.getDefaultSchemas().applyToContext((MultiMap<String, String>)DataSourceOptionsPanel.this.myAllSchemaNames);
            if (checked) {
                map.putValue((Object)first, (Object)second);
            } else {
                map.remove((Object)first, (Object)second);
                map.remove((Object)first, (Object)DataSourceOptionsPanel.ASTERISK);
                map.remove((Object)DataSourceOptionsPanel.ASTERISK, (Object)DataSourceOptionsPanel.ASTERISK);
            }
            DataSourceOptionsPanel.this.myDefaultsInstaller.setDefaultSchemas(IntrospectionScopes.collapse(map));
        }

        public String toString() {
            Couple t = (Couple)ObjectUtils.tryCast((Object)this.getUserObject(), Couple.class);
            return t == null ? super.toString() : (this.myDb ? (String)t.first : (String)t.second);
        }
    }
}

