/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceScopeEditorTree;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.view.ui.FilteringTree;
import com.intellij.dbm.common.IntrospectionScope;
import com.intellij.dbm.common.IntrospectionScopes;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceScopeEditor {
    private static final Key<DataSourceScopeEditor> EDITOR_KEY = Key.create((String)"DataSourceScopeEditor");
    private final MyTree myTree;
    protected DasModel myModel;
    protected IntrospectionScope mySelectedScope;
    protected IntrospectionScope myPermStructure;
    private boolean mySchemaRoot;
    private boolean mySkipSpecForRoot;
    private static final ActionGroup MY_EAST_ACTIONS = new DefaultActionGroup(new AnAction[]{ChildSelectionAction.access$400()});
    private static final ActionGroup MY_WEST_ACTIONS = new DefaultActionGroup(new AnAction[]{new RefreshAction()});

    public DataSourceScopeEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DataSourceScopeEditor", "<init>"));
        }
        this.myModel = null;
        this.mySelectedScope = IntrospectionScopes.EMPTY_SCOPE;
        this.myPermStructure = IntrospectionScopes.EMPTY_SCOPE;
        this.mySchemaRoot = false;
        this.mySkipSpecForRoot = true;
        this.myTree = new MyTree(this, project, new DataSourceScopeEditorTree.MyNode(null, ObjectKind.NONE, null){

            @Override
            public ObjectKind getChildKind() {
                return DataSourceScopeEditor.this.mySchemaRoot ? ObjectKind.SCHEMA : ObjectKind.DATABASE;
            }
        });
        UIUtil.putClientProperty((JComponent)this.getTree(), EDITOR_KEY, (Object)this);
        this.myTree.getSearchModel().addNodeListener(n -> this.onStateChanged());
        this.myTree.getSearchModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            public void treeNodesInserted(TreeModelEvent e) {
                if (DataSourceScopeEditor.this.mySkipSpecForRoot) {
                    for (Object o : e.getChildren()) {
                        CheckedTreeNode node = (CheckedTreeNode)ObjectUtils.tryCast((Object)o, CheckedTreeNode.class);
                        DataSourceScopeEditorTree.MyNode userNode = (DataSourceScopeEditorTree.MyNode)DataSourceScopeEditor.this.myTree.getSearchModel().getUserObject(node);
                        if (userNode == null || userNode.getKind() != ObjectKind.DATABASE) continue;
                        DbUIUtil.invokeLater(() -> DataSourceScopeEditor.this.myTree.getTree().expandPath(new TreePath(node.getPath())));
                    }
                }
            }
        });
    }

    protected void onStateChanged() {
    }

    public void setScopes(@Nullable IntrospectionScope selection, @Nullable IntrospectionScope structure) {
        boolean structChanged;
        boolean permStructChanged;
        if (selection == null && structure == null) {
            return;
        }
        boolean selChanged = selection != null && !selection.equals(this.mySelectedScope);
        if (selChanged) {
            this.mySelectedScope = selection;
        }
        if (permStructChanged = structure != null && !structure.equals(this.myPermStructure)) {
            this.myPermStructure = structure;
        }
        boolean bl = structChanged = permStructChanged || selChanged;
        if (selChanged) {
            this.myTree.recheck((PairFunction<String, String, Boolean>)(db, sc) -> sc == null ? this.mySelectedScope.containsDatabase((String)db) : this.mySelectedScope.containsSchema((String)db, (String)sc));
        }
        DbUIUtil.invokeLater(() -> {
            if (structChanged) {
                IntrospectionScope tempStructure = IntrospectionScopes.union(this.myPermStructure, this.mySelectedScope);
                if (permStructChanged || tempStructure != this.myPermStructure) {
                    this.myTree.createShadowStructure((DataSourceScopeEditorTree.MyNode)this.myTree.getSearchModel().getRootObject(), tempStructure);
                    this.myTree.getSearchModel().updateStructure();
                }
            }
            this.myTree.recheck((PairFunction<String, String, Boolean>)(db, sc) -> sc == null ? this.mySelectedScope.containsDatabase((String)db) : this.mySelectedScope.containsSchema((String)db, (String)sc));
            this.onSetScopeReady();
        });
    }

    protected void onSetScopeReady() {
    }

    @NotNull
    protected MultiMap<String, String> getEditorState() {
        DataSourceScopeEditorTree.MyNode root2 = (DataSourceScopeEditorTree.MyNode)this.myTree.getSearchModel().getRootObject();
        MultiMap state = MultiMap.createLinkedSet();
        if (root2.getChildKind() == ObjectKind.SCHEMA) {
            Collection schemas2 = state.getModifiable((Object)"*");
            if (root2.getAll() == ThreeState.YES) {
                schemas2.add("*");
            }
            DataSourceScopeEditor.getNodeNames(root2.getAllChildren()).addAllTo(schemas2);
        } else {
            if (root2.getAll() == ThreeState.YES) {
                state.putValue((Object)"*", (Object)"*");
            }
            for (DataSourceScopeEditorTree.MyNode node : root2.getAllChildren()) {
                String name = DataSourceScopeEditor.getNodeName(node);
                if (name == null || !node.isChecked()) continue;
                Collection schemas3 = state.getModifiable((Object)name);
                if (node.getAll() == ThreeState.YES) {
                    schemas3.add("*");
                } else if (name == "@") {
                    schemas3.add("@");
                }
                DataSourceScopeEditor.getNodeNames(node.getAllChildren()).addAllTo(schemas3);
            }
        }
        MultiMap multiMap = state;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceScopeEditor", "getEditorState"));
        }
        return multiMap;
    }

    public boolean hasSpeedSearchActive() {
        return SpeedSearchSupply.getSupply((JComponent)this.getTree()) != null;
    }

    @NotNull
    private static JBIterable<String> getNodeNames(Iterable<DataSourceScopeEditorTree.MyNode> nodes2) {
        JBIterable jBIterable = JBIterable.from(nodes2).filter(DataSourceScopeEditorTree.MyNode::isChecked).transform(n -> DataSourceScopeEditor.getNodeName(n)).filter(Conditions.notNull());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceScopeEditor", "getNodeNames"));
        }
        return jBIterable;
    }

    @Nullable
    protected static String getNodeName(DataSourceScopeEditorTree.MyNode n) {
        if (n.getObject() == "@") {
            return "@";
        }
        return n.getName();
    }

    @NotNull
    private static Map<String, DataSourceScopeEditorTree.MyNode> mapByName(@NotNull DataSourceScopeEditorTree.MyNode obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/dataSource/DataSourceScopeEditor", "mapByName"));
        }
        List<DataSourceScopeEditorTree.MyNode> children = obj.getChildren();
        if (children.isEmpty()) {
            Map<String, DataSourceScopeEditorTree.MyNode> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceScopeEditor", "mapByName"));
            }
            return map;
        }
        HashMap objects = ContainerUtil.newHashMap();
        for (DataSourceScopeEditorTree.MyNode o : children) {
            DasObject object = (DasObject)ObjectUtils.tryCast((Object)o.getObject(), DasObject.class);
            if (object == null) continue;
            objects.put(object.getName(), o);
        }
        HashMap hashMap = objects;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceScopeEditor", "mapByName"));
        }
        return hashMap;
    }

    public void setInitialModel(@Nullable LocalDataSource dataSource, @Nullable DasModel tempModel) {
        this.myModel = tempModel;
        this.mySchemaRoot = dataSource != null && this.isSchemaRoot(dataSource, tempModel);
        this.mySkipSpecForRoot = dataSource != null && DataSourceScopeEditor.isSingleRoot(dataSource);
        this.myTree.update();
    }

    protected DataSourceScopeEditorTree.MyNode getRoot() {
        return (DataSourceScopeEditorTree.MyNode)this.myTree.getSearchModel().getRootObject();
    }

    @Nullable
    protected LocalDataSource getDataSource(boolean withCredentials) {
        return null;
    }

    public void introspectIfEmpty() {
        LocalDataSource dataSource = this.getDataSource(false);
        if (dataSource == null || !DbImplUtil.canConnectTo(dataSource) || this.myModel != null && !this.myModel.getModelRoots().isEmpty()) {
            return;
        }
        this.reintrospect(null);
    }

    private boolean canReintrospect() {
        LocalDataSource dataSource = this.getDataSource(false);
        return dataSource != null && DataSourceSyncManager.getInstance().isAbleToPerform(dataSource);
    }

    public void reintrospect(@Nullable List<DasObject> objects) {
        CompletionStage<DataSourceSyncManager.SyncResult> promise;
        LocalDataSource dataSource = this.getDataSource(true);
        if (dataSource == null) {
            return;
        }
        LoaderContext context = new LoaderContext(dataSource).setNamespacesOnly(true);
        if (objects != null) {
            context.getSelection().addAll(objects);
        }
        if ((promise = DataSourceSyncManager.getInstance().tryPerform(this.myTree.getProject(), dataSource, context, false)) == null) {
            return;
        }
        promise.whenCompleteAsync((res, e) -> {
            DasModel model;
            AsyncUtil.addUnhandledError(context.getErrorHandler(), e, context.getDataSource().getName(), DbImplUtil.getDatabaseDialect(context.getDataSource()).getFamilyId());
            if (res != null && !(model = dataSource.getModel()).getModelRoots().isEmpty()) {
                this.myModel = model;
                this.mySchemaRoot = this.isSchemaRoot(dataSource, model);
                this.mySkipSpecForRoot = DataSourceScopeEditor.isSingleRoot(dataSource);
                this.myTree.update();
                this.onStateChanged();
            }
            this.handleIntrospectionError(null, StringUtil.nullize((String)context.getErrorHandler().getSummary()));
        }, AsyncUtil.EDT_EXECUTOR);
    }

    protected void handleIntrospectionError(@Nullable Throwable th, @Nullable String msg) {
    }

    private static boolean isSingleRoot(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceScopeEditor", "isSingleRoot"));
        }
        DatabaseFamilyId familyId = DbImplUtil.getDatabaseDialect(dataSource).getFamilyId();
        return familyId.isPostgres() || familyId.isH2() || familyId.isHsqldb();
    }

    protected boolean isSchemaRoot(@NotNull LocalDataSource dataSource, @Nullable DasModel tempModel) {
        DasObject rootNamespace;
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceScopeEditor", "isSchemaRoot"));
        }
        DasObject dasObject = rootNamespace = tempModel == null ? null : (DasObject)tempModel.getModelRoots().first();
        return rootNamespace == null ? DbImplUtil.getDatabaseDialect(dataSource).getMetaModel().getRootNamespaceKinds().contains((Object)ObjectKind.SCHEMA) : rootNamespace.getKind() == ObjectKind.SCHEMA;
    }

    @NotNull
    public Tree getTree() {
        DataSourceScopeEditorTree dataSourceScopeEditorTree = this.myTree.getTree();
        if (dataSourceScopeEditorTree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceScopeEditor", "getTree"));
        }
        return dataSourceScopeEditorTree;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myTree.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceScopeEditor", "getComponent"));
        }
        return jComponent;
    }

    private class MyTree
    extends FilteringTree<CheckedTreeNode, DataSourceScopeEditorTree.MyNode> {
        final /* synthetic */ DataSourceScopeEditor this$0;

        public MyTree(@NotNull DataSourceScopeEditor dataSourceScopeEditor, Project project, DataSourceScopeEditorTree.MyNode root2) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DataSourceScopeEditor$MyTree", "<init>"));
            }
            this(dataSourceScopeEditor, project, DataSourceScopeEditorTree.createNode(root2));
        }

        private MyTree(@NotNull DataSourceScopeEditor dataSourceScopeEditor, Project project, CheckedTreeNode root2) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DataSourceScopeEditor$MyTree", "<init>"));
            }
            this.this$0 = dataSourceScopeEditor;
            super(project, (Tree)new DataSourceScopeEditorTree(root2), root2);
        }

        @Override
        protected Class<? extends CheckedTreeNode> getNodeClass() {
            return CheckedTreeNode.class;
        }

        @Override
        @NotNull
        protected CheckedTreeNode createNode(@Nullable DataSourceScopeEditorTree.MyNode obj) {
            CheckedTreeNode checkedTreeNode = DataSourceScopeEditorTree.createNode(obj);
            if (checkedTreeNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceScopeEditor$MyTree", "createNode"));
            }
            return checkedTreeNode;
        }

        @Override
        @NotNull
        protected Iterable<DataSourceScopeEditorTree.MyNode> getChildren(@NotNull DataSourceScopeEditorTree.MyNode obj) {
            if (obj == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/dataSource/DataSourceScopeEditor$MyTree", "getChildren"));
            }
            Iterable<DataSourceScopeEditorTree.MyNode> iterable = obj.getAllChildren();
            if (iterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceScopeEditor$MyTree", "getChildren"));
            }
            return iterable;
        }

        @Override
        @Nullable
        protected String getText(@Nullable DataSourceScopeEditorTree.MyNode object) {
            return object == null ? null : object.getName();
        }

        @NotNull
        public DataSourceScopeEditorTree getTree() {
            DataSourceScopeEditorTree dataSourceScopeEditorTree = (DataSourceScopeEditorTree)super.getTree();
            if (dataSourceScopeEditorTree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceScopeEditor$MyTree", "getTree"));
            }
            return dataSourceScopeEditorTree;
        }

        @Override
        protected void rebuildTree() {
            DataSourceScopeEditorTree.MyNode root2 = (DataSourceScopeEditorTree.MyNode)this.getSearchModel().getRootObject();
            root2.setAllAllowed(!this.this$0.mySkipSpecForRoot);
            if (this.this$0.myModel == null) {
                root2.setChildren(null);
                root2.setShadowChildren(null);
                return;
            }
            this.addNodes(root2, this.sorted((Iterable<DasNamespace>)this.this$0.myModel.getModelRoots().filter(DasNamespace.class)));
            this.createShadowStructure(root2, IntrospectionScopes.union(this.this$0.myPermStructure, this.this$0.mySelectedScope));
            this.getSearchModel().updateStructure();
        }

        private void addNodes(@NotNull DataSourceScopeEditorTree.MyNode p, @NotNull Iterable<DasNamespace> objects) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/database/dataSource/DataSourceScopeEditor$MyTree", "addNodes"));
            }
            if (objects == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/database/dataSource/DataSourceScopeEditor$MyTree", "addNodes"));
            }
            HashMap oldCache = ContainerUtil.newHashMap();
            ObjectKind childKind = p.getChildKind();
            DataSourceScopeEditorTree.CurNode current = this.fillNodesCache(p.getAllChildren(), childKind, oldCache);
            ArrayList children = ContainerUtil.newArrayList();
            DasObject cur = null;
            for (DasObject dasObject : objects) {
                DataSourceScopeEditorTree.MyNode node = (DataSourceScopeEditorTree.MyNode)oldCache.remove(dasObject.getName());
                if (node != null) {
                    node.setObject(dasObject);
                } else {
                    node = new DataSourceScopeEditorTree.MyNode(dasObject.getName(), dasObject.getKind(), dasObject);
                }
                node.setAllAllowed(dasObject.getKind() != ObjectKind.SCHEMA);
                children.add(node);
                if (dasObject instanceof BasicNamespace && ((BasicNamespace)dasObject).isCurrent()) {
                    cur = dasObject;
                }
                if (dasObject.getKind() == ObjectKind.SCHEMA) continue;
                this.addNodes(node, this.sorted((Iterable<DasNamespace>)dasObject.getDbChildren(DasNamespace.class, ObjectKind.NONE)));
            }
            oldCache.values().forEach(o -> o.setObject(o.getName()));
            if (p.getKind() != ObjectKind.NONE || !this.this$0.mySkipSpecForRoot) {
                if (current != null) {
                    current.setCurObject(cur);
                }
                children.add(0, current == null ? new DataSourceScopeEditorTree.CurNode(childKind, cur) : current);
            } else if (current != null) {
                current.setCurObject(null);
                oldCache.put(null, current);
            }
            p.setChildren(children);
            p.setShadowChildren(oldCache.values());
        }

        private Iterable<DasNamespace> sorted(Iterable<DasNamespace> children) {
            ArrayList namespaces = ContainerUtil.newArrayList(children);
            Collections.sort(namespaces, (n1, n2) -> StringUtil.naturalCompare((String)n1.getName(), (String)n2.getName()));
            return namespaces;
        }

        private void createShadowStructure(@NotNull DataSourceScopeEditorTree.MyNode root2, @NotNull IntrospectionScope scope) {
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/DataSourceScopeEditor$MyTree", "createShadowStructure"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DataSourceScopeEditor$MyTree", "createShadowStructure"));
            }
            ObjectKind childKind = root2.getChildKind();
            if (!this.this$0.mySchemaRoot) {
                DataSourceScopeEditorTree.CurNode cur;
                HashSet processedDb = ContainerUtil.newHashSet();
                ArrayList rootShadow = ContainerUtil.newArrayList();
                HashMap oldRootCache = ContainerUtil.newHashMap();
                DataSourceScopeEditorTree.CurNode sCur = this.fillNodesCache(root2.getShadowChildren(), childKind, oldRootCache);
                Map objects = DataSourceScopeEditor.mapByName(root2);
                if (scope.databases().contains("@") && ((cur = root2.getCurrent()) == null || cur == sCur)) {
                    rootShadow.add(sCur == null ? new DataSourceScopeEditorTree.CurNode(root2.getChildKind(), null) : sCur);
                }
                for (String db : scope.databases()) {
                    if (db.equals("*") || db.equals("@")) continue;
                    DataSourceScopeEditorTree.MyNode object = (DataSourceScopeEditorTree.MyNode)objects.get(db);
                    DataSourceScopeEditorTree.MyNode p = object;
                    if (p == null) {
                        p = (DataSourceScopeEditorTree.MyNode)oldRootCache.get(db);
                    }
                    if (p == null) {
                        p = new DataSourceScopeEditorTree.MyNode(db, ObjectKind.DATABASE, db);
                    }
                    if (object == null) {
                        rootShadow.add(p);
                    }
                    processedDb.add(object);
                    this.fillShadowSchemas(scope.schemas(db), p);
                }
                root2.setShadowChildren(rootShadow);
                for (DataSourceScopeEditorTree.MyNode node : root2.getChildren()) {
                    if (processedDb.contains(node)) continue;
                    node.purgeShadow();
                }
            } else {
                this.fillShadowSchemas(scope.schemas("*"), root2);
            }
        }

        private void fillShadowSchemas(Iterable<String> schemas2, DataSourceScopeEditorTree.MyNode p) {
            DataSourceScopeEditorTree.CurNode cur;
            ArrayList dbShadow = ContainerUtil.newArrayList();
            Map schemaObjects = DataSourceScopeEditor.mapByName(p);
            HashMap oldSchemasCache = ContainerUtil.newHashMap();
            DataSourceScopeEditorTree.CurNode sCur = this.fillNodesCache(p.getShadowChildren(), p.getChildKind(), oldSchemasCache);
            if (JBIterable.from(schemas2).contains((Object)"@") && ((cur = p.getCurrent()) == null || sCur == cur)) {
                dbShadow.add(sCur == null ? new DataSourceScopeEditorTree.CurNode(ObjectKind.SCHEMA, null) : sCur);
            }
            for (String sc : schemas2) {
                if (sc.equals("*") || sc.equals("@") || schemaObjects.containsKey(sc)) continue;
                DataSourceScopeEditorTree.MyNode schema = (DataSourceScopeEditorTree.MyNode)oldSchemasCache.get(sc);
                if (schema == null) {
                    schema = new DataSourceScopeEditorTree.MyNode(sc, ObjectKind.SCHEMA, sc);
                }
                dbShadow.add(schema);
            }
            p.setShadowChildren(dbShadow);
            for (DataSourceScopeEditorTree.MyNode node : p.getAllChildren()) {
                node.purgeShadow();
            }
        }

        private DataSourceScopeEditorTree.CurNode fillNodesCache(Iterable<DataSourceScopeEditorTree.MyNode> children, ObjectKind childKind, Map<String, DataSourceScopeEditorTree.MyNode> oldCache) {
            DataSourceScopeEditorTree.CurNode current = null;
            for (DataSourceScopeEditorTree.MyNode node : children) {
                if (node.getKind() != childKind) continue;
                if (node instanceof DataSourceScopeEditorTree.CurNode) {
                    current = (DataSourceScopeEditorTree.CurNode)node;
                    continue;
                }
                oldCache.put(node.getName(), node);
            }
            return current;
        }

        @Override
        protected JComponent createToolbarComponent() {
            JPanel res = new JPanel(new BorderLayout());
            ActionToolbarImpl eastToolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("unknown", MY_EAST_ACTIONS, true);
            ActionToolbarImpl westToolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("unknown", MY_WEST_ACTIONS, true);
            westToolbar.setAddSeparatorFirst(true);
            eastToolbar.setTargetComponent((JComponent)((Object)this.getTree()));
            westToolbar.setTargetComponent((JComponent)((Object)this.getTree()));
            ChildSelectionAction.INSTANCE.registerCustomShortcutSet((JComponent)((Object)this.getTree()), null);
            res.add((Component)eastToolbar.getComponent(), "East");
            res.add((Component)westToolbar.getComponent(), "West");
            return res;
        }

        private void recheck(@NotNull PairFunction<String, String, Boolean> scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DataSourceScopeEditor$MyTree", "recheck"));
            }
            FilteringTree.SearchTreeModel model = this.this$0.myTree.getSearchModel();
            DataSourceScopeEditorTree.MyNode root2 = (DataSourceScopeEditorTree.MyNode)model.getRootObject();
            if (this.this$0.mySchemaRoot) {
                if (root2.isAllAllowed()) {
                    root2.setAll(ThreeState.fromBoolean((boolean)((Boolean)scope.fun((Object)"*", (Object)"*"))));
                }
                Iterator<DataSourceScopeEditorTree.MyNode> iterator = root2.getAllChildren().iterator();
                while (iterator.hasNext()) {
                    DataSourceScopeEditorTree.MyNode o;
                    String sc = DataSourceScopeEditor.getNodeName(o = iterator.next());
                    o.setChecked(sc != null && (Boolean)scope.fun((Object)"*", (Object)sc) != false);
                }
            } else {
                if (root2.isAllAllowed()) {
                    root2.setAll(ThreeState.fromBoolean((boolean)((Boolean)scope.fun((Object)"*", null))));
                }
                for (DataSourceScopeEditorTree.MyNode o : root2.getAllChildren()) {
                    String db = DataSourceScopeEditor.getNodeName(o);
                    if (o.isAllAllowed()) {
                        o.setAll(ThreeState.fromBoolean((boolean)((Boolean)scope.fun((Object)db, (Object)"*"))));
                    }
                    o.setChecked(db != null && (Boolean)scope.fun((Object)db, null) != false);
                    for (DataSourceScopeEditorTree.MyNode oo : o.getAllChildren()) {
                        String sc = DataSourceScopeEditor.getNodeName(oo);
                        oo.setChecked(db != null && sc != null && (Boolean)scope.fun((Object)db, (Object)sc) != false);
                    }
                }
            }
            this.getTree().updateFromNodes();
        }
    }

    private static class ChildSelectionAction
    extends CheckboxAction {
        private static AnAction INSTANCE = new ChildSelectionAction();

        public ChildSelectionAction() {
            super("All");
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(65, 9)));
        }

        public void update(AnActionEvent e) {
            super.update(e);
            DataSourceScopeEditorTree tree = DataSourceScopeEditorTree.getTree(e.getDataContext());
            DataSourceScopeEditorTree.MyNode root2 = tree == null ? null : tree.getSearchModel().getRootObject();
            e.getPresentation().setEnabledAndVisible(root2 != null && root2.isAllAllowed());
            ObjectKind kind = root2 == null ? null : root2.getChildKind();
            e.getPresentation().setDescription("Introspect all (" + KeymapUtil.getFirstKeyboardShortcutText((AnAction)this) + ")");
            e.getPresentation().setText(kind != null ? "All " + StringUtil.pluralize((String)kind.code()) : "All");
        }

        public boolean isSelected(AnActionEvent e) {
            DataSourceScopeEditorTree tree = DataSourceScopeEditorTree.getTree(e.getDataContext());
            DataSourceScopeEditorTree.MyNode root2 = tree == null ? null : tree.getSearchModel().getRootObject();
            return root2 != null && root2.getAll() == ThreeState.YES;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            DataSourceScopeEditorTree.MyNode root2;
            DataSourceScopeEditorTree tree = DataSourceScopeEditorTree.getTree(e.getDataContext());
            DataSourceScopeEditorTree.MyNode myNode = root2 = tree == null ? null : tree.getSearchModel().getRootObject();
            if (root2 != null && root2.isAllAllowed()) {
                tree.setAllNodeState((CheckedTreeNode)tree.getSearchModel().getRoot(), state);
            }
        }
    }

    private static class RefreshAction
    extends AnAction {
        public RefreshAction() {
            super("Refresh", "Refresh schemas list", AllIcons.Actions.Refresh);
        }

        public void update(AnActionEvent e) {
            DataSourceScopeEditor editor = (DataSourceScopeEditor)UIUtil.getClientProperty((Object)((Object)DataSourceScopeEditorTree.getTree(e.getDataContext())), (Key)EDITOR_KEY);
            boolean enabled = editor != null && editor.canReintrospect();
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setDescription("Refresh schemas list" + (enabled ? "" : " (already running)"));
        }

        public void actionPerformed(AnActionEvent e) {
            DataSourceScopeEditor editor = (DataSourceScopeEditor)UIUtil.getClientProperty((Object)((Object)DataSourceScopeEditorTree.getTree(e.getDataContext())), (Key)EDITOR_KEY);
            if (editor != null) {
                List objects = JBIterable.of((Object[])editor.getTree().getSelectedNodes(CheckedTreeNode.class, null)).transform(n -> {
                    DataSourceScopeEditorTree.MyNode node = (DataSourceScopeEditorTree.MyNode)editor.myTree.getUserObject((TreeNode)n);
                    return node == null ? null : node.getObject();
                }).filter(DasObject.class).toList();
                editor.reintrospect(objects);
            }
        }
    }
}

