/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.view.ui.FilteringTree;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DataSourceScopeEditorTree
extends CheckboxTree {
    public DataSourceScopeEditorTree(@NotNull CheckedTreeNode root2) {
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/DataSourceScopeEditorTree", "<init>"));
        }
        super((CheckboxTree.CheckboxTreeCellRenderer)new MyTreeCellRenderer(), root2, new CheckboxTreeBase.CheckPolicy(false, true, true, false));
        ChildSelectionAction.INSTANCE.registerCustomShortcutSet((ShortcutSet)MnemonicHelper.createShortcut((char)'A'), (JComponent)((Object)this));
    }

    protected void installSpeedSearch() {
        this.setUI((TreeUI)((Object)new FullWidthTreeUI()));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                Object o;
                CheckedTreeNode node;
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceScopeEditorTree$1", "onClick"));
                }
                MyTreeCellRenderer cellRenderer = (MyTreeCellRenderer)((Object)ObjectUtils.tryCast((Object)DataSourceScopeEditorTree.this.getCellRenderer(), MyTreeCellRenderer.class));
                int row = DataSourceScopeEditorTree.this.getRowForLocation(e.getX(), e.getY());
                if (row < 0 || clickCount != 1 || cellRenderer == null) {
                    return false;
                }
                FilteringTree.SearchTreeModel<CheckedTreeNode, MyNode> model = DataSourceScopeEditorTree.this.getSearchModel();
                MyNode userNode = model.getUserObject(node = (CheckedTreeNode)ObjectUtils.tryCast((Object)(o = DataSourceScopeEditorTree.this.getPathForRow(row).getLastPathComponent()), CheckedTreeNode.class));
                if (userNode == null || !node.isEnabled() || !userNode.isAllAllowed()) {
                    return false;
                }
                Rectangle rowBounds = DataSourceScopeEditorTree.this.getRowBounds(row);
                cellRenderer.setBounds(rowBounds);
                Rectangle checkBounds = SwingUtilities.convertRectangle(cellRenderer.myUseAll, cellRenderer.myUseAllBox.getBounds(), (Component)((Object)cellRenderer));
                checkBounds.translate(rowBounds.x, rowBounds.y);
                if (checkBounds.height == 0) {
                    checkBounds.height = checkBounds.width = rowBounds.height;
                }
                if (checkBounds.contains(e.getPoint()) && node.isEnabled()) {
                    DataSourceScopeEditorTree.this.setAllNodeState(node, null);
                    DataSourceScopeEditorTree.this.setSelectionRow(row);
                    return true;
                }
                return false;
            }
        }.installOn((Component)((Object)this));
    }

    public void setAllNodeState(CheckedTreeNode treeNode, @Nullable(value="toggle") @Nullable(value="toggle") Boolean state) {
        FilteringTree.SearchTreeModel<CheckedTreeNode, MyNode> model = this.getSearchModel();
        MyNode userNode = model.getUserObject(treeNode);
        if (userNode == null || !userNode.isAllAllowed()) {
            return;
        }
        boolean newState = state == null ? userNode.getAll() == ThreeState.NO : state;
        userNode.setAll(ThreeState.fromBoolean((boolean)newState));
        if (newState) {
            for (MyNode tmp = userNode; tmp != null; tmp = tmp.getParent()) {
                tmp.setChecked(true);
            }
        }
        DataSourceScopeEditorTree.updateEnabled((Tree)this, null);
        this.getSearchModel().nodeChanged(userNode);
    }

    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401 && e.getKeyCode() == 32 && e.getModifiers() == 0) {
            CheckedTreeNode node;
            TreePath path = this.getLeadSelectionPath();
            CheckedTreeNode checkedTreeNode = node = path == null ? null : (CheckedTreeNode)ObjectUtils.tryCast((Object)path.getLastPathComponent(), CheckedTreeNode.class);
            if (node != null && node.isEnabled()) {
                this.setNodeState(node, !node.isChecked());
            }
            e.consume();
            return;
        }
        super.processKeyEvent(e);
    }

    public void updateFromNodes() {
        DataSourceScopeEditorTree.updateEnabled((Tree)this, null);
    }

    @NotNull
    public FilteringTree.SearchTreeModel<CheckedTreeNode, MyNode> getSearchModel() {
        FilteringTree.SearchTreeModel searchTreeModel = (FilteringTree.SearchTreeModel)this.getModel();
        if (searchTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceScopeEditorTree", "getSearchModel"));
        }
        return searchTreeModel;
    }

    protected void onNodeStateChanged(CheckedTreeNode treeNode) {
        super.onNodeStateChanged(treeNode);
        FilteringTree.SearchTreeModel<CheckedTreeNode, MyNode> model = this.getSearchModel();
        MyNode node = model.getUserObject(treeNode);
        if (node != null) {
            boolean checked = treeNode.isChecked();
            if (!checked) {
                for (MyNode n2 : (JBTreeTraverser)((JBTreeTraverser)new JBTreeTraverser(n -> n.getAllChildren()).withRoot((Object)node)).expand(Conditions.alwaysTrue())) {
                    n2.setChecked(false);
                    if (n2.getAll() != ThreeState.YES) continue;
                    n2.setAll(ThreeState.NO);
                }
            }
            DataSourceScopeEditorTree.updateEnabled((Tree)this, node);
        }
    }

    private static void updateEnabled(Tree tree, MyNode root2) {
        FilteringTree.SearchTreeModel searchModel = (FilteringTree.SearchTreeModel)tree.getModel();
        JBTreeTraverser traverser = new JBTreeTraverser(n -> n.getAllChildren());
        for (MyNode enabledNode : (JBTreeTraverser)((JBTreeTraverser)traverser.withRoot((Object)(root2 == null ? (MyNode)searchModel.getRootObject() : root2))).expand(n -> n.getAll() != ThreeState.YES)) {
            ((CheckedTreeNode)searchModel.getNode(enabledNode)).setEnabled(true);
            for (MyNode disabledNode : (JBTreeTraverser)((JBTreeTraverser)traverser.withRoots(enabledNode.getAllChildren())).expand(Conditions.alwaysTrue())) {
                ((CheckedTreeNode)searchModel.getNode(disabledNode)).setEnabled(false);
            }
        }
        tree.repaint();
        tree.revalidate();
    }

    static CheckedTreeNode createNode(MyNode node) {
        return new CheckedTreeNode(node){

            public boolean isChecked() {
                return ((MyNode)this.getUserObject()).myChecked;
            }

            public void setChecked(boolean checked) {
                ((MyNode)this.getUserObject()).myChecked = checked;
            }

            public boolean isLeaf() {
                MyNode userNode = (MyNode)ObjectUtils.tryCast((Object)this.getUserObject(), MyNode.class);
                return userNode != null && userNode.getKind() == ObjectKind.SCHEMA;
            }
        };
    }

    @Nullable
    static DataSourceScopeEditorTree getTree(DataContext dataContext) {
        return (DataSourceScopeEditorTree)((Object)ObjectUtils.tryCast((Object)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext), DataSourceScopeEditorTree.class));
    }

    private static class ChildSelectionAction
    extends AnAction {
        private static AnAction INSTANCE = new ChildSelectionAction();

        public ChildSelectionAction() {
            super("Introspect All Children");
        }

        public void update(AnActionEvent e) {
            DataSourceScopeEditorTree tree = DataSourceScopeEditorTree.getTree(e.getDataContext());
            MyNode node = tree == null ? null : tree.getSearchModel().getUserObject(this.getNode(tree));
            e.getPresentation().setEnabledAndVisible(node != null && node.isAllAllowed());
        }

        public void actionPerformed(AnActionEvent e) {
            DataSourceScopeEditorTree tree = DataSourceScopeEditorTree.getTree(e.getDataContext());
            CheckedTreeNode node = this.getNode(tree);
            if (node != null) {
                tree.setAllNodeState(node, null);
            }
        }

        @Contract(value="null->null")
        public CheckedTreeNode getNode(@Nullable DataSourceScopeEditorTree tree) {
            TreePath path = tree == null ? null : tree.getLeadSelectionPath();
            return path == null ? null : (CheckedTreeNode)ObjectUtils.tryCast((Object)path.getLastPathComponent(), CheckedTreeNode.class);
        }
    }

    private class FullWidthTreeUI
    extends WideSelectionTreeUI {
        private final ComponentListener myTreeSizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FullWidthTreeUI.this.updateSizes();
            }
        };
        private final AncestorListener myTreeAncestorListener = new AncestorListenerAdapter(){

            public void ancestorMoved(AncestorEvent event) {
                super.ancestorMoved(event);
                FullWidthTreeUI.this.updateSizes();
            }
        };

        private FullWidthTreeUI() {
        }

        private void updateSizes() {
            this.treeState.invalidateSizes();
            this.tree.repaint();
        }

        protected void installListeners() {
            super.installListeners();
            this.tree.addComponentListener(this.myTreeSizeListener);
            this.tree.addAncestorListener(this.myTreeAncestorListener);
        }

        protected void uninstallListeners() {
            this.tree.removeComponentListener(this.myTreeSizeListener);
            this.tree.removeAncestorListener(this.myTreeAncestorListener);
            super.uninstallListeners();
        }

        protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
            return new BasicTreeUI.NodeDimensionsHandler(){

                @Override
                public Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle size) {
                    Rectangle dimensions = super.getNodeDimensions(value, row, depth, expanded, size);
                    JScrollPane scrollPane = FullWidthTreeUI.this.getScrollPane();
                    dimensions.width = Math.max(scrollPane != null ? scrollPane.getViewport().getWidth() - this.getRowX(row, depth) : DataSourceScopeEditorTree.this.getMinimumSize().width, dimensions.width);
                    return dimensions;
                }
            };
        }

        @Nullable
        private JScrollPane getScrollPane() {
            return (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, (Component)((Object)DataSourceScopeEditorTree.this));
        }
    }

    private static class MyTreeCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private final JComponent myUseAll = new JPanel(new BorderLayout(5, 0));
        private final JCheckBox myUseAllBox = new JCheckBox();
        private final JLabel myUseAllLabel = new JBLabel("All schemas");

        public MyTreeCellRenderer() {
            super(true, false);
            this.myUseAllLabel.setDisplayedMnemonic(65);
            this.myUseAll.setOpaque(false);
            this.myUseAllBox.setOpaque(false);
            this.myUseAll.add((Component)this.myUseAllBox, "West");
            this.myUseAll.add((Component)this.myUseAllLabel, "Center");
            this.myUseAll.setBorder((Border)JBUI.Borders.emptyRight((int)20));
            this.add(this.myUseAll, "East");
        }

        public void customizeRenderer(JTree baseTree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DataSourceScopeEditorTree tree = (DataSourceScopeEditorTree)((Object)ObjectUtils.tryCast((Object)baseTree, DataSourceScopeEditorTree.class));
            CheckedTreeNode treeNode = (CheckedTreeNode)ObjectUtils.tryCast((Object)value, CheckedTreeNode.class);
            if (tree == null || !(tree.getModel() instanceof FilteringTree.SearchTreeModel) || treeNode == null) {
                return;
            }
            this.myUseAllLabel.setForeground(UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus));
            ColoredTreeCellRenderer renderer = this.getTextRenderer();
            MyNode node = tree.getSearchModel().getUserObject(treeNode);
            if (node != null) {
                this.customizeCheckboxRenderer(node);
            }
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)((Object)tree), (SimpleColoredComponent)renderer, (boolean)true, (boolean)selected);
        }

        private void customizeCheckboxRenderer(MyNode node) {
            if (node.getParent() == null) {
                return;
            }
            ColoredTreeCellRenderer renderer = this.getTextRenderer();
            this.myUseAll.setVisible(node.isAllAllowed());
            this.myUseAllBox.setSelected(node.getAll() == ThreeState.YES);
            this.myUseAllBox.setEnabled(this.myCheckbox.isEnabled());
            renderer.setIcon(DbPresentation.getIcon((ObjectKind)node.getKind()));
            String name = node.getName();
            if (node.getObject() instanceof DasObject) {
                if (StringUtil.isEmpty((String)name)) {
                    renderer.append("<Unnamed>", SimpleTextAttributes.GRAY_ATTRIBUTES);
                } else {
                    renderer.append(name);
                }
                CurNode cur = node.getCurrentSibling();
                if (cur != null && cur.getCurObject() == node.getObject() && cur.isChecked()) {
                    renderer.append("  (\u2714current)", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    if (!this.myCheckbox.isSelected()) {
                        this.myCheckbox.setState(ThreeStateCheckBox.State.DONT_CARE);
                    }
                }
            } else if (node instanceof CurNode) {
                boolean gray = node.getParent().isShadow(node);
                renderer.append("Current " + node.getKind().code(), gray ? SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES : SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
                DasObject curObject = ((CurNode)node).getCurObject();
                if (curObject != null) {
                    renderer.append(" (" + curObject.getName() + ")", gray ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            } else {
                renderer.append(StringUtil.isEmpty((String)name) ? "<Unnamed>" : name, SimpleTextAttributes.EXCLUDED_ATTRIBUTES);
            }
        }
    }

    static class MyNode {
        private List<MyNode> myChildren = null;
        private List<MyNode> myShadowChildren = null;
        private MyNode myParent = null;
        private boolean myChecked;
        private final String myName;
        private final ObjectKind myKind;
        private Object myObject;
        private ThreeState myAll = ThreeState.UNSURE;

        public MyNode(String name, ObjectKind kind, Object object) {
            this.myName = name;
            this.myKind = kind;
            this.myObject = object;
        }

        public void setObject(Object object) {
            this.myObject = object;
        }

        public String getName() {
            return this.myName;
        }

        public ObjectKind getKind() {
            return this.myKind;
        }

        public Object getObject() {
            return this.myObject;
        }

        public void setChildren(@Nullable Collection<MyNode> children) {
            this.myChildren = ContainerUtil.isEmpty(children) ? null : new SmartList(children);
            this.reparent((Collection<MyNode>)this.myChildren);
        }

        public boolean isChecked() {
            return this.myChecked;
        }

        public void setChecked(boolean checked) {
            this.myChecked = checked;
        }

        public void setShadowChildren(@Nullable Collection<MyNode> children) {
            this.myShadowChildren = ContainerUtil.isEmpty(children) ? null : new SmartList(children);
            this.reparent((Collection<MyNode>)this.myShadowChildren);
        }

        public boolean isShadow(@NotNull MyNode n) {
            if (n == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n", "com/intellij/database/dataSource/DataSourceScopeEditorTree$MyNode", "isShadow"));
            }
            return this.myShadowChildren != null && this.myShadowChildren.contains(n);
        }

        public void purgeShadow() {
            this.setShadowChildren(null);
            for (MyNode node : this.getChildren()) {
                node.purgeShadow();
            }
        }

        @Nullable
        public ObjectKind getChildKind() {
            return this.getKind() == ObjectKind.DATABASE ? ObjectKind.SCHEMA : null;
        }

        @Nullable
        public CurNode getCurrent() {
            return (CurNode)ObjectUtils.chooseNotNull((Object)ObjectUtils.tryCast((Object)ContainerUtil.getFirstItem(this.myChildren), CurNode.class), (Object)ObjectUtils.tryCast((Object)ContainerUtil.getFirstItem(this.myShadowChildren), CurNode.class));
        }

        @Nullable
        public CurNode getCurrentSibling() {
            return this.myParent == null ? null : this.myParent.getCurrent();
        }

        private void reparent(@Nullable Collection<MyNode> children) {
            if (children == null) {
                return;
            }
            for (MyNode child : children) {
                if (child.myParent != null && child.myParent != this) {
                    throw new AssertionError((Object)"Already has parent");
                }
                child.myParent = this;
            }
        }

        @NotNull
        public List<MyNode> getChildren() {
            List list = (List)ObjectUtils.chooseNotNull(this.myChildren, Collections.emptyList());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceScopeEditorTree$MyNode", "getChildren"));
            }
            return list;
        }

        @NotNull
        public List<MyNode> getShadowChildren() {
            List list = (List)ObjectUtils.chooseNotNull(this.myShadowChildren, Collections.emptyList());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceScopeEditorTree$MyNode", "getShadowChildren"));
            }
            return list;
        }

        @NotNull
        public Iterable<MyNode> getAllChildren() {
            if (this.myChildren != null && this.myShadowChildren != null) {
                JBIterable jBIterable = JBIterable.from(this.myChildren).append(this.myShadowChildren);
                if (jBIterable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceScopeEditorTree$MyNode", "getAllChildren"));
                }
                return jBIterable;
            }
            Iterable iterable = (Iterable)ObjectUtils.chooseNotNull(this.myChildren, (Object)ObjectUtils.chooseNotNull(this.myShadowChildren, Collections.emptyList()));
            if (iterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceScopeEditorTree$MyNode", "getAllChildren"));
            }
            return iterable;
        }

        @Nullable
        public MyNode getParent() {
            return this.myParent;
        }

        public ThreeState getAll() {
            return this.myAll;
        }

        public void setAllAllowed(boolean allow) {
            if (allow == this.isAllAllowed()) {
                return;
            }
            this.myAll = allow ? ThreeState.NO : ThreeState.UNSURE;
        }

        public boolean isAllAllowed() {
            return this.myAll != ThreeState.UNSURE;
        }

        public void setAll(ThreeState all) {
            this.myAll = all;
        }
    }

    static class CurNode
    extends MyNode {
        private DasObject myCurObject;

        public CurNode(ObjectKind kind, DasObject curObject) {
            super("Current", kind, "@");
            this.myCurObject = curObject;
        }

        public DasObject getCurObject() {
            return this.myCurObject;
        }

        public void setCurObject(DasObject curObject) {
            this.myCurObject = curObject;
        }
    }
}

