/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.coding.ScriptGenerator;
import com.intellij.coding.ScriptGeneratorFactory;
import com.intellij.coding.Text;
import com.intellij.coding.UtilKt;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbDataSourceLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcFileStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.TextWithRanges;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSrcBridge
implements ModelTextStorage {
    private static final CountedThreadExecutor ourStorageWriter = new CountedThreadExecutor(10);
    private final Logger LOG;
    private boolean myLayoutInitialized;
    private final DbDataSourceLayout myLayout;
    @Nullable
    private final Project myProject;
    private final SqlLanguageDialect myDialect;
    private final ScriptGenerator myScriptGenerator;
    private final List<DbSrcPath> myRemoveQueue;
    private Couple<DbSrcStorageLayout.WriteSession> mySessions;
    private int myBalanceCheck;

    private DataSourceSrcBridge(@Nullable Project project, @NotNull String dataSourceId) {
        if (dataSourceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/DataSourceSrcBridge", "<init>"));
        }
        this.LOG = Logger.getInstance(DataSourceSrcBridge.class);
        this.myLayoutInitialized = false;
        this.myRemoveQueue = ContainerUtil.newArrayList();
        this.myBalanceCheck = 0;
        DbSrcStorage storage = DbSrcStorage.getInstance(project);
        this.myLayout = storage.getLayout(dataSourceId);
        this.myProject = project;
        this.myDialect = this.findDialect();
        this.myScriptGenerator = ScriptGeneratorFactory.get(GenericIntrospectorLegacyModelUtils.findRdbms(this.myDialect.getDatabaseDialect().getFamilyId()));
    }

    private void ensureLayoutInitialized() {
        if (this.myLayoutInitialized) {
            return;
        }
        this.myLayoutInitialized = true;
        try {
            this.myLayout.initForce(this.myDialect);
        }
        catch (IOException e) {
            this.LOG.warn("Storage initialization failed", (Throwable)e);
        }
    }

    @Override
    public synchronized void save(@NotNull BasicSourceAware object, @Nullable String sourceText) {
        String convertedText;
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/DataSourceSrcBridge", "save"));
        }
        if (this.myBalanceCheck <= 0) {
            this.LOG.error("ModelTextStorage.beginWrite should be called");
        }
        if (this.mySessions == null) {
            this.initSessions();
        }
        this.flushDeleteQueue();
        String string = convertedText = sourceText == null ? null : StringUtil.convertLineSeparators((String)sourceText);
        Text text = convertedText == null ? null : (this.myScriptGenerator == null ? UtilKt.text(convertedText, true) : this.myScriptGenerator.apply(object, convertedText));
        DbSrcPath srcPath = DbSrcPath.of(object);
        Couple<DbSrcStorageLayout.WriteSession> sessions = this.mySessions;
        if (text == null) {
            ourStorageWriter.execute(() -> this.processDelete(sessions, srcPath));
        } else {
            ourStorageWriter.execute(() -> this.processSave(sessions, srcPath, text));
        }
    }

    private void initSessions() {
        if (this.mySessions != null) {
            throw new AssertionError((Object)"Session already initialized");
        }
        this.mySessions = Couple.of((Object)this.myLayout.createWriteSession(true), (Object)this.myLayout.createWriteSession(false));
        ourStorageWriter.acquire();
    }

    private void flushDeleteQueue() {
        if (this.mySessions == null) {
            throw new AssertionError((Object)"Session should be initialized");
        }
        if (this.myRemoveQueue.isEmpty()) {
            return;
        }
        ArrayList toRemove = ContainerUtil.newArrayList(this.myRemoveQueue);
        this.myRemoveQueue.clear();
        Couple<DbSrcStorageLayout.WriteSession> sessions = this.mySessions;
        ourStorageWriter.execute(() -> this.runWriteAction(() -> {
            for (DbSrcPath path : toRemove) {
                try {
                    this.processDelete(sessions, path);
                }
                catch (Throwable e) {
                    this.LOG.warn(e);
                }
            }
        }));
    }

    @Override
    public synchronized void queueDelete(@NotNull BasicSourceAware object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/DataSourceSrcBridge", "queueDelete"));
        }
        if (this.mySessions == null) {
            this.myRemoveQueue.add(DbSrcPath.of(object));
        } else {
            this.save(object, null);
        }
    }

    @Override
    public synchronized void processDeleteQueue() {
        this.beginWrite();
        this.endWrite();
    }

    @Override
    public void waitForWriteFinished() {
        if (!ourStorageWriter.isRunning()) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        ourStorageWriter.acquire();
        try {
            ourStorageWriter.execute(latch::countDown);
        }
        finally {
            ourStorageWriter.release();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public synchronized void beginWrite() {
        ++this.myBalanceCheck;
    }

    @Override
    public synchronized void endWrite() {
        --this.myBalanceCheck;
        if (this.myBalanceCheck != 0) {
            return;
        }
        if (this.mySessions == null) {
            if (this.myRemoveQueue.isEmpty()) {
                return;
            }
            this.initSessions();
            this.flushDeleteQueue();
        }
        Couple<DbSrcStorageLayout.WriteSession> sessions = this.mySessions;
        this.mySessions = null;
        ourStorageWriter.execute(() -> this.processCloseSessions(sessions));
        ourStorageWriter.release();
    }

    private void processCloseSessions(@NotNull Couple<DbSrcStorageLayout.WriteSession> sessions) {
        if (sessions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessions", "com/intellij/database/dataSource/DataSourceSrcBridge", "processCloseSessions"));
        }
        this.runWriteAction(() -> {
            if (sessions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessions", "com/intellij/database/dataSource/DataSourceSrcBridge", "lambda$processCloseSessions$5"));
            }
            try {
                ((DbSrcStorageLayout.WriteSession)sessions.first).close();
            }
            catch (IOException e) {
                this.LOG.warn("Error closing session", (Throwable)e);
            }
            try {
                ((DbSrcStorageLayout.WriteSession)sessions.second).close();
            }
            catch (IOException e) {
                this.LOG.warn("Error closing session", (Throwable)e);
            }
        });
        DbSrcUtils.refresh();
    }

    private void runWriteAction(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dataSource/DataSourceSrcBridge", "runWriteAction"));
        }
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            app.runWriteAction(runnable);
        } else {
            UIUtil.invokeAndWaitIfNeeded(() -> {
                if (runnable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dataSource/DataSourceSrcBridge", "lambda$runWriteAction$9"));
                }
                ModalityState current = ModalityState.current();
                TransactionGuardImpl guard = (TransactionGuardImpl)TransactionGuard.getInstance();
                TransactionGuardImpl.TransactionIdImpl context = guard.getModalityTransaction(current);
                guard.wrapLaterInvocation(() -> this.lambda$null$8(guard, app, (TransactionId)context, runnable), current).run();
            });
        }
    }

    @NotNull
    private Project getAnyProject() {
        if (this.myProject != null && !this.myProject.isDisposed()) {
            Project project = this.myProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge", "getAnyProject"));
            }
            return project;
        }
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        Project project = projects.length != 0 ? projects[0] : ProjectManager.getInstance().getDefaultProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge", "getAnyProject"));
        }
        return project;
    }

    @NotNull
    private SqlLanguageDialect findDialect() {
        Project project = this.getAnyProject();
        LocalDataSource dataSource = DbSrcUtils.findDataSource(project, this.myLayout.getDataSourceId());
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(project, dataSource);
        if (sqlLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge", "findDialect"));
        }
        return sqlLanguageDialect;
    }

    private void processDelete(@NotNull Couple<DbSrcStorageLayout.WriteSession> sessions, @NotNull DbSrcPath srcPath) {
        if (sessions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessions", "com/intellij/database/dataSource/DataSourceSrcBridge", "processDelete"));
        }
        if (srcPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcPath", "com/intellij/database/dataSource/DataSourceSrcBridge", "processDelete"));
        }
        DbSrcStorageLayout.Item baseItem = this.myLayout.getPath(srcPath, false);
        DbSrcStorageLayout.Item stagingItem = this.myLayout.getPath(srcPath, true);
        this.runWriteAction(() -> {
            boolean stagingFileExists;
            if (srcPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcPath", "com/intellij/database/dataSource/DataSourceSrcBridge", "lambda$processDelete$10"));
            }
            if (sessions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessions", "com/intellij/database/dataSource/DataSourceSrcBridge", "lambda$processDelete$10"));
            }
            boolean bl = stagingFileExists = stagingItem != null && stagingItem.getSrcAttributes() != null;
            if (stagingFileExists) {
                DbSrcChangesTracker.markFileDirty(DbSrcFileSystem.getInstance().findFileByPath(DbSrcFileSystem.getPath(this.myProject, this.myLayout.getDataSourceId(), srcPath, true)));
            }
            try {
                if (baseItem != null) {
                    baseItem.delete(this, (DbSrcStorageLayout.WriteSession)sessions.second);
                }
            }
            catch (IOException e) {
                this.LOG.warn((Throwable)e);
            }
        });
        this.myLayout.putMetaData(srcPath, null);
    }

    private void processSave(@NotNull Couple<DbSrcStorageLayout.WriteSession> sessions, @NotNull DbSrcPath srcPath, @NotNull TextWithRanges text) {
        CharSequence sql;
        if (sessions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessions", "com/intellij/database/dataSource/DataSourceSrcBridge", "processSave"));
        }
        if (srcPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcPath", "com/intellij/database/dataSource/DataSourceSrcBridge", "processSave"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/DataSourceSrcBridge", "processSave"));
        }
        try {
            Project project = this.getAnyProject();
            sql = SqlPsiFacade.getInstance((Project)project).format(project, this.myDialect, text);
        }
        catch (Throwable e) {
            this.LOG.warn("Formatting for " + srcPath + " failed, passing unformated", e);
            sql = text.toString();
        }
        int hash = DbSrcUtils.hashCode(sql);
        DbSrcStorageDsMetadata.MetaData data = this.myLayout.getMetaData(srcPath);
        String content = sql.toString();
        this.runWriteAction(() -> {
            if (srcPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcPath", "com/intellij/database/dataSource/DataSourceSrcBridge", "lambda$processSave$11"));
            }
            if (sessions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessions", "com/intellij/database/dataSource/DataSourceSrcBridge", "lambda$processSave$11"));
            }
            this.ensureLayoutInitialized();
            boolean skipWrite = data != null && data.contentHash == hash;
            DbSrcStorageLayout.Item item = this.myLayout.getPath(srcPath, false);
            if (item == null) {
                this.LOG.warn("Uninitialized storage");
                return;
            }
            if (skipWrite &= item.getSrcAttributes() != null) {
                return;
            }
            try (OutputStreamWriter out = new OutputStreamWriter(item.getOutputStream(this, (DbSrcStorageLayout.WriteSession)sessions.second), CharsetToolkit.UTF8_CHARSET);){
                out.write(content);
                this.myLayout.putMetaData(srcPath, DbSrcStorageDsMetadata.MetaData.modContentHash(data, hash));
            }
            catch (IOException e) {
                this.LOG.warn((Throwable)e);
            }
        });
    }

    @Override
    @Nullable
    public String load(@NotNull BasicSourceAware object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/DataSourceSrcBridge", "load"));
        }
        DbSrcPath srcPath = DbSrcPath.of(object);
        DbSrcStorageLayout.Item item = this.myLayout.getPath(srcPath, false);
        return item == null ? null : DbSrcFileStatus.getContent(item.getSrcFile());
    }

    @Override
    public boolean hasExistingSources(@NotNull BasicElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dataSource/DataSourceSrcBridge", "hasExistingSources"));
        }
        DbSrcPath srcPath = DbSrcPath.of(element);
        DbSrcStorageLayout.Item item = this.myLayout.getPath(srcPath, false);
        if (item == null) {
            return false;
        }
        if (item.hasChildren()) {
            return true;
        }
        if (!(element instanceof BasicSourceAware)) {
            return false;
        }
        return item.getSrcAttributes() != null;
    }

    @Override
    public Long getVersion(@NotNull BasicElement object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/DataSourceSrcBridge", "getVersion"));
        }
        DbSrcPath srcPath = DbSrcPath.of(object);
        DbSrcStorageDsMetadata.MetaData data = this.myLayout.getMetaData(srcPath);
        return data == null ? null : data.srcVersion;
    }

    @Override
    public void setVersion(@NotNull BasicElement object, Long version) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/DataSourceSrcBridge", "setVersion"));
        }
        DbSrcPath srcPath = DbSrcPath.of(object);
        DbSrcStorageDsMetadata.MetaData data = this.myLayout.getMetaData(srcPath);
        this.myLayout.putMetaData(srcPath, DbSrcStorageDsMetadata.MetaData.modSrcVersion(data, version));
    }

    @NotNull
    public static ModelFactory createFactory(@Nullable Project project, @NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceSrcBridge", "createFactory"));
        }
        ModelFactory modelFactory = DataSourceSrcBridge.createFactory(dataSource.isGlobal() ? null : project, dataSource.getUniqueId());
        if (modelFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge", "createFactory"));
        }
        return modelFactory;
    }

    @NotNull
    public static ModelFactory createFactory(@Nullable Project project, @Nullable String dataSourceId) {
        ModelFactory modelFactory = new ModelFactory(DbSrcStorage.isEnabled() && dataSourceId != null ? new DataSourceSrcBridge(project, dataSourceId) : new ModelTextStorage(){

            @Override
            public void save(@NotNull BasicSourceAware object, String sourceText) {
                if (object == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/DataSourceSrcBridge$1", "save"));
                }
            }

            @Override
            public void queueDelete(@NotNull BasicSourceAware object) {
                if (object == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/DataSourceSrcBridge$1", "queueDelete"));
                }
            }

            @Override
            public String load(@NotNull BasicSourceAware object) {
                if (object == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/DataSourceSrcBridge$1", "load"));
                }
                return null;
            }

            @Override
            public boolean hasExistingSources(@NotNull BasicElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dataSource/DataSourceSrcBridge$1", "hasExistingSources"));
                }
                return true;
            }

            @Override
            public Long getVersion(@NotNull BasicElement object) {
                if (object == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/DataSourceSrcBridge$1", "getVersion"));
                }
                return null;
            }

            @Override
            public void setVersion(@NotNull BasicElement object, Long version) {
                if (object == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/DataSourceSrcBridge$1", "setVersion"));
                }
            }

            @Override
            public void beginWrite() {
            }

            @Override
            public void endWrite() {
            }

            @Override
            public void processDeleteQueue() {
            }

            @Override
            public void waitForWriteFinished() {
            }
        });
        if (modelFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge", "createFactory"));
        }
        return modelFactory;
    }

    private /* synthetic */ void lambda$null$8(TransactionGuardImpl guard, Application app, TransactionId context, @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dataSource/DataSourceSrcBridge", "lambda$null$8"));
        }
        guard.submitTransaction((Disposable)(this.myProject == null ? app : this.myProject), context, () -> {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dataSource/DataSourceSrcBridge", "lambda$null$7"));
            }
            WriteAction.run(() -> {
                if (runnable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dataSource/DataSourceSrcBridge", "lambda$null$6"));
                }
                runnable.run();
            });
        });
    }

    private static class CountedThreadExecutor
    implements Executor {
        private final Logger LOG = Logger.getInstance(CountedThreadExecutor.class);
        private final BlockingQueue<Runnable> myQueue = new LinkedBlockingQueue<Runnable>(100);
        private final int myTimeoutSec;
        private volatile int myRefCount = 0;
        private volatile boolean myRunning = false;

        private CountedThreadExecutor(int timeoutSec) {
            this.myTimeoutSec = timeoutSec;
        }

        public boolean isRunning() {
            return this.myRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            BlockingQueue<Runnable> blockingQueue = this.myQueue;
            synchronized (blockingQueue) {
                ++this.myRefCount;
                if (!this.myRunning) {
                    this.myRunning = true;
                    ApplicationManager.getApplication().executeOnPooledThread(this::processQueue);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            BlockingQueue<Runnable> blockingQueue = this.myQueue;
            synchronized (blockingQueue) {
                assert (this.myRefCount > 0);
                assert (this.myRunning);
                --this.myRefCount;
            }
        }

        @Override
        public void execute(@NotNull Runnable command) {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/dataSource/DataSourceSrcBridge$CountedThreadExecutor", "execute"));
            }
            if (ApplicationManager.getApplication().isDispatchThread()) {
                throw new AssertionError((Object)"Operation not allowed from EDT");
            }
            assert (this.myRefCount > 0);
            assert (this.myRunning);
            try {
                this.myQueue.put(command);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processQueue() {
            block25: {
                boolean running = true;
                block19: while (true) {
                    try {
                        while (true) {
                            Runnable task;
                            if ((task = this.myQueue.poll(this.myTimeoutSec, TimeUnit.SECONDS)) == null) {
                                BlockingQueue<Runnable> blockingQueue = this.myQueue;
                                synchronized (blockingQueue) {
                                    if (this.myQueue.isEmpty() && this.myRefCount == 0) {
                                        running = false;
                                        this.myRunning = false;
                                        break block25;
                                    }
                                    continue block19;
                                }
                            }
                            try {
                                task.run();
                                continue block19;
                            }
                            catch (Throwable e2) {
                                this.LOG.warn(e2);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        BlockingQueue<Runnable> e2 = this.myQueue;
                        synchronized (e2) {
                            running = false;
                            this.myRunning = false;
                        }
                        Thread.currentThread().interrupt();
                        break block25;
                    }
                }
                finally {
                    if (running) {
                        BlockingQueue<Runnable> blockingQueue = this.myQueue;
                        synchronized (blockingQueue) {
                            Application app = ApplicationManager.getApplication();
                            if (this.myRunning) {
                                this.LOG.warn("DbSrcWriter accidentally stopped, rescheduling...");
                                app.invokeLater(() -> app.executeOnPooledThread(this::processQueue), app.getDisposed());
                            }
                        }
                    }
                    this.LOG.info("DbSrcWriter stopped");
                }
            }
        }
    }
}

