/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.JdbcOperation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.ExceptionUtil;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseConnectionManager {
    private static final Logger LOG = Logger.getInstance(DatabaseConnectionManager.class);
    private static final DatabaseConnectionManager INSTANCE = new DatabaseConnectionManager();
    private static final String USER_KEY = "user";
    private static final String PASSWORD_KEY = "password";

    public static DatabaseConnectionManager getInstance() {
        return INSTANCE;
    }

    @Nullable
    public Connection getConnectionSync(@NotNull Project project, @NotNull LocalDataSource dataSource) throws ExecutionException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DatabaseConnectionManager", "getConnectionSync"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DatabaseConnectionManager", "getConnectionSync"));
        }
        JdbcDriverManager driverManager = JdbcDriverManager.getDriverManager(project);
        return this.getConnectionSync(driverManager, driverManager.getDefaultRunConfiguration(dataSource), dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Connection getConnectionSync(@NotNull JdbcDriverManager driverManager, @NotNull ConsoleRunConfiguration runConfiguration, @NotNull LocalDataSource dataSource) throws ExecutionException {
        if (driverManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driverManager", "com/intellij/database/dataSource/DatabaseConnectionManager", "getConnectionSync"));
        }
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/database/dataSource/DatabaseConnectionManager", "getConnectionSync"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DatabaseConnectionManager", "getConnectionSync"));
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        boolean wasFriendly = AsyncUtil.isAsyncFriendly(indicator);
        if (!wasFriendly) {
            AsyncUtil.markAsyncFriendly(indicator, true);
        }
        CompletionStage<Connection> connectionFuture = this.getConnection(driverManager, runConfiguration, dataSource);
        try {
            Connection connection = connectionFuture.toCompletableFuture().get();
            return connection;
        }
        catch (InterruptedException e) {
            connectionFuture.whenComplete((c, ex) -> {
                if (driverManager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driverManager", "com/intellij/database/dataSource/DatabaseConnectionManager", "lambda$getConnectionSync$0"));
                }
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DatabaseConnectionManager", "lambda$getConnectionSync$0"));
                }
                try {
                    this.releaseConnection(driverManager.getProject(), dataSource, (Connection)c);
                }
                catch (Throwable er) {
                    LOG.warn(er);
                }
            });
            Thread.currentThread().interrupt();
            throw new ProcessCanceledException();
        }
        catch (CompletionException e) {
            AsyncUtil.rethrowUnwrapped(e);
            Connection connection = null;
            return connection;
        }
        finally {
            if (!wasFriendly) {
                AsyncUtil.markAsyncFriendly(indicator, false);
            }
        }
    }

    @NotNull
    public CompletionStage<Connection> getConnection(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DatabaseConnectionManager", "getConnection"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DatabaseConnectionManager", "getConnection"));
        }
        JdbcDriverManager driverManager = JdbcDriverManager.getDriverManager(project);
        CompletionStage<Connection> completionStage = this.getConnection(driverManager, driverManager.getDefaultRunConfiguration(dataSource), dataSource);
        if (completionStage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionManager", "getConnection"));
        }
        return completionStage;
    }

    @NotNull
    public CompletionStage<Connection> getConnection(@NotNull JdbcDriverManager driverManager, @NotNull ConsoleRunConfiguration runConfiguration, @NotNull LocalDataSource dataSource) {
        if (driverManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driverManager", "com/intellij/database/dataSource/DatabaseConnectionManager", "getConnection"));
        }
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/database/dataSource/DatabaseConnectionManager", "getConnection"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DatabaseConnectionManager", "getConnection"));
        }
        CompletionStage<Connection> completionStage = DatabaseCredentials.getInstance().getCredentialsAsync((DatabaseSystem)dataSource).thenCompose(AsyncUtil.captureIndicator(credentials -> {
            if (driverManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driverManager", "com/intellij/database/dataSource/DatabaseConnectionManager", "lambda$getConnection$2"));
            }
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DatabaseConnectionManager", "lambda$getConnection$2"));
            }
            if (runConfiguration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/database/dataSource/DatabaseConnectionManager", "lambda$getConnection$2"));
            }
            try {
                Driver driver = driverManager.getDriver(dataSource, runConfiguration);
                String url = dataSource.getEffectiveUrl(driverManager);
                if (url == null) {
                    return CompletableFuture.completedFuture(null);
                }
                return new ConnectionEstablisher(driverManager.getProject(), driver, dataSource, url, (Credentials)credentials, () -> {
                    if (driverManager == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driverManager", "com/intellij/database/dataSource/DatabaseConnectionManager", "lambda$null$1"));
                    }
                    if (dataSource == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DatabaseConnectionManager", "lambda$null$1"));
                    }
                    if (runConfiguration == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/database/dataSource/DatabaseConnectionManager", "lambda$null$1"));
                    }
                    driverManager.releaseDriver(dataSource, runConfiguration);
                }).tryConnect();
            }
            catch (Exception e) {
                return AsyncUtil.exceptional(e);
            }
        }));
        if (completionStage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionManager", "getConnection"));
        }
        return completionStage;
    }

    private static boolean mayRequestPassword(@NotNull String message, @Nullable String user) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/dataSource/DatabaseConnectionManager", "mayRequestPassword"));
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return false;
        }
        if (message.contains("ORA-28001:")) {
            return true;
        }
        if (message.contains("ORA-12705:")) {
            return false;
        }
        String userPart = StringUtil.isNotEmpty((String)user) ? "|" + StringUtil.escapeToRegexp((String)user) : "";
        String regex = "(?i)\\b(access|denied|password|user" + userPart + ")\\b";
        return Pattern.compile(regex).matcher(message).find();
    }

    private static CompletionStage<Credentials> askPasswordAsync(@NotNull LocalDataSource dataSource, Project project, DatabaseCredentials databaseCredentials, Credentials credentials, String userName, String message) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DatabaseConnectionManager", "askPasswordAsync"));
        }
        String prompt = "The specified user/password combination is rejected";
        prompt = prompt + (message.isEmpty() ? "." : ":<br>" + message);
        String userNameDef = StringUtil.notNullize((String)(credentials == null ? null : userName), (String)StringUtil.notNullize((String)dataSource.getUsername()));
        return databaseCredentials.askCredentialsWhenFailed(project, dataSource, "<html>" + prompt + "</html>", userNameDef);
    }

    @NotNull
    public <T> CompletionStage<T> performJdbcOperationAsync(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull ErrorHandler errorHandler, @NotNull JdbcOperation<T> operation) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DatabaseConnectionManager", "performJdbcOperationAsync"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DatabaseConnectionManager", "performJdbcOperationAsync"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/intellij/database/dataSource/DatabaseConnectionManager", "performJdbcOperationAsync"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/database/dataSource/DatabaseConnectionManager", "performJdbcOperationAsync"));
        }
        CompletionStage<T> completionStage = new JdbcOperationExecutor<T>(project, dataSource, errorHandler, operation).async();
        if (completionStage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionManager", "performJdbcOperationAsync"));
        }
        return completionStage;
    }

    @Nullable
    public <T> T performJdbcOperationSync(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull ErrorHandler errorHandler, @NotNull JdbcOperation<T> operation) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DatabaseConnectionManager", "performJdbcOperationSync"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DatabaseConnectionManager", "performJdbcOperationSync"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/intellij/database/dataSource/DatabaseConnectionManager", "performJdbcOperationSync"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/database/dataSource/DatabaseConnectionManager", "performJdbcOperationSync"));
        }
        return new JdbcOperationExecutor<T>(project, dataSource, errorHandler, operation).sync();
    }

    private static void handleConnectionError(@NotNull Throwable e, @NotNull ErrorHandler errorHandler, @NotNull String dsName) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DatabaseConnectionManager", "handleConnectionError"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/intellij/database/dataSource/DatabaseConnectionManager", "handleConnectionError"));
        }
        if (dsName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dsName", "com/intellij/database/dataSource/DatabaseConnectionManager", "handleConnectionError"));
        }
        if (e instanceof ProcessCanceledException) {
            throw (ProcessCanceledException)e;
        }
        if (e instanceof SQLException) {
            errorHandler.addError(StringUtil.notNullize((String)DatabaseConnectionManager.getSpecialMessage(e, dsName), (String)DatabaseMessages.message((String)"message.text.cant.establish.connection.to", (Object[])new Object[]{dsName})), e);
        } else if (e instanceof ClassNotFoundException) {
            errorHandler.addError(DatabaseMessages.message((String)"message.driver.class.not.found.text", (Object[])new Object[]{e.getMessage()}), null);
        } else if (e instanceof com.intellij.execution.ExecutionException) {
            Matcher matcher = Pattern.compile("java\\.lang\\.(ClassNotFoundException|InstantiationException):\\s+((?:\\w+\\.)*\\w+)").matcher(e.getMessage());
            if (matcher.find()) {
                if ("InstantiationException".equals(matcher.group(1))) {
                    errorHandler.addError(DatabaseMessages.message((String)"message.driver.class.not.instantiable", (Object[])new Object[]{matcher.group(2)}), null);
                } else {
                    errorHandler.addError(DatabaseMessages.message((String)"message.driver.class.not.found.text", (Object[])new Object[]{matcher.group(2)}), null);
                }
            } else {
                errorHandler.addError(DatabaseMessages.message((String)"message.text.cant.establish.connection.because.of.error", (Object[])new Object[]{dsName, e.getMessage()}), e);
            }
        } else if (e instanceof UnsatisfiedLinkError) {
            errorHandler.addError(DatabaseMessages.message((String)"message.text.native.library.cannot.be.loaded", (Object[])new Object[]{e.getMessage()}), e);
        } else if (e.getClass().getName().equals("com.jcraft.jsch.JSchException")) {
            errorHandler.addError("SSH tunnel creation failed:", e);
        } else {
            errorHandler.addError(DatabaseConnectionManager.getSpecialMessage(e, dsName), e);
        }
    }

    @Nullable
    public static String getSpecialMessage(@NotNull Throwable t, @NotNull String processName) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/database/dataSource/DatabaseConnectionManager", "getSpecialMessage"));
        }
        if (processName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processName", "com/intellij/database/dataSource/DatabaseConnectionManager", "getSpecialMessage"));
        }
        Throwable cause = ExceptionUtil.getRootCause((Throwable)t);
        boolean remote = ExceptionUtil.causedBy((Throwable)t, RemoteException.class);
        String message = cause.getMessage();
        if (message == null) {
            return null;
        }
        if (cause instanceof SQLException && StringUtil.contains((CharSequence)message, (CharSequence)"ORA-12705:")) {
            return DatabaseMessages.message((String)"error.message.ora.nls", (Object[])new Object[]{processName});
        }
        if (cause instanceof OutOfMemoryError && remote) {
            return DatabaseMessages.message((String)"error.message.remote.oomerror", (Object[])new Object[]{processName});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(Project project, @NotNull LocalDataSource dataSource, @Nullable Connection connection) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DatabaseConnectionManager", "releaseConnection"));
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.releaseDriver(project, dataSource);
        }
    }

    public Driver getDriver(Project project, LocalDataSource dataSource) throws Exception {
        JdbcDriverManager driverManager = JdbcDriverManager.getDriverManager(project);
        return driverManager.getDriver(dataSource, driverManager.getDefaultRunConfiguration(dataSource));
    }

    public void releaseDriver(Project project, LocalDataSource dataSource) {
        if (dataSource.getUniqueId() == null) {
            JdbcDriverManager.getDriverManager(project).releaseDriver(dataSource, null);
        }
    }

    private class JdbcOperationExecutor<T> {
        private final Project myProject;
        private final LocalDataSource myDataSource;
        private final ErrorHandler myErrorHandler;
        private final JdbcOperation<T> myOperation;

        public JdbcOperationExecutor(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull ErrorHandler errorHandler, JdbcOperation<T> operation) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DatabaseConnectionManager$JdbcOperationExecutor", "<init>"));
            }
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DatabaseConnectionManager$JdbcOperationExecutor", "<init>"));
            }
            if (errorHandler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/intellij/database/dataSource/DatabaseConnectionManager$JdbcOperationExecutor", "<init>"));
            }
            if (operation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/database/dataSource/DatabaseConnectionManager$JdbcOperationExecutor", "<init>"));
            }
            this.myProject = project;
            this.myDataSource = dataSource;
            this.myErrorHandler = errorHandler;
            this.myOperation = operation;
        }

        @NotNull
        public CompletionStage<T> async() {
            ProgressIndicator indicator = this.prepareIndicator();
            CompletionStage<Object> completionStage = DatabaseConnectionManager.this.getConnection(this.myProject, this.myDataSource).handle((r, e) -> {
                if (e == null) {
                    return r;
                }
                if (!AsyncUtil.isCancellation(e)) {
                    DatabaseConnectionManager.handleConnectionError(e, this.myErrorHandler, this.myDataSource.getName());
                }
                throw new ProcessCanceledException();
            }).thenApply(connection -> this.perform((Connection)connection, indicator));
            if (completionStage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionManager$JdbcOperationExecutor", "async"));
            }
            return completionStage;
        }

        @Nullable
        public T sync() {
            Connection connection;
            ProgressIndicator indicator = this.prepareIndicator();
            try {
                connection = DatabaseConnectionManager.this.getConnectionSync(this.myProject, this.myDataSource);
            }
            catch (ExecutionException e) {
                if (!AsyncUtil.isCancellation(e)) {
                    DatabaseConnectionManager.handleConnectionError(e.getCause(), this.myErrorHandler, this.myDataSource.getName());
                }
                throw new ProcessCanceledException();
            }
            return this.perform(connection, indicator);
        }

        @NotNull
        public ProgressIndicator prepareIndicator() {
            ProgressManager progressManager = ProgressManager.getInstance();
            ProgressIndicator indicator = progressManager.getProgressIndicator();
            if (indicator == null) {
                indicator = new EmptyProgressIndicator();
            } else {
                indicator.checkCanceled();
            }
            indicator.setIndeterminate(true);
            indicator.setText("Connecting to database...");
            ProgressIndicator progressIndicator = indicator;
            if (progressIndicator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionManager$JdbcOperationExecutor", "prepareIndicator"));
            }
            return progressIndicator;
        }

        @Nullable
        public T perform(Connection connection, ProgressIndicator indicator) {
            if (connection == null) {
                this.myErrorHandler.addError(DatabaseMessages.message((String)"wrong.driver.specified", (Object[])new Object[0]), null);
                throw new ProcessCanceledException();
            }
            try {
                Object object = this.myOperation.perform(connection, indicator);
                return (T)object;
            }
            catch (Exception e) {
                if (!AsyncUtil.isCancellation(e)) {
                    this.myErrorHandler.addError(DatabaseConnectionManager.getSpecialMessage(e, this.myDataSource.getName()), (Throwable)e);
                }
                throw new ProcessCanceledException();
            }
            finally {
                this.release(connection);
            }
        }

        public void release(Connection connection) {
            try {
                DatabaseConnectionManager.this.releaseConnection(this.myProject, this.myDataSource, connection);
            }
            catch (Throwable e) {
                this.myErrorHandler.addError(null, e);
            }
        }
    }

    private static class ConnectionEstablisher {
        private final LocalDataSource myDataSource;
        private final Driver myDriver;
        private final AtomicReference<Boolean> myStopProcessRef;
        private final Project myProject;
        private final Properties myConnectionProperties;
        private Credentials myCredentials;
        private String myUrl;
        private int myAttemptNo;

        ConnectionEstablisher(@NotNull Project project, @NotNull Driver driver, @NotNull LocalDataSource dataSource, @NotNull String url, @Nullable Credentials credentials, final @NotNull Runnable releaseDriver) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DatabaseConnectionManager$ConnectionEstablisher", "<init>"));
            }
            if (driver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/DatabaseConnectionManager$ConnectionEstablisher", "<init>"));
            }
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DatabaseConnectionManager$ConnectionEstablisher", "<init>"));
            }
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/DatabaseConnectionManager$ConnectionEstablisher", "<init>"));
            }
            if (releaseDriver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "releaseDriver", "com/intellij/database/dataSource/DatabaseConnectionManager$ConnectionEstablisher", "<init>"));
            }
            this.myAttemptNo = 0;
            this.myStopProcessRef = new AtomicReference<Boolean>(true);
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator instanceof ProgressIndicatorEx) {
                ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                    public void cancel() {
                        if (((Boolean)myStopProcessRef.get()).booleanValue()) {
                            releaseDriver.run();
                        }
                    }
                });
            }
            this.myDataSource = dataSource;
            this.myDriver = driver;
            this.myCredentials = credentials;
            this.myProject = project;
            this.myConnectionProperties = dataSource.getConnectionProperties();
            this.myUrl = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        public CompletionStage<Connection> tryConnect() {
            CompletableFuture<Connection> completableFuture;
            block23: {
                CompletionStage<Connection> completionStage;
                block22: {
                    String password;
                    String userName;
                    DatabaseCredentials databaseCredentials = DatabaseCredentials.getInstance();
                    String string = userName = this.myCredentials == null ? null : this.myCredentials.getUserName();
                    if (StringUtil.isNotEmpty((String)userName)) {
                        LOG.info("Connecting as: " + userName);
                        this.myConnectionProperties.setProperty(DatabaseConnectionManager.USER_KEY, userName);
                    } else {
                        LOG.info("No user name provided (may be in url)");
                    }
                    String string2 = password = this.myCredentials == null ? null : this.myCredentials.getPasswordAsString();
                    if (StringUtil.isNotEmpty((String)password)) {
                        this.myConnectionProperties.setProperty(DatabaseConnectionManager.PASSWORD_KEY, password);
                    }
                    try {
                        LOG.info("Connecting to: " + this.myUrl);
                        Connection connection = this.myDriver.connect(this.myUrl, this.myConnectionProperties);
                        if (connection != null && this.myDataSource.isReadOnly()) {
                            connection.setReadOnly(true);
                        }
                        if (this.myAttemptNo == 0 && connection == null && DatabaseFamilyId.forConnection((RawConnectionConfig)this.myDataSource).isPostgres()) {
                            this.myUrl = this.myUrl + "/";
                            CompletionStage<Connection> completionStage2 = this.tryReconnect();
                            completionStage = completionStage2;
                            break block22;
                        }
                        if (connection == null) {
                            LOG.warn("Null connection returned for: " + this.myUrl);
                        }
                        CompletableFuture<Connection> completableFuture2 = CompletableFuture.completedFuture(connection);
                        completableFuture = completableFuture2;
                        break block23;
                    }
                    catch (SQLException e) {
                        if (e.getCause() instanceof SQLException) {
                            e = (SQLException)e.getCause();
                        }
                        String message = JdbcEngine.getMessageLong(e);
                        String title = "Connecting to: " + this.myUrl;
                        String user = StringUtil.notNullize((String)this.myConnectionProperties.getProperty(DatabaseConnectionManager.USER_KEY), (String)DatabaseConnectionManager.USER_KEY);
                        if (this.myAttemptNo >= 20 || !DatabaseConnectionManager.mayRequestPassword(message, user)) {
                            LOG.warn(title);
                            LOG.warn(message);
                            CompletableFuture<Connection> completableFuture3 = AsyncUtil.exceptional(e);
                            CompletableFuture<Connection> completableFuture4 = completableFuture3;
                            if (completableFuture4 == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionManager$ConnectionEstablisher", "tryConnect"));
                            }
                            return completableFuture4;
                        }
                        if (this.myAttemptNo == 0 && !Comparing.equal((Object)this.myCredentials, (Object)databaseCredentials.getCredentials((DatabaseSystem)this.myDataSource))) {
                            CompletionStage<Connection> completionStage3 = this.tryReconnectIfWithCredentials(databaseCredentials.getCredentials((DatabaseSystem)this.myDataSource), message, title);
                            CompletionStage<Connection> completionStage4 = completionStage3;
                            if (completionStage4 == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionManager$ConnectionEstablisher", "tryConnect"));
                            }
                            return completionStage4;
                        }
                        CompletionStage<Connection> completionStage5 = DatabaseConnectionManager.askPasswordAsync(this.myDataSource, this.myProject, databaseCredentials, this.myCredentials, userName, message).thenComposeAsync(AsyncUtil.captureIndicator(credentials -> this.tryReconnectIfWithCredentials((Credentials)credentials, message, title)), AsyncUtil.NON_EDT_EXECUTOR);
                        CompletionStage<Connection> completionStage6 = completionStage5;
                        if (completionStage6 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionManager$ConnectionEstablisher", "tryConnect"));
                        }
                        return completionStage6;
                    }
                }
                if (completionStage == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionManager$ConnectionEstablisher", "tryConnect"));
                }
                return completionStage;
            }
            if (completableFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionManager$ConnectionEstablisher", "tryConnect"));
            }
            return completableFuture;
            finally {
                this.myStopProcessRef.set(false);
                ProgressManager.checkCanceled();
            }
        }

        private CompletionStage<Connection> tryReconnect() {
            ++this.myAttemptNo;
            this.myStopProcessRef.set(false);
            ProgressManager.checkCanceled();
            return this.tryConnect();
        }

        private CompletionStage<Connection> tryReconnectIfWithCredentials(Credentials credentials, String message, String title) {
            this.myCredentials = credentials;
            if (this.myCredentials == null) {
                LOG.warn(title);
                LOG.warn(message);
                return AsyncUtil.cancelled();
            }
            return this.tryReconnect();
        }
    }
}

